/*
 * Source code illustrates usage of AOCL-BLIS in perticular GEMM function
 *
 */

#include <stdio.h>
#include "blis.h"

#define DIM 2


int main()
{
	double a[DIM * DIM] = { 1.0, 3.0, 2.0, 4.0 };
	double b[DIM * DIM] = { 5.0, 7.0, 6.0, 8.0 };
	double c[DIM * DIM];
	int I, J, M, N, K, lda, ldb, ldc;
	double alpha, beta;
	M = DIM;
	N = M;
	K = M;
	lda = M;
	ldb = K;
	ldc = M;
	alpha = 1.0;
	beta = 0.0;
   	
        printf("BLIS Library version is : %s\n", bli_info_get_version_str());
 
	printf("a = \n");
	for (I = 0; I < M; I++)
	{
		for (J = 0; J < K; J++)
		{
			printf("%f\t", a[J * K + I]);
		}
		printf("\n");
	}
	printf("b = \n");
	for (I = 0; I < K; I++)
	{
		for (J = 0; J < N; J++)
		{
			printf("%f\t", b[J * N + I]);
		}
		printf("\n");
	}

	dgemm_("N","N",&M,&N,&K,&alpha,a,&lda,b,&ldb,&beta,c,&ldc);
	printf("c = \n");
	for (I = 0; I < M; I++)
	{
		for (J = 0; J < N; J++)
		{
			printf("%f\t", c[J * N + I]);
		}
		printf("\n");
	}
	return 0;
}
