

#ifndef FLAME_H
#define FLAME_H

// Allow C++ users to include this header file in their source code. However,
// we make the extern "C" conditional on whether we're using a C++ compiler,
// since regular C compilers don't understand the extern "C" construct.
#ifdef __cplusplus
extern "C" {
#endif 

  // Include autoconf-related preprocessor defines.
// begin FLA_config.h
//Determines to enable FLA_ENABLE_EXTRA_SYMBOLS
#define FLA_ENABLE_EXTRA_SYMBOLS    1

#ifdef FLA_ENABLE_EXTRA_SYMBOLS
#define F77_FUNC(name,NAME) name ## _
#define F77_FUNC_(name,NAME) name ## _
#endif

// --- General options ---------------------------------------------------------

// Determines whether to enable various segments of code identified as
// providing non-critical functionality.
#define FLA_ENABLE_NON_CRITICAL_CODE   1

//Determines to enable BuiltinBlas


//Enables blis1 use of flamalloc
#define FLA_ENABLE_BLIS1_USE_OF_FLA_MALLOC 1

// Determines whether the LAPACK compatibility layer is included in libflame.
// NOTE: If lapack2flame is enabled, external-lapack-for-subproblems MUST
// be disabled!
#define FLA_ENABLE_LAPACK2FLAME    1

// Determines whether ILP64 enabled. only enabled when -DENABLE_ILP64 is passed with cmake
#define  FLA_ENABLE_ILP64  1

// Determines whether to enable external LAPACK for small subproblems.
// NOTE: If external-lapack-for-subproblems is enabled, (a) lapack2flame MUST
// be disabled, AND (b) external-lapack-interfaces MUST be enabled.


// Determines whether to enable interfaces to external LAPACK routines.
// NOTE: If external-lapack-interfaces is enabled, an LAPACK library will be
// required at link-time.
#define FLA_ENABLE_EXTERNAL_LAPACK_INTERFACES  1

// Determines whether to use control trees to select a reasonable FLAME
// variant and blocksize when level-3 BLAS front-ends are invoked.


// Determines whether to modify various segments of code needed for
// integrating libflame into Windows.


// Determines whether to define a portable FLA_Clock() in terms of
// gettimeofday() from time.h.
#define FLA_ENABLE_PORTABLE_TIMER  1


// --- Runtime error checking and debugging ------------------------------------

// Determines whether to enable internal runtime consistency checks of
// function parameters and return values.
#define FLA_ENABLE_INTERNAL_ERROR_CHECKING 1

// Encodes the default level of internal error checking chosen at
// configure-time.
// 1-minimal error cheking
// 2-full error cheking
// 3-no error cheking
#define FLA_INTERNAL_ERROR_CHECKING_LEVEL 2   

// Determines whether to enable the FLA_malloc()/FLA_free() memory counter
// by default.



// --- Multithreading and SuperMatrix ------------------------------------------

// Determines whether thread-specific blocks of code should be compiled.


// Encodes the type of multithreading chosen at configure-time.
// 1 - openmp
// 2 - pthreads
#define FLA_MULTITHREADING_MODEL 1

// Determines whether SuperMatrix-specific blocks of code should be compiled.



// --- BLAS and blocksizes -----------------------------------------------------

// Determines whether to enable CBLAS interfaces instead of Fortran-77
// interfaces to the BLAS.


// Determines whether to enable interfaces to internal/low-level libgoto
// symbols.


// Sets the default blocksize in the k dimension (used only if
// libgoto interfaces are disabled).


// Sets the default blocksize in the m dimension (used only if
// libgoto interfaces are disabled).


// Sets the default blocksize in the n dimension (used only if
// libgoto interfaces are disabled).



// --- Memory alignment --------------------------------------------------------

// Determines whether memory is aligned to user-requested boundaries.


// Sets the byte boundary used to align the starting address of all memory
// allocated dynamically through libflame. Only used if
// FLA_ENABLE_MEMORY_ALIGNMENT is defined.


// Determines whether to enable code that will increase FLA_Obj leading
// dimensions to ensure that matrix columns adhere to the alignment specified
// by FLA_MEMORY_ALIGNMENT_BOUNDARY.



// --- Fortran-77 compatibility ------------------------------------------------

// Determines whether the Fortran name-mangling suffix was determined at
// configure-time. This option is not used in Windows.


// Determines whether the Fortran 77 compiler appends an underscore to symbol
// names. Not used in Windows.


// Determines whether the Fortran 77 compiler appends an extra underscore to
// symbol names that already contain at least one underscore. Not used in
// Windows.


// Determines whether invocations to the BLAS within libflame are converted to
// uppercase symbols.


// Determines whether invocations to LAPACK within libflame are converted to
// uppercase symbols.



// --- Experimental/unsupported/broken options ---------------------------------

// Determines whether GPU-specific blocks of code should be compiled.


// Determines AMD optimized code path selection
#define FLA_ENABLE_AMD_OPT 1

//Detrmines library Version
#define FLA_LIBFLAME_VERSION   "5.1.0	Build	20250430"

// Determines OpenMP multithreading for AMD optimized code path 
#define FLA_OPENMP_MULTITHREADING  1

// Determins BLAS Extension API, GEMMT usage in libFLAME APIs
#define FLA_ENABLE_BLAS_EXT_GEMMT  1

// Enables FLA_PORTABLE_TIMER_IS_CLOCK_GETTIME
#define FLA_PORTABLE_TIMER_IS_CLOCK_GETTIME  1

//#define FLA_PORTABLE_TIMER_IS_CLOCK_GETTIME 1
#define FLA_VECTOR_INTRINSIC_TYPE 0

// #define other missing macros
#define HAVE_ASSERT_H 1
#define HAVE_FCNTL_H 1
#define HAVE_INTTYPES_H 1
#define HAVE_LIBM 1
#define HAVE_MATH_H 1
#define HAVE_MEMORY_H 1
#define HAVE_SIGNAL_H 1
#define HAVE_STDINT_H 1
#define HAVE_STDLIB_H 1
#define HAVE_STRINGS_H 1
#define HAVE_STRING_H 1
#define HAVE_SYS_STAT_H 1
#define HAVE_SYS_TIME_H 1
#define HAVE_SYS_TYPES_H 1
#define HAVE_UNISTD_H 1

#define PROTOTYPES 1
#define STDC_HEADERS 1
#define TIME_WITH_SYS_TIME 1
#define _GNU_SOURCE 1
#define __PROTOTYPES 1






// end FLA_config.h
// begin FLA_config_check.h


#ifdef FLA_ENABLE_WINDOWS_BUILD
#include <time.h> // skipped
#else
  // Handle the results of checking for time.h and sys/time.h
  #if TIME_WITH_SYS_TIME
#include <sys/time.h> // skipped
#include <time.h> // skipped
  #else
    #if HAVE_SYS_TIME_H
#include <sys/time.h> // skipped
    #else
#include <time.h> // skipped
    #endif
  #endif
#endif

// Handle the results of checking for ia64intrin.h. The contents of this header
// are required by the ia64 sections of FLA_Clock.c.
#ifdef HAVE_IA64INTRIN_H
#include <ia64intrin.h> // skipped
#endif

// end FLA_config_check.h

  // Include standard C header files.
#include <stdio.h> // skipped
#include <stdlib.h> // skipped
#include <stdarg.h> // skipped
#include <string.h> // skipped
  #ifdef FLA_ENABLE_WINDOWS_BUILD
#include <windows.h> // skipped
  #else
  #ifndef FLA_ENABLE_TIDSP
    // TI CG does not support POSIX
#include <unistd.h> // skipped
#include <fcntl.h> // skipped
#include <sys/types.h> // skipped
  #endif
  #endif
#include <math.h> // skipped
#include <float.h> // skipped
#include <signal.h> // skipped

  // Include f2c definitions.
// begin FLA_f2c.h

// f2c.h  --  Standard Fortran to C header file
//  barf  [ba:rf]  2.  "He suggested using FORTRAN, and everybody barfed."
//  - From The Shogakukan DICTIONARY OF NEW ENGLISH (Second edition)

#include <stdio.h> // skipped
#include <string.h> // skipped
#include <stdlib.h> // skipped
#include <math.h> // skipped
#ifndef __cplusplus
#include <complex.h> // skipped
#endif
#undef complex
// begin FLA_config.h
//Determines to enable FLA_ENABLE_EXTRA_SYMBOLS
#define FLA_ENABLE_EXTRA_SYMBOLS    1

#ifdef FLA_ENABLE_EXTRA_SYMBOLS
#define F77_FUNC(name,NAME) name ## _
#define F77_FUNC_(name,NAME) name ## _
#endif

// --- General options ---------------------------------------------------------

// Determines whether to enable various segments of code identified as
// providing non-critical functionality.
#define FLA_ENABLE_NON_CRITICAL_CODE   1

//Determines to enable BuiltinBlas


//Enables blis1 use of flamalloc
#define FLA_ENABLE_BLIS1_USE_OF_FLA_MALLOC 1

// Determines whether the LAPACK compatibility layer is included in libflame.
// NOTE: If lapack2flame is enabled, external-lapack-for-subproblems MUST
// be disabled!
#define FLA_ENABLE_LAPACK2FLAME    1

// Determines whether ILP64 enabled. only enabled when -DENABLE_ILP64 is passed with cmake
#define  FLA_ENABLE_ILP64  1

// Determines whether to enable external LAPACK for small subproblems.
// NOTE: If external-lapack-for-subproblems is enabled, (a) lapack2flame MUST
// be disabled, AND (b) external-lapack-interfaces MUST be enabled.


// Determines whether to enable interfaces to external LAPACK routines.
// NOTE: If external-lapack-interfaces is enabled, an LAPACK library will be
// required at link-time.
#define FLA_ENABLE_EXTERNAL_LAPACK_INTERFACES  1

// Determines whether to use control trees to select a reasonable FLAME
// variant and blocksize when level-3 BLAS front-ends are invoked.


// Determines whether to modify various segments of code needed for
// integrating libflame into Windows.


// Determines whether to define a portable FLA_Clock() in terms of
// gettimeofday() from time.h.
#define FLA_ENABLE_PORTABLE_TIMER  1


// --- Runtime error checking and debugging ------------------------------------

// Determines whether to enable internal runtime consistency checks of
// function parameters and return values.
#define FLA_ENABLE_INTERNAL_ERROR_CHECKING 1

// Encodes the default level of internal error checking chosen at
// configure-time.
// 1-minimal error cheking
// 2-full error cheking
// 3-no error cheking
#define FLA_INTERNAL_ERROR_CHECKING_LEVEL 2   

// Determines whether to enable the FLA_malloc()/FLA_free() memory counter
// by default.



// --- Multithreading and SuperMatrix ------------------------------------------

// Determines whether thread-specific blocks of code should be compiled.


// Encodes the type of multithreading chosen at configure-time.
// 1 - openmp
// 2 - pthreads
#define FLA_MULTITHREADING_MODEL 1

// Determines whether SuperMatrix-specific blocks of code should be compiled.



// --- BLAS and blocksizes -----------------------------------------------------

// Determines whether to enable CBLAS interfaces instead of Fortran-77
// interfaces to the BLAS.


// Determines whether to enable interfaces to internal/low-level libgoto
// symbols.


// Sets the default blocksize in the k dimension (used only if
// libgoto interfaces are disabled).


// Sets the default blocksize in the m dimension (used only if
// libgoto interfaces are disabled).


// Sets the default blocksize in the n dimension (used only if
// libgoto interfaces are disabled).



// --- Memory alignment --------------------------------------------------------

// Determines whether memory is aligned to user-requested boundaries.


// Sets the byte boundary used to align the starting address of all memory
// allocated dynamically through libflame. Only used if
// FLA_ENABLE_MEMORY_ALIGNMENT is defined.


// Determines whether to enable code that will increase FLA_Obj leading
// dimensions to ensure that matrix columns adhere to the alignment specified
// by FLA_MEMORY_ALIGNMENT_BOUNDARY.



// --- Fortran-77 compatibility ------------------------------------------------

// Determines whether the Fortran name-mangling suffix was determined at
// configure-time. This option is not used in Windows.


// Determines whether the Fortran 77 compiler appends an underscore to symbol
// names. Not used in Windows.


// Determines whether the Fortran 77 compiler appends an extra underscore to
// symbol names that already contain at least one underscore. Not used in
// Windows.


// Determines whether invocations to the BLAS within libflame are converted to
// uppercase symbols.


// Determines whether invocations to LAPACK within libflame are converted to
// uppercase symbols.



// --- Experimental/unsupported/broken options ---------------------------------

// Determines whether GPU-specific blocks of code should be compiled.


// Determines AMD optimized code path selection
#define FLA_ENABLE_AMD_OPT 1

//Detrmines library Version
#define FLA_LIBFLAME_VERSION   "5.1.0	Build	20250430"

// Determines OpenMP multithreading for AMD optimized code path 
#define FLA_OPENMP_MULTITHREADING  1

// Determins BLAS Extension API, GEMMT usage in libFLAME APIs
#define FLA_ENABLE_BLAS_EXT_GEMMT  1

// Enables FLA_PORTABLE_TIMER_IS_CLOCK_GETTIME
#define FLA_PORTABLE_TIMER_IS_CLOCK_GETTIME  1

//#define FLA_PORTABLE_TIMER_IS_CLOCK_GETTIME 1
#define FLA_VECTOR_INTRINSIC_TYPE 0

// #define other missing macros
#define HAVE_ASSERT_H 1
#define HAVE_FCNTL_H 1
#define HAVE_INTTYPES_H 1
#define HAVE_LIBM 1
#define HAVE_MATH_H 1
#define HAVE_MEMORY_H 1
#define HAVE_SIGNAL_H 1
#define HAVE_STDINT_H 1
#define HAVE_STDLIB_H 1
#define HAVE_STRINGS_H 1
#define HAVE_STRING_H 1
#define HAVE_SYS_STAT_H 1
#define HAVE_SYS_TIME_H 1
#define HAVE_SYS_TYPES_H 1
#define HAVE_UNISTD_H 1

#define PROTOTYPES 1
#define STDC_HEADERS 1
#define TIME_WITH_SYS_TIME 1
#define _GNU_SOURCE 1
#define __PROTOTYPES 1






// end FLA_config.h
// begin FLA_macro_defs.h
			





// --- Miscellaneous macro definitions -----------------------------------------
#ifndef FLA_MACRO_DEFS_H
#define FLA_MACRO_DEFS_H

#undef  NULL
#define NULL 0

#ifdef FLA_ENABLE_WINDOWS_BUILD
  #define restrict  __restrict
#endif

// --- Macro to enable/disable Thread Local Storage (TLS) for global variables -
#if defined(WINDOWS_FLA_SHARED_BUILD) && defined(WINDOWS_FLA_TEST)
 #define ENABLE_THREAD_LOCAL_STORAGE 0
 #define LIBFLAME_IMPORT __declspec(dllimport)
#else
 #if defined(FLA_ENABLE_AMD_OPT) && !defined FLA_ENABLE_SUPERMATRIX
   #define ENABLE_THREAD_LOCAL_STORAGE 1
 #else
   #define ENABLE_THREAD_LOCAL_STORAGE 0
 #endif
 #define LIBFLAME_IMPORT
#endif

#if ENABLE_THREAD_LOCAL_STORAGE
#ifdef FLA_ENABLE_WINDOWS_BUILD
#define TLS_CLASS_SPEC __declspec(thread)
#else
#define TLS_CLASS_SPEC __thread
#endif
#else
#define TLS_CLASS_SPEC
#endif

// --- Type-related macro definitions ------------------------------------------

// FLA_Bool
#undef  TRUE
#undef  FALSE
#define TRUE  1
#define FALSE 0

// FLA_Error (non-specific)
#define FLA_SUCCESS           (-1)
#define FLA_FAILURE           (-2)

// FLA_Quadrant
#define FLA_TL                 11
#define FLA_TR                 12
#define FLA_BL                 21
#define FLA_BR                 22

// FLA_Datatype
#define FLA_FLOAT             100
#define FLA_DOUBLE            101
#define FLA_COMPLEX           102
#define FLA_DOUBLE_COMPLEX    103
#define FLA_INT               104
#define FLA_CONSTANT          105

// FLA_Elemtype
#define FLA_MATRIX            150
#define FLA_SCALAR            151

// FLA_Side
#define FLA_TOP               200
#define FLA_BOTTOM            201
#define FLA_LEFT              210
#define FLA_RIGHT             211
#define FLA_SIDE_MASK         0x1

// FLA_Uplo
#define FLA_LOWER_TRIANGULAR  300
#define FLA_UPPER_TRIANGULAR  301
#define FLA_ZERO_MATRIX       310
#define FLA_FULL_MATRIX       311
#define FLA_UPLO_MASK         0x1

// FLA_Trans
#define FLA_NO_TRANSPOSE      400
#define FLA_TRANSPOSE         401
#define FLA_CONJ_TRANSPOSE    402
#define FLA_CONJ_NO_TRANSPOSE 403
#define FLA_TRANS_MASK        0x3

// FLA_Conj
#define FLA_NO_CONJUGATE      450
#define FLA_CONJUGATE         451

// FLA_Diag
#define FLA_UNIT_DIAG         500
#define FLA_NONUNIT_DIAG      501
#define FLA_ZERO_DIAG         502
#define FLA_DIAG_MASK         0x3

// FLA_Dimension
#define FLA_DIMENSION_M       600
#define FLA_DIMENSION_K       601
#define FLA_DIMENSION_N       602
#define FLA_DIMENSION_MIN     603

// FLA_Dimension_index
#define FLA_DIM_M_INDEX         0
#define FLA_DIM_K_INDEX         1
#define FLA_DIM_N_INDEX         2
#define FLA_DIM_MIN_INDEX       3
#define FLA_DIM_INDEX_MASK    0x3

// FLA_Pivot_type
#define FLA_NATIVE_PIVOTS     700
#define FLA_LAPACK_PIVOTS     701

// FLA_Direct
#define FLA_FORWARD           800
#define FLA_BACKWARD          801

// FLA_Store
#define FLA_COLUMNWISE        900
#define FLA_ROWWISE           901

// FLA_Matrix_type
#define FLA_FLAT             1000
#define FLA_HIER             1001

// FLA_Precision
#define FLA_SINGLE_PRECISION 1100
#define FLA_DOUBLE_PRECISION 1101

// FLA_Domain
#define FLA_REAL_DOMAIN      1200
#define FLA_COMPLEX_DOMAIN   1201

// FLA_Inv    
#define FLA_NO_INVERSE       1300
#define FLA_INVERSE          1301

// FLA_Evd_type
#define FLA_EVD_WITHOUT_VECTORS         1400
#define FLA_EVD_WITH_VECTORS            1401
#define FLA_EVD_OF_TRIDIAG_WITH_VECTORS 1402

// FLA_Svd_type
#define FLA_SVD_VECTORS_ALL           1500
#define FLA_SVD_VECTORS_MIN_COPY      1501
#define FLA_SVD_VECTORS_MIN_OVERWRITE 1502
#define FLA_SVD_VECTORS_NONE          1503

// FLA_Machval
#define FLA_MACH_START                1600
#define FLA_MACH_EPS                  1600
#define FLA_MACH_SFMIN                1601
#define FLA_MACH_BASE                 1602
#define FLA_MACH_PREC                 1603
#define FLA_MACH_NDIGMANT             1604
#define FLA_MACH_RND                  1605
#define FLA_MACH_EMIN                 1606
#define FLA_MACH_RMIN                 1607
#define FLA_MACH_EMAX                 1608
#define FLA_MACH_RMAX                 1609
#define FLA_MACH_EPS2                 1610
#define FLA_MACH_N_VALS                 11

// FLA_Diag_off
#define FLA_SUPER_DIAGONAL     ( 1)
#define FLA_MAIN_DIAGONAL        0
#define FLA_SUB_DIAGONAL       (-1)

// FLAME threading model
#define FLA_OPENMP              1
#define FLA_PTHREADS            2

// FLAME vector intrinsics types
#define FLA_NO_INTRINSICS       0
#define FLA_SSE_INTRINSICS      3

// FLAME internal error checking level
#define FLA_FULL_ERROR_CHECKING 2
#define FLA_MIN_ERROR_CHECKING  1
#define FLA_NO_ERROR_CHECKING   0

// FLA_Datatype_index
#define FLA_S_INDEX             0
#define FLA_D_INDEX             1
#define FLA_C_INDEX             2
#define FLA_Z_INDEX             3
#define FLA_DTYPE_INDEX_MASK  0x3

#define FLA_SMALL_LU_BLOCKSIZE 64
// Default blocksize if none are available.
#ifndef FLA_DEFAULT_M_BLOCKSIZE
  #define FLA_DEFAULT_M_BLOCKSIZE  128
#endif
#ifndef FLA_DEFAULT_K_BLOCKSIZE
  #define FLA_DEFAULT_K_BLOCKSIZE  128
#endif
#ifndef FLA_DEFAULT_N_BLOCKSIZE
  #define FLA_DEFAULT_N_BLOCKSIZE  128
#endif

// Blocksize for hierarchical storage of matrices for FLASH based
// external interfaces
#define FLA_EXT_HIER_BLOCKSIZE 128

// QR and LQ factorizations typically has an inner blocksize that corresponds
// to the length of the S (or T) block Householder matrix. For consistency, we
// define the ratio of the inner blocksize to the outer blocksize here, as it
// is used in several places. Note that other operations have analagous inner
// blocksizes, which we also define in terms of the outer storage blocksize,
// or in some cases such as Hessenberg, tridiagonal, and bidiagonal reductions,
// in terms of the system-wide default blocksize.
#define FLA_QR_INNER_TO_OUTER_B_RATIO      (0.25)
#define FLA_LQ_INNER_TO_OUTER_B_RATIO      (0.25)
#define FLA_LU_INNER_TO_OUTER_B_RATIO      (0.25)
#define FLA_UDDATE_INNER_TO_OUTER_B_RATIO  (0.25)
#define FLA_HESS_INNER_TO_OUTER_B_RATIO    (0.25)
#define FLA_TRIDIAG_INNER_TO_OUTER_B_RATIO (0.25)
#define FLA_BIDIAG_INNER_TO_OUTER_B_RATIO  (0.25)
#define FLA_CAQR_INNER_TO_OUTER_B_RATIO    (0.25)

// Matrix size thresholds for choosing unbloked non-FLA variant of QR for
// small matrices
#define FLA_GEQRF_STHRESH (32)
#define FLA_GEQRF_BLOCK_SIZE (32)
// Matrix size thresholds for choosing transposed QR for LQ 
#define FLA_DELQF_TRAN_THRESH (1280)

//POTRF, threshold numbers to chose paths for performance
#define FLA_POTRF_FLOAT_SMALL         (70)
#define FLA_POTRF_DOUBLE_SMALL        (75)

//GETRF , threshold numbers to chose paths for performance
#define FLA_GETRF_SMALL               (85)
#define FLA_GETRF_FLOAT               (1440)
#define FLA_GETRF_COMPLEX             (670)
#define FLA_GETRF_DOUBLE_COMPLEX      (1630)

#define FLA_SGETRF_SMALL_THRESH1      (117)
#define FLA_SGETRF_MEDIUM_THRESH0     (480)

#define FLA_SGETRF_SMALL_THRESH0      (7)
#define FLA_SGETRF_SMALL_AVX2_THRESH0      (31)
#define FLA_SGETRF_SMALL_AVX512_THRESH0    (156)

#define FLA_DGETRF_SMALL_THRESH0      (8)
#define FLA_DGETRF_SMALL_AVX2_THRESH0      (81)
#define FLA_DGETRF_SMALL_AVX512_THRESH0    (160)

#define FLA_ZGETRF_SMALL_THRESH      (100)

// GETRFNPI , these thresholds are used to chose between 3 algorithms to get best
// results in terms of perfmormance
#define FLA_MN_SIZE            (373321)
#define FLA_NFACT_PERCENT      (0.51)
#define FLA_FULL_DGER_CONSTANT (200)

// ORGQR , threshold numbers to chose paths for performance
#define FLA_DGEMV_DGER_SIMD_SMALL_THRESH   (128)
#define FLA_DGEMV_DGER_SIMD_SMALL_THRESH_M (6)
#define FLA_DGEMV_DGER_SIMD_AVX512_THRESH_M (25)
#define FLA_ZGEMV_ZGER_SIMD_AXV2_THRESH_M (8)
#define FLA_ZGEMV_ZGER_SIMD_AXV512_THRESH_M (49)
#define FLA_SSCAL_INLINE_SMALL          (512)
#define FLA_DSCAL_INLINE_SMALL          (512)
#define FLA_ZGERC_INLINE_SMALL_THRESH0  (128)
#define FLA_ZGERC_INLINE_SMALL_THRESH1  (32)
#define FLA_ZSCAL_INLINE_SMALL          (128)
#define FLA_ZUNGQR_BLOCK_SMALL_THRESH   (32)


#define FLA_ZLANGEM_SIMD_AVX512_THRESH_M (15)
#define FLA_CLANGEM_SIMD_AVX512_THRESH_M (15)

// DNRM2 threshold numbers to chose AVX kernel
#define FLA_DNRM2_SMALL_THRESH0  (15)

// GEQP3 , threshold numbers to chose paths for performance
#define FLA_IDAMAX_INLINE_SMALL_THRESH   (128)
#define FLA_DGEQP3_BLOCK_SMALL_THRESH    (32)
#define FLA_ZGEQP3_BLOCK_SMALL_THRESH    (32)

// --- Error-related macro definitions -----------------------------------------

// Useful when determining the relative index base of the error codes.
#define FLA_ERROR_CODE_MIN                    (-10)

// FLA_Error values.
#define FLA_INVALID_SIDE                      (-10)
#define FLA_INVALID_UPLO                      (-11)
#define FLA_INVALID_TRANS                     (-12)
#define FLA_INVALID_TRANS_GIVEN_DATATYPE      (-13)
#define FLA_INVALID_CONJ                      (-14)
#define FLA_INVALID_DIRECT                    (-15)
#define FLA_INVALID_STOREV                    (-16)
#define FLA_INVALID_DATATYPE                  (-17)
#define FLA_INVALID_INTEGER_DATATYPE          (-18)
#define FLA_INVALID_REAL_DATATYPE             (-19)
#define FLA_INVALID_COMPLEX_DATATYPE          (-20)
#define FLA_OBJECT_NOT_INTEGER                (-21)
#define FLA_OBJECT_NOT_REAL                   (-22)
#define FLA_OBJECT_NOT_COMPLEX                (-23)
#define FLA_OBJECT_NOT_SQUARE                 (-24)
#define FLA_OBJECT_NOT_SCALAR                 (-25)
#define FLA_OBJECT_NOT_VECTOR                 (-26)
#define FLA_INCONSISTENT_DATATYPES            (-27)
#define FLA_NONCONFORMAL_DIMENSIONS           (-28)
#define FLA_UNEQUAL_VECTOR_DIMS               (-29)
#define FLA_INVALID_HESSENBERG_INDICES        (-30)
#define FLA_NULL_POINTER                      (-32)
#define FLA_SPECIFIED_OBJ_DIM_MISMATCH        (-33)
#define FLA_INVALID_PIVOT_TYPE                (-35)
#define FLA_MALLOC_RETURNED_NULL_POINTER      (-37)
#define FLA_OBJECT_BASE_BUFFER_MISMATCH       (-38)
#define FLA_OBJECTS_NOT_VERTICALLY_ADJ        (-39)
#define FLA_OBJECTS_NOT_HORIZONTALLY_ADJ      (-40)
#define FLA_ADJACENT_OBJECT_DIM_MISMATCH      (-41)
#define FLA_OBJECTS_NOT_VERTICALLY_ALIGNED    (-42)
#define FLA_OBJECTS_NOT_HORIZONTALLY_ALIGNED  (-43)
#define FLA_INVALID_FLOATING_DATATYPE         (-44)
#define FLA_OBJECT_NOT_FLOATING_POINT         (-45)
#define FLA_INVALID_BLOCKSIZE_VALUE           (-46)
#define FLA_OPEN_RETURNED_ERROR               (-47)
#define FLA_LSEEK_RETURNED_ERROR              (-48)
#define FLA_CLOSE_RETURNED_ERROR              (-49)
#define FLA_UNLINK_RETURNED_ERROR             (-50)
#define FLA_READ_RETURNED_ERROR               (-51)
#define FLA_WRITE_RETURNED_ERROR              (-52)
#define FLA_INVALID_QUADRANT                  (-53)
#define FLA_NOT_YET_IMPLEMENTED               (-54)
#define FLA_EXPECTED_NONNEGATIVE_VALUE        (-55)
#define FLA_SUPERMATRIX_NOT_ENABLED           (-56)
#define FLA_UNDEFINED_ERROR_CODE              (-57)
#define FLA_INVALID_DIAG                      (-58)
#define FLA_INCONSISTENT_OBJECT_PRECISION     (-59)
#define FLA_INVALID_BLOCKSIZE_OBJ             (-60)
#define FLA_VECTOR_DIM_BELOW_MIN              (-61)
#define FLA_PTHREAD_CREATE_RETURNED_ERROR     (-63)
#define FLA_PTHREAD_JOIN_RETURNED_ERROR       (-64)
#define FLA_INVALID_ISGN_VALUE                (-65)
#define FLA_CHOL_FAILED_MATRIX_NOT_SPD        (-67)
#define FLA_INVALID_ELEMTYPE                  (-68)
#define FLA_POSIX_MEMALIGN_FAILED             (-69)
#define FLA_INVALID_SUBMATRIX_DIMS            (-70)
#define FLA_INVALID_SUBMATRIX_OFFSET          (-71)
#define FLA_OBJECT_NOT_SCALAR_ELEMTYPE        (-72)
#define FLA_OBJECT_NOT_MATRIX_ELEMTYPE        (-73)
#define FLA_ENCOUNTERED_NON_POSITIVE_NTHREADS (-74)
#define FLA_INVALID_CONJ_GIVEN_DATATYPE       (-75)
#define FLA_INVALID_COMPLEX_TRANS             (-76)
#define FLA_INVALID_REAL_TRANS                (-77)
#define FLA_INVALID_BLAS_TRANS                (-78)
#define FLA_INVALID_NONCONSTANT_DATATYPE      (-79)
#define FLA_OBJECT_NOT_NONCONSTANT            (-80)
#define FLA_OBJECT_DATATYPES_NOT_EQUAL        (-82)
#define FLA_DIVIDE_BY_ZERO                    (-83)
#define FLA_OBJECT_ELEMTYPES_NOT_EQUAL        (-84)
#define FLA_INVALID_PIVOT_INDEX_RANGE         (-85)
#define FLA_HOUSEH_PANEL_MATRIX_TOO_SMALL     (-86)
#define FLA_INVALID_OBJECT_LENGTH             (-87)
#define FLA_INVALID_OBJECT_WIDTH              (-88)
#define FLA_INVALID_ERROR_CHECKING_LEVEL      (-89)
#define FLA_ATTEMPTED_OVER_REPART_2X2         (-90)
#define FLA_ATTEMPTED_OVER_REPART_2X1         (-91)
#define FLA_ATTEMPTED_OVER_REPART_1X2         (-92)
#define FLA_EXTERNAL_LAPACK_NOT_IMPLEMENTED   (-93)
#define FLA_INVALID_ROW_STRIDE                (-94)
#define FLA_INVALID_COL_STRIDE                (-95)
#define FLA_INVALID_STRIDE_COMBINATION        (-96)
#define FLA_INVALID_VECTOR_DIM                (-97)
#define FLA_EXPECTED_ROW_VECTOR               (-98)
#define FLA_EXPECTED_COL_VECTOR               (-99)
#define FLA_INVALID_INVERSE                   (-100)
#define FLA_MALLOC_GPU_RETURNED_NULL_POINTER  (-101)
#define FLA_INVALID_EVD_TYPE                  (-102)
#define FLA_INVALID_SVD_TYPE                  (-103)
#define FLA_INVALID_MACHVAL                   (-104)
#define FLA_INVALID_DIAG_OFFSET               (-105)
#define FLA_EXPECTED_COL_STORAGE              (-106)
#define FLA_EXPECTED_ROW_STORAGE              (-107)
#define FLA_LAPAC2FLAME_INVALID_RETURN        (-108)
#define FLA_INVALID_SVD_TYPE_COMBINATION      (-109)
#define FLA_INVALID_SVD_TYPE_AND_TRANS_COMBINATION (-110)
#define FLA_OBJECT_NOT_COMPARABLE             (-111)

// Necessary when computing whether an error code is defined.
#define FLA_ERROR_CODE_MAX                    (-111)

// Internal string matrix limits.
#define FLA_MAX_NUM_ERROR_MSGS                 150
#define FLA_MAX_ERROR_MSG_LENGTH               200

// Error code translation and output macro definition.
#define FLA_Check_error_code( code ) \
        FLA_Check_error_code_helper( code, __FILE__, __LINE__ )



// --- Common functions implemented as macros ----------------------------------

#define fla_min( x, y )    \
({                         \
   __typeof__(x) _x = (x); \
   __typeof__(y) _y = (y); \
   _x < _y ? _x : _y;      \
})

#define fla_max( x, y )    \
({                         \
   __typeof__(x) _x = (x); \
   __typeof__(y) _y = (y); \
   _x > _y ? _x : _y;      \
})

#undef signof
#define signof( a, b ) ( (b) >= 0 ? (a) : -(a) )

#ifndef __cplusplus

 #undef exchange
 #define exchange( a, b, temp ) { temp = a; a = b; b = temp; }

#endif

// --- Other macro definitions -------------------------------------------------

#define FLA_NEGATE( a ) \
        ( a.base == FLA_ONE.base ? FLA_MINUS_ONE : FLA_ONE )

#endif

// end FLA_macro_defs.h
// begin FLA_type_defs.h




#ifndef FLA_TYPE_DEFS_H
#define FLA_TYPE_DEFS_H

#ifdef __cplusplus
// For C++, include stdint.h.
#include <stdint.h> // skipped
#elif __STDC_VERSION__ >= 199901L
// For C99 (or later), include stdint.h.
#include <stdint.h> // skipped
#else
// When stdint.h is not available, manually typedef the types we will use.
#ifdef _WIN32
typedef          __int32  int32_t;
typedef unsigned __int32 uint32_t;
typedef          __int64  int64_t;
typedef unsigned __int64 uint64_t;
#else
#error "Attempting to compile on pre-C99 system without stdint.h."
#endif
#endif

#if defined(FLA_ENABLE_ILP64)
typedef int64_t integer;
typedef uint64_t uinteger;
#else
typedef int integer;
typedef unsigned long uinteger;
#endif



#if   FLA_MULTITHREADING_MODEL == FLA_OPENMP
#ifdef FLA_ENABLE_TIDSP
#include <ti/omp/omp.h> // skipped
#else
#include <omp.h> // skipped
#endif
#elif FLA_MULTITHREADING_MODEL == FLA_PTHREADS
#include <pthread.h> // skipped
#endif


// --- Complex type definitions -----------------------------------------------

#ifndef _DEFINED_SCOMPLEX
#define _DEFINED_SCOMPLEX
typedef struct scomplex
{
  float real, imag;
} scomplex;
#endif

#ifndef _DEFINED_DCOMPLEX
#define _DEFINED_DCOMPLEX
typedef struct dcomplex
{
  double real, imag;
} dcomplex;
#endif


// --- Parameter and return type definitions ----------------------------------

typedef int FLA_Bool;
typedef int FLA_Error;
typedef int FLA_Quadrant;
typedef int FLA_Datatype;
typedef int FLA_Elemtype;
typedef int FLA_Side;
typedef int FLA_Uplo;
typedef int FLA_Trans;
typedef int FLA_Conj;
typedef int FLA_Diag;
typedef int FLA_Dimension;
typedef int FLA_Pivot_type;
typedef int FLA_Direct;
typedef int FLA_Store;
typedef int FLA_Matrix_type;
typedef int FLA_Precision;
typedef int FLA_Domain;
typedef int FLA_Inv;
typedef int FLA_Evd_type;
typedef int FLA_Svd_type;
typedef int FLA_Machval;
typedef int FLA_Diag_off;

#ifndef _DEFINED_FLA_DIM_T
#define _DEFINED_FLA_DIM_T
typedef uinteger fla_dim_t;
#endif

// --- Intrinsic/assembly definitions ----------------------------------------

#if FLA_VECTOR_INTRINSIC_TYPE == FLA_SSE_INTRINSICS

#include "pmmintrin.h" // skipped

//typedef double v2df __attribute__ ((vector_size (16)));

typedef union
{
    __m128  v; 
    float   f[4];
} v4sf_t;

typedef union
{
    __m128d v; 
    double  d[2];
} v2df_t;

#endif

// --- FLAME object definitions -----------------------------------------------

typedef struct FLA_Lock_s     FLA_Lock;

//#ifdef FLA_ENABLE_MULTITHREADING
struct FLA_Lock_s
{
  // Implementation-specific lock object
#if   FLA_MULTITHREADING_MODEL == FLA_OPENMP
  omp_lock_t       lock;
#elif FLA_MULTITHREADING_MODEL == FLA_PTHREADS
  pthread_mutex_t  lock;
#endif
};
//#endif

#ifdef FLA_ENABLE_SUPERMATRIX
typedef int                   FLASH_Verbose;
typedef int                   FLASH_Data_aff;

typedef struct FLASH_Queue_s  FLASH_Queue;
typedef struct FLASH_Task_s   FLASH_Task;
typedef struct FLASH_Dep_s    FLASH_Dep;
#endif
typedef struct FLASH_Thread_s FLASH_Thread;

typedef struct FLA_Obj_struct
{
  // Basic object description fields
  FLA_Datatype  datatype;
  FLA_Elemtype  elemtype;
  fla_dim_t         m;
  fla_dim_t         n;
  fla_dim_t         rs;
  fla_dim_t         cs;
  fla_dim_t         m_inner;
  fla_dim_t         n_inner;
  unsigned long id;
  fla_dim_t         m_index;
  fla_dim_t         n_index;

  fla_dim_t         n_elem_alloc;
  void*         buffer;
  int           buffer_info;

  FLA_Uplo      uplo;

#ifdef FLA_ENABLE_SUPERMATRIX
  // Fields for supermatrix
  int           n_read_blocks;
  int           n_write_blocks;

  // All the tasks that previously read this block, anti-dependency
  int           n_read_tasks;
  FLASH_Dep*    read_task_head;
  FLASH_Dep*    read_task_tail;

  // Task that last overwrote this block, flow dependency
  FLASH_Task*   write_task;
#endif
} FLA_Base_obj;

typedef struct FLA_Obj_view
{
  // Basic object view description fields
  fla_dim_t         offm;
  fla_dim_t         offn;
  fla_dim_t         m;
  fla_dim_t         n;
  
  fla_dim_t         m_inner;
  fla_dim_t         n_inner;

  FLA_Base_obj* base;

} FLA_Obj;

#ifdef FLA_ENABLE_SUPERMATRIX
struct FLASH_Queue_s
{
  // Number of tasks currently in queue
  unsigned int  n_tasks;

  // Pointers to head (front) and tail (back) of queue
  FLASH_Task*   head;
  FLASH_Task*   tail;
};

struct FLASH_Task_s
{
  // Execution information
  int           n_ready;

  // Labels
  int           order;
  int           queue;
  int           height;
  int           thread;
  int           cache;
  FLA_Bool      hit;
      
  // Function pointer
  void*         func;

  // Control tree pointer
  void*         cntl;

  // Name of task
  char*         name;

  // GPU enabled task
  FLA_Bool      enabled_gpu;

  // Integer arguments
  int           n_int_args;
  int*          int_arg;

  // Constant FLA_Obj arguments
  int           n_fla_args;
  FLA_Obj*      fla_arg;

  // Input FLA_Obj arguments
  int           n_input_args;
  FLA_Obj*      input_arg;

  // Output FLA_Obj argument
  int           n_output_args;
  FLA_Obj*      output_arg;

  // Number of blocks within all macroblocks
  int           n_macro_args;

  // Number of write after read dependencies
  int           n_war_args;

  // Dependence information
  int           n_dep_args;
  FLASH_Dep*    dep_arg_head;
  FLASH_Dep*    dep_arg_tail;
  
  // Support for a doubly linked list of tasks
  FLASH_Task*   prev_task;
  FLASH_Task*   next_task;

  // Support for a doubly linked list for wait queue
  FLASH_Task*   prev_wait;
  FLASH_Task*   next_wait;
};

struct FLASH_Dep_s
{
  // Task yielding dependency
  FLASH_Task*   task;

  // Support for linked list of FLASH_Deps
  FLASH_Dep*    next_dep;
};
#endif // FLA_ENABLE_SUPERMATRIX

struct FLASH_Thread_s
{
  // The thread's unique identifier
  int       id;

  // Pointer to variables needed to execute SuperMatrix mechanism
  void*     args;

#if FLA_MULTITHREADING_MODEL == FLA_PTHREADS
  // The thread object. Only needed for the POSIX threads implementation.
  pthread_t pthread_obj;
#endif
};

#endif // FLA_TYPE_DEFS_H
// end FLA_type_defs.h
// begin aocldtl.h


#ifndef _AOCLDTL_H_
#define _AOCLDTL_H_

// begin aocldtlcf.h


#ifndef _AOCLDTLCF_H_
#define _AOCLDTLCF_H_


#define AOCL_DTL_TRACE_ENABLE 0


#define AOCL_DTL_DUMP_ENABLE 0


#define AOCL_DTL_LOG_ENABLE 0



#define AOCL_DTL_TRACE_LEVEL AOCL_DTL_LEVEL_TRACE_5

// A workaround for autotools and cmake to work together. To be removed on complete migration to
// cmake and defauilt values of AOCL_DTL_LOG_ENABLE and AOCL_DTL_TRACE_ENABLE to be set to 1. In
// order to fully allow enabling and disbling of logs and trace from cmake commandline
#if AOCL_DTL_LOG_ENABLE
#define LF_AOCL_DTL_LOG_ENABLE 1
#else
#define LF_AOCL_DTL_LOG_ENABLE 0
#endif

#if AOCL_DTL_TRACE_ENABLE
#define LF_AOCL_DTL_TRACE_ENABLE 1
#else
#define LF_AOCL_DTL_TRACE_ENABLE 0
#endif


#define AOCL_DTL_LEVEL_ALL (14)
#define AOCL_DTL_LEVEL_TRACE_8 (13)
#define AOCL_DTL_LEVEL_TRACE_7 (12) 
#define AOCL_DTL_LEVEL_TRACE_6 (11)
#define AOCL_DTL_LEVEL_TRACE_5 (10)
#define AOCL_DTL_LEVEL_TRACE_4 (9)
#define AOCL_DTL_LEVEL_TRACE_3 (8)
#define AOCL_DTL_LEVEL_TRACE_2 (7)
#define AOCL_DTL_LEVEL_TRACE_1 (6) 
#define AOCL_DTL_LEVEL_VERBOSE (5)
#define AOCL_DTL_LEVEL_INFO (4)
#define AOCL_DTL_LEVEL_MINOR (3)
#define AOCL_DTL_LEVEL_MAJOR (2)
#define AOCL_DTL_LEVEL_CRITICAL (1)

#define AOCL_DTL_TRACE_FILE "aocldtl_trace.txt"
#define AOCL_DTL_AUTO_TRACE_FILE "aocldtl_auto_trace.rawfile"
#define AOCL_DTL_LOG_FILE "aocldtl_log.txt"


#define AOCL_CHAR_DATA_TYPE (1)


#define AOCL_UINT16_DATA_TYPE (2)


#define AOCL_STRING_DATA_TYPE (3)


#define AOCL_UINT32_DATA_TYPE (4)


#define AOCL_LOG_HEX_VALUE ('x')


#define AOCL_LOG_DECIMAL_VALUE ('d')

#endif 


// end aocldtlcf.h
// begin aoclflist.h


#ifndef _AOCL_FLIST_H_
#define _AOCL_FLIST_H_

// begin aoclfal.h


#ifndef _AOCL_FAL_H_
#define _AOCL_FAL_H_


#define AOCL_FAL_SUCCESS 0
#define AOCL_FAL_CLOSE_ERROR -1
#define AOCL_FAL_READ_ERROR -2
#define AOCL_FAL_WRITE_ERROR -3
#define AOCL_FAL_EOF_ERROR -6
#define AOCL_FAL_FERROR -7
// begin aocltpdef.h


#ifndef AOCL_TYPEDEF_H_
#define AOCL_TYPEDEF_H_

#include <math.h> // skipped
#include <memory.h> // skipped
#include <stdio.h> // skipped
#include <stdlib.h> // skipped
#include <time.h> // skipped
#ifndef _WIN32
#include <sys/types.h> // skipped
#else
typedef int pid_t;
#endif

typedef double Double;
typedef float Float;
typedef void Void;
typedef unsigned char uint8;
typedef unsigned short int uint16;
typedef unsigned int uint32;
typedef unsigned long uint64;
typedef uint8 *STRING;
typedef unsigned char Bool;
typedef char int8;
typedef signed long int int32;
typedef short int int16;

typedef Void *AOCL_HANDLE;
typedef pid_t AOCL_TID;

#endif 


// end aocltpdef.h


#define AOCL_FAL_FILE FILE


int32 AOCL_FAL_Close(AOCL_FAL_FILE *fpFilePointer);

int32 AOCL_FAL_Error(AOCL_FAL_FILE *fpFilePointer);

AOCL_FAL_FILE *AOCL_FAL_Open(const int8 *pchFileName, const int8 *pchMode);

int32 AOCL_FAL_Read(void *pvBuffer, int32 i32Size, int32 i32Count, AOCL_FAL_FILE *fpFilePointer);

int32 AOCL_FAL_Write(const void *pvBuffer, int32 i32Size, int32 iCount,
                     AOCL_FAL_FILE *fpFilePointer);

#endif 


// end aoclfal.h
// begin aocltpdef.h


#ifndef AOCL_TYPEDEF_H_
#define AOCL_TYPEDEF_H_

#include <math.h> // skipped
#include <memory.h> // skipped
#include <stdio.h> // skipped
#include <stdlib.h> // skipped
#include <time.h> // skipped
#ifndef _WIN32
#include <sys/types.h> // skipped
#else
typedef int pid_t;
#endif

typedef double Double;
typedef float Float;
typedef void Void;
typedef unsigned char uint8;
typedef unsigned short int uint16;
typedef unsigned int uint32;
typedef unsigned long uint64;
typedef uint8 *STRING;
typedef unsigned char Bool;
typedef char int8;
typedef signed long int int32;
typedef short int int16;

typedef Void *AOCL_HANDLE;
typedef pid_t AOCL_TID;

#endif 


// end aocltpdef.h

typedef struct AOCL_FLIST_Node_t
{
    AOCL_TID tid;
    AOCL_FAL_FILE *fp;
    struct AOCL_FLIST_Node_t *pNext;
} AOCL_FLIST_Node;

Bool AOCL_FLIST_IsEmpty(AOCL_FLIST_Node *plist);

AOCL_FAL_FILE *AOCL_FLIST_GetFile(AOCL_FLIST_Node *plist, AOCL_TID tid);

AOCL_FAL_FILE *AOCL_FLIST_AddFile(const int8 *pchFilePrefix, AOCL_FLIST_Node **plist, AOCL_TID tid);

void AOCL_FLIST_CloseFile(AOCL_FLIST_Node *plist, AOCL_TID tid);

void AOCL_FLIST_CloseAll(AOCL_FLIST_Node *plist);

#endif 


// end aoclflist.h
// begin aocltpdef.h


#ifndef AOCL_TYPEDEF_H_
#define AOCL_TYPEDEF_H_

#include <math.h> // skipped
#include <memory.h> // skipped
#include <stdio.h> // skipped
#include <stdlib.h> // skipped
#include <time.h> // skipped
#ifndef _WIN32
#include <sys/types.h> // skipped
#else
typedef int pid_t;
#endif

typedef double Double;
typedef float Float;
typedef void Void;
typedef unsigned char uint8;
typedef unsigned short int uint16;
typedef unsigned int uint32;
typedef unsigned long uint64;
typedef uint8 *STRING;
typedef unsigned char Bool;
typedef char int8;
typedef signed long int int32;
typedef short int int16;

typedef Void *AOCL_HANDLE;
typedef pid_t AOCL_TID;

#endif 


// end aocltpdef.h

#define TRACE_TYPE_FENTRY (1)
#define TRACE_TYPE_FEXIT (2)
#define TRACE_TYPE_LOG (3)
#define TRACE_TYPE_RAW (4)


#define AOCL_DEBUGPRINT printf


#if(LF_AOCL_DTL_TRACE_ENABLE || AOCL_DTL_DUMP_ENABLE || LF_AOCL_DTL_LOG_ENABLE)
#define AOCL_DTL_INITIALIZE_ENABLE
#endif

#if LF_AOCL_DTL_TRACE_ENABLE

#define AOCL_DTL_TRACE_ENTRY(LogLevel) \
    DTL_Trace(LogLevel, TRACE_TYPE_FENTRY, __FILE__, __FUNCTION__, __LINE__, NULL);
#else

#define AOCL_DTL_TRACE_ENTRY(LogLevel)
#endif

#if LF_AOCL_DTL_TRACE_ENABLE

#define AOCL_DTL_TRACE_EXIT(LogLevel) \
    DTL_Trace(LogLevel, TRACE_TYPE_FEXIT, __FILE__, __FUNCTION__, __LINE__, NULL);

#define AOCL_DTL_TRACE_EXIT_ERR(LogLevel, Message) \
    DTL_Trace(LogLevel, TRACE_TYPE_FEXIT, __FILE__, __FUNCTION__, __LINE__, Message);
#else

#define AOCL_DTL_TRACE_EXIT(LogLevel)
#define AOCL_DTL_TRACE_EXIT_ERR(LogLevel, Message)
#endif

#if AOCL_DTL_DUMP_ENABLE

#define AOCL_DTL_DUMP(LogLevel, Buffer, BufferSize, DataType, String, OutputType) \
                                     \
    DTL_DumpData(LogLevel, Buffer, BufferSize, DataType, String, OutputType);
#else

#define AOCL_DTL_DUMP(Buffer, BufferSize, DataType, String, OutputType)

#endif

#if LF_AOCL_DTL_LOG_ENABLE

#define AOCL_DTL_LOG(LogLevel, Message) \
    DTL_Trace(LogLevel, TRACE_TYPE_LOG, __FILE__, __FUNCTION__, __LINE__, Message);
#else

#define AOCL_DTL_LOG(LogLevel, Message)
#endif


#ifdef AOCL_DTL_INITIALIZE_ENABLE
#define AOCL_DTL_INITIALIZE(CURRENT_LOG_LEVEL) DTL_Initialize(CURRENT_LOG_LEVEL);
#else

#define AOCL_DTL_INITIALIZE(CURRENT_LOG_LEVEL)
#endif


#ifdef AOCL_DTL_INITIALIZE_ENABLE
#define AOCL_DTL_UNINITIALIZE() DTL_Uninitialize();
#else

#define AOCL_DTL_UNINITIALIZE()
#endif

#ifdef AOCL_DTL_INITIALIZE_ENABLE

void DTL_Initialize(uint32 ui32CurrentLogLevel);
void DTL_Uninitialize(void);
#endif

#if(LF_AOCL_DTL_TRACE_ENABLE || LF_AOCL_DTL_LOG_ENABLE)

void DTL_Trace(uint8 ui8LogLevel, uint8 ui8LogType, const int8 *pi8FileName,
               const int8 *pi8FunctionName, uint32 ui32LineNumber, const int8 *pi8Message);

#endif

#if AOCL_DTL_DUMP_ENABLE

void DTL_DumpData(uint8 ui8LogLevel, void *pvBuffer, uint32 ui32BufferSize, uint8 ui8DataType,
                  int8 *pi8Message, int8 i8OutputType);
#endif

#endif 


// end aocldtl.h
// begin FLA_progress.h


#ifdef __cplusplus
  // For C++, include stdint.h.
#include <stdint.h> // skipped
#elif __STDC_VERSION__ >= 199901L
  // For C99 (or later), include stdint.h.
#include <stdint.h> // skipped
#else
  // When stdint.h is not available, manually typedef the types we will use.
#ifdef _WIN32
typedef          __int32  int32_t;
typedef unsigned __int32 uint32_t;
typedef          __int64  int64_t;
typedef unsigned __int64 uint64_t;
#else
#error "Attempting to compile on pre-C99 system without stdint.h."
#endif
#endif

#ifdef FLA_ENABLE_ILP64
typedef int64_t integer;
typedef uint64_t uinteger;
#else
typedef int integer;
typedef unsigned long int uinteger;
#endif

#define AOCL_FLA_PROGRESS_H 1
typedef int (*aocl_fla_progress_callback)(
const char* const api,
const integer lenapi,
const integer* const progress,
const integer* const current_thread,
const integer* const total_threads
);

void aocl_fla_set_progress(aocl_fla_progress_callback func);
extern volatile aocl_fla_progress_callback aocl_fla_progress_glb_ptr;
#ifndef FLA_ENABLE_WINDOWS_BUILD  
__attribute__((weak))
int aocl_fla_progress(
const char* const api,
const integer lenapi,
const integer* const progress,
const integer* const current_thread,
const integer* const total_threads
);
#endif
// Macro to send update using api name
#define AOCL_FLA_PROGRESS_FUNC_PTR(api,lenapi,progress,tid,nt) \
         if((*aocl_fla_progress_ptr) (api,lenapi, progress, tid, nt)){\
            printf("stop computation \n");\
			exit(0);\
         }\

#if FLA_OPENMP_MULTITHREADING

#define AOCL_FLA_PROGRESS_VAR \
        aocl_fla_progress_callback aocl_fla_progress_ptr = aocl_fla_progress_glb_ptr;\
        static TLS_CLASS_SPEC integer progress_step_count = 0;\
        static TLS_CLASS_SPEC integer progress_thread_id = 0;\
        static TLS_CLASS_SPEC integer progress_total_threads = 1;\
        progress_thread_id = omp_get_thread_num();\
        progress_total_threads = omp_get_num_threads();\

#else

#define AOCL_FLA_PROGRESS_VAR \
        aocl_fla_progress_callback aocl_fla_progress_ptr = aocl_fla_progress_glb_ptr;\
        static TLS_CLASS_SPEC integer progress_step_count = 0;\
        static TLS_CLASS_SPEC integer progress_thread_id = 0;\
        static TLS_CLASS_SPEC integer progress_total_threads = 1;\
        progress_thread_id = 0;\
        progress_total_threads = 1;\

#endif
// end FLA_progress.h
// begin FLA_Context.h


#pragma once
#ifndef FLA_CONTEXT_H
#define FLA_CONTEXT_H

#include <ctype.h> // skipped
// -- Type and macro definitions -----------------------------------------------

#if defined(FLA_NO_CONTEXT)

// This branch defines a pthread-like API, fla_pthread_*(), and implements it
// in terms of "dummy" code that doesn't depend on POSIX threads or any other
// threading mechanism.
// NOTE: THIS CODE DOES NOT IMPLEMENT THREADING AND IS NOT THREAD-SAFE!

// -- pthread types --

typedef int fla_pthread_mutex_t;
typedef int fla_pthread_once_t;

// -- pthreads macros --

#define FLA_PTHREAD_MUTEX_INITIALIZER 0
#define FLA_PTHREAD_ONCE_INIT 0

#elif defined(_MSC_VER) // !defined(FLA_NO_CONTEXT)

#include <windows.h> // skipped
// This branch defines a pthread-like API, fla_pthread_*(), and implements it
// in terms of Windows API calls.

// -- pthread types --
typedef SRWLOCK   fla_pthread_mutex_t;
typedef INIT_ONCE fla_pthread_once_t;

// -- pthreads macros --

#define FLA_PTHREAD_MUTEX_INITIALIZER SRWLOCK_INIT
#define FLA_PTHREAD_ONCE_INIT INIT_ONCE_STATIC_INIT

#else // !defined(FLA_NO_CONTEXT) && !defined(_MSC_VER)

#include <pthread.h> // skipped

// This branch defines a pthreads-like API, fla_pthreads_*(), and implements it
// in terms of the corresponding pthreads_*() types, macros, and function calls.

// -- pthread types --

typedef pthread_mutex_t fla_pthread_mutex_t;
typedef pthread_once_t  fla_pthread_once_t;

// -- pthreads macros --

#define FLA_PTHREAD_MUTEX_INITIALIZER PTHREAD_MUTEX_INITIALIZER
#define FLA_PTHREAD_ONCE_INIT PTHREAD_ONCE_INIT

#endif

// -- Function definitions -----------------------------------------------------

// -- pthread_mutex_*() --

int fla_pthread_mutex_lock(fla_pthread_mutex_t *mutex);

int fla_pthread_mutex_unlock(fla_pthread_mutex_t *mutex);

// -- pthread_once() --

void fla_pthread_once(fla_pthread_once_t *once, void (*init)(void));


typedef enum
{
    // NOTE: The C language standard guarantees that the first enum value
    // starts at 0.

    FLA_ARCH_GENERIC,
    FLA_ARCH_SSE2,
    FLA_ARCH_AVX,
    FLA_ARCH_AVX2,
    FLA_ARCH_AVX512

} fla_arch_t;


typedef struct _fla_context
{
    // num of threads
    int num_threads;
    FLA_Bool    is_fma;
    FLA_Bool    is_avx2;
    FLA_Bool    is_avx512;
    fla_arch_t  arch_id;
    FLA_Bool    libflame_mt; // num_threads is set using libFLAME environment variable or using OpenMP.
} fla_context;

#define FLA_CONTEXT_INITIALIZER \
    { \
      .num_threads = -1, \
      .is_fma      = FALSE, \
      .is_avx2     = FALSE, \
      .is_avx512   = FALSE, \
      .libflame_mt = FALSE, \
    }

extern fla_context fla_global_context;

// Macros for checking the architecture
#define FLA_IS_MIN_ARCH_ID(ARCH_ID) (fla_global_context.arch_id >= ARCH_ID)
#define FLA_IS_ARCH_ID(ARCH_ID) (fla_global_context.arch_id == ARCH_ID)

typedef struct _fla_tl_context
{
    // num of threads
    int num_threads;
    FLA_Bool    libflame_mt; // num_threads is set using libFLAME environment variable or using OpenMP.
} fla_tl_context_t;

#define FLA_TL_CONTEXT_INITIALIZER \
    { \
      .num_threads = -1, \
      .libflame_mt = FALSE, \
    }

extern TLS_CLASS_SPEC fla_tl_context_t fla_tl_context;


void aocl_fla_init();


void aocl_fla_finalize();

#endif // FLA_CONTEXT_H
// end FLA_Context.h
// begin FLA_Threads.h


#ifdef FLA_OPENMP_MULTITHREADING

#ifndef API_ID_DEFINED
#define API_ID_DEFINED


typedef enum
{
    FLA_LABRD = 0,
    FLA_ORMQR,
    FLA_ORMLQ
} API_ID;
#endif


void FLA_Thread_get_subrange( int thread_ID, int num_threads, integer range, integer *sub_range, integer *index );
void FLA_Thread_optimum( API_ID family, int *actual_num_threads);

#endif// end FLA_Threads.h

#ifndef F2C_INCLUDE
#define F2C_INCLUDE

#define c_div(c, a, b) cladiv_f2c_(c, a, b)
#define z_div(c, a, b) zladiv_f2c_(c, a, b)

#ifdef FLA_ENABLE_F2C_DOTC
#define cdotc_f2c_ cdotc_
#define zdotc_f2c_ zdotc_

#define cdotu_f2c_ cdotu_
#define zdotu_f2c_ zdotu_
#endif

//DTL purpose
#ifdef FLA_ENABLE_ILP64
#define FLA_IS "lld"
#else
#define FLA_IS "d"
#endif

#if LF_AOCL_DTL_LOG_ENABLE
	
	double FLA_Clock();
	void get_time_unit(char * , double *);

	#define BUFF_SIZE 256
	#define BUFFER buffer
	
	#define AOCL_DTL_SNPRINTF(...) snprintf(BUFFER,BUFF_SIZE,__VA_ARGS__)

#else
	#define AOCL_DTL_SNPRINTF(...)

#endif


#if LF_AOCL_DTL_TRACE_ENABLE
	extern TLS_CLASS_SPEC int AOCL_TRACE_COUNTER;
	#define AOCL_DTL_TRACE_ENTRY_INDENT AOCL_DTL_TRACE_ENTRY(AOCL_TRACE_COUNTER++);
	#define AOCL_DTL_TRACE_EXIT_INDENT 	AOCL_DTL_TRACE_EXIT(--AOCL_TRACE_COUNTER);
#else
	#define AOCL_DTL_TRACE_ENTRY_INDENT 
	#define AOCL_DTL_TRACE_EXIT_INDENT
#endif



#if LF_AOCL_DTL_LOG_ENABLE & LF_AOCL_DTL_TRACE_ENABLE
	#define AOCL_DTL_TRACE_LOG_INIT 						\
		AOCL_DTL_TRACE_ENTRY_INDENT							\
		double api_start_time = 0.0;      					\
		char buffer[256],unit[3]=" s";    					\
		double api_duration;              					\
		api_start_time = FLA_Clock();

	#define AOCL_DTL_TRACE_LOG_EXIT    						\
		api_duration = FLA_Clock()-api_start_time;      	\
		get_time_unit(unit, &api_duration);					\
		snprintf(buffer+strlen(buffer), 					\
			sizeof(buffer) - strlen(buffer),				\
			" time: %06.2f%s ",api_duration,unit);			\
		AOCL_DTL_LOG(AOCL_DTL_LEVEL_INFO, buffer);   		\
		AOCL_DTL_TRACE_EXIT_INDENT

#elif LF_AOCL_DTL_LOG_ENABLE
	#define AOCL_DTL_TRACE_LOG_INIT 						\
		double api_start_time = 0.0;    					\
		char buffer[256],unit[3]=" s";  					\
		double api_duration;            					\
		api_start_time = FLA_Clock();

	#define AOCL_DTL_TRACE_LOG_EXIT    						\
		api_duration = FLA_Clock()-api_start_time;      	\
		get_time_unit(unit,  &api_duration);				\
		snprintf(buffer+strlen(buffer), 					\
				sizeof(buffer) - strlen(buffer),			\
				" time: %06.2f%s ", api_duration,unit);		\
		AOCL_DTL_LOG(AOCL_DTL_LEVEL_INFO, buffer);   

#elif LF_AOCL_DTL_TRACE_ENABLE
	#define AOCL_DTL_TRACE_LOG_INIT 						\
		AOCL_DTL_TRACE_ENTRY_INDENT

	#define AOCL_DTL_TRACE_LOG_EXIT  						\
		AOCL_DTL_TRACE_EXIT_INDENT

#else
	#define AOCL_DTL_TRACE_LOG_INIT 
	#define AOCL_DTL_TRACE_LOG_EXIT

#endif


#define M_PTR(A, r, c, lda) ((A) + (((c) * (lda)) + (r)))

// LDLT Factorization for packed matrices uses different threshold to choose
// between blocked /  unblocked variants and also the blocksize for the blocked
// variant. The thresholds and blocksizes re defined here
#define FLA_SPFFRT2__NTHRESH1         (64)
#define FLA_SPFFRT2__NTHRESH2         (201)
#define FLA_SPFFRT2__NTHRESH3         (4096)
#define FLA_SPFFRT2__NCOLTHRESH       (3)
#define FLA_SPFFRT2__NCOLFRAC_THRESH1 (25)
#define FLA_SPFFRT2__NCOLFRAC_THRESH2 (80)
#define FLA_SPFFRT2__NCOLFRAC_THRESH3 (20)
#define FLA_SPFFRT2__BSIZE_NL1        (256)
#define FLA_SPFFRT2__BSIZE_NL2        (4096)
#define FLA_SPFFRT2__BSIZE1           (8)
#define FLA_SPFFRT2__BSIZE2           (32)
#define FLA_SPFFRT2__BSIZE3           (64)



#ifdef __cplusplus
  // For C++, include stdint.h.
#include <stdint.h> // skipped
#elif __STDC_VERSION__ >= 199901L
  // For C99 (or later), include stdint.h.
#include <stdint.h> // skipped
#else
  // When stdint.h is not available, manually typedef the types we will use.
#ifdef _WIN32
typedef          __int32  int32_t;
typedef unsigned __int32 uint32_t;
typedef          __int64  int64_t;
typedef unsigned __int64 uint64_t;
#else
#error "Attempting to compile on pre-C99 system without stdint.h."
#endif
#endif

#ifdef FLA_ENABLE_ILP64
typedef int64_t integer;
typedef uint64_t uinteger;
#else
typedef int32_t integer;
typedef unsigned long int uinteger;
#endif

typedef char *address;
typedef short int shortint;
typedef float real;
typedef double doublereal;
typedef struct { real r, i; } complex;
typedef struct { doublereal r, i; } doublecomplex;


typedef integer logical; 

typedef short int shortlogical;
typedef char logical1;
typedef char integer1;
#ifdef INTEGER_STAR_8	
typedef long long longint;		
typedef unsigned long long ulongint;	
#define qbit_clear(a,b)	((a) & ~((ulongint)1 << (b)))
#define qbit_set(a,b)	((a) |  ((ulongint)1 << (b)))
#endif

#define TRUE_ (1)
#define FALSE_ (0)


#ifndef Extern
#define Extern extern
#endif


#ifdef f2c_i2

typedef short flag;
typedef short ftnlen;
typedef short ftnint;
#else
typedef long int flag;
typedef integer ftnlen;
typedef long int ftnint;
#endif


typedef struct
{	flag cierr;
	ftnint ciunit;
	flag ciend;
	char *cifmt;
	ftnint cirec;
} cilist;


typedef struct
{	flag icierr;
	char *iciunit;
	flag iciend;
	char *icifmt;
	ftnint icirlen;
	ftnint icirnum;
} icilist;


typedef struct
{	flag oerr;
	ftnint ounit;
	char *ofnm;
	ftnlen ofnmlen;
	char *osta;
	char *oacc;
	char *ofm;
	ftnint orl;
	char *oblnk;
} olist;


typedef struct
{	flag cerr;
	ftnint cunit;
	char *csta;
} cllist;


typedef struct
{	flag aerr;
	ftnint aunit;
} alist;


typedef struct
{	flag inerr;
	ftnint inunit;
	char *infile;
	ftnlen infilen;
	ftnint	*inex;	
	ftnint	*inopen;
	ftnint	*innum;
	ftnint	*innamed;
	char	*inname;
	ftnlen	innamlen;
	char	*inacc;
	ftnlen	inacclen;
	char	*inseq;
	ftnlen	inseqlen;
	char 	*indir;
	ftnlen	indirlen;
	char	*infmt;
	ftnlen	infmtlen;
	char	*inform;
	ftnint	informlen;
	char	*inunf;
	ftnlen	inunflen;
	ftnint	*inrecl;
	ftnint	*innrec;
	char	*inblank;
	ftnlen	inblanklen;
} inlist;

#define VOID void

union Multitype {	
	integer1 g;
	shortint h;
	integer i;
	
	real r;
	doublereal d;
	complex c;
	doublecomplex z;
	};

typedef union Multitype Multitype;

	

struct Vardesc {	
	char *name;
	char *addr;
	ftnlen *dims;
	int  type;
	};
typedef struct Vardesc Vardesc;

struct Namelist {
	char *name;
	Vardesc **vars;
	int nvars;
	};
typedef struct Namelist Namelist;

#ifndef ceiling_f90_
  #define ceiling_f90_(x) ((integer)(x) + ((x) > 0 && (x) != (integer)(x)))
#endif
#ifndef floor_f90_
  #define floor_f90_(x) ((integer)(x) - ((x) < 0 && (x) != (integer)(x)))
#endif
#ifndef f2c_abs
  #define f2c_abs(x) ((x) >= 0 ? (x) : -(x))
#endif
#ifndef f2c_dabs
  #define f2c_dabs(x) (doublereal)f2c_abs(x)
#endif
#ifndef dmin
  #define dmin(a,b) (doublereal)fla_min(a,b)
#endif
#ifndef dmax
  #define dmax(a,b) (doublereal)fla_max(a,b)
#endif

#define bit_test(a,b)	((a) >> (b) & 1)
#define bit_clear(a,b)	((a) & ~((uinteger)1 << (b)))
#define bit_set(a,b)	((a) |  ((uinteger)1 << (b)))



#define F2C_proc_par_types 1
#ifdef __cplusplus
typedef int  (*U_fp)(...);
typedef shortint (*J_fp)(...);
typedef integer (*I_fp)(...);
typedef real (*R_fp)(...);
typedef doublereal (*D_fp)(...);
typedef doublereal (*E_fp)(...);
typedef  VOID (*C_fp)(...);
typedef  VOID (*Z_fp)(...);
typedef logical (*L_fp)(...);
typedef logical (*L_fp1)(complex *);
typedef logical (*L_fp2)(complex *, complex *);
typedef logical (*L_fps2)(real *, real *);
typedef logical (*L_fps3)(real *, real *, real *);
typedef logical (*L_fpd2)(doublereal *, doublereal *);
typedef logical (*L_fpd3)(doublereal *, doublereal *, doublereal *);
typedef logical (*L_fpz1)(doublecomplex *);
typedef logical (*L_fpz2)(doublecomplex *, doublecomplex *);
typedef shortlogical (*K_fp)(...);
typedef  VOID (*H_fp)(...);
typedef  int (*S_fp)(...);
#else
typedef int  (*U_fp)();
typedef shortint (*J_fp)();
typedef integer (*I_fp)();
typedef real (*R_fp)();
typedef doublereal (*D_fp)();
typedef doublereal (*E_fp)();
typedef  VOID (*C_fp)();
typedef  VOID (*Z_fp)();
typedef logical (*L_fp)();
typedef logical (*L_fp1)(complex *);
typedef logical (*L_fp2)(complex *, complex *);
typedef logical (*L_fps2)(real *, real *);
typedef logical (*L_fps3)(real *, real *, real *);
typedef logical (*L_fpd2)(doublereal *, doublereal *);
typedef logical (*L_fpd3)(doublereal *, doublereal *, doublereal *);
typedef logical (*L_fpz1)(doublecomplex *);
typedef logical (*L_fpz2)(doublecomplex *, doublecomplex *);
typedef shortlogical (*K_fp)();
typedef  VOID (*H_fp)();
typedef  int (*S_fp)();
#endif

typedef VOID C_f;	
typedef VOID H_f;	
typedef VOID Z_f;	
typedef doublereal E_f;	



#ifndef Skip_f2c_Undefs
#undef cray
#undef gcos
#undef mc68010
#undef mc68020
#undef mips
#undef pdp11
#undef sgi
#undef sparc
#undef sun
#undef sun2
#undef sun3
#undef sun4
#undef u370
#undef u3b
#undef u3b2
#undef u3b5
#undef unix
#undef vax
#endif
#endif

#ifndef FLA_ENABLE_EXTRA_SYMBOLS
#if (defined(_WIN32) || defined(_WIN64))
#ifdef UPPER
#define  cgelst_   CGELST
#define  clatrs3_  CLATRS3
#define  ctrsyl3_  CTRSYL3
#define  dlarmm_   DLARMM
#define  dgelst_   DGELST
#define  dlatrs3_  DLATRS3
#define  dtrsyl3_  DTRSYL3
#define  slarmm_   SLARMM
#define  sgelst_   SGELST
#define  slatrs3_  SLATRS3
#define  strsyl3_  STRSYL3
#define  zgelst_   ZGELST
#define  zlatrs3_  ZLATRS3
#define  ztrsyl3_  ZTRSYL3
#define  cgetsqrhrt_  CGETSQRHRT
#define  claqz0_  CLAQZ0
#define  claqz1_  CLAQZ1
#define  claqz2_  CLAQZ2
#define  claqz3_  CLAQZ3
#define  clarfb_gett_  CLARFB_GETT
#define  cungtsqr_row_  CUNGTSQR_ROW
#define  dgetsqrhrt_  DGETSQRHRT
#define  dlaqz0_  DLAQZ0
#define  dlaqz1_  DLAQZ1
#define  dlaqz2_  DLAQZ2
#define  dlaqz3_  DLAQZ3
#define  dlaqz4_  DLAQZ4
#define  dlarfb_gett_  DLARFB_GETT
#define  dorgtsqr_row_  DORGTSQR_ROW
#define  sgetsqrhrt_  SGETSQRHRT
#define  slaqz0_  SLAQZ0
#define  slaqz1_  SLAQZ1
#define  slaqz2_  SLAQZ2
#define  slaqz3_  SLAQZ3
#define  slaqz4_  SLAQZ4
#define  slarfb_gett_  SLARFB_GETT
#define  sorgtsqr_row_  SORGTSQR_ROW
#define  zgetsqrhrt_  ZGETSQRHRT
#define  zlaqz0_  ZLAQZ0
#define  zlaqz1_  ZLAQZ1
#define  zlaqz2_  ZLAQZ2
#define  zlaqz3_  ZLAQZ3
#define  zlarfb_gett_  ZLARFB_GETT
#define	 zungtsqr_row_  ZUNGTSQR_ROW

#define  isamax_   ISAMAX     
#define  idamax_   IDAMAX     
#define  icamax_   ICAMAX     
#define  izamax_   IZAMAX     
#define  sasum_	   SASUM      
#define  dasum_	   DASUM      
#define  scasum_   SCASUM     
#define  dzasum_   DZASUM     
#define  saxpy_	   SAXPY      
#define  daxpy_	   DAXPY      
#define  caxpy_	   CAXPY      
#define  zaxpy_	   ZAXPY      
#define  scopy_	   SCOPY      
#define  dcopy_	   DCOPY      
#define  ccopy_	   CCOPY      
#define  zcopy_	   ZCOPY      
#define  sdot_	   SDOT       
#define  ddot_	   DDOT       
#define  cdotu_	   CDOTU      
#define  cdotc_	   CDOTC      
#define  zdotu_	   ZDOTU      
#define  zdotc_	   ZDOTC      
#define  snrm2_	   SNRM2      
#define  dnrm2_	   DNRM2      
#define  scnrm2_   SCNRM2     
#define  dznrm2_   DZNRM2     
#define  sscal_	   SSCAL      
#define  dscal_	   DSCAL      
#define  cscal_	   CSCAL      
#define  csscal_   CSSCAL     
#define  zscal_	   ZSCAL      
#define  zdscal_   ZDSCAL     
#define  sswap_	   SSWAP      
#define  dswap_	   DSWAP      
#define  cswap_	   CSWAP      
#define  zswap_	   ZSWAP      
#define  sgemv_	   SGEMV      
#define  dgemv_	   DGEMV      
#define  cgemv_	   CGEMV      
#define  zgemv_	   ZGEMV      
#define  sger_	   SGER       
#define  dger_	   DGER       
#define  cgerc_	   CGERC      
#define  cgeru_	   CGERU      
#define  zgerc_	   ZGERC      
#define  zgeru_	   ZGERU      
#define  chemv_	   CHEMV      
#define  zhemv_	   ZHEMV      
#define  cher_	   CHER       
#define  zher_	   ZHER       
#define  cher2_	   CHER2      
#define  zher2_	   ZHER2      
#define  ssymv_	   SSYMV      
#define  dsymv_	   DSYMV      
#define  ssyr_	   SSYR       
#define  dsyr_	   DSYR       
#define  ssyr2_	   SSYR2      
#define  dsyr2_	   DSYR2      
#define  strmv_	   STRMV      
#define  dtrmv_	   DTRMV      
#define  ctrmv_	   CTRMV      
#define  ztrmv_	   ZTRMV      
#define  strsv_	   STRSV      
#define  dtrsv_	   DTRSV      
#define  ctrsv_	   CTRSV      
#define  ztrsv_	   ZTRSV      
#define  sgemm_	   SGEMM      
#define  dgemm_	   DGEMM      
#define  cgemm_	   CGEMM      
#define  zgemm_	   ZGEMM      
#define  chemm_	   CHEMM      
#define  zhemm_	   ZHEMM      
#define  cherk_	   CHERK      
#define  zherk_	   ZHERK      
#define  cher2k_   CHER2K     
#define  zher2k_   ZHER2K     
#define  ssymm_	   SSYMM      
#define  dsymm_	   DSYMM      
#define  csymm_	   CSYMM      
#define  zsymm_	   ZSYMM      
#define  ssyrk_	   SSYRK      
#define  dsyrk_	   DSYRK      
#define  csyrk_	   CSYRK      
#define  zsyrk_	   ZSYRK      
#define  ssyr2k_   SSYR2K     
#define  dsyr2k_   DSYR2K     
#define  csyr2k_   CSYR2K     
#define  zsyr2k_   ZSYR2K     
#define  strmm_	   STRMM      
#define  dtrmm_	   DTRMM      
#define  ctrmm_	   CTRMM      
#define  ztrmm_	   ZTRMM      
#define  strsm_	   STRSM      
#define  dtrsm_	   DTRSM      
#define  ctrsm_	   CTRSM      
#define  ztrsm_	   ZTRSM
#define  dgemmt_   DGEMMT     

#define csrot_ CSROT
#define cgbmv_ CGBMV
#define ctbsv_ CTBSV
#define dsbmv_ DSBMV
#define dspmv_ DSPMV
#define ctpsv_ CTPSV
#define chpmv_ CHPMV
#define ctpmv_ CTPMV
#define chpr2_ CHPR2
#define chpr_  CHPR
#define chbmv_ CHBMV
#define ctbmv_ CTBMV
#define drot_  DROT
#define dgbmv_ DGBMV
#define dtbsv_ DTBSV
#define drotm_ DROTM
#define dtpsv_ DTPSV
#define dspr_  DSPR
#define dtpmv_ DTPMV
#define dspr2_ DSPR2
#define dtbmv_ DTBMV
#define srot_  SROT
#define sgbmv_ SGBMV
#define stbsv_ STBSV
#define srotm_ SROTM
#define stpsv_  STPSV
#define ssbmv_	SSBMV
#define sspmv_	SSPMV
#define sspr_	SSPR
#define stpmv_	STPMV
#define sspr2_	SSPR2
#define stbmv_	STBMV
#define zdrot_	ZDROT
#define zgbmv_	ZGBMV
#define ztbsv_	ZTBSV
#define ztpsv_	ZTPSV
#define zhpmv_	ZHPMV
#define ztpmv_	ZTPMV
#define zhpr2_	ZHPR2
#define zhpr_	ZHPR
#define zhbmv_	ZHBMV
#define ztbmv_	ZTBMV

#define cbbcsd_                  CBBCSD              
#define cbdsqr_                  CBDSQR 
#define cgbbrd_                  CGBBRD 
#define cgbcon_                  CGBCON  
#define cgbequ_                  CGBEQU 
#define cgbequb_                 CGBEQUB 
#define cgbrfs_                  CGBRFS 
#define cgbsv_                   CGBSV 
#define cgbsvx_                  CGBSVX 
#define cgbtf2_                  CGBTF2 
#define cgbtrf_                  CGBTRF 
#define cgbtrs_                  CGBTRS 
#define cgebak_                  CGEBAK 
#define cgebal_                  CGEBAL 
#define cgebd2_                  CGEBD2 
#define cgebrd_                  CGEBRD 
#define cgecon_                  CGECON 
#define cgeequ_                  CGEEQU 
#define cgeequb_                 CGEEQUB 
#define cgees_                   CGEES 
#define cgeesx_                  CGEESX 
#define cgeev_                   CGEEV 
#define cgeevx_                  CGEEVX 
#define cgegs_                   CGEGS 
#define cgegv_                   CGEGV 
#define cgehd2_                  CGEHD2 
#define cgehrd_                  CGEHRD 
#define cgejsv_                  CGEJSV 
#define cgelq2_                  CGELQ2 
#define cgelq_                   CGELQ 
#define cgelqf_                  CGELQF 
#define cgelqt3_                 CGELQT3 
#define cgelqt_                  CGELQT 
#define cgels_                   CGELS 
#define cgelsd_                  CGELSD 
#define cgelss_                  CGELSS 
#define cgelsx_                  CGELSX 
#define cgelsy_                  CGELSY 
#define cgemlq_                  CGEMLQ 
#define cgemlqt_                 CGEMLQT 
#define cgemqr_                  CGEMQR 
#define cgemqrt_                 CGEMQRT 
#define cgeql2_                  CGEQL2 
#define cgeqlf_                  CGEQLF 
#define cgeqp3_                  CGEQP3 
#define cgeqpf_                  CGEQPF 
#define cgeqr2_                  CGEQR2 
#define cgeqr2p_                 CGEQR2P 
#define cgeqr_                   CGEQR 
#define cgeqrf_                  CGEQRF 
#define cgeqrfp_                 CGEQRFP 
#define cgeqrt2_                 CGEQRT2 
#define cgeqrt3_                 CGEQRT3 
#define cgeqrt_                  CGEQRT 
#define cgerfs_                  CGERFS 
#define cgerq2_                  CGERQ2 
#define cgerqf_                  CGERQF 
#define cgesc2_                  CGESC2 
#define cgesdd_                  CGESDD 
#define cgesv_                   CGESV 
#define cgesvd_                  CGESVD 
#define cgesvdq_                 CGESVDQ 
#define cgesvdx_                 CGESVDX 
#define cgesvj_                  CGESVJ 
#define cgesvx_                  CGESVX 
#define cgetc2_                  CGETC2 
#define cgetf2_                  CGETF2 
#define cgetrf2_                 CGETRF2 
#define cgetrf_                  CGETRF 
#define cgetri_                  CGETRI 
#define cgetrs_                  CGETRS 
#define cgetsls_                 CGETSLS 
#define cggbak_                  CGGBAK 
#define cggbal_                  CGGBAL 
#define cgges3_                  CGGES3 
#define cgges_                   CGGES 
#define cggesx_                  CGGESX 
#define cggev3_                  CGGEV3 
#define cggev_                   CGGEV 
#define cggevx_                  CGGEVX 
#define cggglm_                  CGGGLM 
#define cgghd3_                  CGGHD3 
#define cgghrd_                  CGGHRD 
#define cgglse_                  CGGLSE 
#define cggqrf_                  CGGQRF 
#define cggrqf_                  CGGRQF 
#define cggsvd3_                 CGGSVD3 
#define cggsvd_                  CGGSVD 
#define cggsvp3_                 CGGSVP3 
#define cggsvp_                  CGGSVP 
#define cgsvj0_                  CGSVJ0 
#define cgsvj1_                  CGSVJ1 
#define cgtcon_                  CGTCON 
#define cgtrfs_                  CGTRFS 
#define cgtsv_                   CGTSV 
#define cgtsvx_                  CGTSVX 
#define cgttrf_                  CGTTRF 
#define cgttrs_                  CGTTRS 
#define cgtts2_                  CGTTS2 
#define chb2st_kernels_          CHB2ST_KERNELS 
#define chbev_                   CHBEV 
#define chbev_2stage_            CHBEV_2STAGE 
#define chbevd_                  CHBEVD 
#define chbevd_2stage_           CHBEVD_2STAGE 
#define chbevx_                  CHBEVX 
#define chbevx_2stage_           CHBEVX_2STAGE 
#define chbgst_                  CHBGST 
#define chbgv_                   CHBGV 
#define chbgvd_                  CHBGVD 
#define chbgvx_                  CHBGVX 
#define chbtrd_                  CHBTRD 
#define checon_                  CHECON 
#define checon_3_                CHECON_3 
#define checon_rook_             CHECON_ROOK 
#define cheequb_                 CHEEQUB 
#define cheev_                   CHEEV 
#define cheev_2stage_            CHEEV_2STAGE 
#define cheevd_                  CHEEVD 
#define cheevd_2stage_           CHEEVD_2STAGE 
#define cheevr_                  CHEEVR 
#define cheevr_2stage_           CHEEVR_2STAGE 
#define cheevx_                  CHEEVX 
#define cheevx_2stage_           CHEEVX_2STAGE 
#define chegs2_                  CHEGS2 
#define chegst_                  CHEGST 
#define chegv_                   CHEGV 
#define chegv_2stage_            CHEGV_2STAGE 
#define chegvd_                  CHEGVD 
#define chegvx_                  CHEGVX 
#define cherfs_                  CHERFS 
#define chesv_                   CHESV 
#define chesv_aa_                CHESV_AA 
#define chesv_aa_2stage_         CHESV_AA_2STAGE 
#define chesv_rk_                CHESV_RK 
#define chesv_rook_              CHESV_ROOK 
#define chesvx_                  CHESVX 
#define cheswapr_                CHESWAPR 
#define chetd2_                  CHETD2 
#define chetf2_                  CHETF2 
#define chetf2_rk_               CHETF2_RK 
#define chetf2_rook_             CHETF2_ROOK 
#define chetrd_                  CHETRD 
#define chetrd_2stage_           CHETRD_2STAGE 
#define chetrd_hb2st_            CHETRD_HB2ST 
#define chetrd_he2hb_            CHETRD_HE2HB 
#define chetrf_                  CHETRF 
#define chetrf_aa_               CHETRF_AA 
#define chetrf_aa_2stage_        CHETRF_AA_2STAGE 
#define chetrf_rk_               CHETRF_RK 
#define chetrf_rook_             CHETRF_ROOK 
#define chetri2_                 CHETRI2 
#define chetri2x_                CHETRI2X 
#define chetri_                  CHETRI 
#define chetri_3_                CHETRI_3 
#define chetri_3x_               CHETRI_3X 
#define chetri_rook_             CHETRI_ROOK 
#define chetrs2_                 CHETRS2 
#define chetrs_                  CHETRS 
#define chetrs_3_                CHETRS_3 
#define chetrs_aa_               CHETRS_AA 
#define chetrs_aa_2stage_        CHETRS_AA_2STAGE 
#define chetrs_rook_             CHETRS_ROOK 
#define chfrk_                   CHFRK 
#define chgeqz_                  CHGEQZ 
#define chla_transtype_          CHLA_TRANSTYPE 
#define chpcon_                  CHPCON 
#define chpev_                   CHPEV 
#define chpevd_                  CHPEVD 
#define chpevx_                  CHPEVX 
#define chpgst_                  CHPGST 
#define chpgv_                   CHPGV 
#define chpgvd_                  CHPGVD 
#define chpgvx_                  CHPGVX 
#define chprfs_                  CHPRFS 
#define chpsv_                   CHPSV 
#define chpsvx_                  CHPSVX 
#define chptrd_                  CHPTRD 
#define chptrf_                  CHPTRF 
#define chptri_                  CHPTRI 
#define chptrs_                  CHPTRS 
#define chsein_                  CHSEIN 
#define chseqr_                  CHSEQR 
#define cla_gbamv_               CLA_GBAMV 
#define cla_gbrcond_c_           CLA_GBRCOND_C 
#define cla_gbrcond_x_           CLA_GBRCOND_X 
#define cla_gbrpvgrw_            CLA_GBRPVGRW 
#define cla_geamv_               CLA_GEAMV 
#define cla_gercond_c_           CLA_GERCOND_C 
#define cla_gercond_x_           CLA_GERCOND_X 
#define cla_gerpvgrw_            CLA_GERPVGRW 
#define cla_heamv_               CLA_HEAMV 
#define cla_hercond_c_           CLA_HERCOND_C 
#define cla_hercond_x_           CLA_HERCOND_X 
#define cla_herpvgrw_            CLA_HERPVGRW 
#define cla_lin_berr_            CLA_LIN_BERR 
#define cla_porcond_c_           CLA_PORCOND_C 
#define cla_porcond_x_           CLA_PORCOND_X 
#define cla_porpvgrw_            CLA_PORPVGRW 
#define cla_syamv_               CLA_SYAMV 
#define cla_syrcond_c_           CLA_SYRCOND_C 
#define cla_syrcond_x_           CLA_SYRCOND_X 
#define cla_syrpvgrw_            CLA_SYRPVGRW 
#define cla_wwaddw_              CLA_WWADDW 
#define clabrd_                  CLABRD 
#define clacgv_                  CLACGV 
#define clacn2_                  CLACN2 
#define clacon_                  CLACON 
#define clacp2_                  CLACP2 
#define clacpy_                  CLACPY 
#define clacrm_                  CLACRM 
#define clacrt_                  CLACRT 
#define cladiv_                  CLADIV 
#define claed0_                  CLAED0 
#define claed7_                  CLAED7 
#define claed8_                  CLAED8 
#define claein_                  CLAEIN 
#define claesy_                  CLAESY 
#define claev2_                  CLAEV2 
#define clag2z_                  CLAG2Z 
#define clags2_                  CLAGS2 
#define clagtm_                  CLAGTM 
#define clahef_                  CLAHEF 
#define clahef_aa_               CLAHEF_AA 
#define clahef_rk_               CLAHEF_RK 
#define clahef_rook_             CLAHEF_ROOK 
#define clahqr_                  CLAHQR 
#define clahr2_                  CLAHR2 
#define clahrd_                  CLAHRD 
#define claic1_                  CLAIC1 
#define clals0_                  CLALS0 
#define clalsa_                  CLALSA 
#define clalsd_                  CLALSD 
#define clamswlq_                CLAMSWLQ 
#define clamtsqr_                CLAMTSQR 
#define clangb_                  CLANGB 
#define clange_                  CLANGE 
#define clangt_                  CLANGT 
#define clanhb_                  CLANHB 
#define clanhe_                  CLANHE 
#define clanhf_                  CLANHF 
#define clanhp_                  CLANHP 
#define clanhs_                  CLANHS 
#define clanht_                  CLANHT 
#define clansb_                  CLANSB 
#define clansp_                  CLANSP 
#define clansy_                  CLANSY 
#define clantb_                  CLANTB 
#define clantp_                  CLANTP 
#define clantr_                  CLANTR 
#define clapll_                  CLAPLL 
#define clapmr_                  CLAPMR 
#define clapmt_                  CLAPMT 
#define claqgb_                  CLAQGB 
#define claqge_                  CLAQGE 
#define claqhb_                  CLAQHB 
#define claqhe_                  CLAQHE 
#define claqhp_                  CLAQHP 
#define claqp2_                  CLAQP2 
#define claqps_                  CLAQPS 
#define claqr0_                  CLAQR0 
#define claqr1_                  CLAQR1 
#define claqr2_                  CLAQR2 
#define claqr3_                  CLAQR3 
#define claqr4_                  CLAQR4 
#define claqr5_                  CLAQR5 
#define claqsb_                  CLAQSB 
#define claqsp_                  CLAQSP 
#define claqsy_                  CLAQSY 
#define clar1v_                  CLAR1V 
#define clar2v_                  CLAR2V 
#define clarcm_                  CLARCM 
#define clarf_                   CLARF 
#define clarfb_                  CLARFB 
#define clarfg_                  CLARFG 
#define clarfgp_                 CLARFGP 
#define clarft_                  CLARFT 
#define clarfx_                  CLARFX 
#define clarfy_                  CLARFY 
#define clargv_                  CLARGV 
#define clarnv_                  CLARNV 
#define clarrv_                  CLARRV 
#define clarscl2_                CLARSCL2 
#define clartg_                  CLARTG 
#define clartv_                  CLARTV 
#define clarz_                   CLARZ 
#define clarzb_                  CLARZB 
#define clarzt_                  CLARZT 
#define clascl2_                 CLASCL2 
#define clascl_                  CLASCL 
#define claset_                  CLASET 
#define clasr_                   CLASR 
#define classq_                  CLASSQ 
#define claswlq_                 CLASWLQ 
#define claswp_                  CLASWP 
#define clasyf_                  CLASYF 
#define clasyf_aa_               CLASYF_AA 
#define clasyf_rk_               CLASYF_RK 
#define clasyf_rook_             CLASYF_ROOK 
#define clatbs_                  CLATBS 
#define clatdf_                  CLATDF 
#define clatps_                  CLATPS 
#define clatrd_                  CLATRD 
#define clatrs_                  CLATRS 
#define clatrz_                  CLATRZ 
#define clatsqr_                 CLATSQR 
#define clatzm_                  CLATZM 
#define claunhr_col_getrfnp2_    CLAUNHR_COL_GETRFNP2 
#define claunhr_col_getrfnp_     CLAUNHR_COL_GETRFNP 
#define clauu2_                  CLAUU2 
#define clauum_                  CLAUUM 
#define cpbcon_                  CPBCON 
#define cpbequ_                  CPBEQU 
#define cpbrfs_                  CPBRFS 
#define cpbstf_                  CPBSTF 
#define cpbsv_                   CPBSV 
#define cpbsvx_                  CPBSVX 
#define cpbtf2_                  CPBTF2 
#define cpbtrf_                  CPBTRF 
#define cpbtrs_                  CPBTRS 
#define cpftrf_                  CPFTRF 
#define cpftri_                  CPFTRI 
#define cpftrs_                  CPFTRS 
#define cpocon_                  CPOCON 
#define cpoequ_                  CPOEQU 
#define cpoequb_                 CPOEQUB 
#define cporfs_                  CPORFS 
#define cposv_                   CPOSV 
#define cposvx_                  CPOSVX 
#define cpotf2_                  CPOTF2 
#define cpotrf2_                 CPOTRF2 
#define cpotrf_                  CPOTRF 
#define cpotri_                  CPOTRI 
#define cpotrs_                  CPOTRS 
#define cppcon_                  CPPCON 
#define cppequ_                  CPPEQU 
#define cpprfs_                  CPPRFS 
#define cppsv_                   CPPSV 
#define cppsvx_                  CPPSVX 
#define cpptrf_                  CPPTRF 
#define cpptri_                  CPPTRI 
#define cpptrs_                  CPPTRS 
#define cpstf2_                  CPSTF2 
#define cpstrf_                  CPSTRF 
#define cptcon_                  CPTCON 
#define cpteqr_                  CPTEQR 
#define cptrfs_                  CPTRFS 
#define cptsv_                   CPTSV 
#define cptsvx_                  CPTSVX 
#define cpttrf_                  CPTTRF 
#define cpttrs_                  CPTTRS 
#define cptts2_                  CPTTS2 
#define crot_                    CROT 
#define cspcon_                  CSPCON 
#define cspmv_                   CSPMV 
#define cspr_                    CSPR 
#define csprfs_                  CSPRFS 
#define cspsv_                   CSPSV 
#define cspsvx_                  CSPSVX 
#define csptrf_                  CSPTRF 
#define csptri_                  CSPTRI 
#define csptrs_                  CSPTRS 
#define csrscl_                  CSRSCL 
#define cstedc_                  CSTEDC 
#define cstegr_                  CSTEGR 
#define cstein_                  CSTEIN 
#define cstemr_                  CSTEMR 
#define csteqr_                  CSTEQR 
#define csycon_                  CSYCON 
#define csycon_3_                CSYCON_3 
#define csycon_rook_             CSYCON_ROOK 
#define csyconv_                 CSYCONV 
#define csyconvf_                CSYCONVF 
#define csyconvf_rook_           CSYCONVF_ROOK 
#define csyequb_                 CSYEQUB 
#define csymv_                   CSYMV 
#define csyr_                    CSYR 
#define csyrfs_                  CSYRFS 
#define csysv_                   CSYSV 
#define csysv_aa_                CSYSV_AA 
#define csysv_aa_2stage_         CSYSV_AA_2STAGE 
#define csysv_rk_                CSYSV_RK 
#define csysv_rook_              CSYSV_ROOK 
#define csysvx_                  CSYSVX 
#define csyswapr_                CSYSWAPR 
#define csytf2_                  CSYTF2 
#define csytf2_rk_               CSYTF2_RK 
#define csytf2_rook_             CSYTF2_ROOK 
#define csytrf_                  CSYTRF 
#define csytrf_aa_               CSYTRF_AA 
#define csytrf_aa_2stage_        CSYTRF_AA_2STAGE 
#define csytrf_rk_               CSYTRF_RK 
#define csytrf_rook_             CSYTRF_ROOK 
#define csytri2_                 CSYTRI2 
#define csytri2x_                CSYTRI2X 
#define csytri_                  CSYTRI 
#define csytri_3_                CSYTRI_3 
#define csytri_3x_               CSYTRI_3X 
#define csytri_rook_             CSYTRI_ROOK 
#define csytrs2_                 CSYTRS2 
#define csytrs_                  CSYTRS 
#define csytrs_3_                CSYTRS_3 
#define csytrs_aa_               CSYTRS_AA 
#define csytrs_aa_2stage_        CSYTRS_AA_2STAGE 
#define csytrs_rook_             CSYTRS_ROOK 
#define ctbcon_                  CTBCON 
#define ctbrfs_                  CTBRFS 
#define ctbtrs_                  CTBTRS 
#define ctfsm_                   CTFSM 
#define ctftri_                  CTFTRI 
#define ctfttp_                  CTFTTP 
#define ctfttr_                  CTFTTR 
#define ctgevc_                  CTGEVC 
#define ctgex2_                  CTGEX2 
#define ctgexc_                  CTGEXC 
#define ctgsen_                  CTGSEN 
#define ctgsja_                  CTGSJA 
#define ctgsna_                  CTGSNA 
#define ctgsy2_                  CTGSY2 
#define ctgsyl_                  CTGSYL 
#define ctpcon_                  CTPCON 
#define ctplqt2_                 CTPLQT2 
#define ctplqt_                  CTPLQT 
#define ctpmlqt_                 CTPMLQT 
#define ctpmqrt_                 CTPMQRT 
#define ctpqrt2_                 CTPQRT2 
#define ctpqrt_                  CTPQRT 
#define ctprfb_                  CTPRFB 
#define ctprfs_                  CTPRFS 
#define ctptri_                  CTPTRI 
#define ctptrs_                  CTPTRS 
#define ctpttf_                  CTPTTF 
#define ctpttr_                  CTPTTR 
#define ctrcon_                  CTRCON 
#define ctrevc3_                 CTREVC3 
#define ctrevc_                  CTREVC 
#define ctrexc_                  CTREXC 
#define ctrrfs_                  CTRRFS 
#define ctrsen_                  CTRSEN 
#define ctrsna_                  CTRSNA 
#define ctrsyl_                  CTRSYL 
#define ctrti2_                  CTRTI2 
#define ctrtri_                  CTRTRI 
#define ctrtrs_                  CTRTRS 
#define ctrttf_                  CTRTTF 
#define ctrttp_                  CTRTTP 
#define ctzrqf_                  CTZRQF 
#define ctzrzf_                  CTZRZF 
#define cunbdb1_                 CUNBDB1 
#define cunbdb2_                 CUNBDB2 
#define cunbdb3_                 CUNBDB3 
#define cunbdb4_                 CUNBDB4 
#define cunbdb5_                 CUNBDB5 
#define cunbdb6_                 CUNBDB6 
#define cunbdb_                  CUNBDB 
#define cuncsd2by1_              CUNCSD2BY1 
#define cuncsd_                  CUNCSD 
#define cung2l_                  CUNG2L 
#define cung2r_                  CUNG2R 
#define cungbr_                  CUNGBR 
#define cunghr_                  CUNGHR 
#define cungl2_                  CUNGL2 
#define cunglq_                  CUNGLQ 
#define cungql_                  CUNGQL 
#define cungqr_                  CUNGQR 
#define cungr2_                  CUNGR2 
#define cungrq_                  CUNGRQ 
#define cungtr_                  CUNGTR 
#define cungtsqr_                CUNGTSQR 
#define cunhr_col_               CUNHR_COL 
#define cunm22_                  CUNM22 
#define cunm2l_                  CUNM2L 
#define cunm2r_                  CUNM2R 
#define cunmbr_                  CUNMBR 
#define cunmhr_                  CUNMHR 
#define cunml2_                  CUNML2 
#define cunmlq_                  CUNMLQ 
#define cunmql_                  CUNMQL 
#define cunmqr_                  CUNMQR 
#define cunmr2_                  CUNMR2 
#define cunmr3_                  CUNMR3 
#define cunmrq_                  CUNMRQ 
#define cunmrz_                  CUNMRZ 
#define cunmtr_                  CUNMTR 
#define cupgtr_                  CUPGTR 
#define cupmtr_                  CUPMTR 
#define dbbcsd_                  DBBCSD 
#define dbdsdc_                  DBDSDC 
#define dbdsqr_                  DBDSQR 
#define dbdsvdx_                 DBDSVDX 
#define dcombssq_                DCOMBSSQ 
#define ddisna_                  DDISNA 
#define dgbbrd_                  DGBBRD 
#define dgbcon_                  DGBCON 
#define dgbequ_                  DGBEQU 
#define dgbequb_                 DGBEQUB 
#define dgbrfs_                  DGBRFS 
#define dgbsv_                   DGBSV 
#define dgbsvx_                  DGBSVX 
#define dgbtf2_                  DGBTF2 
#define dgbtrf_                  DGBTRF 
#define dgbtrs_                  DGBTRS 
#define dgebak_                  DGEBAK 
#define dgebal_                  DGEBAL 
#define dgebd2_                  DGEBD2 
#define dgebrd_                  DGEBRD 
#define dgecon_                  DGECON 
#define dgeequ_                  DGEEQU 
#define dgeequb_                 DGEEQUB 
#define dgees_                   DGEES 
#define dgeesx_                  DGEESX 
#define dgeev_                   DGEEV 
#define dgeevx_                  DGEEVX 
#define dgegs_                   DGEGS 
#define dgegv_                   DGEGV 
#define dgehd2_                  DGEHD2 
#define dgehrd_                  DGEHRD 
#define dgejsv_                  DGEJSV 
#define dgelq2_                  DGELQ2 
#define dgelq_                   DGELQ 
#define dgelqf_                  DGELQF 
#define dgelqt3_                 DGELQT3 
#define dgelqt_                  DGELQT 
#define dgels_                   DGELS 
#define dgelsd_                  DGELSD 
#define dgelss_                  DGELSS 
#define dgelsx_                  DGELSX 
#define dgelsy_                  DGELSY 
#define dgemlq_                  DGEMLQ 
#define dgemlqt_                 DGEMLQT 
#define dgemqr_                  DGEMQR 
#define dgemqrt_                 DGEMQRT 
#define dgeql2_                  DGEQL2 
#define dgeqlf_                  DGEQLF 
#define dgeqp3_                  DGEQP3 
#define dgeqpf_                  DGEQPF 
#define dgeqr2_                  DGEQR2 
#define dgeqr2p_                 DGEQR2P 
#define dgeqr_                   DGEQR 
#define dgeqrf_                  DGEQRF 
#define dgeqrfp_                 DGEQRFP 
#define dgeqrt2_                 DGEQRT2 
#define dgeqrt3_                 DGEQRT3 
#define dgeqrt_                  DGEQRT 
#define dgerfs_                  DGERFS 
#define dgerq2_                  DGERQ2 
#define dgerqf_                  DGERQF 
#define dgesc2_                  DGESC2 
#define dgesdd_                  DGESDD 
#define dgesv_                   DGESV 
#define dgesvd_                  DGESVD 
#define dgesvdq_                 DGESVDQ 
#define dgesvdx_                 DGESVDX 
#define dgesvj_                  DGESVJ 
#define dgesvx_                  DGESVX 
#define dgetc2_                  DGETC2 
#define dgetf2_                  DGETF2 
#define dgetrf2_                 DGETRF2 
#define dgetrf_                  DGETRF 
#define dgetri_                  DGETRI 
#define dgetrs_                  DGETRS 
#define dgetsls_                 DGETSLS 
#define dggbak_                  DGGBAK 
#define dggbal_                  DGGBAL 
#define dgges3_                  DGGES3 
#define dgges_                   DGGES 
#define dggesx_                  DGGESX 
#define dggev3_                  DGGEV3 
#define dggev_                   DGGEV 
#define dggevx_                  DGGEVX 
#define dggglm_                  DGGGLM 
#define dgghd3_                  DGGHD3 
#define dgghrd_                  DGGHRD 
#define dgglse_                  DGGLSE 
#define dggqrf_                  DGGQRF 
#define dggrqf_                  DGGRQF 
#define dggsvd3_                 DGGSVD3 
#define dggsvd_                  DGGSVD 
#define dggsvp3_                 DGGSVP3 
#define dggsvp_                  DGGSVP 
#define dgsvj0_                  DGSVJ0 
#define dgsvj1_                  DGSVJ1 
#define dgtcon_                  DGTCON 
#define dgtrfs_                  DGTRFS 
#define dgtsv_                   DGTSV 
#define dgtsvx_                  DGTSVX 
#define dgttrf_                  DGTTRF 
#define dgttrs_                  DGTTRS 
#define dgtts2_                  DGTTS2 
#define dhgeqz_                  DHGEQZ 
#define dhsein_                  DHSEIN 
#define dhseqr_                  DHSEQR 
#define disnan_                  DISNAN 
#define dla_gbamv_               DLA_GBAMV 
#define dla_gbrcond_             DLA_GBRCOND 
#define dla_gbrpvgrw_            DLA_GBRPVGRW 
#define dla_geamv_               DLA_GEAMV 
#define dla_gercond_             DLA_GERCOND 
#define dla_gerpvgrw_            DLA_GERPVGRW 
#define dla_lin_berr_            DLA_LIN_BERR 
#define dla_porcond_             DLA_PORCOND 
#define dla_porpvgrw_            DLA_PORPVGRW 
#define dla_syamv_               DLA_SYAMV 
#define dla_syrcond_             DLA_SYRCOND 
#define dla_syrpvgrw_            DLA_SYRPVGRW 
#define dla_wwaddw_              DLA_WWADDW 
#define dlabad_                  DLABAD 
#define dlabrd_                  DLABRD 
#define dlacn2_                  DLACN2 
#define dlacon_                  DLACON 
#define dlacpy_                  DLACPY 
#define dladiv1_                 DLADIV1 
#define dladiv2_                 DLADIV2 
#define dladiv_                  DLADIV 
#define dlae2_                   DLAE2 
#define dlaebz_                  DLAEBZ 
#define dlaed0_                  DLAED0 
#define dlaed1_                  DLAED1 
#define dlaed2_                  DLAED2 
#define dlaed3_                  DLAED3 
#define dlaed4_                  DLAED4 
#define dlaed5_                  DLAED5 
#define dlaed6_                  DLAED6 
#define dlaed7_                  DLAED7 
#define dlaed8_                  DLAED8 
#define dlaed9_                  DLAED9 
#define dlaeda_                  DLAEDA 
#define dlaein_                  DLAEIN 
#define dlaev2_                  DLAEV2 
#define dlaexc_                  DLAEXC 
#define dlag2_                   DLAG2 
#define dlag2s_                  DLAG2S 
#define dlags2_                  DLAGS2 
#define dlagtf_                  DLAGTF 
#define dlagtm_                  DLAGTM 
#define dlagts_                  DLAGTS 
#define dlagv2_                  DLAGV2 
#define dlahqr_                  DLAHQR 
#define dlahr2_                  DLAHR2 
#define dlahrd_                  DLAHRD 
#define dlaic1_                  DLAIC1 
#define dlaisnan_                DLAISNAN 
#define dlaln2_                  DLALN2 
#define dlals0_                  DLALS0 
#define dlalsa_                  DLALSA 
#define dlalsd_                  DLALSD 
#define dlamc3_                  DLAMC3 
#define dlamch_                  DLAMCH 
#define dlamrg_                  DLAMRG 
#define dlamswlq_                DLAMSWLQ 
#define dlamtsqr_                DLAMTSQR 
#define dlaneg_                  DLANEG 
#define dlangb_                  DLANGB 
#define dlange_                  DLANGE 
#define dlangt_                  DLANGT 
#define dlanhs_                  DLANHS 
#define dlansb_                  DLANSB 
#define dlansf_                  DLANSF 
#define dlansp_                  DLANSP 
#define dlanst_                  DLANST 
#define dlansy_                  DLANSY 
#define dlantb_                  DLANTB 
#define dlantp_                  DLANTP 
#define dlantr_                  DLANTR 
#define dlanv2_                  DLANV2 
#define dlaorhr_col_getrfnp2_    DLAORHR_COL_GETRFNP2 
#define dlaorhr_col_getrfnp_     DLAORHR_COL_GETRFNP 
#define dlapll_                  DLAPLL 
#define dlapmr_                  DLAPMR 
#define dlapmt_                  DLAPMT 
#define dlapy2_                  DLAPY2 
#define dlapy3_                  DLAPY3 
#define dlaqgb_                  DLAQGB 
#define dlaqge_                  DLAQGE 
#define dlaqp2_                  DLAQP2 
#define dlaqps_                  DLAQPS 
#define dlaqr0_                  DLAQR0 
#define dlaqr1_                  DLAQR1 
#define dlaqr2_                  DLAQR2 
#define dlaqr3_                  DLAQR3 
#define dlaqr4_                  DLAQR4 
#define dlaqr5_                  DLAQR5 
#define dlaqsb_                  DLAQSB 
#define dlaqsp_                  DLAQSP 
#define dlaqsy_                  DLAQSY 
#define dlaqtr_                  DLAQTR 
#define dlar1v_                  DLAR1V 
#define dlar2v_                  DLAR2V 
#define dlarf_                   DLARF 
#define dlarfb_                  DLARFB 
#define dlarfg_                  DLARFG 
#define dlarfgp_                 DLARFGP 
#define dlarft_                  DLARFT 
#define dlarfx_                  DLARFX 
#define dlarfy_                  DLARFY 
#define dlargv_                  DLARGV 
#define dlarnv_                  DLARNV 
#define dlarra_                  DLARRA 
#define dlarrb_                  DLARRB 
#define dlarrc_                  DLARRC 
#define dlarrd_                  DLARRD 
#define dlarre_                  DLARRE 
#define dlarrf_                  DLARRF 
#define dlarrj_                  DLARRJ 
#define dlarrk_                  DLARRK 
#define dlarrr_                  DLARRR 
#define dlarrv_                  DLARRV 
#define dlarscl2_                DLARSCL2 
#define dlartg_                  DLARTG 
#define dlartgp_                 DLARTGP 
#define dlartgs_                 DLARTGS 
#define dlartv_                  DLARTV 
#define dlaruv_                  DLARUV 
#define dlarz_                   DLARZ 
#define dlarzb_                  DLARZB 
#define dlarzt_                  DLARZT 
#define dlas2_                   DLAS2 
#define dlascl2_                 DLASCL2 
#define dlascl_                  DLASCL 
#define dlasd0_                  DLASD0 
#define dlasd1_                  DLASD1 
#define dlasd2_                  DLASD2 
#define dlasd3_                  DLASD3 
#define dlasd4_                  DLASD4 
#define dlasd5_                  DLASD5 
#define dlasd6_                  DLASD6 
#define dlasd7_                  DLASD7 
#define dlasd8_                  DLASD8 
#define dlasda_                  DLASDA 
#define dlasdq_                  DLASDQ 
#define dlasdt_                  DLASDT 
#define dlaset_                  DLASET 
#define dlasq1_                  DLASQ1 
#define dlasq2_                  DLASQ2 
#define dlasq3_                  DLASQ3 
#define dlasq4_                  DLASQ4 
#define dlasq5_                  DLASQ5 
#define dlasq6_                  DLASQ6 
#define dlasr_                   DLASR 
#define dlasrt_                  DLASRT 
#define dlassq_                  DLASSQ 
#define dlasv2_                  DLASV2 
#define dlaswlq_                 DLASWLQ 
#define dlaswp_                  DLASWP 
#define dlasy2_                  DLASY2 
#define dlasyf_                  DLASYF 
#define dlasyf_aa_               DLASYF_AA 
#define dlasyf_rk_               DLASYF_RK 
#define dlasyf_rook_             DLASYF_ROOK 
#define dlat2s_                  DLAT2S 
#define dlatbs_                  DLATBS 
#define dlatdf_                  DLATDF 
#define dlatps_                  DLATPS 
#define dlatrd_                  DLATRD 
#define dlatrs_                  DLATRS 
#define dlatrz_                  DLATRZ 
#define dlatsqr_                 DLATSQR 
#define dlatzm_                  DLATZM 
#define dlauu2_                  DLAUU2 
#define dlauum_                  DLAUUM 
#define dopgtr_                  DOPGTR 
#define dopmtr_                  DOPMTR 
#define dorbdb1_                 DORBDB1 
#define dorbdb2_                 DORBDB2 
#define dorbdb3_                 DORBDB3 
#define dorbdb4_                 DORBDB4 
#define dorbdb5_                 DORBDB5 
#define dorbdb6_                 DORBDB6 
#define dorbdb_                  DORBDB 
#define dorcsd2by1_              DORCSD2BY1 
#define dorcsd_                  DORCSD 
#define dorg2l_                  DORG2L 
#define dorg2r_                  DORG2R 
#define dorgbr_                  DORGBR 
#define dorghr_                  DORGHR 
#define dorgl2_                  DORGL2 
#define dorglq_                  DORGLQ 
#define dorgql_                  DORGQL 
#define dorgqr_                  DORGQR 
#define dorgr2_                  DORGR2 
#define dorgrq_                  DORGRQ 
#define dorgtr_                  DORGTR 
#define dorgtsqr_                DORGTSQR 
#define dorhr_col_               DORHR_COL 
#define dorm22_                  DORM22 
#define dorm2l_                  DORM2L 
#define dorm2r_                  DORM2R 
#define dormbr_                  DORMBR 
#define dormhr_                  DORMHR 
#define dorml2_                  DORML2 
#define dormlq_                  DORMLQ 
#define dormql_                  DORMQL 
#define dormqr_                  DORMQR 
#define dormr2_                  DORMR2 
#define dormr3_                  DORMR3 
#define dormrq_                  DORMRQ 
#define dormrz_                  DORMRZ 
#define dormtr_                  DORMTR 
#define dpbcon_                  DPBCON 
#define dpbequ_                  DPBEQU 
#define dpbrfs_                  DPBRFS 
#define dpbstf_                  DPBSTF 
#define dpbsv_                   DPBSV 
#define dpbsvx_                  DPBSVX 
#define dpbtf2_                  DPBTF2 
#define dpbtrf_                  DPBTRF 
#define dpbtrs_                  DPBTRS 
#define dpftrf_                  DPFTRF 
#define dpftri_                  DPFTRI 
#define dpftrs_                  DPFTRS 
#define dpocon_                  DPOCON 
#define dpoequ_                  DPOEQU 
#define dpoequb_                 DPOEQUB 
#define dporfs_                  DPORFS 
#define dposv_                   DPOSV 
#define dposvx_                  DPOSVX 
#define dpotf2_                  DPOTF2 
#define dpotrf2_                 DPOTRF2 
#define dpotrf_                  DPOTRF 
#define dpotri_                  DPOTRI 
#define dpotrs_                  DPOTRS 
#define dppcon_                  DPPCON 
#define dppequ_                  DPPEQU 
#define dpprfs_                  DPPRFS 
#define dppsv_                   DPPSV 
#define dppsvx_                  DPPSVX 
#define dpptrf_                  DPPTRF 
#define dpptri_                  DPPTRI 
#define dpptrs_                  DPPTRS 
#define dpstf2_                  DPSTF2 
#define dpstrf_                  DPSTRF 
#define dptcon_                  DPTCON 
#define dpteqr_                  DPTEQR 
#define dptrfs_                  DPTRFS 
#define dptsv_                   DPTSV 
#define dptsvx_                  DPTSVX 
#define dpttrf_                  DPTTRF 
#define dpttrs_                  DPTTRS 
#define dptts2_                  DPTTS2 
#define drscl_                   DRSCL 
#define dsb2st_kernels_          DSB2ST_KERNELS 
#define dsbev_                   DSBEV 
#define dsbev_2stage_            DSBEV_2STAGE 
#define dsbevd_                  DSBEVD 
#define dsbevd_2stage_           DSBEVD_2STAGE 
#define dsbevx_                  DSBEVX 
#define dsbevx_2stage_           DSBEVX_2STAGE 
#define dsbgst_                  DSBGST 
#define dsbgv_                   DSBGV 
#define dsbgvd_                  DSBGVD 
#define dsbgvx_                  DSBGVX 
#define dsbtrd_                  DSBTRD 
#define dsfrk_                   DSFRK 
#define dsgesv_                  DSGESV 
#define dspcon_                  DSPCON 
#define dspev_                   DSPEV 
#define dspevd_                  DSPEVD 
#define dspevx_                  DSPEVX 
#define dspgst_                  DSPGST 
#define dspgv_                   DSPGV 
#define dspgvd_                  DSPGVD 
#define dspgvx_                  DSPGVX 
#define dsposv_                  DSPOSV 
#define dsprfs_                  DSPRFS 
#define dspsv_                   DSPSV 
#define dspsvx_                  DSPSVX 
#define dsptrd_                  DSPTRD 
#define dsptrf_                  DSPTRF 
#define dsptri_                  DSPTRI 
#define dsptrs_                  DSPTRS 
#define dstebz_                  DSTEBZ 
#define dstedc_                  DSTEDC 
#define dstegr_                  DSTEGR 
#define dstein_                  DSTEIN 
#define dstemr_                  DSTEMR 
#define dsteqr_                  DSTEQR 
#define dsterf_                  DSTERF 
#define dstev_                   DSTEV 
#define dstevd_                  DSTEVD 
#define dstevr_                  DSTEVR 
#define dstevx_                  DSTEVX 
#define dsycon_                  DSYCON 
#define dsycon_3_                DSYCON_3 
#define dsycon_rook_             DSYCON_ROOK 
#define dsyconv_                 DSYCONV 
#define dsyconvf_                DSYCONVF 
#define dsyconvf_rook_           DSYCONVF_ROOK 
#define dsyequb_                 DSYEQUB 
#define dsyev_                   DSYEV 
#define dsyev_2stage_            DSYEV_2STAGE 
#define dsyevd_                  DSYEVD 
#define dsyevd_2stage_           DSYEVD_2STAGE 
#define dsyevr_                  DSYEVR 
#define dsyevr_2stage_           DSYEVR_2STAGE 
#define dsyevx_                  DSYEVX 
#define dsyevx_2stage_           DSYEVX_2STAGE 
#define dsygs2_                  DSYGS2 
#define dsygst_                  DSYGST 
#define dsygv_                   DSYGV 
#define dsygv_2stage_            DSYGV_2STAGE 
#define dsygvd_                  DSYGVD 
#define dsygvx_                  DSYGVX 
#define dsyrfs_                  DSYRFS 
#define dsysv_                   DSYSV 
#define dsysv_aa_                DSYSV_AA 
#define dsysv_aa_2stage_         DSYSV_AA_2STAGE 
#define dsysv_rk_                DSYSV_RK 
#define dsysv_rook_              DSYSV_ROOK 
#define dsysvx_                  DSYSVX 
#define dsyswapr_                DSYSWAPR 
#define dsytd2_                  DSYTD2 
#define dsytf2_                  DSYTF2 
#define dsytf2_rk_               DSYTF2_RK 
#define dsytf2_rook_             DSYTF2_ROOK 
#define dsytrd_                  DSYTRD 
#define dsytrd_2stage_           DSYTRD_2STAGE 
#define dsytrd_sb2st_            DSYTRD_SB2ST 
#define dsytrd_sy2sb_            DSYTRD_SY2SB 
#define dsytrf_                  DSYTRF 
#define dsytrf_aa_               DSYTRF_AA 
#define dsytrf_aa_2stage_        DSYTRF_AA_2STAGE 
#define dsytrf_rk_               DSYTRF_RK 
#define dsytrf_rook_             DSYTRF_ROOK 
#define dsytri2_                 DSYTRI2 
#define dsytri2x_                DSYTRI2X 
#define dsytri_                  DSYTRI 
#define dsytri_3_                DSYTRI_3 
#define dsytri_3x_               DSYTRI_3X 
#define dsytri_rook_             DSYTRI_ROOK 
#define dsytrs2_                 DSYTRS2 
#define dsytrs_                  DSYTRS 
#define dsytrs_3_                DSYTRS_3 
#define dsytrs_aa_               DSYTRS_AA 
#define dsytrs_aa_2stage_        DSYTRS_AA_2STAGE 
#define dsytrs_rook_             DSYTRS_ROOK 
#define dtbcon_                  DTBCON 
#define dtbrfs_                  DTBRFS 
#define dtbtrs_                  DTBTRS 
#define dtfsm_                   DTFSM 
#define dtftri_                  DTFTRI 
#define dtfttp_                  DTFTTP 
#define dtfttr_                  DTFTTR 
#define dtgevc_                  DTGEVC 
#define dtgex2_                  DTGEX2 
#define dtgexc_                  DTGEXC 
#define dtgsen_                  DTGSEN 
#define dtgsja_                  DTGSJA 
#define dtgsna_                  DTGSNA 
#define dtgsy2_                  DTGSY2 
#define dtgsyl_                  DTGSYL 
#define dtpcon_                  DTPCON 
#define dtplqt2_                 DTPLQT2 
#define dtplqt_                  DTPLQT 
#define dtpmlqt_                 DTPMLQT 
#define dtpmqrt_                 DTPMQRT 
#define dtpqrt2_                 DTPQRT2 
#define dtpqrt_                  DTPQRT 
#define dtprfb_                  DTPRFB 
#define dtprfs_                  DTPRFS 
#define dtptri_                  DTPTRI 
#define dtptrs_                  DTPTRS 
#define dtpttf_                  DTPTTF 
#define dtpttr_                  DTPTTR 
#define dtrcon_                  DTRCON 
#define dtrevc3_                 DTREVC3 
#define dtrevc_                  DTREVC 
#define dtrexc_                  DTREXC 
#define dtrrfs_                  DTRRFS 
#define dtrsen_                  DTRSEN 
#define dtrsna_                  DTRSNA 
#define dtrsyl_                  DTRSYL 
#define dtrti2_                  DTRTI2 
#define dtrtri_                  DTRTRI 
#define dtrtrs_                  DTRTRS 
#define dtrttf_                  DTRTTF 
#define dtrttp_                  DTRTTP 
#define dtzrqf_                  DTZRQF 
#define dtzrzf_                  DTZRZF 
#define dzsum1_                  DZSUM1 
#define icmax1_                  ICMAX1 
#define ieeeck_                  IEEECK 
#define ilaclc_                  ILACLC 
#define ilaclr_                  ILACLR 
#define iladiag_                 ILADIAG 
#define iladlc_                  ILADLC 
#define iladlr_                  ILADLR 
#define ilaenv2stage_            ILAENV2STAGE 
#define ilaenv_                  ILAENV 
#define ilaprec_                 ILAPREC 
#define ilaslc_                  ILASLC 
#define ilaslr_                  ILASLR 
#define ilatrans_                ILATRANS 
#define ilauplo_                 ILAUPLO 
#define ilaver_                  ILAVER 
#define ilazlc_                  ILAZLC 
#define ilazlr_                  ILAZLR 
#define iparam2stage_            IPARAM2STAGE 
#define iparmq_                  IPARMQ 
#define izmax1_                  IZMAX1 
#define lsamen_                  LSAMEN 
#define sbbcsd_                  SBBCSD 
#define sbdsdc_                  SBDSDC 
#define sbdsqr_                  SBDSQR 
#define sbdsvdx_                 SBDSVDX 
#define scombssq_                SCOMBSSQ 
#define scsum1_                  SCSUM1 
#define sdisna_                  SDISNA 
#define sgbbrd_                  SGBBRD 
#define sgbcon_                  SGBCON 
#define sgbequ_                  SGBEQU 
#define sgbequb_                 SGBEQUB 
#define sgbrfs_                  SGBRFS 
#define sgbsv_                   SGBSV 
#define sgbsvx_                  SGBSVX 
#define sgbtf2_                  SGBTF2 
#define sgbtrf_                  SGBTRF 
#define sgbtrs_                  SGBTRS 
#define sgebak_                  SGEBAK 
#define sgebal_                  SGEBAL 
#define sgebd2_                  SGEBD2 
#define sgebrd_                  SGEBRD 
#define sgecon_                  SGECON 
#define sgeequ_                  SGEEQU 
#define sgeequb_                 SGEEQUB 
#define sgees_                   SGEES 
#define sgeesx_                  SGEESX 
#define sgeev_                   SGEEV 
#define sgeevx_                  SGEEVX 
#define sgegs_                   SGEGS 
#define sgegv_                   SGEGV 
#define sgehd2_                  SGEHD2 
#define sgehrd_                  SGEHRD 
#define sgejsv_                  SGEJSV 
#define sgelq2_                  SGELQ2 
#define sgelq_                   SGELQ 
#define sgelqf_                  SGELQF 
#define sgelqt3_                 SGELQT3 
#define sgelqt_                  SGELQT 
#define sgels_                   SGELS 
#define sgelsd_                  SGELSD 
#define sgelss_                  SGELSS 
#define sgelsx_                  SGELSX 
#define sgelsy_                  SGELSY 
#define sgemlq_                  SGEMLQ 
#define sgemlqt_                 SGEMLQT 
#define sgemqr_                  SGEMQR 
#define sgemqrt_                 SGEMQRT 
#define sgeql2_                  SGEQL2 
#define sgeqlf_                  SGEQLF 
#define sgeqp3_                  SGEQP3 
#define sgeqpf_                  SGEQPF 
#define sgeqr2_                  SGEQR2 
#define sgeqr2p_                 SGEQR2P 
#define sgeqr_                   SGEQR 
#define sgeqrf_                  SGEQRF 
#define sgeqrfp_                 SGEQRFP 
#define sgeqrt2_                 SGEQRT2 
#define sgeqrt3_                 SGEQRT3 
#define sgeqrt_                  SGEQRT 
#define sgerfs_                  SGERFS 
#define sgerq2_                  SGERQ2 
#define sgerqf_                  SGERQF 
#define sgesc2_                  SGESC2 
#define sgesdd_                  SGESDD 
#define sgesv_                   SGESV 
#define sgesvd_                  SGESVD 
#define sgesvdq_                 SGESVDQ 
#define sgesvdx_                 SGESVDX 
#define sgesvj_                  SGESVJ 
#define sgesvx_                  SGESVX 
#define sgetc2_                  SGETC2 
#define sgetf2_                  SGETF2 
#define sgetrf2_                 SGETRF2 
#define sgetrf_                  SGETRF 
#define sgetri_                  SGETRI 
#define sgetrs_                  SGETRS 
#define sgetsls_                 SGETSLS 
#define sggbak_                  SGGBAK 
#define sggbal_                  SGGBAL 
#define sgges3_                  SGGES3 
#define sgges_                   SGGES 
#define sggesx_                  SGGESX 
#define sggev3_                  SGGEV3 
#define sggev_                   SGGEV 
#define sggevx_                  SGGEVX 
#define sggglm_                  SGGGLM 
#define sgghd3_                  SGGHD3 
#define sgghrd_                  SGGHRD 
#define sgglse_                  SGGLSE 
#define sggqrf_                  SGGQRF 
#define sggrqf_                  SGGRQF 
#define sggsvd3_                 SGGSVD3 
#define sggsvd_                  SGGSVD 
#define sggsvp3_                 SGGSVP3 
#define sggsvp_                  SGGSVP 
#define sgsvj0_                  SGSVJ0 
#define sgsvj1_                  SGSVJ1 
#define sgtcon_                  SGTCON 
#define sgtrfs_                  SGTRFS 
#define sgtsv_                   SGTSV 
#define sgtsvx_                  SGTSVX 
#define sgttrf_                  SGTTRF 
#define sgttrs_                  SGTTRS 
#define sgtts2_                  SGTTS2 
#define shgeqz_                  SHGEQZ 
#define shsein_                  SHSEIN 
#define shseqr_                  SHSEQR 
#define sisnan_                  SISNAN 
#define sla_gbamv_               SLA_GBAMV 
#define sla_gbrcond_             SLA_GBRCOND 
#define sla_gbrpvgrw_            SLA_GBRPVGRW 
#define sla_geamv_               SLA_GEAMV 
#define sla_gercond_             SLA_GERCOND 
#define sla_gerpvgrw_            SLA_GERPVGRW 
#define sla_lin_berr_            SLA_LIN_BERR 
#define sla_porcond_             SLA_PORCOND 
#define sla_porpvgrw_            SLA_PORPVGRW 
#define sla_syamv_               SLA_SYAMV 
#define sla_syrcond_             SLA_SYRCOND 
#define sla_syrpvgrw_            SLA_SYRPVGRW 
#define sla_wwaddw_              SLA_WWADDW 
#define slabad_                  SLABAD 
#define slabrd_                  SLABRD 
#define slacn2_                  SLACN2 
#define slacon_                  SLACON 
#define slacpy_                  SLACPY 
#define sladiv1_                 SLADIV1 
#define sladiv2_                 SLADIV2 
#define sladiv_                  SLADIV 
#define slae2_                   SLAE2 
#define slaebz_                  SLAEBZ 
#define slaed0_                  SLAED0 
#define slaed1_                  SLAED1 
#define slaed2_                  SLAED2 
#define slaed3_                  SLAED3 
#define slaed4_                  SLAED4 
#define slaed5_                  SLAED5 
#define slaed6_                  SLAED6 
#define slaed7_                  SLAED7 
#define slaed8_                  SLAED8 
#define slaed9_                  SLAED9 
#define slaeda_                  SLAEDA 
#define slaein_                  SLAEIN 
#define slaev2_                  SLAEV2 
#define slaexc_                  SLAEXC 
#define slag2_                   SLAG2 
#define slag2d_                  SLAG2D 
#define slags2_                  SLAGS2 
#define slagtf_                  SLAGTF 
#define slagtm_                  SLAGTM 
#define slagts_                  SLAGTS 
#define slagv2_                  SLAGV2 
#define slahqr_                  SLAHQR 
#define slahr2_                  SLAHR2 
#define slahrd_                  SLAHRD 
#define slaic1_                  SLAIC1 
#define slaisnan_                SLAISNAN 
#define slaln2_                  SLALN2 
#define slals0_                  SLALS0 
#define slalsa_                  SLALSA 
#define slalsd_                  SLALSD 
#define slamc3_                  SLAMC3 
#define slamch_                  SLAMCH 
#define slamrg_                  SLAMRG 
#define slamswlq_                SLAMSWLQ 
#define slamtsqr_                SLAMTSQR 
#define slaneg_                  SLANEG 
#define slangb_                  SLANGB 
#define slange_                  SLANGE 
#define slangt_                  SLANGT 
#define slanhs_                  SLANHS 
#define slansb_                  SLANSB 
#define slansf_                  SLANSF 
#define slansp_                  SLANSP 
#define slanst_                  SLANST 
#define slansy_                  SLANSY 
#define slantb_                  SLANTB 
#define slantp_                  SLANTP 
#define slantr_                  SLANTR 
#define slanv2_                  SLANV2 
#define slaorhr_col_getrfnp2_    SLAORHR_COL_GETRFNP2 
#define slaorhr_col_getrfnp_     SLAORHR_COL_GETRFNP 
#define slapll_                  SLAPLL 
#define slapmr_                  SLAPMR 
#define slapmt_                  SLAPMT 
#define slapy2_                  SLAPY2 
#define slapy3_                  SLAPY3 
#define slaqgb_                  SLAQGB 
#define slaqge_                  SLAQGE 
#define slaqp2_                  SLAQP2 
#define slaqps_                  SLAQPS 
#define slaqr0_                  SLAQR0 
#define slaqr1_                  SLAQR1 
#define slaqr2_                  SLAQR2 
#define slaqr3_                  SLAQR3 
#define slaqr4_                  SLAQR4 
#define slaqr5_                  SLAQR5 
#define slaqsb_                  SLAQSB 
#define slaqsp_                  SLAQSP 
#define slaqsy_                  SLAQSY 
#define slaqtr_                  SLAQTR 
#define slar1v_                  SLAR1V 
#define slar2v_                  SLAR2V 
#define slarf_                   SLARF 
#define slarfb_                  SLARFB 
#define slarfg_                  SLARFG 
#define slarfgp_                 SLARFGP 
#define slarft_                  SLARFT 
#define slarfx_                  SLARFX 
#define slarfy_                  SLARFY 
#define slargv_                  SLARGV 
#define slarnv_                  SLARNV 
#define slarra_                  SLARRA 
#define slarrb_                  SLARRB 
#define slarrc_                  SLARRC 
#define slarrd_                  SLARRD 
#define slarre_                  SLARRE 
#define slarrf_                  SLARRF 
#define slarrj_                  SLARRJ 
#define slarrk_                  SLARRK 
#define slarrr_                  SLARRR 
#define slarrv_                  SLARRV 
#define slarscl2_                SLARSCL2 
#define slartg_                  SLARTG 
#define slartgp_                 SLARTGP 
#define slartgs_                 SLARTGS 
#define slartv_                  SLARTV 
#define slaruv_                  SLARUV 
#define slarz_                   SLARZ 
#define slarzb_                  SLARZB 
#define slarzt_                  SLARZT 
#define slas2_                   SLAS2 
#define slascl2_                 SLASCL2 
#define slascl_                  SLASCL 
#define slasd0_                  SLASD0 
#define slasd1_                  SLASD1 
#define slasd2_                  SLASD2 
#define slasd3_                  SLASD3 
#define slasd4_                  SLASD4 
#define slasd5_                  SLASD5 
#define slasd6_                  SLASD6 
#define slasd7_                  SLASD7 
#define slasd8_                  SLASD8 
#define slasda_                  SLASDA 
#define slasdq_                  SLASDQ 
#define slasdt_                  SLASDT 
#define slaset_                  SLASET 
#define slasq1_                  SLASQ1 
#define slasq2_                  SLASQ2 
#define slasq3_                  SLASQ3 
#define slasq4_                  SLASQ4 
#define slasq5_                  SLASQ5 
#define slasq6_                  SLASQ6 
#define slasr_                   SLASR 
#define slasrt_                  SLASRT 
#define slassq_                  SLASSQ 
#define slasv2_                  SLASV2 
#define slaswlq_                 SLASWLQ 
#define slaswp_                  SLASWP 
#define slasy2_                  SLASY2 
#define slasyf_                  SLASYF 
#define slasyf_aa_               SLASYF_AA 
#define slasyf_rk_               SLASYF_RK 
#define slasyf_rook_             SLASYF_ROOK 
#define slatbs_                  SLATBS 
#define slatdf_                  SLATDF 
#define slatps_                  SLATPS 
#define slatrd_                  SLATRD 
#define slatrs_                  SLATRS 
#define slatrz_                  SLATRZ 
#define slatsqr_                 SLATSQR 
#define slatzm_                  SLATZM 
#define slauu2_                  SLAUU2 
#define slauum_                  SLAUUM 
#define sopgtr_                  SOPGTR 
#define sopmtr_                  SOPMTR 
#define sorbdb1_                 SORBDB1 
#define sorbdb2_                 SORBDB2 
#define sorbdb3_                 SORBDB3 
#define sorbdb4_                 SORBDB4 
#define sorbdb5_                 SORBDB5 
#define sorbdb6_                 SORBDB6 
#define sorbdb_                  SORBDB 
#define sorcsd2by1_              SORCSD2BY1 
#define sorcsd_                  SORCSD 
#define sorg2l_                  SORG2L 
#define sorg2r_                  SORG2R 
#define sorgbr_                  SORGBR 
#define sorghr_                  SORGHR 
#define sorgl2_                  SORGL2 
#define sorglq_                  SORGLQ 
#define sorgql_                  SORGQL 
#define sorgqr_                  SORGQR 
#define sorgr2_                  SORGR2 
#define sorgrq_                  SORGRQ 
#define sorgtr_                  SORGTR 
#define sorgtsqr_                SORGTSQR 
#define sorhr_col_               SORHR_COL 
#define sorm22_                  SORM22 
#define sorm2l_                  SORM2L 
#define sorm2r_                  SORM2R 
#define sormbr_                  SORMBR 
#define sormhr_                  SORMHR 
#define sorml2_                  SORML2 
#define sormlq_                  SORMLQ 
#define sormql_                  SORMQL 
#define sormqr_                  SORMQR 
#define sormr2_                  SORMR2 
#define sormr3_                  SORMR3 
#define sormrq_                  SORMRQ 
#define sormrz_                  SORMRZ 
#define sormtr_                  SORMTR 
#define spbcon_                  SPBCON 
#define spbequ_                  SPBEQU 
#define spbrfs_                  SPBRFS 
#define spbstf_                  SPBSTF 
#define spbsv_                   SPBSV 
#define spbsvx_                  SPBSVX 
#define spbtf2_                  SPBTF2 
#define spbtrf_                  SPBTRF 
#define spbtrs_                  SPBTRS 
#define spftrf_                  SPFTRF 
#define spftri_                  SPFTRI 
#define spftrs_                  SPFTRS 
#define spocon_                  SPOCON 
#define spoequ_                  SPOEQU 
#define spoequb_                 SPOEQUB 
#define sporfs_                  SPORFS 
#define sposv_                   SPOSV 
#define sposvx_                  SPOSVX 
#define spotf2_                  SPOTF2 
#define spotrf2_                 SPOTRF2 
#define spotrf_                  SPOTRF 
#define spotri_                  SPOTRI 
#define spotrs_                  SPOTRS 
#define sppcon_                  SPPCON 
#define sppequ_                  SPPEQU 
#define spprfs_                  SPPRFS 
#define sppsv_                   SPPSV 
#define sppsvx_                  SPPSVX 
#define spptrf_                  SPPTRF 
#define spptri_                  SPPTRI 
#define spptrs_                  SPPTRS 
#define spstf2_                  SPSTF2 
#define spstrf_                  SPSTRF 
#define sptcon_                  SPTCON 
#define spteqr_                  SPTEQR 
#define sptrfs_                  SPTRFS 
#define sptsv_                   SPTSV 
#define sptsvx_                  SPTSVX 
#define spttrf_                  SPTTRF 
#define spttrs_                  SPTTRS 
#define sptts2_                  SPTTS2 
#define srscl_                   SRSCL 
#define ssb2st_kernels_          SSB2ST_KERNELS 
#define ssbev_                   SSBEV 
#define ssbev_2stage_            SSBEV_2STAGE 
#define ssbevd_                  SSBEVD 
#define ssbevd_2stage_           SSBEVD_2STAGE 
#define ssbevx_                  SSBEVX 
#define ssbevx_2stage_           SSBEVX_2STAGE 
#define ssbgst_                  SSBGST 
#define ssbgv_                   SSBGV 
#define ssbgvd_                  SSBGVD 
#define ssbgvx_                  SSBGVX 
#define ssbtrd_                  SSBTRD 
#define ssfrk_                   SSFRK 
#define sspcon_                  SSPCON 
#define sspev_                   SSPEV 
#define sspevd_                  SSPEVD 
#define sspevx_                  SSPEVX 
#define sspgst_                  SSPGST 
#define sspgv_                   SSPGV 
#define sspgvd_                  SSPGVD 
#define sspgvx_                  SSPGVX 
#define ssprfs_                  SSPRFS 
#define sspsv_                   SSPSV 
#define sspsvx_                  SSPSVX 
#define ssptrd_                  SSPTRD 
#define ssptrf_                  SSPTRF 
#define ssptri_                  SSPTRI 
#define ssptrs_                  SSPTRS 
#define sstebz_                  SSTEBZ 
#define sstedc_                  SSTEDC 
#define sstegr_                  SSTEGR 
#define sstein_                  SSTEIN 
#define sstemr_                  SSTEMR 
#define ssteqr_                  SSTEQR 
#define ssterf_                  SSTERF 
#define sstev_                   SSTEV 
#define sstevd_                  SSTEVD 
#define sstevr_                  SSTEVR 
#define sstevx_                  SSTEVX 
#define ssycon_                  SSYCON 
#define ssycon_3_                SSYCON_3 
#define ssycon_rook_             SSYCON_ROOK 
#define ssyconv_                 SSYCONV 
#define ssyconvf_                SSYCONVF 
#define ssyconvf_rook_           SSYCONVF_ROOK 
#define ssyequb_                 SSYEQUB 
#define ssyev_                   SSYEV 
#define ssyev_2stage_            SSYEV_2STAGE 
#define ssyevd_                  SSYEVD 
#define ssyevd_2stage_           SSYEVD_2STAGE 
#define ssyevr_                  SSYEVR 
#define ssyevr_2stage_           SSYEVR_2STAGE 
#define ssyevx_                  SSYEVX 
#define ssyevx_2stage_           SSYEVX_2STAGE 
#define ssygs2_                  SSYGS2 
#define ssygst_                  SSYGST 
#define ssygv_                   SSYGV 
#define ssygv_2stage_            SSYGV_2STAGE 
#define ssygvd_                  SSYGVD 
#define ssygvx_                  SSYGVX 
#define ssyrfs_                  SSYRFS 
#define ssysv_                   SSYSV 
#define ssysv_aa_                SSYSV_AA 
#define ssysv_aa_2stage_         SSYSV_AA_2STAGE 
#define ssysv_rk_                SSYSV_RK 
#define ssysv_rook_              SSYSV_ROOK 
#define ssysvx_                  SSYSVX 
#define ssyswapr_                SSYSWAPR 
#define ssytd2_                  SSYTD2 
#define ssytf2_                  SSYTF2 
#define ssytf2_rk_               SSYTF2_RK 
#define ssytf2_rook_             SSYTF2_ROOK 
#define ssytrd_                  SSYTRD 
#define ssytrd_2stage_           SSYTRD_2STAGE 
#define ssytrd_sb2st_            SSYTRD_SB2ST 
#define ssytrd_sy2sb_            SSYTRD_SY2SB 
#define ssytrf_                  SSYTRF 
#define ssytrf_aa_               SSYTRF_AA 
#define ssytrf_aa_2stage_        SSYTRF_AA_2STAGE 
#define ssytrf_rk_               SSYTRF_RK 
#define ssytrf_rook_             SSYTRF_ROOK 
#define ssytri2_                 SSYTRI2 
#define ssytri2x_                SSYTRI2X 
#define ssytri_                  SSYTRI 
#define ssytri_3_                SSYTRI_3 
#define ssytri_3x_               SSYTRI_3X 
#define ssytri_rook_             SSYTRI_ROOK 
#define ssytrs2_                 SSYTRS2 
#define ssytrs_                  SSYTRS 
#define ssytrs_3_                SSYTRS_3 
#define ssytrs_aa_               SSYTRS_AA 
#define ssytrs_aa_2stage_        SSYTRS_AA_2STAGE 
#define ssytrs_rook_             SSYTRS_ROOK 
#define stbcon_                  STBCON 
#define stbrfs_                  STBRFS 
#define stbtrs_                  STBTRS 
#define stfsm_                   STFSM 
#define stftri_                  STFTRI 
#define stfttp_                  STFTTP 
#define stfttr_                  STFTTR 
#define stgevc_                  STGEVC 
#define stgex2_                  STGEX2 
#define stgexc_                  STGEXC 
#define stgsen_                  STGSEN 
#define stgsja_                  STGSJA 
#define stgsna_                  STGSNA 
#define stgsy2_                  STGSY2 
#define stgsyl_                  STGSYL 
#define stpcon_                  STPCON 
#define stplqt2_                 STPLQT2 
#define stplqt_                  STPLQT 
#define stpmlqt_                 STPMLQT 
#define stpmqrt_                 STPMQRT 
#define stpqrt2_                 STPQRT2 
#define stpqrt_                  STPQRT 
#define stprfb_                  STPRFB 
#define stprfs_                  STPRFS 
#define stptri_                  STPTRI 
#define stptrs_                  STPTRS 
#define stpttf_                  STPTTF 
#define stpttr_                  STPTTR 
#define strcon_                  STRCON 
#define strevc3_                 STREVC3 
#define strevc_                  STREVC 
#define strexc_                  STREXC 
#define strrfs_                  STRRFS 
#define strsen_                  STRSEN 
#define strsna_                  STRSNA 
#define strsyl_                  STRSYL 
#define strti2_                  STRTI2 
#define strtri_                  STRTRI 
#define strtrs_                  STRTRS 
#define strttf_                  STRTTF 
#define strttp_                  STRTTP 
#define stzrqf_                  STZRQF 
#define stzrzf_                  STZRZF 
#define xerbla_array_            XERBLA_ARRAY
#define zbbcsd_                  ZBBCSD 
#define zbdsqr_                  ZBDSQR 
#define zcgesv_                  ZCGESV 
#define zcposv_                  ZCPOSV 
#define zdrscl_                  ZDRSCL 
#define zgbbrd_                  ZGBBRD 
#define zgbcon_                  ZGBCON 
#define zgbequ_                  ZGBEQU 
#define zgbequb_                 ZGBEQUB 
#define zgbrfs_                  ZGBRFS 
#define zgbsv_                   ZGBSV 
#define zgbsvx_                  ZGBSVX 
#define zgbtf2_                  ZGBTF2 
#define zgbtrf_                  ZGBTRF 
#define zgbtrs_                  ZGBTRS 
#define zgebak_                  ZGEBAK 
#define zgebal_                  ZGEBAL 
#define zgebd2_                  ZGEBD2 
#define zgebrd_                  ZGEBRD 
#define zgecon_                  ZGECON 
#define zgeequ_                  ZGEEQU 
#define zgeequb_                 ZGEEQUB 
#define zgees_                   ZGEES 
#define zgeesx_                  ZGEESX 
#define zgeev_                   ZGEEV 
#define zgeevx_                  ZGEEVX 
#define zgegs_                   ZGEGS 
#define zgegv_                   ZGEGV 
#define zgehd2_                  ZGEHD2 
#define zgehrd_                  ZGEHRD 
#define zgejsv_                  ZGEJSV 
#define zgelq2_                  ZGELQ2 
#define zgelq_                   ZGELQ 
#define zgelqf_                  ZGELQF 
#define zgelqt3_                 ZGELQT3 
#define zgelqt_                  ZGELQT 
#define zgels_                   ZGELS 
#define zgelsd_                  ZGELSD 
#define zgelss_                  ZGELSS 
#define zgelsx_                  ZGELSX 
#define zgelsy_                  ZGELSY 
#define zgemlq_                  ZGEMLQ 
#define zgemlqt_                 ZGEMLQT 
#define zgemqr_                  ZGEMQR 
#define zgemqrt_                 ZGEMQRT 
#define zgeql2_                  ZGEQL2 
#define zgeqlf_                  ZGEQLF 
#define zgeqp3_                  ZGEQP3 
#define zgeqpf_                  ZGEQPF 
#define zgeqr2_                  ZGEQR2 
#define zgeqr2p_                 ZGEQR2P 
#define zgeqr_                   ZGEQR 
#define zgeqrf_                  ZGEQRF 
#define zgeqrfp_                 ZGEQRFP 
#define zgeqrt2_                 ZGEQRT2 
#define zgeqrt3_                 ZGEQRT3 
#define zgeqrt_                  ZGEQRT 
#define zgerfs_                  ZGERFS 
#define zgerq2_                  ZGERQ2 
#define zgerqf_                  ZGERQF 
#define zgesc2_                  ZGESC2 
#define zgesdd_                  ZGESDD 
#define zgesv_                   ZGESV 
#define zgesvd_                  ZGESVD 
#define zgesvdq_                 ZGESVDQ 
#define zgesvdx_                 ZGESVDX 
#define zgesvj_                  ZGESVJ 
#define zgesvx_                  ZGESVX 
#define zgetc2_                  ZGETC2 
#define zgetf2_                  ZGETF2 
#define zgetrf2_                 ZGETRF2 
#define zgetrf_                  ZGETRF 
#define zgetri_                  ZGETRI 
#define zgetrs_                  ZGETRS 
#define zgetsls_                 ZGETSLS 
#define zggbak_                  ZGGBAK 
#define zggbal_                  ZGGBAL 
#define zgges3_                  ZGGES3 
#define zgges_                   ZGGES 
#define zggesx_                  ZGGESX 
#define zggev3_                  ZGGEV3 
#define zggev_                   ZGGEV 
#define zggevx_                  ZGGEVX 
#define zggglm_                  ZGGGLM 
#define zgghd3_                  ZGGHD3 
#define zgghrd_                  ZGGHRD 
#define zgglse_                  ZGGLSE 
#define zggqrf_                  ZGGQRF 
#define zggrqf_                  ZGGRQF 
#define zggsvd3_                 ZGGSVD3 
#define zggsvd_                  ZGGSVD 
#define zggsvp3_                 ZGGSVP3 
#define zggsvp_                  ZGGSVP 
#define zgsvj0_                  ZGSVJ0 
#define zgsvj1_                  ZGSVJ1 
#define zgtcon_                  ZGTCON 
#define zgtrfs_                  ZGTRFS 
#define zgtsv_                   ZGTSV 
#define zgtsvx_                  ZGTSVX 
#define zgttrf_                  ZGTTRF 
#define zgttrs_                  ZGTTRS 
#define zgtts2_                  ZGTTS2 
#define zhb2st_kernels_          ZHB2ST_KERNELS 
#define zhbev_                   ZHBEV 
#define zhbev_2stage_            ZHBEV_2STAGE 
#define zhbevd_                  ZHBEVD 
#define zhbevd_2stage_           ZHBEVD_2STAGE 
#define zhbevx_                  ZHBEVX 
#define zhbevx_2stage_           ZHBEVX_2STAGE 
#define zhbgst_                  ZHBGST 
#define zhbgv_                   ZHBGV 
#define zhbgvd_                  ZHBGVD 
#define zhbgvx_                  ZHBGVX 
#define zhbtrd_                  ZHBTRD 
#define zhecon_                  ZHECON 
#define zhecon_3_                ZHECON_3 
#define zhecon_rook_             ZHECON_ROOK 
#define zheequb_                 ZHEEQUB 
#define zheev_                   ZHEEV 
#define zheev_2stage_            ZHEEV_2STAGE 
#define zheevd_                  ZHEEVD 
#define zheevd_2stage_           ZHEEVD_2STAGE 
#define zheevr_                  ZHEEVR 
#define zheevr_2stage_           ZHEEVR_2STAGE 
#define zheevx_                  ZHEEVX 
#define zheevx_2stage_           ZHEEVX_2STAGE 
#define zhegs2_                  ZHEGS2 
#define zhegst_                  ZHEGST 
#define zhegv_                   ZHEGV 
#define zhegv_2stage_            ZHEGV_2STAGE 
#define zhegvd_                  ZHEGVD 
#define zhegvx_                  ZHEGVX 
#define zherfs_                  ZHERFS 
#define zhesv_                   ZHESV 
#define zhesv_aa_                ZHESV_AA 
#define zhesv_aa_2stage_         ZHESV_AA_2STAGE 
#define zhesv_rk_                ZHESV_RK 
#define zhesv_rook_              ZHESV_ROOK 
#define zhesvx_                  ZHESVX 
#define zheswapr_                ZHESWAPR 
#define zhetd2_                  ZHETD2 
#define zhetf2_                  ZHETF2 
#define zhetf2_rk_               ZHETF2_RK 
#define zhetf2_rook_             ZHETF2_ROOK 
#define zhetrd_                  ZHETRD 
#define zhetrd_2stage_           ZHETRD_2STAGE 
#define zhetrd_hb2st_            ZHETRD_HB2ST 
#define zhetrd_he2hb_            ZHETRD_HE2HB 
#define zhetrf_                  ZHETRF 
#define zhetrf_aa_               ZHETRF_AA 
#define zhetrf_aa_2stage_        ZHETRF_AA_2STAGE 
#define zhetrf_rk_               ZHETRF_RK 
#define zhetrf_rook_             ZHETRF_ROOK 
#define zhetri2_                 ZHETRI2 
#define zhetri2x_                ZHETRI2X 
#define zhetri_                  ZHETRI 
#define zhetri_3_                ZHETRI_3 
#define zhetri_3x_               ZHETRI_3X 
#define zhetri_rook_             ZHETRI_ROOK 
#define zhetrs2_                 ZHETRS2 
#define zhetrs_                  ZHETRS 
#define zhetrs_3_                ZHETRS_3 
#define zhetrs_aa_               ZHETRS_AA 
#define zhetrs_aa_2stage_        ZHETRS_AA_2STAGE 
#define zhetrs_rook_             ZHETRS_ROOK 
#define zhfrk_                   ZHFRK 
#define zhgeqz_                  ZHGEQZ 
#define zhpcon_                  ZHPCON 
#define zhpev_                   ZHPEV 
#define zhpevd_                  ZHPEVD 
#define zhpevx_                  ZHPEVX 
#define zhpgst_                  ZHPGST 
#define zhpgv_                   ZHPGV 
#define zhpgvd_                  ZHPGVD 
#define zhpgvx_                  ZHPGVX 
#define zhprfs_                  ZHPRFS 
#define zhpsv_                   ZHPSV 
#define zhpsvx_                  ZHPSVX 
#define zhptrd_                  ZHPTRD 
#define zhptrf_                  ZHPTRF 
#define zhptri_                  ZHPTRI 
#define zhptrs_                  ZHPTRS 
#define zhsein_                  ZHSEIN 
#define zhseqr_                  ZHSEQR 
#define zla_gbamv_               ZLA_GBAMV 
#define zla_gbrcond_c_           ZLA_GBRCOND_C 
#define zla_gbrcond_x_           ZLA_GBRCOND_X 
#define zla_gbrpvgrw_            ZLA_GBRPVGRW 
#define zla_geamv_               ZLA_GEAMV 
#define zla_gercond_c_           ZLA_GERCOND_C 
#define zla_gercond_x_           ZLA_GERCOND_X 
#define zla_gerpvgrw_            ZLA_GERPVGRW 
#define zla_heamv_               ZLA_HEAMV 
#define zla_hercond_c_           ZLA_HERCOND_C 
#define zla_hercond_x_           ZLA_HERCOND_X 
#define zla_herpvgrw_            ZLA_HERPVGRW 
#define zla_lin_berr_            ZLA_LIN_BERR 
#define zla_porcond_c_           ZLA_PORCOND_C 
#define zla_porcond_x_           ZLA_PORCOND_X 
#define zla_porpvgrw_            ZLA_PORPVGRW 
#define zla_syamv_               ZLA_SYAMV 
#define zla_syrcond_c_           ZLA_SYRCOND_C 
#define zla_syrcond_x_           ZLA_SYRCOND_X 
#define zla_syrpvgrw_            ZLA_SYRPVGRW 
#define zla_wwaddw_              ZLA_WWADDW 
#define zlabrd_                  ZLABRD 
#define zlacgv_                  ZLACGV 
#define zlacn2_                  ZLACN2 
#define zlacon_                  ZLACON 
#define zlacp2_                  ZLACP2 
#define zlacpy_                  ZLACPY 
#define zlacrm_                  ZLACRM 
#define zlacrt_                  ZLACRT 
#define zladiv_                  ZLADIV 
#define zlaed0_                  ZLAED0 
#define zlaed7_                  ZLAED7 
#define zlaed8_                  ZLAED8 
#define zlaein_                  ZLAEIN 
#define zlaesy_                  ZLAESY 
#define zlaev2_                  ZLAEV2 
#define zlag2c_                  ZLAG2C 
#define zlags2_                  ZLAGS2 
#define zlagtm_                  ZLAGTM 
#define zlahef_                  ZLAHEF 
#define zlahef_aa_               ZLAHEF_AA 
#define zlahef_rk_               ZLAHEF_RK 
#define zlahef_rook_             ZLAHEF_ROOK 
#define zlahqr_                  ZLAHQR 
#define zlahr2_                  ZLAHR2 
#define zlahrd_                  ZLAHRD 
#define zlaic1_                  ZLAIC1 
#define zlals0_                  ZLALS0 
#define zlalsa_                  ZLALSA 
#define zlalsd_                  ZLALSD 
#define zlamswlq_                ZLAMSWLQ 
#define zlamtsqr_                ZLAMTSQR 
#define zlangb_                  ZLANGB 
#define zlange_                  ZLANGE 
#define zlangt_                  ZLANGT 
#define zlanhb_                  ZLANHB 
#define zlanhe_                  ZLANHE 
#define zlanhf_                  ZLANHF 
#define zlanhp_                  ZLANHP 
#define zlanhs_                  ZLANHS 
#define zlanht_                  ZLANHT 
#define zlansb_                  ZLANSB 
#define zlansp_                  ZLANSP 
#define zlansy_                  ZLANSY 
#define zlantb_                  ZLANTB 
#define zlantp_                  ZLANTP 
#define zlantr_                  ZLANTR 
#define zlapll_                  ZLAPLL 
#define zlapmr_                  ZLAPMR 
#define zlapmt_                  ZLAPMT 
#define zlaqgb_                  ZLAQGB 
#define zlaqge_                  ZLAQGE 
#define zlaqhb_                  ZLAQHB 
#define zlaqhe_                  ZLAQHE 
#define zlaqhp_                  ZLAQHP 
#define zlaqp2_                  ZLAQP2 
#define zlaqps_                  ZLAQPS 
#define zlaqr0_                  ZLAQR0 
#define zlaqr1_                  ZLAQR1 
#define zlaqr2_                  ZLAQR2 
#define zlaqr3_                  ZLAQR3 
#define zlaqr4_                  ZLAQR4 
#define zlaqr5_                  ZLAQR5 
#define zlaqsb_                  ZLAQSB 
#define zlaqsp_                  ZLAQSP 
#define zlaqsy_                  ZLAQSY 
#define zlar1v_                  ZLAR1V 
#define zlar2v_                  ZLAR2V 
#define zlarcm_                  ZLARCM 
#define zlarf_                   ZLARF 
#define zlarfb_                  ZLARFB 
#define zlarfg_                  ZLARFG 
#define zlarfgp_                 ZLARFGP 
#define zlarft_                  ZLARFT 
#define zlarfx_                  ZLARFX 
#define zlarfy_                  ZLARFY 
#define zlargv_                  ZLARGV 
#define zlarnv_                  ZLARNV 
#define zlarrv_                  ZLARRV 
#define zlarscl2_                ZLARSCL2 
#define zlartg_                  ZLARTG 
#define zlartv_                  ZLARTV 
#define zlarz_                   ZLARZ 
#define zlarzb_                  ZLARZB 
#define zlarzt_                  ZLARZT 
#define zlascl2_                 ZLASCL2 
#define zlascl_                  ZLASCL 
#define zlaset_                  ZLASET 
#define zlasr_                   ZLASR 
#define zlassq_                  ZLASSQ 
#define zlaswlq_                 ZLASWLQ 
#define zlaswp_                  ZLASWP 
#define zlasyf_                  ZLASYF 
#define zlasyf_aa_               ZLASYF_AA 
#define zlasyf_rk_               ZLASYF_RK 
#define zlasyf_rook_             ZLASYF_ROOK 
#define zlat2c_                  ZLAT2C 
#define zlatbs_                  ZLATBS 
#define zlatdf_                  ZLATDF 
#define zlatps_                  ZLATPS 
#define zlatrd_                  ZLATRD 
#define zlatrs_                  ZLATRS 
#define zlatrz_                  ZLATRZ 
#define zlatsqr_                 ZLATSQR 
#define zlatzm_                  ZLATZM 
#define zlaunhr_col_getrfnp2_    ZLAUNHR_COL_GETRFNP2 
#define zlaunhr_col_getrfnp_     ZLAUNHR_COL_GETRFNP 
#define zlauu2_                  ZLAUU2 
#define zlauum_                  ZLAUUM 
#define zpbcon_                  ZPBCON 
#define zpbequ_                  ZPBEQU 
#define zpbrfs_                  ZPBRFS 
#define zpbstf_                  ZPBSTF 
#define zpbsv_                   ZPBSV 
#define zpbsvx_                  ZPBSVX 
#define zpbtf2_                  ZPBTF2 
#define zpbtrf_                  ZPBTRF 
#define zpbtrs_                  ZPBTRS 
#define zpftrf_                  ZPFTRF 
#define zpftri_                  ZPFTRI 
#define zpftrs_                  ZPFTRS 
#define zpocon_                  ZPOCON 
#define zpoequ_                  ZPOEQU 
#define zpoequb_                 ZPOEQUB 
#define zporfs_                  ZPORFS 
#define zposv_                   ZPOSV 
#define zposvx_                  ZPOSVX 
#define zpotf2_                  ZPOTF2 
#define zpotrf2_                 ZPOTRF2 
#define zpotrf_                  ZPOTRF 
#define zpotri_                  ZPOTRI 
#define zpotrs_                  ZPOTRS 
#define zppcon_                  ZPPCON 
#define zppequ_                  ZPPEQU 
#define zpprfs_                  ZPPRFS 
#define zppsv_                   ZPPSV 
#define zppsvx_                  ZPPSVX 
#define zpptrf_                  ZPPTRF 
#define zpptri_                  ZPPTRI 
#define zpptrs_                  ZPPTRS 
#define zpstf2_                  ZPSTF2 
#define zpstrf_                  ZPSTRF 
#define zptcon_                  ZPTCON 
#define zpteqr_                  ZPTEQR 
#define zptrfs_                  ZPTRFS 
#define zptsv_                   ZPTSV 
#define zptsvx_                  ZPTSVX 
#define zpttrf_                  ZPTTRF 
#define zpttrs_                  ZPTTRS 
#define zptts2_                  ZPTTS2 
#define zrot_                    ZROT 
#define zspcon_                  ZSPCON 
#define zspmv_                   ZSPMV 
#define zspr_                    ZSPR 
#define zsprfs_                  ZSPRFS 
#define zspsv_                   ZSPSV 
#define zspsvx_                  ZSPSVX 
#define zsptrf_                  ZSPTRF 
#define zsptri_                  ZSPTRI 
#define zsptrs_                  ZSPTRS 
#define zstedc_                  ZSTEDC 
#define zstegr_                  ZSTEGR 
#define zstein_                  ZSTEIN 
#define zstemr_                  ZSTEMR 
#define zsteqr_                  ZSTEQR 
#define zsycon_                  ZSYCON 
#define zsycon_3_                ZSYCON_3 
#define zsycon_rook_             ZSYCON_ROOK 
#define zsyconv_                 ZSYCONV 
#define zsyconvf_                ZSYCONVF 
#define zsyconvf_rook_           ZSYCONVF_ROOK 
#define zsyequb_                 ZSYEQUB 
#define zsymv_                   ZSYMV 
#define zsyr_                    ZSYR 
#define zsyrfs_                  ZSYRFS 
#define zsysv_                   ZSYSV 
#define zsysv_aa_                ZSYSV_AA 
#define zsysv_aa_2stage_         ZSYSV_AA_2STAGE 
#define zsysv_rk_                ZSYSV_RK 
#define zsysv_rook_              ZSYSV_ROOK 
#define zsysvx_                  ZSYSVX 
#define zsyswapr_                ZSYSWAPR 
#define zsytf2_                  ZSYTF2 
#define zsytf2_rk_               ZSYTF2_RK 
#define zsytf2_rook_             ZSYTF2_ROOK 
#define zsytrf_                  ZSYTRF 
#define zsytrf_aa_               ZSYTRF_AA 
#define zsytrf_aa_2stage_        ZSYTRF_AA_2STAGE 
#define zsytrf_rk_               ZSYTRF_RK 
#define zsytrf_rook_             ZSYTRF_ROOK 
#define zsytri2_                 ZSYTRI2 
#define zsytri2x_                ZSYTRI2X 
#define zsytri_                  ZSYTRI 
#define zsytri_3_                ZSYTRI_3 
#define zsytri_3x_               ZSYTRI_3X 
#define zsytri_rook_             ZSYTRI_ROOK 
#define zsytrs2_                 ZSYTRS2 
#define zsytrs_                  ZSYTRS 
#define zsytrs_3_                ZSYTRS_3 
#define zsytrs_aa_               ZSYTRS_AA 
#define zsytrs_aa_2stage_        ZSYTRS_AA_2STAGE 
#define zsytrs_rook_             ZSYTRS_ROOK 
#define ztbcon_                  ZTBCON 
#define ztbrfs_                  ZTBRFS 
#define ztbtrs_                  ZTBTRS 
#define ztfsm_                   ZTFSM 
#define ztftri_                  ZTFTRI 
#define ztfttp_                  ZTFTTP 
#define ztfttr_                  ZTFTTR 
#define ztgevc_                  ZTGEVC 
#define ztgex2_                  ZTGEX2 
#define ztgexc_                  ZTGEXC 
#define ztgsen_                  ZTGSEN 
#define ztgsja_                  ZTGSJA 
#define ztgsna_                  ZTGSNA 
#define ztgsy2_                  ZTGSY2 
#define ztgsyl_                  ZTGSYL 
#define ztpcon_                  ZTPCON 
#define ztplqt2_                 ZTPLQT2 
#define ztplqt_                  ZTPLQT 
#define ztpmlqt_                 ZTPMLQT 
#define ztpmqrt_                 ZTPMQRT 
#define ztpqrt2_                 ZTPQRT2 
#define ztpqrt_                  ZTPQRT 
#define ztprfb_                  ZTPRFB 
#define ztprfs_                  ZTPRFS 
#define ztptri_                  ZTPTRI 
#define ztptrs_                  ZTPTRS 
#define ztpttf_                  ZTPTTF 
#define ztpttr_                  ZTPTTR 
#define ztrcon_                  ZTRCON 
#define ztrevc3_                 ZTREVC3 
#define ztrevc_                  ZTREVC 
#define ztrexc_                  ZTREXC 
#define ztrrfs_                  ZTRRFS 
#define ztrsen_                  ZTRSEN 
#define ztrsna_                  ZTRSNA 
#define ztrsyl_                  ZTRSYL 
#define ztrti2_                  ZTRTI2 
#define ztrtri_                  ZTRTRI 
#define ztrtrs_                  ZTRTRS 
#define ztrttf_                  ZTRTTF 
#define ztrttp_                  ZTRTTP 
#define ztzrqf_                  ZTZRQF 
#define ztzrzf_                  ZTZRZF 
#define zunbdb1_                 ZUNBDB1 
#define zunbdb2_                 ZUNBDB2 
#define zunbdb3_                 ZUNBDB3 
#define zunbdb4_                 ZUNBDB4 
#define zunbdb5_                 ZUNBDB5 
#define zunbdb6_                 ZUNBDB6 
#define zunbdb_                  ZUNBDB 
#define zuncsd2by1_              ZUNCSD2BY1 
#define zuncsd_                  ZUNCSD 
#define zung2l_                  ZUNG2L 
#define zung2r_                  ZUNG2R 
#define zungbr_                  ZUNGBR 
#define zunghr_                  ZUNGHR 
#define zungl2_                  ZUNGL2 
#define zunglq_                  ZUNGLQ 
#define zungql_                  ZUNGQL 
#define zungqr_                  ZUNGQR 
#define zungr2_                  ZUNGR2 
#define zungrq_                  ZUNGRQ 
#define zungtr_                  ZUNGTR 
#define zungtsqr_                ZUNGTSQR 
#define zunhr_col_               ZUNHR_COL 
#define zunm22_                  ZUNM22 
#define zunm2l_                  ZUNM2L 
#define zunm2r_                  ZUNM2R 
#define zunmbr_                  ZUNMBR 
#define zunmhr_                  ZUNMHR 
#define zunml2_                  ZUNML2 
#define zunmlq_                  ZUNMLQ 
#define zunmql_                  ZUNMQL 
#define zunmqr_                  ZUNMQR 
#define zunmr2_                  ZUNMR2 
#define zunmr3_                  ZUNMR3 
#define zunmrq_                  ZUNMRQ 
#define zunmrz_                  ZUNMRZ 
#define zunmtr_                  ZUNMTR 
#define zupgtr_                  ZUPGTR 
#define zupmtr_                  ZUPMTR 
#define chla_transtype_          CHLA_TRANSTYPE
#define disnan_                  DISNAN
#define dlaisnan_                DLAISNAN
#define sisnan_                  SISNAN
#define slaisnan_                SLAISNAN
#define cladiv_                  CLADIV
#define zladiv_                  ZLADIV
#define sgetrfnp_                SGETRFNP
#define dgetrfnp_                DGETRFNP
#define cgetrfnp_                CGETRFNP
#define zgetrfnp_                ZGETRFNP
#define sspffrt2_                SSPFFRT2
#define dspffrt2_                DSPFFRT2
#define cspffrt2_                CSPFFRT2
#define zspffrt2_                ZSPFFRT2
#define sspffrtx_                SSPFFRTX
#define dspffrtx_                DSPFFRTX
#define cspffrtx_                CSPFFRTX
#define zspffrtx_                ZSPFFRTX
#define sgetrfnpi_               SGETRFNPI
#define dgetrfnpi_               DGETRFNPI
#define cgetrfnpi_               CGETRFNPI
#define zgetrfnpi_               ZGETRFNPI
#else
#define  cgelst_   cgelst
#define  clatrs3_  clatrs3
#define  ctrsyl3_  ctrsyl3
#define  dlarmm_   dlarmm
#define  dgelst_   dgelst
#define  dlatrs3_  dlatrs3
#define  dtrsyl3_  dtrsyl3
#define  slarmm_   slarmm
#define  sgelst_   sgelst
#define  slatrs3_  slatrs3
#define  strsyl3_  strsyl3
#define  zgelst_   zgelst
#define  zlatrs3_  zlatrs3
#define  ztrsyl3_  ztrsyl3
#define  cgetsqrhrt_  cgetsqrhrt
#define  claqz0_  claqz0
#define  claqz1_  claqz1
#define  claqz2_  claqz2
#define  claqz3_  claqz3
#define  clarfb_gett_  clarfb_gett
#define  cungtsqr_row_  cungtsqr_row
#define  dgetsqrhrt_  dgetsqrhrt
#define  dlaqz0_  dlaqz0
#define  dlaqz1_  dlaqz1
#define  dlaqz2_  dlaqz2
#define  dlaqz3_  dlaqz3
#define  dlaqz4_  dlaqz4
#define  dlarfb_gett_  dlarfb_gett
#define  dorgtsqr_row_  dorgtsqr_row
#define  sgetsqrhrt_  sgetsqrhrt
#define  slaqz0_  slaqz0
#define  slaqz1_  slaqz1
#define  slaqz2_  slaqz2
#define  slaqz3_  slaqz3
#define  slaqz4_  slaqz4
#define  slarfb_gett_  slarfb_gett
#define  sorgtsqr_row_  sorgtsqr_row
#define  zgetsqrhrt_  zgetsqrhrt
#define  zlaqz0_  zlaqz0
#define  zlaqz1_  zlaqz1
#define  zlaqz2_  zlaqz2
#define  zlaqz3_  zlaqz3
#define  zlarfb_gett_  zlarfb_gett
#define	 zungtsqr_row_  zungtsqr_row
#define sroundup_lwork sroundup_lwork
#define droundup_lwork droundup_lwork

#define  isamax_   isamax     
#define  idamax_   idamax     
#define  icamax_   icamax     
#define  izamax_   izamax     
#define  sasum_	   sasum      
#define  dasum_	   dasum      
#define  scasum_   scasum     
#define  dzasum_   dzasum     
#define  saxpy_	   saxpy      
#define  daxpy_	   daxpy      
#define  caxpy_	   caxpy      
#define  zaxpy_	   zaxpy      
#define  scopy_	   scopy      
#define  dcopy_	   dcopy      
#define  ccopy_	   ccopy      
#define  zcopy_	   zcopy      
#define  sdot_	   sdot       
#define  ddot_	   ddot       
#define  cdotu_	   cdotu      
#define  cdotc_	   cdotc      
#define  zdotu_	   zdotu      
#define  zdotc_	   zdotc      
#define  snrm2_	   snrm2      
#define  dnrm2_	   dnrm2      
#define  scnrm2_   scnrm2     
#define  dznrm2_   dznrm2     
#define  sscal_	   sscal      
#define  dscal_	   dscal      
#define  cscal_	   cscal      
#define  csscal_   csscal     
#define  zscal_	   zscal      
#define  zdscal_   zdscal     
#define  sswap_	   sswap      
#define  dswap_	   dswap      
#define  cswap_	   cswap      
#define  zswap_	   zswap      
#define  sgemv_	   sgemv      
#define  dgemv_	   dgemv      
#define  cgemv_	   cgemv      
#define  zgemv_	   zgemv      
#define  sger_	   sger       
#define  dger_	   dger       
#define  cgerc_	   cgerc      
#define  cgeru_	   cgeru      
#define  zgerc_	   zgerc      
#define  zgeru_	   zgeru      
#define  chemv_	   chemv      
#define  zhemv_	   zhemv      
#define  cher_	   cher       
#define  zher_	   zher       
#define  cher2_	   cher2      
#define  zher2_	   zher2      
#define  ssymv_	   ssymv      
#define  dsymv_	   dsymv      
#define  ssyr_	   ssyr       
#define  dsyr_	   dsyr       
#define  ssyr2_	   ssyr2      
#define  dsyr2_	   dsyr2      
#define  strmv_	   strmv      
#define  dtrmv_	   dtrmv      
#define  ctrmv_	   ctrmv      
#define  ztrmv_	   ztrmv      
#define  strsv_	   strsv      
#define  dtrsv_	   dtrsv      
#define  ctrsv_	   ctrsv      
#define  ztrsv_	   ztrsv      
#define  sgemm_	   sgemm      
#define  dgemm_	   dgemm      
#define  cgemm_	   cgemm      
#define  zgemm_	   zgemm      
#define  chemm_	   chemm      
#define  zhemm_	   zhemm      
#define  cherk_	   cherk      
#define  zherk_	   zherk      
#define  cher2k_   cher2k     
#define  zher2k_   zher2k     
#define  ssymm_	   ssymm      
#define  dsymm_	   dsymm      
#define  csymm_	   csymm      
#define  zsymm_	   zsymm      
#define  ssyrk_	   ssyrk      
#define  dsyrk_	   dsyrk      
#define  csyrk_	   csyrk      
#define  zsyrk_	   zsyrk      
#define  ssyr2k_   ssyr2k     
#define  dsyr2k_   dsyr2k     
#define  csyr2k_   csyr2k     
#define  zsyr2k_   zsyr2k     
#define  strmm_	   strmm      
#define  dtrmm_	   dtrmm      
#define  ctrmm_	   ctrmm      
#define  ztrmm_	   ztrmm      
#define  strsm_	   strsm      
#define  dtrsm_	   dtrsm      
#define  ctrsm_	   ctrsm      
#define  ztrsm_	   ztrsm
#define  dgemmt_   dgemmt      

#define csrot_ csrot
#define cgbmv_ cgbmv
#define ctbsv_ ctbsv
#define dsbmv_ dsbmv
#define dspmv_ dspmv
#define ctpsv_ ctpsv
#define chpmv_ chpmv
#define ctpmv_ ctpmv
#define chpr2_ chpr2
#define chpr_ chpr
#define chbmv_ chbmv
#define ctbmv_ ctbmv
#define drot_ drot
#define dgbmv_ dgbmv
#define dtbsv_ dtbsv
#define drotm_ drotm
#define dtpsv_ dtpsv
#define dspr_ dspr
#define dtpmv_ dtpmv
#define dspr2_ dspr2
#define dtbmv_ dtbmv
#define srot_ srot
#define sgbmv_ sgbmv
#define stbsv_ stbsv
#define srotm_ srotm
#define stpsv_  stpsv
#define ssbmv_	ssbmv
#define sspmv_	sspmv
#define sspr_	sspr
#define stpmv_	stpmv
#define sspr2_	sspr2
#define stbmv_	stbmv
#define zdrot_	zdrot
#define zgbmv_	zgbmv
#define ztbsv_	ztbsv
#define ztpsv_	ztpsv
#define zhpmv_	zhpmv
#define ztpmv_	ztpmv
#define zhpr2_	zhpr2
#define zhpr_	zhpr
#define zhbmv_	zhbmv
#define ztbmv_	ztbmv

#define cbbcsd_                  cbbcsd              
#define cbdsqr_                  cbdsqr 
#define cgbbrd_                  cgbbrd 
#define cgbcon_                  cgbcon  
#define cgbequ_                  cgbequ 
#define cgbequb_                 cgbequb 
#define cgbrfs_                  cgbrfs 
#define cgbsv_                   cgbsv 
#define cgbsvx_                  cgbsvx 
#define cgbtf2_                  cgbtf2 
#define cgbtrf_                  cgbtrf 
#define cgbtrs_                  cgbtrs 
#define cgebak_                  cgebak 
#define cgebal_                  cgebal 
#define cgebd2_                  cgebd2 
#define cgebrd_                  cgebrd 
#define cgecon_                  cgecon 
#define cgeequ_                  cgeequ 
#define cgeequb_                 cgeequb 
#define cgees_                   cgees 
#define cgeesx_                  cgeesx 
#define cgeev_                   cgeev 
#define cgeevx_                  cgeevx 
#define cgegs_                   cgegs 
#define cgegv_                   cgegv 
#define cgehd2_                  cgehd2 
#define cgehrd_                  cgehrd 
#define cgejsv_                  cgejsv 
#define cgelq2_                  cgelq2 
#define cgelq_                   cgelq 
#define cgelqf_                  cgelqf 
#define cgelqt3_                 cgelqt3 
#define cgelqt_                  cgelqt 
#define cgels_                   cgels 
#define cgelsd_                  cgelsd 
#define cgelss_                  cgelss 
#define cgelsx_                  cgelsx 
#define cgelsy_                  cgelsy 
#define cgemlq_                  cgemlq 
#define cgemlqt_                 cgemlqt 
#define cgemqr_                  cgemqr 
#define cgemqrt_                 cgemqrt 
#define cgeql2_                  cgeql2 
#define cgeqlf_                  cgeqlf 
#define cgeqp3_                  cgeqp3 
#define cgeqpf_                  cgeqpf 
#define cgeqr2_                  cgeqr2 
#define cgeqr2p_                 cgeqr2p 
#define cgeqr_                   cgeqr 
#define cgeqrf_                  cgeqrf 
#define cgeqrfp_                 cgeqrfp 
#define cgeqrt2_                 cgeqrt2 
#define cgeqrt3_                 cgeqrt3 
#define cgeqrt_                  cgeqrt 
#define cgerfs_                  cgerfs 
#define cgerq2_                  cgerq2 
#define cgerqf_                  cgerqf 
#define cgesc2_                  cgesc2 
#define cgesdd_                  cgesdd 
#define cgesv_                   cgesv 
#define cgesvd_                  cgesvd 
#define cgesvdq_                 cgesvdq 
#define cgesvdx_                 cgesvdx 
#define cgesvj_                  cgesvj 
#define cgesvx_                  cgesvx 
#define cgetc2_                  cgetc2 
#define cgetf2_                  cgetf2 
#define cgetrf2_                 cgetrf2 
#define cgetrf_                  cgetrf 
#define cgetri_                  cgetri 
#define cgetrs_                  cgetrs 
#define cgetsls_                 cgetsls 
#define cggbak_                  cggbak 
#define cggbal_                  cggbal 
#define cgges3_                  cgges3 
#define cgges_                   cgges 
#define cggesx_                  cggesx 
#define cggev3_                  cggev3 
#define cggev_                   cggev 
#define cggevx_                  cggevx 
#define cggglm_                  cggglm 
#define cgghd3_                  cgghd3 
#define cgghrd_                  cgghrd 
#define cgglse_                  cgglse 
#define cggqrf_                  cggqrf 
#define cggrqf_                  cggrqf 
#define cggsvd3_                 cggsvd3 
#define cggsvd_                  cggsvd 
#define cggsvp3_                 cggsvp3 
#define cggsvp_                  cggsvp 
#define cgsvj0_                  cgsvj0 
#define cgsvj1_                  cgsvj1 
#define cgtcon_                  cgtcon 
#define cgtrfs_                  cgtrfs 
#define cgtsv_                   cgtsv 
#define cgtsvx_                  cgtsvx 
#define cgttrf_                  cgttrf 
#define cgttrs_                  cgttrs 
#define cgtts2_                  cgtts2 
#define chb2st_kernels_          chb2st_kernels 
#define chbev_                   chbev 
#define chbev_2stage_            chbev_2stage 
#define chbevd_                  chbevd 
#define chbevd_2stage_           chbevd_2stage 
#define chbevx_                  chbevx 
#define chbevx_2stage_           chbevx_2stage 
#define chbgst_                  chbgst 
#define chbgv_                   chbgv 
#define chbgvd_                  chbgvd 
#define chbgvx_                  chbgvx 
#define chbtrd_                  chbtrd 
#define checon_                  checon 
#define checon_3_                checon_3 
#define checon_rook_             checon_rook 
#define cheequb_                 cheequb 
#define cheev_                   cheev 
#define cheev_2stage_            cheev_2stage 
#define cheevd_                  cheevd 
#define cheevd_2stage_           cheevd_2stage 
#define cheevr_                  cheevr 
#define cheevr_2stage_           cheevr_2stage 
#define cheevx_                  cheevx 
#define cheevx_2stage_           cheevx_2stage 
#define chegs2_                  chegs2 
#define chegst_                  chegst 
#define chegv_                   chegv 
#define chegv_2stage_            chegv_2stage 
#define chegvd_                  chegvd 
#define chegvx_                  chegvx 
#define cherfs_                  cherfs 
#define chesv_                   chesv 
#define chesv_aa_                chesv_aa 
#define chesv_aa_2stage_         chesv_aa_2stage 
#define chesv_rk_                chesv_rk 
#define chesv_rook_              chesv_rook 
#define chesvx_                  chesvx 
#define cheswapr_                cheswapr 
#define chetd2_                  chetd2 
#define chetf2_                  chetf2 
#define chetf2_rk_               chetf2_rk 
#define chetf2_rook_             chetf2_rook 
#define chetrd_                  chetrd 
#define chetrd_2stage_           chetrd_2stage 
#define chetrd_hb2st_            chetrd_hb2st 
#define chetrd_he2hb_            chetrd_he2hb 
#define chetrf_                  chetrf 
#define chetrf_aa_               chetrf_aa 
#define chetrf_aa_2stage_        chetrf_aa_2stage 
#define chetrf_rk_               chetrf_rk 
#define chetrf_rook_             chetrf_rook 
#define chetri2_                 chetri2 
#define chetri2x_                chetri2x 
#define chetri_                  chetri 
#define chetri_3_                chetri_3 
#define chetri_3x_               chetri_3x 
#define chetri_rook_             chetri_rook 
#define chetrs2_                 chetrs2 
#define chetrs_                  chetrs 
#define chetrs_3_                chetrs_3 
#define chetrs_aa_               chetrs_aa 
#define chetrs_aa_2stage_        chetrs_aa_2stage 
#define chetrs_rook_             chetrs_rook 
#define chfrk_                   chfrk 
#define chgeqz_                  chgeqz 
#define chla_transtype_          chla_transtype 
#define chpcon_                  chpcon 
#define chpev_                   chpev 
#define chpevd_                  chpevd 
#define chpevx_                  chpevx 
#define chpgst_                  chpgst 
#define chpgv_                   chpgv 
#define chpgvd_                  chpgvd 
#define chpgvx_                  chpgvx 
#define chprfs_                  chprfs 
#define chpsv_                   chpsv 
#define chpsvx_                  chpsvx 
#define chptrd_                  chptrd 
#define chptrf_                  chptrf 
#define chptri_                  chptri 
#define chptrs_                  chptrs 
#define chsein_                  chsein 
#define chseqr_                  chseqr 
#define cla_gbamv_               cla_gbamv 
#define cla_gbrcond_c_           cla_gbrcond_c 
#define cla_gbrcond_x_           cla_gbrcond_x 
#define cla_gbrpvgrw_            cla_gbrpvgrw 
#define cla_geamv_               cla_geamv 
#define cla_gercond_c_           cla_gercond_c 
#define cla_gercond_x_           cla_gercond_x 
#define cla_gerpvgrw_            cla_gerpvgrw 
#define cla_heamv_               cla_heamv 
#define cla_hercond_c_           cla_hercond_c 
#define cla_hercond_x_           cla_hercond_x 
#define cla_herpvgrw_            cla_herpvgrw 
#define cla_lin_berr_            cla_lin_berr 
#define cla_porcond_c_           cla_porcond_c 
#define cla_porcond_x_           cla_porcond_x 
#define cla_porpvgrw_            cla_porpvgrw 
#define cla_syamv_               cla_syamv 
#define cla_syrcond_c_           cla_syrcond_c 
#define cla_syrcond_x_           cla_syrcond_x 
#define cla_syrpvgrw_            cla_syrpvgrw 
#define cla_wwaddw_              cla_wwaddw 
#define clabrd_                  clabrd 
#define clacgv_                  clacgv 
#define clacn2_                  clacn2 
#define clacon_                  clacon 
#define clacp2_                  clacp2 
#define clacpy_                  clacpy 
#define clacrm_                  clacrm 
#define clacrt_                  clacrt 
#define cladiv_                  cladiv 
#define claed0_                  claed0 
#define claed7_                  claed7 
#define claed8_                  claed8 
#define claein_                  claein 
#define claesy_                  claesy 
#define claev2_                  claev2 
#define clag2z_                  clag2z 
#define clags2_                  clags2 
#define clagtm_                  clagtm 
#define clahef_                  clahef 
#define clahef_aa_               clahef_aa 
#define clahef_rk_               clahef_rk 
#define clahef_rook_             clahef_rook 
#define clahqr_                  clahqr 
#define clahr2_                  clahr2 
#define clahrd_                  clahrd 
#define claic1_                  claic1 
#define clals0_                  clals0 
#define clalsa_                  clalsa 
#define clalsd_                  clalsd 
#define clamswlq_                clamswlq 
#define clamtsqr_                clamtsqr 
#define clangb_                  clangb 
#define clange_                  clange 
#define clangt_                  clangt 
#define clanhb_                  clanhb 
#define clanhe_                  clanhe 
#define clanhf_                  clanhf 
#define clanhp_                  clanhp 
#define clanhs_                  clanhs 
#define clanht_                  clanht 
#define clansb_                  clansb 
#define clansp_                  clansp 
#define clansy_                  clansy 
#define clantb_                  clantb 
#define clantp_                  clantp 
#define clantr_                  clantr 
#define clapll_                  clapll 
#define clapmr_                  clapmr 
#define clapmt_                  clapmt 
#define claqgb_                  claqgb 
#define claqge_                  claqge 
#define claqhb_                  claqhb 
#define claqhe_                  claqhe 
#define claqhp_                  claqhp 
#define claqp2_                  claqp2 
#define claqps_                  claqps 
#define claqr0_                  claqr0 
#define claqr1_                  claqr1 
#define claqr2_                  claqr2 
#define claqr3_                  claqr3 
#define claqr4_                  claqr4 
#define claqr5_                  claqr5 
#define claqsb_                  claqsb 
#define claqsp_                  claqsp 
#define claqsy_                  claqsy 
#define clar1v_                  clar1v 
#define clar2v_                  clar2v 
#define clarcm_                  clarcm 
#define clarf_                   clarf 
#define clarfb_                  clarfb 
#define clarfg_                  clarfg 
#define clarfgp_                 clarfgp 
#define clarft_                  clarft 
#define clarfx_                  clarfx 
#define clarfy_                  clarfy 
#define clargv_                  clargv 
#define clarnv_                  clarnv 
#define clarrv_                  clarrv 
#define clarscl2_                clarscl2 
#define clartg_                  clartg 
#define clartv_                  clartv 
#define clarz_                   clarz 
#define clarzb_                  clarzb 
#define clarzt_                  clarzt 
#define clascl2_                 clascl2 
#define clascl_                  clascl 
#define claset_                  claset 
#define clasr_                   clasr 
#define classq_                  classq 
#define claswlq_                 claswlq 
#define claswp_                  claswp 
#define clasyf_                  clasyf 
#define clasyf_aa_               clasyf_aa 
#define clasyf_rk_               clasyf_rk 
#define clasyf_rook_             clasyf_rook 
#define clatbs_                  clatbs 
#define clatdf_                  clatdf 
#define clatps_                  clatps 
#define clatrd_                  clatrd 
#define clatrs_                  clatrs 
#define clatrz_                  clatrz 
#define clatsqr_                 clatsqr 
#define clatzm_                  clatzm 
#define claunhr_col_getrfnp2_    claunhr_col_getrfnp2 
#define claunhr_col_getrfnp_     claunhr_col_getrfnp 
#define clauu2_                  clauu2 
#define clauum_                  clauum 
#define cpbcon_                  cpbcon 
#define cpbequ_                  cpbequ 
#define cpbrfs_                  cpbrfs 
#define cpbstf_                  cpbstf 
#define cpbsv_                   cpbsv 
#define cpbsvx_                  cpbsvx 
#define cpbtf2_                  cpbtf2 
#define cpbtrf_                  cpbtrf 
#define cpbtrs_                  cpbtrs 
#define cpftrf_                  cpftrf 
#define cpftri_                  cpftri 
#define cpftrs_                  cpftrs 
#define cpocon_                  cpocon 
#define cpoequ_                  cpoequ 
#define cpoequb_                 cpoequb 
#define cporfs_                  cporfs 
#define cposv_                   cposv 
#define cposvx_                  cposvx 
#define cpotf2_                  cpotf2 
#define cpotrf2_                 cpotrf2 
#define cpotrf_                  cpotrf 
#define cpotri_                  cpotri 
#define cpotrs_                  cpotrs 
#define cppcon_                  cppcon 
#define cppequ_                  cppequ 
#define cpprfs_                  cpprfs 
#define cppsv_                   cppsv 
#define cppsvx_                  cppsvx 
#define cpptrf_                  cpptrf 
#define cpptri_                  cpptri 
#define cpptrs_                  cpptrs 
#define cpstf2_                  cpstf2 
#define cpstrf_                  cpstrf 
#define cptcon_                  cptcon 
#define cpteqr_                  cpteqr 
#define cptrfs_                  cptrfs 
#define cptsv_                   cptsv 
#define cptsvx_                  cptsvx 
#define cpttrf_                  cpttrf 
#define cpttrs_                  cpttrs 
#define cptts2_                  cptts2 
#define crot_                    crot 
#define cspcon_                  cspcon 
#define cspmv_                   cspmv 
#define cspr_                    cspr 
#define csprfs_                  csprfs 
#define cspsv_                   cspsv 
#define cspsvx_                  cspsvx 
#define csptrf_                  csptrf 
#define csptri_                  csptri 
#define csptrs_                  csptrs 
#define csrscl_                  csrscl 
#define cstedc_                  cstedc 
#define cstegr_                  cstegr 
#define cstein_                  cstein 
#define cstemr_                  cstemr 
#define csteqr_                  csteqr 
#define csycon_                  csycon 
#define csycon_3_                csycon_3 
#define csycon_rook_             csycon_rook 
#define csyconv_                 csyconv 
#define csyconvf_                csyconvf 
#define csyconvf_rook_           csyconvf_rook 
#define csyequb_                 csyequb 
#define csymv_                   csymv 
#define csyr_                    csyr 
#define csyrfs_                  csyrfs 
#define csysv_                   csysv 
#define csysv_aa_                csysv_aa 
#define csysv_aa_2stage_         csysv_aa_2stage 
#define csysv_rk_                csysv_rk 
#define csysv_rook_              csysv_rook 
#define csysvx_                  csysvx 
#define csyswapr_                csyswapr 
#define csytf2_                  csytf2 
#define csytf2_rk_               csytf2_rk 
#define csytf2_rook_             csytf2_rook 
#define csytrf_                  csytrf 
#define csytrf_aa_               csytrf_aa 
#define csytrf_aa_2stage_        csytrf_aa_2stage 
#define csytrf_rk_               csytrf_rk 
#define csytrf_rook_             csytrf_rook 
#define csytri2_                 csytri2 
#define csytri2x_                csytri2x 
#define csytri_                  csytri 
#define csytri_3_                csytri_3 
#define csytri_3x_               csytri_3x 
#define csytri_rook_             csytri_rook 
#define csytrs2_                 csytrs2 
#define csytrs_                  csytrs 
#define csytrs_3_                csytrs_3 
#define csytrs_aa_               csytrs_aa 
#define csytrs_aa_2stage_        csytrs_aa_2stage 
#define csytrs_rook_             csytrs_rook 
#define ctbcon_                  ctbcon 
#define ctbrfs_                  ctbrfs 
#define ctbtrs_                  ctbtrs 
#define ctfsm_                   ctfsm 
#define ctftri_                  ctftri 
#define ctfttp_                  ctfttp 
#define ctfttr_                  ctfttr 
#define ctgevc_                  ctgevc 
#define ctgex2_                  ctgex2 
#define ctgexc_                  ctgexc 
#define ctgsen_                  ctgsen 
#define ctgsja_                  ctgsja 
#define ctgsna_                  ctgsna 
#define ctgsy2_                  ctgsy2 
#define ctgsyl_                  ctgsyl 
#define ctpcon_                  ctpcon 
#define ctplqt2_                 ctplqt2 
#define ctplqt_                  ctplqt 
#define ctpmlqt_                 ctpmlqt 
#define ctpmqrt_                 ctpmqrt 
#define ctpqrt2_                 ctpqrt2 
#define ctpqrt_                  ctpqrt 
#define ctprfb_                  ctprfb 
#define ctprfs_                  ctprfs 
#define ctptri_                  ctptri 
#define ctptrs_                  ctptrs 
#define ctpttf_                  ctpttf 
#define ctpttr_                  ctpttr 
#define ctrcon_                  ctrcon 
#define ctrevc3_                 ctrevc3 
#define ctrevc_                  ctrevc 
#define ctrexc_                  ctrexc 
#define ctrrfs_                  ctrrfs 
#define ctrsen_                  ctrsen 
#define ctrsna_                  ctrsna 
#define ctrsyl_                  ctrsyl 
#define ctrti2_                  ctrti2 
#define ctrtri_                  ctrtri 
#define ctrtrs_                  ctrtrs 
#define ctrttf_                  ctrttf 
#define ctrttp_                  ctrttp 
#define ctzrqf_                  ctzrqf 
#define ctzrzf_                  ctzrzf 
#define cunbdb1_                 cunbdb1 
#define cunbdb2_                 cunbdb2 
#define cunbdb3_                 cunbdb3 
#define cunbdb4_                 cunbdb4 
#define cunbdb5_                 cunbdb5 
#define cunbdb6_                 cunbdb6 
#define cunbdb_                  cunbdb 
#define cuncsd2by1_              cuncsd2by1 
#define cuncsd_                  cuncsd 
#define cung2l_                  cung2l 
#define cung2r_                  cung2r 
#define cungbr_                  cungbr 
#define cunghr_                  cunghr 
#define cungl2_                  cungl2 
#define cunglq_                  cunglq 
#define cungql_                  cungql 
#define cungqr_                  cungqr 
#define cungr2_                  cungr2 
#define cungrq_                  cungrq 
#define cungtr_                  cungtr 
#define cungtsqr_                cungtsqr 
#define cunhr_col_               cunhr_col 
#define cunm22_                  cunm22 
#define cunm2l_                  cunm2l 
#define cunm2r_                  cunm2r 
#define cunmbr_                  cunmbr 
#define cunmhr_                  cunmhr 
#define cunml2_                  cunml2 
#define cunmlq_                  cunmlq 
#define cunmql_                  cunmql 
#define cunmqr_                  cunmqr 
#define cunmr2_                  cunmr2 
#define cunmr3_                  cunmr3 
#define cunmrq_                  cunmrq 
#define cunmrz_                  cunmrz 
#define cunmtr_                  cunmtr 
#define cupgtr_                  cupgtr 
#define cupmtr_                  cupmtr 
#define dbbcsd_                  dbbcsd 
#define dbdsdc_                  dbdsdc 
#define dbdsqr_                  dbdsqr 
#define dbdsvdx_                 dbdsvdx 
#define dcombssq_                dcombssq 
#define ddisna_                  ddisna 
#define dgbbrd_                  dgbbrd 
#define dgbcon_                  dgbcon 
#define dgbequ_                  dgbequ 
#define dgbequb_                 dgbequb 
#define dgbrfs_                  dgbrfs 
#define dgbsv_                   dgbsv 
#define dgbsvx_                  dgbsvx 
#define dgbtf2_                  dgbtf2 
#define dgbtrf_                  dgbtrf 
#define dgbtrs_                  dgbtrs 
#define dgebak_                  dgebak 
#define dgebal_                  dgebal 
#define dgebd2_                  dgebd2 
#define dgebrd_                  dgebrd 
#define dgecon_                  dgecon 
#define dgeequ_                  dgeequ 
#define dgeequb_                 dgeequb 
#define dgees_                   dgees 
#define dgeesx_                  dgeesx 
#define dgeev_                   dgeev 
#define dgeevx_                  dgeevx 
#define dgegs_                   dgegs 
#define dgegv_                   dgegv 
#define dgehd2_                  dgehd2 
#define dgehrd_                  dgehrd 
#define dgejsv_                  dgejsv 
#define dgelq2_                  dgelq2 
#define dgelq_                   dgelq 
#define dgelqf_                  dgelqf 
#define dgelqt3_                 dgelqt3 
#define dgelqt_                  dgelqt 
#define dgels_                   dgels 
#define dgelsd_                  dgelsd 
#define dgelss_                  dgelss 
#define dgelsx_                  dgelsx 
#define dgelsy_                  dgelsy 
#define dgemlq_                  dgemlq 
#define dgemlqt_                 dgemlqt 
#define dgemqr_                  dgemqr 
#define dgemqrt_                 dgemqrt 
#define dgeql2_                  dgeql2 
#define dgeqlf_                  dgeqlf 
#define dgeqp3_                  dgeqp3 
#define dgeqpf_                  dgeqpf 
#define dgeqr2_                  dgeqr2 
#define dgeqr2p_                 dgeqr2p 
#define dgeqr_                   dgeqr 
#define dgeqrf_                  dgeqrf 
#define dgeqrfp_                 dgeqrfp 
#define dgeqrt2_                 dgeqrt2 
#define dgeqrt3_                 dgeqrt3 
#define dgeqrt_                  dgeqrt 
#define dgerfs_                  dgerfs 
#define dgerq2_                  dgerq2 
#define dgerqf_                  dgerqf 
#define dgesc2_                  dgesc2 
#define dgesdd_                  dgesdd 
#define dgesv_                   dgesv 
#define dgesvd_                  dgesvd 
#define dgesvdq_                 dgesvdq 
#define dgesvdx_                 dgesvdx 
#define dgesvj_                  dgesvj 
#define dgesvx_                  dgesvx 
#define dgetc2_                  dgetc2 
#define dgetf2_                  dgetf2 
#define dgetrf2_                 dgetrf2 
#define dgetrf_                  dgetrf 
#define dgetri_                  dgetri 
#define dgetrs_                  dgetrs 
#define dgetsls_                 dgetsls 
#define dggbak_                  dggbak 
#define dggbal_                  dggbal 
#define dgges3_                  dgges3 
#define dgges_                   dgges 
#define dggesx_                  dggesx 
#define dggev3_                  dggev3 
#define dggev_                   dggev 
#define dggevx_                  dggevx 
#define dggglm_                  dggglm 
#define dgghd3_                  dgghd3 
#define dgghrd_                  dgghrd 
#define dgglse_                  dgglse 
#define dggqrf_                  dggqrf 
#define dggrqf_                  dggrqf 
#define dggsvd3_                 dggsvd3 
#define dggsvd_                  dggsvd 
#define dggsvp3_                 dggsvp3 
#define dggsvp_                  dggsvp 
#define dgsvj0_                  dgsvj0 
#define dgsvj1_                  dgsvj1 
#define dgtcon_                  dgtcon 
#define dgtrfs_                  dgtrfs 
#define dgtsv_                   dgtsv 
#define dgtsvx_                  dgtsvx 
#define dgttrf_                  dgttrf 
#define dgttrs_                  dgttrs 
#define dgtts2_                  dgtts2 
#define dhgeqz_                  dhgeqz 
#define dhsein_                  dhsein 
#define dhseqr_                  dhseqr 
#define disnan_                  disnan 
#define dla_gbamv_               dla_gbamv 
#define dla_gbrcond_             dla_gbrcond 
#define dla_gbrpvgrw_            dla_gbrpvgrw 
#define dla_geamv_               dla_geamv 
#define dla_gercond_             dla_gercond 
#define dla_gerpvgrw_            dla_gerpvgrw 
#define dla_lin_berr_            dla_lin_berr 
#define dla_porcond_             dla_porcond 
#define dla_porpvgrw_            dla_porpvgrw 
#define dla_syamv_               dla_syamv 
#define dla_syrcond_             dla_syrcond 
#define dla_syrpvgrw_            dla_syrpvgrw 
#define dla_wwaddw_              dla_wwaddw 
#define dlabad_                  dlabad 
#define dlabrd_                  dlabrd 
#define dlacn2_                  dlacn2 
#define dlacon_                  dlacon 
#define dlacpy_                  dlacpy 
#define dladiv1_                 dladiv1 
#define dladiv2_                 dladiv2 
#define dladiv_                  dladiv 
#define dlae2_                   dlae2 
#define dlaebz_                  dlaebz 
#define dlaed0_                  dlaed0 
#define dlaed1_                  dlaed1 
#define dlaed2_                  dlaed2 
#define dlaed3_                  dlaed3 
#define dlaed4_                  dlaed4 
#define dlaed5_                  dlaed5 
#define dlaed6_                  dlaed6 
#define dlaed7_                  dlaed7 
#define dlaed8_                  dlaed8 
#define dlaed9_                  dlaed9 
#define dlaeda_                  dlaeda 
#define dlaein_                  dlaein 
#define dlaev2_                  dlaev2 
#define dlaexc_                  dlaexc 
#define dlag2_                   dlag2 
#define dlag2s_                  dlag2s 
#define dlags2_                  dlags2 
#define dlagtf_                  dlagtf 
#define dlagtm_                  dlagtm 
#define dlagts_                  dlagts 
#define dlagv2_                  dlagv2 
#define dlahqr_                  dlahqr 
#define dlahr2_                  dlahr2 
#define dlahrd_                  dlahrd 
#define dlaic1_                  dlaic1 
#define dlaisnan_                dlaisnan 
#define dlaln2_                  dlaln2 
#define dlals0_                  dlals0 
#define dlalsa_                  dlalsa 
#define dlalsd_                  dlalsd 
#define dlamc3_                  dlamc3 
#define dlamch_                  dlamch 
#define dlamrg_                  dlamrg 
#define dlamswlq_                dlamswlq 
#define dlamtsqr_                dlamtsqr 
#define dlaneg_                  dlaneg 
#define dlangb_                  dlangb 
#define dlange_                  dlange 
#define dlangt_                  dlangt 
#define dlanhs_                  dlanhs 
#define dlansb_                  dlansb 
#define dlansf_                  dlansf 
#define dlansp_                  dlansp 
#define dlanst_                  dlanst 
#define dlansy_                  dlansy 
#define dlantb_                  dlantb 
#define dlantp_                  dlantp 
#define dlantr_                  dlantr 
#define dlanv2_                  dlanv2 
#define dlaorhr_col_getrfnp2_    dlaorhr_col_getrfnp2 
#define dlaorhr_col_getrfnp_     dlaorhr_col_getrfnp 
#define dlapll_                  dlapll 
#define dlapmr_                  dlapmr 
#define dlapmt_                  dlapmt 
#define dlapy2_                  dlapy2 
#define dlapy3_                  dlapy3 
#define dlaqgb_                  dlaqgb 
#define dlaqge_                  dlaqge 
#define dlaqp2_                  dlaqp2 
#define dlaqps_                  dlaqps 
#define dlaqr0_                  dlaqr0 
#define dlaqr1_                  dlaqr1 
#define dlaqr2_                  dlaqr2 
#define dlaqr3_                  dlaqr3 
#define dlaqr4_                  dlaqr4 
#define dlaqr5_                  dlaqr5 
#define dlaqsb_                  dlaqsb 
#define dlaqsp_                  dlaqsp 
#define dlaqsy_                  dlaqsy 
#define dlaqtr_                  dlaqtr 
#define dlar1v_                  dlar1v 
#define dlar2v_                  dlar2v 
#define dlarf_                   dlarf 
#define dlarfb_                  dlarfb 
#define dlarfg_                  dlarfg 
#define dlarfgp_                 dlarfgp 
#define dlarft_                  dlarft 
#define dlarfx_                  dlarfx 
#define dlarfy_                  dlarfy 
#define dlargv_                  dlargv 
#define dlarnv_                  dlarnv 
#define dlarra_                  dlarra 
#define dlarrb_                  dlarrb 
#define dlarrc_                  dlarrc 
#define dlarrd_                  dlarrd 
#define dlarre_                  dlarre 
#define dlarrf_                  dlarrf 
#define dlarrj_                  dlarrj 
#define dlarrk_                  dlarrk 
#define dlarrr_                  dlarrr 
#define dlarrv_                  dlarrv 
#define dlarscl2_                dlarscl2 
#define dlartg_                  dlartg 
#define dlartgp_                 dlartgp 
#define dlartgs_                 dlartgs 
#define dlartv_                  dlartv 
#define dlaruv_                  dlaruv 
#define dlarz_                   dlarz 
#define dlarzb_                  dlarzb 
#define dlarzt_                  dlarzt 
#define dlas2_                   dlas2 
#define dlascl2_                 dlascl2 
#define dlascl_                  dlascl 
#define dlasd0_                  dlasd0 
#define dlasd1_                  dlasd1 
#define dlasd2_                  dlasd2 
#define dlasd3_                  dlasd3 
#define dlasd4_                  dlasd4 
#define dlasd5_                  dlasd5 
#define dlasd6_                  dlasd6 
#define dlasd7_                  dlasd7 
#define dlasd8_                  dlasd8 
#define dlasda_                  dlasda 
#define dlasdq_                  dlasdq 
#define dlasdt_                  dlasdt 
#define dlaset_                  dlaset 
#define dlasq1_                  dlasq1 
#define dlasq2_                  dlasq2 
#define dlasq3_                  dlasq3 
#define dlasq4_                  dlasq4 
#define dlasq5_                  dlasq5 
#define dlasq6_                  dlasq6 
#define dlasr_                   dlasr 
#define dlasrt_                  dlasrt 
#define dlassq_                  dlassq 
#define dlasv2_                  dlasv2 
#define dlaswlq_                 dlaswlq 
#define dlaswp_                  dlaswp 
#define dlasy2_                  dlasy2 
#define dlasyf_                  dlasyf 
#define dlasyf_aa_               dlasyf_aa 
#define dlasyf_rk_               dlasyf_rk 
#define dlasyf_rook_             dlasyf_rook 
#define dlat2s_                  dlat2s 
#define dlatbs_                  dlatbs 
#define dlatdf_                  dlatdf 
#define dlatps_                  dlatps 
#define dlatrd_                  dlatrd 
#define dlatrs_                  dlatrs 
#define dlatrz_                  dlatrz 
#define dlatsqr_                 dlatsqr 
#define dlatzm_                  dlatzm 
#define dlauu2_                  dlauu2 
#define dlauum_                  dlauum 
#define dopgtr_                  dopgtr 
#define dopmtr_                  dopmtr 
#define dorbdb1_                 dorbdb1 
#define dorbdb2_                 dorbdb2 
#define dorbdb3_                 dorbdb3 
#define dorbdb4_                 dorbdb4 
#define dorbdb5_                 dorbdb5 
#define dorbdb6_                 dorbdb6 
#define dorbdb_                  dorbdb 
#define dorcsd2by1_              dorcsd2by1 
#define dorcsd_                  dorcsd 
#define dorg2l_                  dorg2l 
#define dorg2r_                  dorg2r 
#define dorgbr_                  dorgbr 
#define dorghr_                  dorghr 
#define dorgl2_                  dorgl2 
#define dorglq_                  dorglq 
#define dorgql_                  dorgql 
#define dorgqr_                  dorgqr 
#define dorgr2_                  dorgr2 
#define dorgrq_                  dorgrq 
#define dorgtr_                  dorgtr 
#define dorgtsqr_                dorgtsqr 
#define dorhr_col_               dorhr_col 
#define dorm22_                  dorm22 
#define dorm2l_                  dorm2l 
#define dorm2r_                  dorm2r 
#define dormbr_                  dormbr 
#define dormhr_                  dormhr 
#define dorml2_                  dorml2 
#define dormlq_                  dormlq 
#define dormql_                  dormql 
#define dormqr_                  dormqr 
#define dormr2_                  dormr2 
#define dormr3_                  dormr3 
#define dormrq_                  dormrq 
#define dormrz_                  dormrz 
#define dormtr_                  dormtr 
#define dpbcon_                  dpbcon 
#define dpbequ_                  dpbequ 
#define dpbrfs_                  dpbrfs 
#define dpbstf_                  dpbstf 
#define dpbsv_                   dpbsv 
#define dpbsvx_                  dpbsvx 
#define dpbtf2_                  dpbtf2 
#define dpbtrf_                  dpbtrf 
#define dpbtrs_                  dpbtrs 
#define dpftrf_                  dpftrf 
#define dpftri_                  dpftri 
#define dpftrs_                  dpftrs 
#define dpocon_                  dpocon 
#define dpoequ_                  dpoequ 
#define dpoequb_                 dpoequb 
#define dporfs_                  dporfs 
#define dposv_                   dposv 
#define dposvx_                  dposvx 
#define dpotf2_                  dpotf2 
#define dpotrf2_                 dpotrf2 
#define dpotrf_                  dpotrf 
#define dpotri_                  dpotri 
#define dpotrs_                  dpotrs 
#define dppcon_                  dppcon 
#define dppequ_                  dppequ 
#define dpprfs_                  dpprfs 
#define dppsv_                   dppsv 
#define dppsvx_                  dppsvx 
#define dpptrf_                  dpptrf 
#define dpptri_                  dpptri 
#define dpptrs_                  dpptrs 
#define dpstf2_                  dpstf2 
#define dpstrf_                  dpstrf 
#define dptcon_                  dptcon 
#define dpteqr_                  dpteqr 
#define dptrfs_                  dptrfs 
#define dptsv_                   dptsv 
#define dptsvx_                  dptsvx 
#define dpttrf_                  dpttrf 
#define dpttrs_                  dpttrs 
#define dptts2_                  dptts2 
#define drscl_                   drscl 
#define dsb2st_kernels_          dsb2st_kernels 
#define dsbev_                   dsbev 
#define dsbev_2stage_            dsbev_2stage 
#define dsbevd_                  dsbevd 
#define dsbevd_2stage_           dsbevd_2stage 
#define dsbevx_                  dsbevx 
#define dsbevx_2stage_           dsbevx_2stage 
#define dsbgst_                  dsbgst 
#define dsbgv_                   dsbgv 
#define dsbgvd_                  dsbgvd 
#define dsbgvx_                  dsbgvx 
#define dsbtrd_                  dsbtrd 
#define dsfrk_                   dsfrk 
#define dsgesv_                  dsgesv 
#define dspcon_                  dspcon 
#define dspev_                   dspev 
#define dspevd_                  dspevd 
#define dspevx_                  dspevx 
#define dspgst_                  dspgst 
#define dspgv_                   dspgv 
#define dspgvd_                  dspgvd 
#define dspgvx_                  dspgvx 
#define dsposv_                  dsposv 
#define dsprfs_                  dsprfs 
#define dspsv_                   dspsv 
#define dspsvx_                  dspsvx 
#define dsptrd_                  dsptrd 
#define dsptrf_                  dsptrf 
#define dsptri_                  dsptri 
#define dsptrs_                  dsptrs 
#define dstebz_                  dstebz 
#define dstedc_                  dstedc 
#define dstegr_                  dstegr 
#define dstein_                  dstein 
#define dstemr_                  dstemr 
#define dsteqr_                  dsteqr 
#define dsterf_                  dsterf 
#define dstev_                   dstev 
#define dstevd_                  dstevd 
#define dstevr_                  dstevr 
#define dstevx_                  dstevx 
#define dsycon_                  dsycon 
#define dsycon_3_                dsycon_3 
#define dsycon_rook_             dsycon_rook 
#define dsyconv_                 dsyconv 
#define dsyconvf_                dsyconvf 
#define dsyconvf_rook_           dsyconvf_rook 
#define dsyequb_                 dsyequb 
#define dsyev_                   dsyev 
#define dsyev_2stage_            dsyev_2stage 
#define dsyevd_                  dsyevd 
#define dsyevd_2stage_           dsyevd_2stage 
#define dsyevr_                  dsyevr 
#define dsyevr_2stage_           dsyevr_2stage 
#define dsyevx_                  dsyevx 
#define dsyevx_2stage_           dsyevx_2stage 
#define dsygs2_                  dsygs2 
#define dsygst_                  dsygst 
#define dsygv_                   dsygv 
#define dsygv_2stage_            dsygv_2stage 
#define dsygvd_                  dsygvd 
#define dsygvx_                  dsygvx 
#define dsyrfs_                  dsyrfs 
#define dsysv_                   dsysv 
#define dsysv_aa_                dsysv_aa 
#define dsysv_aa_2stage_         dsysv_aa_2stage 
#define dsysv_rk_                dsysv_rk 
#define dsysv_rook_              dsysv_rook 
#define dsysvx_                  dsysvx 
#define dsyswapr_                dsyswapr 
#define dsytd2_                  dsytd2 
#define dsytf2_                  dsytf2 
#define dsytf2_rk_               dsytf2_rk 
#define dsytf2_rook_             dsytf2_rook 
#define dsytrd_                  dsytrd 
#define dsytrd_2stage_           dsytrd_2stage 
#define dsytrd_sb2st_            dsytrd_sb2st 
#define dsytrd_sy2sb_            dsytrd_sy2sb 
#define dsytrf_                  dsytrf 
#define dsytrf_aa_               dsytrf_aa 
#define dsytrf_aa_2stage_        dsytrf_aa_2stage 
#define dsytrf_rk_               dsytrf_rk 
#define dsytrf_rook_             dsytrf_rook 
#define dsytri2_                 dsytri2 
#define dsytri2x_                dsytri2x 
#define dsytri_                  dsytri 
#define dsytri_3_                dsytri_3 
#define dsytri_3x_               dsytri_3x 
#define dsytri_rook_             dsytri_rook 
#define dsytrs2_                 dsytrs2 
#define dsytrs_                  dsytrs 
#define dsytrs_3_                dsytrs_3 
#define dsytrs_aa_               dsytrs_aa 
#define dsytrs_aa_2stage_        dsytrs_aa_2stage 
#define dsytrs_rook_             dsytrs_rook 
#define dtbcon_                  dtbcon 
#define dtbrfs_                  dtbrfs 
#define dtbtrs_                  dtbtrs 
#define dtfsm_                   dtfsm 
#define dtftri_                  dtftri 
#define dtfttp_                  dtfttp 
#define dtfttr_                  dtfttr 
#define dtgevc_                  dtgevc 
#define dtgex2_                  dtgex2 
#define dtgexc_                  dtgexc 
#define dtgsen_                  dtgsen 
#define dtgsja_                  dtgsja 
#define dtgsna_                  dtgsna 
#define dtgsy2_                  dtgsy2 
#define dtgsyl_                  dtgsyl 
#define dtpcon_                  dtpcon 
#define dtplqt2_                 dtplqt2 
#define dtplqt_                  dtplqt 
#define dtpmlqt_                 dtpmlqt 
#define dtpmqrt_                 dtpmqrt 
#define dtpqrt2_                 dtpqrt2 
#define dtpqrt_                  dtpqrt 
#define dtprfb_                  dtprfb 
#define dtprfs_                  dtprfs 
#define dtptri_                  dtptri 
#define dtptrs_                  dtptrs 
#define dtpttf_                  dtpttf 
#define dtpttr_                  dtpttr 
#define dtrcon_                  dtrcon 
#define dtrevc3_                 dtrevc3 
#define dtrevc_                  dtrevc 
#define dtrexc_                  dtrexc 
#define dtrrfs_                  dtrrfs 
#define dtrsen_                  dtrsen 
#define dtrsna_                  dtrsna 
#define dtrsyl_                  dtrsyl 
#define dtrti2_                  dtrti2 
#define dtrtri_                  dtrtri 
#define dtrtrs_                  dtrtrs 
#define dtrttf_                  dtrttf 
#define dtrttp_                  dtrttp 
#define dtzrqf_                  dtzrqf 
#define dtzrzf_                  dtzrzf 
#define dzsum1_                  dzsum1 
#define icmax1_                  icmax1 
#define ieeeck_                  ieeeck 
#define ilaclc_                  ilaclc 
#define ilaclr_                  ilaclr 
#define iladiag_                 iladiag 
#define iladlc_                  iladlc 
#define iladlr_                  iladlr 
#define ilaenv2stage_            ilaenv2stage 
#define ilaenv_                  ilaenv 
#define ilaprec_                 ilaprec 
#define ilaslc_                  ilaslc 
#define ilaslr_                  ilaslr 
#define ilatrans_                ilatrans 
#define ilauplo_                 ilauplo 
#define ilaver_                  ilaver 
#define ilazlc_                  ilazlc 
#define ilazlr_                  ilazlr 
#define iparam2stage_            iparam2stage 
#define iparmq_                  iparmq 
#define izmax1_                  izmax1 
#define lsamen_                  lsamen 
#define sbbcsd_                  sbbcsd 
#define sbdsdc_                  sbdsdc 
#define sbdsqr_                  sbdsqr 
#define sbdsvdx_                 sbdsvdx 
#define scombssq_                scombssq 
#define scsum1_                  scsum1 
#define sdisna_                  sdisna 
#define sgbbrd_                  sgbbrd 
#define sgbcon_                  sgbcon 
#define sgbequ_                  sgbequ 
#define sgbequb_                 sgbequb 
#define sgbrfs_                  sgbrfs 
#define sgbsv_                   sgbsv 
#define sgbsvx_                  sgbsvx 
#define sgbtf2_                  sgbtf2 
#define sgbtrf_                  sgbtrf 
#define sgbtrs_                  sgbtrs 
#define sgebak_                  sgebak 
#define sgebal_                  sgebal 
#define sgebd2_                  sgebd2 
#define sgebrd_                  sgebrd 
#define sgecon_                  sgecon 
#define sgeequ_                  sgeequ 
#define sgeequb_                 sgeequb 
#define sgees_                   sgees 
#define sgeesx_                  sgeesx 
#define sgeev_                   sgeev 
#define sgeevx_                  sgeevx 
#define sgegs_                   sgegs 
#define sgegv_                   sgegv 
#define sgehd2_                  sgehd2 
#define sgehrd_                  sgehrd 
#define sgejsv_                  sgejsv 
#define sgelq2_                  sgelq2 
#define sgelq_                   sgelq 
#define sgelqf_                  sgelqf 
#define sgelqt3_                 sgelqt3 
#define sgelqt_                  sgelqt 
#define sgels_                   sgels 
#define sgelsd_                  sgelsd 
#define sgelss_                  sgelss 
#define sgelsx_                  sgelsx 
#define sgelsy_                  sgelsy 
#define sgemlq_                  sgemlq 
#define sgemlqt_                 sgemlqt 
#define sgemqr_                  sgemqr 
#define sgemqrt_                 sgemqrt 
#define sgeql2_                  sgeql2 
#define sgeqlf_                  sgeqlf 
#define sgeqp3_                  sgeqp3 
#define sgeqpf_                  sgeqpf 
#define sgeqr2_                  sgeqr2 
#define sgeqr2p_                 sgeqr2p 
#define sgeqr_                   sgeqr 
#define sgeqrf_                  sgeqrf 
#define sgeqrfp_                 sgeqrfp 
#define sgeqrt2_                 sgeqrt2 
#define sgeqrt3_                 sgeqrt3 
#define sgeqrt_                  sgeqrt 
#define sgerfs_                  sgerfs 
#define sgerq2_                  sgerq2 
#define sgerqf_                  sgerqf 
#define sgesc2_                  sgesc2 
#define sgesdd_                  sgesdd 
#define sgesv_                   sgesv 
#define sgesvd_                  sgesvd 
#define sgesvdq_                 sgesvdq 
#define sgesvdx_                 sgesvdx 
#define sgesvj_                  sgesvj 
#define sgesvx_                  sgesvx 
#define sgetc2_                  sgetc2 
#define sgetf2_                  sgetf2 
#define sgetrf2_                 sgetrf2 
#define sgetrf_                  sgetrf 
#define sgetri_                  sgetri 
#define sgetrs_                  sgetrs 
#define sgetsls_                 sgetsls 
#define sggbak_                  sggbak 
#define sggbal_                  sggbal 
#define sgges3_                  sgges3 
#define sgges_                   sgges 
#define sggesx_                  sggesx 
#define sggev3_                  sggev3 
#define sggev_                   sggev 
#define sggevx_                  sggevx 
#define sggglm_                  sggglm 
#define sgghd3_                  sgghd3 
#define sgghrd_                  sgghrd 
#define sgglse_                  sgglse 
#define sggqrf_                  sggqrf 
#define sggrqf_                  sggrqf 
#define sggsvd3_                 sggsvd3 
#define sggsvd_                  sggsvd 
#define sggsvp3_                 sggsvp3 
#define sggsvp_                  sggsvp 
#define sgsvj0_                  sgsvj0 
#define sgsvj1_                  sgsvj1 
#define sgtcon_                  sgtcon 
#define sgtrfs_                  sgtrfs 
#define sgtsv_                   sgtsv 
#define sgtsvx_                  sgtsvx 
#define sgttrf_                  sgttrf 
#define sgttrs_                  sgttrs 
#define sgtts2_                  sgtts2 
#define shgeqz_                  shgeqz 
#define shsein_                  shsein 
#define shseqr_                  shseqr 
#define sisnan_                  sisnan 
#define sla_gbamv_               sla_gbamv 
#define sla_gbrcond_             sla_gbrcond 
#define sla_gbrpvgrw_            sla_gbrpvgrw 
#define sla_geamv_               sla_geamv 
#define sla_gercond_             sla_gercond 
#define sla_gerpvgrw_            sla_gerpvgrw 
#define sla_lin_berr_            sla_lin_berr 
#define sla_porcond_             sla_porcond 
#define sla_porpvgrw_            sla_porpvgrw 
#define sla_syamv_               sla_syamv 
#define sla_syrcond_             sla_syrcond 
#define sla_syrpvgrw_            sla_syrpvgrw 
#define sla_wwaddw_              sla_wwaddw 
#define slabad_                  slabad 
#define slabrd_                  slabrd 
#define slacn2_                  slacn2 
#define slacon_                  slacon 
#define slacpy_                  slacpy 
#define sladiv1_                 sladiv1 
#define sladiv2_                 sladiv2 
#define sladiv_                  sladiv 
#define slae2_                   slae2 
#define slaebz_                  slaebz 
#define slaed0_                  slaed0 
#define slaed1_                  slaed1 
#define slaed2_                  slaed2 
#define slaed3_                  slaed3 
#define slaed4_                  slaed4 
#define slaed5_                  slaed5 
#define slaed6_                  slaed6 
#define slaed7_                  slaed7 
#define slaed8_                  slaed8 
#define slaed9_                  slaed9 
#define slaeda_                  slaeda 
#define slaein_                  slaein 
#define slaev2_                  slaev2 
#define slaexc_                  slaexc 
#define slag2_                   slag2 
#define slag2d_                  slag2d 
#define slags2_                  slags2 
#define slagtf_                  slagtf 
#define slagtm_                  slagtm 
#define slagts_                  slagts 
#define slagv2_                  slagv2 
#define slahqr_                  slahqr 
#define slahr2_                  slahr2 
#define slahrd_                  slahrd 
#define slaic1_                  slaic1 
#define slaisnan_                slaisnan 
#define slaln2_                  slaln2 
#define slals0_                  slals0 
#define slalsa_                  slalsa 
#define slalsd_                  slalsd 
#define slamc3_                  slamc3 
#define slamch_                  slamch 
#define slamrg_                  slamrg 
#define slamswlq_                slamswlq 
#define slamtsqr_                slamtsqr 
#define slaneg_                  slaneg 
#define slangb_                  slangb 
#define slange_                  slange 
#define slangt_                  slangt 
#define slanhs_                  slanhs 
#define slansb_                  slansb 
#define slansf_                  slansf 
#define slansp_                  slansp 
#define slanst_                  slanst 
#define slansy_                  slansy 
#define slantb_                  slantb 
#define slantp_                  slantp 
#define slantr_                  slantr 
#define slanv2_                  slanv2 
#define slaorhr_col_getrfnp2_    slaorhr_col_getrfnp2 
#define slaorhr_col_getrfnp_     slaorhr_col_getrfnp 
#define slapll_                  slapll 
#define slapmr_                  slapmr 
#define slapmt_                  slapmt 
#define slapy2_                  slapy2 
#define slapy3_                  slapy3 
#define slaqgb_                  slaqgb 
#define slaqge_                  slaqge 
#define slaqp2_                  slaqp2 
#define slaqps_                  slaqps 
#define slaqr0_                  slaqr0 
#define slaqr1_                  slaqr1 
#define slaqr2_                  slaqr2 
#define slaqr3_                  slaqr3 
#define slaqr4_                  slaqr4 
#define slaqr5_                  slaqr5 
#define slaqsb_                  slaqsb 
#define slaqsp_                  slaqsp 
#define slaqsy_                  slaqsy 
#define slaqtr_                  slaqtr 
#define slar1v_                  slar1v 
#define slar2v_                  slar2v 
#define slarf_                   slarf 
#define slarfb_                  slarfb 
#define slarfg_                  slarfg 
#define slarfgp_                 slarfgp 
#define slarft_                  slarft 
#define slarfx_                  slarfx 
#define slarfy_                  slarfy 
#define slargv_                  slargv 
#define slarnv_                  slarnv 
#define slarra_                  slarra 
#define slarrb_                  slarrb 
#define slarrc_                  slarrc 
#define slarrd_                  slarrd 
#define slarre_                  slarre 
#define slarrf_                  slarrf 
#define slarrj_                  slarrj 
#define slarrk_                  slarrk 
#define slarrr_                  slarrr 
#define slarrv_                  slarrv 
#define slarscl2_                slarscl2 
#define slartg_                  slartg 
#define slartgp_                 slartgp 
#define slartgs_                 slartgs 
#define slartv_                  slartv 
#define slaruv_                  slaruv 
#define slarz_                   slarz 
#define slarzb_                  slarzb 
#define slarzt_                  slarzt 
#define slas2_                   slas2 
#define slascl2_                 slascl2 
#define slascl_                  slascl 
#define slasd0_                  slasd0 
#define slasd1_                  slasd1 
#define slasd2_                  slasd2 
#define slasd3_                  slasd3 
#define slasd4_                  slasd4 
#define slasd5_                  slasd5 
#define slasd6_                  slasd6 
#define slasd7_                  slasd7 
#define slasd8_                  slasd8 
#define slasda_                  slasda 
#define slasdq_                  slasdq 
#define slasdt_                  slasdt 
#define slaset_                  slaset 
#define slasq1_                  slasq1 
#define slasq2_                  slasq2 
#define slasq3_                  slasq3 
#define slasq4_                  slasq4 
#define slasq5_                  slasq5 
#define slasq6_                  slasq6 
#define slasr_                   slasr 
#define slasrt_                  slasrt 
#define slassq_                  slassq 
#define slasv2_                  slasv2 
#define slaswlq_                 slaswlq 
#define slaswp_                  slaswp 
#define slasy2_                  slasy2 
#define slasyf_                  slasyf 
#define slasyf_aa_               slasyf_aa 
#define slasyf_rk_               slasyf_rk 
#define slasyf_rook_             slasyf_rook 
#define slatbs_                  slatbs 
#define slatdf_                  slatdf 
#define slatps_                  slatps 
#define slatrd_                  slatrd 
#define slatrs_                  slatrs 
#define slatrz_                  slatrz 
#define slatsqr_                 slatsqr 
#define slatzm_                  slatzm 
#define slauu2_                  slauu2 
#define slauum_                  slauum 
#define sopgtr_                  sopgtr 
#define sopmtr_                  sopmtr 
#define sorbdb1_                 sorbdb1 
#define sorbdb2_                 sorbdb2 
#define sorbdb3_                 sorbdb3 
#define sorbdb4_                 sorbdb4 
#define sorbdb5_                 sorbdb5 
#define sorbdb6_                 sorbdb6 
#define sorbdb_                  sorbdb 
#define sorcsd2by1_              sorcsd2by1 
#define sorcsd_                  sorcsd 
#define sorg2l_                  sorg2l 
#define sorg2r_                  sorg2r 
#define sorgbr_                  sorgbr 
#define sorghr_                  sorghr 
#define sorgl2_                  sorgl2 
#define sorglq_                  sorglq 
#define sorgql_                  sorgql 
#define sorgqr_                  sorgqr 
#define sorgr2_                  sorgr2 
#define sorgrq_                  sorgrq 
#define sorgtr_                  sorgtr 
#define sorgtsqr_                sorgtsqr 
#define sorhr_col_               sorhr_col 
#define sorm22_                  sorm22 
#define sorm2l_                  sorm2l 
#define sorm2r_                  sorm2r 
#define sormbr_                  sormbr 
#define sormhr_                  sormhr 
#define sorml2_                  sorml2 
#define sormlq_                  sormlq 
#define sormql_                  sormql 
#define sormqr_                  sormqr 
#define sormr2_                  sormr2 
#define sormr3_                  sormr3 
#define sormrq_                  sormrq 
#define sormrz_                  sormrz 
#define sormtr_                  sormtr 
#define spbcon_                  spbcon 
#define spbequ_                  spbequ 
#define spbrfs_                  spbrfs 
#define spbstf_                  spbstf 
#define spbsv_                   spbsv 
#define spbsvx_                  spbsvx 
#define spbtf2_                  spbtf2 
#define spbtrf_                  spbtrf 
#define spbtrs_                  spbtrs 
#define spftrf_                  spftrf 
#define spftri_                  spftri 
#define spftrs_                  spftrs 
#define spocon_                  spocon 
#define spoequ_                  spoequ 
#define spoequb_                 spoequb 
#define sporfs_                  sporfs 
#define sposv_                   sposv 
#define sposvx_                  sposvx 
#define spotf2_                  spotf2 
#define spotrf2_                 spotrf2 
#define spotrf_                  spotrf 
#define spotri_                  spotri 
#define spotrs_                  spotrs 
#define sppcon_                  sppcon 
#define sppequ_                  sppequ 
#define spprfs_                  spprfs 
#define sppsv_                   sppsv 
#define sppsvx_                  sppsvx 
#define spptrf_                  spptrf 
#define spptri_                  spptri 
#define spptrs_                  spptrs 
#define spstf2_                  spstf2 
#define spstrf_                  spstrf 
#define sptcon_                  sptcon 
#define spteqr_                  spteqr 
#define sptrfs_                  sptrfs 
#define sptsv_                   sptsv 
#define sptsvx_                  sptsvx 
#define spttrf_                  spttrf 
#define spttrs_                  spttrs 
#define sptts2_                  sptts2 
#define srscl_                   srscl 
#define ssb2st_kernels_          ssb2st_kernels 
#define ssbev_                   ssbev 
#define ssbev_2stage_            ssbev_2stage 
#define ssbevd_                  ssbevd 
#define ssbevd_2stage_           ssbevd_2stage 
#define ssbevx_                  ssbevx 
#define ssbevx_2stage_           ssbevx_2stage 
#define ssbgst_                  ssbgst 
#define ssbgv_                   ssbgv 
#define ssbgvd_                  ssbgvd 
#define ssbgvx_                  ssbgvx 
#define ssbtrd_                  ssbtrd 
#define ssfrk_                   ssfrk 
#define sspcon_                  sspcon 
#define sspev_                   sspev 
#define sspevd_                  sspevd 
#define sspevx_                  sspevx 
#define sspgst_                  sspgst 
#define sspgv_                   sspgv 
#define sspgvd_                  sspgvd 
#define sspgvx_                  sspgvx 
#define ssprfs_                  ssprfs 
#define sspsv_                   sspsv 
#define sspsvx_                  sspsvx 
#define ssptrd_                  ssptrd 
#define ssptrf_                  ssptrf 
#define ssptri_                  ssptri 
#define ssptrs_                  ssptrs 
#define sstebz_                  sstebz 
#define sstedc_                  sstedc 
#define sstegr_                  sstegr 
#define sstein_                  sstein 
#define sstemr_                  sstemr 
#define ssteqr_                  ssteqr 
#define ssterf_                  ssterf 
#define sstev_                   sstev 
#define sstevd_                  sstevd 
#define sstevr_                  sstevr 
#define sstevx_                  sstevx 
#define ssycon_                  ssycon 
#define ssycon_3_                ssycon_3 
#define ssycon_rook_             ssycon_rook 
#define ssyconv_                 ssyconv 
#define ssyconvf_                ssyconvf 
#define ssyconvf_rook_           ssyconvf_rook 
#define ssyequb_                 ssyequb 
#define ssyev_                   ssyev 
#define ssyev_2stage_            ssyev_2stage 
#define ssyevd_                  ssyevd 
#define ssyevd_2stage_           ssyevd_2stage 
#define ssyevr_                  ssyevr 
#define ssyevr_2stage_           ssyevr_2stage 
#define ssyevx_                  ssyevx 
#define ssyevx_2stage_           ssyevx_2stage 
#define ssygs2_                  ssygs2 
#define ssygst_                  ssygst 
#define ssygv_                   ssygv 
#define ssygv_2stage_            ssygv_2stage 
#define ssygvd_                  ssygvd 
#define ssygvx_                  ssygvx 
#define ssyrfs_                  ssyrfs 
#define ssysv_                   ssysv 
#define ssysv_aa_                ssysv_aa 
#define ssysv_aa_2stage_         ssysv_aa_2stage 
#define ssysv_rk_                ssysv_rk 
#define ssysv_rook_              ssysv_rook 
#define ssysvx_                  ssysvx 
#define ssyswapr_                ssyswapr 
#define ssytd2_                  ssytd2 
#define ssytf2_                  ssytf2 
#define ssytf2_rk_               ssytf2_rk 
#define ssytf2_rook_             ssytf2_rook 
#define ssytrd_                  ssytrd 
#define ssytrd_2stage_           ssytrd_2stage 
#define ssytrd_sb2st_            ssytrd_sb2st 
#define ssytrd_sy2sb_            ssytrd_sy2sb 
#define ssytrf_                  ssytrf 
#define ssytrf_aa_               ssytrf_aa 
#define ssytrf_aa_2stage_        ssytrf_aa_2stage 
#define ssytrf_rk_               ssytrf_rk 
#define ssytrf_rook_             ssytrf_rook 
#define ssytri2_                 ssytri2 
#define ssytri2x_                ssytri2x 
#define ssytri_                  ssytri 
#define ssytri_3_                ssytri_3 
#define ssytri_3x_               ssytri_3x 
#define ssytri_rook_             ssytri_rook 
#define ssytrs2_                 ssytrs2 
#define ssytrs_                  ssytrs 
#define ssytrs_3_                ssytrs_3 
#define ssytrs_aa_               ssytrs_aa 
#define ssytrs_aa_2stage_        ssytrs_aa_2stage 
#define ssytrs_rook_             ssytrs_rook 
#define stbcon_                  stbcon 
#define stbrfs_                  stbrfs 
#define stbtrs_                  stbtrs 
#define stfsm_                   stfsm 
#define stftri_                  stftri 
#define stfttp_                  stfttp 
#define stfttr_                  stfttr 
#define stgevc_                  stgevc 
#define stgex2_                  stgex2 
#define stgexc_                  stgexc 
#define stgsen_                  stgsen 
#define stgsja_                  stgsja 
#define stgsna_                  stgsna 
#define stgsy2_                  stgsy2 
#define stgsyl_                  stgsyl 
#define stpcon_                  stpcon 
#define stplqt2_                 stplqt2 
#define stplqt_                  stplqt 
#define stpmlqt_                 stpmlqt 
#define stpmqrt_                 stpmqrt 
#define stpqrt2_                 stpqrt2 
#define stpqrt_                  stpqrt 
#define stprfb_                  stprfb 
#define stprfs_                  stprfs 
#define stptri_                  stptri 
#define stptrs_                  stptrs 
#define stpttf_                  stpttf 
#define stpttr_                  stpttr 
#define strcon_                  strcon 
#define strevc3_                 strevc3 
#define strevc_                  strevc 
#define strexc_                  strexc 
#define strrfs_                  strrfs 
#define strsen_                  strsen 
#define strsna_                  strsna 
#define strsyl_                  strsyl 
#define strti2_                  strti2 
#define strtri_                  strtri 
#define strtrs_                  strtrs 
#define strttf_                  strttf 
#define strttp_                  strttp 
#define stzrqf_                  stzrqf 
#define stzrzf_                  stzrzf 
#define xerbla_array_            xerbla_array
#define zbbcsd_                  zbbcsd 
#define zbdsqr_                  zbdsqr 
#define zcgesv_                  zcgesv 
#define zcposv_                  zcposv 
#define zdrscl_                  zdrscl 
#define zgbbrd_                  zgbbrd 
#define zgbcon_                  zgbcon 
#define zgbequ_                  zgbequ 
#define zgbequb_                 zgbequb 
#define zgbrfs_                  zgbrfs 
#define zgbsv_                   zgbsv 
#define zgbsvx_                  zgbsvx 
#define zgbtf2_                  zgbtf2 
#define zgbtrf_                  zgbtrf 
#define zgbtrs_                  zgbtrs 
#define zgebak_                  zgebak 
#define zgebal_                  zgebal 
#define zgebd2_                  zgebd2 
#define zgebrd_                  zgebrd 
#define zgecon_                  zgecon 
#define zgeequ_                  zgeequ 
#define zgeequb_                 zgeequb 
#define zgees_                   zgees 
#define zgeesx_                  zgeesx 
#define zgeev_                   zgeev 
#define zgeevx_                  zgeevx 
#define zgegs_                   zgegs 
#define zgegv_                   zgegv 
#define zgehd2_                  zgehd2 
#define zgehrd_                  zgehrd 
#define zgejsv_                  zgejsv 
#define zgelq2_                  zgelq2 
#define zgelq_                   zgelq 
#define zgelqf_                  zgelqf 
#define zgelqt3_                 zgelqt3 
#define zgelqt_                  zgelqt 
#define zgels_                   zgels 
#define zgelsd_                  zgelsd 
#define zgelss_                  zgelss 
#define zgelsx_                  zgelsx 
#define zgelsy_                  zgelsy 
#define zgemlq_                  zgemlq 
#define zgemlqt_                 zgemlqt 
#define zgemqr_                  zgemqr 
#define zgemqrt_                 zgemqrt 
#define zgeql2_                  zgeql2 
#define zgeqlf_                  zgeqlf 
#define zgeqp3_                  zgeqp3 
#define zgeqpf_                  zgeqpf 
#define zgeqr2_                  zgeqr2 
#define zgeqr2p_                 zgeqr2p 
#define zgeqr_                   zgeqr 
#define zgeqrf_                  zgeqrf 
#define zgeqrfp_                 zgeqrfp 
#define zgeqrt2_                 zgeqrt2 
#define zgeqrt3_                 zgeqrt3 
#define zgeqrt_                  zgeqrt 
#define zgerfs_                  zgerfs 
#define zgerq2_                  zgerq2 
#define zgerqf_                  zgerqf 
#define zgesc2_                  zgesc2 
#define zgesdd_                  zgesdd 
#define zgesv_                   zgesv 
#define zgesvd_                  zgesvd 
#define zgesvdq_                 zgesvdq 
#define zgesvdx_                 zgesvdx 
#define zgesvj_                  zgesvj 
#define zgesvx_                  zgesvx 
#define zgetc2_                  zgetc2 
#define zgetf2_                  zgetf2 
#define zgetrf2_                 zgetrf2 
#define zgetrf_                  zgetrf 
#define zgetri_                  zgetri 
#define zgetrs_                  zgetrs 
#define zgetsls_                 zgetsls 
#define zggbak_                  zggbak 
#define zggbal_                  zggbal 
#define zgges3_                  zgges3 
#define zgges_                   zgges 
#define zggesx_                  zggesx 
#define zggev3_                  zggev3 
#define zggev_                   zggev 
#define zggevx_                  zggevx 
#define zggglm_                  zggglm 
#define zgghd3_                  zgghd3 
#define zgghrd_                  zgghrd 
#define zgglse_                  zgglse 
#define zggqrf_                  zggqrf 
#define zggrqf_                  zggrqf 
#define zggsvd3_                 zggsvd3 
#define zggsvd_                  zggsvd 
#define zggsvp3_                 zggsvp3 
#define zggsvp_                  zggsvp 
#define zgsvj0_                  zgsvj0 
#define zgsvj1_                  zgsvj1 
#define zgtcon_                  zgtcon 
#define zgtrfs_                  zgtrfs 
#define zgtsv_                   zgtsv 
#define zgtsvx_                  zgtsvx 
#define zgttrf_                  zgttrf 
#define zgttrs_                  zgttrs 
#define zgtts2_                  zgtts2 
#define zhb2st_kernels_          zhb2st_kernels 
#define zhbev_                   zhbev 
#define zhbev_2stage_            zhbev_2stage 
#define zhbevd_                  zhbevd 
#define zhbevd_2stage_           zhbevd_2stage 
#define zhbevx_                  zhbevx 
#define zhbevx_2stage_           zhbevx_2stage 
#define zhbgst_                  zhbgst 
#define zhbgv_                   zhbgv 
#define zhbgvd_                  zhbgvd 
#define zhbgvx_                  zhbgvx 
#define zhbtrd_                  zhbtrd 
#define zhecon_                  zhecon 
#define zhecon_3_                zhecon_3 
#define zhecon_rook_             zhecon_rook 
#define zheequb_                 zheequb 
#define zheev_                   zheev 
#define zheev_2stage_            zheev_2stage 
#define zheevd_                  zheevd 
#define zheevd_2stage_           zheevd_2stage 
#define zheevr_                  zheevr 
#define zheevr_2stage_           zheevr_2stage 
#define zheevx_                  zheevx 
#define zheevx_2stage_           zheevx_2stage 
#define zhegs2_                  zhegs2 
#define zhegst_                  zhegst 
#define zhegv_                   zhegv 
#define zhegv_2stage_            zhegv_2stage 
#define zhegvd_                  zhegvd 
#define zhegvx_                  zhegvx 
#define zherfs_                  zherfs 
#define zhesv_                   zhesv 
#define zhesv_aa_                zhesv_aa 
#define zhesv_aa_2stage_         zhesv_aa_2stage 
#define zhesv_rk_                zhesv_rk 
#define zhesv_rook_              zhesv_rook 
#define zhesvx_                  zhesvx 
#define zheswapr_                zheswapr 
#define zhetd2_                  zhetd2 
#define zhetf2_                  zhetf2 
#define zhetf2_rk_               zhetf2_rk 
#define zhetf2_rook_             zhetf2_rook 
#define zhetrd_                  zhetrd 
#define zhetrd_2stage_           zhetrd_2stage 
#define zhetrd_hb2st_            zhetrd_hb2st 
#define zhetrd_he2hb_            zhetrd_he2hb 
#define zhetrf_                  zhetrf 
#define zhetrf_aa_               zhetrf_aa 
#define zhetrf_aa_2stage_        zhetrf_aa_2stage 
#define zhetrf_rk_               zhetrf_rk 
#define zhetrf_rook_             zhetrf_rook 
#define zhetri2_                 zhetri2 
#define zhetri2x_                zhetri2x 
#define zhetri_                  zhetri 
#define zhetri_3_                zhetri_3 
#define zhetri_3x_               zhetri_3x 
#define zhetri_rook_             zhetri_rook 
#define zhetrs2_                 zhetrs2 
#define zhetrs_                  zhetrs 
#define zhetrs_3_                zhetrs_3 
#define zhetrs_aa_               zhetrs_aa 
#define zhetrs_aa_2stage_        zhetrs_aa_2stage 
#define zhetrs_rook_             zhetrs_rook 
#define zhfrk_                   zhfrk 
#define zhgeqz_                  zhgeqz 
#define zhpcon_                  zhpcon 
#define zhpev_                   zhpev 
#define zhpevd_                  zhpevd 
#define zhpevx_                  zhpevx 
#define zhpgst_                  zhpgst 
#define zhpgv_                   zhpgv 
#define zhpgvd_                  zhpgvd 
#define zhpgvx_                  zhpgvx 
#define zhprfs_                  zhprfs 
#define zhpsv_                   zhpsv 
#define zhpsvx_                  zhpsvx 
#define zhptrd_                  zhptrd 
#define zhptrf_                  zhptrf 
#define zhptri_                  zhptri 
#define zhptrs_                  zhptrs 
#define zhsein_                  zhsein 
#define zhseqr_                  zhseqr 
#define zla_gbamv_               zla_gbamv 
#define zla_gbrcond_c_           zla_gbrcond_c 
#define zla_gbrcond_x_           zla_gbrcond_x 
#define zla_gbrpvgrw_            zla_gbrpvgrw 
#define zla_geamv_               zla_geamv 
#define zla_gercond_c_           zla_gercond_c 
#define zla_gercond_x_           zla_gercond_x 
#define zla_gerpvgrw_            zla_gerpvgrw 
#define zla_heamv_               zla_heamv 
#define zla_hercond_c_           zla_hercond_c 
#define zla_hercond_x_           zla_hercond_x 
#define zla_herpvgrw_            zla_herpvgrw 
#define zla_lin_berr_            zla_lin_berr 
#define zla_porcond_c_           zla_porcond_c 
#define zla_porcond_x_           zla_porcond_x 
#define zla_porpvgrw_            zla_porpvgrw 
#define zla_syamv_               zla_syamv 
#define zla_syrcond_c_           zla_syrcond_c 
#define zla_syrcond_x_           zla_syrcond_x 
#define zla_syrpvgrw_            zla_syrpvgrw 
#define zla_wwaddw_              zla_wwaddw 
#define zlabrd_                  zlabrd 
#define zlacgv_                  zlacgv 
#define zlacn2_                  zlacn2 
#define zlacon_                  zlacon 
#define zlacp2_                  zlacp2 
#define zlacpy_                  zlacpy 
#define zlacrm_                  zlacrm 
#define zlacrt_                  zlacrt 
#define zladiv_                  zladiv 
#define zlaed0_                  zlaed0 
#define zlaed7_                  zlaed7 
#define zlaed8_                  zlaed8 
#define zlaein_                  zlaein 
#define zlaesy_                  zlaesy 
#define zlaev2_                  zlaev2 
#define zlag2c_                  zlag2c 
#define zlags2_                  zlags2 
#define zlagtm_                  zlagtm 
#define zlahef_                  zlahef 
#define zlahef_aa_               zlahef_aa 
#define zlahef_rk_               zlahef_rk 
#define zlahef_rook_             zlahef_rook 
#define zlahqr_                  zlahqr 
#define zlahr2_                  zlahr2 
#define zlahrd_                  zlahrd 
#define zlaic1_                  zlaic1 
#define zlals0_                  zlals0 
#define zlalsa_                  zlalsa 
#define zlalsd_                  zlalsd 
#define zlamswlq_                zlamswlq 
#define zlamtsqr_                zlamtsqr 
#define zlangb_                  zlangb 
#define zlange_                  zlange 
#define zlangt_                  zlangt 
#define zlanhb_                  zlanhb 
#define zlanhe_                  zlanhe 
#define zlanhf_                  zlanhf 
#define zlanhp_                  zlanhp 
#define zlanhs_                  zlanhs 
#define zlanht_                  zlanht 
#define zlansb_                  zlansb 
#define zlansp_                  zlansp 
#define zlansy_                  zlansy 
#define zlantb_                  zlantb 
#define zlantp_                  zlantp 
#define zlantr_                  zlantr 
#define zlapll_                  zlapll 
#define zlapmr_                  zlapmr 
#define zlapmt_                  zlapmt 
#define zlaqgb_                  zlaqgb 
#define zlaqge_                  zlaqge 
#define zlaqhb_                  zlaqhb 
#define zlaqhe_                  zlaqhe 
#define zlaqhp_                  zlaqhp 
#define zlaqp2_                  zlaqp2 
#define zlaqps_                  zlaqps 
#define zlaqr0_                  zlaqr0 
#define zlaqr1_                  zlaqr1 
#define zlaqr2_                  zlaqr2 
#define zlaqr3_                  zlaqr3 
#define zlaqr4_                  zlaqr4 
#define zlaqr5_                  zlaqr5 
#define zlaqsb_                  zlaqsb 
#define zlaqsp_                  zlaqsp 
#define zlaqsy_                  zlaqsy 
#define zlar1v_                  zlar1v 
#define zlar2v_                  zlar2v 
#define zlarcm_                  zlarcm 
#define zlarf_                   zlarf 
#define zlarfb_                  zlarfb 
#define zlarfg_                  zlarfg 
#define zlarfgp_                 zlarfgp 
#define zlarft_                  zlarft 
#define zlarfx_                  zlarfx 
#define zlarfy_                  zlarfy 
#define zlargv_                  zlargv 
#define zlarnv_                  zlarnv 
#define zlarrv_                  zlarrv 
#define zlarscl2_                zlarscl2 
#define zlartg_                  zlartg 
#define zlartv_                  zlartv 
#define zlarz_                   zlarz 
#define zlarzb_                  zlarzb 
#define zlarzt_                  zlarzt 
#define zlascl2_                 zlascl2 
#define zlascl_                  zlascl 
#define zlaset_                  zlaset 
#define zlasr_                   zlasr 
#define zlassq_                  zlassq 
#define zlaswlq_                 zlaswlq 
#define zlaswp_                  zlaswp 
#define zlasyf_                  zlasyf 
#define zlasyf_aa_               zlasyf_aa 
#define zlasyf_rk_               zlasyf_rk 
#define zlasyf_rook_             zlasyf_rook 
#define zlat2c_                  zlat2c 
#define zlatbs_                  zlatbs 
#define zlatdf_                  zlatdf 
#define zlatps_                  zlatps 
#define zlatrd_                  zlatrd 
#define zlatrs_                  zlatrs 
#define zlatrz_                  zlatrz 
#define zlatsqr_                 zlatsqr 
#define zlatzm_                  zlatzm 
#define zlaunhr_col_getrfnp2_    zlaunhr_col_getrfnp2 
#define zlaunhr_col_getrfnp_     zlaunhr_col_getrfnp 
#define zlauu2_                  zlauu2 
#define zlauum_                  zlauum 
#define zpbcon_                  zpbcon 
#define zpbequ_                  zpbequ 
#define zpbrfs_                  zpbrfs 
#define zpbstf_                  zpbstf 
#define zpbsv_                   zpbsv 
#define zpbsvx_                  zpbsvx 
#define zpbtf2_                  zpbtf2 
#define zpbtrf_                  zpbtrf 
#define zpbtrs_                  zpbtrs 
#define zpftrf_                  zpftrf 
#define zpftri_                  zpftri 
#define zpftrs_                  zpftrs 
#define zpocon_                  zpocon 
#define zpoequ_                  zpoequ 
#define zpoequb_                 zpoequb 
#define zporfs_                  zporfs 
#define zposv_                   zposv 
#define zposvx_                  zposvx 
#define zpotf2_                  zpotf2 
#define zpotrf2_                 zpotrf2 
#define zpotrf_                  zpotrf 
#define zpotri_                  zpotri 
#define zpotrs_                  zpotrs 
#define zppcon_                  zppcon 
#define zppequ_                  zppequ 
#define zpprfs_                  zpprfs 
#define zppsv_                   zppsv 
#define zppsvx_                  zppsvx 
#define zpptrf_                  zpptrf 
#define zpptri_                  zpptri 
#define zpptrs_                  zpptrs 
#define zpstf2_                  zpstf2 
#define zpstrf_                  zpstrf 
#define zptcon_                  zptcon 
#define zpteqr_                  zpteqr 
#define zptrfs_                  zptrfs 
#define zptsv_                   zptsv 
#define zptsvx_                  zptsvx 
#define zpttrf_                  zpttrf 
#define zpttrs_                  zpttrs 
#define zptts2_                  zptts2 
#define zrot_                    zrot 
#define zspcon_                  zspcon 
#define zspmv_                   zspmv 
#define zspr_                    zspr 
#define zsprfs_                  zsprfs 
#define zspsv_                   zspsv 
#define zspsvx_                  zspsvx 
#define zsptrf_                  zsptrf 
#define zsptri_                  zsptri 
#define zsptrs_                  zsptrs 
#define zstedc_                  zstedc 
#define zstegr_                  zstegr 
#define zstein_                  zstein 
#define zstemr_                  zstemr 
#define zsteqr_                  zsteqr 
#define zsycon_                  zsycon 
#define zsycon_3_                zsycon_3 
#define zsycon_rook_             zsycon_rook 
#define zsyconv_                 zsyconv 
#define zsyconvf_                zsyconvf 
#define zsyconvf_rook_           zsyconvf_rook 
#define zsyequb_                 zsyequb 
#define zsymv_                   zsymv 
#define zsyr_                    zsyr 
#define zsyrfs_                  zsyrfs 
#define zsysv_                   zsysv 
#define zsysv_aa_                zsysv_aa 
#define zsysv_aa_2stage_         zsysv_aa_2stage 
#define zsysv_rk_                zsysv_rk 
#define zsysv_rook_              zsysv_rook 
#define zsysvx_                  zsysvx 
#define zsyswapr_                zsyswapr 
#define zsytf2_                  zsytf2 
#define zsytf2_rk_               zsytf2_rk 
#define zsytf2_rook_             zsytf2_rook 
#define zsytrf_                  zsytrf 
#define zsytrf_aa_               zsytrf_aa 
#define zsytrf_aa_2stage_        zsytrf_aa_2stage 
#define zsytrf_rk_               zsytrf_rk 
#define zsytrf_rook_             zsytrf_rook 
#define zsytri2_                 zsytri2 
#define zsytri2x_                zsytri2x 
#define zsytri_                  zsytri 
#define zsytri_3_                zsytri_3 
#define zsytri_3x_               zsytri_3x 
#define zsytri_rook_             zsytri_rook 
#define zsytrs2_                 zsytrs2 
#define zsytrs_                  zsytrs 
#define zsytrs_3_                zsytrs_3 
#define zsytrs_aa_               zsytrs_aa 
#define zsytrs_aa_2stage_        zsytrs_aa_2stage 
#define zsytrs_rook_             zsytrs_rook 
#define ztbcon_                  ztbcon 
#define ztbrfs_                  ztbrfs 
#define ztbtrs_                  ztbtrs 
#define ztfsm_                   ztfsm 
#define ztftri_                  ztftri 
#define ztfttp_                  ztfttp 
#define ztfttr_                  ztfttr 
#define ztgevc_                  ztgevc 
#define ztgex2_                  ztgex2 
#define ztgexc_                  ztgexc 
#define ztgsen_                  ztgsen 
#define ztgsja_                  ztgsja 
#define ztgsna_                  ztgsna 
#define ztgsy2_                  ztgsy2 
#define ztgsyl_                  ztgsyl 
#define ztpcon_                  ztpcon 
#define ztplqt2_                 ztplqt2 
#define ztplqt_                  ztplqt 
#define ztpmlqt_                 ztpmlqt 
#define ztpmqrt_                 ztpmqrt 
#define ztpqrt2_                 ztpqrt2 
#define ztpqrt_                  ztpqrt 
#define ztprfb_                  ztprfb 
#define ztprfs_                  ztprfs 
#define ztptri_                  ztptri 
#define ztptrs_                  ztptrs 
#define ztpttf_                  ztpttf 
#define ztpttr_                  ztpttr 
#define ztrcon_                  ztrcon 
#define ztrevc3_                 ztrevc3 
#define ztrevc_                  ztrevc 
#define ztrexc_                  ztrexc 
#define ztrrfs_                  ztrrfs 
#define ztrsen_                  ztrsen 
#define ztrsna_                  ztrsna 
#define ztrsyl_                  ztrsyl 
#define ztrti2_                  ztrti2 
#define ztrtri_                  ztrtri 
#define ztrtrs_                  ztrtrs 
#define ztrttf_                  ztrttf 
#define ztrttp_                  ztrttp 
#define ztzrqf_                  ztzrqf 
#define ztzrzf_                  ztzrzf 
#define zunbdb1_                 zunbdb1 
#define zunbdb2_                 zunbdb2 
#define zunbdb3_                 zunbdb3 
#define zunbdb4_                 zunbdb4 
#define zunbdb5_                 zunbdb5 
#define zunbdb6_                 zunbdb6 
#define zunbdb_                  zunbdb 
#define zuncsd2by1_              zuncsd2by1 
#define zuncsd_                  zuncsd 
#define zung2l_                  zung2l 
#define zung2r_                  zung2r 
#define zungbr_                  zungbr 
#define zunghr_                  zunghr 
#define zungl2_                  zungl2 
#define zunglq_                  zunglq 
#define zungql_                  zungql 
#define zungqr_                  zungqr 
#define zungr2_                  zungr2 
#define zungrq_                  zungrq 
#define zungtr_                  zungtr 
#define zungtsqr_                zungtsqr 
#define zunhr_col_               zunhr_col 
#define zunm22_                  zunm22 
#define zunm2l_                  zunm2l 
#define zunm2r_                  zunm2r 
#define zunmbr_                  zunmbr 
#define zunmhr_                  zunmhr 
#define zunml2_                  zunml2 
#define zunmlq_                  zunmlq 
#define zunmql_                  zunmql 
#define zunmqr_                  zunmqr 
#define zunmr2_                  zunmr2 
#define zunmr3_                  zunmr3 
#define zunmrq_                  zunmrq 
#define zunmrz_                  zunmrz 
#define zunmtr_                  zunmtr 
#define zupgtr_                  zupgtr 
#define zupmtr_                  zupmtr 
#define chla_transtype_          chla_transtype
#define disnan_                  disnan
#define dlaisnan_                dlaisnan
#define sisnan_                  sisnan
#define slaisnan_                slaisnan
#define cladiv_                  cladiv
#define zladiv_                  zladiv
#define sgetrfnp_                sgetrfnp
#define dgetrfnp_                dgetrfnp
#define cgetrfnp_                cgetrfnp
#define zgetrfnp_                zgetrfnp
#define sspffrt2_                sspffrt2
#define dspffrt2_                dspffrt2
#define cspffrt2_                cspffrt2
#define zspffrt2_                zspffrt2
#define sspffrtx_                sspffrtx
#define dspffrtx_                dspffrtx
#define cspffrtx_                cspffrtx
#define zspffrtx_                zspffrtx
#define sgetrfnpi_               sgetrfnpi
#define dgetrfnpi_               dgetrfnpi
#define cgetrfnpi_               cgetrfnpi
#define zgetrfnpi_               zgetrfnpi
#endif
#endif 
#endif
// end FLA_f2c.h

  // Include prototypes for BLAS-like interfaces
// begin blis1.h


#ifndef BLIS1_H
#define BLIS1_H

// Allow C++ users to include this header file in their source code. However,
// we make the extern "C" conditional on whether we're using a C++ compiler,
// since regular C compilers don't understand the extern "C" construct.
#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h> // skipped
#include <stdlib.h> // skipped
#include <math.h> // skipped

// begin FLA_config.h
//Determines to enable FLA_ENABLE_EXTRA_SYMBOLS
#define FLA_ENABLE_EXTRA_SYMBOLS    1

#ifdef FLA_ENABLE_EXTRA_SYMBOLS
#define F77_FUNC(name,NAME) name ## _
#define F77_FUNC_(name,NAME) name ## _
#endif

// --- General options ---------------------------------------------------------

// Determines whether to enable various segments of code identified as
// providing non-critical functionality.
#define FLA_ENABLE_NON_CRITICAL_CODE   1

//Determines to enable BuiltinBlas


//Enables blis1 use of flamalloc
#define FLA_ENABLE_BLIS1_USE_OF_FLA_MALLOC 1

// Determines whether the LAPACK compatibility layer is included in libflame.
// NOTE: If lapack2flame is enabled, external-lapack-for-subproblems MUST
// be disabled!
#define FLA_ENABLE_LAPACK2FLAME    1

// Determines whether ILP64 enabled. only enabled when -DENABLE_ILP64 is passed with cmake
#define  FLA_ENABLE_ILP64  1

// Determines whether to enable external LAPACK for small subproblems.
// NOTE: If external-lapack-for-subproblems is enabled, (a) lapack2flame MUST
// be disabled, AND (b) external-lapack-interfaces MUST be enabled.


// Determines whether to enable interfaces to external LAPACK routines.
// NOTE: If external-lapack-interfaces is enabled, an LAPACK library will be
// required at link-time.
#define FLA_ENABLE_EXTERNAL_LAPACK_INTERFACES  1

// Determines whether to use control trees to select a reasonable FLAME
// variant and blocksize when level-3 BLAS front-ends are invoked.


// Determines whether to modify various segments of code needed for
// integrating libflame into Windows.


// Determines whether to define a portable FLA_Clock() in terms of
// gettimeofday() from time.h.
#define FLA_ENABLE_PORTABLE_TIMER  1


// --- Runtime error checking and debugging ------------------------------------

// Determines whether to enable internal runtime consistency checks of
// function parameters and return values.
#define FLA_ENABLE_INTERNAL_ERROR_CHECKING 1

// Encodes the default level of internal error checking chosen at
// configure-time.
// 1-minimal error cheking
// 2-full error cheking
// 3-no error cheking
#define FLA_INTERNAL_ERROR_CHECKING_LEVEL 2   

// Determines whether to enable the FLA_malloc()/FLA_free() memory counter
// by default.



// --- Multithreading and SuperMatrix ------------------------------------------

// Determines whether thread-specific blocks of code should be compiled.


// Encodes the type of multithreading chosen at configure-time.
// 1 - openmp
// 2 - pthreads
#define FLA_MULTITHREADING_MODEL 1

// Determines whether SuperMatrix-specific blocks of code should be compiled.



// --- BLAS and blocksizes -----------------------------------------------------

// Determines whether to enable CBLAS interfaces instead of Fortran-77
// interfaces to the BLAS.


// Determines whether to enable interfaces to internal/low-level libgoto
// symbols.


// Sets the default blocksize in the k dimension (used only if
// libgoto interfaces are disabled).


// Sets the default blocksize in the m dimension (used only if
// libgoto interfaces are disabled).


// Sets the default blocksize in the n dimension (used only if
// libgoto interfaces are disabled).



// --- Memory alignment --------------------------------------------------------

// Determines whether memory is aligned to user-requested boundaries.


// Sets the byte boundary used to align the starting address of all memory
// allocated dynamically through libflame. Only used if
// FLA_ENABLE_MEMORY_ALIGNMENT is defined.


// Determines whether to enable code that will increase FLA_Obj leading
// dimensions to ensure that matrix columns adhere to the alignment specified
// by FLA_MEMORY_ALIGNMENT_BOUNDARY.



// --- Fortran-77 compatibility ------------------------------------------------

// Determines whether the Fortran name-mangling suffix was determined at
// configure-time. This option is not used in Windows.


// Determines whether the Fortran 77 compiler appends an underscore to symbol
// names. Not used in Windows.


// Determines whether the Fortran 77 compiler appends an extra underscore to
// symbol names that already contain at least one underscore. Not used in
// Windows.


// Determines whether invocations to the BLAS within libflame are converted to
// uppercase symbols.


// Determines whether invocations to LAPACK within libflame are converted to
// uppercase symbols.



// --- Experimental/unsupported/broken options ---------------------------------

// Determines whether GPU-specific blocks of code should be compiled.


// Determines AMD optimized code path selection
#define FLA_ENABLE_AMD_OPT 1

//Detrmines library Version
#define FLA_LIBFLAME_VERSION   "5.1.0	Build	20250430"

// Determines OpenMP multithreading for AMD optimized code path 
#define FLA_OPENMP_MULTITHREADING  1

// Determins BLAS Extension API, GEMMT usage in libFLAME APIs
#define FLA_ENABLE_BLAS_EXT_GEMMT  1

// Enables FLA_PORTABLE_TIMER_IS_CLOCK_GETTIME
#define FLA_PORTABLE_TIMER_IS_CLOCK_GETTIME  1

//#define FLA_PORTABLE_TIMER_IS_CLOCK_GETTIME 1
#define FLA_VECTOR_INTRINSIC_TYPE 0

// #define other missing macros
#define HAVE_ASSERT_H 1
#define HAVE_FCNTL_H 1
#define HAVE_INTTYPES_H 1
#define HAVE_LIBM 1
#define HAVE_MATH_H 1
#define HAVE_MEMORY_H 1
#define HAVE_SIGNAL_H 1
#define HAVE_STDINT_H 1
#define HAVE_STDLIB_H 1
#define HAVE_STRINGS_H 1
#define HAVE_STRING_H 1
#define HAVE_SYS_STAT_H 1
#define HAVE_SYS_TIME_H 1
#define HAVE_SYS_TYPES_H 1
#define HAVE_UNISTD_H 1

#define PROTOTYPES 1
#define STDC_HEADERS 1
#define TIME_WITH_SYS_TIME 1
#define _GNU_SOURCE 1
#define __PROTOTYPES 1






// end FLA_config.h
// begin FLA_macro_defs.h
			





// --- Miscellaneous macro definitions -----------------------------------------
#ifndef FLA_MACRO_DEFS_H
#define FLA_MACRO_DEFS_H

#undef  NULL
#define NULL 0

#ifdef FLA_ENABLE_WINDOWS_BUILD
  #define restrict  __restrict
#endif

// --- Macro to enable/disable Thread Local Storage (TLS) for global variables -
#if defined(WINDOWS_FLA_SHARED_BUILD) && defined(WINDOWS_FLA_TEST)
 #define ENABLE_THREAD_LOCAL_STORAGE 0
 #define LIBFLAME_IMPORT __declspec(dllimport)
#else
 #if defined(FLA_ENABLE_AMD_OPT) && !defined FLA_ENABLE_SUPERMATRIX
   #define ENABLE_THREAD_LOCAL_STORAGE 1
 #else
   #define ENABLE_THREAD_LOCAL_STORAGE 0
 #endif
 #define LIBFLAME_IMPORT
#endif

#if ENABLE_THREAD_LOCAL_STORAGE
#ifdef FLA_ENABLE_WINDOWS_BUILD
#define TLS_CLASS_SPEC __declspec(thread)
#else
#define TLS_CLASS_SPEC __thread
#endif
#else
#define TLS_CLASS_SPEC
#endif

// --- Type-related macro definitions ------------------------------------------

// FLA_Bool
#undef  TRUE
#undef  FALSE
#define TRUE  1
#define FALSE 0

// FLA_Error (non-specific)
#define FLA_SUCCESS           (-1)
#define FLA_FAILURE           (-2)

// FLA_Quadrant
#define FLA_TL                 11
#define FLA_TR                 12
#define FLA_BL                 21
#define FLA_BR                 22

// FLA_Datatype
#define FLA_FLOAT             100
#define FLA_DOUBLE            101
#define FLA_COMPLEX           102
#define FLA_DOUBLE_COMPLEX    103
#define FLA_INT               104
#define FLA_CONSTANT          105

// FLA_Elemtype
#define FLA_MATRIX            150
#define FLA_SCALAR            151

// FLA_Side
#define FLA_TOP               200
#define FLA_BOTTOM            201
#define FLA_LEFT              210
#define FLA_RIGHT             211
#define FLA_SIDE_MASK         0x1

// FLA_Uplo
#define FLA_LOWER_TRIANGULAR  300
#define FLA_UPPER_TRIANGULAR  301
#define FLA_ZERO_MATRIX       310
#define FLA_FULL_MATRIX       311
#define FLA_UPLO_MASK         0x1

// FLA_Trans
#define FLA_NO_TRANSPOSE      400
#define FLA_TRANSPOSE         401
#define FLA_CONJ_TRANSPOSE    402
#define FLA_CONJ_NO_TRANSPOSE 403
#define FLA_TRANS_MASK        0x3

// FLA_Conj
#define FLA_NO_CONJUGATE      450
#define FLA_CONJUGATE         451

// FLA_Diag
#define FLA_UNIT_DIAG         500
#define FLA_NONUNIT_DIAG      501
#define FLA_ZERO_DIAG         502
#define FLA_DIAG_MASK         0x3

// FLA_Dimension
#define FLA_DIMENSION_M       600
#define FLA_DIMENSION_K       601
#define FLA_DIMENSION_N       602
#define FLA_DIMENSION_MIN     603

// FLA_Dimension_index
#define FLA_DIM_M_INDEX         0
#define FLA_DIM_K_INDEX         1
#define FLA_DIM_N_INDEX         2
#define FLA_DIM_MIN_INDEX       3
#define FLA_DIM_INDEX_MASK    0x3

// FLA_Pivot_type
#define FLA_NATIVE_PIVOTS     700
#define FLA_LAPACK_PIVOTS     701

// FLA_Direct
#define FLA_FORWARD           800
#define FLA_BACKWARD          801

// FLA_Store
#define FLA_COLUMNWISE        900
#define FLA_ROWWISE           901

// FLA_Matrix_type
#define FLA_FLAT             1000
#define FLA_HIER             1001

// FLA_Precision
#define FLA_SINGLE_PRECISION 1100
#define FLA_DOUBLE_PRECISION 1101

// FLA_Domain
#define FLA_REAL_DOMAIN      1200
#define FLA_COMPLEX_DOMAIN   1201

// FLA_Inv    
#define FLA_NO_INVERSE       1300
#define FLA_INVERSE          1301

// FLA_Evd_type
#define FLA_EVD_WITHOUT_VECTORS         1400
#define FLA_EVD_WITH_VECTORS            1401
#define FLA_EVD_OF_TRIDIAG_WITH_VECTORS 1402

// FLA_Svd_type
#define FLA_SVD_VECTORS_ALL           1500
#define FLA_SVD_VECTORS_MIN_COPY      1501
#define FLA_SVD_VECTORS_MIN_OVERWRITE 1502
#define FLA_SVD_VECTORS_NONE          1503

// FLA_Machval
#define FLA_MACH_START                1600
#define FLA_MACH_EPS                  1600
#define FLA_MACH_SFMIN                1601
#define FLA_MACH_BASE                 1602
#define FLA_MACH_PREC                 1603
#define FLA_MACH_NDIGMANT             1604
#define FLA_MACH_RND                  1605
#define FLA_MACH_EMIN                 1606
#define FLA_MACH_RMIN                 1607
#define FLA_MACH_EMAX                 1608
#define FLA_MACH_RMAX                 1609
#define FLA_MACH_EPS2                 1610
#define FLA_MACH_N_VALS                 11

// FLA_Diag_off
#define FLA_SUPER_DIAGONAL     ( 1)
#define FLA_MAIN_DIAGONAL        0
#define FLA_SUB_DIAGONAL       (-1)

// FLAME threading model
#define FLA_OPENMP              1
#define FLA_PTHREADS            2

// FLAME vector intrinsics types
#define FLA_NO_INTRINSICS       0
#define FLA_SSE_INTRINSICS      3

// FLAME internal error checking level
#define FLA_FULL_ERROR_CHECKING 2
#define FLA_MIN_ERROR_CHECKING  1
#define FLA_NO_ERROR_CHECKING   0

// FLA_Datatype_index
#define FLA_S_INDEX             0
#define FLA_D_INDEX             1
#define FLA_C_INDEX             2
#define FLA_Z_INDEX             3
#define FLA_DTYPE_INDEX_MASK  0x3

#define FLA_SMALL_LU_BLOCKSIZE 64
// Default blocksize if none are available.
#ifndef FLA_DEFAULT_M_BLOCKSIZE
  #define FLA_DEFAULT_M_BLOCKSIZE  128
#endif
#ifndef FLA_DEFAULT_K_BLOCKSIZE
  #define FLA_DEFAULT_K_BLOCKSIZE  128
#endif
#ifndef FLA_DEFAULT_N_BLOCKSIZE
  #define FLA_DEFAULT_N_BLOCKSIZE  128
#endif

// Blocksize for hierarchical storage of matrices for FLASH based
// external interfaces
#define FLA_EXT_HIER_BLOCKSIZE 128

// QR and LQ factorizations typically has an inner blocksize that corresponds
// to the length of the S (or T) block Householder matrix. For consistency, we
// define the ratio of the inner blocksize to the outer blocksize here, as it
// is used in several places. Note that other operations have analagous inner
// blocksizes, which we also define in terms of the outer storage blocksize,
// or in some cases such as Hessenberg, tridiagonal, and bidiagonal reductions,
// in terms of the system-wide default blocksize.
#define FLA_QR_INNER_TO_OUTER_B_RATIO      (0.25)
#define FLA_LQ_INNER_TO_OUTER_B_RATIO      (0.25)
#define FLA_LU_INNER_TO_OUTER_B_RATIO      (0.25)
#define FLA_UDDATE_INNER_TO_OUTER_B_RATIO  (0.25)
#define FLA_HESS_INNER_TO_OUTER_B_RATIO    (0.25)
#define FLA_TRIDIAG_INNER_TO_OUTER_B_RATIO (0.25)
#define FLA_BIDIAG_INNER_TO_OUTER_B_RATIO  (0.25)
#define FLA_CAQR_INNER_TO_OUTER_B_RATIO    (0.25)

// Matrix size thresholds for choosing unbloked non-FLA variant of QR for
// small matrices
#define FLA_GEQRF_STHRESH (32)
#define FLA_GEQRF_BLOCK_SIZE (32)
// Matrix size thresholds for choosing transposed QR for LQ 
#define FLA_DELQF_TRAN_THRESH (1280)

//POTRF, threshold numbers to chose paths for performance
#define FLA_POTRF_FLOAT_SMALL         (70)
#define FLA_POTRF_DOUBLE_SMALL        (75)

//GETRF , threshold numbers to chose paths for performance
#define FLA_GETRF_SMALL               (85)
#define FLA_GETRF_FLOAT               (1440)
#define FLA_GETRF_COMPLEX             (670)
#define FLA_GETRF_DOUBLE_COMPLEX      (1630)

#define FLA_SGETRF_SMALL_THRESH1      (117)
#define FLA_SGETRF_MEDIUM_THRESH0     (480)

#define FLA_SGETRF_SMALL_THRESH0      (7)
#define FLA_SGETRF_SMALL_AVX2_THRESH0      (31)
#define FLA_SGETRF_SMALL_AVX512_THRESH0    (156)

#define FLA_DGETRF_SMALL_THRESH0      (8)
#define FLA_DGETRF_SMALL_AVX2_THRESH0      (81)
#define FLA_DGETRF_SMALL_AVX512_THRESH0    (160)

#define FLA_ZGETRF_SMALL_THRESH      (100)

// GETRFNPI , these thresholds are used to chose between 3 algorithms to get best
// results in terms of perfmormance
#define FLA_MN_SIZE            (373321)
#define FLA_NFACT_PERCENT      (0.51)
#define FLA_FULL_DGER_CONSTANT (200)

// ORGQR , threshold numbers to chose paths for performance
#define FLA_DGEMV_DGER_SIMD_SMALL_THRESH   (128)
#define FLA_DGEMV_DGER_SIMD_SMALL_THRESH_M (6)
#define FLA_DGEMV_DGER_SIMD_AVX512_THRESH_M (25)
#define FLA_ZGEMV_ZGER_SIMD_AXV2_THRESH_M (8)
#define FLA_ZGEMV_ZGER_SIMD_AXV512_THRESH_M (49)
#define FLA_SSCAL_INLINE_SMALL          (512)
#define FLA_DSCAL_INLINE_SMALL          (512)
#define FLA_ZGERC_INLINE_SMALL_THRESH0  (128)
#define FLA_ZGERC_INLINE_SMALL_THRESH1  (32)
#define FLA_ZSCAL_INLINE_SMALL          (128)
#define FLA_ZUNGQR_BLOCK_SMALL_THRESH   (32)


#define FLA_ZLANGEM_SIMD_AVX512_THRESH_M (15)
#define FLA_CLANGEM_SIMD_AVX512_THRESH_M (15)

// DNRM2 threshold numbers to chose AVX kernel
#define FLA_DNRM2_SMALL_THRESH0  (15)

// GEQP3 , threshold numbers to chose paths for performance
#define FLA_IDAMAX_INLINE_SMALL_THRESH   (128)
#define FLA_DGEQP3_BLOCK_SMALL_THRESH    (32)
#define FLA_ZGEQP3_BLOCK_SMALL_THRESH    (32)

// --- Error-related macro definitions -----------------------------------------

// Useful when determining the relative index base of the error codes.
#define FLA_ERROR_CODE_MIN                    (-10)

// FLA_Error values.
#define FLA_INVALID_SIDE                      (-10)
#define FLA_INVALID_UPLO                      (-11)
#define FLA_INVALID_TRANS                     (-12)
#define FLA_INVALID_TRANS_GIVEN_DATATYPE      (-13)
#define FLA_INVALID_CONJ                      (-14)
#define FLA_INVALID_DIRECT                    (-15)
#define FLA_INVALID_STOREV                    (-16)
#define FLA_INVALID_DATATYPE                  (-17)
#define FLA_INVALID_INTEGER_DATATYPE          (-18)
#define FLA_INVALID_REAL_DATATYPE             (-19)
#define FLA_INVALID_COMPLEX_DATATYPE          (-20)
#define FLA_OBJECT_NOT_INTEGER                (-21)
#define FLA_OBJECT_NOT_REAL                   (-22)
#define FLA_OBJECT_NOT_COMPLEX                (-23)
#define FLA_OBJECT_NOT_SQUARE                 (-24)
#define FLA_OBJECT_NOT_SCALAR                 (-25)
#define FLA_OBJECT_NOT_VECTOR                 (-26)
#define FLA_INCONSISTENT_DATATYPES            (-27)
#define FLA_NONCONFORMAL_DIMENSIONS           (-28)
#define FLA_UNEQUAL_VECTOR_DIMS               (-29)
#define FLA_INVALID_HESSENBERG_INDICES        (-30)
#define FLA_NULL_POINTER                      (-32)
#define FLA_SPECIFIED_OBJ_DIM_MISMATCH        (-33)
#define FLA_INVALID_PIVOT_TYPE                (-35)
#define FLA_MALLOC_RETURNED_NULL_POINTER      (-37)
#define FLA_OBJECT_BASE_BUFFER_MISMATCH       (-38)
#define FLA_OBJECTS_NOT_VERTICALLY_ADJ        (-39)
#define FLA_OBJECTS_NOT_HORIZONTALLY_ADJ      (-40)
#define FLA_ADJACENT_OBJECT_DIM_MISMATCH      (-41)
#define FLA_OBJECTS_NOT_VERTICALLY_ALIGNED    (-42)
#define FLA_OBJECTS_NOT_HORIZONTALLY_ALIGNED  (-43)
#define FLA_INVALID_FLOATING_DATATYPE         (-44)
#define FLA_OBJECT_NOT_FLOATING_POINT         (-45)
#define FLA_INVALID_BLOCKSIZE_VALUE           (-46)
#define FLA_OPEN_RETURNED_ERROR               (-47)
#define FLA_LSEEK_RETURNED_ERROR              (-48)
#define FLA_CLOSE_RETURNED_ERROR              (-49)
#define FLA_UNLINK_RETURNED_ERROR             (-50)
#define FLA_READ_RETURNED_ERROR               (-51)
#define FLA_WRITE_RETURNED_ERROR              (-52)
#define FLA_INVALID_QUADRANT                  (-53)
#define FLA_NOT_YET_IMPLEMENTED               (-54)
#define FLA_EXPECTED_NONNEGATIVE_VALUE        (-55)
#define FLA_SUPERMATRIX_NOT_ENABLED           (-56)
#define FLA_UNDEFINED_ERROR_CODE              (-57)
#define FLA_INVALID_DIAG                      (-58)
#define FLA_INCONSISTENT_OBJECT_PRECISION     (-59)
#define FLA_INVALID_BLOCKSIZE_OBJ             (-60)
#define FLA_VECTOR_DIM_BELOW_MIN              (-61)
#define FLA_PTHREAD_CREATE_RETURNED_ERROR     (-63)
#define FLA_PTHREAD_JOIN_RETURNED_ERROR       (-64)
#define FLA_INVALID_ISGN_VALUE                (-65)
#define FLA_CHOL_FAILED_MATRIX_NOT_SPD        (-67)
#define FLA_INVALID_ELEMTYPE                  (-68)
#define FLA_POSIX_MEMALIGN_FAILED             (-69)
#define FLA_INVALID_SUBMATRIX_DIMS            (-70)
#define FLA_INVALID_SUBMATRIX_OFFSET          (-71)
#define FLA_OBJECT_NOT_SCALAR_ELEMTYPE        (-72)
#define FLA_OBJECT_NOT_MATRIX_ELEMTYPE        (-73)
#define FLA_ENCOUNTERED_NON_POSITIVE_NTHREADS (-74)
#define FLA_INVALID_CONJ_GIVEN_DATATYPE       (-75)
#define FLA_INVALID_COMPLEX_TRANS             (-76)
#define FLA_INVALID_REAL_TRANS                (-77)
#define FLA_INVALID_BLAS_TRANS                (-78)
#define FLA_INVALID_NONCONSTANT_DATATYPE      (-79)
#define FLA_OBJECT_NOT_NONCONSTANT            (-80)
#define FLA_OBJECT_DATATYPES_NOT_EQUAL        (-82)
#define FLA_DIVIDE_BY_ZERO                    (-83)
#define FLA_OBJECT_ELEMTYPES_NOT_EQUAL        (-84)
#define FLA_INVALID_PIVOT_INDEX_RANGE         (-85)
#define FLA_HOUSEH_PANEL_MATRIX_TOO_SMALL     (-86)
#define FLA_INVALID_OBJECT_LENGTH             (-87)
#define FLA_INVALID_OBJECT_WIDTH              (-88)
#define FLA_INVALID_ERROR_CHECKING_LEVEL      (-89)
#define FLA_ATTEMPTED_OVER_REPART_2X2         (-90)
#define FLA_ATTEMPTED_OVER_REPART_2X1         (-91)
#define FLA_ATTEMPTED_OVER_REPART_1X2         (-92)
#define FLA_EXTERNAL_LAPACK_NOT_IMPLEMENTED   (-93)
#define FLA_INVALID_ROW_STRIDE                (-94)
#define FLA_INVALID_COL_STRIDE                (-95)
#define FLA_INVALID_STRIDE_COMBINATION        (-96)
#define FLA_INVALID_VECTOR_DIM                (-97)
#define FLA_EXPECTED_ROW_VECTOR               (-98)
#define FLA_EXPECTED_COL_VECTOR               (-99)
#define FLA_INVALID_INVERSE                   (-100)
#define FLA_MALLOC_GPU_RETURNED_NULL_POINTER  (-101)
#define FLA_INVALID_EVD_TYPE                  (-102)
#define FLA_INVALID_SVD_TYPE                  (-103)
#define FLA_INVALID_MACHVAL                   (-104)
#define FLA_INVALID_DIAG_OFFSET               (-105)
#define FLA_EXPECTED_COL_STORAGE              (-106)
#define FLA_EXPECTED_ROW_STORAGE              (-107)
#define FLA_LAPAC2FLAME_INVALID_RETURN        (-108)
#define FLA_INVALID_SVD_TYPE_COMBINATION      (-109)
#define FLA_INVALID_SVD_TYPE_AND_TRANS_COMBINATION (-110)
#define FLA_OBJECT_NOT_COMPARABLE             (-111)

// Necessary when computing whether an error code is defined.
#define FLA_ERROR_CODE_MAX                    (-111)

// Internal string matrix limits.
#define FLA_MAX_NUM_ERROR_MSGS                 150
#define FLA_MAX_ERROR_MSG_LENGTH               200

// Error code translation and output macro definition.
#define FLA_Check_error_code( code ) \
        FLA_Check_error_code_helper( code, __FILE__, __LINE__ )



// --- Common functions implemented as macros ----------------------------------

#define fla_min( x, y )    \
({                         \
   __typeof__(x) _x = (x); \
   __typeof__(y) _y = (y); \
   _x < _y ? _x : _y;      \
})

#define fla_max( x, y )    \
({                         \
   __typeof__(x) _x = (x); \
   __typeof__(y) _y = (y); \
   _x > _y ? _x : _y;      \
})

#undef signof
#define signof( a, b ) ( (b) >= 0 ? (a) : -(a) )

#ifndef __cplusplus

 #undef exchange
 #define exchange( a, b, temp ) { temp = a; a = b; b = temp; }

#endif

// --- Other macro definitions -------------------------------------------------

#define FLA_NEGATE( a ) \
        ( a.base == FLA_ONE.base ? FLA_MINUS_ONE : FLA_ONE )

#endif

// end FLA_macro_defs.h
// begin FLA_type_defs.h




#ifndef FLA_TYPE_DEFS_H
#define FLA_TYPE_DEFS_H

#ifdef __cplusplus
// For C++, include stdint.h.
#include <stdint.h> // skipped
#elif __STDC_VERSION__ >= 199901L
// For C99 (or later), include stdint.h.
#include <stdint.h> // skipped
#else
// When stdint.h is not available, manually typedef the types we will use.
#ifdef _WIN32
typedef          __int32  int32_t;
typedef unsigned __int32 uint32_t;
typedef          __int64  int64_t;
typedef unsigned __int64 uint64_t;
#else
#error "Attempting to compile on pre-C99 system without stdint.h."
#endif
#endif

#if defined(FLA_ENABLE_ILP64)
typedef int64_t integer;
typedef uint64_t uinteger;
#else
typedef int integer;
typedef unsigned long uinteger;
#endif



#if   FLA_MULTITHREADING_MODEL == FLA_OPENMP
#ifdef FLA_ENABLE_TIDSP
#include <ti/omp/omp.h> // skipped
#else
#include <omp.h> // skipped
#endif
#elif FLA_MULTITHREADING_MODEL == FLA_PTHREADS
#include <pthread.h> // skipped
#endif


// --- Complex type definitions -----------------------------------------------

#ifndef _DEFINED_SCOMPLEX
#define _DEFINED_SCOMPLEX
typedef struct scomplex
{
  float real, imag;
} scomplex;
#endif

#ifndef _DEFINED_DCOMPLEX
#define _DEFINED_DCOMPLEX
typedef struct dcomplex
{
  double real, imag;
} dcomplex;
#endif


// --- Parameter and return type definitions ----------------------------------

typedef int FLA_Bool;
typedef int FLA_Error;
typedef int FLA_Quadrant;
typedef int FLA_Datatype;
typedef int FLA_Elemtype;
typedef int FLA_Side;
typedef int FLA_Uplo;
typedef int FLA_Trans;
typedef int FLA_Conj;
typedef int FLA_Diag;
typedef int FLA_Dimension;
typedef int FLA_Pivot_type;
typedef int FLA_Direct;
typedef int FLA_Store;
typedef int FLA_Matrix_type;
typedef int FLA_Precision;
typedef int FLA_Domain;
typedef int FLA_Inv;
typedef int FLA_Evd_type;
typedef int FLA_Svd_type;
typedef int FLA_Machval;
typedef int FLA_Diag_off;

#ifndef _DEFINED_FLA_DIM_T
#define _DEFINED_FLA_DIM_T
typedef uinteger fla_dim_t;
#endif

// --- Intrinsic/assembly definitions ----------------------------------------

#if FLA_VECTOR_INTRINSIC_TYPE == FLA_SSE_INTRINSICS

#include "pmmintrin.h" // skipped

//typedef double v2df __attribute__ ((vector_size (16)));

typedef union
{
    __m128  v; 
    float   f[4];
} v4sf_t;

typedef union
{
    __m128d v; 
    double  d[2];
} v2df_t;

#endif

// --- FLAME object definitions -----------------------------------------------

typedef struct FLA_Lock_s     FLA_Lock;

//#ifdef FLA_ENABLE_MULTITHREADING
struct FLA_Lock_s
{
  // Implementation-specific lock object
#if   FLA_MULTITHREADING_MODEL == FLA_OPENMP
  omp_lock_t       lock;
#elif FLA_MULTITHREADING_MODEL == FLA_PTHREADS
  pthread_mutex_t  lock;
#endif
};
//#endif

#ifdef FLA_ENABLE_SUPERMATRIX
typedef int                   FLASH_Verbose;
typedef int                   FLASH_Data_aff;

typedef struct FLASH_Queue_s  FLASH_Queue;
typedef struct FLASH_Task_s   FLASH_Task;
typedef struct FLASH_Dep_s    FLASH_Dep;
#endif
typedef struct FLASH_Thread_s FLASH_Thread;

typedef struct FLA_Obj_struct
{
  // Basic object description fields
  FLA_Datatype  datatype;
  FLA_Elemtype  elemtype;
  fla_dim_t         m;
  fla_dim_t         n;
  fla_dim_t         rs;
  fla_dim_t         cs;
  fla_dim_t         m_inner;
  fla_dim_t         n_inner;
  unsigned long id;
  fla_dim_t         m_index;
  fla_dim_t         n_index;

  fla_dim_t         n_elem_alloc;
  void*         buffer;
  int           buffer_info;

  FLA_Uplo      uplo;

#ifdef FLA_ENABLE_SUPERMATRIX
  // Fields for supermatrix
  int           n_read_blocks;
  int           n_write_blocks;

  // All the tasks that previously read this block, anti-dependency
  int           n_read_tasks;
  FLASH_Dep*    read_task_head;
  FLASH_Dep*    read_task_tail;

  // Task that last overwrote this block, flow dependency
  FLASH_Task*   write_task;
#endif
} FLA_Base_obj;

typedef struct FLA_Obj_view
{
  // Basic object view description fields
  fla_dim_t         offm;
  fla_dim_t         offn;
  fla_dim_t         m;
  fla_dim_t         n;
  
  fla_dim_t         m_inner;
  fla_dim_t         n_inner;

  FLA_Base_obj* base;

} FLA_Obj;

#ifdef FLA_ENABLE_SUPERMATRIX
struct FLASH_Queue_s
{
  // Number of tasks currently in queue
  unsigned int  n_tasks;

  // Pointers to head (front) and tail (back) of queue
  FLASH_Task*   head;
  FLASH_Task*   tail;
};

struct FLASH_Task_s
{
  // Execution information
  int           n_ready;

  // Labels
  int           order;
  int           queue;
  int           height;
  int           thread;
  int           cache;
  FLA_Bool      hit;
      
  // Function pointer
  void*         func;

  // Control tree pointer
  void*         cntl;

  // Name of task
  char*         name;

  // GPU enabled task
  FLA_Bool      enabled_gpu;

  // Integer arguments
  int           n_int_args;
  int*          int_arg;

  // Constant FLA_Obj arguments
  int           n_fla_args;
  FLA_Obj*      fla_arg;

  // Input FLA_Obj arguments
  int           n_input_args;
  FLA_Obj*      input_arg;

  // Output FLA_Obj argument
  int           n_output_args;
  FLA_Obj*      output_arg;

  // Number of blocks within all macroblocks
  int           n_macro_args;

  // Number of write after read dependencies
  int           n_war_args;

  // Dependence information
  int           n_dep_args;
  FLASH_Dep*    dep_arg_head;
  FLASH_Dep*    dep_arg_tail;
  
  // Support for a doubly linked list of tasks
  FLASH_Task*   prev_task;
  FLASH_Task*   next_task;

  // Support for a doubly linked list for wait queue
  FLASH_Task*   prev_wait;
  FLASH_Task*   next_wait;
};

struct FLASH_Dep_s
{
  // Task yielding dependency
  FLASH_Task*   task;

  // Support for linked list of FLASH_Deps
  FLASH_Dep*    next_dep;
};
#endif // FLA_ENABLE_SUPERMATRIX

struct FLASH_Thread_s
{
  // The thread's unique identifier
  int       id;

  // Pointer to variables needed to execute SuperMatrix mechanism
  void*     args;

#if FLA_MULTITHREADING_MODEL == FLA_PTHREADS
  // The thread object. Only needed for the POSIX threads implementation.
  pthread_t pthread_obj;
#endif
};

#endif // FLA_TYPE_DEFS_H
// end FLA_type_defs.h

// Determine whether or not we are using BLIS from libflame.


// If using libflame, pull in its header files so that
// vector intrinsics-related macro constants are set properly.

// --- Pass-through macros for BLIS ---
#ifdef FLA_ENABLE_CBLAS_INTERFACES
    #define BLIS1_ENABLE_CBLAS_INTERFACES
#endif
#ifdef FLA_ENABLE_WINDOWS_BUILD
    #define BLIS1_ENABLE_WINDOWS_BUILD
#endif
#ifdef FLA_ENABLE_UPPERCASE_F77
    #define BLIS1_ENABLE_UPPERCASE_F77
#endif
#ifdef FLA_ENABLE_VECTOR_INTRINSICS
    #define BLIS1_ENABLE_VECTOR_INTRINSICS
#endif

#define BLIS1_VECTOR_INTRINSIC_TYPE FLA_VECTOR_INTRINSIC_TYPE


// begin blis_macro_defs.h


#ifndef BLIS1_MACRO_DEFS_H
#define BLIS1_MACRO_DEFS_H

// --- Constants ---------------------------------------------------------------

#define BLIS1_NO_INTRINSICS  0
#define BLIS1_SSE_INTRINSICS 3

#ifdef FLA_ENABLE_WINDOWS_BUILD
#define restrict  __restrict
#endif

// --- boolean ---

#undef FALSE
#define FALSE 0

#undef TRUE
#define TRUE 1



// --- Functional macros -------------------------------------------------------

// --- Type-agnostic ---

// min, max, abs

#define bl1_min( a, b )  ( (a) < (b) ? (a) : (b) )
#define bl1_max( a, b )  ( (a) > (b) ? (a) : (b) )
#define bl1_abs( a )     ( (a) <= 0 ? -(a) : (a) )

// fmin, fmax, fabs

#define bl1_fmin( a, b ) bl1_min( a, b )
#define bl1_fmax( a, b ) bl1_max( a, b )
#define bl1_fabs( a )    ( (a) <= 0.0 ? -(a) : (a) )

// fminabs, fmaxabs
#define bl1_fminabs( a, b ) \
\
    bl1_fmin( bl1_fabs( a ), \
              bl1_fabs( b ) )

#define bl1_fmaxabs( a, b ) \
\
    bl1_fmax( bl1_fabs( a ), \
              bl1_fabs( b ) )

// --- Type-dependent ---

// --- neg1 ---

// void bl1_sneg1( float* x );
#define bl1_sneg1( x ) \
*(x)     *= -1.0F;

// void bl1_dneg1( double* x );
#define bl1_dneg1( x ) \
*(x)     *= -1.0;

// void bl1_cneg1( scomplex* x );
#define bl1_cneg1( x ) \
(x)->real *= -1.0F; \
(x)->imag *= -1.0F;

// void bl1_zneg1( dcomplex* x );
#define bl1_zneg1( x ) \
(x)->real *= -1.0; \
(x)->imag *= -1.0;

// --- neg2 ---

// void bl1_sneg2( float* x, float* y );
#define bl1_sneg2( x, y ) \
*(y)      = -1.0F * *(x);

// void bl1_dneg2( double* x, double* y );
#define bl1_dneg2( x, y ) \
*(y)      = -1.0  * *(x);

// void bl1_cneg2( scomplex* x, scomplex* y );
#define bl1_cneg2( x, y ) \
(y)->real = -1.0F * (x)->real; \
(y)->imag = -1.0F * (x)->imag;

// void bl1_zneg2( dcomplex* x, dcomplex* y );
#define bl1_zneg2( x, y ) \
(y)->real = -1.0  * (x)->real; \
(y)->imag = -1.0  * (x)->imag;

// --- sqrte ---

// void bl1_ssqrte( float* alpha, int* error );
#define bl1_ssqrte( alpha, error ) \
if ( *(alpha)      <= 0.0F || isnan( *(alpha) ) ) {  *(error) = FLA_FAILURE; } \
else { *(alpha)      =  ( float ) sqrt( *(alpha) );  *(error) = FLA_SUCCESS; }

// void bl1_dsqrte( double* alpha, int* error );
#define bl1_dsqrte( alpha, error ) \
if ( *(alpha)      <= 0.0 || isnan( *(alpha) ) ) {   *(error) = FLA_FAILURE; } \
else { *(alpha)      = ( double ) sqrt( *(alpha) );  *(error) = FLA_SUCCESS; }

// void bl1_csqrte( scomplex* alpha, int* error );
#define bl1_csqrte( alpha, error ) \
if ( (alpha)->real <= 0.0F || isnan( (alpha)->real) ) \
{ (alpha)->imag = 0.0F; *(error) = FLA_FAILURE; } \
else { \
  (alpha)->real =  ( float ) sqrt( (alpha)->real ); \
  (alpha)->imag = 0.0F; *(error) = FLA_SUCCESS; \
}

// void bl1_zsqrte( dcomplex* alpha, int* error );
#define bl1_zsqrte( alpha, error ) \
if ( (alpha)->real <= 0.0 || isnan( (alpha)->real) )  \
{ (alpha)->imag = 0.0; *(error) = FLA_FAILURE; } \
else { \
  (alpha)->real = ( double ) sqrt( (alpha)->real ); \
  (alpha)->imag = 0.0;  *(error) = FLA_SUCCESS; \
}

// --- absval2 ---

// void bl1_sabsval2( float* alpha, float* absval );
#define bl1_sabsval2( alpha, absval ) \
*(absval) = ( float ) fabs( ( double ) *(alpha) );

// void bl1_dabsval2( double* alpha, double* absval );
#define bl1_dabsval2( alpha, absval ) \
*(absval) = fabs( *(alpha) );

// void bl1_cabsval2( scomplex* x, scomplex* a );
#define bl1_cabsval2( x, a ) \
{ \
	float  s   = bl1_fmaxabs( (x)->real, (x)->imag ); \
	float  mag = sqrtf( s ) * \
	             sqrtf( ( (x)->real / s ) * (x)->real + \
	                    ( (x)->imag / s ) * (x)->imag ); \
	(a)->real   = mag; \
	(a)->imag   = 0.0F; \
}

// void bl1_csabsval2( scomplex* x, float* a );
#define bl1_csabsval2( x, a ) \
{ \
	float  s   = bl1_fmaxabs( (x)->real, (x)->imag ); \
	float  mag = sqrtf( s ) * \
	             sqrtf( ( (x)->real / s ) * (x)->real + \
	                    ( (x)->imag / s ) * (x)->imag ); \
	*(a)       = mag; \
}

// void bl1_zabsval2( dcomplex* x, dcomplex* a );
#define bl1_zabsval2( x, a ) \
{ \
	double s   = bl1_fmaxabs( (x)->real, (x)->imag ); \
	double mag = sqrt( s ) * \
	             sqrt( ( (x)->real / s ) * (x)->real + \
	                   ( (x)->imag / s ) * (x)->imag ); \
	(a)->real   = mag; \
	(a)->imag   = 0.0; \
}

// void bl1_zdabsval2( dcomplex* x, double* a );
#define bl1_zdabsval2( x, a ) \
{ \
	double s   = bl1_fmaxabs( (x)->real, (x)->imag ); \
	double mag = sqrt( s ) * \
	             sqrt( ( (x)->real / s ) * (x)->real + \
	                   ( (x)->imag / s ) * (x)->imag ); \
	*(a)       = mag; \
}


// --- absqr ---

// void bl1_sabsqr( float* alpha );
#define bl1_sabsqr( alpha ) \
*(alpha) = *(alpha) * *(alpha);

// void bl1_dabsqr( double* alpha );
#define bl1_dabsqr( alpha ) \
*(alpha) = *(alpha) * *(alpha);

// void bl1_cabsqr( scomplex* alpha );
#define bl1_cabsqr( alpha ) \
(alpha)->real = (alpha)->real * (alpha)->real + (alpha)->imag * (alpha)->imag; \
(alpha)->imag = 0.0F;

// void bl1_zabsqr( dcomplex* alpha );
#define bl1_zabsqr( alpha ) \
(alpha)->real = (alpha)->real * (alpha)->real + (alpha)->imag * (alpha)->imag; \
(alpha)->imag = 0.0;

// --- invscals ---

// void bl1_sinvscals( float* a, float* y );
#define bl1_sinvscals( a, y ) \
*(y) = *(y) / *(a);

// void bl1_dinvscals( double* a, double* y );
#define bl1_dinvscals( a, y ) \
*(y) = *(y) / *(a);

// void bl1_csinvscals( float* a, scomplex* y );
#define bl1_csinvscals( a, y ) \
{ \
(y)->real = (y)->real / *(a); \
(y)->imag = (y)->imag / *(a); \
}

// void bl1_cinvscals( scomplex* a, scomplex* y );
#define bl1_cinvscals( a, y ) \
{ \
	float  s     = bl1_fmaxabs( (a)->real, (a)->imag ); \
	float  ar_s  = (a)->real / s; \
	float  ai_s  = (a)->imag / s; \
	float  yrt   = (y)->real; \
	float  temp  = ( ar_s * (a)->real + ai_s * (a)->imag ); \
	(y)->real    = ( (yrt)     * ar_s + (y)->imag * ai_s ) / temp; \
	(y)->imag    = ( (y)->imag * ar_s - (yrt)     * ai_s ) / temp; \
}

// void bl1_zdinvscals( double* a, dcomplex* y );
#define bl1_zdinvscals( a, y ) \
{ \
(y)->real = (y)->real / *(a); \
(y)->imag = (y)->imag / *(a); \
}

// void bl1_zinvscals( dcomplex* a, dcomplex* y );
#define bl1_zinvscals( a, y ) \
{ \
	double s     = bl1_fmaxabs( (a)->real, (a)->imag ); \
	double ar_s  = (a)->real / s; \
	double ai_s  = (a)->imag / s; \
	double yrt   = (y)->real; \
	double temp  = ( ar_s * (a)->real + ai_s * (a)->imag ); \
	(y)->real    = ( (yrt)     * ar_s + (y)->imag * ai_s ) / temp; \
	(y)->imag    = ( (y)->imag * ar_s - (yrt)     * ai_s ) / temp; \
}

// --- div3 ---

// void bl1_sdiv3( float* x, float* y, float* a );
#define bl1_sdiv3( x, y, a ) \
*(a) = *(x) / *(y);

// void bl1_ddiv3( double* x, double* y, double* a );
#define bl1_ddiv3( x, y, a ) \
*(a) = *(x) / *(y);

// void bl1_cdiv3( scomplex* x, scomplex* y, scomplex* a );
// a = x / y;
#define bl1_cdiv3( x, y, a ) \
{ \
	*a = *x; \
	bl1_cinvscals( y, a ); \
}

// void bl1_zdiv3( dcomplex* x, dcomplex* y, dcomplex* a );
#define bl1_zdiv3( x, y, a ) \
{ \
	*a = *x; \
	bl1_zinvscals( y, a ); \
}

// --- add3 ---

// void bl1_sadd3( float* x, float* y, float* a );
#define bl1_sadd3( x, y, a ) \
*(a) = *(x) + *(y);

// void bl1_dadd3( double* x, double* y, double* a );
#define bl1_dadd3( x, y, a ) \
*(a) = *(x) + *(y);

// void bl1_cadd3( scomplex* x, scomplex* y, scomplex* a );
#define bl1_cadd3( x, y, a ) \
{ \
(a)->real = (x)->real + (y)->real; \
(a)->imag = (x)->imag + (y)->imag; \
}

// void bl1_zadd3( dcomplex* x, dcomplex* y, dcomplex* a );
#define bl1_zadd3( x, y, a ) \
{ \
(a)->real = (x)->real + (y)->real; \
(a)->imag = (x)->imag + (y)->imag; \
}

// --- copys ---

// void bl1_scopys( conj1_t conj, float* x, float* y );
#define bl1_scopys( conj, x, y ) \
*(y) = *(x);

// void bl1_dcopys( conj1_t conj, double* x, double* y );
#define bl1_dcopys( conj, x, y ) \
*(y) = *(x);

// void bl1_ccopys( conj1_t conj, scomplex* x, scomplex* y );
#define bl1_ccopys( conj, x, y ) \
*(y) = *(x); \
if ( bl1_is_conj( conj ) ) (y)->imag *= -1.0F;

// void bl1_zcopys( conj1_t conj, dcomplex* x, dcomplex* y );
#define bl1_zcopys( conj, x, y ) \
*(y) = *(x); \
if ( bl1_is_conj( conj ) ) (y)->imag *= -1.0;

// --- scals ---

// void bl1_sscals( float* a, float* y );
#define bl1_sscals( a, y ) \
*(y) = *(a) * *(y);

// void bl1_dscals( double* a, double* y );
#define bl1_dscals( a, y ) \
*(y) = *(a) * *(y);

// void bl1_csscals( float* a, scomplex* y );
#define bl1_csscals( a, y ) \
{ \
(y)->real = *(a) * (y)->real; \
(y)->imag = *(a) * (y)->imag; \
}

// void bl1_cscals( scomplex* a, scomplex* y );
#define bl1_cscals( a, y ) \
{ \
float tempr = (a)->real * (y)->real - (a)->imag * (y)->imag; \
float tempi = (a)->imag * (y)->real + (a)->real * (y)->imag; \
(y)->real = tempr; \
(y)->imag = tempi; \
}

// void bl1_zdscals( double* a, dcomplex* y );
#define bl1_zdscals( a, y ) \
{ \
(y)->real = *(a) * (y)->real; \
(y)->imag = *(a) * (y)->imag; \
}

// void bl1_zscals( dcomplex* a, dcomplex* y );
#define bl1_zscals( a, y ) \
{ \
double tempr = (a)->real * (y)->real - (a)->imag * (y)->imag; \
double tempi = (a)->imag * (y)->real + (a)->real * (y)->imag; \
(y)->real = tempr; \
(y)->imag = tempi; \
}

// --- mult3 ---

// void bl1_smult3( float* x, float* y, float* a );
#define bl1_smult3( x, y, a ) \
*(a) = *(x) * *(y);

// void bl1_dmult3( double* x, double* y, double* a );
#define bl1_dmult3( x, y, a ) \
*(a) = *(x) * *(y);

// void bl1_cmult3( scomplex* x, scomplex* y, scomplex* a );
#define bl1_cmult3( x, y, a ) \
{ \
float tempr = (x)->real * (y)->real - (x)->imag * (y)->imag; \
float tempi = (x)->imag * (y)->real + (x)->real * (y)->imag; \
(a)->real = tempr; \
(a)->imag = tempi; \
}

// void bl1_zmult3( dcomplex* x, dcomplex* y, dcomplex* a );
#define bl1_zmult3( x, y, a ) \
{ \
double tempr = (x)->real * (y)->real - (x)->imag * (y)->imag; \
double tempi = (x)->imag * (y)->real + (x)->real * (y)->imag; \
(a)->real = tempr; \
(a)->imag = tempi; \
}

// --- mult4 ---

// void bl1_smult4( float* alpha, float* x, float* y1, float* y2 );
#define bl1_smult4( alpha, x, y1, y2 ) \
*(y2) = *(y1) + *(alpha) * *(x);

// void bl1_dmult4( double* alpha, double* x, double* y1, double* y2 );
#define bl1_dmult4( alpha, x, y1, y2 ) \
*(y2) = *(y1) + *(alpha) * *(x);

// void bl1_cmult4( scomplex* alpha, scomplex* x, scomplex* y1, scomplex* y2 );
#define bl1_cmult4( alpha, x, y1, y2 ) \
{ \
(y2)->real = (y1)->real + (alpha)->real * (x)->real - (alpha)->imag * (x)->imag; \
(y2)->imag = (y1)->imag + (alpha)->imag * (x)->real + (alpha)->real * (x)->imag; \
}

// void bl1_zmult4( dcomplex* alpha, dcomplex* x, dcomplex* y1, dcomplex* y2 );
#define bl1_zmult4( alpha, x, y1, y2 ) \
{ \
(y2)->real = (y1)->real + (alpha)->real * (x)->real - (alpha)->imag * (x)->imag; \
(y2)->imag = (y1)->imag + (alpha)->imag * (x)->real + (alpha)->real * (x)->imag; \
}

// --- conjs ---

// void bl1_sconjs( float* a );
#define bl1_sconjs( a ) \
;

// void bl1_dconjs( double* a );
#define bl1_dconjs( a ) \
;

// void bl1_cconjs( scomplex* a );
#define bl1_cconjs( a ) \
(a)->imag *= -1.0F;

// void bl1_zconjs( dcomplex* a );
#define bl1_zconjs( a ) \
(a)->imag *= -1.0;

// --- copyconj ---

// void bl1_scopyconj( float* x, float* y );
#define bl1_scopyconj( x, y ) \
*(y) = *(x);

// void bl1_dcopyconj( double* x, double* y );
#define bl1_dcopyconj( x, y ) \
*(y) = *(x);

// void bl1_ccopyconj( scomplex* x, scomplex* y );
#define bl1_ccopyconj( x, y ) \
(y)->real =         (x)->real; \
(y)->imag = -1.0F * (x)->imag;

// void bl1_zcopyconj( dcomplex* x, dcomplex* y );
#define bl1_zcopyconj( x, y ) \
(y)->real =         (x)->real; \
(y)->imag = -1.0  * (x)->imag;

// --- eq1 ---

// void bl1_seq1( float* alpha );
#define bl1_seq1( alpha ) \
  ( *alpha == 1.0F )

// void bl1_deq1( double* alpha );
#define bl1_deq1( alpha ) \
  ( *alpha == 1.0 )

// void bl1_ceq1( scomplex* alpha );
#define bl1_ceq1( alpha ) \
  ( (alpha)->real == 1.0F && (alpha)->imag == 0.0F )

// void bl1_zeq1( dcomplex* alpha );
#define bl1_zeq1( alpha ) \
  ( (alpha)->real == 1.0 && (alpha)->imag == 0.0 )

// --- Swapping/toggle macros --------------------------------------------------

// --- swap_pointers ---

#define bl1_sswap_pointers( a, b ) \
{ \
float* temp = (a); \
(a) = (b); \
(b) = temp; \
}

#define bl1_dswap_pointers( a, b ) \
{ \
double* temp = (a); \
(a) = (b); \
(b) = temp; \
}

#define bl1_cswap_pointers( a, b ) \
{ \
void* temp = (a); \
(a) = (b); \
(b) = temp; \
}

#define bl1_zswap_pointers( a, b ) \
{ \
void* temp = (a); \
(a) = (b); \
(b) = temp; \
}

// --- swap_ints ---

#define bl1_swap_ints( a, b ) \
{ \
int temp = (a); \
(a) = (b); \
(b) = temp; \
}

// --- swap_trans ---

#define bl1_swap_trans( a, b ) \
{ \
trans1_t temp = (a); \
(a) = (b); \
(b) = temp; \
}

// --- swap_conj ---

#define bl1_swap_conj( a, b ) \
{ \
conj1_t temp = (a); \
(a) = (b); \
(b) = temp; \
}

// --- toggle_side ---

#define bl1_toggle_side( side ) \
{ \
if ( bl1_is_left( side ) ) side = BLIS1_RIGHT; \
else                       side = BLIS1_LEFT; \
}

// --- toggle_uplo ---

#define bl1_toggle_uplo( uplo ) \
{ \
if ( bl1_is_lower( uplo ) ) uplo = BLIS1_UPPER_TRIANGULAR; \
else                        uplo = BLIS1_LOWER_TRIANGULAR; \
}

// --- toggle_trans ---
#define bl1_toggle_trans( trans ) \
{ \
if      ( bl1_is_notrans( trans ) )     trans = BLIS1_TRANSPOSE; \
else if ( bl1_is_trans( trans ) )       trans = BLIS1_NO_TRANSPOSE; \
else if ( bl1_is_conjnotrans( trans ) ) trans = BLIS1_CONJ_TRANSPOSE; \
else                                    trans = BLIS1_CONJ_NO_TRANSPOSE; \
}

// --- toggle_conjtrans ---
#define bl1_toggle_conjtrans( trans ) \
{ \
if      ( bl1_is_notrans( trans ) )     trans = BLIS1_CONJ_TRANSPOSE; \
else                                    trans = BLIS1_NO_TRANSPOSE; \
}

// --- toggle_conj ---

#define bl1_toggle_conj( conj ) \
{ \
if ( bl1_is_conj( conj ) ) conj = BLIS1_NO_CONJUGATE; \
else                       conj = BLIS1_CONJUGATE; \
}

#endif // #ifndef BLIS1_MACRO_DEFS_H
// end blis_macro_defs.h
// begin blis_type_defs.h


#ifndef BLIS1_TYPE_DEFS_H
#define BLIS1_TYPE_DEFS_H

#ifdef __cplusplus
// For C++, include stdint.h.
#include <stdint.h> // skipped
#elif __STDC_VERSION__ >= 199901L
// For C99 (or later), include stdint.h.
#include <stdint.h> // skipped
#else
// When stdint.h is not available, manually typedef the types we will use.
#ifdef _WIN32
typedef          __int32  int32_t;
typedef unsigned __int32 uint32_t;
typedef          __int64  int64_t;
typedef unsigned __int64 uint64_t;
#else
#error "Attempting to compile on pre-C99 system without stdint.h."
#endif
#endif

#if defined(FLA_ENABLE_ILP64)
typedef int64_t integer;
typedef uint64_t uinteger;
#else
typedef int integer;
typedef unsigned long uinteger;
#endif


// --- Basic type definitions -------------------------------------------------



#define BLIS1_TRANS_BEGIN 100
#define BLIS1_UPLO_BEGIN  200
#define BLIS1_SIDE_BEGIN  300
#define BLIS1_DIAG_BEGIN  400
#define BLIS1_CONJ_BEGIN  500

typedef enum
{
	BLIS1_NO_TRANSPOSE = BLIS1_TRANS_BEGIN,
	BLIS1_TRANSPOSE,
	BLIS1_CONJ_NO_TRANSPOSE,
	BLIS1_CONJ_TRANSPOSE
} trans1_t;

typedef enum
{
	BLIS1_LOWER_TRIANGULAR = BLIS1_UPLO_BEGIN,
	BLIS1_UPPER_TRIANGULAR
} uplo1_t;

typedef enum
{
	BLIS1_LEFT = BLIS1_SIDE_BEGIN,
	BLIS1_RIGHT
} side1_t;

typedef enum
{
	BLIS1_NONUNIT_DIAG = BLIS1_DIAG_BEGIN,
	BLIS1_UNIT_DIAG,
	BLIS1_ZERO_DIAG
} diag1_t;

typedef enum
{
	BLIS1_NO_CONJUGATE = BLIS1_CONJ_BEGIN,
	BLIS1_CONJUGATE
} conj1_t;





// --- Intrinsic/assembly definitions ----------------------------------------





// Only define vector intrinsics types if they are not already provided by
// libflame.
#ifndef BLIS1_FROM_LIBFLAME

#if BLIS1_VECTOR_INTRINSIC_TYPE == BLIS1_SSE_INTRINSICS

#include "pmmintrin.h" // skipped
typedef union
{
    __m128d v; 
    double  d[2];
} v2df_t;
#endif

#endif


#endif // BLIS1_TYPE_DEFS_H
// end blis_type_defs.h

// begin blis_prototypes_util.h


// --- Utility-level BLAS-like prototypes --------------------------------------

// --- constant-generating functions ---

float    bl1_s2( void );
double   bl1_d2( void );
scomplex bl1_c2( void );
dcomplex bl1_z2( void );
float    bl1_s1( void );
double   bl1_d1( void );
scomplex bl1_c1( void );
dcomplex bl1_z1( void );
float    bl1_s1h( void );
double   bl1_d1h( void );
scomplex bl1_c1h( void );
dcomplex bl1_z1h( void );
float    bl1_s0( void );
double   bl1_d0( void );
scomplex bl1_c0( void );
dcomplex bl1_z0( void );
float    bl1_sm1h( void );
double   bl1_dm1h( void );
scomplex bl1_cm1h( void );
dcomplex bl1_zm1h( void );
float    bl1_sm1( void );
double   bl1_dm1( void );
scomplex bl1_cm1( void );
dcomplex bl1_zm1( void );
float    bl1_sm2( void );
double   bl1_dm2( void );
scomplex bl1_cm2( void );
dcomplex bl1_zm2( void );

// --- allocv ---

void*     bl1_vallocv( uinteger n_elem, uinteger elem_size );
integer*      bl1_iallocv( uinteger n_elem );
float*    bl1_sallocv( uinteger n_elem );
double*   bl1_dallocv( uinteger n_elem );
scomplex* bl1_callocv( uinteger n_elem );
dcomplex* bl1_zallocv( uinteger n_elem );

// --- allocm ---

void*     bl1_vallocm( uinteger m, uinteger n, uinteger elem_size );
integer*      bl1_iallocm( uinteger m, uinteger n );
float*    bl1_sallocm( uinteger m, uinteger n );
double*   bl1_dallocm( uinteger m, uinteger n );
scomplex* bl1_callocm( uinteger m, uinteger n );
dcomplex* bl1_zallocm( uinteger m, uinteger n );

// --- apdiagmv ---

void bl1_sapdiagmv( side1_t side, conj1_t conj, integer m, integer n, float*    x, integer incx, float*    a, integer a_rs, integer a_cs );
void bl1_dapdiagmv( side1_t side, conj1_t conj, integer m, integer n, double*   x, integer incx, double*   a, integer a_rs, integer a_cs );
void bl1_csapdiagmv( side1_t side, conj1_t conj, integer m, integer n, float*    x, integer incx, scomplex* a, integer a_rs, integer a_cs );
void bl1_capdiagmv( side1_t side, conj1_t conj, integer m, integer n, scomplex* x, integer incx, scomplex* a, integer a_rs, integer a_cs );
void bl1_zdapdiagmv( side1_t side, conj1_t conj, integer m, integer n, double*   x, integer incx, dcomplex* a, integer a_rs, integer a_cs );
void bl1_zapdiagmv( side1_t side, conj1_t conj, integer m, integer n, dcomplex* x, integer incx, dcomplex* a, integer a_rs, integer a_cs );

// --- create_contigm ---

void bl1_screate_contigm( integer m, integer n, float*    a_save, integer a_rs_save, integer a_cs_save, float**    a, integer* a_rs, integer* a_cs );
void bl1_dcreate_contigm( integer m, integer n, double*   a_save, integer a_rs_save, integer a_cs_save, double**   a, integer* a_rs, integer* a_cs );
void bl1_ccreate_contigm( integer m, integer n, scomplex* a_save, integer a_rs_save, integer a_cs_save, scomplex** a, integer* a_rs, integer* a_cs );
void bl1_zcreate_contigm( integer m, integer n, dcomplex* a_save, integer a_rs_save, integer a_cs_save, dcomplex** a, integer* a_rs, integer* a_cs );

// --- create_contigmt ---

void bl1_screate_contigmt( trans1_t trans_dims, integer m, integer n, float*    a_save, integer a_rs_save, integer a_cs_save, float**    a, integer* a_rs, integer* a_cs );
void bl1_dcreate_contigmt( trans1_t trans_dims, integer m, integer n, double*   a_save, integer a_rs_save, integer a_cs_save, double**   a, integer* a_rs, integer* a_cs );
void bl1_ccreate_contigmt( trans1_t trans_dims, integer m, integer n, scomplex* a_save, integer a_rs_save, integer a_cs_save, scomplex** a, integer* a_rs, integer* a_cs );
void bl1_zcreate_contigmt( trans1_t trans_dims, integer m, integer n, dcomplex* a_save, integer a_rs_save, integer a_cs_save, dcomplex** a, integer* a_rs, integer* a_cs );

// --- create_contigmr ---

void bl1_screate_contigmr( uplo1_t uplo, integer m, integer n, float*    a_save, integer a_rs_save, integer a_cs_save, float**    a, integer* a_rs, integer* a_cs );
void bl1_dcreate_contigmr( uplo1_t uplo, integer m, integer n, double*   a_save, integer a_rs_save, integer a_cs_save, double**   a, integer* a_rs, integer* a_cs );
void bl1_ccreate_contigmr( uplo1_t uplo, integer m, integer n, scomplex* a_save, integer a_rs_save, integer a_cs_save, scomplex** a, integer* a_rs, integer* a_cs );
void bl1_zcreate_contigmr( uplo1_t uplo, integer m, integer n, dcomplex* a_save, integer a_rs_save, integer a_cs_save, dcomplex** a, integer* a_rs, integer* a_cs );

// --- create_contigmsr ---

void bl1_screate_contigmsr( side1_t side, uplo1_t uplo, integer m, integer n, float*    a_save, integer a_rs_save, integer a_cs_save, float**    a, integer* a_rs, integer* a_cs );
void bl1_dcreate_contigmsr( side1_t side, uplo1_t uplo, integer m, integer n, double*   a_save, integer a_rs_save, integer a_cs_save, double**   a, integer* a_rs, integer* a_cs );
void bl1_ccreate_contigmsr( side1_t side, uplo1_t uplo, integer m, integer n, scomplex* a_save, integer a_rs_save, integer a_cs_save, scomplex** a, integer* a_rs, integer* a_cs );
void bl1_zcreate_contigmsr( side1_t side, uplo1_t uplo, integer m, integer n, dcomplex* a_save, integer a_rs_save, integer a_cs_save, dcomplex** a, integer* a_rs, integer* a_cs );

// --- free_contigm ---

void bl1_sfree_contigm( float*    a_save, integer a_rs_save, integer a_cs_save, float**    a, integer* a_rs, integer* a_cs );
void bl1_dfree_contigm( double*   a_save, integer a_rs_save, integer a_cs_save, double**   a, integer* a_rs, integer* a_cs );
void bl1_cfree_contigm( scomplex* a_save, integer a_rs_save, integer a_cs_save, scomplex** a, integer* a_rs, integer* a_cs );
void bl1_zfree_contigm( dcomplex* a_save, integer a_rs_save, integer a_cs_save, dcomplex** a, integer* a_rs, integer* a_cs );

// --- free_saved_contigm ---

void bl1_sfree_saved_contigm( integer m, integer n, float*    a_save, integer a_rs_save, integer a_cs_save, float**    a, integer* a_rs, integer* a_cs );
void bl1_dfree_saved_contigm( integer m, integer n, double*   a_save, integer a_rs_save, integer a_cs_save, double**   a, integer* a_rs, integer* a_cs );
void bl1_cfree_saved_contigm( integer m, integer n, scomplex* a_save, integer a_rs_save, integer a_cs_save, scomplex** a, integer* a_rs, integer* a_cs );
void bl1_zfree_saved_contigm( integer m, integer n, dcomplex* a_save, integer a_rs_save, integer a_cs_save, dcomplex** a, integer* a_rs, integer* a_cs );

// --- free_saved_contigmr ---

void bl1_sfree_saved_contigmr( uplo1_t uplo, integer m, integer n, float*    a_save, integer a_rs_save, integer a_cs_save, float**    a, integer* a_rs, integer* a_cs );
void bl1_dfree_saved_contigmr( uplo1_t uplo, integer m, integer n, double*   a_save, integer a_rs_save, integer a_cs_save, double**   a, integer* a_rs, integer* a_cs );
void bl1_cfree_saved_contigmr( uplo1_t uplo, integer m, integer n, scomplex* a_save, integer a_rs_save, integer a_cs_save, scomplex** a, integer* a_rs, integer* a_cs );
void bl1_zfree_saved_contigmr( uplo1_t uplo, integer m, integer n, dcomplex* a_save, integer a_rs_save, integer a_cs_save, dcomplex** a, integer* a_rs, integer* a_cs );

// --- free_saved_contigmsr ---

void bl1_sfree_saved_contigmsr( side1_t side, uplo1_t uplo, integer m, integer n, float*    a_save, integer a_rs_save, integer a_cs_save, float**    a, integer* a_rs, integer* a_cs );
void bl1_dfree_saved_contigmsr( side1_t side, uplo1_t uplo, integer m, integer n, double*   a_save, integer a_rs_save, integer a_cs_save, double**   a, integer* a_rs, integer* a_cs );
void bl1_cfree_saved_contigmsr( side1_t side, uplo1_t uplo, integer m, integer n, scomplex* a_save, integer a_rs_save, integer a_cs_save, scomplex** a, integer* a_rs, integer* a_cs );
void bl1_zfree_saved_contigmsr( side1_t side, uplo1_t uplo, integer m, integer n, dcomplex* a_save, integer a_rs_save, integer a_cs_save, dcomplex** a, integer* a_rs, integer* a_cs );

// --- ewinvscalv ---

void bl1_sewinvscalv( conj1_t conj, integer n, float*    x, integer incx, float*    y, integer incy );
void bl1_dewinvscalv( conj1_t conj, integer n, double*   x, integer incx, double*   y, integer incy );
void bl1_csewinvscalv( conj1_t conj, integer n, float*    x, integer incx, scomplex* y, integer incy );
void bl1_cewinvscalv( conj1_t conj, integer n, scomplex* x, integer incx, scomplex* y, integer incy );
void bl1_zdewinvscalv( conj1_t conj, integer n, double*   x, integer incx, dcomplex* y, integer incy );
void bl1_zewinvscalv( conj1_t conj, integer n, dcomplex* x, integer incx, dcomplex* y, integer incy );

// --- ewscalmt ---

void bl1_sewinvscalmt( trans1_t trans, integer m, integer n, float*    a, integer a_rs, integer a_cs, float*    b, integer b_rs, integer b_cs );
void bl1_dewinvscalmt( trans1_t trans, integer m, integer n, double*   a, integer a_rs, integer a_cs, double*   b, integer b_rs, integer b_cs );
void bl1_csewinvscalmt( trans1_t trans, integer m, integer n, float*    a, integer a_rs, integer a_cs, scomplex* b, integer b_rs, integer b_cs );
void bl1_cewinvscalmt( trans1_t trans, integer m, integer n, scomplex* a, integer a_rs, integer a_cs, scomplex* b, integer b_rs, integer b_cs );
void bl1_zdewinvscalmt( trans1_t trans, integer m, integer n, double*   a, integer a_rs, integer a_cs, dcomplex* b, integer b_rs, integer b_cs );
void bl1_zewinvscalmt( trans1_t trans, integer m, integer n, dcomplex* a, integer a_rs, integer a_cs, dcomplex* b, integer b_rs, integer b_cs );

// --- ewscalv ---

void bl1_sewscalv( conj1_t conj, integer n, float*    x, integer incx, float*    y, integer incy );
void bl1_dewscalv( conj1_t conj, integer n, double*   x, integer incx, double*   y, integer incy );
void bl1_csewscalv( conj1_t conj, integer n, float*    x, integer incx, scomplex* y, integer incy );
void bl1_cewscalv( conj1_t conj, integer n, scomplex* x, integer incx, scomplex* y, integer incy );
void bl1_zdewscalv( conj1_t conj, integer n, double*   x, integer incx, dcomplex* y, integer incy );
void bl1_zewscalv( conj1_t conj, integer n, dcomplex* x, integer incx, dcomplex* y, integer incy );

// --- ewscalmt ---

void bl1_sewscalmt( trans1_t trans, integer m, integer n, float*    a, integer a_rs, integer a_cs, float*    b, integer b_rs, integer b_cs );
void bl1_dewscalmt( trans1_t trans, integer m, integer n, double*   a, integer a_rs, integer a_cs, double*   b, integer b_rs, integer b_cs );
void bl1_csewscalmt( trans1_t trans, integer m, integer n, float*    a, integer a_rs, integer a_cs, scomplex* b, integer b_rs, integer b_cs );
void bl1_cewscalmt( trans1_t trans, integer m, integer n, scomplex* a, integer a_rs, integer a_cs, scomplex* b, integer b_rs, integer b_cs );
void bl1_zdewscalmt( trans1_t trans, integer m, integer n, double*   a, integer a_rs, integer a_cs, dcomplex* b, integer b_rs, integer b_cs );
void bl1_zewscalmt( trans1_t trans, integer m, integer n, dcomplex* a, integer a_rs, integer a_cs, dcomplex* b, integer b_rs, integer b_cs );

// --- free ---

void bl1_vfree( void*     p );
void bl1_ifree( integer*      p );
void bl1_sfree( float*    p );
void bl1_dfree( double*   p );
void bl1_cfree( scomplex* p );
void bl1_zfree( dcomplex* p );

// --- inverts ---

void bl1_sinverts( conj1_t conj, float*    alpha );
void bl1_dinverts( conj1_t conj, double*   alpha );
void bl1_cinverts( conj1_t conj, scomplex* alpha );
void bl1_zinverts( conj1_t conj, dcomplex* alpha );

// --- invert2s ---

void bl1_sinvert2s( conj1_t conj, float*    alpha, float*    beta );
void bl1_dinvert2s( conj1_t conj, double*   alpha, double*   beta );
void bl1_cinvert2s( conj1_t conj, scomplex* alpha, scomplex* beta );
void bl1_zinvert2s( conj1_t conj, dcomplex* alpha, dcomplex* beta );

// --- invertv ---

void bl1_sinvertv( conj1_t conj, integer n, float*    x, integer incx );
void bl1_dinvertv( conj1_t conj, integer n, double*   x, integer incx );
void bl1_cinvertv( conj1_t conj, integer n, scomplex* x, integer incx );
void bl1_zinvertv( conj1_t conj, integer n, dcomplex* x, integer incx );

// --- ident ---

void bl1_sident( integer m, float*    a, integer a_rs, integer a_cs );
void bl1_dident( integer m, double*   a, integer a_rs, integer a_cs );
void bl1_cident( integer m, scomplex* a, integer a_rs, integer a_cs );
void bl1_zident( integer m, dcomplex* a, integer a_rs, integer a_cs );

// --- maxabsv ---

void bl1_smaxabsv( integer n, float*    x, integer incx, float*  maxabs );
void bl1_dmaxabsv( integer n, double*   x, integer incx, double* maxabs );
void bl1_cmaxabsv( integer n, scomplex* x, integer incx, float*  maxabs );
void bl1_zmaxabsv( integer n, dcomplex* x, integer incx, double* maxabs );

// --- maxabsm ---

void bl1_smaxabsm( integer m, integer n, float*    a, integer a_rs, integer a_cs, float*  maxabs );
void bl1_dmaxabsm( integer m, integer n, double*   a, integer a_rs, integer a_cs, double* maxabs );
void bl1_cmaxabsm( integer m, integer n, scomplex* a, integer a_rs, integer a_cs, float*  maxabs );
void bl1_zmaxabsm( integer m, integer n, dcomplex* a, integer a_rs, integer a_cs, double* maxabs );

// --- maxabsmr ---

void bl1_smaxabsmr( uplo1_t uplo, integer m, integer n, float*    a, integer a_rs, integer a_cs, float*  maxabs );
void bl1_dmaxabsmr( uplo1_t uplo, integer m, integer n, double*   a, integer a_rs, integer a_cs, double* maxabs );
void bl1_cmaxabsmr( uplo1_t uplo, integer m, integer n, scomplex* a, integer a_rs, integer a_cs, float*  maxabs );
void bl1_zmaxabsmr( uplo1_t uplo, integer m, integer n, dcomplex* a, integer a_rs, integer a_cs, double* maxabs );

// --- rands ---

void bl1_srands( float*    alpha );
void bl1_drands( double*   alpha );
void bl1_crands( scomplex* alpha );
void bl1_zrands( dcomplex* alpha );

// --- randv ---

void bl1_srandv( integer n, float*    x, integer incx );
void bl1_drandv( integer n, double*   x, integer incx );
void bl1_crandv( integer n, scomplex* x, integer incx );
void bl1_zrandv( integer n, dcomplex* x, integer incx );

// --- randm ---

void bl1_srandm( integer m, integer n, float*    a, integer a_rs, integer a_cs );
void bl1_drandm( integer m, integer n, double*   a, integer a_rs, integer a_cs );
void bl1_crandm( integer m, integer n, scomplex* a, integer a_rs, integer a_cs );
void bl1_zrandm( integer m, integer n, dcomplex* a, integer a_rs, integer a_cs );

// --- randmr ---
void bl1_srandmr( uplo1_t uplo, diag1_t diag, integer m, integer n, float*    a, integer a_rs, integer a_cs );
void bl1_drandmr( uplo1_t uplo, diag1_t diag, integer m, integer n, double*   a, integer a_rs, integer a_cs );
void bl1_crandmr( uplo1_t uplo, diag1_t diag, integer m, integer n, scomplex* a, integer a_rs, integer a_cs );
void bl1_zrandmr( uplo1_t uplo, diag1_t diag, integer m, integer n, dcomplex* a, integer a_rs, integer a_cs );

// --- set_contig_strides ---

void bl1_set_contig_strides( integer m, integer n, integer* rs, integer* cs );

// --- set_dims_with_side ---

void bl1_set_dim_with_side( side1_t side, integer m, integer n, integer* dim_new );

// --- set_dims_with_trans ---

void bl1_set_dims_with_trans( trans1_t trans, integer m, integer n, integer* m_new, integer* n_new );

// --- setv ---

void bl1_isetv( integer m, integer*      sigma, integer*      x, integer incx );
void bl1_ssetv( integer m, float*    sigma, float*    x, integer incx );
void bl1_dsetv( integer m, double*   sigma, double*   x, integer incx );
void bl1_csetv( integer m, scomplex* sigma, scomplex* x, integer incx );
void bl1_zsetv( integer m, dcomplex* sigma, dcomplex* x, integer incx );

// --- setm ---

void bl1_isetm( integer m, integer n, integer*      sigma, integer*      a, integer a_rs, integer a_cs );
void bl1_ssetm( integer m, integer n, float*    sigma, float*    a, integer a_rs, integer a_cs );
void bl1_dsetm( integer m, integer n, double*   sigma, double*   a, integer a_rs, integer a_cs );
void bl1_csetm( integer m, integer n, scomplex* sigma, scomplex* a, integer a_rs, integer a_cs );
void bl1_zsetm( integer m, integer n, dcomplex* sigma, dcomplex* a, integer a_rs, integer a_cs );

// --- setmr ---

void bl1_ssetmr( uplo1_t uplo, integer m, integer n, float*    sigma, float*    a, integer a_rs, integer a_cs );
void bl1_dsetmr( uplo1_t uplo, integer m, integer n, double*   sigma, double*   a, integer a_rs, integer a_cs );
void bl1_csetmr( uplo1_t uplo, integer m, integer n, scomplex* sigma, scomplex* a, integer a_rs, integer a_cs );
void bl1_zsetmr( uplo1_t uplo, integer m, integer n, dcomplex* sigma, dcomplex* a, integer a_rs, integer a_cs );

// --- setdiag ---

void bl1_isetdiag( integer offset, integer m, integer n, integer*      sigma, integer*      a, integer a_rs, integer a_cs );
void bl1_ssetdiag( integer offset, integer m, integer n, float*    sigma, float*    a, integer a_rs, integer a_cs );
void bl1_dsetdiag( integer offset, integer m, integer n, double*   sigma, double*   a, integer a_rs, integer a_cs );
void bl1_csetdiag( integer offset, integer m, integer n, scomplex* sigma, scomplex* a, integer a_rs, integer a_cs );
void bl1_zsetdiag( integer offset, integer m, integer n, dcomplex* sigma, dcomplex* a, integer a_rs, integer a_cs );

// --- scalediag ---

void bl1_sscalediag( conj1_t conj, integer offset, integer m, integer n, float*    sigma, float*    a, integer a_rs, integer a_cs );
void bl1_dscalediag( conj1_t conj, integer offset, integer m, integer n, double*   sigma, double*   a, integer a_rs, integer a_cs );
void bl1_cscalediag( conj1_t conj, integer offset, integer m, integer n, scomplex* sigma, scomplex* a, integer a_rs, integer a_cs );
void bl1_zscalediag( conj1_t conj, integer offset, integer m, integer n, dcomplex* sigma, dcomplex* a, integer a_rs, integer a_cs );
void bl1_csscalediag( conj1_t conj, integer offset, integer m, integer n, float*    sigma, scomplex* a, integer a_rs, integer a_cs );
void bl1_zdscalediag( conj1_t conj, integer offset, integer m, integer n, double*   sigma, dcomplex* a, integer a_rs, integer a_cs );

// --- shiftdiag ---

void bl1_sshiftdiag( conj1_t conj, integer offset, integer m, integer n, float*    sigma, float*    a, integer a_rs, integer a_cs );
void bl1_dshiftdiag( conj1_t conj, integer offset, integer m, integer n, double*   sigma, double*   a, integer a_rs, integer a_cs );
void bl1_cshiftdiag( conj1_t conj, integer offset, integer m, integer n, scomplex* sigma, scomplex* a, integer a_rs, integer a_cs );
void bl1_zshiftdiag( conj1_t conj, integer offset, integer m, integer n, dcomplex* sigma, dcomplex* a, integer a_rs, integer a_cs );
void bl1_csshiftdiag( conj1_t conj, integer offset, integer m, integer n, float*    sigma, scomplex* a, integer a_rs, integer a_cs );
void bl1_zdshiftdiag( conj1_t conj, integer offset, integer m, integer n, double*   sigma, dcomplex* a, integer a_rs, integer a_cs );

// --- symmize ---

void bl1_ssymmize( conj1_t conj, uplo1_t uplo, integer m, float*    a, integer a_rs, integer a_cs );
void bl1_dsymmize( conj1_t conj, uplo1_t uplo, integer m, double*   a, integer a_rs, integer a_cs );
void bl1_csymmize( conj1_t conj, uplo1_t uplo, integer m, scomplex* a, integer a_rs, integer a_cs );
void bl1_zsymmize( conj1_t conj, uplo1_t uplo, integer m, dcomplex* a, integer a_rs, integer a_cs );

// end blis_prototypes_util.h
// begin blis_prototypes_query.h


// --- Query routine prototypes ------------------------------------------------

// --- trans ---

int bl1_does_trans( trans1_t trans );
int bl1_does_notrans( trans1_t trans );
int bl1_does_conj( trans1_t trans );

int bl1_is_notrans( trans1_t trans );
int bl1_is_trans( trans1_t trans );
int bl1_is_conjnotrans( trans1_t trans );
int bl1_is_conjtrans( trans1_t trans );

// --- conj ---

int bl1_is_noconj( conj1_t conj );
int bl1_is_conj( conj1_t conj );

// --- uplo ---

int bl1_is_lower( uplo1_t uplo );
int bl1_is_upper( uplo1_t uplo );

// --- side ---

int bl1_is_left( side1_t side );
int bl1_is_right( side1_t side );

// --- diag ---

int bl1_is_nonunit_diag( diag1_t diag );
int bl1_is_unit_diag( diag1_t diag );
int bl1_is_zero_diag( diag1_t diag );

// --- mapping-related ---

conj1_t bl1_proj_trans1_to_conj( trans1_t trans );

// --- storage-related ---

void bl1_check_storage_3m( integer a_rs, integer a_cs, integer b_rs, integer b_cs, integer c_rs, integer c_cs );
void bl1_check_storage_2m( integer a_rs, integer a_cs, integer b_rs, integer b_cs );
int bl1_is_row_or_col_storage( integer rs, integer cs );
int bl1_is_row_storage( integer rs, integer cs );
int bl1_is_col_storage( integer rs, integer cs );
int bl1_is_gen_storage( integer rs, integer cs );
int bl1_is_vector( integer m, integer n );

// --- vector-related ---

int bl1_vector_dim( integer m, integer n );
int bl1_vector_inc( trans1_t trans, integer m, integer n, integer rs, integer cs );

// --- dimension-related ---

int bl1_zero_dim1( integer m );
int bl1_zero_dim2( integer m, integer n );
int bl1_zero_dim3( integer m, integer k, integer n );

// end blis_prototypes_query.h
// begin blis_prototypes_misc.h


// --- Abort prototypes --------------------------------------------------------

void bl1_abort( void );
void bl1_abort_msg( char* message );

// --- Parameter-mapping prototypes --------------------------------------------

void bl1_param_map_to_netlib_trans( trans1_t blis_trans, void* blas_trans );
void bl1_param_map_to_netlib_uplo(  uplo1_t  blis_uplo,  void* blas_uplo );
void bl1_param_map_to_netlib_side(  side1_t  blis_side,  void* blas_side );
void bl1_param_map_to_netlib_diag(  diag1_t  blis_diag,  void* blas_diag );

// end blis_prototypes_misc.h

 
// begin blis_prototypes_level1.h


// --- Level-1 BLAS-like prototypes --------------------------------------------

// --- amax ---

void bl1_samax( integer n, float*    x, integer incx, integer* index );
void bl1_damax( integer n, double*   x, integer incx, integer* index );
void bl1_camax( integer n, scomplex* x, integer incx, integer* index );
void bl1_zamax( integer n, dcomplex* x, integer incx, integer* index );

// --- asum ---

void bl1_sasum( integer n, float*    x, integer incx, float*  norm );
void bl1_dasum( integer n, double*   x, integer incx, double* norm );
void bl1_casum( integer n, scomplex* x, integer incx, float*  norm );
void bl1_zasum( integer n, dcomplex* x, integer incx, double* norm );

// --- axpy ---

void bl1_saxpy( integer n, float*    alpha, float*    x, integer incx, float*    y, integer incy );
void bl1_daxpy( integer n, double*   alpha, double*   x, integer incx, double*   y, integer incy );
void bl1_caxpy( integer n, scomplex* alpha, scomplex* x, integer incx, scomplex* y, integer incy );
void bl1_zaxpy( integer n, dcomplex* alpha, dcomplex* x, integer incx, dcomplex* y, integer incy );

// --- axpyv ---

void bl1_saxpyv( conj1_t conj, integer n, float*    alpha, float*    x, integer incx, float*    y, integer incy );
void bl1_daxpyv( conj1_t conj, integer n, double*   alpha, double*   x, integer incx, double*   y, integer incy );
void bl1_caxpyv( conj1_t conj, integer n, scomplex* alpha, scomplex* x, integer incx, scomplex* y, integer incy );
void bl1_zaxpyv( conj1_t conj, integer n, dcomplex* alpha, dcomplex* x, integer incx, dcomplex* y, integer incy );

// --- axpymt ---

void bl1_saxpymt( trans1_t trans, integer m, integer n, float*    alpha, float*    a, integer a_rs, integer a_cs, float*    b, integer b_rs, integer b_cs );
void bl1_daxpymt( trans1_t trans, integer m, integer n, double*   alpha, double*   a, integer a_rs, integer a_cs, double*   b, integer b_rs, integer b_cs );
void bl1_caxpymt( trans1_t trans, integer m, integer n, scomplex* alpha, scomplex* a, integer a_rs, integer a_cs, scomplex* b, integer b_rs, integer b_cs );
void bl1_zaxpymt( trans1_t trans, integer m, integer n, dcomplex* alpha, dcomplex* a, integer a_rs, integer a_cs, dcomplex* b, integer b_rs, integer b_cs );

// --- axpymrt ---

void bl1_saxpymrt( uplo1_t uplo, trans1_t trans, integer m, integer n, float*    alpha, float*    a, integer a_rs, integer a_cs, float*    b, integer b_rs, integer b_cs );
void bl1_daxpymrt( uplo1_t uplo, trans1_t trans, integer m, integer n, double*   alpha, double*   a, integer a_rs, integer a_cs, double*   b, integer b_rs, integer b_cs );
void bl1_caxpymrt( uplo1_t uplo, trans1_t trans, integer m, integer n, scomplex* alpha, scomplex* a, integer a_rs, integer a_cs, scomplex* b, integer b_rs, integer b_cs );
void bl1_zaxpymrt( uplo1_t uplo, trans1_t trans, integer m, integer n, dcomplex* alpha, dcomplex* a, integer a_rs, integer a_cs, dcomplex* b, integer b_rs, integer b_cs );

// --- axpysv ---

void bl1_saxpysv( integer n, float*    alpha0, float*    alpha1, float*    x, integer incx, float*    beta, float*    y, integer incy );
void bl1_daxpysv( integer n, double*   alpha0, double*   alpha1, double*   x, integer incx, double*   beta, double*   y, integer incy );
void bl1_caxpysv( integer n, scomplex* alpha0, scomplex* alpha1, scomplex* x, integer incx, scomplex* beta, scomplex* y, integer incy );
void bl1_zaxpysv( integer n, dcomplex* alpha0, dcomplex* alpha1, dcomplex* x, integer incx, dcomplex* beta, dcomplex* y, integer incy );

// --- axpysmt ---

void bl1_saxpysmt( trans1_t trans, integer m, integer n, float*    alpha0, float*    alpha1, float*    a, integer a_rs, integer a_cs, float*    beta, float*    b, integer b_rs, integer b_cs );
void bl1_daxpysmt( trans1_t trans, integer m, integer n, double*   alpha0, double*   alpha1, double*   a, integer a_rs, integer a_cs, double*   beta, double*   b, integer b_rs, integer b_cs );
void bl1_caxpysmt( trans1_t trans, integer m, integer n, scomplex* alpha0, scomplex* alpha1, scomplex* a, integer a_rs, integer a_cs, scomplex* beta, scomplex* b, integer b_rs, integer b_cs );
void bl1_zaxpysmt( trans1_t trans, integer m, integer n, dcomplex* alpha0, dcomplex* alpha1, dcomplex* a, integer a_rs, integer a_cs, dcomplex* beta, dcomplex* b, integer b_rs, integer b_cs );

// --- conjv ---

void bl1_sconjv( integer m, float* x, integer incx );
void bl1_dconjv( integer m, double* x, integer incx );
void bl1_cconjv( integer m, scomplex* x, integer incx );
void bl1_zconjv( integer m, dcomplex* x, integer incx );

// --- conjm ---

void bl1_sconjm( integer m, integer n, float*    a, integer a_rs, integer a_cs );
void bl1_dconjm( integer m, integer n, double*   a, integer a_rs, integer a_cs );
void bl1_cconjm( integer m, integer n, scomplex* a, integer a_rs, integer a_cs );
void bl1_zconjm( integer m, integer n, dcomplex* a, integer a_rs, integer a_cs );

// --- conjmr ---

void bl1_sconjmr( uplo1_t uplo, integer m, integer n, float*    a, integer a_rs, integer a_cs );
void bl1_dconjmr( uplo1_t uplo, integer m, integer n, double*   a, integer a_rs, integer a_cs );
void bl1_cconjmr( uplo1_t uplo, integer m, integer n, scomplex* a, integer a_rs, integer a_cs );
void bl1_zconjmr( uplo1_t uplo, integer m, integer n, dcomplex* a, integer a_rs, integer a_cs );

// --- copy ---

void bl1_scopy( integer m, float*    x, integer incx, float*    y, integer incy );
void bl1_dcopy( integer m, double*   x, integer incx, double*   y, integer incy );
void bl1_ccopy( integer m, scomplex* x, integer incx, scomplex* y, integer incy );
void bl1_zcopy( integer m, dcomplex* x, integer incx, dcomplex* y, integer incy );

// --- copyv ---

void bl1_icopyv( conj1_t conj, integer m, integer*      x, integer incx, integer*      y, integer incy );
void bl1_scopyv( conj1_t conj, integer m, float*    x, integer incx, float*    y, integer incy );
void bl1_dcopyv( conj1_t conj, integer m, double*   x, integer incx, double*   y, integer incy );
void bl1_ccopyv( conj1_t conj, integer m, scomplex* x, integer incx, scomplex* y, integer incy );
void bl1_zcopyv( conj1_t conj, integer m, dcomplex* x, integer incx, dcomplex* y, integer incy );

void bl1_sdcopyv( conj1_t conj, integer m, float*    x, integer incx, double*   y, integer incy );
void bl1_dscopyv( conj1_t conj, integer m, double*   x, integer incx, float*    y, integer incy );
void bl1_sccopyv( conj1_t conj, integer m, float*    x, integer incx, scomplex* y, integer incy );
void bl1_cscopyv( conj1_t conj, integer m, scomplex* x, integer incx, float*    y, integer incy );
void bl1_szcopyv( conj1_t conj, integer m, float*    x, integer incx, dcomplex* y, integer incy );
void bl1_zscopyv( conj1_t conj, integer m, dcomplex* x, integer incx, float*    y, integer incy );
void bl1_dccopyv( conj1_t conj, integer m, double*   x, integer incx, scomplex* y, integer incy );
void bl1_cdcopyv( conj1_t conj, integer m, scomplex* x, integer incx, double*   y, integer incy );
void bl1_dzcopyv( conj1_t conj, integer m, double*   x, integer incx, dcomplex* y, integer incy );
void bl1_zdcopyv( conj1_t conj, integer m, dcomplex* x, integer incx, double*   y, integer incy );
void bl1_czcopyv( conj1_t conj, integer m, scomplex* x, integer incx, dcomplex* y, integer incy );
void bl1_zccopyv( conj1_t conj, integer m, dcomplex* x, integer incx, scomplex* y, integer incy );

// --- copymr ---

void bl1_scopymr( uplo1_t uplo, integer m, integer n, float*    a, integer a_rs, integer a_cs, float*    b, integer b_rs, integer b_cs );
void bl1_dcopymr( uplo1_t uplo, integer m, integer n, double*   a, integer a_rs, integer a_cs, double*   b, integer b_rs, integer b_cs );
void bl1_ccopymr( uplo1_t uplo, integer m, integer n, scomplex* a, integer a_rs, integer a_cs, scomplex* b, integer b_rs, integer b_cs );
void bl1_zcopymr( uplo1_t uplo, integer m, integer n, dcomplex* a, integer a_rs, integer a_cs, dcomplex* b, integer b_rs, integer b_cs );

void bl1_sscopymr( uplo1_t uplo, integer m, integer n, float*    a, integer a_rs, integer a_cs, float*    b, integer b_rs, integer b_cs );
void bl1_sdcopymr( uplo1_t uplo, integer m, integer n, float*    a, integer a_rs, integer a_cs, double*   b, integer b_rs, integer b_cs );
void bl1_dscopymr( uplo1_t uplo, integer m, integer n, double*   a, integer a_rs, integer a_cs, float*    b, integer b_rs, integer b_cs );
void bl1_sccopymr( uplo1_t uplo, integer m, integer n, float*    a, integer a_rs, integer a_cs, scomplex* b, integer b_rs, integer b_cs );
void bl1_cscopymr( uplo1_t uplo, integer m, integer n, scomplex* a, integer a_rs, integer a_cs, float*    b, integer b_rs, integer b_cs );
void bl1_szcopymr( uplo1_t uplo, integer m, integer n, float*    a, integer a_rs, integer a_cs, dcomplex* b, integer b_rs, integer b_cs );
void bl1_zscopymr( uplo1_t uplo, integer m, integer n, dcomplex* a, integer a_rs, integer a_cs, float*    b, integer b_rs, integer b_cs );
void bl1_ddcopymr( uplo1_t uplo, integer m, integer n, double*   a, integer a_rs, integer a_cs, double*   b, integer b_rs, integer b_cs );
void bl1_dccopymr( uplo1_t uplo, integer m, integer n, double*   a, integer a_rs, integer a_cs, scomplex* b, integer b_rs, integer b_cs );
void bl1_cdcopymr( uplo1_t uplo, integer m, integer n, scomplex* a, integer a_rs, integer a_cs, double*   b, integer b_rs, integer b_cs );
void bl1_dzcopymr( uplo1_t uplo, integer m, integer n, double*   a, integer a_rs, integer a_cs, dcomplex* b, integer b_rs, integer b_cs );
void bl1_zdcopymr( uplo1_t uplo, integer m, integer n, dcomplex* a, integer a_rs, integer a_cs, double*   b, integer b_rs, integer b_cs );
void bl1_cccopymr( uplo1_t uplo, integer m, integer n, scomplex* a, integer a_rs, integer a_cs, scomplex* b, integer b_rs, integer b_cs );
void bl1_czcopymr( uplo1_t uplo, integer m, integer n, scomplex* a, integer a_rs, integer a_cs, dcomplex* b, integer b_rs, integer b_cs );
void bl1_zccopymr( uplo1_t uplo, integer m, integer n, dcomplex* a, integer a_rs, integer a_cs, scomplex* b, integer b_rs, integer b_cs );
void bl1_zzcopymr( uplo1_t uplo, integer m, integer n, dcomplex* a, integer a_rs, integer a_cs, dcomplex* b, integer b_rs, integer b_cs );

// --- copymrt ---

void bl1_scopymrt( uplo1_t uplo, trans1_t trans, integer m, integer n, float*    a, integer a_rs, integer a_cs, float*    b, integer b_rs, integer b_cs );
void bl1_dcopymrt( uplo1_t uplo, trans1_t trans, integer m, integer n, double*   a, integer a_rs, integer a_cs, double*   b, integer b_rs, integer b_cs );
void bl1_ccopymrt( uplo1_t uplo, trans1_t trans, integer m, integer n, scomplex* a, integer a_rs, integer a_cs, scomplex* b, integer b_rs, integer b_cs );
void bl1_zcopymrt( uplo1_t uplo, trans1_t trans, integer m, integer n, dcomplex* a, integer a_rs, integer a_cs, dcomplex* b, integer b_rs, integer b_cs );

void bl1_sscopymrt( uplo1_t uplo, trans1_t trans, integer m, integer n, float*    a, integer a_rs, integer a_cs, float*    b, integer b_rs, integer b_cs );
void bl1_sdcopymrt( uplo1_t uplo, trans1_t trans, integer m, integer n, float*    a, integer a_rs, integer a_cs, double*   b, integer b_rs, integer b_cs );
void bl1_sccopymrt( uplo1_t uplo, trans1_t trans, integer m, integer n, float*    a, integer a_rs, integer a_cs, scomplex* b, integer b_rs, integer b_cs );
void bl1_szcopymrt( uplo1_t uplo, trans1_t trans, integer m, integer n, float*    a, integer a_rs, integer a_cs, dcomplex* b, integer b_rs, integer b_cs );
void bl1_dscopymrt( uplo1_t uplo, trans1_t trans, integer m, integer n, double*   a, integer a_rs, integer a_cs, float*    b, integer b_rs, integer b_cs );
void bl1_ddcopymrt( uplo1_t uplo, trans1_t trans, integer m, integer n, double*   a, integer a_rs, integer a_cs, double*   b, integer b_rs, integer b_cs );
void bl1_dccopymrt( uplo1_t uplo, trans1_t trans, integer m, integer n, double*   a, integer a_rs, integer a_cs, scomplex* b, integer b_rs, integer b_cs );
void bl1_dzcopymrt( uplo1_t uplo, trans1_t trans, integer m, integer n, double*   a, integer a_rs, integer a_cs, dcomplex* b, integer b_rs, integer b_cs );
void bl1_cscopymrt( uplo1_t uplo, trans1_t trans, integer m, integer n, scomplex* a, integer a_rs, integer a_cs, float*    b, integer b_rs, integer b_cs );
void bl1_cdcopymrt( uplo1_t uplo, trans1_t trans, integer m, integer n, scomplex* a, integer a_rs, integer a_cs, double*   b, integer b_rs, integer b_cs );
void bl1_cccopymrt( uplo1_t uplo, trans1_t trans, integer m, integer n, scomplex* a, integer a_rs, integer a_cs, scomplex* b, integer b_rs, integer b_cs );
void bl1_czcopymrt( uplo1_t uplo, trans1_t trans, integer m, integer n, scomplex* a, integer a_rs, integer a_cs, dcomplex* b, integer b_rs, integer b_cs );
void bl1_zscopymrt( uplo1_t uplo, trans1_t trans, integer m, integer n, dcomplex* a, integer a_rs, integer a_cs, float*    b, integer b_rs, integer b_cs );
void bl1_zdcopymrt( uplo1_t uplo, trans1_t trans, integer m, integer n, dcomplex* a, integer a_rs, integer a_cs, double*   b, integer b_rs, integer b_cs );
void bl1_zccopymrt( uplo1_t uplo, trans1_t trans, integer m, integer n, dcomplex* a, integer a_rs, integer a_cs, scomplex* b, integer b_rs, integer b_cs );
void bl1_zzcopymrt( uplo1_t uplo, trans1_t trans, integer m, integer n, dcomplex* a, integer a_rs, integer a_cs, dcomplex* b, integer b_rs, integer b_cs );

// --- copymt ---

void bl1_icopymt( trans1_t trans, integer m, integer n, integer*      a, integer a_rs, integer a_cs, integer*      b, integer b_rs, integer b_cs );
void bl1_scopymt( trans1_t trans, integer m, integer n, float*    a, integer a_rs, integer a_cs, float*    b, integer b_rs, integer b_cs );
void bl1_dcopymt( trans1_t trans, integer m, integer n, double*   a, integer a_rs, integer a_cs, double*   b, integer b_rs, integer b_cs );
void bl1_ccopymt( trans1_t trans, integer m, integer n, scomplex* a, integer a_rs, integer a_cs, scomplex* b, integer b_rs, integer b_cs );
void bl1_zcopymt( trans1_t trans, integer m, integer n, dcomplex* a, integer a_rs, integer a_cs, dcomplex* b, integer b_rs, integer b_cs );

void bl1_sscopymt( trans1_t trans, integer m, integer n, float*    a, integer a_rs, integer a_cs, float*    b, integer b_rs, integer b_cs );
void bl1_sdcopymt( trans1_t trans, integer m, integer n, float*    a, integer a_rs, integer a_cs, double*   b, integer b_rs, integer b_cs );
void bl1_dscopymt( trans1_t trans, integer m, integer n, double*   a, integer a_rs, integer a_cs, float*    b, integer b_rs, integer b_cs );
void bl1_sccopymt( trans1_t trans, integer m, integer n, float*    a, integer a_rs, integer a_cs, scomplex* b, integer b_rs, integer b_cs );
void bl1_cscopymt( trans1_t trans, integer m, integer n, scomplex* a, integer a_rs, integer a_cs, float*    b, integer b_rs, integer b_cs );
void bl1_szcopymt( trans1_t trans, integer m, integer n, float*    a, integer a_rs, integer a_cs, dcomplex* b, integer b_rs, integer b_cs );
void bl1_zscopymt( trans1_t trans, integer m, integer n, dcomplex* a, integer a_rs, integer a_cs, float*    b, integer b_rs, integer b_cs );
void bl1_ddcopymt( trans1_t trans, integer m, integer n, double*   a, integer a_rs, integer a_cs, double*   b, integer b_rs, integer b_cs );
void bl1_dccopymt( trans1_t trans, integer m, integer n, double*   a, integer a_rs, integer a_cs, scomplex* b, integer b_rs, integer b_cs );
void bl1_cdcopymt( trans1_t trans, integer m, integer n, scomplex* a, integer a_rs, integer a_cs, double*   b, integer b_rs, integer b_cs );
void bl1_dzcopymt( trans1_t trans, integer m, integer n, double*   a, integer a_rs, integer a_cs, dcomplex* b, integer b_rs, integer b_cs );
void bl1_zdcopymt( trans1_t trans, integer m, integer n, dcomplex* a, integer a_rs, integer a_cs, double*   b, integer b_rs, integer b_cs );
void bl1_cccopymt( trans1_t trans, integer m, integer n, scomplex* a, integer a_rs, integer a_cs, scomplex* b, integer b_rs, integer b_cs );
void bl1_czcopymt( trans1_t trans, integer m, integer n, scomplex* a, integer a_rs, integer a_cs, dcomplex* b, integer b_rs, integer b_cs );
void bl1_zccopymt( trans1_t trans, integer m, integer n, dcomplex* a, integer a_rs, integer a_cs, scomplex* b, integer b_rs, integer b_cs );
void bl1_zzcopymt( trans1_t trans, integer m, integer n, dcomplex* a, integer a_rs, integer a_cs, dcomplex* b, integer b_rs, integer b_cs );

// --- dot ---

void bl1_cdot_in( conj1_t conj, integer n, scomplex* x, integer incx, scomplex* y, integer incy, scomplex* rho );
void bl1_zdot_in( conj1_t conj, integer n, dcomplex* x, integer incx, dcomplex* y, integer incy, dcomplex* rho );

void bl1_sdot( conj1_t conj, integer n, float*    x, integer incx, float*    y, integer incy, float*    rho );
void bl1_ddot( conj1_t conj, integer n, double*   x, integer incx, double*   y, integer incy, double*   rho );
void bl1_cdot( conj1_t conj, integer n, scomplex* x, integer incx, scomplex* y, integer incy, scomplex* rho );
void bl1_zdot( conj1_t conj, integer n, dcomplex* x, integer incx, dcomplex* y, integer incy, dcomplex* rho );

// --- dots ---

void bl1_sdots( conj1_t conj, integer n, float*    alpha, float*    x, integer incx, float*    y, integer incy, float*    beta, float*    rho );
void bl1_ddots( conj1_t conj, integer n, double*   alpha, double*   x, integer incx, double*   y, integer incy, double*   beta, double*   rho );
void bl1_cdots( conj1_t conj, integer n, scomplex* alpha, scomplex* x, integer incx, scomplex* y, integer incy, scomplex* beta, scomplex* rho );
void bl1_zdots( conj1_t conj, integer n, dcomplex* alpha, dcomplex* x, integer incx, dcomplex* y, integer incy, dcomplex* beta, dcomplex* rho );

// --- dot2s ---

void bl1_sdot2s( conj1_t conj, integer n, float*    alpha, float*    x, integer incx, float*    y, integer incy, float*    beta, float*    rho );
void bl1_ddot2s( conj1_t conj, integer n, double*   alpha, double*   x, integer incx, double*   y, integer incy, double*   beta, double*   rho );
void bl1_cdot2s( conj1_t conj, integer n, scomplex* alpha, scomplex* x, integer incx, scomplex* y, integer incy, scomplex* beta, scomplex* rho );
void bl1_zdot2s( conj1_t conj, integer n, dcomplex* alpha, dcomplex* x, integer incx, dcomplex* y, integer incy, dcomplex* beta, dcomplex* rho );

// --- fnorm ---

void bl1_sfnorm( integer m, integer n, float*    a, integer a_rs, integer a_cs, float*  norm );
void bl1_dfnorm( integer m, integer n, double*   a, integer a_rs, integer a_cs, double* norm );
void bl1_cfnorm( integer m, integer n, scomplex* a, integer a_rs, integer a_cs, float*  norm );
void bl1_zfnorm( integer m, integer n, dcomplex* a, integer a_rs, integer a_cs, double* norm );

// --- invscalv ---

void bl1_sinvscalv(  conj1_t conj, integer n, float*    alpha, float*    x, integer incx );
void bl1_dinvscalv(  conj1_t conj, integer n, double*   alpha, double*   x, integer incx );
void bl1_csinvscalv( conj1_t conj, integer n, float*    alpha, scomplex* x, integer incx );
void bl1_cinvscalv(  conj1_t conj, integer n, scomplex* alpha, scomplex* x, integer incx );
void bl1_zdinvscalv( conj1_t conj, integer n, double*   alpha, dcomplex* x, integer incx );
void bl1_zinvscalv(  conj1_t conj, integer n, dcomplex* alpha, dcomplex* x, integer incx );

// --- invscalm ---

void bl1_sinvscalm(  conj1_t conj, integer m, integer n, float*    alpha, float*    a, integer a_rs, integer a_cs );
void bl1_dinvscalm(  conj1_t conj, integer m, integer n, double*   alpha, double*   a, integer a_rs, integer a_cs );
void bl1_csinvscalm( conj1_t conj, integer m, integer n, float*    alpha, scomplex* a, integer a_rs, integer a_cs );
void bl1_cinvscalm(  conj1_t conj, integer m, integer n, scomplex* alpha, scomplex* a, integer a_rs, integer a_cs );
void bl1_zdinvscalm( conj1_t conj, integer m, integer n, double*   alpha, dcomplex* a, integer a_rs, integer a_cs );
void bl1_zinvscalm(  conj1_t conj, integer m, integer n, dcomplex* alpha, dcomplex* a, integer a_rs, integer a_cs );

// --- nrm2 ---

void bl1_snrm2( integer n, float*    x, integer incx, float*  norm );
void bl1_dnrm2( integer n, double*   x, integer incx, double* norm );
void bl1_cnrm2( integer n, scomplex* x, integer incx, float*  norm );
void bl1_znrm2( integer n, dcomplex* x, integer incx, double* norm );

// --- scal ---

void bl1_sscal(  integer n, float*    alpha, float*    x, integer incx );
void bl1_dscal(  integer n, double*   alpha, double*   x, integer incx );
void bl1_csscal( integer n, float*    alpha, scomplex* x, integer incx );
void bl1_cscal(  integer n, scomplex* alpha, scomplex* x, integer incx );
void bl1_zdscal( integer n, double*   alpha, dcomplex* x, integer incx );
void bl1_zscal(  integer n, dcomplex* alpha, dcomplex* x, integer incx );

// --- scalv ---

void bl1_sscalv(  conj1_t conj, integer n, float*    alpha, float*    x, integer incx );
void bl1_dscalv(  conj1_t conj, integer n, double*   alpha, double*   x, integer incx );
void bl1_csscalv( conj1_t conj, integer n, float*    alpha, scomplex* x, integer incx );
void bl1_cscalv(  conj1_t conj, integer n, scomplex* alpha, scomplex* x, integer incx );
void bl1_zdscalv( conj1_t conj, integer n, double*   alpha, dcomplex* x, integer incx );
void bl1_zscalv(  conj1_t conj, integer n, dcomplex* alpha, dcomplex* x, integer incx );

// --- scalm ---

void bl1_sscalm(  conj1_t conj, integer m, integer n, float*    alpha, float*    a, integer a_rs, integer a_cs );
void bl1_dscalm(  conj1_t conj, integer m, integer n, double*   alpha, double*   a, integer a_rs, integer a_cs );
void bl1_csscalm( conj1_t conj, integer m, integer n, float*    alpha, scomplex* a, integer a_rs, integer a_cs );
void bl1_cscalm(  conj1_t conj, integer m, integer n, scomplex* alpha, scomplex* a, integer a_rs, integer a_cs );
void bl1_zdscalm( conj1_t conj, integer m, integer n, double*   alpha, dcomplex* a, integer a_rs, integer a_cs );
void bl1_zscalm(  conj1_t conj, integer m, integer n, dcomplex* alpha, dcomplex* a, integer a_rs, integer a_cs );

// --- scalmr ---

void bl1_sscalmr(  uplo1_t uplo, integer m, integer n, float*    alpha, float*    a, integer a_rs, integer a_cs );
void bl1_dscalmr(  uplo1_t uplo, integer m, integer n, double*   alpha, double*   a, integer a_rs, integer a_cs );
void bl1_csscalmr( uplo1_t uplo, integer m, integer n, float*    alpha, scomplex* a, integer a_rs, integer a_cs );
void bl1_cscalmr(  uplo1_t uplo, integer m, integer n, scomplex* alpha, scomplex* a, integer a_rs, integer a_cs );
void bl1_zdscalmr( uplo1_t uplo, integer m, integer n, double*   alpha, dcomplex* a, integer a_rs, integer a_cs );
void bl1_zscalmr(  uplo1_t uplo, integer m, integer n, dcomplex* alpha, dcomplex* a, integer a_rs, integer a_cs );

// --- swap ---

void bl1_sswap( integer n, float*    x, integer incx, float*    y, integer incy );
void bl1_dswap( integer n, double*   x, integer incx, double*   y, integer incy );
void bl1_cswap( integer n, scomplex* x, integer incx, scomplex* y, integer incy );
void bl1_zswap( integer n, dcomplex* x, integer incx, dcomplex* y, integer incy );

// --- swapv ---

void bl1_sswapv( integer n, float*    x, integer incx, float*    y, integer incy );
void bl1_dswapv( integer n, double*   x, integer incx, double*   y, integer incy );
void bl1_cswapv( integer n, scomplex* x, integer incx, scomplex* y, integer incy );
void bl1_zswapv( integer n, dcomplex* x, integer incx, dcomplex* y, integer incy );

// --- swapmt ---

void bl1_sswapmt( trans1_t trans, integer m, integer n, float*    a, integer a_rs, integer a_cs, float*    b, integer b_rs, integer b_cs );
void bl1_dswapmt( trans1_t trans, integer m, integer n, double*   a, integer a_rs, integer a_cs, double*   b, integer b_rs, integer b_cs );
void bl1_cswapmt( trans1_t trans, integer m, integer n, scomplex* a, integer a_rs, integer a_cs, scomplex* b, integer b_rs, integer b_cs );
void bl1_zswapmt( trans1_t trans, integer m, integer n, dcomplex* a, integer a_rs, integer a_cs, dcomplex* b, integer b_rs, integer b_cs );

// end blis_prototypes_level1.h
// begin blis_prototypes_level2.h


// --- Level-2 BLAS-like prototypes --------------------------------------------

// --- gemv ---

void bl1_sgemv( trans1_t transa, conj1_t conjx, integer m, integer n, float*    alpha, float*    a, integer a_rs, integer a_cs, float*    x, integer incx, float*    beta, float*    y, integer incy );
void bl1_dgemv( trans1_t transa, conj1_t conjx, integer m, integer n, double*   alpha, double*   a, integer a_rs, integer a_cs, double*   x, integer incx, double*   beta, double*   y, integer incy );
void bl1_cgemv( trans1_t transa, conj1_t conjx, integer m, integer n, scomplex* alpha, scomplex* a, integer a_rs, integer a_cs, scomplex* x, integer incx, scomplex* beta, scomplex* y, integer incy );
void bl1_zgemv( trans1_t transa, conj1_t conjx, integer m, integer n, dcomplex* alpha, dcomplex* a, integer a_rs, integer a_cs, dcomplex* x, integer incx, dcomplex* beta, dcomplex* y, integer incy );

void bl1_sgemv_blas( trans1_t transa, integer m, integer n, float*    alpha, float*    a, integer lda, float*    x, integer incx, float*    beta, float*    y, integer incy );
void bl1_dgemv_blas( trans1_t transa, integer m, integer n, double*   alpha, double*   a, integer lda, double*   x, integer incx, double*   beta, double*   y, integer incy );
void bl1_cgemv_blas( trans1_t transa, integer m, integer n, scomplex* alpha, scomplex* a, integer lda, scomplex* x, integer incx, scomplex* beta, scomplex* y, integer incy );
void bl1_zgemv_blas( trans1_t transa, integer m, integer n, dcomplex* alpha, dcomplex* a, integer lda, dcomplex* x, integer incx, dcomplex* beta, dcomplex* y, integer incy );

// --- ger ---

void bl1_sger( conj1_t conjx, conj1_t conjy, integer m, integer n, float*    alpha, float*    x, integer incx, float*    y, integer incy, float*    a, integer a_rs, integer a_cs );
void bl1_dger( conj1_t conjx, conj1_t conjy, integer m, integer n, double*   alpha, double*   x, integer incx, double*   y, integer incy, double*   a, integer a_rs, integer a_cs );
void bl1_cger( conj1_t conjx, conj1_t conjy, integer m, integer n, scomplex* alpha, scomplex* x, integer incx, scomplex* y, integer incy, scomplex* a, integer a_rs, integer a_cs );
void bl1_zger( conj1_t conjx, conj1_t conjy, integer m, integer n, dcomplex* alpha, dcomplex* x, integer incx, dcomplex* y, integer incy, dcomplex* a, integer a_rs, integer a_cs );

void bl1_sger_blas(  integer m, integer n, float*    alpha, float*    x, integer incx, float*    y, integer incy, float*    a, integer lda );
void bl1_dger_blas(  integer m, integer n, double*   alpha, double*   x, integer incx, double*   y, integer incy, double*   a, integer lda );
void bl1_cgerc_blas( integer m, integer n, scomplex* alpha, scomplex* x, integer incx, scomplex* y, integer incy, scomplex* a, integer lda );
void bl1_cgeru_blas( integer m, integer n, scomplex* alpha, scomplex* x, integer incx, scomplex* y, integer incy, scomplex* a, integer lda );
void bl1_zgerc_blas( integer m, integer n, dcomplex* alpha, dcomplex* x, integer incx, dcomplex* y, integer incy, dcomplex* a, integer lda );
void bl1_zgeru_blas( integer m, integer n, dcomplex* alpha, dcomplex* x, integer incx, dcomplex* y, integer incy, dcomplex* a, integer lda );

// --- hemv ---

void bl1_shemv( uplo1_t uplo, conj1_t conj, integer m, float*    alpha, float*    a, integer a_rs, integer a_cs, float*    x, integer incx, float*    beta, float*    y, integer incy );
void bl1_dhemv( uplo1_t uplo, conj1_t conj, integer m, double*   alpha, double*   a, integer a_rs, integer a_cs, double*   x, integer incx, double*   beta, double*   y, integer incy );
void bl1_chemv( uplo1_t uplo, conj1_t conj, integer m, scomplex* alpha, scomplex* a, integer a_rs, integer a_cs, scomplex* x, integer incx, scomplex* beta, scomplex* y, integer incy );
void bl1_zhemv( uplo1_t uplo, conj1_t conj, integer m, dcomplex* alpha, dcomplex* a, integer a_rs, integer a_cs, dcomplex* x, integer incx, dcomplex* beta, dcomplex* y, integer incy );

void bl1_chemv_blas( uplo1_t uplo, integer m, scomplex* alpha, scomplex* a, integer lda, scomplex* x, integer incx, scomplex* beta, scomplex* y, integer incy );
void bl1_zhemv_blas( uplo1_t uplo, integer m, dcomplex* alpha, dcomplex* a, integer lda, dcomplex* x, integer incx, dcomplex* beta, dcomplex* y, integer incy );

// --- her ---

void bl1_sher( uplo1_t uplo, conj1_t conj, integer m, float*  alpha, float*    x, integer incx, float*    a, integer a_rs, integer a_cs );
void bl1_dher( uplo1_t uplo, conj1_t conj, integer m, double* alpha, double*   x, integer incx, double*   a, integer a_rs, integer a_cs );
void bl1_cher( uplo1_t uplo, conj1_t conj, integer m, float*  alpha, scomplex* x, integer incx, scomplex* a, integer a_rs, integer a_cs );
void bl1_zher( uplo1_t uplo, conj1_t conj, integer m, double* alpha, dcomplex* x, integer incx, dcomplex* a, integer a_rs, integer a_cs );

void bl1_cher_blas( uplo1_t uplo, integer m, float*  alpha, scomplex* x, integer incx, scomplex* a, integer lda );
void bl1_zher_blas( uplo1_t uplo, integer m, double* alpha, dcomplex* x, integer incx, dcomplex* a, integer lda );

// --- her2 ---

void bl1_sher2( uplo1_t uplo, conj1_t conj, integer m, float*    alpha, float*    x, integer incx, float*    y, integer incy, float*    a, integer a_rs, integer a_cs );
void bl1_dher2( uplo1_t uplo, conj1_t conj, integer m, double*   alpha, double*   x, integer incx, double*   y, integer incy, double*   a, integer a_rs, integer a_cs );
void bl1_cher2( uplo1_t uplo, conj1_t conj, integer m, scomplex* alpha, scomplex* x, integer incx, scomplex* y, integer incy, scomplex* a, integer a_rs, integer a_cs );
void bl1_zher2( uplo1_t uplo, conj1_t conj, integer m, dcomplex* alpha, dcomplex* x, integer incx, dcomplex* y, integer incy, dcomplex* a, integer a_rs, integer a_cs );

void bl1_cher2_blas( uplo1_t uplo, integer m, scomplex* alpha, scomplex* x, integer incx, scomplex* y, integer incy, scomplex* a, integer lda );
void bl1_zher2_blas( uplo1_t uplo, integer m, dcomplex* alpha, dcomplex* x, integer incx, dcomplex* y, integer incy, dcomplex* a, integer lda );

// --- symv ---

void bl1_ssymv( uplo1_t uplo, integer m, float*    alpha, float*    a, integer a_rs, integer a_cs, float*    x, integer incx, float*    beta, float*    y, integer incy );
void bl1_dsymv( uplo1_t uplo, integer m, double*   alpha, double*   a, integer a_rs, integer a_cs, double*   x, integer incx, double*   beta, double*   y, integer incy );
void bl1_csymv( uplo1_t uplo, integer m, scomplex* alpha, scomplex* a, integer a_rs, integer a_cs, scomplex* x, integer incx, scomplex* beta, scomplex* y, integer incy );
void bl1_zsymv( uplo1_t uplo, integer m, dcomplex* alpha, dcomplex* a, integer a_rs, integer a_cs, dcomplex* x, integer incx, dcomplex* beta, dcomplex* y, integer incy );

void bl1_ssymv_blas( uplo1_t uplo, integer m, float*    alpha, float*    a, integer lda, float*    x, integer incx, float*    beta, float*    y, integer incy );
void bl1_dsymv_blas( uplo1_t uplo, integer m, double*   alpha, double*   a, integer lda, double*   x, integer incx, double*   beta, double*   y, integer incy );
void bl1_csymv_blas( uplo1_t uplo, integer m, scomplex* alpha, scomplex* a, integer lda, scomplex* x, integer incx, scomplex* beta, scomplex* y, integer incy );
void bl1_zsymv_blas( uplo1_t uplo, integer m, dcomplex* alpha, dcomplex* a, integer lda, dcomplex* x, integer incx, dcomplex* beta, dcomplex* y, integer incy );

// --- syr ---

void bl1_ssyr( uplo1_t uplo, integer m, float*    alpha, float*    x, integer incx, float*    a, integer a_rs, integer a_cs );
void bl1_dsyr( uplo1_t uplo, integer m, double*   alpha, double*   x, integer incx, double*   a, integer a_rs, integer a_cs );
void bl1_csyr( uplo1_t uplo, integer m, scomplex* alpha, scomplex* x, integer incx, scomplex* a, integer a_rs, integer a_cs );
void bl1_zsyr( uplo1_t uplo, integer m, dcomplex* alpha, dcomplex* x, integer incx, dcomplex* a, integer a_rs, integer a_cs );

void bl1_ssyr_blas( uplo1_t uplo, integer m, float*    alpha, float*    x, integer incx, float*    a, integer lda );
void bl1_dsyr_blas( uplo1_t uplo, integer m, double*   alpha, double*   x, integer incx, double*   a, integer lda );
void bl1_csyr_blas( uplo1_t uplo, integer m, scomplex* alpha, scomplex* x, integer incx, scomplex* a, integer lda );
void bl1_zsyr_blas( uplo1_t uplo, integer m, dcomplex* alpha, dcomplex* x, integer incx, dcomplex* a, integer lda );

// --- syr2 ---

void bl1_ssyr2( uplo1_t uplo, integer m, float*    alpha, float*    x, integer incx, float*    y, integer incy, float*    a, integer a_rs, integer a_cs );
void bl1_dsyr2( uplo1_t uplo, integer m, double*   alpha, double*   x, integer incx, double*   y, integer incy, double*   a, integer a_rs, integer a_cs );
void bl1_csyr2( uplo1_t uplo, integer m, scomplex* alpha, scomplex* x, integer incx, scomplex* y, integer incy, scomplex* a, integer a_rs, integer a_cs );
void bl1_zsyr2( uplo1_t uplo, integer m, dcomplex* alpha, dcomplex* x, integer incx, dcomplex* y, integer incy, dcomplex* a, integer a_rs, integer a_cs );

void bl1_ssyr2_blas( uplo1_t uplo, integer m, float*    alpha, float*    x, integer incx, float*    y, integer incy, float*    a, integer lda );
void bl1_dsyr2_blas( uplo1_t uplo, integer m, double*   alpha, double*   x, integer incx, double*   y, integer incy, double*   a, integer lda );
void bl1_csyr2_blas( uplo1_t uplo, integer m, scomplex* alpha, scomplex* x, integer incx, scomplex* y, integer incy, scomplex* a, integer lda );
void bl1_zsyr2_blas( uplo1_t uplo, integer m, dcomplex* alpha, dcomplex* x, integer incx, dcomplex* y, integer incy, dcomplex* a, integer lda );

// --- trmv ---

void bl1_strmv( uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, float*    a, integer a_rs, integer a_cs, float*    x, integer incx );
void bl1_dtrmv( uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, double*   a, integer a_rs, integer a_cs, double*   x, integer incx );
void bl1_ctrmv( uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, scomplex* a, integer a_rs, integer a_cs, scomplex* x, integer incx );
void bl1_ztrmv( uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, dcomplex* a, integer a_rs, integer a_cs, dcomplex* x, integer incx );

void bl1_strmv_blas( uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, float*    a, integer lda, float*    x, integer incx );
void bl1_dtrmv_blas( uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, double*   a, integer lda, double*   x, integer incx );
void bl1_ctrmv_blas( uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, scomplex* a, integer lda, scomplex* x, integer incx );
void bl1_ztrmv_blas( uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, dcomplex* a, integer lda, dcomplex* x, integer incx );

// --- trsv ---

void bl1_strsv( uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, float*    a, integer a_rs, integer a_cs, float*    x, integer incx );
void bl1_dtrsv( uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, double*   a, integer a_rs, integer a_cs, double*   x, integer incx );
void bl1_ctrsv( uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, scomplex* a, integer a_rs, integer a_cs, scomplex* x, integer incx );
void bl1_ztrsv( uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, dcomplex* a, integer a_rs, integer a_cs, dcomplex* x, integer incx );

void bl1_strsv_blas( uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, float*    a, integer lda, float*    x, integer incx );
void bl1_dtrsv_blas( uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, double*   a, integer lda, double*   x, integer incx );
void bl1_ctrsv_blas( uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, scomplex* a, integer lda, scomplex* x, integer incx );
void bl1_ztrsv_blas( uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, dcomplex* a, integer lda, dcomplex* x, integer incx );

// --- trmvsx ---

void bl1_strmvsx( uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, float* alpha, float* a, integer a_rs, integer a_cs, float* x, integer incx, float* beta, float* y, integer incy );
void bl1_dtrmvsx( uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, double* alpha, double* a, integer a_rs, integer a_cs, double* x, integer incx, double* beta, double* y, integer incy );
void bl1_ctrmvsx( uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, scomplex* alpha, scomplex* a, integer a_rs, integer a_cs, scomplex* x, integer incx, scomplex* beta, scomplex* y, integer incy );
void bl1_ztrmvsx( uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, dcomplex* alpha, dcomplex* a, integer a_rs, integer a_cs, dcomplex* x, integer incx, dcomplex* beta, dcomplex* y, integer incy );

// --- trsvsx ---

void bl1_strsvsx( uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, float* alpha, float* a, integer a_rs, integer a_cs, float* x, integer incx, float* beta, float* y, integer incy );
void bl1_dtrsvsx( uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, double* alpha, double* a, integer a_rs, integer a_cs, double* x, integer incx, double* beta, double* y, integer incy );
void bl1_ctrsvsx( uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, scomplex* alpha, scomplex* a, integer a_rs, integer a_cs, scomplex* x, integer incx, scomplex* beta, scomplex* y, integer incy );
void bl1_ztrsvsx( uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, dcomplex* alpha, dcomplex* a, integer a_rs, integer a_cs, dcomplex* x, integer incx, dcomplex* beta, dcomplex* y, integer incy );

// end blis_prototypes_level2.h
// begin blis_prototypes_level3.h


// --- Level-3 BLAS-like prototypes --------------------------------------------

// --- gemm ---

void bl1_sgemm( trans1_t transa, trans1_t transb, integer m, integer k, integer n, float*    alpha, float*    a, integer a_rs, integer a_cs, float*    b, integer b_rs, integer b_cs, float*    beta, float*    c, integer c_rs, integer c_cs );
void bl1_dgemm( trans1_t transa, trans1_t transb, integer m, integer k, integer n, double*   alpha, double*   a, integer a_rs, integer a_cs, double*   b, integer b_rs, integer b_cs, double*   beta, double*   c, integer c_rs, integer c_cs );
void bl1_cgemm( trans1_t transa, trans1_t transb, integer m, integer k, integer n, scomplex* alpha, scomplex* a, integer a_rs, integer a_cs, scomplex* b, integer b_rs, integer b_cs, scomplex* beta, scomplex* c, integer c_rs, integer c_cs );
void bl1_zgemm( trans1_t transa, trans1_t transb, integer m, integer k, integer n, dcomplex* alpha, dcomplex* a, integer a_rs, integer a_cs, dcomplex* b, integer b_rs, integer b_cs, dcomplex* beta, dcomplex* c, integer c_rs, integer c_cs );

void bl1_sgemm_blas( trans1_t transa, trans1_t transb, integer m, integer n, integer k, float*    alpha, float*    a, integer lda, float*    b, integer ldb, float*    beta, float*    c, integer ldc );
void bl1_dgemm_blas( trans1_t transa, trans1_t transb, integer m, integer n, integer k, double*   alpha, double*   a, integer lda, double*   b, integer ldb, double*   beta, double*   c, integer ldc );
void bl1_cgemm_blas( trans1_t transa, trans1_t transb, integer m, integer n, integer k, scomplex* alpha, scomplex* a, integer lda, scomplex* b, integer ldb, scomplex* beta, scomplex* c, integer ldc );
void bl1_zgemm_blas( trans1_t transa, trans1_t transb, integer m, integer n, integer k, dcomplex* alpha, dcomplex* a, integer lda, dcomplex* b, integer ldb, dcomplex* beta, dcomplex* c, integer ldc );

// --- hemm ---

void bl1_shemm( side1_t side, uplo1_t uplo, integer m, integer n, float*    alpha, float*    a, integer a_rs, integer a_cs, float*    b, integer b_rs, integer b_cs, float*    beta, float*    c, integer c_rs, integer c_cs );
void bl1_dhemm( side1_t side, uplo1_t uplo, integer m, integer n, double*   alpha, double*   a, integer a_rs, integer a_cs, double*   b, integer b_rs, integer b_cs, double*   beta, double*   c, integer c_rs, integer c_cs );
void bl1_chemm( side1_t side, uplo1_t uplo, integer m, integer n, scomplex* alpha, scomplex* a, integer a_rs, integer a_cs, scomplex* b, integer b_rs, integer b_cs, scomplex* beta, scomplex* c, integer c_rs, integer c_cs );
void bl1_zhemm( side1_t side, uplo1_t uplo, integer m, integer n, dcomplex* alpha, dcomplex* a, integer a_rs, integer a_cs, dcomplex* b, integer b_rs, integer b_cs, dcomplex* beta, dcomplex* c, integer c_rs, integer c_cs );

void bl1_chemm_blas( side1_t side, uplo1_t uplo, integer m, integer n, scomplex* alpha, scomplex* a, integer lda, scomplex* b, integer ldb, scomplex* beta, scomplex* c, integer ldc );
void bl1_zhemm_blas( side1_t side, uplo1_t uplo, integer m, integer n, dcomplex* alpha, dcomplex* a, integer lda, dcomplex* b, integer ldb, dcomplex* beta, dcomplex* c, integer ldc );

// --- herk ---

void bl1_sherk( uplo1_t uplo, trans1_t trans, integer m, integer k, float*  alpha, float*    a, integer a_rs, integer a_cs, float*  beta, float*    c, integer c_rs, integer c_cs );
void bl1_dherk( uplo1_t uplo, trans1_t trans, integer m, integer k, double* alpha, double*   a, integer a_rs, integer a_cs, double* beta, double*   c, integer c_rs, integer c_cs );
void bl1_cherk( uplo1_t uplo, trans1_t trans, integer m, integer k, float*  alpha, scomplex* a, integer a_rs, integer a_cs, float*  beta, scomplex* c, integer c_rs, integer c_cs );
void bl1_zherk( uplo1_t uplo, trans1_t trans, integer m, integer k, double* alpha, dcomplex* a, integer a_rs, integer a_cs, double* beta, dcomplex* c, integer c_rs, integer c_cs );

void bl1_cherk_blas( uplo1_t uplo, trans1_t trans, integer m, integer k, float*  alpha, scomplex* a, integer lda, float*  beta, scomplex* c, integer ldc );
void bl1_zherk_blas( uplo1_t uplo, trans1_t trans, integer m, integer k, double* alpha, dcomplex* a, integer lda, double* beta, dcomplex* c, integer ldc );

// --- her2k ---

void bl1_sher2k( uplo1_t uplo, trans1_t trans, integer m, integer k, float*    alpha, float*    a, integer a_rs, integer a_cs, float*    b, integer b_rs, integer b_cs, float*  beta, float*    c, integer c_rs, integer c_cs );
void bl1_dher2k( uplo1_t uplo, trans1_t trans, integer m, integer k, double*   alpha, double*   a, integer a_rs, integer a_cs, double*   b, integer b_rs, integer b_cs, double* beta, double*   c, integer c_rs, integer c_cs );
void bl1_cher2k( uplo1_t uplo, trans1_t trans, integer m, integer k, scomplex* alpha, scomplex* a, integer a_rs, integer a_cs, scomplex* b, integer b_rs, integer b_cs, float*  beta, scomplex* c, integer c_rs, integer c_cs );
void bl1_zher2k( uplo1_t uplo, trans1_t trans, integer m, integer k, dcomplex* alpha, dcomplex* a, integer a_rs, integer a_cs, dcomplex* b, integer b_rs, integer b_cs, double* beta, dcomplex* c, integer c_rs, integer c_cs );

void bl1_cher2k_blas( uplo1_t uplo, trans1_t trans, integer m, integer k, scomplex* alpha, scomplex* a, integer lda, scomplex* b, integer ldb, float*  beta, scomplex* c, integer ldc );
void bl1_zher2k_blas( uplo1_t uplo, trans1_t trans, integer m, integer k, dcomplex* alpha, dcomplex* a, integer lda, dcomplex* b, integer ldb, double* beta, dcomplex* c, integer ldc );

// --- symm ---

void bl1_ssymm( side1_t side, uplo1_t uplo, integer m, integer n, float*    alpha, float*    a, integer a_rs, integer a_cs, float*    b, integer b_rs, integer b_cs, float*    beta, float*    c, integer c_rs, integer c_cs );
void bl1_dsymm( side1_t side, uplo1_t uplo, integer m, integer n, double*   alpha, double*   a, integer a_rs, integer a_cs, double*   b, integer b_rs, integer b_cs, double*   beta, double*   c, integer c_rs, integer c_cs );
void bl1_csymm( side1_t side, uplo1_t uplo, integer m, integer n, scomplex* alpha, scomplex* a, integer a_rs, integer a_cs, scomplex* b, integer b_rs, integer b_cs, scomplex* beta, scomplex* c, integer c_rs, integer c_cs );
void bl1_zsymm( side1_t side, uplo1_t uplo, integer m, integer n, dcomplex* alpha, dcomplex* a, integer a_rs, integer a_cs, dcomplex* b, integer b_rs, integer b_cs, dcomplex* beta, dcomplex* c, integer c_rs, integer c_cs );

void bl1_ssymm_blas( side1_t side, uplo1_t uplo, integer m, integer n, float*    alpha, float*    a, integer lda, float*    b, integer ldb, float*    beta, float*    c, integer ldc );
void bl1_dsymm_blas( side1_t side, uplo1_t uplo, integer m, integer n, double*   alpha, double*   a, integer lda, double*   b, integer ldb, double*   beta, double*   c, integer ldc );
void bl1_csymm_blas( side1_t side, uplo1_t uplo, integer m, integer n, scomplex* alpha, scomplex* a, integer lda, scomplex* b, integer ldb, scomplex* beta, scomplex* c, integer ldc );
void bl1_zsymm_blas( side1_t side, uplo1_t uplo, integer m, integer n, dcomplex* alpha, dcomplex* a, integer lda, dcomplex* b, integer ldb, dcomplex* beta, dcomplex* c, integer ldc );

// --- syrk ---

void bl1_ssyrk( uplo1_t uplo, trans1_t trans, integer m, integer k, float*    alpha, float*    a, integer a_rs, integer a_cs, float*    beta, float*    c, integer c_rs, integer c_cs );
void bl1_dsyrk( uplo1_t uplo, trans1_t trans, integer m, integer k, double*   alpha, double*   a, integer a_rs, integer a_cs, double*   beta, double*   c, integer c_rs, integer c_cs );
void bl1_csyrk( uplo1_t uplo, trans1_t trans, integer m, integer k, scomplex* alpha, scomplex* a, integer a_rs, integer a_cs, scomplex* beta, scomplex* c, integer c_rs, integer c_cs );
void bl1_zsyrk( uplo1_t uplo, trans1_t trans, integer m, integer k, dcomplex* alpha, dcomplex* a, integer a_rs, integer a_cs, dcomplex* beta, dcomplex* c, integer c_rs, integer c_cs );

void bl1_ssyrk_blas( uplo1_t uplo, trans1_t trans, integer m, integer k, float*    alpha, float*    a, integer lda, float*    beta, float*    c, integer ldc );
void bl1_dsyrk_blas( uplo1_t uplo, trans1_t trans, integer m, integer k, double*   alpha, double*   a, integer lda, double*   beta, double*   c, integer ldc );
void bl1_csyrk_blas( uplo1_t uplo, trans1_t trans, integer m, integer k, scomplex* alpha, scomplex* a, integer lda, scomplex* beta, scomplex* c, integer ldc );
void bl1_zsyrk_blas( uplo1_t uplo, trans1_t trans, integer m, integer k, dcomplex* alpha, dcomplex* a, integer lda, dcomplex* beta, dcomplex* c, integer ldc );

// --- syr2k ---

void bl1_ssyr2k( uplo1_t uplo, trans1_t trans, integer m, integer k, float*    alpha, float*    a, integer a_rs, integer a_cs, float*    b, integer b_rs, integer b_cs, float*    beta, float*    c, integer c_rs, integer c_cs );
void bl1_dsyr2k( uplo1_t uplo, trans1_t trans, integer m, integer k, double*   alpha, double*   a, integer a_rs, integer a_cs, double*   b, integer b_rs, integer b_cs, double*   beta, double*   c, integer c_rs, integer c_cs );
void bl1_csyr2k( uplo1_t uplo, trans1_t trans, integer m, integer k, scomplex* alpha, scomplex* a, integer a_rs, integer a_cs, scomplex* b, integer b_rs, integer b_cs, scomplex* beta, scomplex* c, integer c_rs, integer c_cs );
void bl1_zsyr2k( uplo1_t uplo, trans1_t trans, integer m, integer k, dcomplex* alpha, dcomplex* a, integer a_rs, integer a_cs, dcomplex* b, integer b_rs, integer b_cs, dcomplex* beta, dcomplex* c, integer c_rs, integer c_cs );

void bl1_ssyr2k_blas( uplo1_t uplo, trans1_t trans, integer m, integer k, float*    alpha, float*    a, integer lda, float*    b, integer ldb, float*    beta, float*    c, integer ldc );
void bl1_dsyr2k_blas( uplo1_t uplo, trans1_t trans, integer m, integer k, double*   alpha, double*   a, integer lda, double*   b, integer ldb, double*   beta, double*   c, integer ldc );
void bl1_csyr2k_blas( uplo1_t uplo, trans1_t trans, integer m, integer k, scomplex* alpha, scomplex* a, integer lda, scomplex* b, integer ldb, scomplex* beta, scomplex* c, integer ldc );
void bl1_zsyr2k_blas( uplo1_t uplo, trans1_t trans, integer m, integer k, dcomplex* alpha, dcomplex* a, integer lda, dcomplex* b, integer ldb, dcomplex* beta, dcomplex* c, integer ldc );

// --- trmm ---

void bl1_strmm( side1_t side, uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, integer n, float*    alpha, float*    a, integer a_rs, integer a_cs, float*    b, integer b_rs, integer b_cs );
void bl1_dtrmm( side1_t side, uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, integer n, double*   alpha, double*   a, integer a_rs, integer a_cs, double*   b, integer b_rs, integer b_cs );
void bl1_ctrmm( side1_t side, uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, integer n, scomplex* alpha, scomplex* a, integer a_rs, integer a_cs, scomplex* b, integer b_rs, integer b_cs );
void bl1_ztrmm( side1_t side, uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, integer n, dcomplex* alpha, dcomplex* a, integer a_rs, integer a_cs, dcomplex* b, integer b_rs, integer b_cs );

void bl1_strmm_blas( side1_t side, uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, integer n, float*    alpha, float*    a, integer lda, float*    b, integer ldb );
void bl1_dtrmm_blas( side1_t side, uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, integer n, double*   alpha, double*   a, integer lda, double*   b, integer ldb );
void bl1_ctrmm_blas( side1_t side, uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, integer n, scomplex* alpha, scomplex* a, integer lda, scomplex* b, integer ldb );
void bl1_ztrmm_blas( side1_t side, uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, integer n, dcomplex* alpha, dcomplex* a, integer lda, dcomplex* b, integer ldb );

// --- trsm ---

void bl1_strsm( side1_t side, uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, integer n, float*    alpha, float*    a, integer a_rs, integer a_cs, float*    b, integer b_rs, integer b_cs );
void bl1_dtrsm( side1_t side, uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, integer n, double*   alpha, double*   a, integer a_rs, integer a_cs, double*   b, integer b_rs, integer b_cs );
void bl1_ctrsm( side1_t side, uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, integer n, scomplex* alpha, scomplex* a, integer a_rs, integer a_cs, scomplex* b, integer b_rs, integer b_cs );
void bl1_ztrsm( side1_t side, uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, integer n, dcomplex* alpha, dcomplex* a, integer a_rs, integer a_cs, dcomplex* b, integer b_rs, integer b_cs );

void bl1_strsm_blas( side1_t side, uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, integer n, float*    alpha, float*    a, integer lda, float*    b, integer ldb );
void bl1_dtrsm_blas( side1_t side, uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, integer n, double*   alpha, double*   a, integer lda, double*   b, integer ldb );
void bl1_ctrsm_blas( side1_t side, uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, integer n, scomplex* alpha, scomplex* a, integer lda, scomplex* b, integer ldb );
void bl1_ztrsm_blas( side1_t side, uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, integer n, dcomplex* alpha, dcomplex* a, integer lda, dcomplex* b, integer ldb );

// --- trmmsx ---

void bl1_strmmsx( side1_t side, uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, integer n, float*    alpha, float*    a, integer a_rs, integer a_cs, float*    b, integer b_rs, integer b_cs, float*    beta, float*    c, integer c_rs, integer c_cs );
void bl1_dtrmmsx( side1_t side, uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, integer n, double*   alpha, double*   a, integer a_rs, integer a_cs, double*   b, integer b_rs, integer b_cs, double*   beta, double*   c, integer c_rs, integer c_cs );
void bl1_ctrmmsx( side1_t side, uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, integer n, scomplex* alpha, scomplex* a, integer a_rs, integer a_cs, scomplex* b, integer b_rs, integer b_cs, scomplex* beta, scomplex* c, integer c_rs, integer c_cs );
void bl1_ztrmmsx( side1_t side, uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, integer n, dcomplex* alpha, dcomplex* a, integer a_rs, integer a_cs, dcomplex* b, integer b_rs, integer b_cs, dcomplex* beta, dcomplex* c, integer c_rs, integer c_cs );

// --- trsmsx ---

void bl1_strsmsx( side1_t side, uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, integer n, float*    alpha, float*    a, integer a_rs, integer a_cs, float*    b, integer b_rs, integer b_cs, float*    beta, float*    c, integer c_rs, integer c_cs );
void bl1_dtrsmsx( side1_t side, uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, integer n, double*   alpha, double*   a, integer a_rs, integer a_cs, double*   b, integer b_rs, integer b_cs, double*   beta, double*   c, integer c_rs, integer c_cs );
void bl1_ctrsmsx( side1_t side, uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, integer n, scomplex* alpha, scomplex* a, integer a_rs, integer a_cs, scomplex* b, integer b_rs, integer b_cs, scomplex* beta, scomplex* c, integer c_rs, integer c_cs );
void bl1_ztrsmsx( side1_t side, uplo1_t uplo, trans1_t trans, diag1_t diag, integer m, integer n, dcomplex* alpha, dcomplex* a, integer a_rs, integer a_cs, dcomplex* b, integer b_rs, integer b_cs, dcomplex* beta, dcomplex* c, integer c_rs, integer c_cs );

// end blis_prototypes_level3.h

// begin blis_prototypes_fused1.h


// --- Fused Level-1 BLAS-like prototypes --------------------------------------

// --- axmyv2 ---

void bl1_saxmyv2( conj1_t conjx, integer n, float*    alpha, float*    beta, float*    x, integer inc_x, float*    y, integer inc_y, float*    z, integer inc_z );
void bl1_daxmyv2( conj1_t conjx, integer n, double*   alpha, double*   beta, double*   x, integer inc_x, double*   y, integer inc_y, double*   z, integer inc_z );
void bl1_caxmyv2( conj1_t conjx, integer n, scomplex* alpha, scomplex* beta, scomplex* x, integer inc_x, scomplex* y, integer inc_y, scomplex* z, integer inc_z );
void bl1_zaxmyv2( conj1_t conjx, integer n, dcomplex* alpha, dcomplex* beta, dcomplex* x, integer inc_x, dcomplex* y, integer inc_y, dcomplex* z, integer inc_z );

// --- axpyv2b ---

void bl1_saxpyv2b( integer n, float*    beta1, float*    beta2, float*    a1, integer inc_a1, float*    a2, integer inc_a2, float*    w, integer inc_w );
void bl1_daxpyv2b( integer n, double*   beta1, double*   beta2, double*   a1, integer inc_a1, double*   a2, integer inc_a2, double*   w, integer inc_w );
void bl1_caxpyv2b( integer n, scomplex* beta1, scomplex* beta2, scomplex* a1, integer inc_a1, scomplex* a2, integer inc_a2, scomplex* w, integer inc_w );
void bl1_zaxpyv2b( integer n, dcomplex* beta1, dcomplex* beta2, dcomplex* a1, integer inc_a1, dcomplex* a2, integer inc_a2, dcomplex* w, integer inc_w );

// --- axpyv3b ---

void bl1_saxpyv3b( integer n, float*    beta1, float*    beta2, float*    beta3, float*    a1, integer inc_a1, float*    a2, integer inc_a2, float*    a3, integer inc_a3, float*    w, integer inc_w );
void bl1_daxpyv3b( integer n, double*   beta1, double*   beta2, double*   beta3, double*   a1, integer inc_a1, double*   a2, integer inc_a2, double*   a3, integer inc_a3, double*   w, integer inc_w );
void bl1_caxpyv3b( integer n, scomplex* beta1, scomplex* beta2, scomplex* beta3, scomplex* a1, integer inc_a1, scomplex* a2, integer inc_a2, scomplex* a3, integer inc_a3, scomplex* w, integer inc_w );
void bl1_zaxpyv3b( integer n, dcomplex* beta1, dcomplex* beta2, dcomplex* beta3, dcomplex* a1, integer inc_a1, dcomplex* a2, integer inc_a2, dcomplex* a3, integer inc_a3, dcomplex* w, integer inc_w );

// --- axpyv2bdotaxpy ---

void bl1_saxpyv2bdotaxpy( integer n, float*    beta, float*    u, integer inc_u, float*    gamma, float*    z, integer inc_z, float*    a, integer inc_a, float*    x, integer inc_x, float*    kappa, float*    rho, float*    w, integer inc_w );
void bl1_daxpyv2bdotaxpy( integer n, double*   beta, double*   u, integer inc_u, double*   gamma, double*   z, integer inc_z, double*   a, integer inc_a, double*   x, integer inc_x, double*   kappa, double*   rho, double*   w, integer inc_w );
void bl1_caxpyv2bdotaxpy( integer n, scomplex* beta, scomplex* u, integer inc_u, scomplex* gamma, scomplex* z, integer inc_z, scomplex* a, integer inc_a, scomplex* x, integer inc_x, scomplex* kappa, scomplex* rho, scomplex* w, integer inc_w );
void bl1_zaxpyv2bdotaxpy( integer n, dcomplex* beta, dcomplex* u, integer inc_u, dcomplex* gamma, dcomplex* z, integer inc_z, dcomplex* a, integer inc_a, dcomplex* x, integer inc_x, dcomplex* kappa, dcomplex* rho, dcomplex* w, integer inc_w );

// --- dotsv2 ---

void bl1_sdotsv2( conj1_t conjxy, integer n, float*    x, integer inc_x, float*    y, integer inc_y, float*    z, integer inc_z, float*    beta, float*    rho_xz, float*    rho_yz );
void bl1_ddotsv2( conj1_t conjxy, integer n, double*   x, integer inc_x, double*   y, integer inc_y, double*   z, integer inc_z, double*   beta, double*   rho_xz, double*   rho_yz );
void bl1_cdotsv2( conj1_t conjxy, integer n, scomplex* x, integer inc_x, scomplex* y, integer inc_y, scomplex* z, integer inc_z, scomplex* beta, scomplex* rho_xz, scomplex* rho_yz );
void bl1_zdotsv2( conj1_t conjxy, integer n, dcomplex* x, integer inc_x, dcomplex* y, integer inc_y, dcomplex* z, integer inc_z, dcomplex* beta, dcomplex* rho_xz, dcomplex* rho_yz );

// --- dotsv3 ---

void bl1_sdotsv3( conj1_t conjxyw, integer n, float*    x, integer inc_x, float*    y, integer inc_y, float*    w, integer inc_w, float*    z, integer inc_z, float*    beta, float*    rho_xz, float*    rho_yz, float*    rho_wz );
void bl1_ddotsv3( conj1_t conjxyw, integer n, double*   x, integer inc_x, double*   y, integer inc_y, double*   w, integer inc_w, double*   z, integer inc_z, double*   beta, double*   rho_xz, double*   rho_yz, double*   rho_wz );
void bl1_cdotsv3( conj1_t conjxyw, integer n, scomplex* x, integer inc_x, scomplex* y, integer inc_y, scomplex* w, integer inc_w, scomplex* z, integer inc_z, scomplex* beta, scomplex* rho_xz, scomplex* rho_yz, scomplex* rho_wz );
void bl1_zdotsv3( conj1_t conjxyw, integer n, dcomplex* x, integer inc_x, dcomplex* y, integer inc_y, dcomplex* w, integer inc_w, dcomplex* z, integer inc_z, dcomplex* beta, dcomplex* rho_xz, dcomplex* rho_yz, dcomplex* rho_wz );

// --- dotaxpy ---

void bl1_sdotaxpy( integer n, float*    a, integer inc_a, float*    x, integer inc_x, float*    kappa, float*    rho, float*    w, integer inc_w );
void bl1_ddotaxpy( integer n, double*   a, integer inc_a, double*   x, integer inc_x, double*   kappa, double*   rho, double*   w, integer inc_w );
void bl1_cdotaxpy( integer n, scomplex* a, integer inc_a, scomplex* x, integer inc_x, scomplex* kappa, scomplex* rho, scomplex* w, integer inc_w );
void bl1_zdotaxpy( integer n, dcomplex* a, integer inc_a, dcomplex* x, integer inc_x, dcomplex* kappa, dcomplex* rho, dcomplex* w, integer inc_w );

// --- dotaxmyv2 ---

void bl1_sdotaxmyv2( integer n, float*    alpha, float*    beta, float*    x, integer inc_x, float*    u, integer inc_u, float*    rho, float*    y, integer inc_y, float*    z, integer inc_z );
void bl1_ddotaxmyv2( integer n, double*   alpha, double*   beta, double*   x, integer inc_x, double*   u, integer inc_u, double*   rho, double*   y, integer inc_y, double*   z, integer inc_z );
void bl1_cdotaxmyv2( integer n, scomplex* alpha, scomplex* beta, scomplex* x, integer inc_x, scomplex* u, integer inc_u, scomplex* rho, scomplex* y, integer inc_y, scomplex* z, integer inc_z );
void bl1_zdotaxmyv2( integer n, dcomplex* alpha, dcomplex* beta, dcomplex* x, integer inc_x, dcomplex* u, integer inc_u, dcomplex* rho, dcomplex* y, integer inc_y, dcomplex* z, integer inc_z );

// --- dotv2axpyv2b ---

void bl1_sdotv2axpyv2b( integer n, float*    a1, integer inc_a1, float*    a2, integer inc_a2, float*    x,  integer inc_x, float*    kappa1, float*    kappa2, float*    rho1, float*    rho2, float*    w, integer inc_w );
void bl1_ddotv2axpyv2b( integer n, double*   a1, integer inc_a1, double*   a2, integer inc_a2, double*   x,  integer inc_x, double*   kappa1, double*   kappa2, double*   rho1, double*   rho2, double*   w, integer inc_w );
void bl1_cdotv2axpyv2b( integer n, scomplex* a1, integer inc_a1, scomplex* a2, integer inc_a2, scomplex* x,  integer inc_x, scomplex* kappa1, scomplex* kappa2, scomplex* rho1, scomplex* rho2, scomplex* w, integer inc_w );
void bl1_zdotv2axpyv2b( integer n, dcomplex* a1, integer inc_a1, dcomplex* a2, integer inc_a2, dcomplex* x,  integer inc_x, dcomplex* kappa1, dcomplex* kappa2, dcomplex* rho1, dcomplex* rho2, dcomplex* w, integer inc_w );

// --- axpyv2bdots ---

void bl1_zaxpyv2bdots( integer       n,
                       dcomplex* alpha1,
                       dcomplex* alpha2,
                       dcomplex* x1, integer inc_x1,
                       dcomplex* x2, integer inc_x2,
                       dcomplex* y,  integer inc_y,
                       dcomplex* u,  integer inc_u,
                       dcomplex* beta,
                       dcomplex* rho );
// end blis_prototypes_fused1.h

// begin blis_f77_name_mangling.h


// --- Define Fortran name-mangling macro --------------------------------------

// If the F77_FUNC name-mangling macro is undefined, then we we need to define
// it ourselves.
#ifndef F77_FUNC

  // Case 1: F77_FUNC is undefined because we're building for Windows.
  #ifdef BLIS1_ENABLE_WINDOWS_BUILD

    // Check whether we need to use uppercase Fortran routine names; otherwise
    // default to lowercase.
    #ifdef BLIS1_ENABLE_UPPERCASE_F77

      // Use uppercase routine names (no underscore).
      #define F77_FUNC( name_lower, name_upper ) \
              name_upper
    #else

      // Use lowercase routine names (no underscore).
      #define F77_FUNC( name_lower, name_upper ) \
              name_lower
    #endif

  // Case 2: F77_FUNC is undefined because we're in a Linux-like environment
  // that did not define it for us.
  #else

    // Check whether we need to use uppercase Fortran routine names; otherwise
    // default to lowercase.
    #ifdef BLIS1_ENABLE_UPPERCASE_F77

      // Use uppercase routine names (single underscore).
      #define F77_FUNC( name_lower, name_upper ) \
              name_upper ## _
    #else

      // Use lowercase routine names (single underscore).
      #define F77_FUNC( name_lower, name_upper ) \
              name_lower ## _
    #endif

  #endif // #ifdef BLIS1_ENABLE_WINDOWS_BUILD

#endif // #ifndef F77_FUNC

// end blis_f77_name_mangling.h

#ifdef BLIS1_ENABLE_CBLAS_INTERFACES
// begin blis_prototypes_cblas.h


#include <stddef.h> // skipped


#define CBLAS_INDEX size_t  
enum CBLAS_ORDER     {CblasRowMajor=101, CblasColMajor=102};
enum CBLAS_TRANSPOSE {CblasNoTrans=111, CblasTrans=112, CblasConjTrans=113};
enum CBLAS_UPLO      {CblasUpper=121, CblasLower=122};
enum CBLAS_DIAG      {CblasNonUnit=131, CblasUnit=132};
enum CBLAS_SIDE      {CblasLeft=141, CblasRight=142};


float  cblas_sdsdot(const integer N, const float alpha, const float *X,
                    const integer incX, const float *Y, const integer incY);
double cblas_dsdot(const integer N, const float *X, const integer incX, const float *Y,
                   const integer incY);
float  cblas_sdot(const integer N, const float  *X, const integer incX,
                  const float  *Y, const integer incY);
double cblas_ddot(const integer N, const double *X, const integer incX,
                  const double *Y, const integer incY);


void   cblas_cdotu_sub(const integer N, const void *X, const integer incX,
                       const void *Y, const integer incY, void *dotu);
void   cblas_cdotc_sub(const integer N, const void *X, const integer incX,
                       const void *Y, const integer incY, void *dotc);

void   cblas_zdotu_sub(const integer N, const void *X, const integer incX,
                       const void *Y, const integer incY, void *dotu);
void   cblas_zdotc_sub(const integer N, const void *X, const integer incX,
                       const void *Y, const integer incY, void *dotc);



float  cblas_snrm2(const integer N, const float *X, const integer incX);
float  cblas_sasum(const integer N, const float *X, const integer incX);

double cblas_dnrm2(const integer N, const double *X, const integer incX);
double cblas_dasum(const integer N, const double *X, const integer incX);

float  cblas_scnrm2(const integer N, const void *X, const integer incX);
float  cblas_scasum(const integer N, const void *X, const integer incX);

double cblas_dznrm2(const integer N, const void *X, const integer incX);
double cblas_dzasum(const integer N, const void *X, const integer incX);



CBLAS_INDEX cblas_isamax(const integer N, const float  *X, const integer incX);
CBLAS_INDEX cblas_idamax(const integer N, const double *X, const integer incX);
CBLAS_INDEX cblas_icamax(const integer N, const void   *X, const integer incX);
CBLAS_INDEX cblas_izamax(const integer N, const void   *X, const integer incX);




void cblas_sswap(const integer N, float *X, const integer incX, 
                 float *Y, const integer incY);
void cblas_scopy(const integer N, const float *X, const integer incX, 
                 float *Y, const integer incY);
void cblas_saxpy(const integer N, const float alpha, const float *X,
                 const integer incX, float *Y, const integer incY);

void cblas_dswap(const integer N, double *X, const integer incX, 
                 double *Y, const integer incY);
void cblas_dcopy(const integer N, const double *X, const integer incX, 
                 double *Y, const integer incY);
void cblas_daxpy(const integer N, const double alpha, const double *X,
                 const integer incX, double *Y, const integer incY);

void cblas_cswap(const integer N, void *X, const integer incX, 
                 void *Y, const integer incY);
void cblas_ccopy(const integer N, const void *X, const integer incX, 
                 void *Y, const integer incY);
void cblas_caxpy(const integer N, const void *alpha, const void *X,
                 const integer incX, void *Y, const integer incY);

void cblas_zswap(const integer N, void *X, const integer incX, 
                 void *Y, const integer incY);
void cblas_zcopy(const integer N, const void *X, const integer incX, 
                 void *Y, const integer incY);
void cblas_zaxpy(const integer N, const void *alpha, const void *X,
                 const integer incX, void *Y, const integer incY);



void cblas_srotg(float *a, float *b, float *c, float *s);
void cblas_srotmg(float *d1, float *d2, float *b1, const float b2, float *P);
void cblas_srot(const integer N, float *X, const integer incX,
                float *Y, const integer incY, const float c, const float s);
void cblas_srotm(const integer N, float *X, const integer incX,
                float *Y, const integer incY, const float *P);

void cblas_drotg(double *a, double *b, double *c, double *s);
void cblas_drotmg(double *d1, double *d2, double *b1, const double b2, double *P);
void cblas_drot(const integer N, double *X, const integer incX,
                double *Y, const integer incY, const double c, const double s);
void cblas_drotm(const integer N, double *X, const integer incX,
                double *Y, const integer incY, const double *P);



void cblas_sscal(const integer N, const float alpha, float *X, const integer incX);
void cblas_dscal(const integer N, const double alpha, double *X, const integer incX);
void cblas_cscal(const integer N, const void *alpha, void *X, const integer incX);
void cblas_zscal(const integer N, const void *alpha, void *X, const integer incX);
void cblas_csscal(const integer N, const float alpha, void *X, const integer incX);
void cblas_zdscal(const integer N, const double alpha, void *X, const integer incX);




void cblas_sgemv(const enum CBLAS_ORDER order,
                 const enum CBLAS_TRANSPOSE TransA, const integer M, const integer N,
                 const float alpha, const float *A, const integer lda,
                 const float *X, const integer incX, const float beta,
                 float *Y, const integer incY);
void cblas_sgbmv(const enum CBLAS_ORDER order,
                 const enum CBLAS_TRANSPOSE TransA, const integer M, const integer N,
                 const integer KL, const integer KU, const float alpha,
                 const float *A, const integer lda, const float *X,
                 const integer incX, const float beta, float *Y, const integer incY);
void cblas_strmv(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                 const enum CBLAS_TRANSPOSE TransA, const enum CBLAS_DIAG Diag,
                 const integer N, const float *A, const integer lda, 
                 float *X, const integer incX);
void cblas_stbmv(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                 const enum CBLAS_TRANSPOSE TransA, const enum CBLAS_DIAG Diag,
                 const integer N, const integer K, const float *A, const integer lda, 
                 float *X, const integer incX);
void cblas_stpmv(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                 const enum CBLAS_TRANSPOSE TransA, const enum CBLAS_DIAG Diag,
                 const integer N, const float *Ap, float *X, const integer incX);
void cblas_strsv(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                 const enum CBLAS_TRANSPOSE TransA, const enum CBLAS_DIAG Diag,
                 const integer N, const float *A, const integer lda, float *X,
                 const integer incX);
void cblas_stbsv(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                 const enum CBLAS_TRANSPOSE TransA, const enum CBLAS_DIAG Diag,
                 const integer N, const integer K, const float *A, const integer lda,
                 float *X, const integer incX);
void cblas_stpsv(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                 const enum CBLAS_TRANSPOSE TransA, const enum CBLAS_DIAG Diag,
                 const integer N, const float *Ap, float *X, const integer incX);

void cblas_dgemv(const enum CBLAS_ORDER order,
                 const enum CBLAS_TRANSPOSE TransA, const integer M, const integer N,
                 const double alpha, const double *A, const integer lda,
                 const double *X, const integer incX, const double beta,
                 double *Y, const integer incY);
void cblas_dgbmv(const enum CBLAS_ORDER order,
                 const enum CBLAS_TRANSPOSE TransA, const integer M, const integer N,
                 const integer KL, const integer KU, const double alpha,
                 const double *A, const integer lda, const double *X,
                 const integer incX, const double beta, double *Y, const integer incY);
void cblas_dtrmv(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                 const enum CBLAS_TRANSPOSE TransA, const enum CBLAS_DIAG Diag,
                 const integer N, const double *A, const integer lda, 
                 double *X, const integer incX);
void cblas_dtbmv(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                 const enum CBLAS_TRANSPOSE TransA, const enum CBLAS_DIAG Diag,
                 const integer N, const integer K, const double *A, const integer lda, 
                 double *X, const integer incX);
void cblas_dtpmv(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                 const enum CBLAS_TRANSPOSE TransA, const enum CBLAS_DIAG Diag,
                 const integer N, const double *Ap, double *X, const integer incX);
void cblas_dtrsv(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                 const enum CBLAS_TRANSPOSE TransA, const enum CBLAS_DIAG Diag,
                 const integer N, const double *A, const integer lda, double *X,
                 const integer incX);
void cblas_dtbsv(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                 const enum CBLAS_TRANSPOSE TransA, const enum CBLAS_DIAG Diag,
                 const integer N, const integer K, const double *A, const integer lda,
                 double *X, const integer incX);
void cblas_dtpsv(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                 const enum CBLAS_TRANSPOSE TransA, const enum CBLAS_DIAG Diag,
                 const integer N, const double *Ap, double *X, const integer incX);

void cblas_cgemv(const enum CBLAS_ORDER order,
                 const enum CBLAS_TRANSPOSE TransA, const integer M, const integer N,
                 const void *alpha, const void *A, const integer lda,
                 const void *X, const integer incX, const void *beta,
                 void *Y, const integer incY);
void cblas_cgbmv(const enum CBLAS_ORDER order,
                 const enum CBLAS_TRANSPOSE TransA, const integer M, const integer N,
                 const integer KL, const integer KU, const void *alpha,
                 const void *A, const integer lda, const void *X,
                 const integer incX, const void *beta, void *Y, const integer incY);
void cblas_ctrmv(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                 const enum CBLAS_TRANSPOSE TransA, const enum CBLAS_DIAG Diag,
                 const integer N, const void *A, const integer lda, 
                 void *X, const integer incX);
void cblas_ctbmv(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                 const enum CBLAS_TRANSPOSE TransA, const enum CBLAS_DIAG Diag,
                 const integer N, const integer K, const void *A, const integer lda, 
                 void *X, const integer incX);
void cblas_ctpmv(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                 const enum CBLAS_TRANSPOSE TransA, const enum CBLAS_DIAG Diag,
                 const integer N, const void *Ap, void *X, const integer incX);
void cblas_ctrsv(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                 const enum CBLAS_TRANSPOSE TransA, const enum CBLAS_DIAG Diag,
                 const integer N, const void *A, const integer lda, void *X,
                 const integer incX);
void cblas_ctbsv(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                 const enum CBLAS_TRANSPOSE TransA, const enum CBLAS_DIAG Diag,
                 const integer N, const integer K, const void *A, const integer lda,
                 void *X, const integer incX);
void cblas_ctpsv(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                 const enum CBLAS_TRANSPOSE TransA, const enum CBLAS_DIAG Diag,
                 const integer N, const void *Ap, void *X, const integer incX);

void cblas_zgemv(const enum CBLAS_ORDER order,
                 const enum CBLAS_TRANSPOSE TransA, const integer M, const integer N,
                 const void *alpha, const void *A, const integer lda,
                 const void *X, const integer incX, const void *beta,
                 void *Y, const integer incY);
void cblas_zgbmv(const enum CBLAS_ORDER order,
                 const enum CBLAS_TRANSPOSE TransA, const integer M, const integer N,
                 const integer KL, const integer KU, const void *alpha,
                 const void *A, const integer lda, const void *X,
                 const integer incX, const void *beta, void *Y, const integer incY);
void cblas_ztrmv(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                 const enum CBLAS_TRANSPOSE TransA, const enum CBLAS_DIAG Diag,
                 const integer N, const void *A, const integer lda, 
                 void *X, const integer incX);
void cblas_ztbmv(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                 const enum CBLAS_TRANSPOSE TransA, const enum CBLAS_DIAG Diag,
                 const integer N, const integer K, const void *A, const integer lda, 
                 void *X, const integer incX);
void cblas_ztpmv(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                 const enum CBLAS_TRANSPOSE TransA, const enum CBLAS_DIAG Diag,
                 const integer N, const void *Ap, void *X, const integer incX);
void cblas_ztrsv(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                 const enum CBLAS_TRANSPOSE TransA, const enum CBLAS_DIAG Diag,
                 const integer N, const void *A, const integer lda, void *X,
                 const integer incX);
void cblas_ztbsv(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                 const enum CBLAS_TRANSPOSE TransA, const enum CBLAS_DIAG Diag,
                 const integer N, const integer K, const void *A, const integer lda,
                 void *X, const integer incX);
void cblas_ztpsv(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                 const enum CBLAS_TRANSPOSE TransA, const enum CBLAS_DIAG Diag,
                 const integer N, const void *Ap, void *X, const integer incX);



void cblas_ssymv(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                 const integer N, const float alpha, const float *A,
                 const integer lda, const float *X, const integer incX,
                 const float beta, float *Y, const integer incY);
void cblas_ssbmv(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                 const integer N, const integer K, const float alpha, const float *A,
                 const integer lda, const float *X, const integer incX,
                 const float beta, float *Y, const integer incY);
void cblas_sspmv(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                 const integer N, const float alpha, const float *Ap,
                 const float *X, const integer incX,
                 const float beta, float *Y, const integer incY);
void cblas_sger(const enum CBLAS_ORDER order, const integer M, const integer N,
                const float alpha, const float *X, const integer incX,
                const float *Y, const integer incY, float *A, const integer lda);
void cblas_ssyr(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                const integer N, const float alpha, const float *X,
                const integer incX, float *A, const integer lda);
void cblas_sspr(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                const integer N, const float alpha, const float *X,
                const integer incX, float *Ap);
void cblas_ssyr2(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                const integer N, const float alpha, const float *X,
                const integer incX, const float *Y, const integer incY, float *A,
                const integer lda);
void cblas_sspr2(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                const integer N, const float alpha, const float *X,
                const integer incX, const float *Y, const integer incY, float *A);

void cblas_dsymv(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                 const integer N, const double alpha, const double *A,
                 const integer lda, const double *X, const integer incX,
                 const double beta, double *Y, const integer incY);
void cblas_dsbmv(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                 const integer N, const integer K, const double alpha, const double *A,
                 const integer lda, const double *X, const integer incX,
                 const double beta, double *Y, const integer incY);
void cblas_dspmv(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                 const integer N, const double alpha, const double *Ap,
                 const double *X, const integer incX,
                 const double beta, double *Y, const integer incY);
void cblas_dger(const enum CBLAS_ORDER order, const integer M, const integer N,
                const double alpha, const double *X, const integer incX,
                const double *Y, const integer incY, double *A, const integer lda);
void cblas_dsyr(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                const integer N, const double alpha, const double *X,
                const integer incX, double *A, const integer lda);
void cblas_dspr(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                const integer N, const double alpha, const double *X,
                const integer incX, double *Ap);
void cblas_dsyr2(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                const integer N, const double alpha, const double *X,
                const integer incX, const double *Y, const integer incY, double *A,
                const integer lda);
void cblas_dspr2(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                const integer N, const double alpha, const double *X,
                const integer incX, const double *Y, const integer incY, double *A);



void cblas_chemv(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                 const integer N, const void *alpha, const void *A,
                 const integer lda, const void *X, const integer incX,
                 const void *beta, void *Y, const integer incY);
void cblas_chbmv(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                 const integer N, const integer K, const void *alpha, const void *A,
                 const integer lda, const void *X, const integer incX,
                 const void *beta, void *Y, const integer incY);
void cblas_chpmv(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                 const integer N, const void *alpha, const void *Ap,
                 const void *X, const integer incX,
                 const void *beta, void *Y, const integer incY);
void cblas_cgeru(const enum CBLAS_ORDER order, const integer M, const integer N,
                 const void *alpha, const void *X, const integer incX,
                 const void *Y, const integer incY, void *A, const integer lda);
void cblas_cgerc(const enum CBLAS_ORDER order, const integer M, const integer N,
                 const void *alpha, const void *X, const integer incX,
                 const void *Y, const integer incY, void *A, const integer lda);
void cblas_cher(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                const integer N, const float alpha, const void *X, const integer incX,
                void *A, const integer lda);
void cblas_chpr(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                const integer N, const float *alpha, const void *X,
                const integer incX, void *A);
void cblas_cher2(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo, const integer N,
                const void *alpha, const void *X, const integer incX,
                const void *Y, const integer incY, void *A, const integer lda);
void cblas_chpr2(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo, const integer N,
                const void *alpha, const void *X, const integer incX,
                const void *Y, const integer incY, void *Ap);

void cblas_zhemv(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                 const integer N, const void *alpha, const void *A,
                 const integer lda, const void *X, const integer incX,
                 const void *beta, void *Y, const integer incY);
void cblas_zhbmv(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                 const integer N, const integer K, const void *alpha, const void *A,
                 const integer lda, const void *X, const integer incX,
                 const void *beta, void *Y, const integer incY);
void cblas_zhpmv(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                 const integer N, const void *alpha, const void *Ap,
                 const void *X, const integer incX,
                 const void *beta, void *Y, const integer incY);
void cblas_zgeru(const enum CBLAS_ORDER order, const integer M, const integer N,
                 const void *alpha, const void *X, const integer incX,
                 const void *Y, const integer incY, void *A, const integer lda);
void cblas_zgerc(const enum CBLAS_ORDER order, const integer M, const integer N,
                 const void *alpha, const void *X, const integer incX,
                 const void *Y, const integer incY, void *A, const integer lda);
void cblas_zher(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                const integer N, const double alpha, const void *X, const integer incX,
                void *A, const integer lda);
void cblas_zhpr(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo,
                const integer N, const double *alpha, const void *X,
                const integer incX, void *A);
void cblas_zher2(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo, const integer N,
                const void *alpha, const void *X, const integer incX,
                const void *Y, const integer incY, void *A, const integer lda);
void cblas_zhpr2(const enum CBLAS_ORDER order, const enum CBLAS_UPLO Uplo, const integer N,
                const void *alpha, const void *X, const integer incX,
                const void *Y, const integer incY, void *Ap);




void cblas_sgemm(const enum CBLAS_ORDER Order, const enum CBLAS_TRANSPOSE TransA,
                 const enum CBLAS_TRANSPOSE TransB, const integer M, const integer N,
                 const integer K, const float alpha, const float *A,
                 const integer lda, const float *B, const integer ldb,
                 const float beta, float *C, const integer ldc);
void cblas_ssymm(const enum CBLAS_ORDER Order, const enum CBLAS_SIDE Side,
                 const enum CBLAS_UPLO Uplo, const integer M, const integer N,
                 const float alpha, const float *A, const integer lda,
                 const float *B, const integer ldb, const float beta,
                 float *C, const integer ldc);
void cblas_ssyrk(const enum CBLAS_ORDER Order, const enum CBLAS_UPLO Uplo,
                 const enum CBLAS_TRANSPOSE Trans, const integer N, const integer K,
                 const float alpha, const float *A, const integer lda,
                 const float beta, float *C, const integer ldc);
void cblas_ssyr2k(const enum CBLAS_ORDER Order, const enum CBLAS_UPLO Uplo,
                  const enum CBLAS_TRANSPOSE Trans, const integer N, const integer K,
                  const float alpha, const float *A, const integer lda,
                  const float *B, const integer ldb, const float beta,
                  float *C, const integer ldc);
void cblas_strmm(const enum CBLAS_ORDER Order, const enum CBLAS_SIDE Side,
                 const enum CBLAS_UPLO Uplo, const enum CBLAS_TRANSPOSE TransA,
                 const enum CBLAS_DIAG Diag, const integer M, const integer N,
                 const float alpha, const float *A, const integer lda,
                 float *B, const integer ldb);
void cblas_strsm(const enum CBLAS_ORDER Order, const enum CBLAS_SIDE Side,
                 const enum CBLAS_UPLO Uplo, const enum CBLAS_TRANSPOSE TransA,
                 const enum CBLAS_DIAG Diag, const integer M, const integer N,
                 const float alpha, const float *A, const integer lda,
                 float *B, const integer ldb);

void cblas_dgemm(const enum CBLAS_ORDER Order, const enum CBLAS_TRANSPOSE TransA,
                 const enum CBLAS_TRANSPOSE TransB, const integer M, const integer N,
                 const integer K, const double alpha, const double *A,
                 const integer lda, const double *B, const integer ldb,
                 const double beta, double *C, const integer ldc);
void cblas_dsymm(const enum CBLAS_ORDER Order, const enum CBLAS_SIDE Side,
                 const enum CBLAS_UPLO Uplo, const integer M, const integer N,
                 const double alpha, const double *A, const integer lda,
                 const double *B, const integer ldb, const double beta,
                 double *C, const integer ldc);
void cblas_dsyrk(const enum CBLAS_ORDER Order, const enum CBLAS_UPLO Uplo,
                 const enum CBLAS_TRANSPOSE Trans, const integer N, const integer K,
                 const double alpha, const double *A, const integer lda,
                 const double beta, double *C, const integer ldc);
void cblas_dsyr2k(const enum CBLAS_ORDER Order, const enum CBLAS_UPLO Uplo,
                  const enum CBLAS_TRANSPOSE Trans, const integer N, const integer K,
                  const double alpha, const double *A, const integer lda,
                  const double *B, const integer ldb, const double beta,
                  double *C, const integer ldc);
void cblas_dtrmm(const enum CBLAS_ORDER Order, const enum CBLAS_SIDE Side,
                 const enum CBLAS_UPLO Uplo, const enum CBLAS_TRANSPOSE TransA,
                 const enum CBLAS_DIAG Diag, const integer M, const integer N,
                 const double alpha, const double *A, const integer lda,
                 double *B, const integer ldb);
void cblas_dtrsm(const enum CBLAS_ORDER Order, const enum CBLAS_SIDE Side,
                 const enum CBLAS_UPLO Uplo, const enum CBLAS_TRANSPOSE TransA,
                 const enum CBLAS_DIAG Diag, const integer M, const integer N,
                 const double alpha, const double *A, const integer lda,
                 double *B, const integer ldb);

void cblas_cgemm(const enum CBLAS_ORDER Order, const enum CBLAS_TRANSPOSE TransA,
                 const enum CBLAS_TRANSPOSE TransB, const integer M, const integer N,
                 const integer K, const void *alpha, const void *A,
                 const integer lda, const void *B, const integer ldb,
                 const void *beta, void *C, const integer ldc);
void cblas_csymm(const enum CBLAS_ORDER Order, const enum CBLAS_SIDE Side,
                 const enum CBLAS_UPLO Uplo, const integer M, const integer N,
                 const void *alpha, const void *A, const integer lda,
                 const void *B, const integer ldb, const void *beta,
                 void *C, const integer ldc);
void cblas_csyrk(const enum CBLAS_ORDER Order, const enum CBLAS_UPLO Uplo,
                 const enum CBLAS_TRANSPOSE Trans, const integer N, const integer K,
                 const void *alpha, const void *A, const integer lda,
                 const void *beta, void *C, const integer ldc);
void cblas_csyr2k(const enum CBLAS_ORDER Order, const enum CBLAS_UPLO Uplo,
                  const enum CBLAS_TRANSPOSE Trans, const integer N, const integer K,
                  const void *alpha, const void *A, const integer lda,
                  const void *B, const integer ldb, const void *beta,
                  void *C, const integer ldc);
void cblas_ctrmm(const enum CBLAS_ORDER Order, const enum CBLAS_SIDE Side,
                 const enum CBLAS_UPLO Uplo, const enum CBLAS_TRANSPOSE TransA,
                 const enum CBLAS_DIAG Diag, const integer M, const integer N,
                 const void *alpha, const void *A, const integer lda,
                 void *B, const integer ldb);
void cblas_ctrsm(const enum CBLAS_ORDER Order, const enum CBLAS_SIDE Side,
                 const enum CBLAS_UPLO Uplo, const enum CBLAS_TRANSPOSE TransA,
                 const enum CBLAS_DIAG Diag, const integer M, const integer N,
                 const void *alpha, const void *A, const integer lda,
                 void *B, const integer ldb);

void cblas_zgemm(const enum CBLAS_ORDER Order, const enum CBLAS_TRANSPOSE TransA,
                 const enum CBLAS_TRANSPOSE TransB, const integer M, const integer N,
                 const integer K, const void *alpha, const void *A,
                 const integer lda, const void *B, const integer ldb,
                 const void *beta, void *C, const integer ldc);
void cblas_zsymm(const enum CBLAS_ORDER Order, const enum CBLAS_SIDE Side,
                 const enum CBLAS_UPLO Uplo, const integer M, const integer N,
                 const void *alpha, const void *A, const integer lda,
                 const void *B, const integer ldb, const void *beta,
                 void *C, const integer ldc);
void cblas_zsyrk(const enum CBLAS_ORDER Order, const enum CBLAS_UPLO Uplo,
                 const enum CBLAS_TRANSPOSE Trans, const integer N, const integer K,
                 const void *alpha, const void *A, const integer lda,
                 const void *beta, void *C, const integer ldc);
void cblas_zsyr2k(const enum CBLAS_ORDER Order, const enum CBLAS_UPLO Uplo,
                  const enum CBLAS_TRANSPOSE Trans, const integer N, const integer K,
                  const void *alpha, const void *A, const integer lda,
                  const void *B, const integer ldb, const void *beta,
                  void *C, const integer ldc);
void cblas_ztrmm(const enum CBLAS_ORDER Order, const enum CBLAS_SIDE Side,
                 const enum CBLAS_UPLO Uplo, const enum CBLAS_TRANSPOSE TransA,
                 const enum CBLAS_DIAG Diag, const integer M, const integer N,
                 const void *alpha, const void *A, const integer lda,
                 void *B, const integer ldb);
void cblas_ztrsm(const enum CBLAS_ORDER Order, const enum CBLAS_SIDE Side,
                 const enum CBLAS_UPLO Uplo, const enum CBLAS_TRANSPOSE TransA,
                 const enum CBLAS_DIAG Diag, const integer M, const integer N,
                 const void *alpha, const void *A, const integer lda,
                 void *B, const integer ldb);



void cblas_chemm(const enum CBLAS_ORDER Order, const enum CBLAS_SIDE Side,
                 const enum CBLAS_UPLO Uplo, const integer M, const integer N,
                 const void *alpha, const void *A, const integer lda,
                 const void *B, const integer ldb, const void *beta,
                 void *C, const integer ldc);
void cblas_cherk(const enum CBLAS_ORDER Order, const enum CBLAS_UPLO Uplo,
                 const enum CBLAS_TRANSPOSE Trans, const integer N, const integer K,
                 const float alpha, const void *A, const integer lda,
                 const float beta, void *C, const integer ldc);
void cblas_cher2k(const enum CBLAS_ORDER Order, const enum CBLAS_UPLO Uplo,
                  const enum CBLAS_TRANSPOSE Trans, const integer N, const integer K,
                  const void *alpha, const void *A, const integer lda,
                  const void *B, const integer ldb, const float beta,
                  void *C, const integer ldc);

void cblas_zhemm(const enum CBLAS_ORDER Order, const enum CBLAS_SIDE Side,
                 const enum CBLAS_UPLO Uplo, const integer M, const integer N,
                 const void *alpha, const void *A, const integer lda,
                 const void *B, const integer ldb, const void *beta,
                 void *C, const integer ldc);
void cblas_zherk(const enum CBLAS_ORDER Order, const enum CBLAS_UPLO Uplo,
                 const enum CBLAS_TRANSPOSE Trans, const integer N, const integer K,
                 const double alpha, const void *A, const integer lda,
                 const double beta, void *C, const integer ldc);
void cblas_zher2k(const enum CBLAS_ORDER Order, const enum CBLAS_UPLO Uplo,
                  const enum CBLAS_TRANSPOSE Trans, const integer N, const integer K,
                  const void *alpha, const void *A, const integer lda,
                  const void *B, const integer ldb, const double beta,
                  void *C, const integer ldc);
// end blis_prototypes_cblas.h
#else
// begin blis_prototypes_blas.h


// --- Name-mangling macro definitions -----------------------------------------

// --- Name-mangle level-1 BLAS routines ---------------------------

#define F77_isamax F77_FUNC( isamax , ISAMAX )
#define F77_idamax F77_FUNC( idamax , IDAMAX )
#define F77_icamax F77_FUNC( icamax , ICAMAX )
#define F77_izamax F77_FUNC( izamax , IZAMAX )
#define F77_sasum  F77_FUNC( sasum  , SASUM  )
#define F77_dasum  F77_FUNC( dasum  , DASUM  )
#define F77_scasum F77_FUNC( scasum , SCASUM )
#define F77_dzasum F77_FUNC( dzasum , DZASUM )
#define F77_saxpy  F77_FUNC( saxpy  , SAXPY  )
#define F77_daxpy  F77_FUNC( daxpy  , DAXPY  )
#define F77_caxpy  F77_FUNC( caxpy  , CAXPY  )
#define F77_zaxpy  F77_FUNC( zaxpy  , ZAXPY  )
#define F77_scopy  F77_FUNC( scopy  , SCOPY  )
#define F77_dcopy  F77_FUNC( dcopy  , DCOPY  )
#define F77_ccopy  F77_FUNC( ccopy  , CCOPY  )
#define F77_zcopy  F77_FUNC( zcopy  , ZCOPY  )
#define F77_sdot   F77_FUNC( sdot   , SDOT   )
#define F77_ddot   F77_FUNC( ddot   , DDOT   )
#define F77_cdotu  F77_FUNC( cdotu  , CDOTU  )
#define F77_cdotc  F77_FUNC( cdotc  , CDOTC  )
#define F77_zdotu  F77_FUNC( zdotu  , ZDOTU  )
#define F77_zdotc  F77_FUNC( zdotc  , ZDOTC  )
#define F77_snrm2  F77_FUNC( snrm2  , SNRM2  )
#define F77_dnrm2  F77_FUNC( dnrm2  , DNRM2  )
#define F77_scnrm2 F77_FUNC( scnrm2 , SCNRM2 )
#define F77_dznrm2 F77_FUNC( dznrm2 , DZNRM2 )
#define F77_sscal  F77_FUNC( sscal  , SSCAL  )
#define F77_dscal  F77_FUNC( dscal  , DSCAL  )
#define F77_cscal  F77_FUNC( cscal  , CSCAL  )
#define F77_csscal F77_FUNC( csscal , CSSCAL )
#define F77_zscal  F77_FUNC( zscal  , ZSCAL  )
#define F77_zdscal F77_FUNC( zdscal , ZDSCAL )
#define F77_sswap  F77_FUNC( sswap  , SSWAP  )
#define F77_dswap  F77_FUNC( dswap  , DSWAP  )
#define F77_cswap  F77_FUNC( cswap  , CSWAP  )
#define F77_zswap  F77_FUNC( zswap  , ZSWAP  )

// --- Name-mangle level-2 BLAS routines ---------------------------

#define F77_sgemv  F77_FUNC( sgemv  , SGEMV  )
#define F77_dgemv  F77_FUNC( dgemv  , DGEMV  )
#define F77_cgemv  F77_FUNC( cgemv  , CGEMV  )
#define F77_zgemv  F77_FUNC( zgemv  , ZGEMV  )
#define F77_sger   F77_FUNC( sger   , SGER   )
#define F77_dger   F77_FUNC( dger   , DGER   )
#define F77_cgerc  F77_FUNC( cgerc  , CGERC  )
#define F77_cgeru  F77_FUNC( cgeru  , CGERU  )
#define F77_zgerc  F77_FUNC( zgerc  , ZGERC  )
#define F77_zgeru  F77_FUNC( zgeru  , ZGERU  )
#define F77_chemv  F77_FUNC( chemv  , CHEMV  )
#define F77_zhemv  F77_FUNC( zhemv  , ZHEMV  )
#define F77_cher   F77_FUNC( cher   , CHER   )
#define F77_zher   F77_FUNC( zher   , ZHER   )
#define F77_cher2  F77_FUNC( cher2  , CHER2  )
#define F77_zher2  F77_FUNC( zher2  , ZHER2  )
#define F77_ssymv  F77_FUNC( ssymv  , SSYMV  )
#define F77_dsymv  F77_FUNC( dsymv  , DSYMV  )
#define F77_ssyr   F77_FUNC( ssyr   , SSYR   )
#define F77_dsyr   F77_FUNC( dsyr   , DSYR   )
#define F77_ssyr2  F77_FUNC( ssyr2  , SSYR2  )
#define F77_dsyr2  F77_FUNC( dsyr2  , DSYR2  )
#define F77_strmv  F77_FUNC( strmv  , STRMV  )
#define F77_dtrmv  F77_FUNC( dtrmv  , DTRMV  )
#define F77_ctrmv  F77_FUNC( ctrmv  , CTRMV  )
#define F77_ztrmv  F77_FUNC( ztrmv  , ZTRMV  )
#define F77_strsv  F77_FUNC( strsv  , STRSV  )
#define F77_dtrsv  F77_FUNC( dtrsv  , DTRSV  )
#define F77_ctrsv  F77_FUNC( ctrsv  , CTRSV  )
#define F77_ztrsv  F77_FUNC( ztrsv  , ZTRSV  )

// --- Name-mangle level-3 BLAS routines ---------------------------

#define F77_sgemm  F77_FUNC( sgemm  , SGEMM  )
#define F77_dgemm  F77_FUNC( dgemm  , DGEMM  )
#define F77_cgemm  F77_FUNC( cgemm  , CGEMM  )
#define F77_zgemm  F77_FUNC( zgemm  , ZGEMM  )
#define F77_chemm  F77_FUNC( chemm  , CHEMM  )
#define F77_zhemm  F77_FUNC( zhemm  , ZHEMM  )
#define F77_cherk  F77_FUNC( cherk  , CHERK  )
#define F77_zherk  F77_FUNC( zherk  , ZHERK  )
#define F77_cher2k F77_FUNC( cher2k , CHER2K )
#define F77_zher2k F77_FUNC( zher2k , ZHER2K )
#define F77_ssymm  F77_FUNC( ssymm  , SSYMM  )
#define F77_dsymm  F77_FUNC( dsymm  , DSYMM  )
#define F77_csymm  F77_FUNC( csymm  , CSYMM  )
#define F77_zsymm  F77_FUNC( zsymm  , ZSYMM  )
#define F77_ssyrk  F77_FUNC( ssyrk  , SSYRK  )
#define F77_dsyrk  F77_FUNC( dsyrk  , DSYRK  )
#define F77_csyrk  F77_FUNC( csyrk  , CSYRK  )
#define F77_zsyrk  F77_FUNC( zsyrk  , ZSYRK  )
#define F77_ssyr2k F77_FUNC( ssyr2k , SSYR2K )
#define F77_dsyr2k F77_FUNC( dsyr2k , DSYR2K )
#define F77_csyr2k F77_FUNC( csyr2k , CSYR2K )
#define F77_zsyr2k F77_FUNC( zsyr2k , ZSYR2K )
#define F77_strmm  F77_FUNC( strmm  , STRMM  )
#define F77_dtrmm  F77_FUNC( dtrmm  , DTRMM  )
#define F77_ctrmm  F77_FUNC( ctrmm  , CTRMM  )
#define F77_ztrmm  F77_FUNC( ztrmm  , ZTRMM  )
#define F77_strsm  F77_FUNC( strsm  , STRSM  )
#define F77_dtrsm  F77_FUNC( dtrsm  , DTRSM  )
#define F77_ctrsm  F77_FUNC( ctrsm  , CTRSM  )
#define F77_ztrsm  F77_FUNC( ztrsm  , ZTRSM  )

#ifdef BLIS1_FROM_LIBFLAME
// --- Prototypes --------------------------------------------------------------

// --- Level-1 BLAS prototypes -------------------

// --- amax ---
integer  F77_isamax ( integer* n, float*    x, integer* incx );
integer  F77_idamax ( integer* n, double*   x, integer* incx );
integer  F77_icamax ( integer* n, scomplex* x, integer* incx );
integer  F77_izamax ( integer* n, dcomplex* x, integer* incx );
// --- asum ---
float    F77_sasum  ( integer* n, float*    x, integer* incx );
double   F77_dasum  ( integer* n, double*   x, integer* incx );
float    F77_scasum ( integer* n, scomplex* x, integer* incx );
double   F77_dzasum ( integer* n, dcomplex* x, integer* incx );
// --- axpy ---
void     F77_saxpy  ( integer* n, float*    alpha, float*    x, integer* incx,  float*    y, integer* incy );
void     F77_daxpy  ( integer* n, double*   alpha, double*   x, integer* incx,  double*   y, integer* incy );
void     F77_caxpy  ( integer* n, scomplex* alpha, scomplex* x, integer* incx,  scomplex* y, integer* incy );
void     F77_zaxpy  ( integer* n, dcomplex* alpha, dcomplex* x, integer* incx,  dcomplex* y, integer* incy );
// --- copy ---
void     F77_scopy  ( integer* n, float*    x, integer* incx, float*    y, integer* incy );
void     F77_dcopy  ( integer* n, double*   x, integer* incx, double*   y, integer* incy );
void     F77_ccopy  ( integer* n, scomplex* x, integer* incx, scomplex* y, integer* incy );
void     F77_zcopy  ( integer* n, dcomplex* x, integer* incx, dcomplex* y, integer* incy );
// --- dot ---
float    F77_sdot   ( integer* n, float*    x, integer* incx, float*    y, integer* incy );
double   F77_ddot   ( integer* n, double*   x, integer* incx, double*   y, integer* incy );
scomplex F77_cdotu  ( integer* n, scomplex* x, integer* incx, scomplex* y, integer* incy );
scomplex F77_cdotc  ( integer* n, scomplex* x, integer* incx, scomplex* y, integer* incy );
dcomplex F77_zdotu  ( integer* n, dcomplex* x, integer* incx, dcomplex* y, integer* incy );
dcomplex F77_zdotc  ( integer* n, dcomplex* x, integer* incx, dcomplex* y, integer* incy );
// --- nrm2 ---
float    F77_snrm2  ( integer* n, float*    x, integer* incx );
double   F77_dnrm2  ( integer* n, double*   x, integer* incx );
float    F77_scnrm2 ( integer* n, scomplex* x, integer* incx );
double   F77_dznrm2 ( integer* n, dcomplex* x, integer* incx );
// --- scal ---
void     F77_sscal  ( integer* n, float*    alpha, float*    y, integer* incy );
void     F77_dscal  ( integer* n, double*   alpha, double*   y, integer* incy );
void     F77_cscal  ( integer* n, scomplex* alpha, scomplex* y, integer* incy );
void     F77_csscal ( integer* n, float*    alpha, scomplex* y, integer* incy );
void     F77_zscal  ( integer* n, dcomplex* alpha, dcomplex* y, integer* incy );
void     F77_zdscal ( integer* n, double*   alpha, dcomplex* y, integer* incy );
// --- swap ---
void     F77_sswap  ( integer* n, float*    x, integer* incx, float*    y, integer* incy );
void     F77_dswap  ( integer* n, double*   x, integer* incx, double*   y, integer* incy );
void     F77_cswap  ( integer* n, scomplex* x, integer* incx, scomplex* y, integer* incy );
void     F77_zswap  ( integer* n, dcomplex* x, integer* incx, dcomplex* y, integer* incy );

// --- Level-2 BLAS prototypes -------------------

// --- gemv ---
void     F77_sgemv  ( char* transa, integer* m, integer* n, float*    alpha, float*    a, integer* lda, float*    x, integer* incx, float*    beta, float*    y, integer* incy );
void     F77_dgemv  ( char* transa, integer* m, integer* n, double*   alpha, double*   a, integer* lda, double*   x, integer* incx, double*   beta, double*   y, integer* incy );
void     F77_cgemv  ( char* transa, integer* m, integer* n, scomplex* alpha, scomplex* a, integer* lda, scomplex* x, integer* incx, scomplex* beta, scomplex* y, integer* incy );
void     F77_zgemv  ( char* transa, integer* m, integer* n, dcomplex* alpha, dcomplex* a, integer* lda, dcomplex* x, integer* incx, dcomplex* beta, dcomplex* y, integer* incy );
// --- ger ---
void     F77_sger   ( integer* m, integer* n, float*    alpha, float*    x, integer* incx, float*    y, integer* incy, float*    a, integer* lda );
void     F77_dger   ( integer* m, integer* n, double*   alpha, double*   x, integer* incx, double*   y, integer* incy, double*   a, integer* lda );
void     F77_cgerc  ( integer* m, integer* n, scomplex* alpha, scomplex* x, integer* incx, scomplex* y, integer* incy, scomplex* a, integer* lda );
void     F77_cgeru  ( integer* m, integer* n, scomplex* alpha, scomplex* x, integer* incx, scomplex* y, integer* incy, scomplex* a, integer* lda );
void     F77_zgerc  ( integer* m, integer* n, dcomplex* alpha, dcomplex* x, integer* incx, dcomplex* y, integer* incy, dcomplex* a, integer* lda );
void     F77_zgeru  ( integer* m, integer* n, dcomplex* alpha, dcomplex* x, integer* incx, dcomplex* y, integer* incy, dcomplex* a, integer* lda );
// --- hemv ---
void     F77_chemv  ( char* uplo, integer* n, scomplex* alpha, scomplex* a, integer* lda, scomplex* x, integer* incx, scomplex* beta, scomplex* y, integer* incy );
void     F77_zhemv  ( char* uplo, integer* n, dcomplex* alpha, dcomplex* a, integer* lda, dcomplex* x, integer* incx, dcomplex* beta, dcomplex* y, integer* incy );
// --- her ---
void     F77_cher   ( char* uplo, integer* n, float*    alpha, scomplex* x, integer* incx, scomplex* a, integer* lda );
void     F77_zher   ( char* uplo, integer* n, double*   alpha, dcomplex* x, integer* incx, dcomplex* a, integer* lda );
// --- her2 ---
void     F77_cher2  ( char* uplo, integer* n, scomplex* alpha, scomplex* x, integer* incx, scomplex* y, integer* incy, scomplex* a, integer* lda );
void     F77_zher2  ( char* uplo, integer* n, dcomplex* alpha, dcomplex* x, integer* incx, dcomplex* y, integer* incy, dcomplex* a, integer* lda );
// --- symv ---
void     F77_ssymv  ( char* uplo, integer* n, float*    alpha, float*    a, integer* lda, float*    x, integer* incx, float*    beta, float*    y, integer* incy );
void     F77_dsymv  ( char* uplo, integer* n, double*   alpha, double*   a, integer* lda, double*   x, integer* incx, double*   beta, double*   y, integer* incy );
// --- syr ---
void     F77_ssyr   ( char* uplo, integer* n, float*    alpha, float*    x, integer* incx, float*    a, integer* lda );
void     F77_dsyr   ( char* uplo, integer* n, double*   alpha, double*   x, integer* incx, double*   a, integer* lda );
// --- syr2 ---
void     F77_ssyr2  ( char* uplo, integer* n, float*    alpha, float*    x, integer* incx, float*    y, integer* incy, float*    a, integer* lda );
void     F77_dsyr2  ( char* uplo, integer* n, double*   alpha, double*   x, integer* incx, double*   y, integer* incy, double*   a, integer* lda );
// --- trmv ---
void     F77_strmv  ( char* uplo, char* transa, char* diag, integer* n,  float*    a, integer* lda, float*    y, integer* incy );
void     F77_dtrmv  ( char* uplo, char* transa, char* diag, integer* n,  double*   a, integer* lda, double*   y, integer* incy );
void     F77_ctrmv  ( char* uplo, char* transa, char* diag, integer* n,  scomplex* a, integer* lda, scomplex* y, integer* incy );
void     F77_ztrmv  ( char* uplo, char* transa, char* diag, integer* n,  dcomplex* a, integer* lda, dcomplex* y, integer* incy );
// --- trsv ---
void     F77_strsv  ( char* uplo, char* transa, char* diag, integer* n,  float*    a, integer* lda, float*    y, integer* incy );
void     F77_dtrsv  ( char* uplo, char* transa, char* diag, integer* n,  double*   a, integer* lda, double*   y, integer* incy );
void     F77_ctrsv  ( char* uplo, char* transa, char* diag, integer* n,  scomplex* a, integer* lda, scomplex* y, integer* incy );
void     F77_ztrsv  ( char* uplo, char* transa, char* diag, integer* n,  dcomplex* a, integer* lda, dcomplex* y, integer* incy );

// --- Level-3 BLAS prototypes -------------------

// --- gemm ---
void     F77_sgemm  ( char* transa, char* transb, integer* m, integer* n, integer* k, float*    alpha, float*    a, integer* lda, float*    b, integer* ldb, float*    beta, float*    c, integer* ldc );
void     F77_dgemm  ( char* transa, char* transb, integer* m, integer* n, integer* k, double*   alpha, double*   a, integer* lda, double*   b, integer* ldb, double*   beta, double*   c, integer* ldc );
void     F77_cgemm  ( char* transa, char* transb, integer* m, integer* n, integer* k, scomplex* alpha, scomplex* a, integer* lda, scomplex* b, integer* ldb, scomplex* beta, scomplex* c, integer* ldc );
void     F77_zgemm  ( char* transa, char* transb, integer* m, integer* n, integer* k, dcomplex* alpha, dcomplex* a, integer* lda, dcomplex* b, integer* ldb, dcomplex* beta, dcomplex* c, integer* ldc );
// --- hemm ---
void     F77_chemm  ( char* side, char* uplo, integer* m, integer* n, scomplex* alpha, scomplex* a, integer* lda, scomplex* b, integer* ldb, scomplex* beta, scomplex* c, integer* ldc );
void     F77_zhemm  ( char* side, char* uplo, integer* m, integer* n, dcomplex* alpha, dcomplex* a, integer* lda, dcomplex* b, integer* ldb, dcomplex* beta, dcomplex* c, integer* ldc );
// --- herk ---
void     F77_cherk  ( char* uplo, char* transa, integer* n, integer* k, float*  alpha, scomplex* a, integer* lda, float*  beta, scomplex* c, integer* ldc );
void     F77_zherk  ( char* uplo, char* transa, integer* n, integer* k, double* alpha, dcomplex* a, integer* lda, double* beta, dcomplex* c, integer* ldc );
// --- her2k ---
void     F77_cher2k ( char* uplo, char* transa, integer* n, integer* k, scomplex* alpha, scomplex* a, integer* lda, scomplex* b, integer* ldb, float*  beta, scomplex* c, integer* ldc );
void     F77_zher2k ( char* uplo, char* transa, integer* n, integer* k, dcomplex* alpha, dcomplex* a, integer* lda, dcomplex* b, integer* ldb, double* beta, dcomplex* c, integer* ldc );
// --- symm ---
void     F77_ssymm  ( char* side, char* uplo, integer* m, integer* n, float*    alpha, float*    a, integer* lda, float*    b, integer* ldb, float*    beta, float*    c, integer* ldc );
void     F77_dsymm  ( char* side, char* uplo, integer* m, integer* n, double*   alpha, double*   a, integer* lda, double*   b, integer* ldb, double*   beta, double*   c, integer* ldc );
void     F77_csymm  ( char* side, char* uplo, integer* m, integer* n, scomplex* alpha, scomplex* a, integer* lda, scomplex* b, integer* ldb, scomplex* beta, scomplex* c, integer* ldc );
void     F77_zsymm  ( char* side, char* uplo, integer* m, integer* n, dcomplex* alpha, dcomplex* a, integer* lda, dcomplex* b, integer* ldb, dcomplex* beta, dcomplex* c, integer* ldc );
// --- syrk ---
void     F77_ssyrk  ( char* uplo, char* transa, integer* n, integer* k, float*    alpha, float*    a, integer* lda, float*    beta, float*    c, integer* ldc );
void     F77_dsyrk  ( char* uplo, char* transa, integer* n, integer* k, double*   alpha, double*   a, integer* lda, double*   beta, double*   c, integer* ldc );
void     F77_csyrk  ( char* uplo, char* transa, integer* n, integer* k, scomplex* alpha, scomplex* a, integer* lda, scomplex* beta, scomplex* c, integer* ldc );
void     F77_zsyrk  ( char* uplo, char* transa, integer* n, integer* k, dcomplex* alpha, dcomplex* a, integer* lda, dcomplex* beta, dcomplex* c, integer* ldc );
// --- syr2k ---
void     F77_ssyr2k ( char* uplo, char* transa, integer* n, integer* k, float*    alpha, float*    a, integer* lda, float*    b, integer* ldb, float*    beta, float*    c, integer* ldc );
void     F77_dsyr2k ( char* uplo, char* transa, integer* n, integer* k, double*   alpha, double*   a, integer* lda, double*   b, integer* ldb, double*   beta, double*   c, integer* ldc );
void     F77_csyr2k ( char* uplo, char* transa, integer* n, integer* k, scomplex* alpha, scomplex* a, integer* lda, scomplex* b, integer* ldb, scomplex* beta, scomplex* c, integer* ldc );
void     F77_zsyr2k ( char* uplo, char* transa, integer* n, integer* k, dcomplex* alpha, dcomplex* a, integer* lda, dcomplex* b, integer* ldb, dcomplex* beta, dcomplex* c, integer* ldc );
// --- trmm ---
void     F77_strmm  ( char* side, char* uplo, char* transa, char* diag, integer* m, integer* n, float*    alpha, float*    a, integer* lda, float*    b, integer* ldb );
void     F77_dtrmm  ( char* side, char* uplo, char* transa, char* diag, integer* m, integer* n, double*   alpha, double*   a, integer* lda, double*   b, integer* ldb );
void     F77_ctrmm  ( char* side, char* uplo, char* transa, char* diag, integer* m, integer* n, scomplex* alpha, scomplex* a, integer* lda, scomplex* b, integer* ldb );
void     F77_ztrmm  ( char* side, char* uplo, char* transa, char* diag, integer* m, integer* n, dcomplex* alpha, dcomplex* a, integer* lda, dcomplex* b, integer* ldb );
// --- trsm ---
void     F77_strsm  ( char* side, char* uplo, char* transa, char* diag, integer* m, integer* n, float*    alpha, float*    a, integer* lda, float*    b, integer* ldb );
void     F77_dtrsm  ( char* side, char* uplo, char* transa, char* diag, integer* m, integer* n, double*   alpha, double*   a, integer* lda, double*   b, integer* ldb );
void     F77_ctrsm  ( char* side, char* uplo, char* transa, char* diag, integer* m, integer* n, scomplex* alpha, scomplex* a, integer* lda, scomplex* b, integer* ldb );
void     F77_ztrsm  ( char* side, char* uplo, char* transa, char* diag, integer* m, integer* n, dcomplex* alpha, dcomplex* a, integer* lda, dcomplex* b, integer* ldb );

#endif
// end blis_prototypes_blas.h
#endif

// End extern "C" construct block.
#ifdef __cplusplus
}
#endif

#endif
// end blis1.h

  // Include _PTR macro definitions.
// begin FLA_macro_ptr_defs.h


// begin FLA_type_defs.h




#ifndef FLA_TYPE_DEFS_H
#define FLA_TYPE_DEFS_H

#ifdef __cplusplus
// For C++, include stdint.h.
#include <stdint.h> // skipped
#elif __STDC_VERSION__ >= 199901L
// For C99 (or later), include stdint.h.
#include <stdint.h> // skipped
#else
// When stdint.h is not available, manually typedef the types we will use.
#ifdef _WIN32
typedef          __int32  int32_t;
typedef unsigned __int32 uint32_t;
typedef          __int64  int64_t;
typedef unsigned __int64 uint64_t;
#else
#error "Attempting to compile on pre-C99 system without stdint.h."
#endif
#endif

#if defined(FLA_ENABLE_ILP64)
typedef int64_t integer;
typedef uint64_t uinteger;
#else
typedef int integer;
typedef unsigned long uinteger;
#endif



#if   FLA_MULTITHREADING_MODEL == FLA_OPENMP
#ifdef FLA_ENABLE_TIDSP
#include <ti/omp/omp.h> // skipped
#else
#include <omp.h> // skipped
#endif
#elif FLA_MULTITHREADING_MODEL == FLA_PTHREADS
#include <pthread.h> // skipped
#endif


// --- Complex type definitions -----------------------------------------------

#ifndef _DEFINED_SCOMPLEX
#define _DEFINED_SCOMPLEX
typedef struct scomplex
{
  float real, imag;
} scomplex;
#endif

#ifndef _DEFINED_DCOMPLEX
#define _DEFINED_DCOMPLEX
typedef struct dcomplex
{
  double real, imag;
} dcomplex;
#endif


// --- Parameter and return type definitions ----------------------------------

typedef int FLA_Bool;
typedef int FLA_Error;
typedef int FLA_Quadrant;
typedef int FLA_Datatype;
typedef int FLA_Elemtype;
typedef int FLA_Side;
typedef int FLA_Uplo;
typedef int FLA_Trans;
typedef int FLA_Conj;
typedef int FLA_Diag;
typedef int FLA_Dimension;
typedef int FLA_Pivot_type;
typedef int FLA_Direct;
typedef int FLA_Store;
typedef int FLA_Matrix_type;
typedef int FLA_Precision;
typedef int FLA_Domain;
typedef int FLA_Inv;
typedef int FLA_Evd_type;
typedef int FLA_Svd_type;
typedef int FLA_Machval;
typedef int FLA_Diag_off;

#ifndef _DEFINED_FLA_DIM_T
#define _DEFINED_FLA_DIM_T
typedef uinteger fla_dim_t;
#endif

// --- Intrinsic/assembly definitions ----------------------------------------

#if FLA_VECTOR_INTRINSIC_TYPE == FLA_SSE_INTRINSICS

#include "pmmintrin.h" // skipped

//typedef double v2df __attribute__ ((vector_size (16)));

typedef union
{
    __m128  v; 
    float   f[4];
} v4sf_t;

typedef union
{
    __m128d v; 
    double  d[2];
} v2df_t;

#endif

// --- FLAME object definitions -----------------------------------------------

typedef struct FLA_Lock_s     FLA_Lock;

//#ifdef FLA_ENABLE_MULTITHREADING
struct FLA_Lock_s
{
  // Implementation-specific lock object
#if   FLA_MULTITHREADING_MODEL == FLA_OPENMP
  omp_lock_t       lock;
#elif FLA_MULTITHREADING_MODEL == FLA_PTHREADS
  pthread_mutex_t  lock;
#endif
};
//#endif

#ifdef FLA_ENABLE_SUPERMATRIX
typedef int                   FLASH_Verbose;
typedef int                   FLASH_Data_aff;

typedef struct FLASH_Queue_s  FLASH_Queue;
typedef struct FLASH_Task_s   FLASH_Task;
typedef struct FLASH_Dep_s    FLASH_Dep;
#endif
typedef struct FLASH_Thread_s FLASH_Thread;

typedef struct FLA_Obj_struct
{
  // Basic object description fields
  FLA_Datatype  datatype;
  FLA_Elemtype  elemtype;
  fla_dim_t         m;
  fla_dim_t         n;
  fla_dim_t         rs;
  fla_dim_t         cs;
  fla_dim_t         m_inner;
  fla_dim_t         n_inner;
  unsigned long id;
  fla_dim_t         m_index;
  fla_dim_t         n_index;

  fla_dim_t         n_elem_alloc;
  void*         buffer;
  int           buffer_info;

  FLA_Uplo      uplo;

#ifdef FLA_ENABLE_SUPERMATRIX
  // Fields for supermatrix
  int           n_read_blocks;
  int           n_write_blocks;

  // All the tasks that previously read this block, anti-dependency
  int           n_read_tasks;
  FLASH_Dep*    read_task_head;
  FLASH_Dep*    read_task_tail;

  // Task that last overwrote this block, flow dependency
  FLASH_Task*   write_task;
#endif
} FLA_Base_obj;

typedef struct FLA_Obj_view
{
  // Basic object view description fields
  fla_dim_t         offm;
  fla_dim_t         offn;
  fla_dim_t         m;
  fla_dim_t         n;
  
  fla_dim_t         m_inner;
  fla_dim_t         n_inner;

  FLA_Base_obj* base;

} FLA_Obj;

#ifdef FLA_ENABLE_SUPERMATRIX
struct FLASH_Queue_s
{
  // Number of tasks currently in queue
  unsigned int  n_tasks;

  // Pointers to head (front) and tail (back) of queue
  FLASH_Task*   head;
  FLASH_Task*   tail;
};

struct FLASH_Task_s
{
  // Execution information
  int           n_ready;

  // Labels
  int           order;
  int           queue;
  int           height;
  int           thread;
  int           cache;
  FLA_Bool      hit;
      
  // Function pointer
  void*         func;

  // Control tree pointer
  void*         cntl;

  // Name of task
  char*         name;

  // GPU enabled task
  FLA_Bool      enabled_gpu;

  // Integer arguments
  int           n_int_args;
  int*          int_arg;

  // Constant FLA_Obj arguments
  int           n_fla_args;
  FLA_Obj*      fla_arg;

  // Input FLA_Obj arguments
  int           n_input_args;
  FLA_Obj*      input_arg;

  // Output FLA_Obj argument
  int           n_output_args;
  FLA_Obj*      output_arg;

  // Number of blocks within all macroblocks
  int           n_macro_args;

  // Number of write after read dependencies
  int           n_war_args;

  // Dependence information
  int           n_dep_args;
  FLASH_Dep*    dep_arg_head;
  FLASH_Dep*    dep_arg_tail;
  
  // Support for a doubly linked list of tasks
  FLASH_Task*   prev_task;
  FLASH_Task*   next_task;

  // Support for a doubly linked list for wait queue
  FLASH_Task*   prev_wait;
  FLASH_Task*   next_wait;
};

struct FLASH_Dep_s
{
  // Task yielding dependency
  FLASH_Task*   task;

  // Support for linked list of FLASH_Deps
  FLASH_Dep*    next_dep;
};
#endif // FLA_ENABLE_SUPERMATRIX

struct FLASH_Thread_s
{
  // The thread's unique identifier
  int       id;

  // Pointer to variables needed to execute SuperMatrix mechanism
  void*     args;

#if FLA_MULTITHREADING_MODEL == FLA_PTHREADS
  // The thread object. Only needed for the POSIX threads implementation.
  pthread_t pthread_obj;
#endif
};

#endif // FLA_TYPE_DEFS_H
// end FLA_type_defs.h

// --- Pointer-accessing FLAME macro definitions ------------------------------------

#define FLA_CONSTANT_I_OFFSET  0
#define FLA_CONSTANT_S_OFFSET  ( sizeof(double) )
#define FLA_CONSTANT_D_OFFSET  ( sizeof(double) + sizeof(double) )
#define FLA_CONSTANT_C_OFFSET  ( sizeof(double) + sizeof(double) + sizeof(double) )
#define FLA_CONSTANT_Z_OFFSET  ( sizeof(double) + sizeof(double) + sizeof(double) + sizeof( scomplex ) )
#define FLA_CONSTANT_SIZE      ( sizeof(double) + sizeof(double) + sizeof(double) + sizeof( scomplex ) + sizeof( dcomplex ) )

#define FLA_INT_PTR( x ) \
  ( ((x).base)->datatype == FLA_CONSTANT ? \
    ( ( integer * )      ( ( ( char * )     ((x).base)->buffer ) + FLA_CONSTANT_I_OFFSET             ) ) : \
                     ( ( ( integer * )      ((x).base)->buffer ) + ( size_t ) (x).offn * ((x).base)->cs + \
                                                               ( size_t ) (x).offm * ((x).base)->rs ) )

#define FLA_FLOAT_PTR( x ) \
  ( ((x).base)->datatype == FLA_CONSTANT ? \
    ( ( float * )    ( ( ( char * )     ((x).base)->buffer ) + FLA_CONSTANT_S_OFFSET             ) ) : \
                     ( ( ( float * )    ((x).base)->buffer ) + ( size_t ) (x).offn * ((x).base)->cs + \
                                                               ( size_t ) (x).offm * ((x).base)->rs ) )

#define FLA_DOUBLE_PTR( x ) \
  ( ((x).base)->datatype == FLA_CONSTANT ? \
    ( ( double * )   ( ( ( char * )     ((x).base)->buffer ) + FLA_CONSTANT_D_OFFSET             ) ) : \
                     ( ( ( double * )   ((x).base)->buffer ) + ( size_t ) (x).offn * ((x).base)->cs + \
                                                               ( size_t ) (x).offm * ((x).base)->rs ) )

#define FLA_COMPLEX_PTR( x ) \
  ( ((x).base)->datatype == FLA_CONSTANT ? \
    ( ( scomplex * ) ( ( ( char * )     ((x).base)->buffer ) + FLA_CONSTANT_C_OFFSET             ) ) : \
                     ( ( ( scomplex * ) ((x).base)->buffer ) + ( size_t ) (x).offn * ((x).base)->cs + \
                                                               ( size_t ) (x).offm * ((x).base)->rs ) )

#define FLA_DOUBLE_COMPLEX_PTR( x ) \
  ( ((x).base)->datatype == FLA_CONSTANT ? \
    ( ( dcomplex * ) ( ( ( char * )     ((x).base)->buffer ) + FLA_CONSTANT_Z_OFFSET             ) ) : \
                     ( ( ( dcomplex * ) ((x).base)->buffer ) + ( size_t ) (x).offn * ((x).base)->cs + \
                                                               ( size_t ) (x).offm * ((x).base)->rs ) )

// end FLA_macro_ptr_defs.h

  // Include "extern" definitions for global FLAME scalar constants.
// begin FLA_extern_defs.h


#ifndef FLA_EXTERN_DEFS_H
#define FLA_EXTERN_DEFS_H

extern LIBFLAME_IMPORT TLS_CLASS_SPEC FLA_Obj FLA_THREE;
extern LIBFLAME_IMPORT TLS_CLASS_SPEC FLA_Obj FLA_TWO;
extern LIBFLAME_IMPORT TLS_CLASS_SPEC FLA_Obj FLA_ONE;
extern LIBFLAME_IMPORT TLS_CLASS_SPEC FLA_Obj FLA_ONE_HALF;
extern LIBFLAME_IMPORT TLS_CLASS_SPEC FLA_Obj FLA_ZERO;
extern LIBFLAME_IMPORT TLS_CLASS_SPEC FLA_Obj FLA_MINUS_ONE_HALF;
extern LIBFLAME_IMPORT TLS_CLASS_SPEC FLA_Obj FLA_MINUS_ONE;
extern LIBFLAME_IMPORT TLS_CLASS_SPEC FLA_Obj FLA_MINUS_TWO;
extern LIBFLAME_IMPORT TLS_CLASS_SPEC FLA_Obj FLA_MINUS_THREE;

extern LIBFLAME_IMPORT TLS_CLASS_SPEC FLA_Obj FLA_EPSILON;
extern LIBFLAME_IMPORT TLS_CLASS_SPEC FLA_Obj FLA_SAFE_MIN;
extern LIBFLAME_IMPORT TLS_CLASS_SPEC FLA_Obj FLA_SAFE_MIN_SQUARE;
extern LIBFLAME_IMPORT TLS_CLASS_SPEC FLA_Obj FLA_SAFE_INV_MIN;
extern LIBFLAME_IMPORT TLS_CLASS_SPEC FLA_Obj FLA_SAFE_INV_MIN_SQUARE;
extern LIBFLAME_IMPORT TLS_CLASS_SPEC FLA_Obj FLA_UNDERFLOW_THRES;
extern LIBFLAME_IMPORT TLS_CLASS_SPEC FLA_Obj FLA_OVERFLOW_THRES;
extern LIBFLAME_IMPORT TLS_CLASS_SPEC FLA_Obj FLA_UNDERFLOW_SQUARE_THRES;
extern LIBFLAME_IMPORT TLS_CLASS_SPEC FLA_Obj FLA_OVERFLOW_SQUARE_THRES;

extern LIBFLAME_IMPORT TLS_CLASS_SPEC const float    fzero;
extern LIBFLAME_IMPORT TLS_CLASS_SPEC const double   dzero;
extern LIBFLAME_IMPORT TLS_CLASS_SPEC const scomplex czero;
extern LIBFLAME_IMPORT TLS_CLASS_SPEC const dcomplex zzero;

#endif

// end FLA_extern_defs.h

  // Include control tree structure definitions, utility prototypes, and
  // initialization prototypes.
// begin FLA_Cntl.h


// Shared definitions

typedef struct FLA_Blocksize_s
{
	fla_dim_t s;
	fla_dim_t d;
	fla_dim_t c;
	fla_dim_t z;
} fla_blocksize_t;

#define FLA_SUBPROBLEM                  0
#define FLA_UNBLOCKED_EXTERN           10
#define FLA_BLOCKED_EXTERN             13

#define FLA_UNB_VAR_OFFSET             40
#define FLA_OPT_VAR_OFFSET             80
#define FLA_BLK_VAR_OFFSET            120
#define FLA_BLF_VAR_OFFSET            160

#define FLA_UNBLOCKED_VARIANT1        (FLA_UNB_VAR_OFFSET+1)
#define FLA_UNBLOCKED_VARIANT2        (FLA_UNB_VAR_OFFSET+2)
#define FLA_UNBLOCKED_VARIANT3        (FLA_UNB_VAR_OFFSET+3)
#define FLA_UNBLOCKED_VARIANT4        (FLA_UNB_VAR_OFFSET+4)
#define FLA_UNBLOCKED_VARIANT5        (FLA_UNB_VAR_OFFSET+5)
#define FLA_UNBLOCKED_VARIANT6        (FLA_UNB_VAR_OFFSET+6)
#define FLA_UNBLOCKED_VARIANT7        (FLA_UNB_VAR_OFFSET+7)
#define FLA_UNBLOCKED_VARIANT8        (FLA_UNB_VAR_OFFSET+8)
#define FLA_UNBLOCKED_VARIANT9        (FLA_UNB_VAR_OFFSET+9)
#define FLA_UNBLOCKED_VARIANT10       (FLA_UNB_VAR_OFFSET+10)

#define FLA_UNB_OPT_VARIANT1          (FLA_OPT_VAR_OFFSET+1)
#define FLA_UNB_OPT_VARIANT2          (FLA_OPT_VAR_OFFSET+2)
#define FLA_UNB_OPT_VARIANT3          (FLA_OPT_VAR_OFFSET+3)
#define FLA_UNB_OPT_VARIANT4          (FLA_OPT_VAR_OFFSET+4)
#define FLA_UNB_OPT_VARIANT5          (FLA_OPT_VAR_OFFSET+5)
#define FLA_UNB_OPT_VARIANT6          (FLA_OPT_VAR_OFFSET+6)
#define FLA_UNB_OPT_VARIANT7          (FLA_OPT_VAR_OFFSET+7)
#define FLA_UNB_OPT_VARIANT8          (FLA_OPT_VAR_OFFSET+8)
#define FLA_UNB_OPT_VARIANT9          (FLA_OPT_VAR_OFFSET+9)
#define FLA_UNB_OPT_VARIANT10         (FLA_OPT_VAR_OFFSET+10)

#define FLA_BLOCKED_VARIANT1          (FLA_BLK_VAR_OFFSET+1)
#define FLA_BLOCKED_VARIANT2          (FLA_BLK_VAR_OFFSET+2)
#define FLA_BLOCKED_VARIANT3          (FLA_BLK_VAR_OFFSET+3)
#define FLA_BLOCKED_VARIANT4          (FLA_BLK_VAR_OFFSET+4)
#define FLA_BLOCKED_VARIANT5          (FLA_BLK_VAR_OFFSET+5)
#define FLA_BLOCKED_VARIANT6          (FLA_BLK_VAR_OFFSET+6)
#define FLA_BLOCKED_VARIANT7          (FLA_BLK_VAR_OFFSET+7)
#define FLA_BLOCKED_VARIANT8          (FLA_BLK_VAR_OFFSET+8)
#define FLA_BLOCKED_VARIANT9          (FLA_BLK_VAR_OFFSET+9)
#define FLA_BLOCKED_VARIANT10         (FLA_BLK_VAR_OFFSET+10)
#define FLA_BLOCKED_VARIANT11         (FLA_BLK_VAR_OFFSET+11)
#define FLA_BLOCKED_VARIANT12         (FLA_BLK_VAR_OFFSET+12)
#define FLA_BLOCKED_VARIANT13         (FLA_BLK_VAR_OFFSET+13)
#define FLA_BLOCKED_VARIANT14         (FLA_BLK_VAR_OFFSET+14)
#define FLA_BLOCKED_VARIANT15         (FLA_BLK_VAR_OFFSET+15)
#define FLA_BLOCKED_VARIANT16         (FLA_BLK_VAR_OFFSET+16)
#define FLA_BLOCKED_VARIANT17         (FLA_BLK_VAR_OFFSET+17)
#define FLA_BLOCKED_VARIANT18         (FLA_BLK_VAR_OFFSET+18)
#define FLA_BLOCKED_VARIANT19         (FLA_BLK_VAR_OFFSET+19)
#define FLA_BLOCKED_VARIANT20         (FLA_BLK_VAR_OFFSET+20)

#define FLA_BLK_FUS_VARIANT1          (FLA_BLF_VAR_OFFSET+1)
#define FLA_BLK_FUS_VARIANT2          (FLA_BLF_VAR_OFFSET+2)
#define FLA_BLK_FUS_VARIANT3          (FLA_BLF_VAR_OFFSET+3)
#define FLA_BLK_FUS_VARIANT4          (FLA_BLF_VAR_OFFSET+4)
#define FLA_BLK_FUS_VARIANT5          (FLA_BLF_VAR_OFFSET+5)
#define FLA_BLK_FUS_VARIANT6          (FLA_BLF_VAR_OFFSET+6)
#define FLA_BLK_FUS_VARIANT7          (FLA_BLF_VAR_OFFSET+7)
#define FLA_BLK_FUS_VARIANT8          (FLA_BLF_VAR_OFFSET+8)
#define FLA_BLK_FUS_VARIANT9          (FLA_BLF_VAR_OFFSET+9)
#define FLA_BLK_FUS_VARIANT10         (FLA_BLF_VAR_OFFSET+10)

#define FLA_Cntl_matrix_type( cntl )  cntl->matrix_type
#define FLA_Cntl_blocksize( cntl )    cntl->blocksize
#define FLA_Cntl_variant( cntl )      cntl->variant

void FLA_Cntl_obj_free( void* cntl );


// Include the control tree definitions for each class of operation.
// begin FLA_Cntl_blas1.h



//
// Level-1 BLAS
//

struct fla_axpy_s
{
	FLA_Matrix_type    matrix_type;
	int                variant;
	fla_blocksize_t*   blocksize;
	struct fla_axpy_s* sub_axpy;
};
typedef struct fla_axpy_s fla_axpy_t;


struct fla_axpyt_s
{
	FLA_Matrix_type     matrix_type;
	int                 variant;
	fla_blocksize_t*    blocksize;
	struct fla_axpyt_s* sub_axpyt;
};
typedef struct fla_axpyt_s fla_axpyt_t;


struct fla_copy_s
{
	FLA_Matrix_type    matrix_type;
	int                variant;
	fla_blocksize_t*   blocksize;
	struct fla_copy_s* sub_copy;
};
typedef struct fla_copy_s fla_copy_t;


struct fla_copyt_s
{
	FLA_Matrix_type     matrix_type;
	int                 variant;
	fla_blocksize_t*    blocksize;
	struct fla_copyt_s* sub_copyt;
};
typedef struct fla_copyt_s fla_copyt_t;


struct fla_copyr_s
{
	FLA_Matrix_type     matrix_type;
	int                 variant;
	fla_blocksize_t*    blocksize;
	struct fla_copyr_s* sub_copyr;
	struct fla_copy_s*  sub_copy;
};
typedef struct fla_copyr_s fla_copyr_t;


struct fla_scal_s
{
	FLA_Matrix_type    matrix_type;
	int                variant;
	fla_blocksize_t*   blocksize;
	struct fla_scal_s* sub_scal;
};
typedef struct fla_scal_s fla_scal_t;


struct fla_scalr_s
{
	FLA_Matrix_type     matrix_type;
	int                 variant;
	fla_blocksize_t*    blocksize;
	struct fla_scalr_s* sub_scalr;
	struct fla_scal_s*  sub_scal;
};
typedef struct fla_scalr_s fla_scalr_t;


struct fla_swap_s
{
	FLA_Matrix_type    matrix_type;
	int                variant;
	fla_blocksize_t*   blocksize;
	struct fla_swap_s* sub_swap;
};
typedef struct fla_swap_s fla_swap_t;


struct fla_tpose_s
{
	FLA_Matrix_type     matrix_type;
	int                 variant;
	fla_blocksize_t*    blocksize;
	struct fla_tpose_s* sub_trans;
	struct fla_swap_s*  sub_swap;
};
typedef struct fla_tpose_s fla_tpose_t;


#define FLA_Cntl_sub_axpy( cntl )     cntl->sub_axpy
#define FLA_Cntl_sub_axpy1( cntl )    cntl->sub_axpy1
#define FLA_Cntl_sub_axpy2( cntl )    cntl->sub_axpy2
#define FLA_Cntl_sub_axpy3( cntl )    cntl->sub_axpy3
#define FLA_Cntl_sub_axpyt( cntl )    cntl->sub_axpyt
#define FLA_Cntl_sub_copy( cntl )     cntl->sub_copy
#define FLA_Cntl_sub_copyt( cntl )    cntl->sub_copyt
#define FLA_Cntl_sub_copyr( cntl )    cntl->sub_copyr
#define FLA_Cntl_sub_scal( cntl )     cntl->sub_scal
#define FLA_Cntl_sub_scalr( cntl )    cntl->sub_scalr
#define FLA_Cntl_sub_swap( cntl )     cntl->sub_swap
#define FLA_Cntl_sub_trans( cntl )    cntl->sub_trans


fla_axpy_t* FLA_Cntl_axpy_obj_create( FLA_Matrix_type  matrix_type,
                                      int              variant,
                                      fla_blocksize_t* blocksize,
                                      fla_axpy_t*      sub_axpy );
fla_axpyt_t* FLA_Cntl_axpyt_obj_create( FLA_Matrix_type  matrix_type,
                                        int              variant,
                                        fla_blocksize_t* blocksize,
                                        fla_axpyt_t*     sub_axpyt );
fla_copy_t* FLA_Cntl_copy_obj_create( FLA_Matrix_type  matrix_type,
                                      int              variant,
                                      fla_blocksize_t* blocksize,
                                      fla_copy_t*      sub_copy );
fla_copyt_t* FLA_Cntl_copyt_obj_create( FLA_Matrix_type  matrix_type,
                                        int              variant,
                                        fla_blocksize_t* blocksize,
                                        fla_copyt_t*     sub_copyt );
fla_copyr_t* FLA_Cntl_copyr_obj_create( FLA_Matrix_type  matrix_type,
                                        int              variant,
                                        fla_blocksize_t* blocksize,
                                        fla_copyr_t*     sub_copyr,
                                        fla_copy_t*      sub_copy );
fla_scal_t* FLA_Cntl_scal_obj_create( FLA_Matrix_type  matrix_type,
                                      int              variant,
                                      fla_blocksize_t* blocksize,
                                      fla_scal_t*      sub_scal );
fla_scalr_t* FLA_Cntl_scalr_obj_create( FLA_Matrix_type  matrix_type,
                                        int              variant,
                                        fla_blocksize_t* blocksize,
                                        fla_scalr_t*     sub_scalr,
                                        fla_scal_t*      sub_scal );
fla_swap_t* FLA_Cntl_swap_obj_create( FLA_Matrix_type  matrix_type,
                                      int              variant,
                                      fla_blocksize_t* blocksize,
                                      fla_swap_t*      sub_swap );
fla_tpose_t* FLA_Cntl_tpose_obj_create( FLA_Matrix_type  matrix_type,
                                        int              variant,
                                        fla_blocksize_t* blocksize,
                                        fla_tpose_t*     sub_trans,
                                        fla_swap_t*      sub_swap );

// end FLA_Cntl_blas1.h
// begin FLA_Cntl_blas2.h



//
// Level-2 BLAS
//

struct fla_gemv_s
{
	FLA_Matrix_type    matrix_type;
	int                variant;
	fla_blocksize_t*   blocksize;
	struct fla_scal_s* sub_scal;
	struct fla_gemv_s* sub_gemv;
};
typedef struct fla_gemv_s fla_gemv_t;

struct fla_trsv_s
{
	FLA_Matrix_type    matrix_type;
	int                variant;
	fla_blocksize_t*   blocksize;
	struct fla_trsv_s* sub_trsv;
	struct fla_gemv_s* sub_gemv;
};
typedef struct fla_trsv_s fla_trsv_t;


#define FLA_Cntl_sub_gemv( cntl )     cntl->sub_gemv
#define FLA_Cntl_sub_trsv( cntl )     cntl->sub_trsv


fla_gemv_t* FLA_Cntl_gemv_obj_create( FLA_Matrix_type  matrix_type,
                                      int              variant,
                                      fla_blocksize_t* blocksize,
                                      fla_scal_t*      sub_scal,
                                      fla_gemv_t*      sub_gemv );
fla_trsv_t* FLA_Cntl_trsv_obj_create( FLA_Matrix_type  matrix_type,
                                      int              variant,
                                      fla_blocksize_t* blocksize,
                                      fla_trsv_t*      sub_trsv,
                                      fla_gemv_t*      sub_gemv );

// end FLA_Cntl_blas2.h
// begin FLA_Cntl_blas3.h



//
// Level-3 BLAS
//

struct fla_gemm_s
{
	FLA_Matrix_type    matrix_type;
	int                variant;
	fla_blocksize_t*   blocksize;
	struct fla_scal_s* sub_scal;
	struct fla_gemm_s* sub_gemm;
};
typedef struct fla_gemm_s fla_gemm_t;


struct fla_hemm_s
{
	FLA_Matrix_type    matrix_type;
	int                variant;
	fla_blocksize_t*   blocksize;
	struct fla_scal_s* sub_scal;
	struct fla_hemm_s* sub_hemm;
	struct fla_gemm_s* sub_gemm1;
	struct fla_gemm_s* sub_gemm2;
};
typedef struct fla_hemm_s fla_hemm_t;


struct fla_herk_s
{
	FLA_Matrix_type     matrix_type;
	int                 variant;
	fla_blocksize_t*    blocksize;
	struct fla_scalr_s* sub_scalr;
	struct fla_herk_s*  sub_herk;
	struct fla_gemm_s*  sub_gemm;
};
typedef struct fla_herk_s fla_herk_t;


struct fla_her2k_s
{
	FLA_Matrix_type     matrix_type;
	int                 variant;
	fla_blocksize_t*    blocksize;
	struct fla_scalr_s* sub_scalr;
	struct fla_her2k_s* sub_her2k;
	struct fla_gemm_s*  sub_gemm1;
	struct fla_gemm_s*  sub_gemm2;
};
typedef struct fla_her2k_s fla_her2k_t;


struct fla_symm_s
{
	FLA_Matrix_type    matrix_type;
	int                variant;
	fla_blocksize_t*   blocksize;
	struct fla_scal_s* sub_scal;
	struct fla_symm_s* sub_symm;
	struct fla_gemm_s* sub_gemm1;
	struct fla_gemm_s* sub_gemm2;
};
typedef struct fla_symm_s fla_symm_t;


struct fla_syrk_s
{
	FLA_Matrix_type     matrix_type;
	int                 variant;
	fla_blocksize_t*    blocksize;
	struct fla_scalr_s* sub_scalr;
	struct fla_syrk_s*  sub_syrk;
	struct fla_gemm_s*  sub_gemm;
};
typedef struct fla_syrk_s fla_syrk_t;


struct fla_syr2k_s
{
	FLA_Matrix_type     matrix_type;
	int                 variant;
	fla_blocksize_t*    blocksize;
	struct fla_scalr_s* sub_scalr;
	struct fla_syr2k_s* sub_syr2k;
	struct fla_gemm_s*  sub_gemm1;
	struct fla_gemm_s*  sub_gemm2;
};
typedef struct fla_syr2k_s fla_syr2k_t;


struct fla_trmm_s
{
	FLA_Matrix_type    matrix_type;
	int                variant;
	fla_blocksize_t*   blocksize;
	struct fla_scal_s* sub_scal;
	struct fla_trmm_s* sub_trmm;
	struct fla_gemm_s* sub_gemm;
};
typedef struct fla_trmm_s fla_trmm_t;


struct fla_trsm_s
{
	FLA_Matrix_type    matrix_type;
	int                variant;
	fla_blocksize_t*   blocksize;
	struct fla_scal_s* sub_scal;
	struct fla_trsm_s* sub_trsm;
	struct fla_gemm_s* sub_gemm;
};
typedef struct fla_trsm_s fla_trsm_t;


#define FLA_Cntl_sub_gemm( cntl )     cntl->sub_gemm
#define FLA_Cntl_sub_gemm1( cntl )    cntl->sub_gemm1
#define FLA_Cntl_sub_gemm2( cntl )    cntl->sub_gemm2
#define FLA_Cntl_sub_gemm3( cntl )    cntl->sub_gemm3
#define FLA_Cntl_sub_gemm4( cntl )    cntl->sub_gemm4
#define FLA_Cntl_sub_gemm5( cntl )    cntl->sub_gemm5
#define FLA_Cntl_sub_gemm6( cntl )    cntl->sub_gemm6
#define FLA_Cntl_sub_gemm7( cntl )    cntl->sub_gemm7
#define FLA_Cntl_sub_gemm8( cntl )    cntl->sub_gemm8
#define FLA_Cntl_sub_hemm( cntl )     cntl->sub_hemm
#define FLA_Cntl_sub_hemm1( cntl )    cntl->sub_hemm1
#define FLA_Cntl_sub_hemm2( cntl )    cntl->sub_hemm2
#define FLA_Cntl_sub_herk( cntl )     cntl->sub_herk
#define FLA_Cntl_sub_herk1( cntl )    cntl->sub_herk1
#define FLA_Cntl_sub_herk2( cntl )    cntl->sub_herk2
#define FLA_Cntl_sub_her2k( cntl )    cntl->sub_her2k
#define FLA_Cntl_sub_symm( cntl )     cntl->sub_symm
#define FLA_Cntl_sub_syrk( cntl )     cntl->sub_syrk
#define FLA_Cntl_sub_syr2k( cntl )    cntl->sub_syr2k
#define FLA_Cntl_sub_trmm( cntl )     cntl->sub_trmm
#define FLA_Cntl_sub_trmm1( cntl )    cntl->sub_trmm1
#define FLA_Cntl_sub_trmm2( cntl )    cntl->sub_trmm2
#define FLA_Cntl_sub_trsm( cntl )     cntl->sub_trsm
#define FLA_Cntl_sub_trsm1( cntl )    cntl->sub_trsm1
#define FLA_Cntl_sub_trsm2( cntl )    cntl->sub_trsm2
#define FLA_Cntl_sub_trsm3( cntl )    cntl->sub_trsm3
#define FLA_Cntl_sub_trsm4( cntl )    cntl->sub_trsm4


fla_gemm_t* FLA_Cntl_gemm_obj_create( FLA_Matrix_type  matrix_type,
                                      int              variant,
                                      fla_blocksize_t* blocksize,
                                      fla_scal_t*      sub_scal,
                                      fla_gemm_t*      sub_gemm );
fla_hemm_t* FLA_Cntl_hemm_obj_create( FLA_Matrix_type  matrix_type,
                                      int              variant,
                                      fla_blocksize_t* blocksize,
                                      fla_scal_t*      sub_scal,
                                      fla_hemm_t*      sub_hemm,
                                      fla_gemm_t*      sub_gemm1,
                                      fla_gemm_t*      sub_gemm2 );
fla_herk_t* FLA_Cntl_herk_obj_create( FLA_Matrix_type  matrix_type,
                                      int              variant,
                                      fla_blocksize_t* blocksize,
                                      fla_scalr_t*     sub_scalr,
                                      fla_herk_t*      sub_herk,
                                      fla_gemm_t*      sub_gemm );
fla_her2k_t* FLA_Cntl_her2k_obj_create( FLA_Matrix_type  matrix_type,
                                        int              variant,
                                        fla_blocksize_t* blocksize,
                                        fla_scalr_t*     sub_scalr,
                                        fla_her2k_t*     sub_her2k,
                                        fla_gemm_t*      sub_gemm1,
                                        fla_gemm_t*      sub_gemm2 );
fla_symm_t* FLA_Cntl_symm_obj_create( FLA_Matrix_type  matrix_type,
                                      int              variant,
                                      fla_blocksize_t* blocksize,
                                      fla_scal_t*      sub_scal,
                                      fla_symm_t*      sub_symm,
                                      fla_gemm_t*      sub_gemm1,
                                      fla_gemm_t*      sub_gemm2 );
fla_syrk_t* FLA_Cntl_syrk_obj_create( FLA_Matrix_type  matrix_type,
                                      int              variant,
                                      fla_blocksize_t* blocksize,
                                      fla_scalr_t*     sub_scalr,
                                      fla_syrk_t*      sub_syrk,
                                      fla_gemm_t*      sub_gemm );
fla_syr2k_t* FLA_Cntl_syr2k_obj_create( FLA_Matrix_type  matrix_type,
                                        int              variant,
                                        fla_blocksize_t* blocksize,
                                        fla_scalr_t*     sub_scalr,
                                        fla_syr2k_t*     sub_syr2k,
                                        fla_gemm_t*      sub_gemm1,
                                        fla_gemm_t*      sub_gemm2 );
fla_trmm_t* FLA_Cntl_trmm_obj_create( FLA_Matrix_type  matrix_type,
                                      int              variant,
                                      fla_blocksize_t* blocksize,
                                      fla_scal_t*      sub_scal,
                                      fla_trmm_t*      sub_trmm,
                                      fla_gemm_t*      sub_gemm );
fla_trsm_t* FLA_Cntl_trsm_obj_create( FLA_Matrix_type  matrix_type,
                                      int              variant,
                                      fla_blocksize_t* blocksize,
                                      fla_scal_t*      sub_scal,
                                      fla_trsm_t*      sub_trsm,
                                      fla_gemm_t*      sub_gemm );

// end FLA_Cntl_blas3.h
// begin FLA_Cntl_lapack.h



//
// LAPACK-level
//

struct fla_chol_s
{
	FLA_Matrix_type    matrix_type;
	int                variant;
	fla_blocksize_t*   blocksize;
	struct fla_chol_s* sub_chol;
	struct fla_herk_s* sub_herk;
	struct fla_trsm_s* sub_trsm;
	struct fla_gemm_s* sub_gemm;
};
typedef struct fla_chol_s fla_chol_t;


struct fla_ttmm_s
{
	FLA_Matrix_type    matrix_type;
	int                variant;
	fla_blocksize_t*   blocksize;
	struct fla_ttmm_s* sub_ttmm;
	struct fla_herk_s* sub_herk;
	struct fla_trmm_s* sub_trmm;
	struct fla_gemm_s* sub_gemm;
};
typedef struct fla_ttmm_s fla_ttmm_t;


struct fla_appiv_s
{
	FLA_Matrix_type     matrix_type;
	int                 variant;
	fla_blocksize_t*    blocksize;
	struct fla_appiv_s* sub_appiv;
};
typedef struct fla_appiv_s fla_appiv_t;


struct fla_lu_s
{
	FLA_Matrix_type     matrix_type;
	int                 variant;
	fla_blocksize_t*    blocksize;
	struct fla_lu_s*    sub_lu;
	struct fla_gemm_s*  sub_gemm1;
	struct fla_gemm_s*  sub_gemm2;
	struct fla_gemm_s*  sub_gemm3;
	struct fla_trsm_s*  sub_trsm1;
	struct fla_trsm_s*  sub_trsm2;
	struct fla_appiv_s* sub_appiv1;
	struct fla_appiv_s* sub_appiv2;
};
typedef struct fla_lu_s fla_lu_t;


struct fla_qr_ut_s
{
	FLA_Matrix_type     matrix_type;
	int                 variant;
	fla_blocksize_t*    blocksize;
	struct fla_qr_ut_s* sub_qrut;
	struct fla_apqut_s* sub_apqut;
};
typedef struct fla_qr_ut_s fla_qrut_t;


struct fla_qr2_ut_s
{
	FLA_Matrix_type        matrix_type;
	int                    variant;
	fla_blocksize_t*       blocksize;
	struct fla_qr2_ut_s*   sub_qr2ut;
	struct fla_gemm_s*     sub_gemm1;
	struct fla_gemm_s*     sub_gemm2;
	struct fla_trsm_s*     sub_trsm;
	struct fla_copy_s*     sub_copy;
	struct fla_axpy_s*     sub_axpy;
};
typedef struct fla_qr2_ut_s fla_qr2ut_t;


struct fla_lq_ut_s
{
	FLA_Matrix_type     matrix_type;
	int                 variant;
	fla_blocksize_t*    blocksize;
	struct fla_lq_ut_s* sub_lqut;
	struct fla_apqut_s* sub_apqut;
};
typedef struct fla_lq_ut_s fla_lqut_t;

struct fla_caqr2ut_s
{
	FLA_Matrix_type        matrix_type;
	int                    variant;
	fla_blocksize_t*       blocksize;
	struct fla_caqr2ut_s*  sub_caqr2ut;
	struct fla_gemm_s*     sub_gemm1;
	struct fla_gemm_s*     sub_gemm2;
	struct fla_trmm_s*     sub_trmm1;
	struct fla_trmm_s*     sub_trmm2;
	struct fla_trsm_s*     sub_trsm;
	struct fla_axpy_s*     sub_axpy1;
	struct fla_axpy_s*     sub_axpy2;
	struct fla_axpy_s*     sub_axpy3;
	struct fla_copy_s*     sub_copy;
};
typedef struct fla_caqr2ut_s fla_caqr2ut_t;


struct fla_hess_ut_s
{
	FLA_Matrix_type       matrix_type;
	int                   variant;
	fla_blocksize_t*      blocksize;
};
typedef struct fla_hess_ut_s fla_hessut_t;

struct fla_tridiag_ut_s
{
	FLA_Matrix_type       matrix_type;
	int                   variant;
	fla_blocksize_t*      blocksize;
};
typedef struct fla_tridiag_ut_s fla_tridiagut_t;

struct fla_bidiag_ut_s
{
	FLA_Matrix_type       matrix_type;
	int                   variant;
	fla_blocksize_t*      blocksize;
};
typedef struct fla_bidiag_ut_s fla_bidiagut_t;

struct fla_trinv_s
{
	FLA_Matrix_type     matrix_type;
	int                 variant;
	fla_blocksize_t*    blocksize;
	struct fla_trinv_s* sub_trinv;
	struct fla_gemm_s*  sub_gemm;
	struct fla_trmm_s*  sub_trmm;
	struct fla_trsm_s*  sub_trsm1;
	struct fla_trsm_s*  sub_trsm2;
};
typedef struct fla_trinv_s fla_trinv_t;


struct fla_sylv_s
{
	FLA_Matrix_type     matrix_type;
	int                 variant;
	fla_blocksize_t*    blocksize;
	struct fla_sylv_s*  sub_sylv1;
	struct fla_sylv_s*  sub_sylv2;
	struct fla_sylv_s*  sub_sylv3;
	struct fla_gemm_s*  sub_gemm1;
	struct fla_gemm_s*  sub_gemm2;
	struct fla_gemm_s*  sub_gemm3;
	struct fla_gemm_s*  sub_gemm4;
	struct fla_gemm_s*  sub_gemm5;
	struct fla_gemm_s*  sub_gemm6;
	struct fla_gemm_s*  sub_gemm7;
	struct fla_gemm_s*  sub_gemm8;
};
typedef struct fla_sylv_s fla_sylv_t;


struct fla_lyap_s
{
	FLA_Matrix_type     matrix_type;
	int                 variant;
	fla_blocksize_t*    blocksize;
	struct fla_scal_s*  sub_scal;
	struct fla_lyap_s*  sub_lyap;
	struct fla_sylv_s*  sub_sylv;
	struct fla_gemm_s*  sub_gemm1;
	struct fla_gemm_s*  sub_gemm2;
	struct fla_hemm_s*  sub_hemm;
	struct fla_her2k_s* sub_her2k;
};
typedef struct fla_lyap_s fla_lyap_t;


struct fla_spdinv_s
{
	FLA_Matrix_type     matrix_type;
	int                 variant;
	fla_blocksize_t*    blocksize;
	struct fla_chol_s*  sub_chol;
	struct fla_trinv_s* sub_trinv;
	struct fla_ttmm_s*  sub_ttmm;
};
typedef struct fla_spdinv_s fla_spdinv_t;


struct fla_apqut_s
{
	FLA_Matrix_type      matrix_type;
	int                  variant;
	fla_blocksize_t*     blocksize;
	struct fla_apqut_s*  sub_apqut;
	struct fla_trmm_s*   sub_trmm1;
	struct fla_trmm_s*   sub_trmm2;
	struct fla_gemm_s*   sub_gemm1;
	struct fla_gemm_s*   sub_gemm2;
	struct fla_trsm_s*   sub_trsm;
	struct fla_copyt_s*  sub_copyt;
	struct fla_axpyt_s*  sub_axpyt;
};
typedef struct fla_apqut_s fla_apqut_t;


struct fla_apq2ut_s
{
	FLA_Matrix_type       matrix_type;
	int                   variant;
	fla_blocksize_t*      blocksize;
	struct fla_apq2ut_s*  sub_apq2ut;
	struct fla_gemm_s*    sub_gemm1;
	struct fla_gemm_s*    sub_gemm2;
	struct fla_trsm_s*    sub_trsm;
	struct fla_copyt_s*   sub_copyt;
	struct fla_axpyt_s*   sub_axpyt;
};
typedef struct fla_apq2ut_s fla_apq2ut_t;


struct fla_caqrutinc_s
{
	FLA_Matrix_type        matrix_type;
	int                    variant;
	fla_blocksize_t*       blocksize;
	struct fla_caqr2ut_s*  sub_caqr2ut;
	struct fla_apcaq2ut_s* sub_apcaq2ut;
};
typedef struct fla_caqrutinc_s fla_caqrutinc_t;


struct fla_apcaqutinc_s
{
	FLA_Matrix_type        matrix_type;
	int                    variant;
	fla_blocksize_t*       blocksize;
	struct fla_apcaq2ut_s* sub_apcaq2ut;
};
typedef struct fla_apcaqutinc_s fla_apcaqutinc_t;


struct fla_apcaq2ut_s
{
	FLA_Matrix_type        matrix_type;
	int                    variant;
	fla_blocksize_t*       blocksize;
	struct fla_apcaq2ut_s* sub_apcaq2ut;
	struct fla_gemm_s*     sub_gemm1;
	struct fla_gemm_s*     sub_gemm2;
	struct fla_trmm_s*     sub_trmm1;
	struct fla_trmm_s*     sub_trmm2;
	struct fla_trsm_s*     sub_trsm;
	struct fla_axpy_s*     sub_axpy1;
	struct fla_axpy_s*     sub_axpy2;
	struct fla_axpy_s*     sub_axpy3;
	struct fla_copy_s*     sub_copy;
};
typedef struct fla_apcaq2ut_s fla_apcaq2ut_t;


struct fla_qr_ut_inc_s
{
	FLA_Matrix_type        matrix_type;
	int                    variant;
	fla_blocksize_t*       blocksize;
	struct fla_qr_ut_s*    sub_qrut;
	struct fla_qr2_ut_s*   sub_qr2ut;
	struct fla_apqut_s*    sub_apqut;
	struct fla_apq2ut_s*   sub_apq2ut;
};
typedef struct fla_qr_ut_inc_s fla_qrutinc_t;


struct fla_apqutinc_s
{
	FLA_Matrix_type        matrix_type;
	int                    variant;
	fla_blocksize_t*       blocksize;
	struct fla_apqut_s*    sub_apqut;
	struct fla_apq2ut_s*   sub_apq2ut;
};
typedef struct fla_apqutinc_s fla_apqutinc_t;


struct fla_uddateut_s
{
	FLA_Matrix_type        matrix_type;
	int                    variant;
	fla_blocksize_t*       blocksize;
	struct fla_uddateut_s* sub_uddateut;
	struct fla_apqudut_s*  sub_apqudut;
};
typedef struct fla_uddateut_s fla_uddateut_t;


struct fla_apqudut_s
{
	FLA_Matrix_type       matrix_type;
	int                   variant;
	fla_blocksize_t*      blocksize;
	struct fla_apqudut_s* sub_apqudut;
	struct fla_gemm_s*    sub_gemm1;
	struct fla_gemm_s*    sub_gemm2;
	struct fla_gemm_s*    sub_gemm3;
	struct fla_gemm_s*    sub_gemm4;
	struct fla_trsm_s*    sub_trsm;
	struct fla_copyt_s*   sub_copyt;
	struct fla_axpyt_s*   sub_axpyt;
};
typedef struct fla_apqudut_s fla_apqudut_t;


struct fla_uddateutinc_s
{
	FLA_Matrix_type        matrix_type;
	int                    variant;
	fla_blocksize_t*       blocksize;
	struct fla_uddateut_s* sub_uddateut;
	struct fla_apqudut_s*  sub_apqudut;
};
typedef struct fla_uddateutinc_s fla_uddateutinc_t;


struct fla_apqudutinc_s
{
	FLA_Matrix_type        matrix_type;
	int                    variant;
	fla_blocksize_t*       blocksize;
	struct fla_apqudut_s*  sub_apqudut;
};
typedef struct fla_apqudutinc_s fla_apqudutinc_t;


struct fla_eig_gest_s
{
	FLA_Matrix_type        matrix_type;
	int                    variant;
	fla_blocksize_t*       blocksize;
	struct fla_eig_gest_s* sub_eig_gest;
	struct fla_axpy_s*     sub_axpy1;
	struct fla_axpy_s*     sub_axpy2;
	struct fla_gemm_s*     sub_gemm1;
	struct fla_gemm_s*     sub_gemm2;
	struct fla_gemm_s*     sub_gemm3;
	struct fla_hemm_s*     sub_hemm;
	struct fla_her2k_s*    sub_her2k;
	struct fla_trmm_s*     sub_trmm1;
	struct fla_trmm_s*     sub_trmm2;
	struct fla_trsm_s*     sub_trsm1;
	struct fla_trsm_s*     sub_trsm2;
};
typedef struct fla_eig_gest_s fla_eig_gest_t;


#define FLA_Cntl_sub_chol( cntl )      cntl->sub_chol
#define FLA_Cntl_sub_lu( cntl )        cntl->sub_lu
#define FLA_Cntl_sub_qr( cntl )        cntl->sub_qr
#define FLA_Cntl_sub_qrut( cntl )      cntl->sub_qrut
#define FLA_Cntl_sub_qr2ut( cntl )     cntl->sub_qr2ut
#define FLA_Cntl_sub_lq( cntl )        cntl->sub_lq
#define FLA_Cntl_sub_lqut( cntl )      cntl->sub_lqut
#define FLA_Cntl_sub_caqr2ut( cntl )   cntl->sub_caqr2ut
#define FLA_Cntl_sub_trinv( cntl )     cntl->sub_trinv
#define FLA_Cntl_sub_ttmm( cntl )      cntl->sub_ttmm
#define FLA_Cntl_sub_sylv( cntl )      cntl->sub_sylv
#define FLA_Cntl_sub_sylv1( cntl )     cntl->sub_sylv1
#define FLA_Cntl_sub_sylv2( cntl )     cntl->sub_sylv2
#define FLA_Cntl_sub_sylv3( cntl )     cntl->sub_sylv3
#define FLA_Cntl_sub_lyap( cntl )      cntl->sub_lyap
#define FLA_Cntl_sub_appiv( cntl )     cntl->sub_appiv
#define FLA_Cntl_sub_appiv1( cntl )    cntl->sub_appiv1
#define FLA_Cntl_sub_appiv2( cntl )    cntl->sub_appiv2
#define FLA_Cntl_sub_apqut( cntl )     cntl->sub_apqut
#define FLA_Cntl_sub_apq2ut( cntl )    cntl->sub_apq2ut
#define FLA_Cntl_sub_apcaq2ut( cntl )  cntl->sub_apcaq2ut
#define FLA_Cntl_sub_uddateut( cntl )  cntl->sub_uddateut
#define FLA_Cntl_sub_apqudut( cntl )   cntl->sub_apqudut
#define FLA_Cntl_sub_hessut( cntl )    cntl->sub_hessut
#define FLA_Cntl_sub_tridiagut( cntl ) cntl->sub_tridiagut
#define FLA_Cntl_sub_bidiagut( cntl )  cntl->sub_bidiagut
#define FLA_Cntl_sub_eig_gest( cntl )  cntl->sub_eig_gest


fla_chol_t* FLA_Cntl_chol_obj_create( FLA_Matrix_type  matrix_type,
                                      int              variant,
                                      fla_blocksize_t* blocksize,
                                      fla_chol_t*      sub_chol,
                                      fla_herk_t*      sub_herk,
                                      fla_trsm_t*      sub_trsm,
                                      fla_gemm_t*      sub_gemm );
fla_lu_t* FLA_Cntl_lu_obj_create( FLA_Matrix_type  matrix_type,
                                  int              variant,
                                  fla_blocksize_t* blocksize,
                                  fla_lu_t*        sub_lu,
                                  fla_gemm_t*      sub_gemm1,
                                  fla_gemm_t*      sub_gemm2,
                                  fla_gemm_t*      sub_gemm3,
                                  fla_trsm_t*      sub_trsm1,
                                  fla_trsm_t*      sub_trsm2,
                                  fla_appiv_t*     sub_appiv1,
                                  fla_appiv_t*     sub_appiv2 );
fla_appiv_t* FLA_Cntl_appiv_obj_create( FLA_Matrix_type  matrix_type,
                                        int              variant,
                                        fla_blocksize_t* blocksize,
                                        fla_appiv_t*     sub_appiv );
fla_qrut_t* FLA_Cntl_qrut_obj_create( FLA_Matrix_type  matrix_type,
                                      int              variant,
                                      fla_blocksize_t* blocksize,
                                      fla_qrut_t*      sub_qrut,
                                      fla_apqut_t*     sub_apqut );
fla_qr2ut_t* FLA_Cntl_qr2ut_obj_create( FLA_Matrix_type  matrix_type,
                                        int              variant,
                                        fla_blocksize_t* blocksize,
                                        fla_qr2ut_t*     sub_qr2ut,
                                        fla_gemm_t*      sub_gemm1,
                                        fla_gemm_t*      sub_gemm2,
                                        fla_trsm_t*      sub_trsm,
                                        fla_copy_t*      sub_copy,
                                        fla_axpy_t*      sub_axpy );
fla_lqut_t* FLA_Cntl_lqut_obj_create( FLA_Matrix_type  matrix_type,
                                      int              variant,
                                      fla_blocksize_t* blocksize,
                                      fla_lqut_t*      sub_lqut,
                                      fla_apqut_t*     sub_apqut );
fla_caqr2ut_t* FLA_Cntl_caqr2ut_obj_create( FLA_Matrix_type  matrix_type,
                                            int              variant,
                                            fla_blocksize_t* blocksize,
                                            fla_caqr2ut_t*   sub_caqr2ut,
                                            fla_gemm_t*      sub_gemm1,
                                            fla_gemm_t*      sub_gemm2,
                                            fla_trmm_t*      sub_trmm1,
                                            fla_trmm_t*      sub_trmm2,
                                            fla_trsm_t*      sub_trsm,
                                            fla_axpy_t*      sub_axpy1,
                                            fla_axpy_t*      sub_axpy2,
                                            fla_axpy_t*      sub_axpy3,
                                            fla_copy_t*      sub_copy );
fla_hessut_t* FLA_Cntl_hessut_obj_create( FLA_Matrix_type  matrix_type,
                                          int              variant,
                                          fla_blocksize_t* blocksize );
fla_tridiagut_t* FLA_Cntl_tridiagut_obj_create( FLA_Matrix_type  matrix_type,
                                                int              variant,
                                                fla_blocksize_t* blocksize );
fla_bidiagut_t* FLA_Cntl_bidiagut_obj_create( FLA_Matrix_type  matrix_type,
                                              int              variant,
                                              fla_blocksize_t* blocksize );
fla_trinv_t* FLA_Cntl_trinv_obj_create( FLA_Matrix_type  matrix_type,
                                        int              variant,
                                        fla_blocksize_t* blocksize,
                                        fla_trinv_t*     sub_trinv,
                                        fla_trmm_t*      sub_trmm,
                                        fla_trsm_t*      sub_trsm1,
                                        fla_trsm_t*      sub_trsm2,
                                        fla_gemm_t*      sub_gemm );
fla_ttmm_t* FLA_Cntl_ttmm_obj_create( FLA_Matrix_type  matrix_type,
                                      int              variant,
                                      fla_blocksize_t* blocksize,
                                      fla_ttmm_t*      sub_ttmm,
                                      fla_herk_t*      sub_herk,
                                      fla_trmm_t*      sub_trmm,
                                      fla_gemm_t*      sub_gemm );
fla_sylv_t* FLA_Cntl_sylv_obj_create( FLA_Matrix_type  matrix_type,
                                      int              variant,
                                      fla_blocksize_t* blocksize,
                                      fla_sylv_t*      sub_sylv1,
                                      fla_sylv_t*      sub_sylv2,
                                      fla_sylv_t*      sub_sylv3,
                                      fla_gemm_t*      sub_gemm1,
                                      fla_gemm_t*      sub_gemm2,
                                      fla_gemm_t*      sub_gemm3,
                                      fla_gemm_t*      sub_gemm4,
                                      fla_gemm_t*      sub_gemm5,
                                      fla_gemm_t*      sub_gemm6,
                                      fla_gemm_t*      sub_gemm7,
                                      fla_gemm_t*      sub_gemm8 );
fla_lyap_t* FLA_Cntl_lyap_obj_create( FLA_Matrix_type  matrix_type,
                                      int              variant,
                                      fla_blocksize_t* blocksize,
                                      fla_scal_t*      sub_scal,
                                      fla_lyap_t*      sub_lyap,
                                      fla_sylv_t*      sub_sylv,
                                      fla_gemm_t*      sub_gemm1,
                                      fla_gemm_t*      sub_gemm2,
                                      fla_hemm_t*      sub_hemm,
                                      fla_her2k_t*     sub_her2k );
fla_spdinv_t* FLA_Cntl_spdinv_obj_create( FLA_Matrix_type  matrix_type,
                                          int              variant,
                                          fla_blocksize_t* blocksize,
                                          fla_chol_t*      sub_chol,
                                          fla_trinv_t*     sub_trinv,
                                          fla_ttmm_t*      sub_ttmm );
fla_apqut_t* FLA_Cntl_apqut_obj_create( FLA_Matrix_type  matrix_type,
                                        int              variant,
                                        fla_blocksize_t* blocksize,
                                        fla_apqut_t*     sub_apqut,
                                        fla_trmm_t*      sub_trmm1,
                                        fla_trmm_t*      sub_trmm2,
                                        fla_gemm_t*      sub_gemm1,
                                        fla_gemm_t*      sub_gemm2,
                                        fla_trsm_t*      sub_trsm,
                                        fla_copyt_t*     sub_copyt,
                                        fla_axpyt_t*     sub_axpyt );
fla_apq2ut_t* FLA_Cntl_apq2ut_obj_create( FLA_Matrix_type  matrix_type,
                                          int              variant,
                                          fla_blocksize_t* blocksize,
                                          fla_apq2ut_t*    sub_apq2ut,
                                          fla_gemm_t*      sub_gemm1,
                                          fla_gemm_t*      sub_gemm2,
                                          fla_trsm_t*      sub_trsm,
                                          fla_copyt_t*     sub_copyt,
                                          fla_axpyt_t*     sub_axpyt );
fla_apcaq2ut_t* FLA_Cntl_apcaq2ut_obj_create( FLA_Matrix_type  matrix_type,
                                              int              variant,
                                              fla_blocksize_t* blocksize,
                                              fla_apcaq2ut_t*  sub_apcaq2ut,
                                              fla_gemm_t*      sub_gemm1,
                                              fla_gemm_t*      sub_gemm2,
                                              fla_trmm_t*      sub_trmm1,
                                              fla_trmm_t*      sub_trmm2,
                                              fla_trsm_t*      sub_trsm,
                                              fla_axpy_t*      sub_axpy1,
                                              fla_axpy_t*      sub_axpy2,
                                              fla_axpy_t*      sub_axpy3,
                                              fla_copy_t*      sub_copy );
fla_qrutinc_t* FLA_Cntl_qrutinc_obj_create( FLA_Matrix_type  matrix_type,
                                            int              variant,
                                            fla_blocksize_t* blocksize,
                                            fla_qrut_t*      sub_qrut,
                                            fla_apqut_t*     sub_apqut,
                                            fla_qr2ut_t*     sub_qr2ut,
                                            fla_apq2ut_t*    sub_apq2ut );
fla_apqutinc_t* FLA_Cntl_apqutinc_obj_create( FLA_Matrix_type  matrix_type,
                                              int              variant,
                                              fla_blocksize_t* blocksize,
                                              fla_apqut_t*     sub_apqut,
                                              fla_apq2ut_t*    sub_apq2ut );
fla_caqrutinc_t* FLA_Cntl_caqrutinc_obj_create( FLA_Matrix_type  matrix_type,
                                                int              variant,
                                                fla_blocksize_t* blocksize,
                                                fla_caqr2ut_t*   sub_caqr2ut,
                                                fla_apcaq2ut_t*  sub_apcaq2ut );
fla_apcaqutinc_t* FLA_Cntl_apcaqutinc_obj_create( FLA_Matrix_type  matrix_type,
                                                  int              variant,
                                                  fla_blocksize_t* blocksize,
                                                  fla_apcaq2ut_t*  sub_apcaq2ut );
fla_uddateut_t* FLA_Cntl_uddateut_obj_create( FLA_Matrix_type  matrix_type,
                                              int              variant,
                                              fla_blocksize_t* blocksize,
                                              fla_uddateut_t*  sub_uddateut,
                                              fla_apqudut_t*   sub_apqudut );
fla_apqudut_t* FLA_Cntl_apqudut_obj_create( FLA_Matrix_type  matrix_type,
                                            int              variant,
                                            fla_blocksize_t* blocksize,
                                            fla_apqudut_t*   sub_apq2ut,
                                            fla_gemm_t*      sub_gemm1,
                                            fla_gemm_t*      sub_gemm2,
                                            fla_gemm_t*      sub_gemm3,
                                            fla_gemm_t*      sub_gemm4,
                                            fla_trsm_t*      sub_trsm,
                                            fla_copyt_t*     sub_copyt,
                                            fla_axpyt_t*     sub_axpyt );
fla_uddateutinc_t* FLA_Cntl_uddateutinc_obj_create( FLA_Matrix_type  matrix_type,
                                                    int              variant,
                                                    fla_blocksize_t* blocksize,
                                                    fla_uddateut_t*  sub_uddateut,
                                                    fla_apqudut_t*   sub_apqudut );
fla_apqudutinc_t* FLA_Cntl_apqudutinc_obj_create( FLA_Matrix_type  matrix_type,
                                                  int              variant,
                                                  fla_blocksize_t* blocksize,
                                                  fla_apqudut_t*   sub_apqudut );
fla_eig_gest_t* FLA_Cntl_eig_gest_obj_create( FLA_Matrix_type  matrix_type,
                                              int              variant,
                                              fla_blocksize_t* blocksize,
                                              fla_eig_gest_t*  sub_eig_gest,
                                              fla_axpy_t*      sub_axpy1,
                                              fla_axpy_t*      sub_axpy2,
                                              fla_gemm_t*      sub_gemm1,
                                              fla_gemm_t*      sub_gemm2,
                                              fla_gemm_t*      sub_gemm3,
                                              fla_hemm_t*      sub_hemm,
                                              fla_her2k_t*     sub_her2k,
                                              fla_trmm_t*      sub_trmm1,
                                              fla_trmm_t*      sub_trmm2,
                                              fla_trsm_t*      sub_trsm1,
                                              fla_trsm_t*      sub_trsm2 );

// end FLA_Cntl_lapack.h

// end FLA_Cntl.h
// begin FLA_Cntl_init.h


// begin FLA_Cntl_init_flamec.h


void FLA_Cntl_init_flamec( void );
void FLA_Cntl_finalize_flamec( void );


// --- Base library prototypes -------------------------------------------------
void FLA_Transpose_cntl_init( void );

void FLA_Transpose_cntl_finalize( void );


// --- Level-1 BLAS prototypes -------------------------------------------------
void FLA_Axpy_cntl_init( void );
void FLA_Axpyt_cntl_init( void );
void FLA_Copy_cntl_init( void );
void FLA_Copyt_cntl_init( void );
void FLA_Copyr_cntl_init( void );
void FLA_Scal_cntl_init( void );
void FLA_Scalr_cntl_init( void );

void FLA_Axpy_cntl_finalize( void );
void FLA_Axpyt_cntl_finalize( void );
void FLA_Copy_cntl_finalize( void );
void FLA_Copyt_cntl_finalize( void );
void FLA_Copyr_cntl_finalize( void );
void FLA_Scal_cntl_finalize( void );
void FLA_Scalr_cntl_finalize( void );


// --- Level-2 BLAS prototypes -------------------------------------------------
void FLA_Gemv_cntl_init( void );
void FLA_Trsv_cntl_init( void );

void FLA_Gemv_cntl_finalize( void );
void FLA_Trsv_cntl_finalize( void );


// --- Level-3 BLAS prototypes -------------------------------------------------
void FLA_Gemm_cntl_init( void );
void FLA_Hemm_cntl_init( void );
void FLA_Herk_cntl_init( void );
void FLA_Her2k_cntl_init( void );
void FLA_Symm_cntl_init( void );
void FLA_Syrk_cntl_init( void );
void FLA_Syr2k_cntl_init( void );
void FLA_Trmm_cntl_init( void );
void FLA_Trsm_cntl_init( void );

void FLA_Gemm_cntl_finalize( void );
void FLA_Hemm_cntl_finalize( void );
void FLA_Herk_cntl_finalize( void );
void FLA_Her2k_cntl_finalize( void );
void FLA_Symm_cntl_finalize( void );
void FLA_Syrk_cntl_finalize( void );
void FLA_Syr2k_cntl_finalize( void );
void FLA_Trmm_cntl_finalize( void );
void FLA_Trsm_cntl_finalize( void );


// --- LAPACK-level prototypes -------------------------------------------------
void FLA_Apply_pivots_cntl_init( void );
void FLA_Chol_cntl_init( void );
void FLA_LU_piv_cntl_init( void );
void FLA_LU_nopiv_cntl_init( void );
void FLA_QR_UT_cntl_init( void );
void FLA_QR2_UT_cntl_init( void );
void FLA_LQ_UT_cntl_init( void );
void FLA_CAQR2_UT_cntl_init( void );
void FLA_UDdate_UT_cntl_init( void );
void FLA_Hess_UT_cntl_init( void );
void FLA_Tridiag_UT_cntl_init( void );
void FLA_Bidiag_UT_cntl_init( void );
void FLA_Trinv_cntl_init( void );
void FLA_Ttmm_cntl_init( void );
void FLA_Sylv_cntl_init( void );
void FLA_Lyap_cntl_init( void );
void FLA_SPDinv_cntl_init( void );
void FLA_Apply_Q_UT_cntl_init( void );
void FLA_Apply_Q2_UT_cntl_init( void );
void FLA_Apply_CAQ2_UT_cntl_init( void );
void FLA_Apply_QUD_UT_cntl_init( void );
void FLA_Eig_gest_cntl_init( void );

void FLA_Apply_pivots_cntl_finalize( void );
void FLA_Chol_cntl_finalize( void );
void FLA_LU_piv_cntl_finalize( void );
void FLA_LU_nopiv_cntl_finalize( void );
void FLA_QR_UT_cntl_finalize( void );
void FLA_QR2_UT_cntl_finalize( void );
void FLA_LQ_UT_cntl_finalize( void );
void FLA_CAQR2_UT_cntl_finalize( void );
void FLA_UDdate_UT_cntl_finalize( void );
void FLA_Hess_UT_cntl_finalize( void );
void FLA_Tridiag_UT_cntl_finalize( void );
void FLA_Bidiag_UT_cntl_finalize( void );
void FLA_Trinv_cntl_finalize( void );
void FLA_Ttmm_cntl_finalize( void );
void FLA_Sylv_cntl_finalize( void );
void FLA_Lyap_cntl_finalize( void );
void FLA_SPDinv_cntl_finalize( void );
void FLA_Apply_Q_UT_cntl_finalize( void );
void FLA_Apply_Q2_UT_cntl_finalize( void );
void FLA_Apply_CAQ2_UT_cntl_finalize( void );
void FLA_Apply_QUD_UT_cntl_finalize( void );
void FLA_Eig_gest_cntl_finalize( void );

// end FLA_Cntl_init_flamec.h
// begin FLA_Cntl_init_flash.h


void FLA_Cntl_init_flash( void );
void FLA_Cntl_finalize_flash( void );


// --- Base library prototypes -------------------------------------------------
void FLASH_Transpose_cntl_init( void );

void FLASH_Transpose_cntl_finalize( void );


// --- Level-1 BLAS prototypes -------------------------------------------------
void FLASH_Axpy_cntl_init( void );
void FLASH_Axpyt_cntl_init( void );
void FLASH_Copy_cntl_init( void );
void FLASH_Copyt_cntl_init( void );
void FLASH_Copyr_cntl_init( void );
void FLASH_Scal_cntl_init( void );
void FLASH_Scalr_cntl_init( void );

void FLASH_Axpy_cntl_finalize( void );
void FLASH_Axpyt_cntl_finalize( void );
void FLASH_Copy_cntl_finalize( void );
void FLASH_Copyt_cntl_finalize( void );
void FLASH_Copyr_cntl_finalize( void );
void FLASH_Scal_cntl_finalize( void );
void FLASH_Scalr_cntl_finalize( void );


// --- Level-2 BLAS prototypes -------------------------------------------------
void FLASH_Gemv_cntl_init( void );
void FLASH_Trsv_cntl_init( void );

void FLASH_Gemv_cntl_finalize( void );
void FLASH_Trsv_cntl_finalize( void );


// --- Level-3 BLAS prototypes -------------------------------------------------
void FLASH_Gemm_cntl_init( void );
void FLASH_Hemm_cntl_init( void );
void FLASH_Herk_cntl_init( void );
void FLASH_Her2k_cntl_init( void );
void FLASH_Symm_cntl_init( void );
void FLASH_Syrk_cntl_init( void );
void FLASH_Syr2k_cntl_init( void );
void FLASH_Trmm_cntl_init( void );
void FLASH_Trsm_cntl_init( void );

void FLASH_Gemm_cntl_finalize( void );
void FLASH_Hemm_cntl_finalize( void );
void FLASH_Herk_cntl_finalize( void );
void FLASH_Her2k_cntl_finalize( void );
void FLASH_Symm_cntl_finalize( void );
void FLASH_Syrk_cntl_finalize( void );
void FLASH_Syr2k_cntl_finalize( void );
void FLASH_Trmm_cntl_finalize( void );
void FLASH_Trsm_cntl_finalize( void );


// --- LAPACK-level prototypes -------------------------------------------------
void FLASH_Apply_pivots_cntl_init( void );
void FLASH_Chol_cntl_init( void );
void FLASH_LU_nopiv_cntl_init( void );
void FLASH_LU_piv_cntl_init( void );
void FLASH_LU_incpiv_cntl_init( void );
void FLASH_Trinv_cntl_init( void );
void FLASH_Ttmm_cntl_init( void );
void FLASH_SPDinv_cntl_init( void );
void FLASH_Sylv_cntl_init( void );
void FLASH_Lyap_cntl_init( void );
void FLASH_QR_UT_cntl_init( void );
void FLASH_QR2_UT_cntl_init( void );
void FLASH_LQ_UT_cntl_init( void );
void FLASH_CAQR2_UT_cntl_init( void );
void FLASH_UDdate_UT_cntl_init( void );
void FLASH_QR_UT_inc_cntl_init( void );
void FLASH_CAQR_UT_inc_cntl_init( void );
void FLASH_UDdate_UT_inc_cntl_init( void );
void FLASH_Apply_Q_UT_cntl_init( void );
void FLASH_Apply_Q2_UT_cntl_init( void );
void FLASH_Apply_CAQ2_UT_cntl_init( void );
void FLASH_Apply_QUD_UT_cntl_init( void );
void FLASH_Apply_Q_UT_inc_cntl_init( void );
void FLASH_Apply_CAQ_UT_inc_cntl_init( void );
void FLASH_Apply_QUD_UT_inc_cntl_init( void );
void FLASH_Eig_gest_cntl_init( void );

void FLASH_Apply_pivots_cntl_finalize( void );
void FLASH_Chol_cntl_finalize( void );
void FLASH_LU_nopiv_cntl_finalize( void );
void FLASH_LU_piv_cntl_finalize( void );
void FLASH_LU_incpiv_cntl_finalize( void );
void FLASH_Trinv_cntl_finalize( void );
void FLASH_Ttmm_cntl_finalize( void );
void FLASH_SPDinv_cntl_finalize( void );
void FLASH_Sylv_cntl_finalize( void );
void FLASH_Lyap_cntl_finalize( void );
void FLASH_QR_UT_cntl_finalize( void );
void FLASH_QR2_UT_cntl_finalize( void );
void FLASH_LQ_UT_cntl_finalize( void );
void FLASH_CAQR2_UT_cntl_finalize( void );
void FLASH_UDdate_UT_cntl_finalize( void );
void FLASH_QR_UT_inc_cntl_finalize( void );
void FLASH_CAQR_UT_inc_cntl_finalize( void );
void FLASH_UDdate_UT_inc_cntl_finalize( void );
void FLASH_Apply_Q_UT_cntl_finalize( void );
void FLASH_Apply_Q2_UT_cntl_finalize( void );
void FLASH_Apply_CAQ2_UT_cntl_finalize( void );
void FLASH_Apply_QUD_UT_cntl_finalize( void );
void FLASH_Apply_Q_UT_inc_cntl_finalize( void );
void FLASH_Apply_CAQ_UT_inc_cntl_finalize( void );
void FLASH_Apply_QUD_UT_inc_cntl_finalize( void );
void FLASH_Eig_gest_cntl_finalize( void );

// end FLA_Cntl_init_flash.h

void FLA_Cntl_init( void );
void FLA_Cntl_finalize( void );

// end FLA_Cntl_init.h

  // Include prototypes for base FLAME routines.
// begin FLA_main_prototypes.h


// -----------------------------------------------------------------------------

fla_blocksize_t* FLA_Blocksize_create( fla_dim_t b_s, fla_dim_t b_d, fla_dim_t b_c, fla_dim_t b_z );
fla_blocksize_t* FLA_Blocksize_create_copy( fla_blocksize_t* bp );
void             FLA_Blocksize_set( fla_blocksize_t* bp, fla_dim_t b_s, fla_dim_t b_d, fla_dim_t b_c, fla_dim_t b_z );
void             FLA_Blocksize_scale( fla_blocksize_t* bp, double factor );
void             FLA_Blocksize_free( fla_blocksize_t* bp );
fla_dim_t            FLA_Blocksize_extract( FLA_Datatype dt, fla_blocksize_t* bp );

fla_blocksize_t* FLA_Query_blocksizes( FLA_Dimension dim );
fla_dim_t            FLA_Query_blocksize( FLA_Datatype dt, FLA_Dimension dim );

fla_dim_t            FLA_Determine_blocksize( FLA_Obj A_unproc, FLA_Quadrant to_dir, fla_blocksize_t* cntl_blocksizes );
fla_dim_t            FLA_determine_matrix_size( FLA_Obj A_unproc, FLA_Quadrant to_dir );



// -----------------------------------------------------------------------------

unsigned int  FLA_Check_error_level( void );
unsigned int  FLA_Check_error_level_set( unsigned int level );
FLA_Error     FLA_Check_error_code_helper( int code, char* file, int line );
FLA_Error     FLA_Check_valid_side( FLA_Side side );
FLA_Error     FLA_Check_valid_uplo( FLA_Uplo uplo );
FLA_Error     FLA_Check_valid_trans( FLA_Trans trans );
FLA_Error     FLA_Check_valid_diag( FLA_Diag diag );
FLA_Error     FLA_Check_valid_conj( FLA_Conj conj );
FLA_Error     FLA_Check_valid_direct( FLA_Conj direct );
FLA_Error     FLA_Check_valid_storev( FLA_Conj storev );
FLA_Error     FLA_Check_valid_inverse( FLA_Inv inv );
FLA_Error     FLA_Check_valid_datatype( FLA_Datatype datatype );
FLA_Error     FLA_Check_valid_object_datatype( FLA_Obj A );
FLA_Error     FLA_Check_valid_evd_type( FLA_Evd_type evd_type );
FLA_Error     FLA_Check_valid_svd_type( FLA_Svd_type svd_type );
FLA_Error     FLA_Check_valid_svd_type_combination( FLA_Svd_type svd_type_u, FLA_Svd_type svd_type_v );
FLA_Error     FLA_Check_valid_svd_type_and_trans_combination( FLA_Svd_type svd_type_u, FLA_Trans transu,
                                                              FLA_Svd_type svd_type_v, FLA_Trans transv );
FLA_Error     FLA_Check_floating_datatype( FLA_Datatype datatype );
FLA_Error     FLA_Check_int_datatype( FLA_Datatype datatype );
FLA_Error     FLA_Check_real_datatype( FLA_Datatype datatype );
FLA_Error     FLA_Check_complex_datatype( FLA_Datatype datatype );
FLA_Error     FLA_Check_floating_object( FLA_Obj A );
FLA_Error     FLA_Check_int_object( FLA_Obj A );
FLA_Error     FLA_Check_real_object( FLA_Obj A );
FLA_Error     FLA_Check_comparable_object( FLA_Obj A );
FLA_Error     FLA_Check_complex_object( FLA_Obj A );
FLA_Error     FLA_Check_consistent_datatype( FLA_Datatype datatype, FLA_Obj A );
FLA_Error     FLA_Check_consistent_object_datatype( FLA_Obj A, FLA_Obj B );
FLA_Error     FLA_Check_identical_object_precision( FLA_Obj A, FLA_Obj B );
FLA_Error     FLA_Check_square( FLA_Obj A );
FLA_Error     FLA_Check_if_scalar( FLA_Obj A );
FLA_Error     FLA_Check_if_vector( FLA_Obj A );
FLA_Error     FLA_Check_conformal_dims( FLA_Trans trans, FLA_Obj A, FLA_Obj B );
FLA_Error     FLA_Check_matrix_matrix_dims( FLA_Trans transa, FLA_Trans transb, FLA_Obj A, FLA_Obj B, FLA_Obj C );
FLA_Error     FLA_Check_matrix_vector_dims( FLA_Trans trans, FLA_Obj A, FLA_Obj x, FLA_Obj y );
FLA_Error     FLA_Check_equal_vector_dims( FLA_Obj x, FLA_Obj y );
FLA_Error     FLA_Check_conj1_trans_and_datatype( FLA_Trans trans, FLA_Obj A );
FLA_Error     FLA_Check_hess_indices( FLA_Obj A, int ilo, int ihi );
FLA_Error     FLA_Check_null_pointer( void* ptr );
FLA_Error     FLA_Check_object_dims( FLA_Trans trans, fla_dim_t m, fla_dim_t n, FLA_Obj A );
FLA_Error     FLA_Check_valid_pivot_type( FLA_Pivot_type ptype );
FLA_Error     FLA_Check_malloc_pointer( void* ptr );
FLA_Error     FLA_Check_base_buffer_mismatch( FLA_Obj A, FLA_Obj B );
FLA_Error     FLA_Check_adjacent_objects_2x2( FLA_Obj A11, FLA_Obj A12,
                                              FLA_Obj A21, FLA_Obj A22 );
FLA_Error     FLA_Check_adjacent_objects_2x1( FLA_Obj AT,
                                              FLA_Obj AB );
FLA_Error     FLA_Check_adjacent_objects_1x2( FLA_Obj AL, FLA_Obj AR );
FLA_Error     FLA_Check_blocksize_value( fla_dim_t b );
FLA_Error     FLA_Check_blocksize_object( FLA_Datatype datatype, fla_blocksize_t* bp );
FLA_Error     FLA_Check_file_descriptor( int fd );
FLA_Error     FLA_Check_lseek_result( int requested_offset, int lseek_r_val );
FLA_Error     FLA_Check_close_result( int close_r_val );
FLA_Error     FLA_Check_unlink_result( int unlink_r_val );
FLA_Error     FLA_Check_read_result( int requested_size, int read_r_val );
FLA_Error     FLA_Check_write_result( int requested_size, int write_r_val );
FLA_Error     FLA_Check_valid_quadrant( FLA_Quadrant quad );
FLA_Error     FLA_Check_vector_dim_min( FLA_Obj x, fla_dim_t min_dim );
FLA_Error     FLA_Check_pthread_create_result( int pthread_create_r_val );
FLA_Error     FLA_Check_pthread_join_result( int pthread_join_r_val );
FLA_Error     FLA_Check_valid_isgn_value( FLA_Obj isgn );
FLA_Error     FLA_Check_sylv_matrix_dims( FLA_Obj A, FLA_Obj B, FLA_Obj C );
FLA_Error     FLA_Check_chol_failure( FLA_Error r_val );
FLA_Error     FLA_Check_valid_elemtype( FLA_Elemtype elemtype );
FLA_Error     FLA_Check_posix_memalign_failure( int r_val );
FLA_Error     FLA_Check_submatrix_dims_and_offset( fla_dim_t m, fla_dim_t n, fla_dim_t i, fla_dim_t j, FLA_Obj A );
FLA_Error     FLA_Check_object_scalar_elemtype( FLA_Obj A );
FLA_Error     FLA_Check_object_matrix_elemtype( FLA_Obj A );
FLA_Error     FLA_Check_num_threads( unsigned int n_threads );
FLA_Error     FLA_Check_conj_and_datatype( FLA_Conj conj, FLA_Obj A );
FLA_Error     FLA_Check_valid_complex_trans( FLA_Trans trans );
FLA_Error     FLA_Check_valid_real_trans( FLA_Trans trans );
FLA_Error     FLA_Check_valid_blas_trans( FLA_Trans trans );
FLA_Error     FLA_Check_nonconstant_datatype( FLA_Datatype datatype );
FLA_Error     FLA_Check_nonconstant_object( FLA_Obj A );
FLA_Error     FLA_Check_identical_object_datatype( FLA_Obj A, FLA_Obj B );
FLA_Error     FLA_Check_divide_by_zero( FLA_Obj alpha );
FLA_Error     FLA_Check_identical_object_elemtype( FLA_Obj A, FLA_Obj B );
FLA_Error     FLA_Check_pivot_index_range( FLA_Obj p, fla_dim_t k1, fla_dim_t k2 );
FLA_Error     FLA_Check_householder_panel_dims( FLA_Obj A, FLA_Obj T );
FLA_Error     FLA_Check_object_length_equals( FLA_Obj A, fla_dim_t m );
FLA_Error     FLA_Check_object_width_equals( FLA_Obj A, fla_dim_t n );
FLA_Error     FLA_Check_object_length_min( FLA_Obj A, fla_dim_t m );
FLA_Error     FLA_Check_object_width_min( FLA_Obj A, fla_dim_t n );
FLA_Error     FLA_Check_valid_error_level( unsigned int level );
FLA_Error     FLA_Check_attempted_repart_2x2( FLA_Obj A_quad, fla_dim_t b_m, fla_dim_t b_n );
FLA_Error     FLA_Check_attempted_repart_2x1( FLA_Obj A_side, fla_dim_t b_m );
FLA_Error     FLA_Check_attempted_repart_1x2( FLA_Obj A_side, fla_dim_t b_n );
FLA_Error     FLA_Check_valid_leftright_side( FLA_Side side );
FLA_Error     FLA_Check_valid_topbottom_side( FLA_Side side );
FLA_Error     FLA_Check_matrix_strides( fla_dim_t m, fla_dim_t n, fla_dim_t rs, fla_dim_t cs );
FLA_Error     FLA_Check_vector_dim( FLA_Obj x, fla_dim_t expected_length );
FLA_Error     FLA_Check_row_vector( FLA_Obj x );
FLA_Error     FLA_Check_col_vector( FLA_Obj x );
FLA_Error     FLA_Check_valid_machval( FLA_Machval val );
FLA_Error     FLA_Check_valid_evd_type( FLA_Evd_type evd_type );
FLA_Error     FLA_Check_valid_svd_type( FLA_Svd_type svd_type );
FLA_Error     FLA_Check_valid_diag_offset( FLA_Obj A, FLA_Diag_off offset );
FLA_Error     FLA_Check_col_storage( FLA_Obj A );
FLA_Error     FLA_Check_row_storage( FLA_Obj A );




// -----------------------------------------------------------------------------

char*         FLA_Error_string_for_code( int code );
void          FLA_Error_messages_init( void );
void          FLA_Print_message( char *str, char *file, int line );
void          FLA_Abort( void );



// -----------------------------------------------------------------------------

void          FLA_Init( void );
void          FLA_Finalize( void );
FLA_Bool      FLA_Initialized( void );

void          FLA_Init_safe( FLA_Error* init_result );
void          FLA_Finalize_safe( FLA_Error init_result );

void          FLA_Init_constants( void );
void          FLA_Finalize_constants( void );

void          FLA_Init_numerical_constants( void );
void          FLA_Finalize_numerical_constants( void );

char*         FLA_Get_AOCL_Version( void );

//------------------------------------------------------------------------------

void          FLA_Lock_init( FLA_Lock* fla_lock_ptr );
void          FLA_Lock_destroy( FLA_Lock* fla_lock_ptr );
void          FLA_Lock_acquire( FLA_Lock* fla_lock_ptr );
void          FLA_Lock_release( FLA_Lock* fla_lock_ptr );



// -----------------------------------------------------------------------------

void          FLA_Memory_leak_counter_init( void );
void          FLA_Memory_leak_counter_finalize( void );
FLA_Bool      FLA_Memory_leak_counter_status( void );
FLA_Bool      FLA_Memory_leak_counter_set( FLA_Bool new_status );

void*         FLA_malloc( size_t size );
void*         FLA_realloc( void* old_ptr, size_t size );
void          FLA_free( void *ptr );
 


// -----------------------------------------------------------------------------

FLA_Error     FLA_Obj_copy_view( FLA_Obj A, FLA_Obj* B );
void          FLA_Obj_extract_real_scalar( FLA_Obj alpha, double* alpha_value );
void          FLA_Obj_extract_complex_scalar( FLA_Obj alpha, dcomplex* alpha_value );
void          FLA_Obj_extract_real_part( FLA_Obj alpha, FLA_Obj beta );
void          FLA_Obj_extract_imag_part( FLA_Obj alpha, FLA_Obj beta );
void          FLA_Obj_set_real_part( FLA_Obj alpha, FLA_Obj beta );
void          FLA_Obj_set_imag_part( FLA_Obj alpha, FLA_Obj beta );
FLA_Error     FLA_Obj_show( char *s1, FLA_Obj A, char *format, char *s2 );
FLA_Error     FLA_Obj_fshow( FILE* file, char *s1, FLA_Obj A, char *format, char *s2 );

FLA_Error     FLA_Obj_copy_view_check( FLA_Obj A, FLA_Obj* B );
FLA_Error     FLA_Obj_extract_real_scalar_check( FLA_Obj alpha, double* alpha_value );
FLA_Error     FLA_Obj_extract_complex_scalar_check( FLA_Obj alpha, dcomplex* alpha_value );
FLA_Error     FLA_Obj_extract_real_part_check( FLA_Obj alpha, FLA_Obj beta );
FLA_Error     FLA_Obj_extract_imag_part_check( FLA_Obj alpha, FLA_Obj beta );
FLA_Error     FLA_Obj_set_real_part_check( FLA_Obj alpha, FLA_Obj beta );
FLA_Error     FLA_Obj_set_imag_part_check( FLA_Obj alpha, FLA_Obj beta );
FLA_Error     FLA_Obj_show_check( char* s1, FLA_Obj obj, char* format, char* s2 );
FLA_Error     FLA_Obj_fshow_check( FILE* file, char* s1, FLA_Obj obj, char* format, char* s2 );


// -----------------------------------------------------------------------------

FLA_Error     FLA_Copy_buffer_to_object( FLA_Trans trans, fla_dim_t m, fla_dim_t n, void* buffer, fla_dim_t rs, fla_dim_t cs, fla_dim_t i, fla_dim_t j, FLA_Obj obj );
FLA_Error     FLA_Copy_object_to_buffer( FLA_Trans trans, fla_dim_t i, fla_dim_t j, FLA_Obj obj, fla_dim_t m, fla_dim_t n, void* buffer, fla_dim_t rs, fla_dim_t cs );
FLA_Error     FLA_Copy_buffer_to_object_check( FLA_Trans trans, fla_dim_t m, fla_dim_t n, void* buffer, fla_dim_t rs, fla_dim_t cs, fla_dim_t i, fla_dim_t j, FLA_Obj obj );
FLA_Error     FLA_Copy_object_to_buffer_check( FLA_Trans trans, fla_dim_t i, fla_dim_t j, FLA_Obj obj, fla_dim_t m, fla_dim_t n, void* buffer, fla_dim_t rs, fla_dim_t cs );



// -----------------------------------------------------------------------------

FLA_Error     FLA_Axpy_buffer_to_object( FLA_Trans trans, FLA_Obj alpha, fla_dim_t m, fla_dim_t n, void* buffer, fla_dim_t rs, fla_dim_t cs, fla_dim_t i, fla_dim_t j, FLA_Obj C );
FLA_Error     FLA_Axpy_object_to_buffer( FLA_Trans trans, FLA_Obj alpha, fla_dim_t i, fla_dim_t j, FLA_Obj C, fla_dim_t m, fla_dim_t n, void* buffer, fla_dim_t rs, fla_dim_t cs );

FLA_Error     FLA_Axpy_buffer_to_object_check( FLA_Trans trans, FLA_Obj alpha, fla_dim_t m, fla_dim_t n, void* buffer, fla_dim_t rs, fla_dim_t cs, fla_dim_t i, fla_dim_t j, FLA_Obj C );
FLA_Error     FLA_Axpy_object_to_buffer_check( FLA_Trans trans, FLA_Obj alpha, fla_dim_t i, fla_dim_t j, FLA_Obj C, fla_dim_t m, fla_dim_t n, void* buffer, fla_dim_t rs, fla_dim_t cs );



// -----------------------------------------------------------------------------

#ifdef FLA_ENABLE_SCC
void*         FLA_shmalloc( size_t size );
void          FLA_shfree( void* ptr );
FLA_Bool      FLA_is_owner( void );
#endif
FLA_Error     FLA_Obj_nullify( FLA_Obj *obj );
FLA_Error     FLA_Obj_create( FLA_Datatype datatype, fla_dim_t m, fla_dim_t n, fla_dim_t rs, fla_dim_t cs, FLA_Obj *obj );
FLA_Error     FLA_Obj_create_ext( FLA_Datatype datatype, FLA_Elemtype elemtype, fla_dim_t m, fla_dim_t n, fla_dim_t m_inner, fla_dim_t n_inner, fla_dim_t rs, fla_dim_t cs, FLA_Obj *obj );
FLA_Error     FLA_Obj_create_conf_to( FLA_Trans trans, FLA_Obj old, FLA_Obj *obj );
FLA_Error     FLA_Obj_create_copy_of( FLA_Trans trans, FLA_Obj old, FLA_Obj *obj );
FLA_Error     FLA_Obj_create_without_buffer( FLA_Datatype datatype, fla_dim_t m, fla_dim_t n, FLA_Obj *obj );
FLA_Error     FLA_Obj_create_constant( double const_real, FLA_Obj *obj );
FLA_Error     FLA_Obj_create_constant_ext( float const_s, double const_d, FLA_Obj *obj );
FLA_Error     FLA_Obj_create_complex_constant( double const_real, double const_imag, FLA_Obj *obj );
FLA_Error     FLA_Obj_attach_buffer( void *buffer, fla_dim_t rs, fla_dim_t cs, FLA_Obj *obj );
FLA_Error     FLA_Obj_create_buffer( fla_dim_t rs, fla_dim_t cs, FLA_Obj *obj );
FLA_Error     FLA_Obj_free( FLA_Obj *obj );
FLA_Error     FLA_Obj_free_without_buffer( FLA_Obj *obj );
FLA_Error     FLA_Obj_free_buffer( FLA_Obj *obj );
fla_dim_t         FLA_align_ldim( fla_dim_t ldim, fla_dim_t elem_size );
fla_dim_t         FLA_compute_num_elem( fla_dim_t elem_size, fla_dim_t m, fla_dim_t n, fla_dim_t* rs, fla_dim_t* cs );
void          FLA_adjust_strides( fla_dim_t m, fla_dim_t n, fla_dim_t* rs, fla_dim_t* cs );

FLA_Error     FLA_Obj_flip_base( FLA_Obj *obj );
FLA_Error     FLA_Obj_flip_view( FLA_Obj *obj );

FLA_Error     FLA_Obj_create_ext_check( FLA_Datatype datatype, FLA_Elemtype elemtype, fla_dim_t m, fla_dim_t n, fla_dim_t m_inner, fla_dim_t n_inner, fla_dim_t rs, fla_dim_t cs, FLA_Obj *obj );
FLA_Error     FLA_Obj_create_conf_to_check( FLA_Trans trans, FLA_Obj obj_old, FLA_Obj *obj );
FLA_Error     FLA_Obj_create_without_buffer_check( FLA_Datatype datatype, fla_dim_t m, fla_dim_t n, FLA_Obj *obj );
FLA_Error     FLA_Obj_create_constant_check( double const_real, FLA_Obj *obj );
FLA_Error     FLA_Obj_create_constant_ext_check( float const_s, double const_d, FLA_Obj *obj );
FLA_Error     FLA_Obj_create_complex_constant_check( double const_real, double const_imag, FLA_Obj *obj );
FLA_Error     FLA_Obj_attach_buffer_check( void *buffer, fla_dim_t rs, fla_dim_t cs, FLA_Obj *obj );
FLA_Error     FLA_Obj_create_buffer_check( fla_dim_t rs, fla_dim_t cs, FLA_Obj *obj );
FLA_Error     FLA_Obj_free_check( FLA_Obj *obj );
FLA_Error     FLA_Obj_free_without_buffer_check( FLA_Obj *obj );
FLA_Error     FLA_Obj_free_buffer_check( FLA_Obj *obj );

FLA_Error     FLA_Obj_create_buffer_task( fla_dim_t rs, fla_dim_t cs, FLA_Obj obj, void* cntl );
FLA_Error     FLA_Obj_free_buffer_task( FLA_Obj obj, void* cntl );


// -----------------------------------------------------------------------------

FLA_Datatype  FLA_Obj_datatype( FLA_Obj obj );
FLA_Datatype  FLA_Obj_datatype_proj_to_real( FLA_Obj A );
FLA_Datatype  FLA_Obj_datatype_proj_to_complex( FLA_Obj A );
FLA_Elemtype  FLA_Obj_elemtype( FLA_Obj obj );
fla_dim_t         FLA_Obj_datatype_size( FLA_Datatype datatype );
fla_dim_t         FLA_Obj_elem_size( FLA_Obj obj );
fla_dim_t         FLA_Obj_length( FLA_Obj obj );
fla_dim_t         FLA_Obj_width( FLA_Obj obj );
FLA_Uplo      FLA_Obj_structure( FLA_Obj obj );
fla_dim_t         FLA_Obj_vector_dim( FLA_Obj obj );
fla_dim_t         FLA_Obj_vector_inc( FLA_Obj obj );
fla_dim_t         FLA_Obj_min_dim( FLA_Obj obj );
fla_dim_t         FLA_Obj_max_dim( FLA_Obj obj );
fla_dim_t         FLA_Obj_row_stride( FLA_Obj obj );
fla_dim_t         FLA_Obj_col_stride( FLA_Obj obj );
fla_dim_t         FLA_Obj_row_offset( FLA_Obj obj );
fla_dim_t         FLA_Obj_col_offset( FLA_Obj obj );
fla_dim_t         FLA_Obj_base_length( FLA_Obj obj );
fla_dim_t         FLA_Obj_base_width( FLA_Obj obj );
fla_dim_t         FLA_Obj_num_elem_alloc( FLA_Obj obj );
void*         FLA_Obj_base_buffer( FLA_Obj obj );
void*         FLA_Obj_buffer_at_view( FLA_Obj obj );
FLA_Bool      FLA_Obj_buffer_is_null( FLA_Obj obj );
FLA_Bool      FLA_Obj_is_int( FLA_Obj A );
FLA_Bool      FLA_Obj_is_floating_point( FLA_Obj A );
FLA_Bool      FLA_Obj_is_constant( FLA_Obj A );
FLA_Bool      FLA_Obj_is_real( FLA_Obj A );
FLA_Bool      FLA_Obj_is_complex( FLA_Obj A );
FLA_Bool      FLA_Obj_is_single_precision( FLA_Obj A );
FLA_Bool      FLA_Obj_is_double_precision( FLA_Obj A );
FLA_Bool      FLA_Obj_is_scalar( FLA_Obj A );
FLA_Bool      FLA_Obj_is_vector( FLA_Obj A );
FLA_Bool      FLA_Obj_has_zero_dim( FLA_Obj A );
FLA_Bool      FLA_Obj_is_row_major( FLA_Obj A );
FLA_Bool      FLA_Obj_is_col_major( FLA_Obj A );
FLA_Bool      FLA_Obj_is_conformal_to( FLA_Trans trans, FLA_Obj A, FLA_Obj B );
FLA_Bool      FLA_Obj_is( FLA_Obj A, FLA_Obj B );
FLA_Bool      FLA_Obj_is_identical( FLA_Obj A, FLA_Obj B );
FLA_Bool      FLA_Obj_is_overlapped( FLA_Obj A, FLA_Obj B );
FLA_Bool      FLA_Obj_equals( FLA_Obj A, FLA_Obj B );
FLA_Bool      FLA_Obj_gt( FLA_Obj A, FLA_Obj B );
FLA_Bool      FLA_Obj_ge( FLA_Obj A, FLA_Obj B );
FLA_Bool      FLA_Obj_lt( FLA_Obj A, FLA_Obj B );
FLA_Bool      FLA_Obj_le( FLA_Obj A, FLA_Obj B );
void*         FLA_Submatrix_at( FLA_Datatype datatype, void* buffer, fla_dim_t i, fla_dim_t j, fla_dim_t rs, fla_dim_t cs );
FLA_Bool      FLA_Obj_has_nan( FLA_Obj A );

FLA_Error     FLA_Obj_datatype_check( FLA_Obj obj );
FLA_Error     FLA_Obj_datatype_proj_to_real_check( FLA_Obj obj );
FLA_Error     FLA_Obj_elemtype_check( FLA_Obj obj );
FLA_Error     FLA_Obj_datatype_size_check( FLA_Datatype datatype );
FLA_Error     FLA_Obj_elem_size_check( FLA_Obj obj );
FLA_Error     FLA_Obj_buffer_at_view_check( FLA_Obj obj );
FLA_Error     FLA_Obj_equals_check( FLA_Obj A, FLA_Obj B );
FLA_Bool      FLA_Obj_gt_check( FLA_Obj A, FLA_Obj B );
FLA_Bool      FLA_Obj_ge_check( FLA_Obj A, FLA_Obj B );
FLA_Bool      FLA_Obj_lt_check( FLA_Obj A, FLA_Obj B );
FLA_Bool      FLA_Obj_le_check( FLA_Obj A, FLA_Obj B );
FLA_Error     FLA_Submatrix_at_check( FLA_Datatype datatype, void* buffer, fla_dim_t i, fla_dim_t j, fla_dim_t rs, fla_dim_t cs );
FLA_Error     FLA_Obj_has_nan_check( FLA_Obj A );


// ------------------------------------------------------------------------------

void          FLA_Param_map_flame_to_netlib_trans( FLA_Trans trans, void* blas_trans );
void          FLA_Param_map_flame_to_netlib_uplo( FLA_Uplo uplo, void* blas_uplo );
void          FLA_Param_map_flame_to_netlib_side( FLA_Uplo side, void* blas_side );
void          FLA_Param_map_flame_to_netlib_diag( FLA_Diag diag, void* blas_diag );
void          FLA_Param_map_flame_to_netlib_direct( FLA_Direct direct, void* lapack_direct );
void          FLA_Param_map_flame_to_netlib_storev( FLA_Store storev, void* lapack_storev );
void          FLA_Param_map_flame_to_netlib_evd_type( FLA_Evd_type evd_type, void* lapack_evd_type );
void          FLA_Param_map_flame_to_netlib_svd_type( FLA_Svd_type svd_type, void* lapack_svd_type );
void          FLA_Param_map_flame_to_netlib_machval( FLA_Machval machval, void* blas_machval );

void          FLA_Param_map_flame_to_blis_trans( FLA_Trans trans, trans1_t* blis_trans );
void          FLA_Param_map_flame_to_blis_conj( FLA_Conj conj, conj1_t* blis_conj );
void          FLA_Param_map_flame_to_blis_uplo( FLA_Uplo uplo, uplo1_t* blis_uplo );
void          FLA_Param_map_flame_to_blis_side( FLA_Uplo side, side1_t* blis_side );
void          FLA_Param_map_flame_to_blis_diag( FLA_Diag diag, diag1_t* blis_diag );
#if 0
void          FLA_Param_map_flame_to_blis2_trans( FLA_Trans trans, trans_t* blis_trans );
void          FLA_Param_map_flame_to_blis2_conj( FLA_Conj conj, conj_t* blis_conj );
void          FLA_Param_map_flame_to_blis2_uplo( FLA_Uplo uplo, uplo_t* blis_uplo );
void          FLA_Param_map_flame_to_blis2_side( FLA_Uplo side, side_t* blis_side );
void          FLA_Param_map_flame_to_blis2_diag( FLA_Diag diag, diag_t* blis_diag );
#endif

void          FLA_Param_map_blis_to_flame_trans( trans1_t trans, FLA_Trans* flame_trans );
void          FLA_Param_map_blis_to_flame_uplo( uplo1_t uplo, FLA_Uplo* flame_uplo );
void          FLA_Param_map_blis_to_flame_side( side1_t side, FLA_Side* flame_side );
void          FLA_Param_map_blis_to_flame_diag( diag1_t diag, FLA_Diag* flame_diag );

void          FLA_Param_map_char_to_flame_trans( char* trans, FLA_Trans* flame_trans );
void          FLA_Param_map_char_to_flame_uplo( char* uplo, FLA_Uplo* flame_uplo );
void          FLA_Param_map_char_to_flame_side( char* side, FLA_Side* flame_side );
void          FLA_Param_map_char_to_flame_diag( char* diag, FLA_Diag* flame_diag );
void          FLA_Param_map_char_to_flame_storev( char* storev, FLA_Direct* flame_storev );
void          FLA_Param_map_char_to_flame_direct( char* direct, FLA_Direct* flame_direct );
void          FLA_Param_map_char_to_flame_inv( char* inv, FLA_Inv* flame_inv );



void          FLA_Param_map_netlib_to_flame_trans( char* trans, FLA_Trans* flame_trans );
void          FLA_Param_map_netlib_to_flame_uplo( char* uplo, FLA_Uplo* flame_uplo );
void          FLA_Param_map_netlib_to_flame_side( char* side, FLA_Side* flame_side );
void          FLA_Param_map_netlib_to_flame_diag( char* diag, FLA_Diag* flame_diag );
void          FLA_Param_map_netlib_to_flame_inv( int* itype, FLA_Inv* flame_inv );
void          FLA_Param_map_netlib_to_flame_svd_type( char* svd, FLA_Svd_type* flame_svd );




// -----------------------------------------------------------------------------

FLA_Error     FLA_Part_2x2( FLA_Obj A,  FLA_Obj *A11, FLA_Obj *A12,
                                        FLA_Obj *A21, FLA_Obj *A22,
                            fla_dim_t  mb,  fla_dim_t     nb, FLA_Quadrant quadrant );

FLA_Error     FLA_Part_2x1 ( FLA_Obj A,  FLA_Obj *A1,
                                         FLA_Obj *A2,
                             fla_dim_t  mb,  FLA_Side side );

FLA_Error     FLA_Part_1x2( FLA_Obj A,  FLA_Obj *A1, FLA_Obj *A2,
                                        fla_dim_t    nb, FLA_Side side );
 
FLA_Error     FLA_Merge_2x2( FLA_Obj A11, FLA_Obj A12,
                             FLA_Obj A21, FLA_Obj A22,  FLA_Obj *A );
 
FLA_Error     FLA_Merge_2x1( FLA_Obj AT,
                             FLA_Obj AB,  FLA_Obj *A );

FLA_Error     FLA_Merge_1x2( FLA_Obj AL, FLA_Obj AR,  FLA_Obj *A );

FLA_Error     FLA_Repart_2x2_to_3x3( FLA_Obj ATL, FLA_Obj ATR,  FLA_Obj *A00, FLA_Obj *A01, FLA_Obj *A02,
                                                                FLA_Obj *A10, FLA_Obj *A11, FLA_Obj *A12,
                                     FLA_Obj ABL, FLA_Obj ABR,  FLA_Obj *A20, FLA_Obj *A21, FLA_Obj *A22,
                                     fla_dim_t   mb,  fla_dim_t    nb,  FLA_Quadrant quadrant );

FLA_Error     FLA_Repart_2x1_to_3x1( FLA_Obj AT,  FLA_Obj *A0,
                                                  FLA_Obj *A1,
                                     FLA_Obj AB,  FLA_Obj *A2,
                                     fla_dim_t   mb,  FLA_Side side );

FLA_Error     FLA_Repart_1x2_to_1x3( FLA_Obj  AL,              FLA_Obj  AR,
                                     FLA_Obj *A0, FLA_Obj *A1, FLA_Obj *A2,
                                                  fla_dim_t    nb, FLA_Side side );

FLA_Error     FLA_Cont_with_3x3_to_2x2( FLA_Obj *ATL, FLA_Obj *ATR,  FLA_Obj A00, FLA_Obj A01, FLA_Obj A02,
                                                                     FLA_Obj A10, FLA_Obj A11, FLA_Obj A12,
                                        FLA_Obj *ABL, FLA_Obj *ABR,  FLA_Obj A20, FLA_Obj A21, FLA_Obj A22,
                                                                     FLA_Quadrant quadrant );

FLA_Error     FLA_Cont_with_3x1_to_2x1( FLA_Obj *AT,  FLA_Obj A0,
                                                      FLA_Obj A1,
                                        FLA_Obj *AB,  FLA_Obj A2,
                                                      FLA_Side side );

FLA_Error     FLA_Cont_with_1x3_to_1x2( FLA_Obj *AL,              FLA_Obj *AR,
                                        FLA_Obj  A0, FLA_Obj  A1, FLA_Obj  A2,
                                                                  FLA_Side side );

FLA_Error     FLA_Repart_3x3_to_5x5( FLA_Obj ATL, FLA_Obj ATM, FLA_Obj ATR,
                                     FLA_Obj AML, FLA_Obj AMM, FLA_Obj AMR,
                                     FLA_Obj ABL, FLA_Obj ABM, FLA_Obj ABR,
                                     FLA_Obj *A00, FLA_Obj *A01, FLA_Obj *A02, FLA_Obj *A03, FLA_Obj *A04,
                                     FLA_Obj *A10, FLA_Obj *A11, FLA_Obj *A12, FLA_Obj *A13, FLA_Obj *A14,
                                     FLA_Obj *A20, FLA_Obj *A21, FLA_Obj *A22, FLA_Obj *A23, FLA_Obj *A24,
                                     FLA_Obj *A30, FLA_Obj *A31, FLA_Obj *A32, FLA_Obj *A33, FLA_Obj *A34,
                                     FLA_Obj *A40, FLA_Obj *A41, FLA_Obj *A42, FLA_Obj *A43, FLA_Obj *A44,
                                     fla_dim_t b, FLA_Quadrant quadrant );

FLA_Error     FLA_Cont_with_5x5_to_3x3( FLA_Obj *ATL, FLA_Obj *ATM, FLA_Obj *ATR,
                                        FLA_Obj *AML, FLA_Obj *AMM, FLA_Obj *AMR,
                                        FLA_Obj *ABL, FLA_Obj *ABM, FLA_Obj *ABR,
                                        FLA_Obj A00, FLA_Obj A01, FLA_Obj A02, FLA_Obj A03, FLA_Obj A04,
                                        FLA_Obj A10, FLA_Obj A11, FLA_Obj A12, FLA_Obj A13, FLA_Obj A14,
                                        FLA_Obj A20, FLA_Obj A21, FLA_Obj A22, FLA_Obj A23, FLA_Obj A24,
                                        FLA_Obj A30, FLA_Obj A31, FLA_Obj A32, FLA_Obj A33, FLA_Obj A34,
                                        FLA_Obj A40, FLA_Obj A41, FLA_Obj A42, FLA_Obj A43, FLA_Obj A44,
                                        FLA_Quadrant quadrant );



FLA_Error     FLA_Part_2x2_check( FLA_Obj A,  FLA_Obj *A11, FLA_Obj *A12,
                                              FLA_Obj *A21, FLA_Obj *A22,
                                  fla_dim_t  mb,  fla_dim_t     nb, FLA_Quadrant quadrant );

FLA_Error     FLA_Part_2x1_check( FLA_Obj A,  FLA_Obj *A1,
                                               FLA_Obj *A2,
                                   fla_dim_t  mb,  FLA_Side side );

FLA_Error     FLA_Part_1x2_check( FLA_Obj A,  FLA_Obj *A1, FLA_Obj *A2,
                                              fla_dim_t    nb, FLA_Side side );
 
FLA_Error     FLA_Merge_2x2_check( FLA_Obj A11, FLA_Obj A12,
                                   FLA_Obj A21, FLA_Obj A22,  FLA_Obj *A );
 
FLA_Error     FLA_Merge_2x1_check( FLA_Obj AT,
                                   FLA_Obj AB,  FLA_Obj *A );

FLA_Error     FLA_Merge_1x2_check( FLA_Obj AL, FLA_Obj AR,  FLA_Obj *A );

FLA_Error     FLA_Repart_2x2_to_3x3_check( FLA_Obj ATL, FLA_Obj ATR,  FLA_Obj *A00, FLA_Obj *A01, FLA_Obj *A02,
                                                                      FLA_Obj *A10, FLA_Obj *A11, FLA_Obj *A12,
                                           FLA_Obj ABL, FLA_Obj ABR,  FLA_Obj *A20, FLA_Obj *A21, FLA_Obj *A22,
                                           fla_dim_t   mb,  fla_dim_t    nb,  FLA_Quadrant quadrant );

FLA_Error     FLA_Repart_2x1_to_3x1_check( FLA_Obj AT,  FLA_Obj *A0,
                                                        FLA_Obj *A1,
                                           FLA_Obj AB,  FLA_Obj *A2,
                                           fla_dim_t   mb,  FLA_Side side );

FLA_Error     FLA_Repart_1x2_to_1x3_check( FLA_Obj  AL,              FLA_Obj  AR,
                                           FLA_Obj *A0, FLA_Obj *A1, FLA_Obj *A2,
                                                        fla_dim_t    nb, FLA_Side side );

FLA_Error     FLA_Cont_with_3x3_to_2x2_check( FLA_Obj *ATL, FLA_Obj *ATR,  FLA_Obj A00, FLA_Obj A01, FLA_Obj A02,
                                                                           FLA_Obj A10, FLA_Obj A11, FLA_Obj A12,
                                              FLA_Obj *ABL, FLA_Obj *ABR,  FLA_Obj A20, FLA_Obj A21, FLA_Obj A22,
                                                                           FLA_Quadrant quadrant );

FLA_Error     FLA_Cont_with_3x1_to_2x1_check( FLA_Obj *AT,  FLA_Obj A0,
                                                            FLA_Obj A1,
                                              FLA_Obj *AB,  FLA_Obj A2,
                                                            FLA_Side side );

FLA_Error     FLA_Cont_with_1x3_to_1x2_check( FLA_Obj *AL,              FLA_Obj *AR,
                                              FLA_Obj  A0, FLA_Obj  A1, FLA_Obj  A2,
                                                                        FLA_Side side );
// end FLA_main_prototypes.h
// begin FLA_util_base_prototypes.h


float     FLA_random_float( void );
double    FLA_random_double( void );
scomplex  FLA_random_scomplex( void );
dcomplex  FLA_random_dcomplex( void );

FLA_Error FLA_Absolute_square( FLA_Obj alpha );
FLA_Error FLA_Absolute_value( FLA_Obj alpha );
double    FLA_Clock( void );
FLA_Error FLA_Conjugate( FLA_Obj A );
FLA_Error FLA_Conjugate_r( FLA_Uplo uplo, FLA_Obj A );
FLA_Error FLA_Fill_with_linear_dist( FLA_Obj shift, FLA_Obj delta, FLA_Obj x );
FLA_Error FLA_Fill_with_inverse_dist( FLA_Obj alpha, FLA_Obj x );
FLA_Error FLA_Fill_with_geometric_dist( FLA_Obj alpha, FLA_Obj x );
FLA_Error FLA_Fill_with_random_dist( FLA_Obj shift, FLA_Obj max, FLA_Obj x );
FLA_Error FLA_Fill_with_logarithmic_dist( FLA_Obj max, FLA_Obj x );
FLA_Error FLA_Fill_with_cluster_dist( FLA_Obj n_clusters, FLA_Obj cluster_width, FLA_Obj x );
FLA_Error FLA_Hermitianize( FLA_Uplo uplo, FLA_Obj A );
FLA_Error FLA_Invert( FLA_Conj conj, FLA_Obj x );
FLA_Error FLA_Inv_scal_elemwise( FLA_Trans trans, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Max_abs_value( FLA_Obj A, FLA_Obj amax );
FLA_Error FLA_Max_abs_value_herm( FLA_Uplo uplo, FLA_Obj A, FLA_Obj maxabs );
double    FLA_Max_elemwise_diff( FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Mult_add( FLA_Obj alpha, FLA_Obj beta, FLA_Obj gamma );
FLA_Error FLA_Negate( FLA_Obj x );
FLA_Error FLA_Norm1( FLA_Obj A, FLA_Obj norm );
FLA_Error FLA_Norm_inf( FLA_Obj A, FLA_Obj norm );
FLA_Error FLA_Norm_frob( FLA_Obj A, FLA_Obj norm );
FLA_Error FLA_Pow( FLA_Obj base, FLA_Obj exp, FLA_Obj btoe );
FLA_Error FLA_Random_matrix( FLA_Obj A );
FLA_Error FLA_Random_herm_matrix( FLA_Uplo uplo, FLA_Obj A );
FLA_Error FLA_Random_symm_matrix( FLA_Uplo uplo, FLA_Obj A );
FLA_Error FLA_Random_spd_matrix( FLA_Uplo uplo, FLA_Obj A );
FLA_Error FLA_Random_tri_matrix( FLA_Uplo uplo, FLA_Diag diag, FLA_Obj A );
FLA_Error FLA_Random_unitary_matrix( FLA_Obj A );
FLA_Error FLA_Scal_elemwise( FLA_Trans trans, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Setr( FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj A );
FLA_Error FLA_Shift_pivots_to_check( FLA_Pivot_type ptype, FLA_Obj p );
FLA_Error FLA_Sqrt( FLA_Obj alpha );
FLA_Error FLA_Symmetrize( FLA_Uplo uplo, FLA_Obj A );
FLA_Error FLA_Triangularize( FLA_Uplo uplo, FLA_Diag diag, FLA_Obj A );
FLA_Error FLA_Transpose( FLA_Obj A );

FLA_Error FLA_Set( FLA_Obj alpha, FLA_Obj A );
FLA_Error FLA_Set_diag( FLA_Obj alpha, FLA_Obj A );
FLA_Error FLA_Set_offdiag( integer offset, FLA_Obj alpha, FLA_Obj A );
FLA_Error FLA_Set_to_identity( FLA_Obj A );
FLA_Error FLA_Add_to_diag( void *diag_value, FLA_Obj A );
FLA_Error FLA_Shift_diag( FLA_Conj conj, FLA_Obj sigma, FLA_Obj A );
FLA_Error FLA_Scale_diag( FLA_Conj conj, FLA_Obj alpha, FLA_Obj A );

FLA_Error FLA_Set_diagonal_vector( FLA_Obj A, FLA_Obj d );
FLA_Error FLA_Set_diagonal_matrix( FLA_Obj d, FLA_Obj A );

// -----------------------------------------------------------------------------

FLA_Error FLA_Absolute_square_check( FLA_Obj alpha );
FLA_Error FLA_Absolute_value_check( FLA_Obj alpha );
FLA_Error FLA_Conjugate_check( FLA_Obj A );
FLA_Error FLA_Conjugate_r_check( FLA_Uplo uplo, FLA_Obj A );
FLA_Error FLA_Fill_with_linear_dist_check( FLA_Obj shift, FLA_Obj delta, FLA_Obj x );
FLA_Error FLA_Fill_with_inverse_dist_check( FLA_Obj alpha, FLA_Obj x );
FLA_Error FLA_Fill_with_geometric_dist_check( FLA_Obj alpha, FLA_Obj x );
FLA_Error FLA_Fill_with_random_dist_check( FLA_Obj shift, FLA_Obj max, FLA_Obj x );
FLA_Error FLA_Fill_with_logarithmic_dist_check( FLA_Obj alpha, FLA_Obj x );
FLA_Error FLA_Fill_with_cluster_dist_check( FLA_Obj n_clusters, FLA_Obj cluster_width, FLA_Obj x );
FLA_Error FLA_Hermitianize_check( FLA_Uplo uplo, FLA_Obj A );
FLA_Error FLA_Invert_check( FLA_Conj conj, FLA_Obj x );
FLA_Error FLA_Inv_scal_elemwise_check( FLA_Trans trans, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Max_abs_value_check( FLA_Obj A, FLA_Obj amax );
FLA_Error FLA_Max_abs_value_herm_check( FLA_Uplo uplo, FLA_Obj A, FLA_Obj maxabs );
FLA_Error FLA_Max_elemwise_diff_check( FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Mult_add_check( FLA_Obj alpha, FLA_Obj beta, FLA_Obj gamma );
FLA_Error FLA_Negate_check( FLA_Obj x );
FLA_Error FLA_Norm1_check( FLA_Obj A, FLA_Obj norm );
FLA_Error FLA_Norm_inf_check( FLA_Obj A, FLA_Obj norm );
FLA_Error FLA_Norm_frob_check( FLA_Obj A, FLA_Obj norm );
FLA_Error FLA_Pow_check( FLA_Obj base, FLA_Obj exp, FLA_Obj btoe );
FLA_Error FLA_Random_matrix_check( FLA_Obj A );
FLA_Error FLA_Random_herm_matrix_check( FLA_Uplo uplo, FLA_Obj A );
FLA_Error FLA_Random_symm_matrix_check( FLA_Uplo uplo, FLA_Obj A );
FLA_Error FLA_Random_spd_matrix_check( FLA_Uplo uplo, FLA_Obj A );
FLA_Error FLA_Random_tri_matrix_check( FLA_Uplo uplo, FLA_Diag diag, FLA_Obj A );
FLA_Error FLA_Random_unitary_matrix_check( FLA_Obj A );
FLA_Error FLA_Scal_elemwise_check( FLA_Trans trans, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Setr_check( FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj A );
FLA_Error FLA_Sort_check( FLA_Direct direct, FLA_Obj x );
FLA_Error FLA_Sqrt_check( FLA_Obj alpha );
FLA_Error FLA_Symmetrize_check( FLA_Uplo uplo, FLA_Obj A );
FLA_Error FLA_Triangularize_check( FLA_Uplo uplo, FLA_Diag diag, FLA_Obj A );
FLA_Error FLA_Transpose_check( FLA_Obj A );

FLA_Error FLA_Set_check( FLA_Obj alpha, FLA_Obj A );
FLA_Error FLA_Set_diag_check( FLA_Obj alpha, FLA_Obj A );
FLA_Error FLA_Set_to_identity_check( FLA_Obj A );
FLA_Error FLA_Add_to_diag_check( void *diag_value, FLA_Obj A );
FLA_Error FLA_Shift_diag_check( FLA_Conj conj, FLA_Obj sigma, FLA_Obj A );
FLA_Error FLA_Scale_diag_check( FLA_Conj conj, FLA_Obj alpha, FLA_Obj A );

// -----------------------------------------------------------------------------

FLA_Error FLA_Transpose_blk_var1( FLA_Obj A, fla_tpose_t* cntl );
FLA_Error FLA_Transpose_blk_var2( FLA_Obj A, fla_tpose_t* cntl );
FLA_Error FLA_Transpose_unb_var1( FLA_Obj A );
FLA_Error FLA_Transpose_unb_var2( FLA_Obj A );
FLA_Error FLA_Swap_t_blk_var1( FLA_Obj A, FLA_Obj B, fla_swap_t* cntl );
FLA_Error FLA_Swap_t_blk_var2( FLA_Obj A, FLA_Obj B, fla_swap_t* cntl );

FLA_Error FLA_Sort( FLA_Direct direct, FLA_Obj x );
FLA_Error FLA_Sort_f_ops( integer     m_x,
                          float*  x, integer inc_x );
FLA_Error FLA_Sort_b_ops( integer     m_x,
                          float*  x, integer inc_x );
FLA_Error FLA_Sort_f_opd( integer     m_x,
                          double* x, integer inc_x );
FLA_Error FLA_Sort_b_opd( integer     m_x,
                          double* x, integer inc_x );

// end FLA_util_base_prototypes.h
// begin FLA_util_lapack_prototypes.h


// --- LAPACK-related utility prototypes ---------------------------------------

FLA_Error FLA_Househ2_UT( FLA_Side side, FLA_Obj chi_1, FLA_Obj x2, FLA_Obj tau );
FLA_Error FLA_Househ2_UT_l_ops( integer m_x2,
                                float* chi_1,
                                float* x2, integer inc_x2,
                                float* tau );
FLA_Error FLA_Househ2_UT_l_opd( integer m_x2,
                                double* chi_1,
                                double* x2, integer inc_x2,
                                double* tau );
FLA_Error FLA_Househ2_UT_l_opc( integer m_x2,
                                scomplex* chi_1,
                                scomplex* x2, integer inc_x2,
                                scomplex* tau );
FLA_Error FLA_Househ2_UT_l_opz( integer m_x2,
                                dcomplex* chi_1,
                                dcomplex* x2, integer inc_x2,
                                dcomplex* tau );
FLA_Error FLA_Househ2_UT_r_ops( integer m_x2,
                                float* chi_1,
                                float* x2, integer inc_x2,
                                float* tau );
FLA_Error FLA_Househ2_UT_r_opd( integer m_x2,
                                double* chi_1,
                                double* x2, integer inc_x2,
                                double* tau );
FLA_Error FLA_Househ2_UT_r_opc( integer m_x2,
                                scomplex* chi_1,
                                scomplex* x2, integer inc_x2,
                                scomplex* tau );
FLA_Error FLA_Househ2_UT_r_opz( integer m_x2,
                                dcomplex* chi_1,
                                dcomplex* x2, integer inc_x2,
                                dcomplex* tau );

FLA_Error FLA_Househ3UD_UT( FLA_Obj chi_1, FLA_Obj x2, FLA_Obj y2, FLA_Obj tau );
FLA_Error FLA_Househ3UD_UT_ops( integer m_x2,
                                integer m_y2,
                                float* chi_1,
                                float* x2, integer inc_x2,
                                float* y2, integer inc_y2,
                                float* tau );
FLA_Error FLA_Househ3UD_UT_opd( integer m_x2,
                                integer m_y2,
                                double* chi_1,
                                double* x2, integer inc_x2,
                                double* y2, integer inc_y2,
                                double* tau );
FLA_Error FLA_Househ3UD_UT_opc( integer m_x2,
                                integer m_y2,
                                scomplex* chi_1,
                                scomplex* x2, integer inc_x2,
                                scomplex* y2, integer inc_y2,
                                scomplex* tau );
FLA_Error FLA_Househ3UD_UT_opz( integer m_x2,
                                integer m_y2,
                                dcomplex* chi_1,
                                dcomplex* x2, integer inc_x2,
                                dcomplex* y2, integer inc_y2,
                                dcomplex* tau );

FLA_Error FLA_Househ2s_UT( FLA_Side side, FLA_Obj chi_1, FLA_Obj x2, FLA_Obj alpha, FLA_Obj chi_1_minus_alpha, FLA_Obj tau );
FLA_Error FLA_Househ2s_UT_l_ops( integer    m_x2,
                                 float* chi_1,
                                 float* x2, integer inc_x2,
                                 float* alpha,
                                 float* chi_1_minus_alpha,
                                 float* tau );
FLA_Error FLA_Househ2s_UT_l_opd( integer     m_x2,
                                 double* chi_1,
                                 double* x2, integer inc_x2,
                                 double* alpha,
                                 double* chi_1_minus_alpha,
                                 double* tau );
FLA_Error FLA_Househ2s_UT_l_opc( integer       m_x2,
                                 scomplex* chi_1,
                                 scomplex* x2, integer inc_x2,
                                 scomplex* alpha,
                                 scomplex* chi_1_minus_alpha,
                                 scomplex* tau );
FLA_Error FLA_Househ2s_UT_l_opz( integer       m_x2,
                                 dcomplex* chi_1,
                                 dcomplex* x2, integer inc_x2,
                                 dcomplex* alpha,
                                 dcomplex* chi_1_minus_alpha,
                                 dcomplex* tau );
FLA_Error FLA_Househ2s_UT_r_ops( integer    m_x2,
                                 float* chi_1,
                                 float* x2, integer inc_x2,
                                 float* alpha,
                                 float* chi_1_minus_alpha,
                                 float* tau );
FLA_Error FLA_Househ2s_UT_r_opd( integer     m_x2,
                                 double* chi_1,
                                 double* x2, integer inc_x2,
                                 double* alpha,
                                 double* chi_1_minus_alpha,
                                 double* tau );
FLA_Error FLA_Househ2s_UT_r_opc( integer       m_x2,
                                 scomplex* chi_1,
                                 scomplex* x2, integer inc_x2,
                                 scomplex* alpha,
                                 scomplex* chi_1_minus_alpha,
                                 scomplex* tau );
FLA_Error FLA_Househ2s_UT_r_opz( integer       m_x2,
                                 dcomplex* chi_1,
                                 dcomplex* x2, integer inc_x2,
                                 dcomplex* alpha,
                                 dcomplex* chi_1_minus_alpha,
                                 dcomplex* tau );

FLA_Error FLA_Hev_2x2( FLA_Obj alpha11, FLA_Obj alpha21, FLA_Obj alpha22,
                       FLA_Obj lambda1, FLA_Obj lambda2 );
FLA_Error FLA_Hev_2x2_ops( float*    buff_alpha11,
                           float*    buff_alpha21,
                           float*    buff_alpha22,
                           float*    buff_lambda1,
                           float*    buff_lambda2 );
FLA_Error FLA_Hev_2x2_opd( double*   buff_alpha11,
                           double*   buff_alpha21,
                           double*   buff_alpha22,
                           double*   buff_lambda1,
                           double*   buff_lambda2 );

FLA_Error FLA_Hevv_2x2( FLA_Obj alpha11, FLA_Obj alpha21, FLA_Obj alpha22,
                        FLA_Obj lambda1, FLA_Obj lambda2,
                        FLA_Obj gamma1,  FLA_Obj sigma1 );
FLA_Error FLA_Hevv_2x2_ops( float*    alpha11,
                            float*    alpha21,
                            float*    alpha22,
                            float*    lambda1,
                            float*    lambda2,
                            float*    gamma1,
                            float*    sigma1 );
FLA_Error FLA_Hevv_2x2_opd( double*   alpha11,
                            double*   alpha21,
                            double*   alpha22,
                            double*   lambda1,
                            double*   lambda2,
                            double*   gamma1,
                            double*   sigma1 );
FLA_Error FLA_Hevv_2x2_opc( scomplex* alpha11,
                            scomplex* alpha21,
                            scomplex* alpha22,
                            float*    lambda1,
                            float*    lambda2,
                            float*    gamma1,
                            scomplex* sigma1 );
FLA_Error FLA_Hevv_2x2_opz( dcomplex* alpha11,
                            dcomplex* alpha21,
                            dcomplex* alpha22,
                            double*   lambda1,
                            double*   lambda2,
                            double*   gamma1,
                            dcomplex* sigma1 );

FLA_Error FLA_Wilkshift_tridiag( FLA_Obj delta1, FLA_Obj epsilon, FLA_Obj delta2, FLA_Obj kappa );
FLA_Error FLA_Wilkshift_tridiag_ops( float   delta1,
                                     float   epsilon,
                                     float   delta2,
                                     float*  kappa );
FLA_Error FLA_Wilkshift_tridiag_opd( double  delta1,
                                     double  epsilon,
                                     double  delta2,
                                     double* kappa );

FLA_Error FLA_Pythag2( FLA_Obj chi, FLA_Obj psi, FLA_Obj rho );
FLA_Error FLA_Pythag2_ops( float*    chi,
                           float*    psi,
                           float*    rho );
FLA_Error FLA_Pythag2_opd( double*   chi,
                           double*   psi,
                           double*   rho );

FLA_Error FLA_Pythag3( FLA_Obj chi, FLA_Obj psi, FLA_Obj zeta, FLA_Obj rho );
FLA_Error FLA_Pythag3_ops( float*    chi,
                           float*    psi,
                           float*    zeta,
                           float*    rho );
FLA_Error FLA_Pythag3_opd( double*   chi,
                           double*   psi,
                           double*   zeta,
                           double*   rho );

FLA_Error FLA_Sort_evd( FLA_Direct direct, FLA_Obj l, FLA_Obj V );
FLA_Error FLA_Sort_evd_f_ops( integer       m_A,
                              float*    l, integer inc_l,
                              float*    V, integer rs_V, integer cs_V );
FLA_Error FLA_Sort_evd_b_ops( integer       m_A,
                              float*    l, integer inc_l,
                              float*    V, integer rs_V, integer cs_V );
FLA_Error FLA_Sort_evd_f_opd( integer       m_A,
                              double*   l, integer inc_l,
                              double*   V, integer rs_V, integer cs_V );
FLA_Error FLA_Sort_evd_b_opd( integer       m_A,
                              double*   l, integer inc_l,
                              double*   V, integer rs_V, integer cs_V );
FLA_Error FLA_Sort_evd_f_opc( integer       m_A,
                              float*    l, integer inc_l,
                              scomplex* V, integer rs_V, integer cs_V );
FLA_Error FLA_Sort_evd_b_opc( integer       m_A,
                              float*    l, integer inc_l,
                              scomplex* V, integer rs_V, integer cs_V );
FLA_Error FLA_Sort_evd_f_opz( integer       m_A,
                              double*   l, integer inc_l,
                              dcomplex* V, integer rs_V, integer cs_V );
FLA_Error FLA_Sort_evd_b_opz( integer       m_A,
                              double*   l, integer inc_l,
                              dcomplex* V, integer rs_V, integer cs_V );

FLA_Error FLA_Sort_bsvd_ext( FLA_Direct direct, FLA_Obj s,
                             FLA_Bool apply_U, FLA_Obj U,
                             FLA_Bool apply_V, FLA_Obj V,
                             FLA_Bool apply_C, FLA_Obj C );
FLA_Error FLA_Sort_bsvd_ext_f_ops( integer m_s, float* s, integer inc_s,
                                   integer m_U, float* U, integer rs_U, integer cs_U,
                                   integer m_V, float* V, integer rs_V, integer cs_V,
                                   integer n_C, float* C, integer rs_C, integer cs_C );
FLA_Error FLA_Sort_bsvd_ext_b_ops( integer m_s, float* s, integer inc_s,
                                   integer m_U, float* U, integer rs_U, integer cs_U,
                                   integer m_V, float* V, integer rs_V, integer cs_V,
                                   integer n_C, float* C, integer rs_C, integer cs_C );
FLA_Error FLA_Sort_bsvd_ext_f_opd( integer m_s, double* s, integer inc_s,
                                   integer m_U, double* U, integer rs_U, integer cs_U,
                                   integer m_V, double* V, integer rs_V, integer cs_V,
                                   integer n_C, double* C, integer rs_C, integer cs_C );
FLA_Error FLA_Sort_bsvd_ext_b_opd( integer m_s, double* s, integer inc_s,
                                   integer m_U, double* U, integer rs_U, integer cs_U,
                                   integer m_V, double* V, integer rs_V, integer cs_V,
                                   integer n_C, double* C, integer rs_C, integer cs_C );
FLA_Error FLA_Sort_bsvd_ext_f_opc( integer m_s, float*    s, integer inc_s,
                                   integer m_U, scomplex* U, integer rs_U, integer cs_U,
                                   integer m_V, scomplex* V, integer rs_V, integer cs_V,
                                   integer n_C, scomplex* C, integer rs_C, integer cs_C );
FLA_Error FLA_Sort_bsvd_ext_b_opc( integer m_s, float*    s, integer inc_s,
                                   integer m_U, scomplex* U, integer rs_U, integer cs_U,
                                   integer m_V, scomplex* V, integer rs_V, integer cs_V,
                                   integer n_C, scomplex* C, integer rs_C, integer cs_C );
FLA_Error FLA_Sort_bsvd_ext_f_opz( integer m_s, double*   s, integer inc_s,
                                   integer m_U, dcomplex* U, integer rs_U, integer cs_U,
                                   integer m_V, dcomplex* V, integer rs_V, integer cs_V,
                                   integer n_C, dcomplex* C, integer rs_C, integer cs_C );
FLA_Error FLA_Sort_bsvd_ext_b_opz( integer m_s, double*   s, integer inc_s,
                                   integer m_U, dcomplex* U, integer rs_U, integer cs_U,
                                   integer m_V, dcomplex* V, integer rs_V, integer cs_V,
                                   integer n_C, dcomplex* C, integer rs_C, integer cs_C );

FLA_Error FLA_Sort_svd( FLA_Direct direct, FLA_Obj s, FLA_Obj U, FLA_Obj V );
FLA_Error FLA_Sort_svd_f_ops( integer       m_U,
                              integer       n_V,
                              float*    s, integer inc_s,
                              float*    U, integer rs_U, integer cs_U,
                              float*    V, integer rs_V, integer cs_V );
FLA_Error FLA_Sort_svd_b_ops( integer       m_U,
                              integer       n_V,
                              float*    s, integer inc_s,
                              float*    U, integer rs_U, integer cs_U,
                              float*    V, integer rs_V, integer cs_V );
FLA_Error FLA_Sort_svd_f_opd( integer       m_U,
                              integer       n_V,
                              double*   s, integer inc_s,
                              double*   U, integer rs_U, integer cs_U,
                              double*   V, integer rs_V, integer cs_V );
FLA_Error FLA_Sort_svd_b_opd( integer       m_U,
                              integer       n_V,
                              double*   s, integer inc_s,
                              double*   U, integer rs_U, integer cs_U,
                              double*   V, integer rs_V, integer cs_V );
FLA_Error FLA_Sort_svd_f_opc( integer       m_U,
                              integer       n_V,
                              float*    s, integer inc_s,
                              scomplex* U, integer rs_U, integer cs_U,
                              scomplex* V, integer rs_V, integer cs_V );
FLA_Error FLA_Sort_svd_b_opc( integer       m_U,
                              integer       n_V,
                              float*    s, integer inc_s,
                              scomplex* U, integer rs_U, integer cs_U,
                              scomplex* V, integer rs_V, integer cs_V );
FLA_Error FLA_Sort_svd_f_opz( integer       m_U,
                              integer       n_V,
                              double*   s, integer inc_s,
                              dcomplex* U, integer rs_U, integer cs_U,
                              dcomplex* V, integer rs_V, integer cs_V );
FLA_Error FLA_Sort_svd_b_opz( integer       m_U,
                              integer       n_V,
                              double*   s, integer inc_s,
                              dcomplex* U, integer rs_U, integer cs_U,
                              dcomplex* V, integer rs_V, integer cs_V );

FLA_Error FLA_Sv_2x2( FLA_Obj alpha11, FLA_Obj alpha12, FLA_Obj alpha22,
                      FLA_Obj sigma1, FLA_Obj sigma2 );
FLA_Error FLA_Sv_2x2_ops( float*    alpha11,
                          float*    alpha12,
                          float*    alpha22,
                          float*    sigma1,
                          float*    sigma2 );
FLA_Error FLA_Sv_2x2_opd( double*   alpha11,
                          double*   alpha12,
                          double*   alpha22,
                          double*   sigma1,
                          double*   sigma2 );

FLA_Error FLA_Svv_2x2( FLA_Obj alpha11, FLA_Obj alpha12, FLA_Obj alpha22,
                       FLA_Obj sigma1, FLA_Obj sigma2,
                       FLA_Obj gammaL, FLA_Obj sigmaL,
                       FLA_Obj gammaR, FLA_Obj sigmaR );
FLA_Error FLA_Svv_2x2_ops( float*    alpha11,
                           float*    alpha12,
                           float*    alpha22,
                           float*    sigma1,
                           float*    sigma2,
                           float*    gammaL,
                           float*    sigmaL,
                           float*    gammaR,
                           float*    sigmaR );
FLA_Error FLA_Svv_2x2_opd( double*   alpha11,
                           double*   alpha12,
                           double*   alpha22,
                           double*   sigma1,
                           double*   sigma2,
                           double*   gammaL,
                           double*   sigmaL,
                           double*   gammaR,
                           double*   sigmaR );

FLA_Error FLA_Mach_params( FLA_Machval machval, FLA_Obj val );
float     FLA_Mach_params_ops( FLA_Machval machval );
double    FLA_Mach_params_opd( FLA_Machval machval );

FLA_Error FLA_Apply_diag_matrix( FLA_Side side, FLA_Conj conj, FLA_Obj x, FLA_Obj A );
FLA_Error FLA_Shift_pivots_to( FLA_Pivot_type ptype, FLA_Obj p );
FLA_Error FLA_Form_perm_matrix( FLA_Obj p, FLA_Obj A );
FLA_Error FLA_LU_find_zero_on_diagonal( FLA_Obj A );

// --- f2c-converted routine prototypes ----------------------------------------

doublereal fla_dlamch( char* cmach, ftnlen cmach_len );
real       fla_slamch( char* cmach, ftnlen cmach_len );
logical    fla_lsame( char* ca, char* cb, ftnlen ca_len, ftnlen cb_len );
double     fla_pow_di( doublereal* a, integer* n );
real       fla_pow_ri( real* a, integer* n );

// --- LAPACK-related utility check routine prototypes -------------------------

FLA_Error FLA_Househ2_UT_check( FLA_Side side, FLA_Obj chi_1, FLA_Obj x2, FLA_Obj tau );
FLA_Error FLA_Househ3UD_UT_check( FLA_Obj chi_1, FLA_Obj x2, FLA_Obj y2, FLA_Obj tau );
FLA_Error FLA_Househ2s_UT_check( FLA_Side side, FLA_Obj chi_1, FLA_Obj x2, FLA_Obj alpha, FLA_Obj chi_1_minus_alpha, FLA_Obj tau );

FLA_Error FLA_Givens2_check( FLA_Obj chi_1, FLA_Obj chi_2, FLA_Obj gamma, FLA_Obj sigma, FLA_Obj chi_1_new );
FLA_Error FLA_Apply_GTG_check( FLA_Obj gamma, FLA_Obj sigma, FLA_Obj delta1, FLA_Obj epsilon1, FLA_Obj delta2 );
FLA_Error FLA_Apply_G_1x2_check( FLA_Obj gamma, FLA_Obj sigma, FLA_Obj beta, FLA_Obj epsilon );
FLA_Error FLA_Apply_G_mx2_check( FLA_Obj gamma, FLA_Obj sigma, FLA_Obj a1, FLA_Obj a2 );
FLA_Error FLA_Apply_G_check( FLA_Side side, FLA_Direct direct, FLA_Obj G, FLA_Obj A );
FLA_Error FLA_Wilkshift_tridiag_check( FLA_Obj delta1, FLA_Obj epsilon, FLA_Obj delta2, FLA_Obj kappa );
FLA_Error FLA_Wilkshift_bidiag_check( FLA_Obj epsilon1, FLA_Obj delta1, FLA_Obj epsilon2, FLA_Obj delta2, FLA_Obj kappa );
FLA_Error FLA_Introduce_bulge_check( FLA_Obj shift, FLA_Obj gamma, FLA_Obj sigma, FLA_Obj delta1, FLA_Obj epsilon1, FLA_Obj delta2, FLA_Obj beta, FLA_Obj epsilon2 );
FLA_Error FLA_Mach_params_check( FLA_Machval machval, FLA_Obj val );

FLA_Error FLA_Sort_evd_check( FLA_Direct direct, FLA_Obj l, FLA_Obj V );
FLA_Error FLA_Sort_svd_check( FLA_Direct direct, FLA_Obj s, FLA_Obj U, FLA_Obj V );

FLA_Error FLA_Apply_diag_matrix_check( FLA_Side side, FLA_Conj conj, FLA_Obj x, FLA_Obj A );
FLA_Error FLA_Shift_pivots_to_check( FLA_Pivot_type ptype, FLA_Obj p );
FLA_Error FLA_Form_perm_matrix_check( FLA_Obj p, FLA_Obj A );
FLA_Error FLA_LU_find_zero_on_diagonal_check( FLA_Obj A );

// end FLA_util_lapack_prototypes.h

  // Include prototypes for FLAME interfaces to BLAS and LAPACK operations.
// begin FLA_blas1_prototypes.h


// --- top-level wrapper prototypes --------------------------------------------

FLA_Error FLA_Asum( FLA_Obj x, FLA_Obj asum_x );
FLA_Error FLA_Axpy( FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Axpys( FLA_Obj alpha0, FLA_Obj alpha1, FLA_Obj A, FLA_Obj beta, FLA_Obj B );
FLA_Error FLA_Axpyt( FLA_Trans trans, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Axpyrt( FLA_Uplo uplo, FLA_Trans trans, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Copy( FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Copyr( FLA_Uplo uplo, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Copyrt( FLA_Uplo uplo, FLA_Trans trans, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Copyt( FLA_Trans trans, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Copyr( FLA_Uplo uplo, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Dot( FLA_Obj x, FLA_Obj y, FLA_Obj rho );
FLA_Error FLA_Dot2cs( FLA_Conj conj, FLA_Obj alpha, FLA_Obj x, FLA_Obj y, FLA_Obj beta, FLA_Obj rho );
FLA_Error FLA_Dot2s( FLA_Obj alpha, FLA_Obj x, FLA_Obj y, FLA_Obj beta, FLA_Obj rho );
FLA_Error FLA_Dotc( FLA_Conj conj, FLA_Obj x, FLA_Obj y, FLA_Obj rho );
FLA_Error FLA_Dotcs( FLA_Conj conj, FLA_Obj alpha, FLA_Obj x, FLA_Obj y, FLA_Obj beta, FLA_Obj rho );
FLA_Error FLA_Dots( FLA_Obj alpha, FLA_Obj x, FLA_Obj y, FLA_Obj beta, FLA_Obj rho );
FLA_Error FLA_Amax( FLA_Obj x, FLA_Obj index );
FLA_Error FLA_Inv_scal( FLA_Obj alpha, FLA_Obj A );
FLA_Error FLA_Inv_scalc( FLA_Conj conjalpha, FLA_Obj alpha, FLA_Obj A );
FLA_Error FLA_Nrm2( FLA_Obj x, FLA_Obj norm_x );
FLA_Error FLA_Scal( FLA_Obj alpha, FLA_Obj A );
FLA_Error FLA_Scalc( FLA_Conj conjalpha, FLA_Obj alpha, FLA_Obj A );
FLA_Error FLA_Scalr( FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj A );
FLA_Error FLA_Swap( FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Swapt( FLA_Trans trans, FLA_Obj A, FLA_Obj B );


// --- task wrapper prototypes -------------------------------------------------

FLA_Error FLA_Axpy_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_axpy_t* cntl );
FLA_Error FLA_Axpyt_task( FLA_Trans trans, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_axpyt_t* cntl );
FLA_Error FLA_Copy_task( FLA_Obj A, FLA_Obj B, fla_copy_t* cntl );
FLA_Error FLA_Copyt_task( FLA_Trans trans, FLA_Obj A, FLA_Obj B, fla_copyt_t* cntl );
FLA_Error FLA_Copyr_task( FLA_Uplo uplo, FLA_Obj A, FLA_Obj B, fla_copyr_t* cntl );
FLA_Error FLA_Scal_task( FLA_Obj alpha, FLA_Obj A, fla_scal_t* cntl );
FLA_Error FLA_Scalr_task( FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj A, fla_scalr_t* cntl );

FLA_Error FLA_Axpyt_n_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_axpyt_t* cntl );
FLA_Error FLA_Axpyt_t_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_axpyt_t* cntl );
FLA_Error FLA_Axpyt_c_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_axpyt_t* cntl );
FLA_Error FLA_Axpyt_h_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_axpyt_t* cntl );

FLA_Error FLA_Copyt_n_task( FLA_Obj A, FLA_Obj B, fla_copyt_t* cntl );
FLA_Error FLA_Copyt_t_task( FLA_Obj A, FLA_Obj B, fla_copyt_t* cntl );
FLA_Error FLA_Copyt_c_task( FLA_Obj A, FLA_Obj B, fla_copyt_t* cntl );
FLA_Error FLA_Copyt_h_task( FLA_Obj A, FLA_Obj B, fla_copyt_t* cntl );

FLA_Error FLA_Copyr_l_task( FLA_Obj A, FLA_Obj B, fla_copyr_t* cntl );
FLA_Error FLA_Copyr_u_task( FLA_Obj A, FLA_Obj B, fla_copyr_t* cntl );

FLA_Error FLA_Scalr_l_task( FLA_Obj alpha, FLA_Obj A, fla_scalr_t* cntl );
FLA_Error FLA_Scalr_u_task( FLA_Obj alpha, FLA_Obj A, fla_scalr_t* cntl );


// --- external wrapper prototypes ---------------------------------------------

FLA_Error FLA_Asum_external( FLA_Obj x, FLA_Obj asum_x );
FLA_Error FLA_Axpy_external( FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Axpys_external( FLA_Obj alpha0, FLA_Obj alpha1, FLA_Obj A, FLA_Obj beta, FLA_Obj B );
FLA_Error FLA_Axpyt_external( FLA_Trans trans, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Axpyrt_external( FLA_Uplo uplo, FLA_Trans trans, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Copy_external( FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Copyr_external( FLA_Uplo uplo, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Copyrt_external( FLA_Uplo uplo, FLA_Trans trans, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Copyt_external( FLA_Trans trans, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Dot_external( FLA_Obj x, FLA_Obj y, FLA_Obj rho );
FLA_Error FLA_Dotc_external( FLA_Conj conj, FLA_Obj x, FLA_Obj y, FLA_Obj rho );
FLA_Error FLA_Dots_external( FLA_Obj alpha, FLA_Obj x, FLA_Obj y, FLA_Obj beta, FLA_Obj rho );
FLA_Error FLA_Dotcs_external( FLA_Conj conj, FLA_Obj alpha, FLA_Obj x, FLA_Obj y, FLA_Obj beta, FLA_Obj rho );
FLA_Error FLA_Dot2s_external( FLA_Obj alpha, FLA_Obj x, FLA_Obj y, FLA_Obj beta, FLA_Obj rho );
FLA_Error FLA_Dot2cs_external( FLA_Conj conj, FLA_Obj alpha, FLA_Obj x, FLA_Obj y, FLA_Obj beta, FLA_Obj rho );
FLA_Error FLA_Amax_external( FLA_Obj x, FLA_Obj index );
FLA_Error FLA_Inv_scal_external( FLA_Obj alpha, FLA_Obj A );
FLA_Error FLA_Inv_scalc_external( FLA_Conj conjalpha, FLA_Obj alpha, FLA_Obj A );
FLA_Error FLA_Nrm2_external( FLA_Obj x, FLA_Obj nrm_x );
FLA_Error FLA_Scal_external( FLA_Obj alpha, FLA_Obj A );
FLA_Error FLA_Scalc_external( FLA_Conj conjalpha, FLA_Obj alpha, FLA_Obj A );
FLA_Error FLA_Scalr_external( FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj A );
FLA_Error FLA_Swap_external( FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Swapt_external( FLA_Trans trans, FLA_Obj A, FLA_Obj B );


// --- gpu wrapper prototypes --------------------------------------------------

FLA_Error FLA_Axpy_external_gpu( FLA_Obj alpha, FLA_Obj A, void* A_gpu, FLA_Obj B, void* B_gpu );
FLA_Error FLA_Copy_external_gpu( FLA_Obj A, void* A_gpu, FLA_Obj B, void* B_gpu );
FLA_Error FLA_Scal_external_gpu( FLA_Obj alpha, FLA_Obj A, void* A_gpu );
FLA_Error FLA_Scalr_external_gpu( FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj A, void* A_gpu );


// --- check routine prototypes ------------------------------------------------

// front-ends
FLA_Error FLA_Asum_check( FLA_Obj x, FLA_Obj asum_x );
FLA_Error FLA_Axpy_check( FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Axpys_check( FLA_Obj alpha0, FLA_Obj alpha1, FLA_Obj A, FLA_Obj beta, FLA_Obj B );
FLA_Error FLA_Axpyt_check( FLA_Trans trans, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Axpyrt_check( FLA_Uplo uplo, FLA_Trans trans, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Copy_check( FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Copyr_check( FLA_Uplo uplo, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Copyrt_check( FLA_Uplo uplo, FLA_Trans trans, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Copyt_check( FLA_Trans trans, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Dot_check( FLA_Obj x, FLA_Obj y, FLA_Obj rho );
FLA_Error FLA_Dotc_check( FLA_Conj conj, FLA_Obj x, FLA_Obj y, FLA_Obj rho );
FLA_Error FLA_Dots_check( FLA_Obj alpha, FLA_Obj x, FLA_Obj y, FLA_Obj beta, FLA_Obj rho );
FLA_Error FLA_Dotcs_check( FLA_Conj conj, FLA_Obj alpha, FLA_Obj x, FLA_Obj y, FLA_Obj beta, FLA_Obj rho );
FLA_Error FLA_Dot2s_check( FLA_Obj alpha, FLA_Obj x, FLA_Obj y, FLA_Obj beta, FLA_Obj rho );
FLA_Error FLA_Dot2cs_check( FLA_Conj conj, FLA_Obj alpha, FLA_Obj x, FLA_Obj y, FLA_Obj beta, FLA_Obj rho );
FLA_Error FLA_Amax_check( FLA_Obj x, FLA_Obj index );
FLA_Error FLA_Inv_scal_check( FLA_Obj alpha, FLA_Obj A );
FLA_Error FLA_Inv_scalc_check( FLA_Conj conjalpha, FLA_Obj alpha, FLA_Obj A );
FLA_Error FLA_Nrm2_check( FLA_Obj x, FLA_Obj nrm_x );
FLA_Error FLA_Scal_check( FLA_Obj alpha, FLA_Obj A );
FLA_Error FLA_Scalc_check( FLA_Conj conjalpha, FLA_Obj alpha, FLA_Obj A );
FLA_Error FLA_Scalr_check( FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj A );
FLA_Error FLA_Swap_check( FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Swapt_check( FLA_Trans trans, FLA_Obj A, FLA_Obj B );

// internal back-ends
FLA_Error FLA_Axpy_internal_check( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_axpy_t* cntl );
FLA_Error FLA_Axpyt_internal_check( FLA_Trans trans, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_axpyt_t* cntl );
FLA_Error FLA_Copy_internal_check( FLA_Obj A, FLA_Obj B, fla_copy_t* cntl );
FLA_Error FLA_Copyt_internal_check( FLA_Trans trans, FLA_Obj A, FLA_Obj B, fla_copyt_t* cntl );
FLA_Error FLA_Copyr_internal_check( FLA_Uplo uplo, FLA_Obj A, FLA_Obj B, fla_copyr_t* cntl );
FLA_Error FLA_Scal_internal_check( FLA_Obj alpha, FLA_Obj A, fla_scal_t* cntl );
FLA_Error FLA_Scalr_internal_check( FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj A, fla_scalr_t* cntl );

// end FLA_blas1_prototypes.h
// begin FLA_blas2_prototypes.h


// --- top-level wrapper prototypes --------------------------------------------

FLA_Error FLA_Gemv( FLA_Trans transa, FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y );
FLA_Error FLA_Gemvc( FLA_Trans transa, FLA_Conj conjx, FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y );
FLA_Error FLA_Ger( FLA_Obj alpha, FLA_Obj x, FLA_Obj y, FLA_Obj A );
FLA_Error FLA_Gerc( FLA_Conj conjx, FLA_Conj conjy, FLA_Obj alpha, FLA_Obj x, FLA_Obj y, FLA_Obj A );
FLA_Error FLA_Hemv( FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y );
FLA_Error FLA_Hemvc( FLA_Uplo uplo, FLA_Conj conja, FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y );
FLA_Error FLA_Her( FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj x, FLA_Obj A );
FLA_Error FLA_Herc( FLA_Uplo uplo, FLA_Conj conj, FLA_Obj alpha, FLA_Obj x, FLA_Obj A );
FLA_Error FLA_Her2( FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj x, FLA_Obj y, FLA_Obj A );
FLA_Error FLA_Her2c( FLA_Uplo uplo, FLA_Conj conj, FLA_Obj alpha, FLA_Obj x, FLA_Obj y, FLA_Obj A );
FLA_Error FLA_Symv( FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y );
FLA_Error FLA_Syr( FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj x, FLA_Obj A );
FLA_Error FLA_Syr2( FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj x, FLA_Obj y, FLA_Obj A );
FLA_Error FLA_Trmv( FLA_Uplo uplo, FLA_Trans transa, FLA_Diag diag, FLA_Obj A, FLA_Obj x );
FLA_Error FLA_Trmvsx( FLA_Uplo uplo, FLA_Trans transa, FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y );
FLA_Error FLA_Trsv( FLA_Uplo uplo, FLA_Trans transa, FLA_Diag diag, FLA_Obj A, FLA_Obj x );
FLA_Error FLA_Trsvsx( FLA_Uplo uplo, FLA_Trans transa, FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y );


// --- task wrapper prototypes -------------------------------------------------

FLA_Error FLA_Gemv_task( FLA_Trans transa, FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y, fla_gemv_t* cntl );
FLA_Error FLA_Trsv_task( FLA_Uplo uplo, FLA_Trans transa, FLA_Diag diag, FLA_Obj A, FLA_Obj x, fla_trsv_t* cntl );

FLA_Error FLA_Gemv_h_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y, fla_gemv_t* cntl );
FLA_Error FLA_Gemv_n_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y, fla_gemv_t* cntl );
FLA_Error FLA_Gemv_t_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y, fla_gemv_t* cntl );

FLA_Error FLA_Trsv_lc_task( FLA_Diag diag, FLA_Obj A, FLA_Obj x, fla_trsv_t* cntl );
FLA_Error FLA_Trsv_ln_task( FLA_Diag diag, FLA_Obj A, FLA_Obj x, fla_trsv_t* cntl );
FLA_Error FLA_Trsv_lt_task( FLA_Diag diag, FLA_Obj A, FLA_Obj x, fla_trsv_t* cntl );
FLA_Error FLA_Trsv_uc_task( FLA_Diag diag, FLA_Obj A, FLA_Obj x, fla_trsv_t* cntl );
FLA_Error FLA_Trsv_un_task( FLA_Diag diag, FLA_Obj A, FLA_Obj x, fla_trsv_t* cntl );
FLA_Error FLA_Trsv_ut_task( FLA_Diag diag, FLA_Obj A, FLA_Obj x, fla_trsv_t* cntl );


// --- external wrapper prototypes ---------------------------------------------

FLA_Error FLA_Gemv_external( FLA_Trans transa, FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y );
FLA_Error FLA_Gemvc_external( FLA_Trans transa, FLA_Conj conjx, FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y );
FLA_Error FLA_Ger_external( FLA_Obj alpha, FLA_Obj x, FLA_Obj y, FLA_Obj A );
FLA_Error FLA_Gerc_external( FLA_Conj conjx, FLA_Conj conjy, FLA_Obj alpha, FLA_Obj x, FLA_Obj y, FLA_Obj A );
FLA_Error FLA_Hemv_external( FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y );
FLA_Error FLA_Hemvc_external( FLA_Uplo uplo, FLA_Conj conja, FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y );
FLA_Error FLA_Her_external( FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj x, FLA_Obj A );
FLA_Error FLA_Herc_external( FLA_Uplo uplo, FLA_Conj conj, FLA_Obj alpha, FLA_Obj x, FLA_Obj A );
FLA_Error FLA_Her2_external( FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj x, FLA_Obj y, FLA_Obj A );
FLA_Error FLA_Her2c_external( FLA_Uplo uplo, FLA_Conj conj, FLA_Obj alpha, FLA_Obj x, FLA_Obj y, FLA_Obj A );
FLA_Error FLA_Symv_external( FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y );
FLA_Error FLA_Syr_external( FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj x, FLA_Obj A );
FLA_Error FLA_Syr2_external( FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj x, FLA_Obj y, FLA_Obj A );
FLA_Error FLA_Trmv_external( FLA_Uplo uplo, FLA_Trans transa, FLA_Diag diag, FLA_Obj A, FLA_Obj x );
FLA_Error FLA_Trmvsx_external( FLA_Uplo uplo, FLA_Trans transa, FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y );
FLA_Error FLA_Trsv_external( FLA_Uplo uplo, FLA_Trans transa, FLA_Diag diag, FLA_Obj A, FLA_Obj x );
FLA_Error FLA_Trsvsx_external( FLA_Uplo uplo, FLA_Trans transa, FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y );


// --- gpu wrapper prototypes --------------------------------------------------

FLA_Error FLA_Gemv_external_gpu( FLA_Trans transa, FLA_Obj alpha, FLA_Obj A, void* A_gpu, FLA_Obj x, void* x_gpu, FLA_Obj beta, FLA_Obj y, void* y_gpu );
FLA_Error FLA_Trsv_external_gpu( FLA_Uplo uplo, FLA_Trans transa, FLA_Diag diag, FLA_Obj A, void* A_gpu, FLA_Obj x, void* x_gpu );


// --- check routine prototypes ------------------------------------------------

// front-ends
FLA_Error FLA_Gemv_check( FLA_Trans transa, FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y );
FLA_Error FLA_Gemvc_check( FLA_Trans transa, FLA_Conj conjx, FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y );
FLA_Error FLA_Ger_check( FLA_Obj alpha, FLA_Obj x, FLA_Obj y, FLA_Obj A );
FLA_Error FLA_Gerc_check( FLA_Conj conjx, FLA_Conj conjy, FLA_Obj alpha, FLA_Obj x, FLA_Obj y, FLA_Obj A );
FLA_Error FLA_Hemv_check( FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y );
FLA_Error FLA_Hemvc_check( FLA_Uplo uplo, FLA_Conj conja, FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y );
FLA_Error FLA_Her_check( FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj x, FLA_Obj A );
FLA_Error FLA_Herc_check( FLA_Uplo uplo, FLA_Conj conj, FLA_Obj alpha, FLA_Obj x, FLA_Obj A );
FLA_Error FLA_Her2_check( FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj x, FLA_Obj y, FLA_Obj A );
FLA_Error FLA_Her2c_check( FLA_Uplo uplo, FLA_Conj conj, FLA_Obj alpha, FLA_Obj x, FLA_Obj y, FLA_Obj A );
FLA_Error FLA_Symv_check( FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y );
FLA_Error FLA_Syr_check( FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj x, FLA_Obj A );
FLA_Error FLA_Syr2_check( FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj x, FLA_Obj y, FLA_Obj A );
FLA_Error FLA_Trmv_check( FLA_Uplo uplo, FLA_Trans transa, FLA_Diag diag, FLA_Obj A, FLA_Obj x );
FLA_Error FLA_Trmvsx_check( FLA_Uplo uplo, FLA_Trans transa, FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y );
FLA_Error FLA_Trsv_check( FLA_Uplo uplo, FLA_Trans transa, FLA_Diag diag, FLA_Obj A, FLA_Obj x );
FLA_Error FLA_Trsvsx_check( FLA_Uplo uplo, FLA_Trans transa, FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y );

// internal back-ends
FLA_Error FLA_Gemv_internal_check( FLA_Trans transa, FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y, fla_gemv_t* cntl );
FLA_Error FLA_Trsv_internal_check( FLA_Uplo uplo, FLA_Trans transa, FLA_Diag diag, FLA_Obj A, FLA_Obj x, fla_trsv_t* cntl );

// end FLA_blas2_prototypes.h
// begin FLA_blas3_prototypes.h


// --- top-level wrapper prototypes --------------------------------------------

FLA_Error FLA_Gemm( FLA_Trans transa, FLA_Trans transb, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Hemm( FLA_Side side, FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Herk( FLA_Uplo uplo, FLA_Trans trans, FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Her2k( FLA_Uplo uplo, FLA_Trans trans, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Symm( FLA_Side side, FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syrk( FLA_Uplo uplo, FLA_Trans trans, FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k( FLA_Uplo uplo, FLA_Trans trans, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Trmm( FLA_Side side, FLA_Uplo uplo, FLA_Trans trans, FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmmsx( FLA_Side side, FLA_Uplo uplo, FLA_Trans transa, FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Trsm( FLA_Side side, FLA_Uplo uplo, FLA_Trans trans, FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsmsx( FLA_Side side, FLA_Uplo uplo, FLA_Trans transa, FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );

FLA_Error FLA_Gemp( FLA_Trans transa, FLA_Trans transb, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gepm( FLA_Trans transa, FLA_Trans transb, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gepp( FLA_Trans transa, FLA_Trans transb, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );


// --- task wrapper prototypes -------------------------------------------------

FLA_Error FLA_Gemm_task( FLA_Trans transa, FLA_Trans transb, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Hemm_task( FLA_Side side, FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Herk_task( FLA_Uplo uplo, FLA_Trans trans, FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_herk_t* cntl );
FLA_Error FLA_Her2k_task( FLA_Uplo uplo, FLA_Trans trans, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Symm_task( FLA_Side side, FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Syrk_task( FLA_Uplo uplo, FLA_Trans trans, FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_syrk_t* cntl );
FLA_Error FLA_Syr2k_task( FLA_Uplo uplo, FLA_Trans trans, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Trmm_task( FLA_Side side, FLA_Uplo uplo, FLA_Trans trans, FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trsm_task( FLA_Side side, FLA_Uplo uplo, FLA_Trans trans, FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );

FLA_Error FLA_Gemm_cc_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_ch_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_cn_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_ct_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_hc_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_hh_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_hn_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_ht_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_nc_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_nh_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_nn_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_nt_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_tc_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_th_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_tn_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_tt_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );

FLA_Error FLA_Hemm_ll_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_lu_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_rl_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_ru_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );

FLA_Error FLA_Her2k_ln_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_lh_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_un_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_uh_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );

FLA_Error FLA_Herk_ln_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_herk_t* cntl );
FLA_Error FLA_Herk_lh_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_herk_t* cntl );
FLA_Error FLA_Herk_un_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_herk_t* cntl );
FLA_Error FLA_Herk_uh_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_herk_t* cntl );

FLA_Error FLA_Symm_ll_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_lu_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_rl_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_ru_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );

FLA_Error FLA_Syr2k_ln_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_lt_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_un_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_ut_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );

FLA_Error FLA_Syrk_ln_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_syrk_t* cntl );
FLA_Error FLA_Syrk_lt_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_syrk_t* cntl );
FLA_Error FLA_Syrk_un_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_syrk_t* cntl );
FLA_Error FLA_Syrk_ut_task( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_syrk_t* cntl );

FLA_Error FLA_Trmm_llc_task( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_llh_task( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_lln_task( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_llt_task( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_luc_task( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_luh_task( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_lun_task( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_lut_task( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_rlc_task( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_rlh_task( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_rln_task( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_rlt_task( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_ruc_task( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_ruh_task( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_run_task( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_rut_task( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );

FLA_Error FLA_Trsm_llc_task( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_llh_task( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_lln_task( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_llt_task( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_luc_task( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_luh_task( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_lun_task( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_lut_task( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_rlc_task( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_rlh_task( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_rln_task( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_rlt_task( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_ruc_task( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_ruh_task( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_run_task( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_rut_task( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );


// --- external wrapper prototypes ---------------------------------------------

FLA_Error FLA_Gemm_external( FLA_Trans transa, FLA_Trans transb, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Hemm_external( FLA_Side side, FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Herk_external( FLA_Uplo uplo, FLA_Trans trans, FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Her2k_external( FLA_Uplo uplo, FLA_Trans trans, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Symm_external( FLA_Side side, FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syrk_external( FLA_Uplo uplo, FLA_Trans trans, FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k_external( FLA_Uplo uplo, FLA_Trans trans, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Trmm_external( FLA_Side side, FLA_Uplo uplo, FLA_Trans trans, FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_external( FLA_Side side, FLA_Uplo uplo, FLA_Trans trans, FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );

FLA_Error FLA_Trmmsx_external( FLA_Side side, FLA_Uplo uplo, FLA_Trans transa, FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Trsmsx_external( FLA_Side side, FLA_Uplo uplo, FLA_Trans transa, FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );


// --- gpu wrapper prototypes --------------------------------------------------

FLA_Error FLA_Gemm_external_gpu( FLA_Trans transa, FLA_Trans transb, FLA_Obj alpha, FLA_Obj A, void* A_gpu, FLA_Obj B, void* B_gpu, FLA_Obj beta, FLA_Obj C, void* C_gpu );
FLA_Error FLA_Hemm_external_gpu( FLA_Side side, FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj A, void* A_gpu, FLA_Obj B, void* B_gpu, FLA_Obj beta, FLA_Obj C, void* C_gpu );
FLA_Error FLA_Herk_external_gpu( FLA_Uplo uplo, FLA_Trans trans, FLA_Obj alpha, FLA_Obj A, void* A_gpu, FLA_Obj beta, FLA_Obj C, void* C_gpu );
FLA_Error FLA_Her2k_external_gpu( FLA_Uplo uplo, FLA_Trans trans, FLA_Obj alpha, FLA_Obj A, void* A_gpu, FLA_Obj B, void* B_gpu, FLA_Obj beta, FLA_Obj C, void* C_gpu );
FLA_Error FLA_Symm_external_gpu( FLA_Side side, FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj A, void* A_gpu, FLA_Obj B, void* B_gpu, FLA_Obj beta, FLA_Obj C, void* C_gpu );
FLA_Error FLA_Syrk_external_gpu( FLA_Uplo uplo, FLA_Trans trans, FLA_Obj alpha, FLA_Obj A, void* A_gpu, FLA_Obj beta, FLA_Obj C, void* C_gpu );
FLA_Error FLA_Syr2k_external_gpu( FLA_Uplo uplo, FLA_Trans trans, FLA_Obj alpha, FLA_Obj A, void* A_gpu, FLA_Obj B, void* B_gpu, FLA_Obj beta, FLA_Obj C, void* C_gpu );
FLA_Error FLA_Trmm_external_gpu( FLA_Side side, FLA_Uplo uplo, FLA_Trans trans, FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, void* A_gpu, FLA_Obj B, void* B_gpu );
FLA_Error FLA_Trsm_external_gpu( FLA_Side side, FLA_Uplo uplo, FLA_Trans trans, FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, void* A_gpu, FLA_Obj B, void* B_gpu );


// --- check routine prototypes ------------------------------------------------

// front-ends
FLA_Error FLA_Gemm_check( FLA_Trans transa, FLA_Trans transb, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj  beta, FLA_Obj C );
FLA_Error FLA_Hemm_check( FLA_Side side, FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta,  FLA_Obj C );
FLA_Error FLA_Her2k_check( FLA_Uplo uplo, FLA_Trans trans, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta,  FLA_Obj C );
FLA_Error FLA_Herk_check( FLA_Uplo uplo, FLA_Trans trans, FLA_Obj alpha, FLA_Obj A, FLA_Obj beta,  FLA_Obj C );
FLA_Error FLA_Symm_check( FLA_Side side, FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k_check( FLA_Uplo uplo, FLA_Trans trans, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta,  FLA_Obj C );
FLA_Error FLA_Syrk_check( FLA_Uplo uplo, FLA_Trans trans, FLA_Obj alpha, FLA_Obj A, FLA_Obj beta,  FLA_Obj C );
FLA_Error FLA_Trmm_check( FLA_Side side, FLA_Uplo uplo, FLA_Trans transa, FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmmsx_check( FLA_Side side, FLA_Uplo uplo, FLA_Trans transa, FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Trsm_check( FLA_Side side, FLA_Uplo uplo, FLA_Trans transa, FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsmsx_check( FLA_Side side, FLA_Uplo uplo, FLA_Trans transa, FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );

// internal back-ends
FLA_Error FLA_Gemm_internal_check( FLA_Trans transa, FLA_Trans transb, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Hemm_internal_check( FLA_Side side, FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Herk_internal_check( FLA_Uplo uplo, FLA_Trans trans, FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_herk_t* cntl );
FLA_Error FLA_Her2k_internal_check( FLA_Uplo uplo, FLA_Trans trans, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Symm_internal_check( FLA_Side side, FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Syrk_internal_check( FLA_Uplo uplo, FLA_Trans trans, FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_syrk_t* cntl );
FLA_Error FLA_Syr2k_internal_check( FLA_Uplo uplo, FLA_Trans trans, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Trmm_internal_check( FLA_Side side, FLA_Uplo uplo, FLA_Trans trans, FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trsm_internal_check( FLA_Side side, FLA_Uplo uplo, FLA_Trans trans, FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );

// end FLA_blas3_prototypes.h
// begin FLA_lapack_prototypes.h


// --- top-level wrapper prototypes --------------------------------------------

FLA_Error FLA_Chol( FLA_Uplo uplo, FLA_Obj A );
FLA_Error FLA_LU_nopiv( FLA_Obj A );
FLA_Error FLA_LU_piv( FLA_Obj A, FLA_Obj p );
FLA_Error FLA_QR_UT( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_QR_UT_piv( FLA_Obj A, FLA_Obj T, FLA_Obj w, FLA_Obj p );
FLA_Error FLA_LQ_UT( FLA_Obj A, FLA_Obj S );
FLA_Error FLA_Trinv( FLA_Uplo uplo, FLA_Diag diag, FLA_Obj A );
FLA_Error FLA_Ttmm( FLA_Uplo uplo, FLA_Obj A );
FLA_Error FLA_Sylv( FLA_Trans transa, FLA_Trans transb, FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_SPDinv( FLA_Uplo uplo, FLA_Obj A );
FLA_Error FLA_Hess_UT( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Eig_gest( FLA_Inv inv, FLA_Uplo uplo, FLA_Obj A, FLA_Obj B );

FLA_Error FLA_Accum_T_UT( FLA_Direct direct, FLA_Store storev, FLA_Obj A, FLA_Obj tau, FLA_Obj T );
FLA_Error FLA_Apply_H2_UT( FLA_Side side, FLA_Obj tau, FLA_Obj u2, FLA_Obj a1, FLA_Obj A2 );
FLA_Error FLA_Apply_HUD_UT( FLA_Side side, FLA_Obj tau, FLA_Obj w12t, FLA_Obj u2, FLA_Obj v2, FLA_Obj r12t, FLA_Obj C2, FLA_Obj D2 );
FLA_Error FLA_Apply_Q_UT( FLA_Side side, FLA_Trans trans, FLA_Direct direct, FLA_Store storev, FLA_Obj A, FLA_Obj T, FLA_Obj W, FLA_Obj B );
FLA_Error FLA_Apply_pivots( FLA_Side side, FLA_Trans trans, FLA_Obj p, FLA_Obj A );

// --- task wrapper prototypes -------------------------------------------------

FLA_Error FLA_Chol_task( FLA_Uplo uplo, FLA_Obj A, fla_chol_t* cntl );
FLA_Error FLA_Chol_l_task( FLA_Obj A, fla_chol_t* cntl );
FLA_Error FLA_Chol_u_task( FLA_Obj A, fla_chol_t* cntl );
FLA_Error FLA_LU_piv_macro_task( FLA_Obj A, FLA_Obj p, fla_lu_t* cntl );
FLA_Error FLA_Apply_pivots_task( FLA_Side side, FLA_Trans trans, FLA_Obj p, FLA_Obj A, fla_appiv_t* cntl );
FLA_Error FLA_Apply_pivots_ln_task( FLA_Obj p, FLA_Obj A, fla_appiv_t* cntl );
FLA_Error FLA_Apply_pivots_macro_task( FLA_Side side, FLA_Trans trans, FLA_Obj p, FLA_Obj A, fla_appiv_t* cntl );
FLA_Error FLA_LU_nopiv_task( FLA_Obj A, fla_lu_t* cntl );
FLA_Error FLA_LU_piv_task( FLA_Obj A, FLA_Obj p, fla_lu_t* cntl );
FLA_Error FLA_LU_piv_copy_task( FLA_Obj A, FLA_Obj p, FLA_Obj U, fla_lu_t* cntl );
FLA_Error FLA_Trsm_piv_task( FLA_Obj A, FLA_Obj B, FLA_Obj p, fla_trsm_t* cntl );
FLA_Error FLA_SA_LU_task( FLA_Obj U, FLA_Obj D, FLA_Obj p, FLA_Obj L, fla_dim_t nb_alg, fla_lu_t* cntl );
FLA_Error FLA_SA_FS_task( FLA_Obj L, FLA_Obj D, FLA_Obj p, FLA_Obj C, FLA_Obj E, fla_dim_t nb_alg, fla_gemm_t* cntl );
FLA_Error FLA_Trinv_task( FLA_Uplo uplo, FLA_Diag diag, FLA_Obj A, fla_trinv_t* cntl );
FLA_Error FLA_Trinv_ln_task( FLA_Obj A, fla_trinv_t* cntl );
FLA_Error FLA_Trinv_lu_task( FLA_Obj A, fla_trinv_t* cntl );
FLA_Error FLA_Trinv_un_task( FLA_Obj A, fla_trinv_t* cntl );
FLA_Error FLA_Trinv_uu_task( FLA_Obj A, fla_trinv_t* cntl );
FLA_Error FLA_Ttmm_task( FLA_Uplo uplo, FLA_Obj A, fla_ttmm_t* cntl );
FLA_Error FLA_Ttmm_l_task( FLA_Obj A, fla_ttmm_t* cntl );
FLA_Error FLA_Ttmm_u_task( FLA_Obj A, fla_ttmm_t* cntl );
FLA_Error FLA_Sylv_task( FLA_Trans transa, FLA_Trans transb, FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_nn_task( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_nh_task( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_hn_task( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_hh_task( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Lyap_task( FLA_Trans trans, FLA_Obj isgn, FLA_Obj A, FLA_Obj C, FLA_Obj scale, fla_lyap_t* cntl );
FLA_Error FLA_Lyap_n_task( FLA_Obj isgn, FLA_Obj A, FLA_Obj C, FLA_Obj scale, fla_lyap_t* cntl );
FLA_Error FLA_Lyap_h_task( FLA_Obj isgn, FLA_Obj A, FLA_Obj C, FLA_Obj scale, fla_lyap_t* cntl );
FLA_Error FLA_Apply_Q_UT_task( FLA_Side side, FLA_Trans trans, FLA_Direct direct, FLA_Store storev, FLA_Obj A, FLA_Obj T, FLA_Obj W, FLA_Obj B, fla_apqut_t* cntl );
FLA_Error FLA_Apply_Q_UT_lhbc_task( FLA_Obj A, FLA_Obj T, FLA_Obj W, FLA_Obj B, fla_apqut_t* cntl );
FLA_Error FLA_Apply_Q_UT_lhbr_task( FLA_Obj A, FLA_Obj T, FLA_Obj W, FLA_Obj B, fla_apqut_t* cntl );
FLA_Error FLA_Apply_Q_UT_lhfc_task( FLA_Obj A, FLA_Obj T, FLA_Obj W, FLA_Obj B, fla_apqut_t* cntl );
FLA_Error FLA_Apply_Q_UT_lhfr_task( FLA_Obj A, FLA_Obj T, FLA_Obj W, FLA_Obj B, fla_apqut_t* cntl );
FLA_Error FLA_Apply_Q_UT_lnbc_task( FLA_Obj A, FLA_Obj T, FLA_Obj W, FLA_Obj B, fla_apqut_t* cntl );
FLA_Error FLA_Apply_Q_UT_lnbr_task( FLA_Obj A, FLA_Obj T, FLA_Obj W, FLA_Obj B, fla_apqut_t* cntl );
FLA_Error FLA_Apply_Q_UT_lnfc_task( FLA_Obj A, FLA_Obj T, FLA_Obj W, FLA_Obj B, fla_apqut_t* cntl );
FLA_Error FLA_Apply_Q_UT_lnfr_task( FLA_Obj A, FLA_Obj T, FLA_Obj W, FLA_Obj B, fla_apqut_t* cntl );
FLA_Error FLA_Apply_Q_UT_rhbc_task( FLA_Obj A, FLA_Obj T, FLA_Obj W, FLA_Obj B, fla_apqut_t* cntl );
FLA_Error FLA_Apply_Q_UT_rhbr_task( FLA_Obj A, FLA_Obj T, FLA_Obj W, FLA_Obj B, fla_apqut_t* cntl );
FLA_Error FLA_Apply_Q_UT_rhfc_task( FLA_Obj A, FLA_Obj T, FLA_Obj W, FLA_Obj B, fla_apqut_t* cntl );
FLA_Error FLA_Apply_Q_UT_rhfr_task( FLA_Obj A, FLA_Obj T, FLA_Obj W, FLA_Obj B, fla_apqut_t* cntl );
FLA_Error FLA_Apply_Q_UT_rnbc_task( FLA_Obj A, FLA_Obj T, FLA_Obj W, FLA_Obj B, fla_apqut_t* cntl );
FLA_Error FLA_Apply_Q_UT_rnbr_task( FLA_Obj A, FLA_Obj T, FLA_Obj W, FLA_Obj B, fla_apqut_t* cntl );
FLA_Error FLA_Apply_Q_UT_rnfc_task( FLA_Obj A, FLA_Obj T, FLA_Obj W, FLA_Obj B, fla_apqut_t* cntl );
FLA_Error FLA_Apply_Q_UT_rnfr_task( FLA_Obj A, FLA_Obj T, FLA_Obj W, FLA_Obj B, fla_apqut_t* cntl );
FLA_Error FLA_Apply_Q2_UT_task( FLA_Side side, FLA_Trans trans, FLA_Direct direct, FLA_Store storev, FLA_Obj D, FLA_Obj T, FLA_Obj W, FLA_Obj C, FLA_Obj E, fla_apq2ut_t* cntl );
FLA_Error FLA_Apply_Q2_UT_lhfc_task( FLA_Obj D, FLA_Obj T, FLA_Obj W, FLA_Obj C, FLA_Obj E, fla_apq2ut_t* cntl );
FLA_Error FLA_Apply_CAQ2_UT_task( FLA_Side side, FLA_Trans trans, FLA_Direct direct, FLA_Store storev, FLA_Obj D, FLA_Obj T, FLA_Obj W, FLA_Obj C, FLA_Obj E, fla_apcaq2ut_t* cntl );
FLA_Error FLA_Apply_CAQ2_UT_lhfc_task( FLA_Obj D, FLA_Obj T, FLA_Obj W, FLA_Obj C, FLA_Obj E, fla_apcaq2ut_t* cntl );
FLA_Error FLA_QR2_UT_task( FLA_Obj B, FLA_Obj D, FLA_Obj T, fla_qr2ut_t* cntl );
FLA_Error FLA_CAQR2_UT_task( FLA_Obj B, FLA_Obj D, FLA_Obj T, fla_caqr2ut_t* cntl );
FLA_Error FLA_QR_UT_macro_task( FLA_Obj A, FLA_Obj T, fla_qrut_t* cntl );
FLA_Error FLA_QR_UT_task( FLA_Obj A, FLA_Obj T, fla_qrut_t* cntl );
FLA_Error FLA_QR_UT_copy_task( FLA_Obj A, FLA_Obj T, FLA_Obj U, fla_qrut_t* cntl );
FLA_Error FLA_LQ_UT_macro_task( FLA_Obj A, FLA_Obj T, fla_lqut_t* cntl );
FLA_Error FLA_LQ_UT_task( FLA_Obj A, FLA_Obj T, fla_lqut_t* cntl );
FLA_Error FLA_UDdate_UT_task( FLA_Obj R, FLA_Obj C, FLA_Obj D, FLA_Obj T, fla_uddateut_t* cntl );
FLA_Error FLA_Apply_QUD_UT_task( FLA_Side side, FLA_Trans trans, FLA_Direct direct, FLA_Store storev, FLA_Obj T, FLA_Obj W, FLA_Obj R, FLA_Obj U, FLA_Obj C, FLA_Obj V, FLA_Obj D, fla_apqudut_t* cntl );
FLA_Error FLA_Apply_QUD_UT_lhfc_task( FLA_Obj T, FLA_Obj W, FLA_Obj R, FLA_Obj U, FLA_Obj C, FLA_Obj V, FLA_Obj D, fla_apqudut_t* cntl );
FLA_Error FLA_Eig_gest_task( FLA_Inv inv, FLA_Uplo uplo, FLA_Obj A, FLA_Obj Y, FLA_Obj B, fla_eig_gest_t* cntl );
FLA_Error FLA_Eig_gest_il_task( FLA_Obj A, FLA_Obj Y, FLA_Obj B, fla_eig_gest_t* cntl );
FLA_Error FLA_Eig_gest_iu_task( FLA_Obj A, FLA_Obj Y, FLA_Obj B, fla_eig_gest_t* cntl );
FLA_Error FLA_Eig_gest_nl_task( FLA_Obj A, FLA_Obj Y, FLA_Obj B, fla_eig_gest_t* cntl );
FLA_Error FLA_Eig_gest_nu_task( FLA_Obj A, FLA_Obj Y, FLA_Obj B, fla_eig_gest_t* cntl );

// --- external wrapper prototypes ---------------------------------------------

FLA_Error FLA_Apply_Q_blk_external( FLA_Side side, FLA_Trans trans, FLA_Store storev, FLA_Obj A, FLA_Obj t, FLA_Obj B );

FLA_Error FLA_Apply_pivots_unb_external( FLA_Side side, FLA_Trans trans, FLA_Obj p, FLA_Obj A );
FLA_Error FLA_Apply_pivots_ln_unb_ext( FLA_Obj p, FLA_Obj A );

FLA_Error FLA_Apply_pivots_macro_external( FLA_Side side, FLA_Trans trans, FLA_Obj p, FLA_Obj A );

FLA_Error FLA_Chol_blk_external( FLA_Uplo uplo, FLA_Obj A );
FLA_Error FLA_Chol_l_blk_ext( FLA_Obj A );
FLA_Error FLA_Chol_u_blk_ext( FLA_Obj A );
FLA_Error FLA_Chol_unb_external( FLA_Uplo uplo, FLA_Obj A );
FLA_Error FLA_Chol_l_unb_ext( FLA_Obj A );
FLA_Error FLA_Chol_u_unb_ext( FLA_Obj A );

FLA_Error FLA_LU_piv_blk_external( FLA_Obj A, FLA_Obj p );
FLA_Error FLA_LU_piv_blk_ext( FLA_Obj A, FLA_Obj p );
FLA_Error FLA_LU_piv_unb_external( FLA_Obj A, FLA_Obj p );
FLA_Error FLA_LU_piv_unb_ext( FLA_Obj A, FLA_Obj p );

FLA_Error FLA_QR_blk_external( FLA_Obj A, FLA_Obj t );
FLA_Error FLA_QR_unb_external( FLA_Obj A, FLA_Obj t );

FLA_Error FLA_LQ_blk_external( FLA_Obj A, FLA_Obj t );
FLA_Error FLA_LQ_unb_external( FLA_Obj A, FLA_Obj t );

FLA_Error FLA_Hess_blk_external( FLA_Obj A, FLA_Obj t, integer ilo, integer ihi );
FLA_Error FLA_Hess_unb_external( FLA_Obj A, FLA_Obj t, integer ilo, integer ihi );

FLA_Error FLA_Tridiag_blk_external( FLA_Uplo uplo, FLA_Obj A, FLA_Obj t );
FLA_Error FLA_Tridiag_unb_external( FLA_Uplo uplo, FLA_Obj A, FLA_Obj t );

FLA_Error FLA_Bidiag_blk_external( FLA_Obj A, FLA_Obj tu, FLA_Obj tv );
FLA_Error FLA_Bidiag_unb_external( FLA_Obj A, FLA_Obj tu, FLA_Obj tv );

FLA_Error FLA_QR_form_Q_external( FLA_Obj A, FLA_Obj t );

FLA_Error FLA_Tridiag_form_Q_external( FLA_Uplo uplo, FLA_Obj A, FLA_Obj t );
FLA_Error FLA_Tridiag_apply_Q_external( FLA_Side side, FLA_Uplo uplo, FLA_Trans trans, FLA_Obj A, FLA_Obj t, FLA_Obj B );

FLA_Error FLA_Bidiag_form_U_external( FLA_Obj A, FLA_Obj t );
FLA_Error FLA_Bidiag_form_V_external( FLA_Obj A, FLA_Obj t );
FLA_Error FLA_Bidiag_apply_U_external( FLA_Side side, FLA_Trans trans, FLA_Obj A, FLA_Obj t, FLA_Obj B );
FLA_Error FLA_Bidiag_apply_V_external( FLA_Side side, FLA_Trans trans, FLA_Obj A, FLA_Obj t, FLA_Obj B );

FLA_Error FLA_Trinv_blk_external( FLA_Uplo uplo, FLA_Diag diag, FLA_Obj A );
FLA_Error FLA_Trinv_ln_blk_ext( FLA_Obj A );
FLA_Error FLA_Trinv_lu_blk_ext( FLA_Obj A );
FLA_Error FLA_Trinv_un_blk_ext( FLA_Obj A );
FLA_Error FLA_Trinv_uu_blk_ext( FLA_Obj A );
FLA_Error FLA_Trinv_unb_external( FLA_Uplo uplo, FLA_Diag diag, FLA_Obj A );
FLA_Error FLA_Trinv_ln_unb_ext( FLA_Obj A );
FLA_Error FLA_Trinv_lu_unb_ext( FLA_Obj A );
FLA_Error FLA_Trinv_un_unb_ext( FLA_Obj A );
FLA_Error FLA_Trinv_uu_unb_ext( FLA_Obj A );

FLA_Error FLA_Ttmm_blk_external( FLA_Uplo uplo, FLA_Obj A );
FLA_Error FLA_Ttmm_l_blk_ext( FLA_Obj A );
FLA_Error FLA_Ttmm_u_blk_ext( FLA_Obj A );
FLA_Error FLA_Ttmm_unb_external( FLA_Uplo uplo, FLA_Obj A );
FLA_Error FLA_Ttmm_l_unb_ext( FLA_Obj A );
FLA_Error FLA_Ttmm_u_unb_ext( FLA_Obj A );

FLA_Error FLA_Sylv_blk_external( FLA_Trans transa, FLA_Trans transb, FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_nn_blk_ext( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_nh_blk_ext( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_hn_blk_ext( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_hh_blk_ext( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_unb_external( FLA_Trans transa, FLA_Trans transb, FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_nn_unb_ext( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_nh_unb_ext( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_hn_unb_ext( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_hh_unb_ext( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );

FLA_Error FLA_SPDinv_blk_external( FLA_Uplo uplo, FLA_Obj A );

FLA_Error FLA_Eig_gest_blk_external( FLA_Inv inv, FLA_Uplo uplo, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Eig_gest_il_blk_ext( FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Eig_gest_iu_blk_ext( FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Eig_gest_nl_blk_ext( FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Eig_gest_nu_blk_ext( FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Eig_gest_unb_external( FLA_Inv inv, FLA_Uplo uplo, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Eig_gest_il_unb_ext( FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Eig_gest_iu_unb_ext( FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Eig_gest_nl_unb_ext( FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Eig_gest_nu_unb_ext( FLA_Obj A, FLA_Obj B );

FLA_Error FLA_Tevd_external( FLA_Evd_type jobz, FLA_Obj d, FLA_Obj e, FLA_Obj A );
FLA_Error FLA_Tevdd_external( FLA_Evd_type jobz, FLA_Obj d, FLA_Obj e, FLA_Obj A );
FLA_Error FLA_Tevdr_external( FLA_Evd_type jobz, FLA_Obj d, FLA_Obj e, FLA_Obj l, FLA_Obj A );
FLA_Error FLA_Hevd_external( FLA_Evd_type jobz, FLA_Uplo uplo, FLA_Obj A, FLA_Obj l );
FLA_Error FLA_Hevdd_external( FLA_Evd_type jobz, FLA_Uplo uplo, FLA_Obj A, FLA_Obj l );
FLA_Error FLA_Hevdr_external( FLA_Evd_type jobz, FLA_Uplo uplo, FLA_Obj A, FLA_Obj l, FLA_Obj Z );
FLA_Error FLA_Bsvd_external( FLA_Uplo uplo, FLA_Obj d, FLA_Obj e, FLA_Obj U, FLA_Obj V );
FLA_Error FLA_Bsvdd_external( FLA_Uplo uplo, FLA_Obj d, FLA_Obj e, FLA_Obj U, FLA_Obj V );
FLA_Error FLA_Svd_external( FLA_Svd_type jobu, FLA_Svd_type jobv, FLA_Obj A, FLA_Obj s, FLA_Obj U, FLA_Obj V );
FLA_Error FLA_Svdd_external( FLA_Svd_type jobz, FLA_Obj A, FLA_Obj s, FLA_Obj U, FLA_Obj V );

// --- check routine prototypes ------------------------------------------------

FLA_Error FLA_Chol_check( FLA_Uplo uplo, FLA_Obj A );
FLA_Error FLA_Chol_solve_check( FLA_Uplo uplo, FLA_Obj A, FLA_Obj B, FLA_Obj X );
FLA_Error FLA_LU_nopiv_check( FLA_Obj A );
FLA_Error FLA_LU_nopiv_solve_check( FLA_Obj A, FLA_Obj B, FLA_Obj X );
FLA_Error FLA_LU_piv_check( FLA_Obj A, FLA_Obj p );
FLA_Error FLA_LU_piv_solve_check( FLA_Obj A, FLA_Obj p, FLA_Obj B, FLA_Obj X );
FLA_Error FLA_LU_incpiv_check( FLA_Obj A, FLA_Obj p, FLA_Obj L );
FLA_Error FLA_LU_incpiv_solve_check( FLA_Obj A, FLA_Obj p, FLA_Obj L, FLA_Obj B, FLA_Obj X );
FLA_Error FLA_FS_incpiv_check( FLA_Obj A, FLA_Obj p, FLA_Obj L, FLA_Obj b );
FLA_Error FLA_QR_check( FLA_Obj A, FLA_Obj t );
FLA_Error FLA_QR_UT_check( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_QR_UT_solve_check( FLA_Obj A, FLA_Obj T, FLA_Obj B, FLA_Obj X );
FLA_Error FLA_QR_UT_recover_tau_check( FLA_Obj T, FLA_Obj tau );
FLA_Error FLA_QR_UT_form_Q_check( FLA_Obj A, FLA_Obj T, FLA_Obj Q );
FLA_Error FLA_LQ_check( FLA_Obj A, FLA_Obj t );
FLA_Error FLA_LQ_UT_check( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_LQ_UT_solve_check( FLA_Obj A, FLA_Obj T, FLA_Obj B, FLA_Obj X );
FLA_Error FLA_LQ_UT_recover_tau_check( FLA_Obj T, FLA_Obj tau );
FLA_Error FLA_LQ_UT_form_Q_check( FLA_Obj A, FLA_Obj T, FLA_Obj Q );
FLA_Error FLA_Hess_check( FLA_Obj A, FLA_Obj t, integer ilo, integer ihi );
FLA_Error FLA_Hess_UT_check( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Hess_UT_recover_tau_check( FLA_Obj T, FLA_Obj tau );
FLA_Error FLA_Tridiag_check( FLA_Uplo uplo, FLA_Obj A, FLA_Obj t );
FLA_Error FLA_Tridiag_UT_check( FLA_Uplo uplo, FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Tridiag_UT_recover_tau_check( FLA_Obj T, FLA_Obj tau );
FLA_Error FLA_Tridiag_UT_scale_diagonals_check( FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj A );
FLA_Error FLA_Tridiag_UT_extract_diagonals_check( FLA_Uplo uplo, FLA_Obj A, FLA_Obj d, FLA_Obj e );
FLA_Error FLA_Tridiag_UT_extract_real_diagonals_check( FLA_Uplo uplo, FLA_Obj A, FLA_Obj d, FLA_Obj e );
FLA_Error FLA_Tridiag_UT_realify_check( FLA_Uplo uplo, FLA_Obj A, FLA_Obj d );
FLA_Error FLA_Tridiag_UT_realify_subdiagonal_check( FLA_Obj b, FLA_Obj d );
FLA_Error FLA_Tridiag_UT_shift_U_check( FLA_Uplo uplo, FLA_Obj A );
FLA_Error FLA_Tridiag_UT_form_Q_check( FLA_Uplo uplo, FLA_Obj A, FLA_Obj T, FLA_Obj Q );
FLA_Error FLA_Trinv_check( FLA_Uplo uplo, FLA_Diag diag, FLA_Obj A );
FLA_Error FLA_Bidiag_check( FLA_Obj A, FLA_Obj tu, FLA_Obj tv );
FLA_Error FLA_Bidiag_UT_check( FLA_Obj A, FLA_Obj TU, FLA_Obj TV );
FLA_Error FLA_Bidiag_UT_recover_tau_check( FLA_Obj TU, FLA_Obj TV, FLA_Obj tu, FLA_Obj tv );
FLA_Error FLA_Bidiag_UT_extract_diagonals_check( FLA_Obj A, FLA_Obj d, FLA_Obj e );
FLA_Error FLA_Bidiag_UT_extract_real_diagonals_check( FLA_Obj A, FLA_Obj d, FLA_Obj e );
FLA_Error FLA_Bidiag_UT_scale_diagonals_check( FLA_Obj alpha, FLA_Obj A );
FLA_Error FLA_Bidiag_UT_realify_check( FLA_Obj A, FLA_Obj d, FLA_Obj e );
FLA_Error FLA_Bidiag_UT_realify_diagonals_check( FLA_Uplo uplo, FLA_Obj a, FLA_Obj b, FLA_Obj d, FLA_Obj e );
FLA_Error FLA_Bidiag_UT_form_U_check( FLA_Obj A, FLA_Obj T, FLA_Obj U );
FLA_Error FLA_Bidiag_UT_form_V_check( FLA_Obj A, FLA_Obj S, FLA_Obj V );
FLA_Error FLA_Ttmm_check( FLA_Uplo uplo, FLA_Obj A );
FLA_Error FLA_Sylv_check( FLA_Trans transa, FLA_Trans transb, FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Lyap_check( FLA_Trans trans, FLA_Obj isgn, FLA_Obj A, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_SPDinv_check( FLA_Uplo uplo, FLA_Obj A );
FLA_Error FLA_Eig_gest_check( FLA_Inv inv, FLA_Uplo uplo, FLA_Obj A, FLA_Obj B );

FLA_Error FLA_Apply_Q_check( FLA_Side side, FLA_Trans trans, FLA_Store storev, FLA_Obj A, FLA_Obj t, FLA_Obj B );

FLA_Error FLA_QR_form_Q_check( FLA_Obj A, FLA_Obj t );

FLA_Error FLA_Tridiag_form_Q_check( FLA_Uplo uplo, FLA_Obj A, FLA_Obj t );
FLA_Error FLA_Tridiag_apply_Q_check( FLA_Side side, FLA_Uplo uplo, FLA_Trans trans, FLA_Obj A, FLA_Obj t, FLA_Obj B );

FLA_Error FLA_Bidiag_form_U_check( FLA_Obj A, FLA_Obj t );
FLA_Error FLA_Bidiag_form_V_check( FLA_Obj A, FLA_Obj t );
FLA_Error FLA_Bidiag_apply_U_check( FLA_Side side, FLA_Trans trans, FLA_Obj A, FLA_Obj t, FLA_Obj B );
FLA_Error FLA_Bidiag_apply_V_check( FLA_Side side, FLA_Trans trans, FLA_Obj A, FLA_Obj t, FLA_Obj B );

FLA_Error FLA_Apply_Q_UT_check( FLA_Side side, FLA_Trans trans, FLA_Direct direct, FLA_Store storev, FLA_Obj A, FLA_Obj T, FLA_Obj W, FLA_Obj B );
FLA_Error FLA_Apply_Q2_UT_check( FLA_Side side, FLA_Trans trans, FLA_Direct direct, FLA_Store storev, FLA_Obj D, FLA_Obj T, FLA_Obj W, FLA_Obj C, FLA_Obj E );
FLA_Error FLA_Apply_QUD_UT_check( FLA_Side side, FLA_Trans trans, FLA_Direct direct, FLA_Store storev, FLA_Obj T, FLA_Obj W, FLA_Obj R, FLA_Obj U, FLA_Obj C, FLA_Obj V, FLA_Obj D );
FLA_Error FLA_Apply_pivots_check( FLA_Side side, FLA_Trans trans, FLA_Obj p, FLA_Obj A );
FLA_Error FLA_QR2_UT_check( FLA_Obj B, FLA_Obj D, FLA_Obj T );
FLA_Error FLA_CAQR2_UT_check( FLA_Obj B, FLA_Obj D, FLA_Obj T );
FLA_Error FLA_QR_UT_inc_check( FLA_Obj A, FLA_Obj TW );
FLA_Error FLA_Apply_Q_UT_inc_check( FLA_Side side, FLA_Trans trans, FLA_Direct direct, FLA_Store storev, FLA_Obj A, FLA_Obj TW, FLA_Obj W1, FLA_Obj B );
FLA_Error FLA_Apply_CAQ_UT_inc_check( FLA_Side side, FLA_Trans trans, FLA_Direct direct, FLA_Store storev, FLA_Obj A, FLA_Obj ATW, FLA_Obj R, FLA_Obj RTW, FLA_Obj W1, FLA_Obj B );

FLA_Error FLA_QR_UT_inc_solve_check( FLA_Obj A, FLA_Obj TW, FLA_Obj B, FLA_Obj X );
FLA_Error FLA_CAQR_UT_inc_solve_check( fla_dim_t p, FLA_Obj A, FLA_Obj ATW, FLA_Obj R, FLA_Obj RTW, FLA_Obj B, FLA_Obj X );

FLA_Error FLA_UDdate_UT_check( FLA_Obj R, FLA_Obj C, FLA_Obj D, FLA_Obj T );
FLA_Error FLA_UDdate_UT_update_rhs_check( FLA_Obj T, FLA_Obj bR, FLA_Obj C, FLA_Obj bC, FLA_Obj D, FLA_Obj bD );
FLA_Error FLA_UDdate_UT_solve_check( FLA_Obj R, FLA_Obj bR, FLA_Obj x );

FLA_Error FLA_UDdate_UT_inc_check( FLA_Obj R, FLA_Obj C, FLA_Obj D, FLA_Obj T, FLA_Obj W );
FLA_Error FLA_UDdate_UT_inc_update_rhs_check( FLA_Obj T, FLA_Obj bR, FLA_Obj C, FLA_Obj bC, FLA_Obj D, FLA_Obj bD );
FLA_Error FLA_UDdate_UT_inc_solve_check( FLA_Obj R, FLA_Obj bR, FLA_Obj x );

FLA_Error FLA_CAQR_UT_inc_check( fla_dim_t p, FLA_Obj A, FLA_Obj ATW, FLA_Obj R, FLA_Obj RTW );

FLA_Error FLA_Apply_QUD_UT_inc_check( FLA_Side side, FLA_Trans trans, FLA_Direct direct, FLA_Store storev, FLA_Obj T, FLA_Obj W, FLA_Obj R, FLA_Obj U, FLA_Obj C, FLA_Obj V, FLA_Obj D );

FLA_Error FLA_Apply_H2_UT_check( FLA_Side side, FLA_Obj tau, FLA_Obj u2, FLA_Obj a1t, FLA_Obj A2 );
FLA_Error FLA_Apply_HUD_UT_check( FLA_Side side, FLA_Obj tau, FLA_Obj w12t, FLA_Obj u2, FLA_Obj v2, FLA_Obj r12t, FLA_Obj C2, FLA_Obj D2 );
FLA_Error FLA_Accum_T_UT_check( FLA_Direct direct, FLA_Store storev, FLA_Obj A, FLA_Obj tau, FLA_Obj T );

FLA_Error FLA_Tevd_compute_scaling_check( FLA_Obj d, FLA_Obj e, FLA_Obj sigma );
FLA_Error FLA_Hevd_compute_scaling_check( FLA_Uplo uplo, FLA_Obj A, FLA_Obj sigma );
FLA_Error FLA_Hevd_check( FLA_Evd_type jobz, FLA_Uplo uplo, FLA_Obj A, FLA_Obj l );
FLA_Error FLA_Hevdd_check( FLA_Evd_type jobz, FLA_Uplo uplo, FLA_Obj A, FLA_Obj l );
FLA_Error FLA_Hevdr_check( FLA_Evd_type jobz, FLA_Uplo uplo, FLA_Obj A, FLA_Obj l, FLA_Obj Z );

FLA_Error FLA_Bsvd_check( FLA_Uplo uplo, FLA_Obj d, FLA_Obj e,
                          FLA_Obj G, FLA_Obj H,
                          FLA_Svd_type jobu, FLA_Obj U,
                          FLA_Svd_type jobv, FLA_Obj V );
FLA_Error FLA_Bsvd_ext_check( FLA_Uplo uplo, FLA_Obj d, FLA_Obj e,
                              FLA_Obj G, FLA_Obj H,
                              FLA_Svd_type jobu, FLA_Obj U,
                              FLA_Svd_type jobv, FLA_Obj V,
                              FLA_Bool apply_Uh2C, FLA_Obj C );
FLA_Error FLA_Bsvd_compute_scaling_check( FLA_Obj d, FLA_Obj e, FLA_Obj sigma );
FLA_Error FLA_Svd_compute_scaling_check( FLA_Obj A, FLA_Obj sigma );
FLA_Error FLA_Svd_check( FLA_Svd_type jobu, FLA_Svd_type jobv, FLA_Obj A, FLA_Obj s, FLA_Obj U, FLA_Obj V );
FLA_Error FLA_Svd_ext_check( FLA_Svd_type jobu, FLA_Trans transu, FLA_Svd_type jobv, FLA_Trans transv,
                             FLA_Obj A, FLA_Obj s, FLA_Obj U, FLA_Obj V );
FLA_Error FLA_Svdd_check( FLA_Svd_type jobz, FLA_Obj A, FLA_Obj s, FLA_Obj U, FLA_Obj V );

FLA_Error FLA_Chol_internal_check( FLA_Uplo uplo, FLA_Obj A, fla_chol_t* cntl );
FLA_Error FLA_LU_nopiv_internal_check( FLA_Obj A, fla_lu_t* cntl );
FLA_Error FLA_Trinv_internal_check( FLA_Uplo uplo, FLA_Diag diag, FLA_Obj A, fla_trinv_t* cntl );
FLA_Error FLA_Ttmm_internal_check( FLA_Uplo uplo, FLA_Obj A, fla_ttmm_t* cntl );
FLA_Error FLA_SPDinv_internal_check( FLA_Uplo uplo, FLA_Obj A, fla_spdinv_t* cntl );
FLA_Error FLA_Sylv_internal_check( FLA_Trans transa, FLA_Trans transb, FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Lyap_internal_check( FLA_Trans trans, FLA_Obj isgn, FLA_Obj A, FLA_Obj C, FLA_Obj scale, fla_lyap_t* cntl );
FLA_Error FLA_QR_UT_internal_check( FLA_Obj A, FLA_Obj T, fla_qrut_t* cntl );
FLA_Error FLA_QR_UT_copy_internal_check( FLA_Obj A, FLA_Obj T, FLA_Obj U, fla_qrut_t* cntl );
FLA_Error FLA_QR2_UT_internal_check( FLA_Obj B, FLA_Obj D, FLA_Obj T, fla_qr2ut_t* cntl );
FLA_Error FLA_CAQR2_UT_internal_check( FLA_Obj B, FLA_Obj D, FLA_Obj T, fla_caqr2ut_t* cntl );
FLA_Error FLA_LQ_UT_internal_check( FLA_Obj A, FLA_Obj T, fla_lqut_t* cntl );
FLA_Error FLA_Hess_UT_internal_check( FLA_Obj A, FLA_Obj T, fla_hessut_t* cntl );
FLA_Error FLA_Tridiag_UT_internal_check( FLA_Uplo uplo, FLA_Obj A, FLA_Obj T, fla_tridiagut_t* cntl );
FLA_Error FLA_Bidiag_UT_internal_check( FLA_Obj A, FLA_Obj TU, FLA_Obj TV, fla_bidiagut_t* cntl );

FLA_Error FLA_UDdate_UT_internal_check( FLA_Obj R, FLA_Obj C, FLA_Obj D, FLA_Obj T, fla_uddateut_t* cntl );

FLA_Error FLA_Apply_Q_UT_internal_check( FLA_Side side, FLA_Trans trans, FLA_Direct direct, FLA_Store storev, FLA_Obj A, FLA_Obj T, FLA_Obj W, FLA_Obj B, fla_apqut_t* cntl );
FLA_Error FLA_Apply_Q2_UT_internal_check( FLA_Side side, FLA_Trans trans, FLA_Direct direct, FLA_Store storev, FLA_Obj D, FLA_Obj T, FLA_Obj W, FLA_Obj C, FLA_Obj E, fla_apq2ut_t* cntl );
FLA_Error FLA_Apply_CAQ2_UT_internal_check( FLA_Side side, FLA_Trans trans, FLA_Direct direct, FLA_Store storev, FLA_Obj D, FLA_Obj T, FLA_Obj W, FLA_Obj C, FLA_Obj E, fla_apcaq2ut_t* cntl );
FLA_Error FLA_Apply_QUD_UT_internal_check( FLA_Side side, FLA_Trans trans, FLA_Direct direct, FLA_Store storev, FLA_Obj T, FLA_Obj W, FLA_Obj R, FLA_Obj U, FLA_Obj C, FLA_Obj V, FLA_Obj D, fla_apqudut_t* cntl );

FLA_Error FLA_Apply_Q_UT_inc_internal_check( FLA_Side side, FLA_Trans trans, FLA_Direct direct, FLA_Store storev, FLA_Obj A, FLA_Obj TW, FLA_Obj W1, FLA_Obj B, fla_apqutinc_t* cntl );
FLA_Error FLA_Apply_CAQ_UT_inc_internal_check( FLA_Side side, FLA_Trans trans, FLA_Direct direct, FLA_Store storev, FLA_Obj R, FLA_Obj TW, FLA_Obj W, FLA_Obj B, fla_apcaqutinc_t* cntl );
FLA_Error FLA_Apply_QUD_UT_inc_internal_check( FLA_Side side, FLA_Trans trans, FLA_Direct direct, FLA_Store storev, FLA_Obj T, FLA_Obj W, FLA_Obj R, FLA_Obj U, FLA_Obj C, FLA_Obj V, FLA_Obj D, fla_apqudutinc_t* cntl );

FLA_Error FLA_Eig_gest_internal_check( FLA_Inv inv, FLA_Uplo uplo, FLA_Obj A, FLA_Obj Y, FLA_Obj B, fla_eig_gest_t* cntl );
// end FLA_lapack_prototypes.h

  // Include prototypes for FLAME implementations of BLAS and LAPACK operations.
// begin FLA_blas_var_prototypes.h


// Level-1 BLAS
// begin FLA_Axpy.h


// begin FLA_Axpy_vars.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Axpy_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_axpy_t* cntl );
FLA_Error FLA_Axpy_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_axpy_t* cntl );
FLA_Error FLA_Axpy_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_axpy_t* cntl );
FLA_Error FLA_Axpy_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_axpy_t* cntl );

// end FLA_Axpy_vars.h

FLA_Error FLA_Axpy_internal( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_axpy_t* cntl );

// end FLA_Axpy.h
// begin FLA_Axpyt.h


// begin FLA_Axpyt_n.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Axpyt_n_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_axpyt_t* cntl );
FLA_Error FLA_Axpyt_n_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_axpyt_t* cntl );
FLA_Error FLA_Axpyt_n_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_axpyt_t* cntl );
FLA_Error FLA_Axpyt_n_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_axpyt_t* cntl );

// end FLA_Axpyt_n.h
// begin FLA_Axpyt_t.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Axpyt_t_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_axpyt_t* cntl );
FLA_Error FLA_Axpyt_t_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_axpyt_t* cntl );
FLA_Error FLA_Axpyt_t_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_axpyt_t* cntl );
FLA_Error FLA_Axpyt_t_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_axpyt_t* cntl );

// end FLA_Axpyt_t.h
// begin FLA_Axpyt_c.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Axpyt_c_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_axpyt_t* cntl );
FLA_Error FLA_Axpyt_c_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_axpyt_t* cntl );
FLA_Error FLA_Axpyt_c_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_axpyt_t* cntl );
FLA_Error FLA_Axpyt_c_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_axpyt_t* cntl );

// end FLA_Axpyt_c.h
// begin FLA_Axpyt_h.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Axpyt_h_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_axpyt_t* cntl );
FLA_Error FLA_Axpyt_h_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_axpyt_t* cntl );
FLA_Error FLA_Axpyt_h_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_axpyt_t* cntl );
FLA_Error FLA_Axpyt_h_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_axpyt_t* cntl );

// end FLA_Axpyt_h.h

FLA_Error FLA_Axpyt_internal( FLA_Trans trans, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_axpyt_t* cntl );
FLA_Error FLA_Axpyt_n( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_axpyt_t* cntl );
FLA_Error FLA_Axpyt_t( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_axpyt_t* cntl );
FLA_Error FLA_Axpyt_c( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_axpyt_t* cntl );
FLA_Error FLA_Axpyt_h( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_axpyt_t* cntl );

// end FLA_Axpyt.h
// begin FLA_Copy.h


// begin FLA_Copy_vars.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Copy_blk_var1( FLA_Obj A, FLA_Obj B, fla_copy_t* cntl );
FLA_Error FLA_Copy_blk_var2( FLA_Obj A, FLA_Obj B, fla_copy_t* cntl );
FLA_Error FLA_Copy_blk_var3( FLA_Obj A, FLA_Obj B, fla_copy_t* cntl );
FLA_Error FLA_Copy_blk_var4( FLA_Obj A, FLA_Obj B, fla_copy_t* cntl );

// end FLA_Copy_vars.h

FLA_Error FLA_Copy_internal( FLA_Obj A, FLA_Obj B, fla_copy_t* cntl );

// end FLA_Copy.h
// begin FLA_Copyt.h


// begin FLA_Copyt_n.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Copyt_n_blk_var1( FLA_Obj A, FLA_Obj B, fla_copyt_t* cntl );
FLA_Error FLA_Copyt_n_blk_var2( FLA_Obj A, FLA_Obj B, fla_copyt_t* cntl );
FLA_Error FLA_Copyt_n_blk_var3( FLA_Obj A, FLA_Obj B, fla_copyt_t* cntl );
FLA_Error FLA_Copyt_n_blk_var4( FLA_Obj A, FLA_Obj B, fla_copyt_t* cntl );

// end FLA_Copyt_n.h
// begin FLA_Copyt_t.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Copyt_t_blk_var1( FLA_Obj A, FLA_Obj B, fla_copyt_t* cntl );
FLA_Error FLA_Copyt_t_blk_var2( FLA_Obj A, FLA_Obj B, fla_copyt_t* cntl );
FLA_Error FLA_Copyt_t_blk_var3( FLA_Obj A, FLA_Obj B, fla_copyt_t* cntl );
FLA_Error FLA_Copyt_t_blk_var4( FLA_Obj A, FLA_Obj B, fla_copyt_t* cntl );

// end FLA_Copyt_t.h
// begin FLA_Copyt_c.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Copyt_c_blk_var1( FLA_Obj A, FLA_Obj B, fla_copyt_t* cntl );
FLA_Error FLA_Copyt_c_blk_var2( FLA_Obj A, FLA_Obj B, fla_copyt_t* cntl );
FLA_Error FLA_Copyt_c_blk_var3( FLA_Obj A, FLA_Obj B, fla_copyt_t* cntl );
FLA_Error FLA_Copyt_c_blk_var4( FLA_Obj A, FLA_Obj B, fla_copyt_t* cntl );

// end FLA_Copyt_c.h
// begin FLA_Copyt_h.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Copyt_h_blk_var1( FLA_Obj A, FLA_Obj B, fla_copyt_t* cntl );
FLA_Error FLA_Copyt_h_blk_var2( FLA_Obj A, FLA_Obj B, fla_copyt_t* cntl );
FLA_Error FLA_Copyt_h_blk_var3( FLA_Obj A, FLA_Obj B, fla_copyt_t* cntl );
FLA_Error FLA_Copyt_h_blk_var4( FLA_Obj A, FLA_Obj B, fla_copyt_t* cntl );

// end FLA_Copyt_h.h

FLA_Error FLA_Copyt_internal( FLA_Trans trans, FLA_Obj A, FLA_Obj B, fla_copyt_t* cntl );
FLA_Error FLA_Copyt_n( FLA_Obj A, FLA_Obj B, fla_copyt_t* cntl );
FLA_Error FLA_Copyt_t( FLA_Obj A, FLA_Obj B, fla_copyt_t* cntl );
FLA_Error FLA_Copyt_c( FLA_Obj A, FLA_Obj B, fla_copyt_t* cntl );
FLA_Error FLA_Copyt_h( FLA_Obj A, FLA_Obj B, fla_copyt_t* cntl );

// end FLA_Copyt.h
// begin FLA_Copyr.h


// begin FLA_Copyr_l.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Copyr_l_blk_var1( FLA_Obj A, FLA_Obj B, fla_copyr_t* cntl );
FLA_Error FLA_Copyr_l_blk_var2( FLA_Obj A, FLA_Obj B, fla_copyr_t* cntl );
FLA_Error FLA_Copyr_l_blk_var3( FLA_Obj A, FLA_Obj B, fla_copyr_t* cntl );
FLA_Error FLA_Copyr_l_blk_var4( FLA_Obj A, FLA_Obj B, fla_copyr_t* cntl );

// end FLA_Copyr_l.h
// begin FLA_Copyr_u.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Copyr_u_blk_var1( FLA_Obj A, FLA_Obj B, fla_copyr_t* cntl );
FLA_Error FLA_Copyr_u_blk_var2( FLA_Obj A, FLA_Obj B, fla_copyr_t* cntl );
FLA_Error FLA_Copyr_u_blk_var3( FLA_Obj A, FLA_Obj B, fla_copyr_t* cntl );
FLA_Error FLA_Copyr_u_blk_var4( FLA_Obj A, FLA_Obj B, fla_copyr_t* cntl );

// end FLA_Copyr_u.h

FLA_Error FLASH_Copyr( FLA_Uplo uplo, FLA_Obj A, FLA_Obj B );

FLA_Error FLA_Copyr_internal( FLA_Uplo uplo, FLA_Obj A, FLA_Obj B, fla_copyr_t* cntl );
FLA_Error FLA_Copyr_l( FLA_Obj A, FLA_Obj B, fla_copyr_t* cntl );
FLA_Error FLA_Copyr_u( FLA_Obj A, FLA_Obj B, fla_copyr_t* cntl );

// end FLA_Copyr.h
// begin FLA_Scal.h


// begin FLA_Scal_vars.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Scal_blk_var1( FLA_Obj alpha, FLA_Obj A, fla_scal_t* cntl );
FLA_Error FLA_Scal_blk_var2( FLA_Obj alpha, FLA_Obj A, fla_scal_t* cntl );
FLA_Error FLA_Scal_blk_var3( FLA_Obj alpha, FLA_Obj A, fla_scal_t* cntl );
FLA_Error FLA_Scal_blk_var4( FLA_Obj alpha, FLA_Obj A, fla_scal_t* cntl );

// end FLA_Scal_vars.h

FLA_Error FLA_Scal_internal( FLA_Obj alpha, FLA_Obj A, fla_scal_t* cntl );

// end FLA_Scal.h
// begin FLA_Scalr.h


// begin FLA_Scalr_l.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Scalr_l_blk_var1( FLA_Obj alpha, FLA_Obj A, fla_scalr_t* cntl );
FLA_Error FLA_Scalr_l_blk_var2( FLA_Obj alpha, FLA_Obj A, fla_scalr_t* cntl );
FLA_Error FLA_Scalr_l_blk_var3( FLA_Obj alpha, FLA_Obj A, fla_scalr_t* cntl );
FLA_Error FLA_Scalr_l_blk_var4( FLA_Obj alpha, FLA_Obj A, fla_scalr_t* cntl );

// end FLA_Scalr_l.h
// begin FLA_Scalr_u.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Scalr_u_blk_var1( FLA_Obj alpha, FLA_Obj A, fla_scalr_t* cntl );
FLA_Error FLA_Scalr_u_blk_var2( FLA_Obj alpha, FLA_Obj A, fla_scalr_t* cntl );
FLA_Error FLA_Scalr_u_blk_var3( FLA_Obj alpha, FLA_Obj A, fla_scalr_t* cntl );
FLA_Error FLA_Scalr_u_blk_var4( FLA_Obj alpha, FLA_Obj A, fla_scalr_t* cntl );

// end FLA_Scalr_u.h

FLA_Error FLA_Scalr_internal( FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj A, fla_scalr_t* cntl );

FLA_Error FLA_Scalr_l( FLA_Obj alpha, FLA_Obj A, fla_scalr_t* cntl );
FLA_Error FLA_Scalr_u( FLA_Obj alpha, FLA_Obj A, fla_scalr_t* cntl );

// end FLA_Scalr.h

// Level-2 BLAS
// begin FLA_Gemv.h


// begin FLA_Gemv_h.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Gemv_h_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y, fla_gemv_t* cntl );
FLA_Error FLA_Gemv_h_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y, fla_gemv_t* cntl );
FLA_Error FLA_Gemv_h_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y, fla_gemv_t* cntl );
FLA_Error FLA_Gemv_h_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y, fla_gemv_t* cntl );

// end FLA_Gemv_h.h
// begin FLA_Gemv_n.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Gemv_n_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y, fla_gemv_t* cntl );
FLA_Error FLA_Gemv_n_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y, fla_gemv_t* cntl );
FLA_Error FLA_Gemv_n_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y, fla_gemv_t* cntl );
FLA_Error FLA_Gemv_n_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y, fla_gemv_t* cntl );

// end FLA_Gemv_n.h
// begin FLA_Gemv_t.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Gemv_t_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y, fla_gemv_t* cntl );
FLA_Error FLA_Gemv_t_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y, fla_gemv_t* cntl );
FLA_Error FLA_Gemv_t_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y, fla_gemv_t* cntl );
FLA_Error FLA_Gemv_t_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y, fla_gemv_t* cntl );

// end FLA_Gemv_t.h

FLA_Error FLA_Gemv_internal( FLA_Trans transa, FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y, fla_gemv_t* cntl );

FLA_Error FLA_Gemv_h( FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y, fla_gemv_t* cntl );
FLA_Error FLA_Gemv_n( FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y, fla_gemv_t* cntl );
FLA_Error FLA_Gemv_t( FLA_Obj alpha, FLA_Obj A, FLA_Obj x, FLA_Obj beta, FLA_Obj y, fla_gemv_t* cntl );

// end FLA_Gemv.h
// begin FLA_Trsv.h


// begin FLA_Trsv_lc.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trsv_lc_blk_var1( FLA_Diag diagA, FLA_Obj A, FLA_Obj x, fla_trsv_t* cntl );
FLA_Error FLA_Trsv_lc_blk_var2( FLA_Diag diagA, FLA_Obj A, FLA_Obj x, fla_trsv_t* cntl );

// end FLA_Trsv_lc.h
// begin FLA_Trsv_ln.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trsv_ln_blk_var1( FLA_Diag diagA, FLA_Obj A, FLA_Obj x, fla_trsv_t* cntl );
FLA_Error FLA_Trsv_ln_blk_var2( FLA_Diag diagA, FLA_Obj A, FLA_Obj x, fla_trsv_t* cntl );

// end FLA_Trsv_ln.h
// begin FLA_Trsv_lt.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trsv_lt_blk_var1( FLA_Diag diagA, FLA_Obj A, FLA_Obj x, fla_trsv_t* cntl );
FLA_Error FLA_Trsv_lt_blk_var2( FLA_Diag diagA, FLA_Obj A, FLA_Obj x, fla_trsv_t* cntl );

// end FLA_Trsv_lt.h
// begin FLA_Trsv_uc.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trsv_uc_blk_var1( FLA_Diag diagA, FLA_Obj A, FLA_Obj x, fla_trsv_t* cntl );
FLA_Error FLA_Trsv_uc_blk_var2( FLA_Diag diagA, FLA_Obj A, FLA_Obj x, fla_trsv_t* cntl );

// end FLA_Trsv_uc.h
// begin FLA_Trsv_un.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trsv_un_blk_var1( FLA_Diag diagA, FLA_Obj A, FLA_Obj x, fla_trsv_t* cntl );
FLA_Error FLA_Trsv_un_blk_var2( FLA_Diag diagA, FLA_Obj A, FLA_Obj x, fla_trsv_t* cntl );

// end FLA_Trsv_un.h
// begin FLA_Trsv_ut.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trsv_ut_blk_var1( FLA_Diag diagA, FLA_Obj A, FLA_Obj x, fla_trsv_t* cntl );
FLA_Error FLA_Trsv_ut_blk_var2( FLA_Diag diagA, FLA_Obj A, FLA_Obj x, fla_trsv_t* cntl );

// end FLA_Trsv_ut.h

FLA_Error FLA_Trsv_internal( FLA_Uplo uplo, FLA_Trans transa, FLA_Diag diag, FLA_Obj A, FLA_Obj x, fla_trsv_t* cntl );

FLA_Error FLA_Trsv_lc( FLA_Diag diag, FLA_Obj A, FLA_Obj x, fla_trsv_t* cntl );
FLA_Error FLA_Trsv_ln( FLA_Diag diag, FLA_Obj A, FLA_Obj x, fla_trsv_t* cntl );
FLA_Error FLA_Trsv_lt( FLA_Diag diag, FLA_Obj A, FLA_Obj x, fla_trsv_t* cntl );
FLA_Error FLA_Trsv_uc( FLA_Diag diag, FLA_Obj A, FLA_Obj x, fla_trsv_t* cntl );
FLA_Error FLA_Trsv_un( FLA_Diag diag, FLA_Obj A, FLA_Obj x, fla_trsv_t* cntl );
FLA_Error FLA_Trsv_ut( FLA_Diag diag, FLA_Obj A, FLA_Obj x, fla_trsv_t* cntl );

// end FLA_Trsv.h

// Level-3 BLAS
// begin FLA_Gemm.h


// begin FLA_Gemm_cc.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Gemm_cc_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_cc_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_cc_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_cc_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_cc_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_cc_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );

FLA_Error FLA_Gemm_cc_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_cc_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_cc_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_cc_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_cc_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_cc_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );

// end FLA_Gemm_cc.h
// begin FLA_Gemm_ch.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Gemm_ch_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_ch_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_ch_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_ch_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_ch_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_ch_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );

FLA_Error FLA_Gemm_ch_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_ch_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_ch_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_ch_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_ch_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_ch_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );

// end FLA_Gemm_ch.h
// begin FLA_Gemm_cn.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Gemm_cn_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_cn_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_cn_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_cn_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_cn_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_cn_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );

FLA_Error FLA_Gemm_cn_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_cn_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_cn_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_cn_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_cn_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_cn_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );

// end FLA_Gemm_cn.h
// begin FLA_Gemm_ct.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Gemm_ct_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_ct_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_ct_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_ct_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_ct_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_ct_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );

FLA_Error FLA_Gemm_ct_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_ct_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_ct_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_ct_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_ct_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_ct_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );

// end FLA_Gemm_ct.h
// begin FLA_Gemm_hc.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Gemm_hc_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_hc_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_hc_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_hc_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_hc_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_hc_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );

FLA_Error FLA_Gemm_hc_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_hc_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_hc_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_hc_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_hc_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_hc_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );

// end FLA_Gemm_hc.h
// begin FLA_Gemm_hh.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Gemm_hh_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_hh_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_hh_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_hh_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_hh_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_hh_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );

FLA_Error FLA_Gemm_hh_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_hh_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_hh_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_hh_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_hh_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_hh_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );

// end FLA_Gemm_hh.h
// begin FLA_Gemm_hn.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Gemm_hn_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_hn_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_hn_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_hn_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_hn_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_hn_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );

FLA_Error FLA_Gemm_hn_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_hn_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_hn_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_hn_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_hn_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_hn_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );

// end FLA_Gemm_hn.h
// begin FLA_Gemm_ht.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Gemm_ht_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_ht_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_ht_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_ht_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_ht_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_ht_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );

FLA_Error FLA_Gemm_ht_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_ht_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_ht_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_ht_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_ht_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_ht_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );

// end FLA_Gemm_ht.h
// begin FLA_Gemm_nc.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Gemm_nc_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_nc_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_nc_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_nc_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_nc_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_nc_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );

FLA_Error FLA_Gemm_nc_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_nc_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_nc_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_nc_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_nc_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_nc_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );

// end FLA_Gemm_nc.h
// begin FLA_Gemm_nh.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Gemm_nh_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_nh_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_nh_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_nh_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_nh_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_nh_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );

FLA_Error FLA_Gemm_nh_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_nh_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_nh_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_nh_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_nh_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_nh_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );

// end FLA_Gemm_nh.h
// begin FLA_Gemm_nn.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Gemm_nn_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_nn_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_nn_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_nn_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_nn_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_nn_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );

FLA_Error FLA_Gemm_nn_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_nn_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_nn_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_nn_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_nn_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_nn_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );

// end FLA_Gemm_nn.h
// begin FLA_Gemm_nt.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Gemm_nt_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_nt_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_nt_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_nt_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_nt_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_nt_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );

FLA_Error FLA_Gemm_nt_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_nt_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_nt_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_nt_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_nt_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_nt_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );

// end FLA_Gemm_nt.h
// begin FLA_Gemm_tc.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Gemm_tc_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_tc_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_tc_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_tc_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_tc_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_tc_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );

FLA_Error FLA_Gemm_tc_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_tc_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_tc_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_tc_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_tc_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_tc_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );

// end FLA_Gemm_tc.h
// begin FLA_Gemm_th.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Gemm_th_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_th_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_th_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_th_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_th_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_th_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );

FLA_Error FLA_Gemm_th_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_th_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_th_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_th_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_th_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_th_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );

// end FLA_Gemm_th.h
// begin FLA_Gemm_tn.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Gemm_tn_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_tn_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_tn_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_tn_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_tn_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_tn_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );

FLA_Error FLA_Gemm_tn_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_tn_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_tn_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_tn_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_tn_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_tn_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );

// end FLA_Gemm_tn.h
// begin FLA_Gemm_tt.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Gemm_tt_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_tt_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_tt_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_tt_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_tt_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_tt_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );

FLA_Error FLA_Gemm_tt_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_tt_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_tt_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_tt_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_tt_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Gemm_tt_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );

// end FLA_Gemm_tt.h

FLA_Error FLA_Gemm_internal( FLA_Trans transa, FLA_Trans transb, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );

FLA_Error FLA_Gemm_cc( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_ch( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_cn( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_ct( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_hc( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_hh( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_hn( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_ht( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_nc( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_nh( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_nn( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_nt( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_tc( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_th( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_tn( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );
FLA_Error FLA_Gemm_tt( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_gemm_t* cntl );

// end FLA_Gemm.h
// begin FLA_Hemm.h


// begin FLA_Hemm_ll.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Hemm_ll_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_ll_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_ll_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_ll_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_ll_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_ll_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_ll_blk_var7( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_ll_blk_var8( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_ll_blk_var9( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_ll_blk_var10( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );

FLA_Error FLA_Hemm_ll_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Hemm_ll_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Hemm_ll_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Hemm_ll_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Hemm_ll_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Hemm_ll_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Hemm_ll_unb_var7( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Hemm_ll_unb_var8( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Hemm_ll_unb_var9( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Hemm_ll_unb_var10( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );

// end FLA_Hemm_ll.h
// begin FLA_Hemm_lu.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Hemm_lu_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_lu_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_lu_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_lu_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_lu_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_lu_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_lu_blk_var7( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_lu_blk_var8( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_lu_blk_var9( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_lu_blk_var10( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );

FLA_Error FLA_Hemm_lu_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Hemm_lu_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Hemm_lu_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Hemm_lu_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Hemm_lu_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Hemm_lu_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Hemm_lu_unb_var7( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Hemm_lu_unb_var8( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Hemm_lu_unb_var9( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Hemm_lu_unb_var10( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );

// end FLA_Hemm_lu.h
// begin FLA_Hemm_rl.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Hemm_rl_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_rl_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_rl_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_rl_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_rl_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_rl_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_rl_blk_var7( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_rl_blk_var8( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_rl_blk_var9( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_rl_blk_var10( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );

FLA_Error FLA_Hemm_rl_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Hemm_rl_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Hemm_rl_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Hemm_rl_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Hemm_rl_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Hemm_rl_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Hemm_rl_unb_var7( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Hemm_rl_unb_var8( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Hemm_rl_unb_var9( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Hemm_rl_unb_var10( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );

// end FLA_Hemm_rl.h
// begin FLA_Hemm_ru.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Hemm_ru_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_ru_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_ru_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_ru_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_ru_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_ru_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_ru_blk_var7( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_ru_blk_var8( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_ru_blk_var9( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_ru_blk_var10( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );

FLA_Error FLA_Hemm_ru_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Hemm_ru_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Hemm_ru_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Hemm_ru_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Hemm_ru_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Hemm_ru_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Hemm_ru_unb_var7( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Hemm_ru_unb_var8( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Hemm_ru_unb_var9( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Hemm_ru_unb_var10( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );

// end FLA_Hemm_ru.h

FLA_Error FLA_Hemm_internal( FLA_Side side, FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );

FLA_Error FLA_Hemm_ll( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_lu( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_rl( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );
FLA_Error FLA_Hemm_ru( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_hemm_t* cntl );

// end FLA_Hemm.h
// begin FLA_Herk.h


// begin FLA_Herk_lh.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Herk_lh_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_herk_t* cntl );
FLA_Error FLA_Herk_lh_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_herk_t* cntl );
FLA_Error FLA_Herk_lh_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_herk_t* cntl );
FLA_Error FLA_Herk_lh_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_herk_t* cntl );
FLA_Error FLA_Herk_lh_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_herk_t* cntl );
FLA_Error FLA_Herk_lh_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_herk_t* cntl );

FLA_Error FLA_Herk_lh_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Herk_lh_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Herk_lh_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Herk_lh_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Herk_lh_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Herk_lh_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );

// end FLA_Herk_lh.h
// begin FLA_Herk_ln.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Herk_ln_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_herk_t* cntl );
FLA_Error FLA_Herk_ln_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_herk_t* cntl );
FLA_Error FLA_Herk_ln_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_herk_t* cntl );
FLA_Error FLA_Herk_ln_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_herk_t* cntl );
FLA_Error FLA_Herk_ln_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_herk_t* cntl );
FLA_Error FLA_Herk_ln_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_herk_t* cntl );

FLA_Error FLA_Herk_ln_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Herk_ln_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Herk_ln_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Herk_ln_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Herk_ln_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Herk_ln_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );

// end FLA_Herk_ln.h
// begin FLA_Herk_uh.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Herk_uh_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_herk_t* cntl );
FLA_Error FLA_Herk_uh_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_herk_t* cntl );
FLA_Error FLA_Herk_uh_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_herk_t* cntl );
FLA_Error FLA_Herk_uh_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_herk_t* cntl );
FLA_Error FLA_Herk_uh_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_herk_t* cntl );
FLA_Error FLA_Herk_uh_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_herk_t* cntl );

FLA_Error FLA_Herk_uh_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Herk_uh_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Herk_uh_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Herk_uh_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Herk_uh_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Herk_uh_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );

// end FLA_Herk_uh.h
// begin FLA_Herk_un.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Herk_un_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_herk_t* cntl );
FLA_Error FLA_Herk_un_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_herk_t* cntl );
FLA_Error FLA_Herk_un_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_herk_t* cntl );
FLA_Error FLA_Herk_un_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_herk_t* cntl );
FLA_Error FLA_Herk_un_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_herk_t* cntl );
FLA_Error FLA_Herk_un_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_herk_t* cntl );

FLA_Error FLA_Herk_un_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Herk_un_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Herk_un_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Herk_un_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Herk_un_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Herk_un_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );

// end FLA_Herk_un.h

FLA_Error FLA_Herk_internal( FLA_Uplo uplo, FLA_Trans trans, FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_herk_t* cntl );

FLA_Error FLA_Herk_lh( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_herk_t* cntl );
FLA_Error FLA_Herk_ln( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_herk_t* cntl );
FLA_Error FLA_Herk_uh( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_herk_t* cntl );
FLA_Error FLA_Herk_un( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_herk_t* cntl );

// end FLA_Herk.h
// begin FLA_Her2k.h


// begin FLA_Her2k_lh.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Her2k_lh_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_lh_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_lh_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_lh_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_lh_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_lh_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_lh_blk_var7( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_lh_blk_var8( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_lh_blk_var9( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_lh_blk_var10( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );

FLA_Error FLA_Her2k_lh_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Her2k_lh_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Her2k_lh_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Her2k_lh_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Her2k_lh_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Her2k_lh_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Her2k_lh_unb_var7( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Her2k_lh_unb_var8( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Her2k_lh_unb_var9( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Her2k_lh_unb_var10( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );

// end FLA_Her2k_lh.h
// begin FLA_Her2k_ln.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Her2k_ln_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_ln_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_ln_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_ln_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_ln_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_ln_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_ln_blk_var7( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_ln_blk_var8( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_ln_blk_var9( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_ln_blk_var10( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );

FLA_Error FLA_Her2k_ln_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Her2k_ln_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Her2k_ln_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Her2k_ln_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Her2k_ln_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Her2k_ln_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Her2k_ln_unb_var7( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Her2k_ln_unb_var8( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Her2k_ln_unb_var9( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Her2k_ln_unb_var10( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );

// end FLA_Her2k_ln.h
// begin FLA_Her2k_uh.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Her2k_uh_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_uh_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_uh_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_uh_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_uh_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_uh_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_uh_blk_var7( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_uh_blk_var8( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_uh_blk_var9( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_uh_blk_var10( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );

FLA_Error FLA_Her2k_uh_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Her2k_uh_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Her2k_uh_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Her2k_uh_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Her2k_uh_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Her2k_uh_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Her2k_uh_unb_var7( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Her2k_uh_unb_var8( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Her2k_uh_unb_var9( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Her2k_uh_unb_var10( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );

// end FLA_Her2k_uh.h
// begin FLA_Her2k_un.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Her2k_un_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_un_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_un_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_un_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_un_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_un_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_un_blk_var7( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_un_blk_var8( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_un_blk_var9( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_un_blk_var10( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );

FLA_Error FLA_Her2k_un_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Her2k_un_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Her2k_un_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Her2k_un_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Her2k_un_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Her2k_un_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Her2k_un_unb_var7( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Her2k_un_unb_var8( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Her2k_un_unb_var9( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Her2k_un_unb_var10( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );

// end FLA_Her2k_un.h

FLA_Error FLA_Her2k_internal( FLA_Uplo uplo, FLA_Trans trans, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );

FLA_Error FLA_Her2k_lh( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_ln( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_uh( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );
FLA_Error FLA_Her2k_un( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_her2k_t* cntl );

// end FLA_Her2k.h
// begin FLA_Symm.h


// begin FLA_Symm_ll.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Symm_ll_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_ll_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_ll_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_ll_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_ll_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_ll_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_ll_blk_var7( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_ll_blk_var8( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_ll_blk_var9( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_ll_blk_var10( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );

FLA_Error FLA_Symm_ll_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Symm_ll_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Symm_ll_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Symm_ll_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Symm_ll_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Symm_ll_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Symm_ll_unb_var7( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Symm_ll_unb_var8( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Symm_ll_unb_var9( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Symm_ll_unb_var10( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );

// end FLA_Symm_ll.h
// begin FLA_Symm_lu.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Symm_lu_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_lu_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_lu_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_lu_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_lu_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_lu_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_lu_blk_var7( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_lu_blk_var8( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_lu_blk_var9( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_lu_blk_var10( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );

FLA_Error FLA_Symm_lu_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Symm_lu_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Symm_lu_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Symm_lu_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Symm_lu_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Symm_lu_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Symm_lu_unb_var7( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Symm_lu_unb_var8( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Symm_lu_unb_var9( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Symm_lu_unb_var10( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );

// end FLA_Symm_lu.h
// begin FLA_Symm_rl.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Symm_rl_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_rl_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_rl_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_rl_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_rl_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_rl_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_rl_blk_var7( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_rl_blk_var8( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_rl_blk_var9( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_rl_blk_var10( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );

FLA_Error FLA_Symm_rl_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Symm_rl_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Symm_rl_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Symm_rl_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Symm_rl_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Symm_rl_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Symm_rl_unb_var7( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Symm_rl_unb_var8( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Symm_rl_unb_var9( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Symm_rl_unb_var10( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );

// end FLA_Symm_rl.h
// begin FLA_Symm_ru.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Symm_ru_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_ru_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_ru_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_ru_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_ru_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_ru_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_ru_blk_var7( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_ru_blk_var8( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_ru_blk_var9( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_ru_blk_var10( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );

FLA_Error FLA_Symm_ru_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Symm_ru_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Symm_ru_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Symm_ru_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Symm_ru_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Symm_ru_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Symm_ru_unb_var7( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Symm_ru_unb_var8( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Symm_ru_unb_var9( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Symm_ru_unb_var10( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );

// end FLA_Symm_ru.h

FLA_Error FLA_Symm_internal( FLA_Side side, FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );

FLA_Error FLA_Symm_ll( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_lu( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_rl( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );
FLA_Error FLA_Symm_ru( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_symm_t* cntl );

// end FLA_Symm.h
// begin FLA_Syrk.h


// begin FLA_Syrk_ln.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Syrk_ln_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_syrk_t* cntl );
FLA_Error FLA_Syrk_ln_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_syrk_t* cntl );
FLA_Error FLA_Syrk_ln_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_syrk_t* cntl );
FLA_Error FLA_Syrk_ln_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_syrk_t* cntl );
FLA_Error FLA_Syrk_ln_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_syrk_t* cntl );
FLA_Error FLA_Syrk_ln_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_syrk_t* cntl );

FLA_Error FLA_Syrk_ln_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syrk_ln_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syrk_ln_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syrk_ln_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syrk_ln_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syrk_ln_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );

// end FLA_Syrk_ln.h
// begin FLA_Syrk_lt.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Syrk_lt_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_syrk_t* cntl );
FLA_Error FLA_Syrk_lt_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_syrk_t* cntl );
FLA_Error FLA_Syrk_lt_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_syrk_t* cntl );
FLA_Error FLA_Syrk_lt_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_syrk_t* cntl );
FLA_Error FLA_Syrk_lt_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_syrk_t* cntl );
FLA_Error FLA_Syrk_lt_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_syrk_t* cntl );

FLA_Error FLA_Syrk_lt_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syrk_lt_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syrk_lt_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syrk_lt_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syrk_lt_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syrk_lt_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );

// end FLA_Syrk_lt.h
// begin FLA_Syrk_un.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Syrk_un_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_syrk_t* cntl );
FLA_Error FLA_Syrk_un_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_syrk_t* cntl );
FLA_Error FLA_Syrk_un_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_syrk_t* cntl );
FLA_Error FLA_Syrk_un_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_syrk_t* cntl );
FLA_Error FLA_Syrk_un_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_syrk_t* cntl );
FLA_Error FLA_Syrk_un_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_syrk_t* cntl );

FLA_Error FLA_Syrk_un_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syrk_un_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syrk_un_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syrk_un_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syrk_un_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syrk_un_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );

// end FLA_Syrk_un.h
// begin FLA_Syrk_ut.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Syrk_ut_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_syrk_t* cntl );
FLA_Error FLA_Syrk_ut_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_syrk_t* cntl );
FLA_Error FLA_Syrk_ut_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_syrk_t* cntl );
FLA_Error FLA_Syrk_ut_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_syrk_t* cntl );
FLA_Error FLA_Syrk_ut_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_syrk_t* cntl );
FLA_Error FLA_Syrk_ut_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_syrk_t* cntl );

FLA_Error FLA_Syrk_ut_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syrk_ut_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syrk_ut_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syrk_ut_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syrk_ut_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syrk_ut_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C );

// end FLA_Syrk_ut.h

FLA_Error FLA_Syrk_internal( FLA_Uplo uplo, FLA_Trans trans, FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_syrk_t* cntl );

FLA_Error FLA_Syrk_ln( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_syrk_t* cntl );
FLA_Error FLA_Syrk_lt( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_syrk_t* cntl );
FLA_Error FLA_Syrk_un( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_syrk_t* cntl );
FLA_Error FLA_Syrk_ut( FLA_Obj alpha, FLA_Obj A, FLA_Obj beta, FLA_Obj C, fla_syrk_t* cntl );

// end FLA_Syrk.h
// begin FLA_Syr2k.h


// begin FLA_Syr2k_ln.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Syr2k_ln_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_ln_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_ln_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_ln_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_ln_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_ln_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_ln_blk_var7( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_ln_blk_var8( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_ln_blk_var9( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_ln_blk_var10( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );

FLA_Error FLA_Syr2k_ln_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k_ln_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k_ln_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k_ln_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k_ln_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k_ln_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k_ln_unb_var7( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k_ln_unb_var8( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k_ln_unb_var9( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k_ln_unb_var10( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );

// end FLA_Syr2k_ln.h
// begin FLA_Syr2k_lt.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Syr2k_lt_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_lt_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_lt_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_lt_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_lt_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_lt_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_lt_blk_var7( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_lt_blk_var8( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_lt_blk_var9( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_lt_blk_var10( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );

FLA_Error FLA_Syr2k_lt_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k_lt_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k_lt_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k_lt_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k_lt_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k_lt_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k_lt_unb_var7( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k_lt_unb_var8( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k_lt_unb_var9( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k_lt_unb_var10( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );

// end FLA_Syr2k_lt.h
// begin FLA_Syr2k_un.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Syr2k_un_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_un_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_un_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_un_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_un_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_un_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_un_blk_var7( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_un_blk_var8( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_un_blk_var9( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_un_blk_var10( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );

FLA_Error FLA_Syr2k_un_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k_un_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k_un_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k_un_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k_un_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k_un_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k_un_unb_var7( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k_un_unb_var8( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k_un_unb_var9( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k_un_unb_var10( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );

// end FLA_Syr2k_un.h
// begin FLA_Syr2k_ut.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Syr2k_ut_blk_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_ut_blk_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_ut_blk_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_ut_blk_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_ut_blk_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_ut_blk_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_ut_blk_var7( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_ut_blk_var8( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_ut_blk_var9( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_ut_blk_var10( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );

FLA_Error FLA_Syr2k_ut_unb_var1( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k_ut_unb_var2( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k_ut_unb_var3( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k_ut_unb_var4( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k_ut_unb_var5( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k_ut_unb_var6( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k_ut_unb_var7( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k_ut_unb_var8( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k_ut_unb_var9( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );
FLA_Error FLA_Syr2k_ut_unb_var10( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C );

// end FLA_Syr2k_ut.h

FLA_Error FLA_Syr2k_internal( FLA_Uplo uplo, FLA_Trans trans, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );

FLA_Error FLA_Syr2k_ln( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_lt( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_un( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );
FLA_Error FLA_Syr2k_ut( FLA_Obj alpha, FLA_Obj A, FLA_Obj B, FLA_Obj beta, FLA_Obj C, fla_syr2k_t* cntl );

// end FLA_Syr2k.h
// begin FLA_Trmm.h


// begin FLA_Trmm_llc.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trmm_llc_blk_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_llc_blk_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_llc_blk_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_llc_blk_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_llc_unb_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_llc_unb_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_llc_unb_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_llc_unb_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );

// end FLA_Trmm_llc.h
// begin FLA_Trmm_llh.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trmm_llh_blk_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_llh_blk_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_llh_blk_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_llh_blk_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_llh_unb_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_llh_unb_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_llh_unb_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_llh_unb_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );

// end FLA_Trmm_llh.h
// begin FLA_Trmm_lln.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trmm_lln_blk_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_lln_blk_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_lln_blk_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_lln_blk_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_lln_unb_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_lln_unb_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_lln_unb_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_lln_unb_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );

// end FLA_Trmm_lln.h
// begin FLA_Trmm_llt.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trmm_llt_blk_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_llt_blk_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_llt_blk_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_llt_blk_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_llt_unb_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_llt_unb_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_llt_unb_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_llt_unb_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );

// end FLA_Trmm_llt.h
// begin FLA_Trmm_luc.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trmm_luc_blk_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_luc_blk_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_luc_blk_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_luc_blk_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_luc_unb_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_luc_unb_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_luc_unb_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_luc_unb_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );

// end FLA_Trmm_luc.h
// begin FLA_Trmm_luh.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trmm_luh_blk_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_luh_blk_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_luh_blk_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_luh_blk_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_luh_unb_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_luh_unb_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_luh_unb_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_luh_unb_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );

// end FLA_Trmm_luh.h
// begin FLA_Trmm_lun.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trmm_lun_blk_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_lun_blk_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_lun_blk_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_lun_blk_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_lun_unb_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_lun_unb_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_lun_unb_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_lun_unb_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );

// end FLA_Trmm_lun.h
// begin FLA_Trmm_lut.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trmm_lut_blk_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_lut_blk_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_lut_blk_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_lut_blk_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_lut_unb_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_lut_unb_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_lut_unb_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_lut_unb_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );

// end FLA_Trmm_lut.h
// begin FLA_Trmm_rlc.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trmm_rlc_blk_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_rlc_blk_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_rlc_blk_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_rlc_blk_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_rlc_unb_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_rlc_unb_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_rlc_unb_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_rlc_unb_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );

// end FLA_Trmm_rlc.h
// begin FLA_Trmm_rlh.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trmm_rlh_blk_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_rlh_blk_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_rlh_blk_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_rlh_blk_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_rlh_unb_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_rlh_unb_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_rlh_unb_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_rlh_unb_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );

// end FLA_Trmm_rlh.h
// begin FLA_Trmm_rln.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trmm_rln_blk_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_rln_blk_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_rln_blk_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_rln_blk_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_rln_unb_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_rln_unb_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_rln_unb_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_rln_unb_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );

// end FLA_Trmm_rln.h
// begin FLA_Trmm_rlt.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trmm_rlt_blk_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_rlt_blk_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_rlt_blk_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_rlt_blk_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_rlt_unb_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_rlt_unb_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_rlt_unb_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_rlt_unb_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );

// end FLA_Trmm_rlt.h
// begin FLA_Trmm_ruc.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trmm_ruc_blk_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_ruc_blk_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_ruc_blk_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_ruc_blk_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_ruc_unb_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_ruc_unb_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_ruc_unb_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_ruc_unb_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );

// end FLA_Trmm_ruc.h
// begin FLA_Trmm_ruh.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trmm_ruh_blk_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_ruh_blk_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_ruh_blk_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_ruh_blk_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_ruh_unb_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_ruh_unb_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_ruh_unb_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_ruh_unb_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );

// end FLA_Trmm_ruh.h
// begin FLA_Trmm_run.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trmm_run_blk_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_run_blk_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_run_blk_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_run_blk_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_run_unb_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_run_unb_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_run_unb_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_run_unb_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );

// end FLA_Trmm_run.h
// begin FLA_Trmm_rut.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trmm_rut_blk_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_rut_blk_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_rut_blk_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_rut_blk_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_rut_unb_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_rut_unb_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_rut_unb_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trmm_rut_unb_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );

// end FLA_Trmm_rut.h

FLA_Error FLA_Trmm_internal( FLA_Side side, FLA_Uplo uplo, FLA_Trans transa, FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );

FLA_Error FLA_Trmm_llc( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_llh( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_lln( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_llt( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_luc( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_luh( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_lun( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_lut( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_rlc( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_rlh( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_rln( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_rlt( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_ruc( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_ruh( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_run( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );
FLA_Error FLA_Trmm_rut( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trmm_t* cntl );

// end FLA_Trmm.h
// begin FLA_Trsm.h


// begin FLA_Trsm_llc.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trsm_llc_blk_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_llc_blk_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_llc_blk_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_llc_blk_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_llc_unb_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_llc_unb_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_llc_unb_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_llc_unb_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );

// end FLA_Trsm_llc.h
// begin FLA_Trsm_llh.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trsm_llh_blk_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_llh_blk_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_llh_blk_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_llh_blk_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_llh_unb_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_llh_unb_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_llh_unb_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_llh_unb_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );

// end FLA_Trsm_llh.h
// begin FLA_Trsm_lln.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trsm_lln_blk_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_lln_blk_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_lln_blk_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_lln_blk_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_lln_unb_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_lln_unb_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_lln_unb_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_lln_unb_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );

// end FLA_Trsm_lln.h
// begin FLA_Trsm_llt.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trsm_llt_blk_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_llt_blk_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_llt_blk_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_llt_blk_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_llt_unb_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_llt_unb_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_llt_unb_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_llt_unb_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );

// end FLA_Trsm_llt.h
// begin FLA_Trsm_luc.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trsm_luc_blk_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_luc_blk_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_luc_blk_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_luc_blk_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_luc_unb_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_luc_unb_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_luc_unb_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_luc_unb_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );

// end FLA_Trsm_luc.h
// begin FLA_Trsm_luh.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trsm_luh_blk_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_luh_blk_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_luh_blk_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_luh_blk_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_luh_unb_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_luh_unb_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_luh_unb_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_luh_unb_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );

// end FLA_Trsm_luh.h
// begin FLA_Trsm_lun.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trsm_lun_blk_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_lun_blk_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_lun_blk_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_lun_blk_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_lun_unb_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_lun_unb_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_lun_unb_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_lun_unb_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );

// end FLA_Trsm_lun.h
// begin FLA_Trsm_lut.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trsm_lut_blk_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_lut_blk_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_lut_blk_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_lut_blk_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_lut_unb_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_lut_unb_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_lut_unb_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_lut_unb_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );

// end FLA_Trsm_lut.h
// begin FLA_Trsm_rlc.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trsm_rlc_blk_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_rlc_blk_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_rlc_blk_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_rlc_blk_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_rlc_unb_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_rlc_unb_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_rlc_unb_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_rlc_unb_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );

// end FLA_Trsm_rlc.h
// begin FLA_Trsm_rlh.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trsm_rlh_blk_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_rlh_blk_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_rlh_blk_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_rlh_blk_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_rlh_unb_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_rlh_unb_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_rlh_unb_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_rlh_unb_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );

// end FLA_Trsm_rlh.h
// begin FLA_Trsm_rln.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trsm_rln_blk_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_rln_blk_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_rln_blk_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_rln_blk_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_rln_unb_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_rln_unb_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_rln_unb_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_rln_unb_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );

// end FLA_Trsm_rln.h
// begin FLA_Trsm_rlt.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trsm_rlt_blk_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_rlt_blk_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_rlt_blk_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_rlt_blk_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_rlt_unb_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_rlt_unb_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_rlt_unb_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_rlt_unb_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );

// end FLA_Trsm_rlt.h
// begin FLA_Trsm_ruc.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trsm_ruc_blk_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_ruc_blk_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_ruc_blk_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_ruc_blk_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_ruc_unb_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_ruc_unb_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_ruc_unb_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_ruc_unb_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );

// end FLA_Trsm_ruc.h
// begin FLA_Trsm_ruh.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trsm_ruh_blk_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_ruh_blk_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_ruh_blk_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_ruh_blk_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_ruh_unb_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_ruh_unb_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_ruh_unb_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_ruh_unb_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );

// end FLA_Trsm_ruh.h
// begin FLA_Trsm_run.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trsm_run_blk_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_run_blk_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_run_blk_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_run_blk_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_run_unb_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_run_unb_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_run_unb_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_run_unb_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );

// end FLA_Trsm_run.h
// begin FLA_Trsm_rut.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trsm_rut_blk_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_rut_blk_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_rut_blk_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_rut_blk_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_rut_unb_var1( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_rut_unb_var2( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_rut_unb_var3( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );
FLA_Error FLA_Trsm_rut_unb_var4( FLA_Diag diagA, FLA_Obj alpha, FLA_Obj A, FLA_Obj B );

// end FLA_Trsm_rut.h

FLA_Error FLA_Trsm_internal( FLA_Side side, FLA_Uplo uplo, FLA_Trans transa, FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );

FLA_Error FLA_Trsm_llc( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_llh( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_lln( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_llt( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_luc( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_luh( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_lun( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_lut( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_rlc( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_rlh( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_rln( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_rlt( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_ruc( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_ruh( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_run( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );
FLA_Error FLA_Trsm_rut( FLA_Diag diag, FLA_Obj alpha, FLA_Obj A, FLA_Obj B, fla_trsm_t* cntl );

// end FLA_Trsm.h

// end FLA_blas_var_prototypes.h
// begin FLA_lapack_var_prototypes.h


// Factorizations
// begin FLA_Chol.h


// begin FLA_Chol_l.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Chol_l_blk_var1( FLA_Obj A, fla_chol_t* cntl );
FLA_Error FLA_Chol_l_blk_var2( FLA_Obj A, fla_chol_t* cntl );
FLA_Error FLA_Chol_l_blk_var3( FLA_Obj A, fla_chol_t* cntl );

FLA_Error FLA_Chol_l_unb_var1( FLA_Obj A );
FLA_Error FLA_Chol_l_unb_var2( FLA_Obj A );
FLA_Error FLA_Chol_l_unb_var3( FLA_Obj A );

FLA_Error FLA_Chol_l_opt_var1( FLA_Obj A );
FLA_Error FLA_Chol_l_ops_var1( integer mn_A,
                               float*    A, integer rs_A, integer cs_A );
FLA_Error FLA_Chol_l_opd_var1( integer mn_A,
                               double*   A, integer rs_A, integer cs_A );
FLA_Error FLA_Chol_l_opc_var1( integer mn_A,
                               scomplex* A, integer rs_A, integer cs_A );
FLA_Error FLA_Chol_l_opz_var1( integer mn_A,
                               dcomplex* A, integer rs_A, integer cs_A );

FLA_Error FLA_Chol_l_opt_var2( FLA_Obj A );
FLA_Error FLA_Chol_l_ops_var2( integer mn_A,
                               float*    A, integer rs_A, integer cs_A );
FLA_Error FLA_Chol_l_opd_var2( integer mn_A,
                               double*   A, integer rs_A, integer cs_A );
FLA_Error FLA_Chol_l_opc_var2( integer mn_A,
                               scomplex* A, integer rs_A, integer cs_A );
FLA_Error FLA_Chol_l_opz_var2( integer mn_A,
                               dcomplex* A, integer rs_A, integer cs_A );

FLA_Error FLA_Chol_l_opt_var3( FLA_Obj A );
FLA_Error FLA_Chol_l_ops_var3( integer mn_A,
                               float*    A, integer rs_A, integer cs_A );
FLA_Error FLA_Chol_l_opd_var3( integer mn_A,
                               double*   A, integer rs_A, integer cs_A );
FLA_Error FLA_Chol_l_opc_var3( integer mn_A,
                               scomplex* A, integer rs_A, integer cs_A );
FLA_Error FLA_Chol_l_opz_var3( integer mn_A,
                               dcomplex* A, integer rs_A, integer cs_A );

// end FLA_Chol_l.h
// begin FLA_Chol_u.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Chol_u_blk_var1( FLA_Obj A, fla_chol_t* cntl );
FLA_Error FLA_Chol_u_blk_var2( FLA_Obj A, fla_chol_t* cntl );
FLA_Error FLA_Chol_u_blk_var3( FLA_Obj A, fla_chol_t* cntl );

FLA_Error FLA_Chol_u_unb_var1( FLA_Obj A );
FLA_Error FLA_Chol_u_unb_var2( FLA_Obj A );
FLA_Error FLA_Chol_u_unb_var3( FLA_Obj A );

FLA_Error FLA_Chol_u_opt_var1( FLA_Obj A );
FLA_Error FLA_Chol_u_ops_var1( integer mn_A,
                               float*    A, integer rs_A, integer cs_A );
FLA_Error FLA_Chol_u_opd_var1( integer mn_A,
                               double*   A, integer rs_A, integer cs_A );
FLA_Error FLA_Chol_u_opc_var1( integer mn_A,
                               scomplex* A, integer rs_A, integer cs_A );
FLA_Error FLA_Chol_u_opz_var1( integer mn_A,
                               dcomplex* A, integer rs_A, integer cs_A );

FLA_Error FLA_Chol_u_opt_var2( FLA_Obj A );
FLA_Error FLA_Chol_u_ops_var2( integer mn_A,
                               float*    A, integer rs_A, integer cs_A );
FLA_Error FLA_Chol_u_opd_var2( integer mn_A,
                               double*   A, integer rs_A, integer cs_A );
FLA_Error FLA_Chol_u_opc_var2( integer mn_A,
                               scomplex* A, integer rs_A, integer cs_A );
FLA_Error FLA_Chol_u_opz_var2( integer mn_A,
                               dcomplex* A, integer rs_A, integer cs_A );

FLA_Error FLA_Chol_u_opt_var3( FLA_Obj A );
FLA_Error FLA_Chol_u_ops_var3( integer mn_A,
                               float*    A, integer rs_A, integer cs_A );
FLA_Error FLA_Chol_u_opd_var3( integer mn_A,
                               double*   A, integer rs_A, integer cs_A );
FLA_Error FLA_Chol_u_opc_var3( integer mn_A,
                               scomplex* A, integer rs_A, integer cs_A );
FLA_Error FLA_Chol_u_opz_var3( integer mn_A,
                               dcomplex* A, integer rs_A, integer cs_A );

// end FLA_Chol_u.h

FLA_Error FLA_Chol_internal( FLA_Uplo uplo, FLA_Obj A, fla_chol_t* cntl );
FLA_Error FLA_Chol_l( FLA_Obj A, fla_chol_t* cntl );
FLA_Error FLA_Chol_u( FLA_Obj A, fla_chol_t* cntl );

FLA_Error FLA_Chol_solve( FLA_Uplo uplo, FLA_Obj A, FLA_Obj B, FLA_Obj X );
FLA_Error FLASH_Chol_solve( FLA_Uplo uplo, FLA_Obj A, FLA_Obj B, FLA_Obj X );
// end FLA_Chol.h
// begin FLA_LU_nopiv.h


// begin FLA_LU_nopiv_vars.h




// skipped #include "FLAME.h" 

FLA_Error FLA_LU_nopiv_blk_var1( FLA_Obj A, fla_lu_t* cntl );
FLA_Error FLA_LU_nopiv_blk_var2( FLA_Obj A, fla_lu_t* cntl );
FLA_Error FLA_LU_nopiv_blk_var3( FLA_Obj A, fla_lu_t* cntl );
FLA_Error FLA_LU_nopiv_blk_var4( FLA_Obj A, fla_lu_t* cntl );
FLA_Error FLA_LU_nopiv_blk_var5( FLA_Obj A, fla_lu_t* cntl );

FLA_Error FLA_LU_nopiv_unb_var1( FLA_Obj A );
FLA_Error FLA_LU_nopiv_unb_var2( FLA_Obj A );
FLA_Error FLA_LU_nopiv_unb_var3( FLA_Obj A );
FLA_Error FLA_LU_nopiv_unb_var4( FLA_Obj A );
FLA_Error FLA_LU_nopiv_unb_var5( FLA_Obj A );

FLA_Error FLA_LU_nopiv_opt_var1( FLA_Obj A );
FLA_Error FLA_LU_nopiv_ops_var1( integer m_A,
                                 integer n_A,
                                 float* A, integer rs_A, integer cs_A );
FLA_Error FLA_LU_nopiv_opd_var1( integer m_A,
                                 integer n_A,
                                 double* A, integer rs_A, integer cs_A );
FLA_Error FLA_LU_nopiv_opc_var1( integer m_A,
                                 integer n_A,
                                 scomplex* A, integer rs_A, integer cs_A );
FLA_Error FLA_LU_nopiv_opz_var1( integer m_A,
                                 integer n_A,
                                 dcomplex* A, integer rs_A, integer cs_A );

FLA_Error FLA_LU_nopiv_opt_var2( FLA_Obj A );
FLA_Error FLA_LU_nopiv_ops_var2( integer m_A,
                                 integer n_A,
                                 float* A, integer rs_A, integer cs_A );
FLA_Error FLA_LU_nopiv_opd_var2( integer m_A,
                                 integer n_A,
                                 double* A, integer rs_A, integer cs_A );
FLA_Error FLA_LU_nopiv_opc_var2( integer m_A,
                                 integer n_A,
                                 scomplex* A, integer rs_A, integer cs_A );
FLA_Error FLA_LU_nopiv_opz_var2( integer m_A,
                                 integer n_A,
                                 dcomplex* A, integer rs_A, integer cs_A );

FLA_Error FLA_LU_nopiv_opt_var3( FLA_Obj A );
FLA_Error FLA_LU_nopiv_ops_var3( integer m_A,
                                 integer n_A,
                                 float* A, integer rs_A, integer cs_A );
FLA_Error FLA_LU_nopiv_opd_var3( integer m_A,
                                 integer n_A,
                                 double* A, integer rs_A, integer cs_A );
FLA_Error FLA_LU_nopiv_opc_var3( integer m_A,
                                 integer n_A,
                                 scomplex* A, integer rs_A, integer cs_A );
FLA_Error FLA_LU_nopiv_opz_var3( integer m_A,
                                 integer n_A,
                                 dcomplex* A, integer rs_A, integer cs_A );

FLA_Error FLA_LU_nopiv_opt_var4( FLA_Obj A );
FLA_Error FLA_LU_nopiv_ops_var4( integer m_A,
                                 integer n_A,
                                 float* A, integer rs_A, integer cs_A );
FLA_Error FLA_LU_nopiv_opd_var4( integer m_A,
                                 integer n_A,
                                 double* A, integer rs_A, integer cs_A );
FLA_Error FLA_LU_nopiv_opc_var4( integer m_A,
                                 integer n_A,
                                 scomplex* A, integer rs_A, integer cs_A );
FLA_Error FLA_LU_nopiv_opz_var4( integer m_A,
                                 integer n_A,
                                 dcomplex* A, integer rs_A, integer cs_A );

FLA_Error FLA_LU_nopiv_opt_var5( FLA_Obj A );
FLA_Error FLA_LU_nopiv_ops_var5( integer m_A,
                                 integer n_A,
                                 float* A, integer rs_A, integer cs_A );
FLA_Error FLA_LU_nopiv_opd_var5( integer m_A,
                                 integer n_A,
                                 double* A, integer rs_A, integer cs_A );
FLA_Error FLA_LU_nopiv_opc_var5( integer m_A,
                                 integer n_A,
                                 scomplex* A, integer rs_A, integer cs_A );
FLA_Error FLA_LU_nopiv_opz_var5( integer m_A,
                                 integer n_A,
                                 dcomplex* A, integer rs_A, integer cs_A );

FLA_Error FLA_LU_nopiv_is_blk_var1( integer m_A, integer n_A,FLA_Obj A, float* buff_A, integer nfact, integer rs_A, integer cs_A );
FLA_Error FLA_LU_nopiv_id_blk_var1( integer m_A, integer n_A,FLA_Obj A, double* buff_A, integer nfact, integer rs_A, integer cs_A );
FLA_Error FLA_LU_nopiv_ic_blk_var1( integer m_A, integer n_A,FLA_Obj A, scomplex* buff_A, integer nfact, integer rs_A, integer cs_A );
FLA_Error FLA_LU_nopiv_iz_blk_var1( integer m_A, integer n_A,FLA_Obj A, dcomplex* buff_A, integer nfact, integer rs_A, integer cs_A );
FLA_Error FLA_LU_nopiv_is_unblk_var1( integer m_A,
                                      integer n_A,
                                      float* A, integer nfact, integer rs_A, integer cs_A );
FLA_Error FLA_LU_nopiv_id_unblk_var1( integer m_A,
                                      integer n_A,
                                      double* A, integer nfact, integer rs_A, integer cs_A );
FLA_Error FLA_LU_nopiv_ic_unblk_var1( integer m_A,
                                      integer n_A,
                                      scomplex* A, integer nfact, integer rs_A, integer cs_A );
FLA_Error FLA_LU_nopiv_iz_unblk_var1( integer m_A,
                                      integer n_A,
                                      dcomplex* A, integer nfact, integer rs_A, integer cs_A );
FLA_Error FLA_LU_nopiv_id_unblk_var2( integer m_A,
                                      integer n_A,
                                      double* A, integer nfact, integer rs_A, integer cs_A );
// end FLA_LU_nopiv_vars.h

FLA_Error FLA_LU_nopiv_internal( FLA_Obj A, fla_lu_t* cntl );

FLA_Error FLA_LU_nopiv_solve( FLA_Obj A, FLA_Obj B, FLA_Obj X );
FLA_Error FLASH_LU_nopiv_solve( FLA_Obj A, FLA_Obj B, FLA_Obj X );
// end FLA_LU_nopiv.h
// begin FLA_LU_piv.h




// begin FLA_LU_piv_vars.h


// skipped #include "FLAME.h" 

FLA_Error FLA_LU_piv_blk_var3( FLA_Obj A, FLA_Obj p, fla_lu_t* cntl );
FLA_Error FLA_LU_piv_blk_var4( FLA_Obj A, FLA_Obj p, fla_lu_t* cntl );
FLA_Error FLA_LU_piv_blk_var5( FLA_Obj A, FLA_Obj p, fla_lu_t* cntl );

FLA_Error FLA_LU_piv_unb_var3( FLA_Obj A, FLA_Obj p );
FLA_Error FLA_LU_piv_unb_var3b( FLA_Obj A, FLA_Obj p );
FLA_Error FLA_LU_piv_unb_var4( FLA_Obj A, FLA_Obj p );
FLA_Error FLA_LU_piv_unb_var5( FLA_Obj A, FLA_Obj p );

FLA_Error FLA_LU_piv_opt_var3( FLA_Obj A, FLA_Obj p );
FLA_Error FLA_LU_piv_ops_var3( integer m_A,
                               integer n_A,
                               float*    buff_A, integer rs_A, integer cs_A,
                               integer*      buff_p, integer inc_p );
FLA_Error FLA_LU_piv_opd_var3( integer m_A,
                               integer n_A,
                               double*   buff_A, integer rs_A, integer cs_A,
                               integer*      buff_p, integer inc_p );
FLA_Error FLA_LU_piv_opc_var3( integer m_A,
                               integer n_A,
                               scomplex* buff_A, integer rs_A, integer cs_A,
                               integer*      buff_p, integer inc_p );
FLA_Error FLA_LU_piv_opz_var3( integer m_A,
                               integer n_A,
                               dcomplex* buff_A, integer rs_A, integer cs_A,
                               integer*      buff_p, integer inc_p );

FLA_Error FLA_LU_piv_opt_var4( FLA_Obj A, FLA_Obj p );
FLA_Error FLA_LU_piv_ops_var4( integer m_A,
                               integer n_A,
                               float*    buff_A, integer rs_A, integer cs_A,
                               integer*      buff_p, integer inc_p );
FLA_Error FLA_LU_piv_opd_var4( integer m_A,
                               integer n_A,
                               double*   buff_A, integer rs_A, integer cs_A,
                               integer*      buff_p, integer inc_p );
FLA_Error FLA_LU_piv_opc_var4( integer m_A,
                               integer n_A,
                               scomplex* buff_A, integer rs_A, integer cs_A,
                               integer*      buff_p, integer inc_p );
FLA_Error FLA_LU_piv_opz_var4( integer m_A,
                               integer n_A,
                               dcomplex* buff_A, integer rs_A, integer cs_A,
                               integer*      buff_p, integer inc_p );

FLA_Error FLA_LU_piv_opt_var5( FLA_Obj A, FLA_Obj p );
FLA_Error FLA_LU_piv_ops_var5( integer m_A,
                               integer n_A,
                               float*    buff_A, integer rs_A, integer cs_A,
                               integer*      buff_p, integer inc_p );
FLA_Error FLA_LU_piv_opd_var5( integer m_A,
                               integer n_A,
                               double*   buff_A, integer rs_A, integer cs_A,
                               integer*      buff_p, integer inc_p );
FLA_Error FLA_LU_piv_opc_var5( integer m_A,
                               integer n_A,
                               scomplex* buff_A, integer rs_A, integer cs_A,
                               integer*      buff_p, integer inc_p );
FLA_Error FLA_LU_piv_opz_var5( integer m_A,
                               integer n_A,
                               dcomplex* buff_A, integer rs_A, integer cs_A,
                               integer*      buff_p, integer inc_p );
// end FLA_LU_piv_vars.h

FLA_Error FLA_LU_piv_internal( FLA_Obj A, FLA_Obj p, fla_lu_t* cntl );
integer   FLA_LU_piv_small_s_var0( integer *m, integer *n, real *a, integer *lda,
                                   integer *ipiv, integer *info );
integer   FLA_LU_piv_small_s_var1( integer *m, integer *n, real *a, integer *lda,
                                   integer *ipiv, integer *info );
integer   FLA_LU_piv_small_d_var0( integer *m, integer *n, doublereal *a, integer *lda,
                                   integer *ipiv, integer *info );
integer   FLA_LU_piv_small_d_var1( integer *m, integer *n, doublereal *a, integer *lda,
                                   integer *ipiv, integer *info );
integer   FLA_LU_piv_small_d_var2( integer *m, integer *n, doublereal *a, integer *lda,
                                   integer *ipiv, integer *info );
int   FLA_LU_piv_small_z_var0( integer *m, integer *n, dcomplex *a, integer *lda,
                                   integer *ipiv, integer *info);
int   FLA_LU_piv_z_var0(integer *m, integer *n, dcomplex *a, integer *lda, integer *ipiv, integer *info);
int   FLA_LU_piv_z_parallel( integer *m, integer *n, dcomplex *a, integer *lda, integer *ipiv, integer *info);
int   FLA_LU_piv_z_var1_parallel(integer* m, integer* n, dcomplex* a, integer* lda, integer* ipiv, integer* info);
integer   FLA_LU_piv_small_s_var0( integer *m, integer *n, real *a, integer *lda,
                                   integer *ipiv, integer *info );
integer   FLA_LU_piv_small_s_var1( integer *m, integer *n, real *a, integer *lda,
                                   integer *ipiv, integer *info );
int FLA_LU_piv_d_parallel( integer *m, integer *n, doublereal *a, integer *lda, integer *ipiv, integer *info);

int FLA_LU_piv_s_parallel( integer *m, integer *n, real *a, integer *lda, integer *ipiv, integer *info);

FLA_Error FLA_LU_piv_solve( FLA_Obj A, FLA_Obj p, FLA_Obj B, FLA_Obj X );

FLA_Error FLASH_LU_piv_solve( FLA_Obj A, FLA_Obj p, FLA_Obj B, FLA_Obj X );

integer lapack_cgetf2(integer *m, integer *n, scomplex *a, integer *lda,
	 integer *ipiv, integer *info);
integer lapack_cgetrf(integer *m, integer *n, scomplex *a, integer *lda,
	 integer *ipiv, integer *info);
integer lapack_dgetrf(integer *m, integer *n, doublereal *a, integer *
	lda, integer *ipiv, integer *info);
integer lapack_sgetf2(integer *m, integer *n, real *a, integer *lda,
	integer *ipiv, integer *info);
integer lapack_sgetrf(integer *m, integer *n, real *a, integer *lda,
	integer *ipiv, integer *info);
integer lapack_zgetf2(integer *m, integer *n, dcomplex *a,
	integer *lda, integer *ipiv, integer *info);
integer lapack_zgetrf(integer *m, integer *n, dcomplex *a,
	integer *lda, integer *ipiv, integer *info);
// end FLA_LU_piv.h
// begin FLA_LU_incpiv.h


// begin FLA_LU_incpiv_aux.h


// skipped #include "FLAME.h" 

FLA_Error FLA_SA_Apply_pivots( FLA_Obj C, FLA_Obj E, FLA_Obj p );
FLA_Error FLA_SA_LU_blk( FLA_Obj U,
                         FLA_Obj D, FLA_Obj p, FLA_Obj L, fla_dim_t nb_alg );
FLA_Error FLA_SA_LU_unb( FLA_Obj U, 
                         FLA_Obj D, FLA_Obj p, FLA_Obj L );
FLA_Error FLA_SA_FS_blk( FLA_Obj L,
                         FLA_Obj D, FLA_Obj p, FLA_Obj C,
                                               FLA_Obj E, fla_dim_t nb_alg );

FLA_Error FLASH_LU_incpiv_var1( FLA_Obj A, FLA_Obj p, FLA_Obj L, fla_dim_t nb_alg, fla_lu_t* cntl );
FLA_Error FLASH_LU_incpiv_var2( FLA_Obj A, FLA_Obj p, FLA_Obj L, FLA_Obj U, fla_dim_t nb_alg, fla_lu_t* cntl );
FLA_Error FLASH_Trsm_piv( FLA_Obj A, FLA_Obj B, FLA_Obj p, fla_trsm_t* cntl );
FLA_Error FLASH_SA_LU( FLA_Obj B, FLA_Obj C,
                       FLA_Obj D, FLA_Obj E, FLA_Obj p, FLA_Obj L, fla_dim_t nb_alg, fla_lu_t* cntl );
FLA_Error FLASH_SA_FS( FLA_Obj L,
                       FLA_Obj D, FLA_Obj p, FLA_Obj C,
                                             FLA_Obj E, fla_dim_t nb_alg, fla_gemm_t* cntl );

FLA_Error FLASH_FS_incpiv_aux1( FLA_Obj A, FLA_Obj p, FLA_Obj L, FLA_Obj b, fla_dim_t nb_alg );
FLA_Error FLASH_FS_incpiv_aux2( FLA_Obj L,
                                FLA_Obj D, FLA_Obj p, FLA_Obj C,
                                                      FLA_Obj E, fla_dim_t nb_alg );

// end FLA_LU_incpiv_aux.h

FLA_Error FLASH_LU_incpiv_create_hier_matrices( FLA_Obj A_flat, fla_dim_t depth, fla_dim_t* b_flash, fla_dim_t b_alg, FLA_Obj* A, FLA_Obj* p, FLA_Obj* L );
fla_dim_t     FLASH_LU_incpiv_determine_alg_blocksize( FLA_Obj A );

FLA_Error FLASH_LU_incpiv_noopt( FLA_Obj A, FLA_Obj p, FLA_Obj L );
FLA_Error FLASH_LU_incpiv_opt1( FLA_Obj A, FLA_Obj p, FLA_Obj L );

FLA_Error FLASH_LU_incpiv_solve( FLA_Obj A, FLA_Obj p, FLA_Obj L, FLA_Obj B, FLA_Obj X );
// end FLA_LU_incpiv.h
// begin FLA_QR_UT.h


// begin FLA_QR_UT_vars.h


FLA_Error FLA_QR_UT_unb_var1( FLA_Obj A, FLA_Obj t );
FLA_Error FLA_QR_UT_blk_var1( FLA_Obj A, FLA_Obj T, fla_qrut_t* cntl );
FLA_Error FLA_QR_UT_opt_var1( FLA_Obj A, FLA_Obj t );
FLA_Error FLA_QR_UT_ops_var1( integer m_A,
                              integer n_A,
                              float* A, integer rs_A, integer cs_A,
                              float* t, integer inc_t );
FLA_Error FLA_QR_UT_opd_var1( integer m_A,
                              integer n_A,
                              double* A, integer rs_A, integer cs_A,
                              double* t, integer inc_t );
FLA_Error FLA_QR_UT_opc_var1( integer m_A,
                              integer n_A,
                              scomplex* A, integer rs_A, integer cs_A,
                              scomplex* t, integer inc_t );
FLA_Error FLA_QR_UT_opz_var1( integer m_A,
                              integer n_A,
                              dcomplex* A, integer rs_A, integer cs_A,
                              dcomplex* t, integer inc_t );

FLA_Error FLA_QR_UT_unb_var2( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_QR_UT_blk_var2( FLA_Obj A, FLA_Obj T, fla_qrut_t* cntl );
FLA_Error FLA_QR_UT_opt_var2( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_QR_UT_ops_var2( integer m_A,
                              integer n_A,
                              float* A, integer rs_A, integer cs_A,
                              float* T, integer rs_T, integer cs_T );
FLA_Error FLA_QR_UT_opd_var2( integer m_A,
                              integer n_A,
                              double* A, integer rs_A, integer cs_A,
                              double* T, integer rs_T, integer cs_T );
FLA_Error FLA_QR_UT_opc_var2( integer m_A,
                              integer n_A,
                              scomplex* A, integer rs_A, integer cs_A,
                              scomplex* T, integer rs_T, integer cs_T );
FLA_Error FLA_QR_UT_opz_var2( integer m_A,
                              integer n_A,
                              dcomplex* A, integer rs_A, integer cs_A,
                              dcomplex* T, integer rs_T, integer cs_T );

FLA_Error FLA_QR_UT_blk_var3( FLA_Obj A, FLA_Obj T, fla_qrut_t* cntl );

// end FLA_QR_UT_vars.h

FLA_Error FLA_QR_UT( FLA_Obj A, FLA_Obj T );

FLA_Error FLA_QR_UT_internal( FLA_Obj A, FLA_Obj T, fla_qrut_t* cntl );
FLA_Error FLA_QR_UT_copy_internal( FLA_Obj A, FLA_Obj T, FLA_Obj U, fla_qrut_t* cntl );

FLA_Error FLA_QR_UT_create_T( FLA_Obj A, FLA_Obj* T );

FLA_Error FLA_QR_UT_recover_tau( FLA_Obj T, FLA_Obj tau );

FLA_Error FLA_QR_UT_solve( FLA_Obj A, FLA_Obj T, FLA_Obj B, FLA_Obj X );

FLA_Error FLASH_QR_UT( FLA_Obj A, FLA_Obj TW );
FLA_Error FLASH_QR_UT_create_hier_matrices( FLA_Obj A_flat, fla_dim_t depth, fla_dim_t* b_flash, FLA_Obj* A, FLA_Obj* TW );
FLA_Error FLASH_QR_UT_solve( FLA_Obj A, FLA_Obj T, FLA_Obj B, FLA_Obj X );


FLA_Error FLA_QR_UT_form_Q( FLA_Obj A, FLA_Obj T, FLA_Obj Q );
FLA_Error FLA_QR_UT_form_Q_blk_var1( FLA_Obj A, FLA_Obj T, FLA_Obj W );
FLA_Error FLA_QR_UT_form_Q_opt_var1( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_QR_UT_form_Q_ops_var1( integer       m_A,
                                     integer       n_AT,
                                     float*    buff_A, integer rs_A, integer cs_A,
                                     float*    buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_QR_UT_form_Q_opd_var1( integer       m_A,
                                     integer       n_AT,
                                     double*   buff_A, integer rs_A, integer cs_A,
                                     double*   buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_QR_UT_form_Q_opc_var1( integer       m_A,
                                     integer       n_AT,
                                     scomplex* buff_A, integer rs_A, integer cs_A,
                                     scomplex* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_QR_UT_form_Q_opz_var1( integer       m_A,
                                     integer       n_AT,
                                     dcomplex* buff_A, integer rs_A, integer cs_A,
                                     dcomplex* buff_T, integer rs_T, integer cs_T );
// end FLA_QR_UT.h
// begin FLA_QR_UT_piv.h


// begin FLA_QR_UT_piv_vars.h



// BLAS 2 version
FLA_Error FLA_QR_UT_piv_unb_var1( FLA_Obj A, FLA_Obj T, FLA_Obj w, FLA_Obj p );
FLA_Error FLA_QR_UT_piv_blk_var1( FLA_Obj A, FLA_Obj T, FLA_Obj w, FLA_Obj p, fla_qrut_t* cntl );

// BLAS 3 version
FLA_Error FLA_QR_UT_piv_unb_var2( FLA_Obj A, FLA_Obj T, FLA_Obj w, FLA_Obj p );
FLA_Error FLA_QR_UT_piv_blk_var2( FLA_Obj A, FLA_Obj T, FLA_Obj w, FLA_Obj p, fla_qrut_t* cntl );
FLA_Error FLA_Apply_H2_UT_piv_row( FLA_Obj tau, FLA_Obj a1t, FLA_Obj u1t, FLA_Obj W,
                                   FLA_Obj u2,  FLA_Obj A2,  FLA_Obj U2,  FLA_Obj w1t,
                                   FLA_Obj vt );

// end FLA_QR_UT_piv_vars.h

FLA_Error FLA_QR_UT_piv( FLA_Obj A, FLA_Obj T, FLA_Obj w, FLA_Obj p );

FLA_Error FLA_QR_UT_piv_internal( FLA_Obj A, FLA_Obj T, FLA_Obj w, FLA_Obj p, fla_qrut_t* cntl );
FLA_Error FLA_QR_UT_piv_colnorm( FLA_Obj alpha, FLA_Obj A, FLA_Obj b );

// The source files are located at src/base/flamec/check/lapack
FLA_Error FLA_QR_UT_piv_check( FLA_Obj A, FLA_Obj T, FLA_Obj w, FLA_Obj p );
FLA_Error FLA_QR_UT_piv_internal_check( FLA_Obj A, FLA_Obj T, FLA_Obj w, FLA_Obj p, fla_qrut_t* cntl );
FLA_Error FLA_QR_UT_piv_colnorm_check( FLA_Obj alpha, FLA_Obj A, FLA_Obj b );
// end FLA_QR_UT_piv.h
// begin FLA_EXT_geqrf.h


FLA_Error FLA_EXT_sgeqrf( integer m_A, integer n_A,
                          float* buff_A, integer cs_A,
                          float* buff_t,
                          float* buff_w,
                          integer* lwork,
                          integer* info );
FLA_Error FLA_EXT_dgeqrf( integer m_A, integer n_A,
                          double* buff_A, integer cs_A,
                          double* buff_t,
                          double* buff_w,
                          integer* lwork,
                          integer* info );
// end FLA_EXT_geqrf.h
// begin FLA_QR2_UT.h


// begin FLA_QR2_UT_vars.h


FLA_Error FLA_QR2_UT_blk_var1( FLA_Obj U,
                               FLA_Obj D, FLA_Obj T, fla_qr2ut_t* cntl );
FLA_Error FLA_QR2_UT_blk_var2( FLA_Obj U,
                               FLA_Obj D, FLA_Obj T, fla_qr2ut_t* cntl );

FLA_Error FLA_QR2_UT_unb_var1( FLA_Obj U,
                               FLA_Obj D, FLA_Obj T );

FLA_Error FLA_QR2_UT_opt_var1( FLA_Obj U,
                               FLA_Obj D, FLA_Obj T );

FLA_Error FLA_QR2_UT_ops_var1( integer m_UT,
                               integer m_D,
                               float* U, integer rs_U, integer cs_U,
                               float* D, integer rs_D, integer cs_D,
                               float* T, integer rs_T, integer cs_T );
FLA_Error FLA_QR2_UT_opd_var1( integer m_UT,
                               integer m_D,
                               double* U, integer rs_U, integer cs_U,
                               double* D, integer rs_D, integer cs_D,
                               double* T, integer rs_T, integer cs_T );
FLA_Error FLA_QR2_UT_opc_var1( integer m_UT,
                               integer m_D,
                               scomplex* U, integer rs_U, integer cs_U,
                               scomplex* D, integer rs_D, integer cs_D,
                               scomplex* T, integer rs_T, integer cs_T );
FLA_Error FLA_QR2_UT_opz_var1( integer m_UT,
                               integer m_D,
                               dcomplex* U, integer rs_U, integer cs_U,
                               dcomplex* D, integer rs_D, integer cs_D,
                               dcomplex* T, integer rs_T, integer cs_T );
// end FLA_QR2_UT_vars.h

FLA_Error FLASH_QR2_UT( FLA_Obj U,
                        FLA_Obj D, FLA_Obj T );

FLA_Error FLA_QR2_UT_internal( FLA_Obj U,
                               FLA_Obj D, FLA_Obj T, fla_qr2ut_t* cntl );

// end FLA_QR2_UT.h
// begin FLA_QR_UT_inc.h


FLA_Error FLASH_QR_UT_inc( FLA_Obj A, FLA_Obj TW );

FLA_Error FLASH_QR_UT_inc_noopt( FLA_Obj A, FLA_Obj TW );
FLA_Error FLASH_QR_UT_inc_opt1( FLA_Obj A, FLA_Obj TW );

FLA_Error FLA_QR_UT_inc_blk_var1( FLA_Obj A, FLA_Obj TW, fla_qrutinc_t* cntl );
FLA_Error FLA_QR_UT_inc_blk_var2( FLA_Obj A, FLA_Obj TW, FLA_Obj U, fla_qrutinc_t* cntl );

FLA_Error FLASH_QR_UT_inc_create_hier_matrices( FLA_Obj A_flat, fla_dim_t depth, fla_dim_t* b_flash, fla_dim_t b_alg, FLA_Obj* A, FLA_Obj* TW );
fla_dim_t     FLASH_QR_UT_inc_determine_alg_blocksize( FLA_Obj A );

FLA_Error FLASH_QR_UT_inc_solve( FLA_Obj A, FLA_Obj TW, FLA_Obj B, FLA_Obj X );

// end FLA_QR_UT_inc.h
// begin FLA_LQ_UT.h


// begin FLA_LQ_UT_vars.h


// skipped #include "FLAME.h" 

FLA_Error FLA_LQ_UT_unb_var1( FLA_Obj A, FLA_Obj t );
FLA_Error FLA_LQ_UT_blk_var1( FLA_Obj A, FLA_Obj T, fla_lqut_t* cntl );
FLA_Error FLA_LQ_UT_opt_var1( FLA_Obj A, FLA_Obj t );
FLA_Error FLA_LQ_UT_ops_var1( integer m_A,
                              integer n_A,
                              float* A, integer rs_A, integer cs_A,
                              float* t, integer inc_t );
FLA_Error FLA_LQ_UT_opd_var1( integer m_A,
                              integer n_A,
                              double* A, integer rs_A, integer cs_A,
                              double* t, integer inc_t );
FLA_Error FLA_LQ_UT_opc_var1( integer m_A,
                              integer n_A,
                              scomplex* A, integer rs_A, integer cs_A,
                              scomplex* t, integer inc_t );
FLA_Error FLA_LQ_UT_opz_var1( integer m_A,
                              integer n_A,
                              dcomplex* A, integer rs_A, integer cs_A,
                              dcomplex* t, integer inc_t );

FLA_Error FLA_LQ_UT_unb_var2( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_LQ_UT_blk_var2( FLA_Obj A, FLA_Obj T, fla_lqut_t* cntl );
FLA_Error FLA_LQ_UT_opt_var2( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_LQ_UT_ops_var2( integer m_A,
                              integer n_A,
                              float* A, integer rs_A, integer cs_A,
                              float* T, integer rs_T, integer cs_T );
FLA_Error FLA_LQ_UT_opd_var2( integer m_A,
                              integer n_A,
                              double* A, integer rs_A, integer cs_A,
                              double* T, integer rs_T, integer cs_T );
FLA_Error FLA_LQ_UT_opc_var2( integer m_A,
                              integer n_A,
                              scomplex* A, integer rs_A, integer cs_A,
                              scomplex* T, integer rs_T, integer cs_T );
FLA_Error FLA_LQ_UT_opz_var2( integer m_A,
                              integer n_A,
                              dcomplex* A, integer rs_A, integer cs_A,
                              dcomplex* T, integer rs_T, integer cs_T );

FLA_Error FLA_LQ_UT_blk_var3( FLA_Obj A, FLA_Obj T, fla_lqut_t* cntl );

// end FLA_LQ_UT_vars.h

FLA_Error FLA_LQ_UT( FLA_Obj A, FLA_Obj T );

FLA_Error FLA_LQ_UT_internal( FLA_Obj A, FLA_Obj T, fla_lqut_t* cntl );

FLA_Error FLA_LQ_UT_create_T( FLA_Obj A, FLA_Obj* T );

FLA_Error FLA_LQ_UT_recover_tau( FLA_Obj T, FLA_Obj tau );

FLA_Error FLA_LQ_UT_solve( FLA_Obj A, FLA_Obj T, FLA_Obj B, FLA_Obj X );

FLA_Error FLASH_LQ_UT( FLA_Obj A, FLA_Obj TW );
FLA_Error FLASH_LQ_UT_create_hier_matrices( FLA_Obj A_flat, fla_dim_t depth, fla_dim_t* b_flash, FLA_Obj* A, FLA_Obj* TW );
FLA_Error FLASH_LQ_UT_solve( FLA_Obj A, FLA_Obj T, FLA_Obj B, FLA_Obj X );

FLA_Error FLA_LQ_UT_form_Q( FLA_Obj A, FLA_Obj T, FLA_Obj Q );
//FLA_Error FLA_LQ_UT_form_Q_blk_var1( FLA_Obj A, FLA_Obj T, FLA_Obj W );
//FLA_Error FLA_LQ_UT_form_Q_opt_var1( FLA_Obj A, FLA_Obj T );
//FLA_Error FLA_LQ_UT_form_Q_ops_var1( integer       m_A,
//                                     integer       n_A,
//                                     float*    buff_A, integer rs_A, integer cs_A,
//                                     float*    buff_T, integer rs_T, integer cs_T );
//FLA_Error FLA_LQ_UT_form_Q_opd_var1( integer       m_A,
//                                     integer       n_A,
//                                     double*   buff_A, integer rs_A, integer cs_A,
//                                     double*   buff_T, integer rs_T, integer cs_T );
//FLA_Error FLA_LQ_UT_form_Q_opc_var1( integer       m_A,
//                                     integer       n_A,
//                                     scomplex* buff_A, integer rs_A, integer cs_A,
//                                     scomplex* buff_T, integer rs_T, integer cs_T );
//FLA_Error FLA_LQ_UT_form_Q_opz_var1( integer       m_A,
//                                     integer       n_A,
//                                     dcomplex* buff_A, integer rs_A, integer cs_A,
//                                     dcomplex* buff_T, integer rs_T, integer cs_T );
// end FLA_LQ_UT.h
// begin FLA_CAQR2_UT.h


// begin FLA_CAQR2_UT_vars.h


FLA_Error FLA_CAQR2_UT_blk_var1( FLA_Obj U,
                                 FLA_Obj D, FLA_Obj T, fla_caqr2ut_t* cntl );
FLA_Error FLA_CAQR2_UT_blk_var2( FLA_Obj U,
                                 FLA_Obj D, FLA_Obj T, fla_caqr2ut_t* cntl );

FLA_Error FLA_CAQR2_UT_unb_var1( FLA_Obj U,
                                 FLA_Obj D, FLA_Obj T );

FLA_Error FLA_CAQR2_UT_opt_var1( FLA_Obj U,
                                 FLA_Obj D, FLA_Obj T );
FLA_Error FLA_CAQR2_UT_ops_var1( integer m_UT,
                                 integer m_D,
                                 float* U, integer rs_U, integer cs_U,
                                 float* D, integer rs_D, integer cs_D,
                                 float* T, integer rs_T, integer cs_T );
FLA_Error FLA_CAQR2_UT_opd_var1( integer m_UT,
                                 integer m_D,
                                 double* U, integer rs_U, integer cs_U,
                                 double* D, integer rs_D, integer cs_D,
                                 double* T, integer rs_T, integer cs_T );
FLA_Error FLA_CAQR2_UT_opc_var1( integer m_UT,
                                 integer m_D,
                                 scomplex* U, integer rs_U, integer cs_U,
                                 scomplex* D, integer rs_D, integer cs_D,
                                 scomplex* T, integer rs_T, integer cs_T );
FLA_Error FLA_CAQR2_UT_opz_var1( integer m_UT,
                                 integer m_D,
                                 dcomplex* U, integer rs_U, integer cs_U,
                                 dcomplex* D, integer rs_D, integer cs_D,
                                 dcomplex* T, integer rs_T, integer cs_T );

// end FLA_CAQR2_UT_vars.h

FLA_Error FLA_CAQR2_UT_internal( FLA_Obj U,
                                 FLA_Obj D, FLA_Obj T, fla_caqr2ut_t* cntl );

// end FLA_CAQR2_UT.h
// begin FLA_CAQR_UT_inc.h


FLA_Error FLASH_CAQR_UT_inc( fla_dim_t p, FLA_Obj A, FLA_Obj ATW, FLA_Obj R, FLA_Obj RTW );

FLA_Error FLASH_CAQR_UT_inc_noopt( fla_dim_t p, FLA_Obj A, FLA_Obj ATW, FLA_Obj R, FLA_Obj RTW );

FLA_Error FLASH_CAQR_UT_inc_create_hier_matrices( fla_dim_t p, FLA_Obj A_flat, fla_dim_t depth, fla_dim_t* b_flash, fla_dim_t b_alg, FLA_Obj* A, FLA_Obj* ATW, FLA_Obj* R, FLA_Obj* RTW );
fla_dim_t     FLASH_CAQR_UT_inc_determine_alg_blocksize( FLA_Obj A );
FLA_Error FLASH_CAQR_UT_inc_adjust_views( FLA_Obj A, FLA_Obj TW );

void      FLA_CAQR_UT_inc_init_structure( fla_dim_t p, fla_dim_t nb_part, FLA_Obj R );

fla_dim_t     FLA_CAQR_UT_inc_compute_blocks_per_part( fla_dim_t p, FLA_Obj A );

FLA_Error FLA_CAQR_UT_inc_factorize_panels( fla_dim_t nb_part, FLA_Obj A, FLA_Obj ATW );

FLA_Error FLA_CAQR_UT_inc_copy_triangles( fla_dim_t nb_part, FLA_Obj A, FLA_Obj R );

FLA_Error FLA_CAQR_UT_inc_blk_var1( FLA_Obj R, FLA_Obj TW, fla_caqrutinc_t* cntl );

FLA_Error FLASH_CAQR_UT_inc_solve( fla_dim_t p, FLA_Obj A, FLA_Obj ATW, FLA_Obj R, FLA_Obj RTW, FLA_Obj B, FLA_Obj X );

// end FLA_CAQR_UT_inc.h


// Other Decompositions
// begin FLA_Hevd.h


// begin FLA_Hevd_ln.h


FLA_Error FLA_Hevd_ln_unb_var1( FLA_Obj A, FLA_Obj l );
// end FLA_Hevd_ln.h
// begin FLA_Hevd_lv.h


FLA_Error FLA_Hevd_lv_unb_var1( fla_dim_t n_iter_max, FLA_Obj A, FLA_Obj l, fla_dim_t k_accum, fla_dim_t b_alg );
FLA_Error FLA_Hevd_lv_unb_var2( fla_dim_t n_iter_max, FLA_Obj A, FLA_Obj l, fla_dim_t k_accum, fla_dim_t b_alg );

// end FLA_Hevd_lv.h
//#include "FLA_Hevd_un.h"
//#include "FLA_Hevd_uv.h"

FLA_Error FLA_Hevd_compute_scaling( FLA_Uplo uplo, FLA_Obj A, FLA_Obj sigma );

FLA_Error FLA_Hevd( FLA_Evd_type jobz, FLA_Uplo uplo, FLA_Obj A, FLA_Obj l );

// end FLA_Hevd.h
// begin FLA_Tevd.h


// begin FLA_Tevd_n.h


// begin FLA_Tevd_iteracc_n.h


// --- FLA_Tevd_iteracc_n_opt_var1() -------------------------------------------

FLA_Error FLA_Tevd_iteracc_n_ops_var1( integer       m_A,
                                       integer       n_G,
                                       integer       ijTL,
                                       float*    buff_d, integer inc_d, 
                                       float*    buff_e, integer inc_e,
                                       integer*      n_iter_perf );
FLA_Error FLA_Tevd_iteracc_n_opd_var1( integer       m_A,
                                       integer       n_G,
                                       integer       ijTL,
                                       double*   buff_d, integer inc_d, 
                                       double*   buff_e, integer inc_e,
                                       integer*      n_iter_perf );

// end FLA_Tevd_iteracc_n.h
// begin FLA_Tevd_eigval_n.h


// --- FLA_Tevd_eigval_n_opt_var1() --------------------------------------------

FLA_Error FLA_Tevd_eigval_n_opt_var1( FLA_Obj G, FLA_Obj d, FLA_Obj e, FLA_Obj n_iter );
FLA_Error FLA_Tevd_eigval_n_ops_var1( integer       m_A,
                                      integer       n_G,
                                      float*    buff_d, integer inc_d, 
                                      float*    buff_e, integer inc_e,
                                      integer*      n_iter );
FLA_Error FLA_Tevd_eigval_n_opd_var1( integer       m_A,
                                      integer       n_G,
                                      double*   buff_d, integer inc_d, 
                                      double*   buff_e, integer inc_e,
                                      integer*      n_iter );

// end FLA_Tevd_eigval_n.h
// begin FLA_Tevd_francis_n.h


// --- FLA_Tevd_francis_n_opt_var1() -------------------------------------------

FLA_Error FLA_Tevd_francis_n_opt_var1( FLA_Obj shift, FLA_Obj d, FLA_Obj e );
FLA_Error FLA_Tevd_francis_n_ops_var1( integer       m_A,
                                       float*    buff_shift,
                                       float*    buff_d, integer inc_d, 
                                       float*    buff_e, integer inc_e ); 
FLA_Error FLA_Tevd_francis_n_opd_var1( integer       m_A,
                                       double*   buff_shift,
                                       double*   buff_d, integer inc_d, 
                                       double*   buff_e, integer inc_e ); 

// end FLA_Tevd_francis_n.h

// --- FLA_Tevd_find_submatrix() -----------------------------------------------

FLA_Error FLA_Tevd_find_submatrix_ops( integer       m_A,
                                       integer       ij_begin,
                                       float*    buff_d, integer inc_d, 
                                       float*    buff_e, integer inc_e,
                                       integer*      ijTL,
                                       integer*      ijBR );
FLA_Error FLA_Tevd_find_submatrix_opd( integer       m_A,
                                       integer       ij_begin,
                                       double*   buff_d, integer inc_d, 
                                       double*   buff_e, integer inc_e,
                                       integer*      ijTL,
                                       integer*      ijBR );

// --- FLA_Norm1_tridiag() -----------------------------------------------------

FLA_Error FLA_Norm1_tridiag( FLA_Obj d, FLA_Obj e, FLA_Obj norm );
FLA_Error FLA_Norm1_tridiag_ops( integer       m_A,
                                 float*    buff_d, integer inc_d, 
                                 float*    buff_e, integer inc_e,
                                 float*    norm );
FLA_Error FLA_Norm1_tridiag_opd( integer       m_A,
                                 double*   buff_d, integer inc_d, 
                                 double*   buff_e, integer inc_e,
                                 double*   norm );

// --- FLA_Tevd_n_opt_var1() ---------------------------------------------------

FLA_Error FLA_Tevd_n_opt_var1( fla_dim_t n_iter_max, FLA_Obj d, FLA_Obj e, FLA_Obj G, FLA_Obj U );
FLA_Error FLA_Tevd_n_ops_var1( integer       m_A,
                               integer       m_U,
                               integer       n_G,
                               integer       n_iter_max,
                               float*    buff_d, integer inc_d, 
                               float*    buff_e, integer inc_e,
                               scomplex* buff_G, integer rs_G, integer cs_G );
FLA_Error FLA_Tevd_n_opd_var1( integer       m_A,
                               integer       m_U,
                               integer       n_G,
                               integer       n_iter_max,
                               double*   buff_d, integer inc_d, 
                               double*   buff_e, integer inc_e,
                               dcomplex* buff_G, integer rs_G, integer cs_G );
FLA_Error FLA_Tevd_n_opc_var1( integer       m_A,
                               integer       m_U,
                               integer       n_G,
                               integer       n_iter_max,
                               float*    buff_d, integer inc_d, 
                               float*    buff_e, integer inc_e,
                               scomplex* buff_G, integer rs_G, integer cs_G );
FLA_Error FLA_Tevd_n_opz_var1( integer       m_A,
                               integer       m_U,
                               integer       n_G,
                               integer       n_iter_max,
                               double*   buff_d, integer inc_d, 
                               double*   buff_e, integer inc_e,
                               dcomplex* buff_G, integer rs_G, integer cs_G );


// end FLA_Tevd_n.h
// begin FLA_Tevd_v.h


// begin FLA_Tevd_iteracc_v.h


// --- FLA_Tevd_iteracc_v_opt_var1() -------------------------------------------

FLA_Error FLA_Tevd_iteracc_v_ops_var1( integer       m_A,
                                       integer       n_G,
                                       integer       ijTL,
                                       float*    buff_d, integer inc_d, 
                                       float*    buff_e, integer inc_e,
                                       scomplex* buff_G, integer rs_G, integer cs_G,
                                       integer*      n_iter_perf );
FLA_Error FLA_Tevd_iteracc_v_opd_var1( integer       m_A,
                                       integer       n_G,
                                       integer       ijTL,
                                       double*   buff_d, integer inc_d, 
                                       double*   buff_e, integer inc_e,
                                       dcomplex* buff_G, integer rs_G, integer cs_G,
                                       integer*      n_iter_perf );

FLA_Error FLA_Tevd_iteracc_v_ops_var3( integer       m_A,
                                       integer       m_U,
                                       integer       n_G,
                                       integer       ijTL,
                                       float*    buff_d, integer inc_d, 
                                       float*    buff_e, integer inc_e,
                                       float*    buff_l, integer inc_l,
                                       integer*      buff_ls, integer inc_ls,
                                       float*    buff_pu, integer inc_pu,
                                       scomplex* buff_G, integer rs_G, integer cs_G,
                                       integer*      n_iter_perf );
FLA_Error FLA_Tevd_iteracc_v_opd_var3( integer       m_A,
                                       integer       m_U,
                                       integer       n_G,
                                       integer       ijTL,
                                       double*   buff_d, integer inc_d, 
                                       double*   buff_e, integer inc_e,
                                       double*   buff_l, integer inc_l,
                                       integer*      buff_ls, integer inc_ls,
                                       double*   buff_pu, integer inc_pu,
                                       dcomplex* buff_G, integer rs_G, integer cs_G,
                                       integer*      n_iter_perf );

// end FLA_Tevd_iteracc_v.h
// begin FLA_Tevd_eigval_v.h


// --- FLA_Tevd_eigval_v_opt_var1() --------------------------------------------

FLA_Error FLA_Tevd_eigval_v_opt_var1( FLA_Obj G, FLA_Obj d, FLA_Obj e, FLA_Obj n_iter );
FLA_Error FLA_Tevd_eigval_v_ops_var1( integer       m_A,
                                      integer       n_G,
                                      scomplex* buff_G, integer rs_G, integer cs_G,
                                      float*    buff_d, integer inc_d, 
                                      float*    buff_e, integer inc_e,
                                      integer*      n_iter );
FLA_Error FLA_Tevd_eigval_v_opd_var1( integer       m_A,
                                      integer       n_G,
                                      dcomplex* buff_G, integer rs_G, integer cs_G,
                                      double*   buff_d, integer inc_d, 
                                      double*   buff_e, integer inc_e,
                                      integer*      n_iter );

FLA_Error FLA_Tevd_eigval_v_ops_var3( integer       m_A,
                                      integer       m_U,
                                      integer       n_G,
                                      scomplex* buff_G, integer rs_G, integer cs_G,
                                      float*    buff_d, integer inc_d, 
                                      float*    buff_e, integer inc_e,
                                      float*    buff_l, integer inc_l,
                                      integer*      buff_ls, integer inc_ls,
                                      float*    buff_pu, integer inc_pu,
                                      integer*      n_iter );
FLA_Error FLA_Tevd_eigval_v_opd_var3( integer       m_A,
                                      integer       m_U,
                                      integer       n_G,
                                      dcomplex* buff_G, integer rs_G, integer cs_G,
                                      double*   buff_d, integer inc_d, 
                                      double*   buff_e, integer inc_e,
                                      double*   buff_l, integer inc_l,
                                      integer*      buff_ls, integer inc_ls,
                                      double*   buff_pu, integer inc_pu,
                                      integer*      n_iter );

// end FLA_Tevd_eigval_v.h
// begin FLA_Tevd_francis_v.h


// --- FLA_Tevd_francis_v_opt_var1() -------------------------------------------

FLA_Error FLA_Tevd_francis_v_opt_var1( FLA_Obj shift, FLA_Obj g, FLA_Obj d, FLA_Obj e );
FLA_Error FLA_Tevd_francis_v_ops_var1( integer       m_A,
                                       float*    buff_shift,
                                       scomplex* buff_g, integer inc_g, 
                                       float*    buff_d, integer inc_d, 
                                       float*    buff_e, integer inc_e ); 
FLA_Error FLA_Tevd_francis_v_opd_var1( integer       m_A,
                                       double*   buff_shift,
                                       dcomplex* buff_g, integer inc_g, 
                                       double*   buff_d, integer inc_d, 
                                       double*   buff_e, integer inc_e ); 

// end FLA_Tevd_francis_v.h

// --- FLA_Tevd_compute_scaling() ----------------------------------------------

FLA_Error FLA_Tevd_compute_scaling_ops( integer       m_A,
                                        float*    buff_d, integer inc_d, 
                                        float*    buff_e, integer inc_e,
                                        float*    sigma );
FLA_Error FLA_Tevd_compute_scaling_opd( integer       m_A,
                                        double*   buff_d, integer inc_d, 
                                        double*   buff_e, integer inc_e,
                                        double*   sigma );

// --- FLA_Tevd_find_submatrix() -----------------------------------------------

FLA_Error FLA_Tevd_find_submatrix_ops( integer       m_A,
                                       integer       ij_begin,
                                       float*    buff_d, integer inc_d, 
                                       float*    buff_e, integer inc_e,
                                       integer*      ijTL,
                                       integer*      ijBR );
FLA_Error FLA_Tevd_find_submatrix_opd( integer       m_A,
                                       integer       ij_begin,
                                       double*   buff_d, integer inc_d, 
                                       double*   buff_e, integer inc_e,
                                       integer*      ijTL,
                                       integer*      ijBR );

// --- FLA_Tevd_find_perfshift() -----------------------------------------------

FLA_Error FLA_Tevd_find_perfshift_ops( integer       m_d,
                                       integer       m_l,
                                       float*    buff_d, integer inc_d, 
                                       float*    buff_e, integer inc_e, 
                                       float*    buff_l, integer inc_l, 
                                       integer*      buff_lstat, integer inc_lstat, 
                                       float*    buff_pu, integer inc_pu, 
                                       integer*      ij_shift );
FLA_Error FLA_Tevd_find_perfshift_opd( integer       m_d,
                                       integer       m_l,
                                       double*   buff_d, integer inc_d, 
                                       double*   buff_e, integer inc_e, 
                                       double*   buff_l, integer inc_l, 
                                       integer*      buff_lstat, integer inc_lstat, 
                                       double*   buff_pu, integer inc_pu, 
                                       integer*      ij_shift );

// --- FLA_Norm1_tridiag() -----------------------------------------------------

FLA_Error FLA_Norm1_tridiag( FLA_Obj d, FLA_Obj e, FLA_Obj norm );
FLA_Error FLA_Norm1_tridiag_ops( integer       m_A,
                                 float*    buff_d, integer inc_d, 
                                 float*    buff_e, integer inc_e,
                                 float*    norm );
FLA_Error FLA_Norm1_tridiag_opd( integer       m_A,
                                 double*   buff_d, integer inc_d, 
                                 double*   buff_e, integer inc_e,
                                 double*   norm );

// --- FLA_Tevd_v_opt_var1() ---------------------------------------------------

FLA_Error FLA_Tevd_v_opt_var1( fla_dim_t n_iter_max, FLA_Obj d, FLA_Obj e, FLA_Obj G, FLA_Obj U, fla_dim_t b_alg );
FLA_Error FLA_Tevd_v_ops_var1( integer       m_A,
                               integer       m_U,
                               integer       n_G,
                               integer       n_iter_max,
                               float*    buff_d, integer inc_d, 
                               float*    buff_e, integer inc_e,
                               scomplex* buff_G, integer rs_G, integer cs_G,
                               float*    buff_U, integer rs_U, integer cs_U,
                               integer       b_alg );
FLA_Error FLA_Tevd_v_opd_var1( integer       m_A,
                               integer       m_U,
                               integer       n_G,
                               integer       n_iter_max,
                               double*   buff_d, integer inc_d, 
                               double*   buff_e, integer inc_e,
                               dcomplex* buff_G, integer rs_G, integer cs_G,
                               double*   buff_U, integer rs_U, integer cs_U,
                               integer       b_alg );
FLA_Error FLA_Tevd_v_opc_var1( integer       m_A,
                               integer       m_U,
                               integer       n_G,
                               integer       n_iter_max,
                               float*    buff_d, integer inc_d, 
                               float*    buff_e, integer inc_e,
                               scomplex* buff_G, integer rs_G, integer cs_G,
                               scomplex* buff_U, integer rs_U, integer cs_U,
                               integer       b_alg );
FLA_Error FLA_Tevd_v_opz_var1( integer       m_A,
                               integer       m_U,
                               integer       n_G,
                               integer       n_iter_max,
                               double*   buff_d, integer inc_d, 
                               double*   buff_e, integer inc_e,
                               dcomplex* buff_G, integer rs_G, integer cs_G,
                               dcomplex* buff_U, integer rs_U, integer cs_U,
                               integer       b_alg );

// --- FLA_Tevd_v_opt_var2() ---------------------------------------------------

FLA_Error FLA_Tevd_v_opt_var2( fla_dim_t n_iter_max, FLA_Obj d, FLA_Obj e, FLA_Obj G, FLA_Obj R, FLA_Obj W, FLA_Obj U, fla_dim_t b_alg );
FLA_Error FLA_Tevd_v_ops_var2( integer       m_A,
                               integer       m_U,
                               integer       n_G,
                               integer       n_G_extra,
                               float*    buff_d, integer inc_d, 
                               float*    buff_e, integer inc_e,
                               scomplex* buff_G, integer rs_G, integer cs_G,
                               float*    buff_R, integer rs_R, integer cs_R,
                               float*    buff_W, integer rs_W, integer cs_W,
                               float*    buff_U, integer rs_U, integer cs_U,
                               integer       b_alg );
FLA_Error FLA_Tevd_v_opd_var2( integer       m_A,
                               integer       m_U,
                               integer       n_G,
                               integer       n_G_extra,
                               double*   buff_d, integer inc_d, 
                               double*   buff_e, integer inc_e,
                               dcomplex* buff_G, integer rs_G, integer cs_G,
                               double*   buff_R, integer rs_R, integer cs_R,
                               double*   buff_W, integer rs_W, integer cs_W,
                               double*   buff_U, integer rs_U, integer cs_U,
                               integer       b_alg );
FLA_Error FLA_Tevd_v_opc_var2( integer       m_A,
                               integer       m_U,
                               integer       n_G,
                               integer       n_G_extra,
                               float*    buff_d, integer inc_d, 
                               float*    buff_e, integer inc_e,
                               scomplex* buff_G, integer rs_G, integer cs_G,
                               float*    buff_R, integer rs_R, integer cs_R,
                               scomplex* buff_W, integer rs_W, integer cs_W,
                               scomplex* buff_U, integer rs_U, integer cs_U,
                               integer       b_alg );
FLA_Error FLA_Tevd_v_opz_var2( integer       m_A,
                               integer       m_U,
                               integer       n_G,
                               integer       n_G_extra,
                               double*   buff_d, integer inc_d, 
                               double*   buff_e, integer inc_e,
                               dcomplex* buff_G, integer rs_G, integer cs_G,
                               double*   buff_R, integer rs_R, integer cs_R,
                               dcomplex* buff_W, integer rs_W, integer cs_W,
                               dcomplex* buff_U, integer rs_U, integer cs_U,
                               integer       b_alg );

// end FLA_Tevd_v.h

// --- MAC_Tevd_eigval_converged() ---------------------------------------------

#define MAC_Tevd_eigval_converged_ops( eps, safmin, d1, e1, d2 ) \
	fabsf( e1 ) <= (eps) * sqrt( fabsf( d1 ) ) * sqrt( fabsf( d2 ) ) + (safmin)

#define MAC_Tevd_eigval_converged_opd( eps, safmin, d1, e1, d2 ) \
	fabs( e1 )  <= (eps) * sqrt( fabs( d1 ) )  * sqrt( fabs( d2 ) )  + (safmin)

// --- MAC_Tevd_eigval_converged2() ---------------------------------------------

#define MAC_Tevd_eigval_converged2_ops( eps2, safmin, d1, e1, d2 ) \
	(e1) * (e1) <=        (eps2) * fabsf( (d1) * (d2) ) + (safmin)

#define MAC_Tevd_eigval_converged2_opd( eps2, safmin, d1, e1, d2 ) \
	(e1) * (e1) <=        (eps2) * fabs( (d1) * (d2) ) + (safmin)

FLA_Error FLA_Tevd( FLA_Evd_type jobz, FLA_Obj U, FLA_Obj d, FLA_Obj e, FLA_Obj l );

// end FLA_Tevd.h
// begin FLA_Svd.h


// begin FLA_Svd_ext.h



FLA_Error FLA_Svd_ext_u_unb_var1( FLA_Svd_type jobu, FLA_Svd_type jobv, 
                                  fla_dim_t n_iter_max,
                                  FLA_Obj A, FLA_Obj s, FLA_Obj V, FLA_Obj U,
                                  fla_dim_t k_accum,
                                  fla_dim_t b_alg );
int lapack_dbdsqr(char *uplo, integer *n, integer *ncvt, integer *
	          nru, integer *ncc, doublereal *d__, doublereal *e, doublereal *vt, 
	          integer *ldvt, doublereal *u, integer *ldu, doublereal *c__, integer *
	          ldc, doublereal *work, integer *info);
int lapack_dbdsqr_small(char *uplo, integer *n, integer *ncvt, integer *nru,
                                doublereal *d__, doublereal *e,
                                doublereal *vt, integer *ldvt,
                                doublereal *u, integer *ldu,
                                integer *info);
int lapack_dgebd2(integer *m, integer *n, doublereal *a, integer *
	          lda, doublereal *d__, doublereal *e, doublereal *tauq, doublereal *
	          taup, doublereal *work, integer *info);
int lapack_dgebrd(integer *m, integer *n, doublereal *a, integer *
	          lda, doublereal *d__, doublereal *e, doublereal *tauq, doublereal *
	          taup, doublereal *work, integer *lwork, integer *info);
int lapack_dgelqf(integer *m, integer *n, doublereal *a, integer *
	          lda, doublereal *tau, doublereal *work, integer *lwork, integer *info);
int lapack_dgelq2(integer *m, integer *n, doublereal *a, integer * lda, 
                  doublereal *tau, doublereal *work, integer *info);
int lapack_dgesvd(char *jobu, char *jobvt, integer *m, integer *n, 
	          doublereal *a, integer *lda, doublereal *s, doublereal *u, integer *
	          ldu, doublereal *vt, integer *ldvt, doublereal *work, integer *lwork, 
	          integer *info);
int lapack_dorg2r(integer *m, integer *n, integer *k, doublereal *
	          a, integer *lda, doublereal *tau, doublereal *work, integer *info);
int lapack_dorgbr(char *vect, integer *m, integer *n, integer *k, 
	          doublereal *a, integer *lda, doublereal *tau, doublereal *work, 
	          integer *lwork, integer *info);
int lapack_dorgl2(integer *m, integer *n, integer *k, doublereal *
	          a, integer *lda, doublereal *tau, doublereal *work, integer *info);
int lapack_dorglq(integer *m, integer *n, integer *k, doublereal *
	          a, integer *lda, doublereal *tau, doublereal *work, integer *lwork, 
	          integer *info);
int lapack_dorgqr(integer *m, integer *n, integer *k, doublereal *
	          a, integer *lda, doublereal *tau, doublereal *work, integer *lwork, 
	          integer *info);
int lapack_dorm2r(char *side, char *trans, integer *m, integer *n, integer *k, 
                  doublereal *a, integer *lda, doublereal *tau, doublereal * c__, 
                  integer *ldc, doublereal *work, integer *info);
int lapack_dormbr(char *vect, char *side, char *trans, integer *m, 
	          integer *n, integer *k, doublereal *a, integer *lda, doublereal *tau, 
	          doublereal *c__, integer *ldc, doublereal *work, integer *lwork, 
	          integer *info);
int lapack_dormlq(char *side, char *trans, integer *m, integer *n, 
                  integer *k, doublereal *a, integer *lda, doublereal *tau, doublereal *
	          c__, integer *ldc, doublereal *work, integer *lwork, integer *info);
int lapack_dorml2(char *side, char *trans, integer *m, integer *n, integer *k, 
                  doublereal *a, integer *lda, doublereal *tau, doublereal * c__, 
                  integer *ldc, doublereal *work, integer *info); 
int lapack_dormqr(char *side, char *trans, integer *m, integer *n, 
	          integer *k, doublereal *a, integer *lda, doublereal *tau, doublereal *
	          c__, integer *ldc, doublereal *work, integer *lwork, integer *info);
int  dgesvd2x2(   char *jobu, char *jobvt, integer *m, integer *n,
                  doublereal *a, integer *lda, doublereal *s, doublereal *u, integer *
                  ldu, doublereal *vt, integer *ldvt, doublereal *work, integer *lwork,
                  integer *info);



// end FLA_Svd_ext.h
// begin FLA_Svd_uv.h


FLA_Error FLA_Svd_uv_unb_var1( fla_dim_t n_iter_max, FLA_Obj A, FLA_Obj s, FLA_Obj U, FLA_Obj V, fla_dim_t k_accum, fla_dim_t b_alg );
FLA_Error FLA_Svd_uv_unb_var2( fla_dim_t n_iter_max, FLA_Obj A, FLA_Obj s, FLA_Obj U, FLA_Obj V, fla_dim_t k_accum, fla_dim_t b_alg );
// end FLA_Svd_uv.h

FLA_Error FLA_Svd_compute_scaling( FLA_Obj A, FLA_Obj sigma );

FLA_Error FLA_Svd( FLA_Svd_type jobu, FLA_Svd_type jobv, FLA_Obj A, FLA_Obj s, FLA_Obj U, FLA_Obj V );
FLA_Error FLA_Svd_ext( FLA_Svd_type jobu, FLA_Trans transu,
                       FLA_Svd_type jobv, FLA_Trans transv,
                       FLA_Obj A, FLA_Obj s, FLA_Obj U, FLA_Obj V );
// end FLA_Svd.h
// begin FLA_Bsvd.h


// begin FLA_Bsvd_n.h



// end FLA_Bsvd_n.h
// begin FLA_Bsvd_v.h


// begin FLA_Bsvd_iteracc_v.h


// --- FLA_Bsvd_iteracc_v_opt_var1() -------------------------------------------

FLA_Error FLA_Bsvd_iteracc_v_ops_var1( integer       m_A,
                                       integer       n_GH,
                                       integer       ijTL,
                                       float     tol,
                                       float     thresh,
                                       float*    buff_d, integer inc_d, 
                                       float*    buff_e, integer inc_e,
                                       scomplex* buff_G, integer rs_G, integer cs_G,
                                       scomplex* buff_H, integer rs_H, integer cs_H,
                                       integer*      n_iter_perf );
FLA_Error FLA_Bsvd_iteracc_v_opd_var1( integer       m_A,
                                       integer       n_GH,
                                       integer       ijTL,
                                       double    tol,
                                       double    thresh,
                                       double*   buff_d, integer inc_d, 
                                       double*   buff_e, integer inc_e,
                                       dcomplex* buff_G, integer rs_G, integer cs_G,
                                       dcomplex* buff_H, integer rs_H, integer cs_H,
                                       integer*      n_iter_perf );
// end FLA_Bsvd_iteracc_v.h
// begin FLA_Bsvd_sinval_v.h


// --- MAC_Bsvd_sinval_is_converged() ------------------------------------------

#define MAC_Bsvd_sinval_is_converged_ops( tol, d1, e1 ) \
	fabsf( (e1) ) <= fabsf( (tol) * (d1) )

#define MAC_Bsvd_sinval_is_converged_opd( tol, d1, e1 ) \
	fabs(  (e1) ) <= fabs(  (tol) * (d1) )

// --- FLA_Bsvd_sinval_v_opt_var1() --------------------------------------------

FLA_Error FLA_Bsvd_sinval_v_opt_var1( FLA_Obj tol, FLA_Obj thresh, FLA_Obj G, FLA_Obj H, FLA_Obj d, FLA_Obj e, FLA_Obj n_iter );
FLA_Error FLA_Bsvd_sinval_v_ops_var1( integer       m_A,
                                      integer       n_GH,
                                      integer       n_iter_allowed,
                                      float     tol, 
                                      float     thresh, 
                                      scomplex* buff_G, integer rs_G, integer cs_G,
                                      scomplex* buff_H, integer rs_H, integer cs_H,
                                      float*    buff_d, integer inc_d, 
                                      float*    buff_e, integer inc_e,
                                      integer*      n_iter );
FLA_Error FLA_Bsvd_sinval_v_opd_var1( integer       m_A,
                                      integer       n_GH,
                                      integer       n_iter_allowed,
                                      double    tol, 
                                      double    thresh, 
                                      dcomplex* buff_G, integer rs_G, integer cs_G,
                                      dcomplex* buff_H, integer rs_H, integer cs_H,
                                      double*   buff_d, integer inc_d, 
                                      double*   buff_e, integer inc_e,
                                      integer*      n_iter );

// end FLA_Bsvd_sinval_v.h
// begin FLA_Bsvd_francis_v.h


// --- FLA_Bsvd_francis_v_opt_var1() -------------------------------------------

FLA_Error FLA_Bsvd_francis_v_opt_var1( FLA_Obj shift, FLA_Obj g, FLA_Obj h, FLA_Obj d, FLA_Obj e );
FLA_Error FLA_Bsvd_francis_v_ops_var1( integer       m_A,
                                       float     shift,
                                       scomplex* buff_g, integer inc_g, 
                                       scomplex* buff_h, integer inc_h, 
                                       float*    buff_d, integer inc_d, 
                                       float*    buff_e, integer inc_e ); 
FLA_Error FLA_Bsvd_francis_v_opd_var1( integer       m_A,
                                       double    shift,
                                       dcomplex* buff_g, integer inc_g, 
                                       dcomplex* buff_h, integer inc_h, 
                                       double*   buff_d, integer inc_d, 
                                       double*   buff_e, integer inc_e ); 

// end FLA_Bsvd_francis_v.h

// --- FLA_Bsvd_compute_shift() ------------------------------------------------

FLA_Error FLA_Bsvd_compute_shift( FLA_Obj tol, FLA_Obj sminl, FLA_Obj smax, FLA_Obj d, FLA_Obj e, FLA_Obj shift );
FLA_Error FLA_Bsvd_compute_shift_ops( integer       m_A,
                                      float     tol,
                                      float     sminl,
                                      float     smax,
                                      float*    buff_d, integer inc_d,
                                      float*    buff_e, integer inc_e,
                                      float*    shift );
FLA_Error FLA_Bsvd_compute_shift_opd( integer       m_A,
                                      double    tol,
                                      double    sminl,
                                      double    smax,
                                      double*   buff_d, integer inc_d,
                                      double*   buff_e, integer inc_e,
                                      double*   shift );

// --- FLA_Bsvd_compute_tol_thresh() -------------------------------------------

FLA_Error FLA_Bsvd_compute_tol_thresh( FLA_Obj tolmul, FLA_Obj maxit, FLA_Obj d, FLA_Obj e, FLA_Obj tol, FLA_Obj thresh );
FLA_Error FLA_Bsvd_compute_tol_thresh_ops( integer       m_A,
                                           float     tolmul,
                                           float     maxit,
                                           float*    buff_d, integer inc_d, 
                                           float*    buff_e, integer inc_e, 
                                           float*    tol,
                                           float*    thresh );
FLA_Error FLA_Bsvd_compute_tol_thresh_opd( integer       m_A,
                                           double    tolmul,
                                           double    maxit,
                                           double*   buff_d, integer inc_d, 
                                           double*   buff_e, integer inc_e, 
                                           double*   tol,
                                           double*   thresh );

// --- FLA_Bsvd_find_converged() -----------------------------------------------

FLA_Error FLA_Bsvd_find_converged( FLA_Obj tol, FLA_Obj d, FLA_Obj e, FLA_Obj sminl );
FLA_Error FLA_Bsvd_find_converged_ops( integer       m_A,
                                       float     tol, 
                                       float*    buff_d, integer inc_d, 
                                       float*    buff_e, integer inc_e,
                                       float*    sminl );
FLA_Error FLA_Bsvd_find_converged_opd( integer       m_A,
                                       double    tol, 
                                       double*   buff_d, integer inc_d, 
                                       double*   buff_e, integer inc_e,
                                       double*   sminl );

// --- FLA_Bsvd_find_max_fla_min() -------------------------------------------------

FLA_Error FLA_Bsvd_find_max_fla_min( FLA_Obj d, FLA_Obj e, FLA_Obj smax, FLA_Obj smin );
FLA_Error FLA_Bsvd_find_max_min_ops( integer       m_A,
                                     float*    buff_d, integer inc_d, 
                                     float*    buff_e, integer inc_e, 
                                     float*    smax,
                                     float*    smin );
FLA_Error FLA_Bsvd_find_max_min_opd( integer       m_A,
                                     double*   buff_d, integer inc_d, 
                                     double*   buff_e, integer inc_e, 
                                     double*   smax,
                                     double*   smin );

// --- FLA_Bsvd_find_submatrix() -----------------------------------------------

FLA_Error FLA_Bsvd_find_submatrix_ops( integer       mn_A,
                                       integer       ij_begin,
                                       float*    buff_d, integer inc_d,
                                       float*    buff_e, integer inc_e,
                                       integer*      ijTL,
                                       integer*      ijBR );
FLA_Error FLA_Bsvd_find_submatrix_opd( integer       mn_A,
                                       integer       ij_begin,
                                       double*   buff_d, integer inc_d,
                                       double*   buff_e, integer inc_e,
                                       integer*      ijTL,
                                       integer*      ijBR );

// --- FLA_Bsvd_v_opt_var1() ---------------------------------------------------

FLA_Error FLA_Bsvd_v_opt_var1( fla_dim_t n_iter_max, FLA_Obj d, FLA_Obj e, FLA_Obj G, FLA_Obj H, FLA_Obj U, FLA_Obj V, fla_dim_t b_alg );
FLA_Error FLA_Bsvd_v_ops_var1( integer       min_m_n,
                               integer       m_U,
                               integer       m_V,
                               integer       n_GH,
                               integer       n_iter_max,
                               float*    buff_d, integer inc_d, 
                               float*    buff_e, integer inc_e,
                               scomplex* buff_G, integer rs_G, integer cs_G,
                               scomplex* buff_H, integer rs_H, integer cs_H,
                               float*    buff_U, integer rs_U, integer cs_U,
                               float*    buff_V, integer rs_V, integer cs_V,
                               integer       b_alg );
FLA_Error FLA_Bsvd_v_opd_var1( integer       min_m_n,
                               integer       m_U,
                               integer       m_V,
                               integer       n_GH,
                               integer       n_iter_max,
                               double*   buff_d, integer inc_d, 
                               double*   buff_e, integer inc_e,
                               dcomplex* buff_G, integer rs_G, integer cs_G,
                               dcomplex* buff_H, integer rs_H, integer cs_H,
                               double*   buff_U, integer rs_U, integer cs_U,
                               double*   buff_V, integer rs_V, integer cs_V,
                               integer       b_alg );
FLA_Error FLA_Bsvd_v_opc_var1( integer       min_m_n,
                               integer       m_U,
                               integer       m_V,
                               integer       n_GH,
                               integer       n_iter_max,
                               float*    buff_d, integer inc_d, 
                               float*    buff_e, integer inc_e,
                               scomplex* buff_G, integer rs_G, integer cs_G,
                               scomplex* buff_H, integer rs_H, integer cs_H,
                               scomplex* buff_U, integer rs_U, integer cs_U,
                               scomplex* buff_V, integer rs_V, integer cs_V,
                               integer       b_alg );
FLA_Error FLA_Bsvd_v_opz_var1( integer       min_m_n,
                               integer       m_U,
                               integer       m_V,
                               integer       n_GH,
                               integer       n_iter_max,
                               double*   buff_d, integer inc_d, 
                               double*   buff_e, integer inc_e,
                               dcomplex* buff_G, integer rs_G, integer cs_G,
                               dcomplex* buff_H, integer rs_H, integer cs_H,
                               dcomplex* buff_U, integer rs_U, integer cs_U,
                               dcomplex* buff_V, integer rs_V, integer cs_V,
                               integer       b_alg );

// --- FLA_Bsvd_v_opt_var2() ---------------------------------------------------

FLA_Error FLA_Bsvd_v_opt_var2( fla_dim_t n_iter_max, FLA_Obj d, FLA_Obj e, FLA_Obj G, FLA_Obj H, FLA_Obj RG, FLA_Obj RH, FLA_Obj W, FLA_Obj U, FLA_Obj V, fla_dim_t b_alg );
FLA_Error FLA_Bsvd_v_ops_var2( integer       min_m_n,
                               integer       m_U,
                               integer       m_V,
                               integer       n_GH,
                               integer       n_iter_max,
                               float*    buff_d, integer inc_d, 
                               float*    buff_e, integer inc_e,
                               scomplex* buff_G, integer rs_G, integer cs_G,
                               scomplex* buff_H, integer rs_H, integer cs_H,
                               float*    buff_RG, integer rs_RG, integer cs_RG,
                               float*    buff_RH, integer rs_RH, integer cs_RH,
                               float*    buff_W, integer rs_W, integer cs_W,
                               float*    buff_U, integer rs_U, integer cs_U,
                               float*    buff_V, integer rs_V, integer cs_V,
                               integer       b_alg );
FLA_Error FLA_Bsvd_v_opd_var2( integer       min_m_n,
                               integer       m_U,
                               integer       m_V,
                               integer       n_GH,
                               integer       n_iter_max,
                               double*   buff_d, integer inc_d, 
                               double*   buff_e, integer inc_e,
                               dcomplex* buff_G, integer rs_G, integer cs_G,
                               dcomplex* buff_H, integer rs_H, integer cs_H,
                               double*   buff_RG, integer rs_RG, integer cs_RG,
                               double*   buff_RH, integer rs_RH, integer cs_RH,
                               double*   buff_W, integer rs_W, integer cs_W,
                               double*   buff_U, integer rs_U, integer cs_U,
                               double*   buff_V, integer rs_V, integer cs_V,
                               integer       b_alg );
FLA_Error FLA_Bsvd_v_opc_var2( integer       min_m_n,
                               integer       m_U,
                               integer       m_V,
                               integer       n_GH,
                               integer       n_iter_max,
                               float*    buff_d, integer inc_d, 
                               float*    buff_e, integer inc_e,
                               scomplex* buff_G, integer rs_G, integer cs_G,
                               scomplex* buff_H, integer rs_H, integer cs_H,
                               float*    buff_RG, integer rs_RG, integer cs_RG,
                               float*    buff_RH, integer rs_RH, integer cs_RH,
                               scomplex* buff_W, integer rs_W, integer cs_W,
                               scomplex* buff_U, integer rs_U, integer cs_U,
                               scomplex* buff_V, integer rs_V, integer cs_V,
                               integer       b_alg );
FLA_Error FLA_Bsvd_v_opz_var2( integer       min_m_n,
                               integer       m_U,
                               integer       m_V,
                               integer       n_GH,
                               integer       n_iter_max,
                               double*   buff_d, integer inc_d, 
                               double*   buff_e, integer inc_e,
                               dcomplex* buff_G, integer rs_G, integer cs_G,
                               dcomplex* buff_H, integer rs_H, integer cs_H,
                               double*   buff_RG, integer rs_RG, integer cs_RG,
                               double*   buff_RH, integer rs_RH, integer cs_RH,
                               dcomplex* buff_W, integer rs_W, integer cs_W,
                               dcomplex* buff_U, integer rs_U, integer cs_U,
                               dcomplex* buff_V, integer rs_V, integer cs_V,
                               integer       b_alg );

// end FLA_Bsvd_v.h
// begin FLA_Bsvd_ext.h


// --- FLA_Bsvd_ext_opt_var1() ---------------------------------------------------

FLA_Error FLA_Bsvd_ext_opt_var1( fla_dim_t n_iter_max, FLA_Obj d, FLA_Obj e, FLA_Obj G, FLA_Obj H, 
                                 FLA_Svd_type jobu, FLA_Obj U, 
                                 FLA_Svd_type jobv, FLA_Obj V, 
                                 FLA_Bool apply_Uh2C, FLA_Obj C,
                                 fla_dim_t b_alg );
FLA_Error FLA_Bsvd_ext_ops_var1( integer       m_d,
                                 integer       m_U,
                                 integer       m_V,
                                 integer       m_C,
                                 integer       n_C,
                                 integer       n_GH,
                                 integer       n_iter_max,
                                 float*    buff_d, integer inc_d, 
                                 float*    buff_e, integer inc_e,
                                 scomplex* buff_G, integer rs_G, integer cs_G,
                                 scomplex* buff_H, integer rs_H, integer cs_H,
                                 float*    buff_U, integer rs_U, integer cs_U,
                                 float*    buff_V, integer rs_V, integer cs_V,
                                 float*    buff_C, integer rs_C, integer cs_C,
                                 integer       b_alg );
FLA_Error FLA_Bsvd_ext_opd_var1( integer       m_d,
                                 integer       m_U,
                                 integer       m_V,
                                 integer       m_C,
                                 integer       n_C,
                                 integer       n_GH,
                                 integer       n_iter_max,
                                 double*   buff_d, integer inc_d, 
                                 double*   buff_e, integer inc_e,
                                 dcomplex* buff_G, integer rs_G, integer cs_G,
                                 dcomplex* buff_H, integer rs_H, integer cs_H,
                                 double*   buff_U, integer rs_U, integer cs_U,
                                 double*   buff_V, integer rs_V, integer cs_V,
                                 double*   buff_C, integer rs_C, integer cs_C,
                                 integer       b_alg );
FLA_Error FLA_Bsvd_ext_opc_var1( integer       m_d,
                                 integer       m_U,
                                 integer       m_V,
                                 integer       m_C,
                                 integer       n_C,
                                 integer       n_GH,
                                 integer       n_iter_max,
                                 float*    buff_d, integer inc_d, 
                                 float*    buff_e, integer inc_e,
                                 scomplex* buff_G, integer rs_G, integer cs_G,
                                 scomplex* buff_H, integer rs_H, integer cs_H,
                                 scomplex* buff_U, integer rs_U, integer cs_U,
                                 scomplex* buff_V, integer rs_V, integer cs_V,
                                 scomplex* buff_C, integer rs_C, integer cs_C,
                                 integer       b_alg );
FLA_Error FLA_Bsvd_ext_opz_var1( integer       m_d,
                                 integer       m_U,
                                 integer       m_V,
                                 integer       m_C,
                                 integer       n_C,
                                 integer       n_GH,
                                 integer       n_iter_max,
                                 double*   buff_d, integer inc_d, 
                                 double*   buff_e, integer inc_e,
                                 dcomplex* buff_G, integer rs_G, integer cs_G,
                                 dcomplex* buff_H, integer rs_H, integer cs_H,
                                 dcomplex* buff_U, integer rs_U, integer cs_U,
                                 dcomplex* buff_V, integer rs_V, integer cs_V,
                                 dcomplex* buff_C, integer rs_C, integer cs_C,
                                 integer       b_alg );

// end FLA_Bsvd_ext.h

FLA_Error FLA_Bsvd_create_workspace( FLA_Obj d, FLA_Obj *G, FLA_Obj *H );
FLA_Error FLA_Bsvd( FLA_Uplo uplo, FLA_Obj d, FLA_Obj e, FLA_Obj G, FLA_Obj H, 
                    FLA_Svd_type jobu, FLA_Obj U, 
                    FLA_Svd_type jobv, FLA_Obj V );
FLA_Error FLA_Bsvd_ext( FLA_Uplo uplo, FLA_Obj d, FLA_Obj e, FLA_Obj G, FLA_Obj H,
                        FLA_Svd_type jobu, FLA_Obj U,
                        FLA_Svd_type jobv, FLA_Obj V,
                        FLA_Bool apply_Uh2C, FLA_Obj C );
// end FLA_Bsvd.h

// Inversions
// begin FLA_Trinv.h


// begin FLA_Trinv_ln.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trinv_ln_blk_var1( FLA_Obj A, fla_trinv_t* cntl );
FLA_Error FLA_Trinv_ln_blk_var2( FLA_Obj A, fla_trinv_t* cntl );
FLA_Error FLA_Trinv_ln_blk_var3( FLA_Obj A, fla_trinv_t* cntl );
FLA_Error FLA_Trinv_ln_blk_var4( FLA_Obj A, fla_trinv_t* cntl );

FLA_Error FLA_Trinv_ln_unb_var1( FLA_Obj A );
FLA_Error FLA_Trinv_ln_unb_var2( FLA_Obj A );
FLA_Error FLA_Trinv_ln_unb_var3( FLA_Obj A );
FLA_Error FLA_Trinv_ln_unb_var4( FLA_Obj A );

FLA_Error FLA_Trinv_ln_opt_var1( FLA_Obj A );
FLA_Error FLA_Trinv_ln_ops_var1( integer mn_A,
                                 float*    A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_ln_opd_var1( integer mn_A,
                                 double*   A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_ln_opc_var1( integer mn_A,
                                 scomplex* A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_ln_opz_var1( integer mn_A,
                                 dcomplex* A, integer rs_A, integer cs_A );

FLA_Error FLA_Trinv_ln_opt_var2( FLA_Obj A );
FLA_Error FLA_Trinv_ln_ops_var2( integer mn_A,
                                 float*    A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_ln_opd_var2( integer mn_A,
                                 double*   A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_ln_opc_var2( integer mn_A,
                                 scomplex* A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_ln_opz_var2( integer mn_A,
                                 dcomplex* A, integer rs_A, integer cs_A );

FLA_Error FLA_Trinv_ln_opt_var3( FLA_Obj A );
FLA_Error FLA_Trinv_ln_ops_var3( integer mn_A,
                                 float*    A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_ln_opd_var3( integer mn_A,
                                 double*   A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_ln_opc_var3( integer mn_A,
                                 scomplex* A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_ln_opz_var3( integer mn_A,
                                 dcomplex* A, integer rs_A, integer cs_A );

FLA_Error FLA_Trinv_ln_opt_var4( FLA_Obj A );
FLA_Error FLA_Trinv_ln_ops_var4( integer mn_A,
                                 float*    A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_ln_opd_var4( integer mn_A,
                                 double*   A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_ln_opc_var4( integer mn_A,
                                 scomplex* A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_ln_opz_var4( integer mn_A,
                                 dcomplex* A, integer rs_A, integer cs_A );
// end FLA_Trinv_ln.h
// begin FLA_Trinv_lu.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trinv_lu_blk_var1( FLA_Obj A, fla_trinv_t* cntl );
FLA_Error FLA_Trinv_lu_blk_var2( FLA_Obj A, fla_trinv_t* cntl );
FLA_Error FLA_Trinv_lu_blk_var3( FLA_Obj A, fla_trinv_t* cntl );
FLA_Error FLA_Trinv_lu_blk_var4( FLA_Obj A, fla_trinv_t* cntl );

FLA_Error FLA_Trinv_lu_unb_var1( FLA_Obj A );
FLA_Error FLA_Trinv_lu_unb_var2( FLA_Obj A );
FLA_Error FLA_Trinv_lu_unb_var3( FLA_Obj A );
FLA_Error FLA_Trinv_lu_unb_var4( FLA_Obj A );

FLA_Error FLA_Trinv_lu_opt_var1( FLA_Obj A );
FLA_Error FLA_Trinv_lu_ops_var1( integer mn_A,
                                 float*    A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_lu_opd_var1( integer mn_A,
                                 double*   A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_lu_opc_var1( integer mn_A,
                                 scomplex* A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_lu_opz_var1( integer mn_A,
                                 dcomplex* A, integer rs_A, integer cs_A );

FLA_Error FLA_Trinv_lu_opt_var2( FLA_Obj A );
FLA_Error FLA_Trinv_lu_ops_var2( integer mn_A,
                                 float*    A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_lu_opd_var2( integer mn_A,
                                 double*   A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_lu_opc_var2( integer mn_A,
                                 scomplex* A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_lu_opz_var2( integer mn_A,
                                 dcomplex* A, integer rs_A, integer cs_A );

FLA_Error FLA_Trinv_lu_opt_var3( FLA_Obj A );
FLA_Error FLA_Trinv_lu_ops_var3( integer mn_A,
                                 float*    A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_lu_opd_var3( integer mn_A,
                                 double*   A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_lu_opc_var3( integer mn_A,
                                 scomplex* A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_lu_opz_var3( integer mn_A,
                                 dcomplex* A, integer rs_A, integer cs_A );

FLA_Error FLA_Trinv_lu_opt_var4( FLA_Obj A );
FLA_Error FLA_Trinv_lu_ops_var4( integer mn_A,
                                 float*    A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_lu_opd_var4( integer mn_A,
                                 double*   A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_lu_opc_var4( integer mn_A,
                                 scomplex* A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_lu_opz_var4( integer mn_A,
                                 dcomplex* A, integer rs_A, integer cs_A );
void lapack_dtrtri(char *uplo, char *diag, integer *n, doublereal *a, integer *lda, integer *info);
void lapack_dtrti2(char *uplo, char *diag, integer *n, doublereal *a, integer *lda, integer *info);
// end FLA_Trinv_lu.h
// begin FLA_Trinv_un.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trinv_un_blk_var1( FLA_Obj A, fla_trinv_t* cntl );
FLA_Error FLA_Trinv_un_blk_var2( FLA_Obj A, fla_trinv_t* cntl );
FLA_Error FLA_Trinv_un_blk_var3( FLA_Obj A, fla_trinv_t* cntl );
FLA_Error FLA_Trinv_un_blk_var4( FLA_Obj A, fla_trinv_t* cntl );

FLA_Error FLA_Trinv_un_unb_var1( FLA_Obj A );
FLA_Error FLA_Trinv_un_unb_var2( FLA_Obj A );
FLA_Error FLA_Trinv_un_unb_var3( FLA_Obj A );
FLA_Error FLA_Trinv_un_unb_var4( FLA_Obj A );

FLA_Error FLA_Trinv_un_opt_var1( FLA_Obj A );
FLA_Error FLA_Trinv_un_ops_var1( integer mn_A,
                                 float*    A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_un_opd_var1( integer mn_A,
                                 double*   A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_un_opc_var1( integer mn_A,
                                 scomplex* A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_un_opz_var1( integer mn_A,
                                 dcomplex* A, integer rs_A, integer cs_A );

FLA_Error FLA_Trinv_un_opt_var2( FLA_Obj A );
FLA_Error FLA_Trinv_un_ops_var2( integer mn_A,
                                 float*    A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_un_opd_var2( integer mn_A,
                                 double*   A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_un_opc_var2( integer mn_A,
                                 scomplex* A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_un_opz_var2( integer mn_A,
                                 dcomplex* A, integer rs_A, integer cs_A );

FLA_Error FLA_Trinv_un_opt_var3( FLA_Obj A );
FLA_Error FLA_Trinv_un_ops_var3( integer mn_A,
                                 float*    A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_un_opd_var3( integer mn_A,
                                 double*   A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_un_opc_var3( integer mn_A,
                                 scomplex* A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_un_opz_var3( integer mn_A,
                                 dcomplex* A, integer rs_A, integer cs_A );

FLA_Error FLA_Trinv_un_opt_var4( FLA_Obj A );
FLA_Error FLA_Trinv_un_ops_var4( integer mn_A,
                                 float*    A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_un_opd_var4( integer mn_A,
                                 double*   A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_un_opc_var4( integer mn_A,
                                 scomplex* A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_un_opz_var4( integer mn_A,
                                 dcomplex* A, integer rs_A, integer cs_A );
// end FLA_Trinv_un.h
// begin FLA_Trinv_uu.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Trinv_uu_blk_var1( FLA_Obj A, fla_trinv_t* cntl );
FLA_Error FLA_Trinv_uu_blk_var2( FLA_Obj A, fla_trinv_t* cntl );
FLA_Error FLA_Trinv_uu_blk_var3( FLA_Obj A, fla_trinv_t* cntl );
FLA_Error FLA_Trinv_uu_blk_var4( FLA_Obj A, fla_trinv_t* cntl );

FLA_Error FLA_Trinv_uu_unb_var1( FLA_Obj A );
FLA_Error FLA_Trinv_uu_unb_var2( FLA_Obj A );
FLA_Error FLA_Trinv_uu_unb_var3( FLA_Obj A );
FLA_Error FLA_Trinv_uu_unb_var4( FLA_Obj A );

FLA_Error FLA_Trinv_uu_opt_var1( FLA_Obj A );
FLA_Error FLA_Trinv_uu_ops_var1( integer mn_A,
                                 float*    A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_uu_opd_var1( integer mn_A,
                                 double*   A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_uu_opc_var1( integer mn_A,
                                 scomplex* A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_uu_opz_var1( integer mn_A,
                                 dcomplex* A, integer rs_A, integer cs_A );

FLA_Error FLA_Trinv_uu_opt_var2( FLA_Obj A );
FLA_Error FLA_Trinv_uu_ops_var2( integer mn_A,
                                 float*    A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_uu_opd_var2( integer mn_A,
                                 double*   A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_uu_opc_var2( integer mn_A,
                                 scomplex* A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_uu_opz_var2( integer mn_A,
                                 dcomplex* A, integer rs_A, integer cs_A );

FLA_Error FLA_Trinv_uu_opt_var3( FLA_Obj A );
FLA_Error FLA_Trinv_uu_ops_var3( integer mn_A,
                                 float*    A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_uu_opd_var3( integer mn_A,
                                 double*   A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_uu_opc_var3( integer mn_A,
                                 scomplex* A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_uu_opz_var3( integer mn_A,
                                 dcomplex* A, integer rs_A, integer cs_A );

FLA_Error FLA_Trinv_uu_opt_var4( FLA_Obj A );
FLA_Error FLA_Trinv_uu_ops_var4( integer mn_A,
                                 float*    A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_uu_opd_var4( integer mn_A,
                                 double*   A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_uu_opc_var4( integer mn_A,
                                 scomplex* A, integer rs_A, integer cs_A );
FLA_Error FLA_Trinv_uu_opz_var4( integer mn_A,
                                 dcomplex* A, integer rs_A, integer cs_A );
// end FLA_Trinv_uu.h

FLA_Error FLA_Trinv_internal( FLA_Uplo uplo, FLA_Diag diag, FLA_Obj A, fla_trinv_t* cntl );

FLA_Error FLA_Trinv_ln( FLA_Obj A, fla_trinv_t* cntl );
FLA_Error FLA_Trinv_lu( FLA_Obj A, fla_trinv_t* cntl );
FLA_Error FLA_Trinv_un( FLA_Obj A, fla_trinv_t* cntl );
FLA_Error FLA_Trinv_uu( FLA_Obj A, fla_trinv_t* cntl );

// end FLA_Trinv.h
// begin FLA_SPDinv.h


// skipped #include "FLAME.h" 

FLA_Error FLA_SPDinv_internal( FLA_Uplo uplo, FLA_Obj A, fla_spdinv_t* cntl );
// end FLA_SPDinv.h

// Reductions
// begin FLA_Hess_UT.h


// begin FLA_Hess_UT_vars.h


FLA_Error FLA_Hess_UT_blk_var1( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Hess_UT_unb_var1( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Hess_UT_step_unb_var1( FLA_Obj A, FLA_Obj T );

FLA_Error FLA_Hess_UT_blk_var2( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Hess_UT_blf_var2( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Hess_UT_unb_var2( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Hess_UT_step_unb_var2( FLA_Obj A, FLA_Obj T );

FLA_Error FLA_Hess_UT_blk_var3( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Hess_UT_blf_var3( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Hess_UT_unb_var3( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Hess_UT_step_unb_var3( FLA_Obj A, FLA_Obj T );

FLA_Error FLA_Hess_UT_blk_var4( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Hess_UT_blf_var4( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Hess_UT_unb_var4( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Hess_UT_step_unb_var4( FLA_Obj A, FLA_Obj Y, FLA_Obj Z, FLA_Obj T );

FLA_Error FLA_Hess_UT_blk_var5( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Hess_UT_unb_var5( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Hess_UT_step_unb_var5( FLA_Obj A, FLA_Obj U, FLA_Obj Z, FLA_Obj T );


FLA_Error FLA_Hess_UT_opt_var1( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Hess_UT_step_opt_var1( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Hess_UT_step_ops_var1( integer m_A,
                                     integer m_T,
                                     float* buff_A, integer rs_A, integer cs_A, 
                                     float* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Hess_UT_step_opd_var1( integer m_A,
                                     integer m_T,
                                     double* buff_A, integer rs_A, integer cs_A, 
                                     double* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Hess_UT_step_opc_var1( integer m_A,
                                     integer m_T,
                                     scomplex* buff_A, integer rs_A, integer cs_A, 
                                     scomplex* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Hess_UT_step_opz_var1( integer m_A,
                                     integer m_T,
                                     dcomplex* buff_A, integer rs_A, integer cs_A, 
                                     dcomplex* buff_T, integer rs_T, integer cs_T );


FLA_Error FLA_Hess_UT_opt_var2( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Hess_UT_step_opt_var2( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Hess_UT_step_ops_var2( integer m_A,
                                     integer m_T,
                                     float* buff_A, integer rs_A, integer cs_A, 
                                     float* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Hess_UT_step_opd_var2( integer m_A,
                                     integer m_T,
                                     double* buff_A, integer rs_A, integer cs_A, 
                                     double* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Hess_UT_step_opc_var2( integer m_A,
                                     integer m_T,
                                     scomplex* buff_A, integer rs_A, integer cs_A, 
                                     scomplex* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Hess_UT_step_opz_var2( integer m_A,
                                     integer m_T,
                                     dcomplex* buff_A, integer rs_A, integer cs_A, 
                                     dcomplex* buff_T, integer rs_T, integer cs_T );


FLA_Error FLA_Hess_UT_opt_var3( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Hess_UT_step_opt_var3( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Hess_UT_step_ops_var3( integer m_A,
                                     integer m_T,
                                     float* buff_A, integer rs_A, integer cs_A, 
                                     float* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Hess_UT_step_opd_var3( integer m_A,
                                     integer m_T,
                                     double* buff_A, integer rs_A, integer cs_A, 
                                     double* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Hess_UT_step_opc_var3( integer m_A,
                                     integer m_T,
                                     scomplex* buff_A, integer rs_A, integer cs_A, 
                                     scomplex* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Hess_UT_step_opz_var3( integer m_A,
                                     integer m_T,
                                     dcomplex* buff_A, integer rs_A, integer cs_A, 
                                     dcomplex* buff_T, integer rs_T, integer cs_T );


FLA_Error FLA_Hess_UT_opt_var4( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Hess_UT_step_opt_var4( FLA_Obj A, FLA_Obj Y, FLA_Obj Z, FLA_Obj T );
FLA_Error FLA_Hess_UT_step_ops_var4( integer m_A,
                                     integer m_T,
                                     float* buff_A, integer rs_A, integer cs_A, 
                                     float* buff_Y, integer rs_Y, integer cs_Y, 
                                     float* buff_Z, integer rs_Z, integer cs_Z, 
                                     float* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Hess_UT_step_opd_var4( integer m_A,
                                     integer m_T,
                                     double* buff_A, integer rs_A, integer cs_A, 
                                     double* buff_Y, integer rs_Y, integer cs_Y, 
                                     double* buff_Z, integer rs_Z, integer cs_Z, 
                                     double* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Hess_UT_step_opc_var4( integer m_A,
                                     integer m_T,
                                     scomplex* buff_A, integer rs_A, integer cs_A, 
                                     scomplex* buff_Y, integer rs_Y, integer cs_Y, 
                                     scomplex* buff_Z, integer rs_Z, integer cs_Z, 
                                     scomplex* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Hess_UT_step_opz_var4( integer m_A,
                                     integer m_T,
                                     dcomplex* buff_A, integer rs_A, integer cs_A, 
                                     dcomplex* buff_Y, integer rs_Y, integer cs_Y, 
                                     dcomplex* buff_Z, integer rs_Z, integer cs_Z, 
                                     dcomplex* buff_T, integer rs_T, integer cs_T );


FLA_Error FLA_Hess_UT_opt_var5( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Hess_UT_step_opt_var5( FLA_Obj A, FLA_Obj U, FLA_Obj Z, FLA_Obj T );
FLA_Error FLA_Hess_UT_step_ops_var5( integer m_A,
                                     integer m_T,
                                     float* buff_A, integer rs_A, integer cs_A, 
                                     float* buff_U, integer rs_U, integer cs_U, 
                                     float* buff_Z, integer rs_Z, integer cs_Z, 
                                     float* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Hess_UT_step_opd_var5( integer m_A,
                                     integer m_T,
                                     double* buff_A, integer rs_A, integer cs_A, 
                                     double* buff_U, integer rs_U, integer cs_U, 
                                     double* buff_Z, integer rs_Z, integer cs_Z, 
                                     double* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Hess_UT_step_opc_var5( integer m_A,
                                     integer m_T,
                                     scomplex* buff_A, integer rs_A, integer cs_A, 
                                     scomplex* buff_U, integer rs_U, integer cs_U, 
                                     scomplex* buff_Z, integer rs_Z, integer cs_Z, 
                                     scomplex* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Hess_UT_step_opz_var5( integer m_A,
                                     integer m_T,
                                     dcomplex* buff_A, integer rs_A, integer cs_A, 
                                     dcomplex* buff_U, integer rs_U, integer cs_U, 
                                     dcomplex* buff_Z, integer rs_Z, integer cs_Z, 
                                     dcomplex* buff_T, integer rs_T, integer cs_T );


FLA_Error FLA_Hess_UT_ofu_var1( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Hess_UT_step_ofu_var1( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Hess_UT_step_ofs_var1( integer m_A,
                                     integer m_T,
                                     float* buff_A, integer rs_A, integer cs_A, 
                                     float* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Hess_UT_step_ofd_var1( integer m_A,
                                     integer m_T,
                                     double* buff_A, integer rs_A, integer cs_A, 
                                     double* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Hess_UT_step_ofc_var1( integer m_A,
                                     integer m_T,
                                     scomplex* buff_A, integer rs_A, integer cs_A, 
                                     scomplex* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Hess_UT_step_ofz_var1( integer m_A,
                                     integer m_T,
                                     dcomplex* buff_A, integer rs_A, integer cs_A, 
                                     dcomplex* buff_T, integer rs_T, integer cs_T );


FLA_Error FLA_Hess_UT_ofu_var2( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Hess_UT_step_ofu_var2( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Hess_UT_step_ofs_var2( integer m_A,
                                     integer m_T,
                                     float* buff_A, integer rs_A, integer cs_A, 
                                     float* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Hess_UT_step_ofd_var2( integer m_A,
                                     integer m_T,
                                     double* buff_A, integer rs_A, integer cs_A, 
                                     double* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Hess_UT_step_ofc_var2( integer m_A,
                                     integer m_T,
                                     scomplex* buff_A, integer rs_A, integer cs_A, 
                                     scomplex* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Hess_UT_step_ofz_var2( integer m_A,
                                     integer m_T,
                                     dcomplex* buff_A, integer rs_A, integer cs_A, 
                                     dcomplex* buff_T, integer rs_T, integer cs_T );


FLA_Error FLA_Hess_UT_ofu_var3( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Hess_UT_step_ofu_var3( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Hess_UT_step_ofs_var3( integer m_A,
                                     integer m_T,
                                     float* buff_A, integer rs_A, integer cs_A, 
                                     float* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Hess_UT_step_ofd_var3( integer m_A,
                                     integer m_T,
                                     double* buff_A, integer rs_A, integer cs_A, 
                                     double* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Hess_UT_step_ofc_var3( integer m_A,
                                     integer m_T,
                                     scomplex* buff_A, integer rs_A, integer cs_A, 
                                     scomplex* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Hess_UT_step_ofz_var3( integer m_A,
                                     integer m_T,
                                     dcomplex* buff_A, integer rs_A, integer cs_A, 
                                     dcomplex* buff_T, integer rs_T, integer cs_T );


FLA_Error FLA_Hess_UT_ofu_var4( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Hess_UT_step_ofu_var4( FLA_Obj A, FLA_Obj Y, FLA_Obj Z, FLA_Obj T );
FLA_Error FLA_Hess_UT_step_ofs_var4( integer m_A,
                                     integer m_T,
                                     float* buff_A, integer rs_A, integer cs_A, 
                                     float* buff_Y, integer rs_Y, integer cs_Y,
                                     float* buff_Z, integer rs_Z, integer cs_Z,
                                     float* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Hess_UT_step_ofd_var4( integer m_A,
                                     integer m_T,
                                     double* buff_A, integer rs_A, integer cs_A, 
                                     double* buff_Y, integer rs_Y, integer cs_Y,
                                     double* buff_Z, integer rs_Z, integer cs_Z,
                                     double* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Hess_UT_step_ofc_var4( integer m_A,
                                     integer m_T,
                                     scomplex* buff_A, integer rs_A, integer cs_A, 
                                     scomplex* buff_Y, integer rs_Y, integer cs_Y,
                                     scomplex* buff_Z, integer rs_Z, integer cs_Z,
                                     scomplex* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Hess_UT_step_ofz_var4( integer m_A,
                                     integer m_T,
                                     dcomplex* buff_A, integer rs_A, integer cs_A, 
                                     dcomplex* buff_Y, integer rs_Y, integer cs_Y,
                                     dcomplex* buff_Z, integer rs_Z, integer cs_Z,
                                     dcomplex* buff_T, integer rs_T, integer cs_T );


// --- Fused operations --------------------------------------------------------

FLA_Error FLA_Fused_Ahx_Ax_ops_var1( integer m_A,
                                     integer n_A,
                                     float* buff_A, integer rs_A, integer cs_A, 
                                     float* buff_x, integer inc_x, 
                                     float* buff_v, integer inc_v, 
                                     float* buff_w, integer inc_w );
FLA_Error FLA_Fused_Ahx_Ax_opd_var1( integer m_A,
                                     integer n_A,
                                     double* buff_A, integer rs_A, integer cs_A, 
                                     double* buff_x, integer inc_x, 
                                     double* buff_v, integer inc_v, 
                                     double* buff_w, integer inc_w );
FLA_Error FLA_Fused_Ahx_Ax_opc_var1( integer m_A,
                                     integer n_A,
                                     scomplex* buff_A, integer rs_A, integer cs_A, 
                                     scomplex* buff_x, integer inc_x, 
                                     scomplex* buff_v, integer inc_v, 
                                     scomplex* buff_w, integer inc_w );
FLA_Error FLA_Fused_Ahx_Ax_opz_var1( integer m_A,
                                     integer n_A,
                                     dcomplex* buff_A, integer rs_A, integer cs_A, 
                                     dcomplex* buff_x, integer inc_x, 
                                     dcomplex* buff_v, integer inc_v, 
                                     dcomplex* buff_w, integer inc_w );


FLA_Error FLA_Fused_Gerc2_Ahx_Ax_ops_var1( integer m_A,
                                           integer n_A,
                                           float* buff_alpha, 
                                           float* buff_u, integer inc_u, 
                                           float* buff_y, integer inc_y, 
                                           float* buff_z, integer inc_z, 
                                           float* buff_A, integer rs_A, integer cs_A, 
                                           float* buff_x, integer inc_x, 
                                           float* buff_v, integer inc_v, 
                                           float* buff_w, integer inc_w );
FLA_Error FLA_Fused_Gerc2_Ahx_Ax_opd_var1( integer m_A,
                                           integer n_A,
                                           double* buff_alpha, 
                                           double* buff_u, integer inc_u, 
                                           double* buff_y, integer inc_y, 
                                           double* buff_z, integer inc_z, 
                                           double* buff_A, integer rs_A, integer cs_A, 
                                           double* buff_x, integer inc_x, 
                                           double* buff_v, integer inc_v, 
                                           double* buff_w, integer inc_w );
FLA_Error FLA_Fused_Gerc2_Ahx_Ax_opc_var1( integer m_A,
                                           integer n_A,
                                           scomplex* buff_alpha, 
                                           scomplex* buff_u, integer inc_u, 
                                           scomplex* buff_y, integer inc_y, 
                                           scomplex* buff_z, integer inc_z, 
                                           scomplex* buff_A, integer rs_A, integer cs_A, 
                                           scomplex* buff_x, integer inc_x, 
                                           scomplex* buff_v, integer inc_v, 
                                           scomplex* buff_w, integer inc_w );
FLA_Error FLA_Fused_Gerc2_Ahx_Ax_opz_var1( integer m_A,
                                           integer n_A,
                                           dcomplex* buff_alpha, 
                                           dcomplex* buff_u, integer inc_u, 
                                           dcomplex* buff_y, integer inc_y, 
                                           dcomplex* buff_z, integer inc_z, 
                                           dcomplex* buff_A, integer rs_A, integer cs_A, 
                                           dcomplex* buff_x, integer inc_x, 
                                           dcomplex* buff_v, integer inc_v, 
                                           dcomplex* buff_w, integer inc_w );


FLA_Error FLA_Fused_Uhu_Yhu_Zhu_ops_var1( integer m_U,
                                          integer n_U,
                                          float* buff_delta,
                                          float* buff_U, integer rs_U, integer cs_U,
                                          float* buff_Y, integer rs_Y, integer cs_Y,
                                          float* buff_Z, integer rs_Z, integer cs_Z,
                                          float* buff_t, integer inc_t,
                                          float* buff_u, integer inc_u,
                                          float* buff_y, integer inc_y,
                                          float* buff_z, integer inc_z );
FLA_Error FLA_Fused_Uhu_Yhu_Zhu_opd_var1( integer m_U,
                                          integer n_U,
                                          double* buff_delta,
                                          double* buff_U, integer rs_U, integer cs_U,
                                          double* buff_Y, integer rs_Y, integer cs_Y,
                                          double* buff_Z, integer rs_Z, integer cs_Z,
                                          double* buff_t, integer inc_t,
                                          double* buff_u, integer inc_u,
                                          double* buff_y, integer inc_y,
                                          double* buff_z, integer inc_z );
FLA_Error FLA_Fused_Uhu_Yhu_Zhu_opc_var1( integer m_U,
                                          integer n_U,
                                          scomplex* buff_delta,
                                          scomplex* buff_U, integer rs_U, integer cs_U,
                                          scomplex* buff_Y, integer rs_Y, integer cs_Y,
                                          scomplex* buff_Z, integer rs_Z, integer cs_Z,
                                          scomplex* buff_t, integer inc_t,
                                          scomplex* buff_u, integer inc_u,
                                          scomplex* buff_y, integer inc_y,
                                          scomplex* buff_z, integer inc_z );
FLA_Error FLA_Fused_Uhu_Yhu_Zhu_opz_var1( integer m_U,
                                          integer n_U,
                                          dcomplex* buff_delta,
                                          dcomplex* buff_U, integer rs_U, integer cs_U,
                                          dcomplex* buff_Y, integer rs_Y, integer cs_Y,
                                          dcomplex* buff_Z, integer rs_Z, integer cs_Z,
                                          dcomplex* buff_t, integer inc_t,
                                          dcomplex* buff_u, integer inc_u,
                                          dcomplex* buff_y, integer inc_y,
                                          dcomplex* buff_z, integer inc_z );

// end FLA_Hess_UT_vars.h

FLA_Error FLA_Hess_UT( FLA_Obj A, FLA_Obj T );

FLA_Error FLA_Hess_UT_internal( FLA_Obj A, FLA_Obj T, fla_hessut_t* cntl );

FLA_Error FLA_Hess_UT_create_T( FLA_Obj A, FLA_Obj* T );

FLA_Error FLA_Hess_UT_recover_tau( FLA_Obj T, FLA_Obj t );
// end FLA_Hess_UT.h
// begin FLA_Tridiag_UT.h


// begin FLA_Tridiag_UT_l.h


FLA_Error FLA_Tridiag_UT_l_blk_var1( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Tridiag_UT_l_unb_var1( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Tridiag_UT_l_step_unb_var1( FLA_Obj A, FLA_Obj T );

FLA_Error FLA_Tridiag_UT_l_blk_var2( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Tridiag_UT_l_blf_var2( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Tridiag_UT_l_unb_var2( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Tridiag_UT_l_step_unb_var2( FLA_Obj A, FLA_Obj T );

FLA_Error FLA_Tridiag_UT_l_blk_var3( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Tridiag_UT_l_blf_var3( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Tridiag_UT_l_unb_var3( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Tridiag_UT_l_step_unb_var3( FLA_Obj A, FLA_Obj Z, FLA_Obj T );

FLA_Error FLA_Tridiag_UT_l_opt_var1( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Tridiag_UT_l_step_opt_var1( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Tridiag_UT_l_step_ops_var1( integer m_A,
                                          integer m_T,
                                          float* buff_A, integer rs_A, integer cs_A, 
                                          float* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Tridiag_UT_l_step_opd_var1( integer m_A,
                                          integer m_T,
                                          double* buff_A, integer rs_A, integer cs_A, 
                                          double* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Tridiag_UT_l_step_opc_var1( integer m_A,
                                          integer m_T,
                                          scomplex* buff_A, integer rs_A, integer cs_A, 
                                          scomplex* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Tridiag_UT_l_step_opz_var1( integer m_A,
                                          integer m_T,
                                          dcomplex* buff_A, integer rs_A, integer cs_A, 
                                          dcomplex* buff_T, integer rs_T, integer cs_T );

FLA_Error FLA_Tridiag_UT_l_opt_var2( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Tridiag_UT_l_step_opt_var2( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Tridiag_UT_l_step_ops_var2( integer m_A,
                                          integer m_T,
                                          float* buff_A, integer rs_A, integer cs_A, 
                                          float* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Tridiag_UT_l_step_opd_var2( integer m_A,
                                          integer m_T,
                                          double* buff_A, integer rs_A, integer cs_A, 
                                          double* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Tridiag_UT_l_step_opc_var2( integer m_A,
                                          integer m_T,
                                          scomplex* buff_A, integer rs_A, integer cs_A, 
                                          scomplex* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Tridiag_UT_l_step_opz_var2( integer m_A,
                                          integer m_T,
                                          dcomplex* buff_A, integer rs_A, integer cs_A, 
                                          dcomplex* buff_T, integer rs_T, integer cs_T );

FLA_Error FLA_Tridiag_UT_l_opt_var3( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Tridiag_UT_l_step_opt_var3( FLA_Obj A, FLA_Obj Z, FLA_Obj T );
FLA_Error FLA_Tridiag_UT_l_step_ops_var3( integer m_A,
                                          integer m_T,
                                          float* buff_A, integer rs_A, integer cs_A, 
                                          float* buff_Z, integer rs_Z, integer cs_Z, 
                                          float* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Tridiag_UT_l_step_opd_var3( integer m_A,
                                          integer m_T,
                                          double* buff_A, integer rs_A, integer cs_A, 
                                          double* buff_Z, integer rs_Z, integer cs_Z, 
                                          double* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Tridiag_UT_l_step_opc_var3( integer m_A,
                                          integer m_T,
                                          scomplex* buff_A, integer rs_A, integer cs_A, 
                                          scomplex* buff_Z, integer rs_Z, integer cs_Z, 
                                          scomplex* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Tridiag_UT_l_step_opz_var3( integer m_A,
                                          integer m_T,
                                          dcomplex* buff_A, integer rs_A, integer cs_A, 
                                          dcomplex* buff_Z, integer rs_Z, integer cs_Z, 
                                          dcomplex* buff_T, integer rs_T, integer cs_T );

FLA_Error FLA_Tridiag_UT_l_ofu_var1( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Tridiag_UT_l_step_ofu_var1( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Tridiag_UT_l_step_ofs_var1( integer m_A,
                                          integer m_T,
                                          float* buff_A, integer rs_A, integer cs_A, 
                                          float* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Tridiag_UT_l_step_ofd_var1( integer m_A,
                                          integer m_T,
                                          double* buff_A, integer rs_A, integer cs_A, 
                                          double* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Tridiag_UT_l_step_ofc_var1( integer m_A,
                                          integer m_T,
                                          scomplex* buff_A, integer rs_A, integer cs_A, 
                                          scomplex* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Tridiag_UT_l_step_ofz_var1( integer m_A,
                                          integer m_T,
                                          dcomplex* buff_A, integer rs_A, integer cs_A, 
                                          dcomplex* buff_T, integer rs_T, integer cs_T );

FLA_Error FLA_Tridiag_UT_l_ofu_var2( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Tridiag_UT_l_step_ofu_var2( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Tridiag_UT_l_step_ofs_var2( integer m_A,
                                          integer m_T,
                                          float* buff_A, integer rs_A, integer cs_A, 
                                          float* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Tridiag_UT_l_step_ofd_var2( integer m_A,
                                          integer m_T,
                                          double* buff_A, integer rs_A, integer cs_A, 
                                          double* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Tridiag_UT_l_step_ofc_var2( integer m_A,
                                          integer m_T,
                                          scomplex* buff_A, integer rs_A, integer cs_A, 
                                          scomplex* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Tridiag_UT_l_step_ofz_var2( integer m_A,
                                          integer m_T,
                                          dcomplex* buff_A, integer rs_A, integer cs_A, 
                                          dcomplex* buff_T, integer rs_T, integer cs_T );

FLA_Error FLA_Tridiag_UT_l_ofu_var3( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Tridiag_UT_l_step_ofu_var3( FLA_Obj A, FLA_Obj Z, FLA_Obj T );
FLA_Error FLA_Tridiag_UT_l_step_ofs_var3( integer m_A,
                                          integer m_T,
                                          float* buff_A, integer rs_A, integer cs_A, 
                                          float* buff_Z, integer rs_Z, integer cs_Z,
                                          float* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Tridiag_UT_l_step_ofd_var3( integer m_A,
                                          integer m_T,
                                          double* buff_A, integer rs_A, integer cs_A, 
                                          double* buff_Z, integer rs_Z, integer cs_Z,
                                          double* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Tridiag_UT_l_step_ofc_var3( integer m_A,
                                          integer m_T,
                                          scomplex* buff_A, integer rs_A, integer cs_A, 
                                          scomplex* buff_Z, integer rs_Z, integer cs_Z,
                                          scomplex* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Tridiag_UT_l_step_ofz_var3( integer m_A,
                                          integer m_T,
                                          dcomplex* buff_A, integer rs_A, integer cs_A, 
                                          dcomplex* buff_Z, integer rs_Z, integer cs_Z,
                                          dcomplex* buff_T, integer rs_T, integer cs_T );

// --- Fused operations ---

FLA_Error FLA_Fused_Her2_Ax_l_opt_var1( FLA_Obj alpha, FLA_Obj u, FLA_Obj z, FLA_Obj A, FLA_Obj x, FLA_Obj w );
FLA_Error FLA_Fused_Her2_Ax_l_ops_var1( integer m_A,
                                        float* buff_alpha, 
                                        float* buff_u, integer inc_u, 
                                        float* buff_z, integer inc_z, 
                                        float* buff_A, integer rs_A, integer cs_A, 
                                        float* buff_x, integer inc_x, 
                                        float* buff_w, integer inc_w );
FLA_Error FLA_Fused_Her2_Ax_l_opd_var1( integer m_A,
                                        double* buff_alpha, 
                                        double* buff_u, integer inc_u, 
                                        double* buff_z, integer inc_z, 
                                        double* buff_A, integer rs_A, integer cs_A, 
                                        double* buff_x, integer inc_x, 
                                        double* buff_w, integer inc_w );
FLA_Error FLA_Fused_Her2_Ax_l_opc_var1( integer m_A,
                                        scomplex* buff_alpha, 
                                        scomplex* buff_u, integer inc_u, 
                                        scomplex* buff_z, integer inc_z, 
                                        scomplex* buff_A, integer rs_A, integer cs_A, 
                                        scomplex* buff_x, integer inc_x, 
                                        scomplex* buff_w, integer inc_w );
FLA_Error FLA_Fused_Her2_Ax_l_opz_var1( integer m_A,
                                        dcomplex* buff_alpha, 
                                        dcomplex* buff_u, integer inc_u, 
                                        dcomplex* buff_z, integer inc_z, 
                                        dcomplex* buff_A, integer rs_A, integer cs_A, 
                                        dcomplex* buff_x, integer inc_x, 
                                        dcomplex* buff_w, integer inc_w );

FLA_Error FLA_Fused_UZhu_ZUhu_opt_var1( FLA_Obj delta, FLA_Obj U, FLA_Obj Z, FLA_Obj t, FLA_Obj u, FLA_Obj w );
FLA_Error FLA_Fused_UZhu_ZUhu_ops_var1( integer m_U,
                                        integer n_U,
                                        float* buff_delta, 
                                        float* buff_U, integer rs_U, integer cs_U, 
                                        float* buff_Z, integer rs_Z, integer cs_Z, 
                                        float* buff_t, integer inc_t, 
                                        float* buff_u, integer inc_u, 
                                        float* buff_w, integer inc_w );
FLA_Error FLA_Fused_UZhu_ZUhu_opd_var1( integer m_U,
                                        integer n_U,
                                        double* buff_delta, 
                                        double* buff_U, integer rs_U, integer cs_U, 
                                        double* buff_Z, integer rs_Z, integer cs_Z, 
                                        double* buff_t, integer inc_t, 
                                        double* buff_u, integer inc_u, 
                                        double* buff_w, integer inc_w );
FLA_Error FLA_Fused_UZhu_ZUhu_opc_var1( integer m_U,
                                        integer n_U,
                                        scomplex* buff_delta, 
                                        scomplex* buff_U, integer rs_U, integer cs_U, 
                                        scomplex* buff_Z, integer rs_Z, integer cs_Z, 
                                        scomplex* buff_t, integer inc_t, 
                                        scomplex* buff_u, integer inc_u, 
                                        scomplex* buff_w, integer inc_w );
FLA_Error FLA_Fused_UZhu_ZUhu_opz_var1( integer m_U,
                                        integer n_U,
                                        dcomplex* buff_delta, 
                                        dcomplex* buff_U, integer rs_U, integer cs_U, 
                                        dcomplex* buff_Z, integer rs_Z, integer cs_Z, 
                                        dcomplex* buff_t, integer inc_t, 
                                        dcomplex* buff_u, integer inc_u, 
                                        dcomplex* buff_w, integer inc_w );
// end FLA_Tridiag_UT_l.h
//#include "FLA_Tridiag_UT_u.h"

FLA_Error FLA_Tridiag_UT( FLA_Uplo uplo, FLA_Obj A, FLA_Obj T );

FLA_Error FLA_Tridiag_UT_internal( FLA_Uplo uplo, FLA_Obj A, FLA_Obj T, fla_tridiagut_t* cntl );

FLA_Error FLA_Tridiag_UT_l( FLA_Obj A, FLA_Obj T, fla_tridiagut_t* cntl );
FLA_Error FLA_Tridiag_UT_u( FLA_Obj A, FLA_Obj T, fla_tridiagut_t* cntl );

FLA_Error FLA_Tridiag_UT_create_T( FLA_Obj A, FLA_Obj* T );
FLA_Error FLA_Tridiag_UT_recover_tau( FLA_Obj T, FLA_Obj t );

FLA_Error FLA_Tridiag_UT_scale_diagonals( FLA_Uplo uplo, FLA_Obj alpha, FLA_Obj A );

FLA_Error FLA_Tridiag_UT_extract_diagonals( FLA_Uplo uplo, FLA_Obj A, FLA_Obj d, FLA_Obj e );
FLA_Error FLA_Tridiag_UT_extract_real_diagonals( FLA_Uplo uplo, FLA_Obj A, FLA_Obj d, FLA_Obj e );
//// FLA_Error FLA_Tridiag_UT_l_extract_diagonals( FLA_Obj A, FLA_Obj d, FLA_Obj e );
//// FLA_Error FLA_Tridiag_UT_u_extract_diagonals( FLA_Obj A, FLA_Obj d, FLA_Obj e );

FLA_Error FLA_Tridiag_UT_realify( FLA_Uplo uplo, FLA_Obj A, FLA_Obj d );
FLA_Error FLA_Tridiag_UT_l_realify_unb( FLA_Obj A, FLA_Obj d );
FLA_Error FLA_Tridiag_UT_l_realify_opt( FLA_Obj A, FLA_Obj d );
FLA_Error FLA_Tridiag_UT_u_realify_unb( FLA_Obj A, FLA_Obj d );
FLA_Error FLA_Tridiag_UT_u_realify_opt( FLA_Obj A, FLA_Obj d );

FLA_Error FLA_Tridiag_UT_realify_subdiagonal( FLA_Obj b, FLA_Obj d );
FLA_Error FLA_Tridiag_UT_realify_subdiagonal_opt( FLA_Obj b, FLA_Obj d );

FLA_Error FLA_Tridiag_UT_shift_U( FLA_Uplo uplo, FLA_Obj A );
FLA_Error FLA_Tridiag_UT_shift_U_l_ops( integer       m_A,
                                        float*    buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Tridiag_UT_shift_U_u_ops( integer       m_A,
                                        float*    buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Tridiag_UT_shift_U_l_opd( integer       m_A,
                                        double*   buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Tridiag_UT_shift_U_u_opd( integer       m_A,
                                        double*   buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Tridiag_UT_shift_U_l_opc( integer       m_A,
                                        scomplex* buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Tridiag_UT_shift_U_u_opc( integer       m_A,
                                        scomplex* buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Tridiag_UT_shift_U_l_opz( integer       m_A,
                                        dcomplex* buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Tridiag_UT_shift_U_u_opz( integer       m_A,
                                        dcomplex* buff_A, integer rs_A, integer cs_A );

FLA_Error FLA_Tridiag_UT_form_Q( FLA_Uplo uplo, FLA_Obj A, FLA_Obj T, FLA_Obj Q );
FLA_Error FLA_Tridiag_UT_form_Q_l_blk_var1( FLA_Obj A, FLA_Obj T, FLA_Obj W );
FLA_Error FLA_Tridiag_UT_form_Q_u_blk_var1( FLA_Obj A, FLA_Obj T, FLA_Obj W );
FLA_Error FLA_Tridiag_UT_form_Q_l_opt_var1( FLA_Obj A, FLA_Obj T );
FLA_Error FLA_Tridiag_UT_form_Q_l_ops_var1( integer       m_A,
                                            integer       n_AT,
                                            float*    buff_A, integer rs_A, integer cs_A,
                                            float*    buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Tridiag_UT_form_Q_l_opd_var1( integer       m_A,
                                            integer       n_AT,
                                            double*   buff_A, integer rs_A, integer cs_A,
                                            double*   buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Tridiag_UT_form_Q_l_opc_var1( integer       m_A,
                                            integer       n_AT,
                                            scomplex* buff_A, integer rs_A, integer cs_A,
                                            scomplex* buff_T, integer rs_T, integer cs_T );
FLA_Error FLA_Tridiag_UT_form_Q_l_opz_var1( integer       m_A,
                                            integer       n_AT,
                                            dcomplex* buff_A, integer rs_A, integer cs_A,
                                            dcomplex* buff_T, integer rs_T, integer cs_T );
// end FLA_Tridiag_UT.h
// begin FLA_Bidiag_UT.h


//#include "FLA_Bidiag_UT_l.h"
// begin FLA_Bidiag_UT_u.h


FLA_Error FLA_Bidiag_UT_u_unb_var1( FLA_Obj A, FLA_Obj TU, FLA_Obj TV );
FLA_Error FLA_Bidiag_UT_u_blk_var1( FLA_Obj A, FLA_Obj TU, FLA_Obj TV );
FLA_Error FLA_Bidiag_UT_u_step_unb_var1( FLA_Obj A, FLA_Obj TU, FLA_Obj TV );

FLA_Error FLA_Bidiag_UT_u_unb_var2( FLA_Obj A, FLA_Obj TU, FLA_Obj TV );
FLA_Error FLA_Bidiag_UT_u_blk_var2( FLA_Obj A, FLA_Obj TU, FLA_Obj TV );
FLA_Error FLA_Bidiag_UT_u_blf_var2( FLA_Obj A, FLA_Obj TU, FLA_Obj TV );
FLA_Error FLA_Bidiag_UT_u_step_unb_var2( FLA_Obj A, FLA_Obj TU, FLA_Obj TV );

FLA_Error FLA_Bidiag_UT_u_unb_var3( FLA_Obj A, FLA_Obj TU, FLA_Obj TV );
FLA_Error FLA_Bidiag_UT_u_blk_var3( FLA_Obj A, FLA_Obj TU, FLA_Obj TV );
FLA_Error FLA_Bidiag_UT_u_blf_var3( FLA_Obj A, FLA_Obj TU, FLA_Obj TV );
FLA_Error FLA_Bidiag_UT_u_step_unb_var3( FLA_Obj A, FLA_Obj TU, FLA_Obj TV );

FLA_Error FLA_Bidiag_UT_u_unb_var4( FLA_Obj A, FLA_Obj TU, FLA_Obj TV );
FLA_Error FLA_Bidiag_UT_u_blk_var4( FLA_Obj A, FLA_Obj TU, FLA_Obj TV );
FLA_Error FLA_Bidiag_UT_u_blf_var4( FLA_Obj A, FLA_Obj TU, FLA_Obj TV );
FLA_Error FLA_Bidiag_UT_u_step_unb_var4( FLA_Obj A, FLA_Obj Y, FLA_Obj Z, FLA_Obj TU, FLA_Obj TV );

FLA_Error FLA_Bidiag_UT_u_unb_var5( FLA_Obj A, FLA_Obj TU, FLA_Obj TV );
FLA_Error FLA_Bidiag_UT_u_blk_var5( FLA_Obj A, FLA_Obj TU, FLA_Obj TV );
FLA_Error FLA_Bidiag_UT_u_step_unb_var5( FLA_Obj A, FLA_Obj Y, FLA_Obj Z, FLA_Obj TU, FLA_Obj TV );

FLA_Error FLA_Bidiag_UT_u_opt_var1( FLA_Obj A, FLA_Obj T, FLA_Obj S );
FLA_Error FLA_Bidiag_UT_u_step_opt_var1( FLA_Obj A, FLA_Obj T, FLA_Obj S );
FLA_Error FLA_Bidiag_UT_u_step_ops_var1( integer m_A,
                                         integer n_A,
                                         integer m_TS,
                                         float* buff_A, integer rs_A, integer cs_A, 
                                         float* buff_T, integer rs_T, integer cs_T, 
                                         float* buff_S, integer rs_S, integer cs_S );
FLA_Error FLA_Bidiag_UT_u_step_opd_var1( integer m_A,
                                         integer n_A,
                                         integer m_TS,
                                         double* buff_A, integer rs_A, integer cs_A, 
                                         double* buff_T, integer rs_T, integer cs_T, 
                                         double* buff_S, integer rs_S, integer cs_S );
FLA_Error FLA_Bidiag_UT_u_step_opc_var1( integer m_A,
                                         integer n_A,
                                         integer m_TS,
                                         scomplex* buff_A, integer rs_A, integer cs_A, 
                                         scomplex* buff_T, integer rs_T, integer cs_T, 
                                         scomplex* buff_S, integer rs_S, integer cs_S );
FLA_Error FLA_Bidiag_UT_u_step_opz_var1( integer m_A,
                                         integer n_A,
                                         integer m_TS,
                                         dcomplex* buff_A, integer rs_A, integer cs_A, 
                                         dcomplex* buff_T, integer rs_T, integer cs_T, 
                                         dcomplex* buff_S, integer rs_S, integer cs_S );

FLA_Error FLA_Bidiag_UT_u_opt_var2( FLA_Obj A, FLA_Obj T, FLA_Obj S );
FLA_Error FLA_Bidiag_UT_u_step_opt_var2( FLA_Obj A, FLA_Obj T, FLA_Obj S );
FLA_Error FLA_Bidiag_UT_u_step_ops_var2( integer m_A,
                                         integer n_A,
                                         integer m_TS,
                                         float* buff_A, integer rs_A, integer cs_A, 
                                         float* buff_T, integer rs_T, integer cs_T, 
                                         float* buff_S, integer rs_S, integer cs_S );
FLA_Error FLA_Bidiag_UT_u_step_opd_var2( integer m_A,
                                         integer n_A,
                                         integer m_TS,
                                         double* buff_A, integer rs_A, integer cs_A, 
                                         double* buff_T, integer rs_T, integer cs_T, 
                                         double* buff_S, integer rs_S, integer cs_S );
FLA_Error FLA_Bidiag_UT_u_step_opc_var2( integer m_A,
                                         integer n_A,
                                         integer m_TS,
                                         scomplex* buff_A, integer rs_A, integer cs_A, 
                                         scomplex* buff_T, integer rs_T, integer cs_T, 
                                         scomplex* buff_S, integer rs_S, integer cs_S );
FLA_Error FLA_Bidiag_UT_u_step_opz_var2( integer m_A,
                                         integer n_A,
                                         integer m_TS,
                                         dcomplex* buff_A, integer rs_A, integer cs_A, 
                                         dcomplex* buff_T, integer rs_T, integer cs_T, 
                                         dcomplex* buff_S, integer rs_S, integer cs_S );

FLA_Error FLA_Bidiag_UT_u_opt_var3( FLA_Obj A, FLA_Obj T, FLA_Obj S );
FLA_Error FLA_Bidiag_UT_u_step_opt_var3( FLA_Obj A, FLA_Obj T, FLA_Obj S );
FLA_Error FLA_Bidiag_UT_u_step_ops_var3( integer m_A,
                                         integer n_A,
                                         integer m_TS,
                                         float* buff_A, integer rs_A, integer cs_A, 
                                         float* buff_T, integer rs_T, integer cs_T, 
                                         float* buff_S, integer rs_S, integer cs_S );
FLA_Error FLA_Bidiag_UT_u_step_opd_var3( integer m_A,
                                         integer n_A,
                                         integer m_TS,
                                         double* buff_A, integer rs_A, integer cs_A, 
                                         double* buff_T, integer rs_T, integer cs_T, 
                                         double* buff_S, integer rs_S, integer cs_S );
FLA_Error FLA_Bidiag_UT_u_step_opc_var3( integer m_A,
                                         integer n_A,
                                         integer m_TS,
                                         scomplex* buff_A, integer rs_A, integer cs_A, 
                                         scomplex* buff_T, integer rs_T, integer cs_T, 
                                         scomplex* buff_S, integer rs_S, integer cs_S );
FLA_Error FLA_Bidiag_UT_u_step_opz_var3( integer m_A,
                                         integer n_A,
                                         integer m_TS,
                                         dcomplex* buff_A, integer rs_A, integer cs_A, 
                                         dcomplex* buff_T, integer rs_T, integer cs_T, 
                                         dcomplex* buff_S, integer rs_S, integer cs_S );

FLA_Error FLA_Bidiag_UT_u_opt_var4( FLA_Obj A, FLA_Obj T, FLA_Obj S );
FLA_Error FLA_Bidiag_UT_u_step_opt_var4( FLA_Obj A, FLA_Obj Y, FLA_Obj Z, FLA_Obj T, FLA_Obj S );
FLA_Error FLA_Bidiag_UT_u_step_ops_var4( integer m_A,
                                         integer n_A,
                                         integer m_TS,
                                         float* buff_A, integer rs_A, integer cs_A, 
                                         float* buff_Y, integer rs_Y, integer cs_Y, 
                                         float* buff_Z, integer rs_Z, integer cs_Z, 
                                         float* buff_T, integer rs_T, integer cs_T, 
                                         float* buff_S, integer rs_S, integer cs_S );
FLA_Error FLA_Bidiag_UT_u_step_opd_var4( integer m_A,
                                         integer n_A,
                                         integer m_TS,
                                         double* buff_A, integer rs_A, integer cs_A, 
                                         double* buff_Y, integer rs_Y, integer cs_Y, 
                                         double* buff_Z, integer rs_Z, integer cs_Z, 
                                         double* buff_T, integer rs_T, integer cs_T, 
                                         double* buff_S, integer rs_S, integer cs_S );
FLA_Error FLA_Bidiag_UT_u_step_opc_var4( integer m_A,
                                         integer n_A,
                                         integer m_TS,
                                         scomplex* buff_A, integer rs_A, integer cs_A, 
                                         scomplex* buff_Y, integer rs_Y, integer cs_Y, 
                                         scomplex* buff_Z, integer rs_Z, integer cs_Z, 
                                         scomplex* buff_T, integer rs_T, integer cs_T, 
                                         scomplex* buff_S, integer rs_S, integer cs_S );
FLA_Error FLA_Bidiag_UT_u_step_opz_var4( integer m_A,
                                         integer n_A,
                                         integer m_TS,
                                         dcomplex* buff_A, integer rs_A, integer cs_A, 
                                         dcomplex* buff_Y, integer rs_Y, integer cs_Y, 
                                         dcomplex* buff_Z, integer rs_Z, integer cs_Z, 
                                         dcomplex* buff_T, integer rs_T, integer cs_T, 
                                         dcomplex* buff_S, integer rs_S, integer cs_S );

FLA_Error FLA_Bidiag_UT_u_opt_var5( FLA_Obj A, FLA_Obj T, FLA_Obj S );
FLA_Error FLA_Bidiag_UT_u_step_opt_var5( FLA_Obj A, FLA_Obj Y, FLA_Obj Z, FLA_Obj T, FLA_Obj S );
FLA_Error FLA_Bidiag_UT_u_step_ops_var5( integer m_A,
                                         integer n_A,
                                         integer m_TS,
                                         float* buff_A, integer rs_A, integer cs_A, 
                                         float* buff_Y, integer rs_Y, integer cs_Y, 
                                         float* buff_Z, integer rs_Z, integer cs_Z, 
                                         float* buff_T, integer rs_T, integer cs_T, 
                                         float* buff_S, integer rs_S, integer cs_S );
FLA_Error FLA_Bidiag_UT_u_step_opd_var5( integer m_A,
                                         integer n_A,
                                         integer m_TS,
                                         double* buff_A, integer rs_A, integer cs_A, 
                                         double* buff_Y, integer rs_Y, integer cs_Y, 
                                         double* buff_Z, integer rs_Z, integer cs_Z, 
                                         double* buff_T, integer rs_T, integer cs_T, 
                                         double* buff_S, integer rs_S, integer cs_S );
FLA_Error FLA_Bidiag_UT_u_step_opc_var5( integer m_A,
                                         integer n_A,
                                         integer m_TS,
                                         scomplex* buff_A, integer rs_A, integer cs_A, 
                                         scomplex* buff_Y, integer rs_Y, integer cs_Y, 
                                         scomplex* buff_Z, integer rs_Z, integer cs_Z, 
                                         scomplex* buff_T, integer rs_T, integer cs_T, 
                                         scomplex* buff_S, integer rs_S, integer cs_S );
FLA_Error FLA_Bidiag_UT_u_step_opz_var5( integer m_A,
                                         integer n_A,
                                         integer m_TS,
                                         dcomplex* buff_A, integer rs_A, integer cs_A, 
                                         dcomplex* buff_Y, integer rs_Y, integer cs_Y, 
                                         dcomplex* buff_Z, integer rs_Z, integer cs_Z, 
                                         dcomplex* buff_T, integer rs_T, integer cs_T, 
                                         dcomplex* buff_S, integer rs_S, integer cs_S );


FLA_Error FLA_Bidiag_UT_u_ofu_var2( FLA_Obj A, FLA_Obj T, FLA_Obj S );
FLA_Error FLA_Bidiag_UT_u_step_ofu_var2( FLA_Obj A, FLA_Obj T, FLA_Obj S );
FLA_Error FLA_Bidiag_UT_u_step_ofs_var2( integer m_A,
                                         integer n_A,
                                         integer m_TS,
                                         float* buff_A, integer rs_A, integer cs_A, 
                                         float* buff_T, integer rs_T, integer cs_T, 
                                         float* buff_S, integer rs_S, integer cs_S );
FLA_Error FLA_Bidiag_UT_u_step_ofd_var2( integer m_A,
                                         integer n_A,
                                         integer m_TS,
                                         double* buff_A, integer rs_A, integer cs_A, 
                                         double* buff_T, integer rs_T, integer cs_T, 
                                         double* buff_S, integer rs_S, integer cs_S );
FLA_Error FLA_Bidiag_UT_u_step_ofc_var2( integer m_A,
                                         integer n_A,
                                         integer m_TS,
                                         scomplex* buff_A, integer rs_A, integer cs_A, 
                                         scomplex* buff_T, integer rs_T, integer cs_T, 
                                         scomplex* buff_S, integer rs_S, integer cs_S );
FLA_Error FLA_Bidiag_UT_u_step_ofz_var2( integer m_A,
                                         integer n_A,
                                         integer m_TS,
                                         dcomplex* buff_A, integer rs_A, integer cs_A, 
                                         dcomplex* buff_T, integer rs_T, integer cs_T, 
                                         dcomplex* buff_S, integer rs_S, integer cs_S );

FLA_Error FLA_Bidiag_UT_u_ofu_var3( FLA_Obj A, FLA_Obj T, FLA_Obj S );
FLA_Error FLA_Bidiag_UT_u_step_ofu_var3( FLA_Obj A, FLA_Obj T, FLA_Obj S );
FLA_Error FLA_Bidiag_UT_u_step_ofs_var3( integer m_A,
                                         integer n_A,
                                         integer m_TS,
                                         float* buff_A, integer rs_A, integer cs_A, 
                                         float* buff_T, integer rs_T, integer cs_T, 
                                         float* buff_S, integer rs_S, integer cs_S );
FLA_Error FLA_Bidiag_UT_u_step_ofd_var3( integer m_A,
                                         integer n_A,
                                         integer m_TS,
                                         double* buff_A, integer rs_A, integer cs_A, 
                                         double* buff_T, integer rs_T, integer cs_T, 
                                         double* buff_S, integer rs_S, integer cs_S );
FLA_Error FLA_Bidiag_UT_u_step_ofc_var3( integer m_A,
                                         integer n_A,
                                         integer m_TS,
                                         scomplex* buff_A, integer rs_A, integer cs_A, 
                                         scomplex* buff_T, integer rs_T, integer cs_T, 
                                         scomplex* buff_S, integer rs_S, integer cs_S );
FLA_Error FLA_Bidiag_UT_u_step_ofz_var3( integer m_A,
                                         integer n_A,
                                         integer m_TS,
                                         dcomplex* buff_A, integer rs_A, integer cs_A, 
                                         dcomplex* buff_T, integer rs_T, integer cs_T, 
                                         dcomplex* buff_S, integer rs_S, integer cs_S );

FLA_Error FLA_Bidiag_UT_u_ofu_var4( FLA_Obj A, FLA_Obj T, FLA_Obj S );
FLA_Error FLA_Bidiag_UT_u_step_ofu_var4( FLA_Obj A, FLA_Obj Y, FLA_Obj Z, FLA_Obj T, FLA_Obj S );
FLA_Error FLA_Bidiag_UT_u_step_ofs_var4( integer m_A,
                                         integer n_A,
                                         integer m_TS,
                                         float* buff_A, integer rs_A, integer cs_A, 
                                         float* buff_Y, integer rs_Y, integer cs_Y, 
                                         float* buff_Z, integer rs_Z, integer cs_Z, 
                                         float* buff_T, integer rs_T, integer cs_T, 
                                         float* buff_S, integer rs_S, integer cs_S );
FLA_Error FLA_Bidiag_UT_u_step_ofd_var4( integer m_A,
                                         integer n_A,
                                         integer m_TS,
                                         double* buff_A, integer rs_A, integer cs_A, 
                                         double* buff_Y, integer rs_Y, integer cs_Y, 
                                         double* buff_Z, integer rs_Z, integer cs_Z, 
                                         double* buff_T, integer rs_T, integer cs_T, 
                                         double* buff_S, integer rs_S, integer cs_S );
FLA_Error FLA_Bidiag_UT_u_step_ofc_var4( integer m_A,
                                         integer n_A,
                                         integer m_TS,
                                         scomplex* buff_A, integer rs_A, integer cs_A, 
                                         scomplex* buff_Y, integer rs_Y, integer cs_Y, 
                                         scomplex* buff_Z, integer rs_Z, integer cs_Z, 
                                         scomplex* buff_T, integer rs_T, integer cs_T, 
                                         scomplex* buff_S, integer rs_S, integer cs_S );
FLA_Error FLA_Bidiag_UT_u_step_ofz_var4( integer m_A,
                                         integer n_A,
                                         integer m_TS,
                                         dcomplex* buff_A, integer rs_A, integer cs_A, 
                                         dcomplex* buff_Y, integer rs_Y, integer cs_Y, 
                                         dcomplex* buff_Z, integer rs_Z, integer cs_Z, 
                                         dcomplex* buff_T, integer rs_T, integer cs_T, 
                                         dcomplex* buff_S, integer rs_S, integer cs_S );

// --- Fused operations ---

FLA_Error FLA_Fused_Gerc2_opt_var1( FLA_Obj alpha, FLA_Obj u, FLA_Obj y, FLA_Obj z, FLA_Obj v, FLA_Obj A );
FLA_Error FLA_Fused_Gerc2_ops_var1( integer m_A,
                                    integer n_A,
                                    float* buff_alpha, 
                                    float* buff_u, integer inc_u, 
                                    float* buff_y, integer inc_y, 
                                    float* buff_z, integer inc_z, 
                                    float* buff_v, integer inc_v, 
                                    float* buff_A, integer rs_A, integer cs_A ); 
FLA_Error FLA_Fused_Gerc2_opd_var1( integer m_A,
                                    integer n_A,
                                    double* buff_alpha, 
                                    double* buff_u, integer inc_u, 
                                    double* buff_y, integer inc_y, 
                                    double* buff_z, integer inc_z, 
                                    double* buff_v, integer inc_v, 
                                    double* buff_A, integer rs_A, integer cs_A ); 
FLA_Error FLA_Fused_Gerc2_opc_var1( integer m_A,
                                    integer n_A,
                                    scomplex* buff_alpha, 
                                    scomplex* buff_u, integer inc_u, 
                                    scomplex* buff_y, integer inc_y, 
                                    scomplex* buff_z, integer inc_z, 
                                    scomplex* buff_v, integer inc_v, 
                                    scomplex* buff_A, integer rs_A, integer cs_A ); 
FLA_Error FLA_Fused_Gerc2_opz_var1( integer m_A,
                                    integer n_A,
                                    dcomplex* buff_alpha, 
                                    dcomplex* buff_u, integer inc_u, 
                                    dcomplex* buff_y, integer inc_y, 
                                    dcomplex* buff_z, integer inc_z, 
                                    dcomplex* buff_v, integer inc_v, 
                                    dcomplex* buff_A, integer rs_A, integer cs_A ); 


FLA_Error FLA_Fused_Ahx_Axpy_Ax_opt_var1( FLA_Obj A, FLA_Obj u, FLA_Obj tau, FLA_Obj a, FLA_Obj beta, FLA_Obj y, FLA_Obj w );
FLA_Error FLA_Fused_Ahx_Axpy_Ax_ops_var1( integer m_A,
                                          integer n_A,
                                          float* buff_tau, 
                                          float* buff_beta, 
                                          float* buff_A, integer rs_A, integer cs_A, 
                                          float* buff_u, integer inc_u, 
                                          float* buff_a, integer inc_a, 
                                          float* buff_y, integer inc_y, 
                                          float* buff_w, integer inc_w );
FLA_Error FLA_Fused_Ahx_Axpy_Ax_opd_var1( integer m_A,
                                          integer n_A,
                                          double* buff_tau, 
                                          double* buff_beta, 
                                          double* buff_A, integer rs_A, integer cs_A, 
                                          double* buff_u, integer inc_u, 
                                          double* buff_a, integer inc_a, 
                                          double* buff_y, integer inc_y, 
                                          double* buff_w, integer inc_w );
FLA_Error FLA_Fused_Ahx_Axpy_Ax_opc_var1( integer m_A,
                                          integer n_A,
                                          scomplex* buff_tau, 
                                          scomplex* buff_beta, 
                                          scomplex* buff_A, integer rs_A, integer cs_A, 
                                          scomplex* buff_u, integer inc_u, 
                                          scomplex* buff_a, integer inc_a, 
                                          scomplex* buff_y, integer inc_y, 
                                          scomplex* buff_w, integer inc_w );
FLA_Error FLA_Fused_Ahx_Axpy_Ax_opz_var1( integer m_A,
                                          integer n_A,
                                          dcomplex* buff_tau, 
                                          dcomplex* buff_beta, 
                                          dcomplex* buff_A, integer rs_A, integer cs_A, 
                                          dcomplex* buff_u, integer inc_u, 
                                          dcomplex* buff_a, integer inc_a, 
                                          dcomplex* buff_y, integer inc_y, 
                                          dcomplex* buff_w, integer inc_w );

FLA_Error FLA_Fused_Gerc2_Ahx_Axpy_Ax_opt_var1( FLA_Obj alpha, FLA_Obj tau, FLA_Obj u, FLA_Obj y, FLA_Obj z, FLA_Obj v, FLA_Obj A, FLA_Obj up, FLA_Obj a, FLA_Obj w );
FLA_Error FLA_Fused_Gerc2_Ahx_Axpy_Ax_ops_var1( integer m_A,
                                                integer n_A,
                                                float* buff_tau, 
                                                float* buff_alpha, 
                                                float* buff_u, integer inc_u, 
                                                float* buff_y, integer inc_y, 
                                                float* buff_z, integer inc_z, 
                                                float* buff_v, integer inc_v, 
                                                float* buff_A, integer rs_A, integer cs_A, 
                                                float* buff_up, integer inc_up, 
                                                float* buff_a, integer inc_a, 
                                                float* buff_w, integer inc_w );
FLA_Error FLA_Fused_Gerc2_Ahx_Axpy_Ax_opd_var1( integer m_A,
                                                integer n_A,
                                                double* buff_tau, 
                                                double* buff_alpha, 
                                                double* buff_u, integer inc_u, 
                                                double* buff_y, integer inc_y, 
                                                double* buff_z, integer inc_z, 
                                                double* buff_v, integer inc_v, 
                                                double* buff_A, integer rs_A, integer cs_A, 
                                                double* buff_up, integer inc_up, 
                                                double* buff_a, integer inc_a, 
                                                double* buff_w, integer inc_w );
FLA_Error FLA_Fused_Gerc2_Ahx_Axpy_Ax_opc_var1( integer m_A,
                                                integer n_A,
                                                scomplex* buff_tau, 
                                                scomplex* buff_alpha, 
                                                scomplex* buff_u, integer inc_u, 
                                                scomplex* buff_y, integer inc_y, 
                                                scomplex* buff_z, integer inc_z, 
                                                scomplex* buff_v, integer inc_v, 
                                                scomplex* buff_A, integer rs_A, integer cs_A, 
                                                scomplex* buff_up, integer inc_up, 
                                                scomplex* buff_a, integer inc_a, 
                                                scomplex* buff_w, integer inc_w );
FLA_Error FLA_Fused_Gerc2_Ahx_Axpy_Ax_opz_var1( integer m_A,
                                                integer n_A,
                                                dcomplex* buff_tau, 
                                                dcomplex* buff_alpha, 
                                                dcomplex* buff_u, integer inc_u, 
                                                dcomplex* buff_y, integer inc_y, 
                                                dcomplex* buff_z, integer inc_z, 
                                                dcomplex* buff_v, integer inc_v, 
                                                dcomplex* buff_A, integer rs_A, integer cs_A, 
                                                dcomplex* buff_up, integer inc_up, 
                                                dcomplex* buff_a, integer inc_a, 
                                                dcomplex* buff_w, integer inc_w );

FLA_Error FLA_Fused_UYx_ZVx_opt_var1( FLA_Obj delta, FLA_Obj a, FLA_Obj U, FLA_Obj Y, FLA_Obj Z, FLA_Obj V, FLA_Obj A, FLA_Obj temp, FLA_Obj t, FLA_Obj w, FLA_Obj al );
FLA_Error FLA_Fused_UYx_ZVx_ops_var1( integer m_U,
                                      integer n_U,
                                      integer m_V,
                                      integer n_V,
                                      float* buff_delta, 
                                      float* buff_U, integer rs_U, integer cs_U, 
                                      float* buff_Y, integer rs_Y, integer cs_Y, 
                                      float* buff_Z, integer rs_Z, integer cs_Z, 
                                      float* buff_V, integer rs_V, integer cs_V, 
                                      float* buff_A, integer rs_A, integer cs_A, 
                                      float* buff_temp, integer inc_temp, 
                                      float* buff_t, integer inc_t, 
                                      float* buff_a, integer inc_a, 
                                      float* buff_w, integer inc_w, 
                                      float* buff_al, integer inc_al );
FLA_Error FLA_Fused_UYx_ZVx_opd_var1( integer m_U,
                                      integer n_U,
                                      integer m_V,
                                      integer n_V,
                                      double* buff_delta, 
                                      double* buff_U, integer rs_U, integer cs_U, 
                                      double* buff_Y, integer rs_Y, integer cs_Y, 
                                      double* buff_Z, integer rs_Z, integer cs_Z, 
                                      double* buff_V, integer rs_V, integer cs_V, 
                                      double* buff_A, integer rs_A, integer cs_A, 
                                      double* buff_temp, integer inc_temp, 
                                      double* buff_t, integer inc_t, 
                                      double* buff_a, integer inc_a, 
                                      double* buff_w, integer inc_w, 
                                      double* buff_al, integer inc_al );
FLA_Error FLA_Fused_UYx_ZVx_opc_var1( integer m_U,
                                      integer n_U,
                                      integer m_V,
                                      integer n_V,
                                      scomplex* buff_delta, 
                                      scomplex* buff_U, integer rs_U, integer cs_U, 
                                      scomplex* buff_Y, integer rs_Y, integer cs_Y, 
                                      scomplex* buff_Z, integer rs_Z, integer cs_Z, 
                                      scomplex* buff_V, integer rs_V, integer cs_V, 
                                      scomplex* buff_A, integer rs_A, integer cs_A, 
                                      scomplex* buff_temp, integer inc_temp, 
                                      scomplex* buff_t, integer inc_t, 
                                      scomplex* buff_a, integer inc_a, 
                                      scomplex* buff_w, integer inc_w, 
                                      scomplex* buff_al, integer inc_al );
FLA_Error FLA_Fused_UYx_ZVx_opz_var1( integer m_U,
                                      integer n_U,
                                      integer m_V,
                                      integer n_V,
                                      dcomplex* buff_delta, 
                                      dcomplex* buff_U, integer rs_U, integer cs_U, 
                                      dcomplex* buff_Y, integer rs_Y, integer cs_Y, 
                                      dcomplex* buff_Z, integer rs_Z, integer cs_Z, 
                                      dcomplex* buff_V, integer rs_V, integer cs_V, 
                                      dcomplex* buff_A, integer rs_A, integer cs_A, 
                                      dcomplex* buff_temp, integer inc_temp, 
                                      dcomplex* buff_t, integer inc_t, 
                                      dcomplex* buff_a, integer inc_a, 
                                      dcomplex* buff_w, integer inc_w, 
                                      dcomplex* buff_al, integer inc_al );
// end FLA_Bidiag_UT_u.h

FLA_Error FLA_Bidiag_UT( FLA_Obj A, FLA_Obj TU, FLA_Obj TV );

FLA_Error FLA_Bidiag_UT_internal( FLA_Obj A, FLA_Obj TU, FLA_Obj TV, fla_bidiagut_t* cntl );

FLA_Error FLA_Bidiag_UT_l( FLA_Obj A, FLA_Obj TU, FLA_Obj TV, fla_bidiagut_t* cntl );
FLA_Error FLA_Bidiag_UT_u( FLA_Obj A, FLA_Obj TU, FLA_Obj TV, fla_bidiagut_t* cntl );

FLA_Error FLA_Bidiag_UT_create_T( FLA_Obj A, FLA_Obj* TU, FLA_Obj* TV );

FLA_Error FLA_Bidiag_UT_recover_tau( FLA_Obj TU, FLA_Obj TV, FLA_Obj tu, FLA_Obj tv );

FLA_Error FLA_Bidiag_UT_extract_diagonals( FLA_Obj A, FLA_Obj d, FLA_Obj e );
FLA_Error FLA_Bidiag_UT_u_extract_diagonals( FLA_Obj A, FLA_Obj d, FLA_Obj e );
FLA_Error FLA_Bidiag_UT_l_extract_diagonals( FLA_Obj A, FLA_Obj d, FLA_Obj e );

FLA_Error FLA_Bidiag_UT_extract_real_diagonals( FLA_Obj A, FLA_Obj d, FLA_Obj e );
FLA_Error FLA_Bidiag_UT_u_extract_real_diagonals( FLA_Obj A, FLA_Obj d, FLA_Obj e );
FLA_Error FLA_Bidiag_UT_l_extract_real_diagonals( FLA_Obj A, FLA_Obj d, FLA_Obj e );

FLA_Error FLA_Bidiag_UT_scale_diagonals( FLA_Obj alpha, FLA_Obj A );
FLA_Error FLA_Bidiag_UT_u_scale_diagonals( FLA_Obj alpha, FLA_Obj A );
FLA_Error FLA_Bidiag_UT_l_scale_diagonals( FLA_Obj alpha, FLA_Obj A );

FLA_Error FLA_Bidiag_UT_realify( FLA_Obj A, FLA_Obj d, FLA_Obj e );
FLA_Error FLA_Bidiag_UT_l_realify_unb( FLA_Obj A, FLA_Obj d, FLA_Obj e );
FLA_Error FLA_Bidiag_UT_l_realify_opt( FLA_Obj A, FLA_Obj d, FLA_Obj e );
FLA_Error FLA_Bidiag_UT_u_realify_unb( FLA_Obj A, FLA_Obj d, FLA_Obj e );
FLA_Error FLA_Bidiag_UT_u_realify_opt( FLA_Obj A, FLA_Obj d, FLA_Obj e );

FLA_Error FLA_Bidiag_UT_realify_diagonals( FLA_Uplo uplo, FLA_Obj a, FLA_Obj b, FLA_Obj d, FLA_Obj e );
FLA_Error FLA_Bidiag_UT_realify_diagonals_opt( FLA_Obj a, FLA_Obj b, FLA_Obj d, FLA_Obj e );

FLA_Error FLA_Bidiag_UT_form_U( FLA_Obj A, FLA_Obj T, FLA_Obj U );
FLA_Error FLA_Bidiag_UT_form_V( FLA_Obj A, FLA_Obj S, FLA_Obj V );

FLA_Error FLA_Bidiag_UT_form_U_ext( FLA_Uplo uplo, FLA_Obj A, FLA_Obj T, FLA_Trans transu, FLA_Obj U );
FLA_Error FLA_Bidiag_UT_form_V_ext( FLA_Uplo uplo, FLA_Obj A, FLA_Obj S, FLA_Trans transv, FLA_Obj V );

// end FLA_Bidiag_UT.h

// Solves
// begin FLA_Lyap.h


// begin FLA_Lyap_n.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Lyap_n_unb_var1( FLA_Obj isgn, FLA_Obj A, FLA_Obj C );
FLA_Error FLA_Lyap_n_unb_var2( FLA_Obj isgn, FLA_Obj A, FLA_Obj C );
FLA_Error FLA_Lyap_n_unb_var3( FLA_Obj isgn, FLA_Obj A, FLA_Obj C );
FLA_Error FLA_Lyap_n_unb_var4( FLA_Obj isgn, FLA_Obj A, FLA_Obj C );

FLA_Error FLA_Lyap_n_blk_var1( FLA_Obj isgn, FLA_Obj A, FLA_Obj C, FLA_Obj scale, fla_lyap_t* cntl );
FLA_Error FLA_Lyap_n_blk_var2( FLA_Obj isgn, FLA_Obj A, FLA_Obj C, FLA_Obj scale, fla_lyap_t* cntl );
FLA_Error FLA_Lyap_n_blk_var3( FLA_Obj isgn, FLA_Obj A, FLA_Obj C, FLA_Obj scale, fla_lyap_t* cntl );
FLA_Error FLA_Lyap_n_blk_var4( FLA_Obj isgn, FLA_Obj A, FLA_Obj C, FLA_Obj scale, fla_lyap_t* cntl );

FLA_Error FLA_Lyap_n_opt_var1( FLA_Obj isgn, FLA_Obj A, FLA_Obj C );
FLA_Error FLA_Lyap_n_ops_var1( integer m_AC,
                               float* buff_sgn,
                               float* buff_A, integer rs_A, integer cs_A, 
                               float* buff_W, integer rs_W, integer cs_W, 
                               float* buff_C, integer rs_C, integer cs_C );
FLA_Error FLA_Lyap_n_opd_var1( integer m_AC,
                               double* buff_sgn,
                               double* buff_A, integer rs_A, integer cs_A, 
                               double* buff_W, integer rs_W, integer cs_W, 
                               double* buff_C, integer rs_C, integer cs_C );
FLA_Error FLA_Lyap_n_opc_var1( integer m_AC,
                               scomplex* buff_sgn,
                               scomplex* buff_A, integer rs_A, integer cs_A, 
                               scomplex* buff_W, integer rs_W, integer cs_W, 
                               scomplex* buff_C, integer rs_C, integer cs_C );
FLA_Error FLA_Lyap_n_opz_var1( integer m_AC,
                               dcomplex* buff_sgn,
                               dcomplex* buff_A, integer rs_A, integer cs_A, 
                               dcomplex* buff_W, integer rs_W, integer cs_W, 
                               dcomplex* buff_C, integer rs_C, integer cs_C );

FLA_Error FLA_Lyap_n_opt_var2( FLA_Obj isgn, FLA_Obj A, FLA_Obj C );
FLA_Error FLA_Lyap_n_ops_var2( integer m_AC,
                               float* buff_sgn,
                               float* buff_A, integer rs_A, integer cs_A, 
                               float* buff_W, integer rs_W, integer cs_W, 
                               float* buff_C, integer rs_C, integer cs_C );
FLA_Error FLA_Lyap_n_opd_var2( integer m_AC,
                               double* buff_sgn,
                               double* buff_A, integer rs_A, integer cs_A, 
                               double* buff_W, integer rs_W, integer cs_W, 
                               double* buff_C, integer rs_C, integer cs_C );
FLA_Error FLA_Lyap_n_opc_var2( integer m_AC,
                               scomplex* buff_sgn,
                               scomplex* buff_A, integer rs_A, integer cs_A, 
                               scomplex* buff_W, integer rs_W, integer cs_W, 
                               scomplex* buff_C, integer rs_C, integer cs_C );
FLA_Error FLA_Lyap_n_opz_var2( integer m_AC,
                               dcomplex* buff_sgn,
                               dcomplex* buff_A, integer rs_A, integer cs_A, 
                               dcomplex* buff_W, integer rs_W, integer cs_W, 
                               dcomplex* buff_C, integer rs_C, integer cs_C );

FLA_Error FLA_Lyap_n_opt_var3( FLA_Obj isgn, FLA_Obj A, FLA_Obj C );
FLA_Error FLA_Lyap_n_ops_var3( integer m_AC,
                               float* buff_sgn,
                               float* buff_A, integer rs_A, integer cs_A, 
                               float* buff_W, integer rs_W, integer cs_W, 
                               float* buff_C, integer rs_C, integer cs_C );
FLA_Error FLA_Lyap_n_opd_var3( integer m_AC,
                               double* buff_sgn,
                               double* buff_A, integer rs_A, integer cs_A, 
                               double* buff_W, integer rs_W, integer cs_W, 
                               double* buff_C, integer rs_C, integer cs_C );
FLA_Error FLA_Lyap_n_opc_var3( integer m_AC,
                               scomplex* buff_sgn,
                               scomplex* buff_A, integer rs_A, integer cs_A, 
                               scomplex* buff_W, integer rs_W, integer cs_W, 
                               scomplex* buff_C, integer rs_C, integer cs_C );
FLA_Error FLA_Lyap_n_opz_var3( integer m_AC,
                               dcomplex* buff_sgn,
                               dcomplex* buff_A, integer rs_A, integer cs_A, 
                               dcomplex* buff_W, integer rs_W, integer cs_W, 
                               dcomplex* buff_C, integer rs_C, integer cs_C );

FLA_Error FLA_Lyap_n_opt_var4( FLA_Obj isgn, FLA_Obj A, FLA_Obj C );
FLA_Error FLA_Lyap_n_ops_var4( integer m_AC,
                               float* buff_sgn,
                               float* buff_A, integer rs_A, integer cs_A, 
                               float* buff_W, integer rs_W, integer cs_W, 
                               float* buff_C, integer rs_C, integer cs_C );
FLA_Error FLA_Lyap_n_opd_var4( integer m_AC,
                               double* buff_sgn,
                               double* buff_A, integer rs_A, integer cs_A, 
                               double* buff_W, integer rs_W, integer cs_W, 
                               double* buff_C, integer rs_C, integer cs_C );
FLA_Error FLA_Lyap_n_opc_var4( integer m_AC,
                               scomplex* buff_sgn,
                               scomplex* buff_A, integer rs_A, integer cs_A, 
                               scomplex* buff_W, integer rs_W, integer cs_W, 
                               scomplex* buff_C, integer rs_C, integer cs_C );
FLA_Error FLA_Lyap_n_opz_var4( integer m_AC,
                               dcomplex* buff_sgn,
                               dcomplex* buff_A, integer rs_A, integer cs_A, 
                               dcomplex* buff_W, integer rs_W, integer cs_W, 
                               dcomplex* buff_C, integer rs_C, integer cs_C );
// end FLA_Lyap_n.h
// begin FLA_Lyap_h.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Lyap_h_unb_var1( FLA_Obj isgn, FLA_Obj A, FLA_Obj C );
FLA_Error FLA_Lyap_h_unb_var2( FLA_Obj isgn, FLA_Obj A, FLA_Obj C );
FLA_Error FLA_Lyap_h_unb_var3( FLA_Obj isgn, FLA_Obj A, FLA_Obj C );
FLA_Error FLA_Lyap_h_unb_var4( FLA_Obj isgn, FLA_Obj A, FLA_Obj C );

FLA_Error FLA_Lyap_h_blk_var1( FLA_Obj isgn, FLA_Obj A, FLA_Obj C, FLA_Obj scale, fla_lyap_t* cntl );
FLA_Error FLA_Lyap_h_blk_var2( FLA_Obj isgn, FLA_Obj A, FLA_Obj C, FLA_Obj scale, fla_lyap_t* cntl );
FLA_Error FLA_Lyap_h_blk_var3( FLA_Obj isgn, FLA_Obj A, FLA_Obj C, FLA_Obj scale, fla_lyap_t* cntl );
FLA_Error FLA_Lyap_h_blk_var4( FLA_Obj isgn, FLA_Obj A, FLA_Obj C, FLA_Obj scale, fla_lyap_t* cntl );

FLA_Error FLA_Lyap_h_opt_var1( FLA_Obj isgn, FLA_Obj A, FLA_Obj C );
FLA_Error FLA_Lyap_h_ops_var1( integer m_AC,
                               float* buff_sgn,
                               float* buff_A, integer rs_A, integer cs_A, 
                               float* buff_W, integer rs_W, integer cs_W, 
                               float* buff_C, integer rs_C, integer cs_C );
FLA_Error FLA_Lyap_h_opd_var1( integer m_AC,
                               double* buff_sgn,
                               double* buff_A, integer rs_A, integer cs_A, 
                               double* buff_W, integer rs_W, integer cs_W, 
                               double* buff_C, integer rs_C, integer cs_C );
FLA_Error FLA_Lyap_h_opc_var1( integer m_AC,
                               scomplex* buff_sgn,
                               scomplex* buff_A, integer rs_A, integer cs_A, 
                               scomplex* buff_W, integer rs_W, integer cs_W, 
                               scomplex* buff_C, integer rs_C, integer cs_C );
FLA_Error FLA_Lyap_h_opz_var1( integer m_AC,
                               dcomplex* buff_sgn,
                               dcomplex* buff_A, integer rs_A, integer cs_A, 
                               dcomplex* buff_W, integer rs_W, integer cs_W, 
                               dcomplex* buff_C, integer rs_C, integer cs_C );

FLA_Error FLA_Lyap_h_opt_var2( FLA_Obj isgn, FLA_Obj A, FLA_Obj C );
FLA_Error FLA_Lyap_h_ops_var2( integer m_AC,
                               float* buff_sgn,
                               float* buff_A, integer rs_A, integer cs_A, 
                               float* buff_W, integer rs_W, integer cs_W, 
                               float* buff_C, integer rs_C, integer cs_C );
FLA_Error FLA_Lyap_h_opd_var2( integer m_AC,
                               double* buff_sgn,
                               double* buff_A, integer rs_A, integer cs_A, 
                               double* buff_W, integer rs_W, integer cs_W, 
                               double* buff_C, integer rs_C, integer cs_C );
FLA_Error FLA_Lyap_h_opc_var2( integer m_AC,
                               scomplex* buff_sgn,
                               scomplex* buff_A, integer rs_A, integer cs_A, 
                               scomplex* buff_W, integer rs_W, integer cs_W, 
                               scomplex* buff_C, integer rs_C, integer cs_C );
FLA_Error FLA_Lyap_h_opz_var2( integer m_AC,
                               dcomplex* buff_sgn,
                               dcomplex* buff_A, integer rs_A, integer cs_A, 
                               dcomplex* buff_W, integer rs_W, integer cs_W, 
                               dcomplex* buff_C, integer rs_C, integer cs_C );

FLA_Error FLA_Lyap_h_opt_var3( FLA_Obj isgn, FLA_Obj A, FLA_Obj C );
FLA_Error FLA_Lyap_h_ops_var3( integer m_AC,
                               float* buff_sgn,
                               float* buff_A, integer rs_A, integer cs_A, 
                               float* buff_W, integer rs_W, integer cs_W, 
                               float* buff_C, integer rs_C, integer cs_C );
FLA_Error FLA_Lyap_h_opd_var3( integer m_AC,
                               double* buff_sgn,
                               double* buff_A, integer rs_A, integer cs_A, 
                               double* buff_W, integer rs_W, integer cs_W, 
                               double* buff_C, integer rs_C, integer cs_C );
FLA_Error FLA_Lyap_h_opc_var3( integer m_AC,
                               scomplex* buff_sgn,
                               scomplex* buff_A, integer rs_A, integer cs_A, 
                               scomplex* buff_W, integer rs_W, integer cs_W, 
                               scomplex* buff_C, integer rs_C, integer cs_C );
FLA_Error FLA_Lyap_h_opz_var3( integer m_AC,
                               dcomplex* buff_sgn,
                               dcomplex* buff_A, integer rs_A, integer cs_A, 
                               dcomplex* buff_W, integer rs_W, integer cs_W, 
                               dcomplex* buff_C, integer rs_C, integer cs_C );

FLA_Error FLA_Lyap_h_opt_var4( FLA_Obj isgn, FLA_Obj A, FLA_Obj C );
FLA_Error FLA_Lyap_h_ops_var4( integer m_AC,
                               float* buff_sgn,
                               float* buff_A, integer rs_A, integer cs_A, 
                               float* buff_W, integer rs_W, integer cs_W, 
                               float* buff_C, integer rs_C, integer cs_C );
FLA_Error FLA_Lyap_h_opd_var4( integer m_AC,
                               double* buff_sgn,
                               double* buff_A, integer rs_A, integer cs_A, 
                               double* buff_W, integer rs_W, integer cs_W, 
                               double* buff_C, integer rs_C, integer cs_C );
FLA_Error FLA_Lyap_h_opc_var4( integer m_AC,
                               scomplex* buff_sgn,
                               scomplex* buff_A, integer rs_A, integer cs_A, 
                               scomplex* buff_W, integer rs_W, integer cs_W, 
                               scomplex* buff_C, integer rs_C, integer cs_C );
FLA_Error FLA_Lyap_h_opz_var4( integer m_AC,
                               dcomplex* buff_sgn,
                               dcomplex* buff_A, integer rs_A, integer cs_A, 
                               dcomplex* buff_W, integer rs_W, integer cs_W, 
                               dcomplex* buff_C, integer rs_C, integer cs_C );
// end FLA_Lyap_h.h

FLA_Error FLASH_Lyap( FLA_Trans trans, FLA_Obj isgn, FLA_Obj A, FLA_Obj C, FLA_Obj scale );

FLA_Error FLA_Lyap( FLA_Trans trans, FLA_Obj isgn, FLA_Obj A, FLA_Obj C, FLA_Obj scale );

FLA_Error FLA_Lyap_internal( FLA_Trans trans, FLA_Obj isgn, FLA_Obj A, FLA_Obj C, FLA_Obj scale, fla_lyap_t* cntl );
FLA_Error FLA_Lyap_n( FLA_Obj isgn, FLA_Obj A, FLA_Obj C, FLA_Obj scale, fla_lyap_t* cntl );
FLA_Error FLA_Lyap_h( FLA_Obj isgn, FLA_Obj A, FLA_Obj C, FLA_Obj scale, fla_lyap_t* cntl );

// end FLA_Lyap.h
// begin FLA_Sylv.h


// begin FLA_Sylv_nn.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Sylv_nn_blk_var1( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_nn_blk_var2( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_nn_blk_var3( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_nn_blk_var4( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_nn_blk_var5( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_nn_blk_var6( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_nn_blk_var7( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_nn_blk_var8( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_nn_blk_var9( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_nn_blk_var10( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_nn_blk_var11( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_nn_blk_var12( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_nn_blk_var13( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_nn_blk_var14( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_nn_blk_var15( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_nn_blk_var16( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_nn_blk_var17( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_nn_blk_var18( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );

FLA_Error FLA_Sylv_nn_opt_var1( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_nn_opt_var2( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_nn_opt_var3( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_nn_opt_var4( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_nn_opt_var5( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_nn_opt_var6( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_nn_opt_var7( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_nn_opt_var8( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_nn_opt_var9( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_nn_opt_var10( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_nn_opt_var11( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_nn_opt_var12( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_nn_opt_var13( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_nn_opt_var14( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_nn_opt_var15( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_nn_opt_var16( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_nn_opt_var17( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_nn_opt_var18( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );

FLA_Error FLA_Sylv_nn_ops_var1( float sgn,
                                integer m_C,
                                integer n_C,
                                float* buff_A, integer rs_A, integer cs_A,
                                float* buff_B, integer rs_B, integer cs_B,
                                float* buff_C, integer rs_C, integer cs_C,
                                float* buff_scale,
                                integer* info );
FLA_Error FLA_Sylv_nn_opd_var1( double sgn,
                                integer m_C,
                                integer n_C,
                                double* buff_A, integer rs_A, integer cs_A,
                                double* buff_B, integer rs_B, integer cs_B,
                                double* buff_C, integer rs_C, integer cs_C,
                                double* buff_scale,
                                integer* info );
FLA_Error FLA_Sylv_nn_opc_var1( float sgn,
                                integer m_C,
                                integer n_C,
                                scomplex* buff_A, integer rs_A, integer cs_A,
                                scomplex* buff_B, integer rs_B, integer cs_B,
                                scomplex* buff_C, integer rs_C, integer cs_C,
                                scomplex* buff_scale,
                                integer* info );
FLA_Error FLA_Sylv_nn_opz_var1( double sgn,
                                integer m_C,
                                integer n_C,
                                dcomplex* buff_A, integer rs_A, integer cs_A,
                                dcomplex* buff_B, integer rs_B, integer cs_B,
                                dcomplex* buff_C, integer rs_C, integer cs_C,
                                dcomplex* buff_scale,
                                integer* info );
// end FLA_Sylv_nn.h
// begin FLA_Sylv_nh.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Sylv_nh_blk_var1( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_nh_blk_var2( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_nh_blk_var3( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_nh_blk_var4( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_nh_blk_var5( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_nh_blk_var6( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_nh_blk_var7( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_nh_blk_var8( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_nh_blk_var9( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_nh_blk_var10( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_nh_blk_var11( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_nh_blk_var12( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_nh_blk_var13( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_nh_blk_var14( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_nh_blk_var15( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_nh_blk_var16( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_nh_blk_var17( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_nh_blk_var18( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );

FLA_Error FLA_Sylv_nh_opt_var1( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_nh_opt_var2( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_nh_opt_var3( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_nh_opt_var4( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_nh_opt_var5( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_nh_opt_var6( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_nh_opt_var7( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_nh_opt_var8( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_nh_opt_var9( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_nh_opt_var10( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_nh_opt_var11( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_nh_opt_var12( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_nh_opt_var13( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_nh_opt_var14( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_nh_opt_var15( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_nh_opt_var16( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_nh_opt_var17( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_nh_opt_var18( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );

FLA_Error FLA_Sylv_nh_ops_var1( float sgn,
                                integer m_C,
                                integer n_C,
                                float* buff_A, integer rs_A, integer cs_A,
                                float* buff_B, integer rs_B, integer cs_B,
                                float* buff_C, integer rs_C, integer cs_C,
                                float* buff_scale,
                                integer* info );
FLA_Error FLA_Sylv_nh_opd_var1( double sgn,
                                integer m_C,
                                integer n_C,
                                double* buff_A, integer rs_A, integer cs_A,
                                double* buff_B, integer rs_B, integer cs_B,
                                double* buff_C, integer rs_C, integer cs_C,
                                double* buff_scale,
                                integer* info );
FLA_Error FLA_Sylv_nh_opc_var1( float sgn,
                                integer m_C,
                                integer n_C,
                                scomplex* buff_A, integer rs_A, integer cs_A,
                                scomplex* buff_B, integer rs_B, integer cs_B,
                                scomplex* buff_C, integer rs_C, integer cs_C,
                                scomplex* buff_scale,
                                integer* info );
FLA_Error FLA_Sylv_nh_opz_var1( double sgn,
                                integer m_C,
                                integer n_C,
                                dcomplex* buff_A, integer rs_A, integer cs_A,
                                dcomplex* buff_B, integer rs_B, integer cs_B,
                                dcomplex* buff_C, integer rs_C, integer cs_C,
                                dcomplex* buff_scale,
                                integer* info );
// end FLA_Sylv_nh.h
// begin FLA_Sylv_hn.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Sylv_hn_blk_var1( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_hn_blk_var2( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_hn_blk_var3( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_hn_blk_var4( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_hn_blk_var5( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_hn_blk_var6( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_hn_blk_var7( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_hn_blk_var8( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_hn_blk_var9( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_hn_blk_var10( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_hn_blk_var11( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_hn_blk_var12( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_hn_blk_var13( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_hn_blk_var14( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_hn_blk_var15( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_hn_blk_var16( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_hn_blk_var17( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_hn_blk_var18( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );

FLA_Error FLA_Sylv_hn_opt_var1( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_hn_opt_var2( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_hn_opt_var3( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_hn_opt_var4( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_hn_opt_var5( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_hn_opt_var6( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_hn_opt_var7( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_hn_opt_var8( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_hn_opt_var9( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_hn_opt_var10( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_hn_opt_var11( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_hn_opt_var12( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_hn_opt_var13( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_hn_opt_var14( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_hn_opt_var15( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_hn_opt_var16( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_hn_opt_var17( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_hn_opt_var18( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );

FLA_Error FLA_Sylv_hn_ops_var1( float sgn,
                                integer m_C,
                                integer n_C,
                                float* buff_A, integer rs_A, integer cs_A,
                                float* buff_B, integer rs_B, integer cs_B,
                                float* buff_C, integer rs_C, integer cs_C,
                                float* buff_scale,
                                integer* info );
FLA_Error FLA_Sylv_hn_opd_var1( double sgn,
                                integer m_C,
                                integer n_C,
                                double* buff_A, integer rs_A, integer cs_A,
                                double* buff_B, integer rs_B, integer cs_B,
                                double* buff_C, integer rs_C, integer cs_C,
                                double* buff_scale,
                                integer* info );
FLA_Error FLA_Sylv_hn_opc_var1( float sgn,
                                integer m_C,
                                integer n_C,
                                scomplex* buff_A, integer rs_A, integer cs_A,
                                scomplex* buff_B, integer rs_B, integer cs_B,
                                scomplex* buff_C, integer rs_C, integer cs_C,
                                scomplex* buff_scale,
                                integer* info );
FLA_Error FLA_Sylv_hn_opz_var1( double sgn,
                                integer m_C,
                                integer n_C,
                                dcomplex* buff_A, integer rs_A, integer cs_A,
                                dcomplex* buff_B, integer rs_B, integer cs_B,
                                dcomplex* buff_C, integer rs_C, integer cs_C,
                                dcomplex* buff_scale,
                                integer* info );
// end FLA_Sylv_hn.h
// begin FLA_Sylv_hh.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Sylv_hh_blk_var1( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_hh_blk_var2( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_hh_blk_var3( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_hh_blk_var4( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_hh_blk_var5( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_hh_blk_var6( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_hh_blk_var7( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_hh_blk_var8( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_hh_blk_var9( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_hh_blk_var10( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_hh_blk_var11( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_hh_blk_var12( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_hh_blk_var13( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_hh_blk_var14( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_hh_blk_var15( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_hh_blk_var16( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_hh_blk_var17( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_hh_blk_var18( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );

FLA_Error FLA_Sylv_hh_opt_var1( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_hh_opt_var2( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_hh_opt_var3( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_hh_opt_var4( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_hh_opt_var5( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_hh_opt_var6( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_hh_opt_var7( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_hh_opt_var8( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_hh_opt_var9( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_hh_opt_var10( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_hh_opt_var11( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_hh_opt_var12( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_hh_opt_var13( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_hh_opt_var14( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_hh_opt_var15( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_hh_opt_var16( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_hh_opt_var17( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );
FLA_Error FLA_Sylv_hh_opt_var18( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale );

FLA_Error FLA_Sylv_hh_ops_var1( float sgn,
                                integer m_C,
                                integer n_C,
                                float* buff_A, integer rs_A, integer cs_A,
                                float* buff_B, integer rs_B, integer cs_B,
                                float* buff_C, integer rs_C, integer cs_C,
                                float* buff_scale,
                                integer* info );
FLA_Error FLA_Sylv_hh_opd_var1( double sgn,
                                integer m_C,
                                integer n_C,
                                double* buff_A, integer rs_A, integer cs_A,
                                double* buff_B, integer rs_B, integer cs_B,
                                double* buff_C, integer rs_C, integer cs_C,
                                double* buff_scale,
                                integer* info );
FLA_Error FLA_Sylv_hh_opc_var1( float sgn,
                                integer m_C,
                                integer n_C,
                                scomplex* buff_A, integer rs_A, integer cs_A,
                                scomplex* buff_B, integer rs_B, integer cs_B,
                                scomplex* buff_C, integer rs_C, integer cs_C,
                                scomplex* buff_scale,
                                integer* info );
FLA_Error FLA_Sylv_hh_opz_var1( double sgn,
                                integer m_C,
                                integer n_C,
                                dcomplex* buff_A, integer rs_A, integer cs_A,
                                dcomplex* buff_B, integer rs_B, integer cs_B,
                                dcomplex* buff_C, integer rs_C, integer cs_C,
                                dcomplex* buff_scale,
                                integer* info );
// end FLA_Sylv_hh.h

FLA_Error FLA_Sylv_internal( FLA_Trans transa, FLA_Trans transb, FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_nn( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_nh( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_hn( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );
FLA_Error FLA_Sylv_hh( FLA_Obj isgn, FLA_Obj A, FLA_Obj B, FLA_Obj C, FLA_Obj scale, fla_sylv_t* cntl );

// end FLA_Sylv.h

// Miscellaneous
// begin FLA_Ttmm.h


// begin FLA_Ttmm_l.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Ttmm_l_blk_var1( FLA_Obj A, fla_ttmm_t* cntl );
FLA_Error FLA_Ttmm_l_blk_var2( FLA_Obj A, fla_ttmm_t* cntl );
FLA_Error FLA_Ttmm_l_blk_var3( FLA_Obj A, fla_ttmm_t* cntl );

FLA_Error FLA_Ttmm_l_unb_var1( FLA_Obj A );
FLA_Error FLA_Ttmm_l_unb_var2( FLA_Obj A );
FLA_Error FLA_Ttmm_l_unb_var3( FLA_Obj A );

FLA_Error FLA_Ttmm_l_opt_var1( FLA_Obj A );
FLA_Error FLA_Ttmm_l_ops_var1( integer mn_A,
                               float*    A, integer rs_A, integer cs_A );
FLA_Error FLA_Ttmm_l_opd_var1( integer mn_A,
                               double*   A, integer rs_A, integer cs_A );
FLA_Error FLA_Ttmm_l_opc_var1( integer mn_A,
                               scomplex* A, integer rs_A, integer cs_A );
FLA_Error FLA_Ttmm_l_opz_var1( integer mn_A,
                               dcomplex* A, integer rs_A, integer cs_A );

FLA_Error FLA_Ttmm_l_opt_var2( FLA_Obj A );
FLA_Error FLA_Ttmm_l_ops_var2( integer mn_A,
                               float*    A, integer rs_A, integer cs_A );
FLA_Error FLA_Ttmm_l_opd_var2( integer mn_A,
                               double*   A, integer rs_A, integer cs_A );
FLA_Error FLA_Ttmm_l_opc_var2( integer mn_A,
                               scomplex* A, integer rs_A, integer cs_A );
FLA_Error FLA_Ttmm_l_opz_var2( integer mn_A,
                               dcomplex* A, integer rs_A, integer cs_A );

FLA_Error FLA_Ttmm_l_opt_var3( FLA_Obj A );
FLA_Error FLA_Ttmm_l_ops_var3( integer mn_A,
                               float*    A, integer rs_A, integer cs_A );
FLA_Error FLA_Ttmm_l_opd_var3( integer mn_A,
                               double*   A, integer rs_A, integer cs_A );
FLA_Error FLA_Ttmm_l_opc_var3( integer mn_A,
                               scomplex* A, integer rs_A, integer cs_A );
FLA_Error FLA_Ttmm_l_opz_var3( integer mn_A,
                               dcomplex* A, integer rs_A, integer cs_A );

// end FLA_Ttmm_l.h
// begin FLA_Ttmm_u.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Ttmm_u_blk_var1( FLA_Obj A, fla_ttmm_t* cntl );
FLA_Error FLA_Ttmm_u_blk_var2( FLA_Obj A, fla_ttmm_t* cntl );
FLA_Error FLA_Ttmm_u_blk_var3( FLA_Obj A, fla_ttmm_t* cntl );

FLA_Error FLA_Ttmm_u_unb_var1( FLA_Obj A );
FLA_Error FLA_Ttmm_u_unb_var2( FLA_Obj A );
FLA_Error FLA_Ttmm_u_unb_var3( FLA_Obj A );

FLA_Error FLA_Ttmm_u_opt_var1( FLA_Obj A );
FLA_Error FLA_Ttmm_u_ops_var1( integer mn_A,
                               float*    A, integer rs_A, integer cs_A );
FLA_Error FLA_Ttmm_u_opd_var1( integer mn_A,
                               double*   A, integer rs_A, integer cs_A );
FLA_Error FLA_Ttmm_u_opc_var1( integer mn_A,
                               scomplex* A, integer rs_A, integer cs_A );
FLA_Error FLA_Ttmm_u_opz_var1( integer mn_A,
                               dcomplex* A, integer rs_A, integer cs_A );

FLA_Error FLA_Ttmm_u_opt_var2( FLA_Obj A );
FLA_Error FLA_Ttmm_u_ops_var2( integer mn_A,
                               float*    A, integer rs_A, integer cs_A );
FLA_Error FLA_Ttmm_u_opd_var2( integer mn_A,
                               double*   A, integer rs_A, integer cs_A );
FLA_Error FLA_Ttmm_u_opc_var2( integer mn_A,
                               scomplex* A, integer rs_A, integer cs_A );
FLA_Error FLA_Ttmm_u_opz_var2( integer mn_A,
                               dcomplex* A, integer rs_A, integer cs_A );

FLA_Error FLA_Ttmm_u_opt_var3( FLA_Obj A );
FLA_Error FLA_Ttmm_u_ops_var3( integer mn_A,
                               float*    A, integer rs_A, integer cs_A );
FLA_Error FLA_Ttmm_u_opd_var3( integer mn_A,
                               double*   A, integer rs_A, integer cs_A );
FLA_Error FLA_Ttmm_u_opc_var3( integer mn_A,
                               scomplex* A, integer rs_A, integer cs_A );
FLA_Error FLA_Ttmm_u_opz_var3( integer mn_A,
                               dcomplex* A, integer rs_A, integer cs_A );

// end FLA_Ttmm_u.h

FLA_Error FLA_Ttmm_internal( FLA_Uplo uplo, FLA_Obj A, fla_ttmm_t* cntl );
FLA_Error FLA_Ttmm_l( FLA_Obj A, fla_ttmm_t* cntl );
FLA_Error FLA_Ttmm_u( FLA_Obj A, fla_ttmm_t* cntl );
// end FLA_Ttmm.h
// begin FLA_UDdate_UT.h


// begin FLA_UDdate_UT_vars.h


FLA_Error FLA_UDdate_UT_blk_var1( FLA_Obj R,
                                  FLA_Obj C,
                                  FLA_Obj D, FLA_Obj T, fla_uddateut_t* cntl );
FLA_Error FLA_UDdate_UT_blk_var2( FLA_Obj R,
                                  FLA_Obj C,
                                  FLA_Obj D, FLA_Obj T, fla_uddateut_t* cntl );

FLA_Error FLA_UDdate_UT_unb_var1( FLA_Obj R,
                                  FLA_Obj C,
                                  FLA_Obj D, FLA_Obj T );

FLA_Error FLA_UDdate_UT_opt_var1( FLA_Obj R,
                                  FLA_Obj C,
                                  FLA_Obj D, FLA_Obj T );
FLA_Error FLA_UDdate_UT_ops_var1( integer mn_RT,
                                  integer m_C,
                                  integer m_D,
                                  float* R, integer rs_R, integer cs_R,
                                  float* C, integer rs_C, integer cs_C,
                                  float* D, integer rs_D, integer cs_D,
                                  float* T, integer rs_T, integer cs_T );
FLA_Error FLA_UDdate_UT_opd_var1( integer mn_RT,
                                  integer m_C,
                                  integer m_D,
                                  double* R, integer rs_R, integer cs_R,
                                  double* C, integer rs_C, integer cs_C,
                                  double* D, integer rs_D, integer cs_D,
                                  double* T, integer rs_T, integer cs_T );
FLA_Error FLA_UDdate_UT_opc_var1( integer mn_RT,
                                  integer m_C,
                                  integer m_D,
                                  scomplex* R, integer rs_R, integer cs_R,
                                  scomplex* C, integer rs_C, integer cs_C,
                                  scomplex* D, integer rs_D, integer cs_D,
                                  scomplex* T, integer rs_T, integer cs_T );
FLA_Error FLA_UDdate_UT_opz_var1( integer mn_RT,
                                  integer m_C,
                                  integer m_D,
                                  dcomplex* R, integer rs_R, integer cs_R,
                                  dcomplex* C, integer rs_C, integer cs_C,
                                  dcomplex* D, integer rs_D, integer cs_D,
                                  dcomplex* T, integer rs_T, integer cs_T );

// end FLA_UDdate_UT_vars.h

FLA_Error FLA_UDdate_UT( FLA_Obj R,
                         FLA_Obj C,
                         FLA_Obj D, FLA_Obj T );

FLA_Error FLA_UDdate_UT_internal( FLA_Obj R,
                                  FLA_Obj C,
                                  FLA_Obj D, FLA_Obj T, fla_uddateut_t* cntl );

FLA_Error FLA_UDdate_UT_create_T( FLA_Obj R, FLA_Obj* T );

FLA_Error FLA_UDdate_UT_update_rhs( FLA_Obj T, FLA_Obj bR,
                                    FLA_Obj C, FLA_Obj bC,
                                    FLA_Obj D, FLA_Obj bD );

FLA_Error FLA_UDdate_UT_solve( FLA_Obj R, FLA_Obj bR, FLA_Obj x );
// end FLA_UDdate_UT.h
// begin FLA_UDdate_UT_inc.h


FLA_Error FLASH_UDdate_UT_inc( FLA_Obj R,
                               FLA_Obj C,
                               FLA_Obj D, FLA_Obj T, FLA_Obj W );

FLA_Error FLA_UDdate_UT_inc_blk_var1( FLA_Obj R,
                                      FLA_Obj C,
                                      FLA_Obj D, FLA_Obj T, FLA_Obj W, fla_uddateutinc_t* cntl );

FLA_Error FLASH_UDdate_UT_inc_create_hier_matrices( FLA_Obj R_flat, FLA_Obj C_flat, FLA_Obj D_flat, fla_dim_t depth, fla_dim_t* b_flash, fla_dim_t b_alg, FLA_Obj* R, FLA_Obj* C, FLA_Obj* D, FLA_Obj* T, FLA_Obj* W );
fla_dim_t     FLASH_UDdate_UT_inc_determine_alg_blocksize( FLA_Obj R );

FLA_Error FLASH_UDdate_UT_inc_update_rhs( FLA_Obj T, FLA_Obj bR,
                                          FLA_Obj C, FLA_Obj bC,
                                          FLA_Obj D, FLA_Obj bD );
FLA_Error FLASH_UDdate_UT_inc_solve( FLA_Obj R, FLA_Obj bR, FLA_Obj x );
// end FLA_UDdate_UT_inc.h

// BLAS kernels
// begin fla_lapack_fblas_common.h




#ifdef FLA_ENABLE_AMD_OPT
integer fla_idamax(integer *n, doublereal *dx, integer *incx);
#endif
// end fla_lapack_fblas_common.h
// begin fla_lapack_fblas_kernels.h




#ifdef FLA_ENABLE_AMD_OPT
integer fla_idamax_small(integer *n, doublereal *dx, integer *incx);
#endif

// end fla_lapack_fblas_kernels.h

// Utility
// begin FLA_Accum_T_UT.h


// begin FLA_Accum_T_UT_fc.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Accum_T_UT_fc_unb_var1( FLA_Obj A, FLA_Obj t, FLA_Obj T );
FLA_Error FLA_Accum_T_UT_fc_blk_var2( FLA_Obj A, FLA_Obj t, FLA_Obj T );

FLA_Error FLA_Accum_T_UT_fc_opt_var1( FLA_Obj A, FLA_Obj t, FLA_Obj T );

FLA_Error FLA_Accum_T_UT_fc_ops_var1( integer m_A,
                                      integer n_AT,
                                      float* A, integer rs_A, integer cs_A,
                                      integer m_t, 
                                      float* t, integer inc_t,
                                      float* T, integer rs_T, integer cs_T );
FLA_Error FLA_Accum_T_UT_fc_opd_var1( integer m_A,
                                      integer n_AT,
                                      double* A, integer rs_A, integer cs_A,
                                      integer m_t, 
                                      double* t, integer inc_t,
                                      double* T, integer rs_T, integer cs_T );
FLA_Error FLA_Accum_T_UT_fc_opc_var1( integer m_A,
                                      integer n_AT,
                                      scomplex* A, integer rs_A, integer cs_A,
                                      integer m_t, 
                                      scomplex* t, integer inc_t,
                                      scomplex* T, integer rs_T, integer cs_T );
FLA_Error FLA_Accum_T_UT_fc_opz_var1( integer m_A,
                                      integer n_AT,
                                      dcomplex* A, integer rs_A, integer cs_A,
                                      integer m_t, 
                                      dcomplex* t, integer inc_t,
                                      dcomplex* T, integer rs_T, integer cs_T );
// end FLA_Accum_T_UT_fc.h
// begin FLA_Accum_T_UT_fr.h


// skipped #include "FLAME.h" 

FLA_Error FLA_Accum_T_UT_fr_unb_var1( FLA_Obj A, FLA_Obj t, FLA_Obj T );
FLA_Error FLA_Accum_T_UT_fr_blk_var2( FLA_Obj A, FLA_Obj t, FLA_Obj T );

FLA_Error FLA_Accum_T_UT_fr_opt_var1( FLA_Obj A, FLA_Obj t, FLA_Obj T );

FLA_Error FLA_Accum_T_UT_fr_ops_var1( integer m_A,
                                      integer n_A,
                                      float* A, integer rs_A, integer cs_A,
                                      integer m_t,
                                      float* t, integer inc_t,
                                      float* T, integer rs_T, integer cs_T );
FLA_Error FLA_Accum_T_UT_fr_opd_var1( integer m_A,
                                      integer n_A,
                                      double* A, integer rs_A, integer cs_A,
                                      integer m_t,
                                      double* t, integer inc_t,
                                      double* T, integer rs_T, integer cs_T );
FLA_Error FLA_Accum_T_UT_fr_opc_var1( integer m_A,
                                      integer n_A,
                                      scomplex* A, integer rs_A, integer cs_A,
                                      integer m_t,
                                      scomplex* t, integer inc_t,
                                      scomplex* T, integer rs_T, integer cs_T );
FLA_Error FLA_Accum_T_UT_fr_opz_var1( integer m_A,
                                      integer n_A,
                                      dcomplex* A, integer rs_A, integer cs_A,
                                      integer m_t,
                                      dcomplex* t, integer inc_t,
                                      dcomplex* T, integer rs_T, integer cs_T );
// end FLA_Accum_T_UT_fr.h

FLA_Error FLA_Accum_T_UT_internal( FLA_Direct direct, FLA_Store storev, FLA_Obj A, FLA_Obj tau, FLA_Obj T );
// end FLA_Accum_T_UT.h
// begin FLA_Apply_G.h


// begin FLA_Apply_G_lf.h


FLA_Error FLA_Apply_G_lf_opt_var1( FLA_Obj G, FLA_Obj A );
FLA_Error FLA_Apply_G_lf_blk_var3( FLA_Obj G, FLA_Obj A, fla_dim_t b_alg );
// end FLA_Apply_G_lf.h
// begin FLA_Apply_G_lb.h


FLA_Error FLA_Apply_G_lb_opt_var1( FLA_Obj c, FLA_Obj s, FLA_Obj A );
FLA_Error FLA_Apply_G_lb_ops_var1( integer       m_A,
                                   integer       n_A,
                                   float*    buff_c, integer inc_c,
                                   float*    buff_s, integer inc_s,
                                   float*    buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_lb_opd_var1( integer       m_A,
                                   integer       n_A,
                                   double*   buff_c, integer inc_c,
                                   double*   buff_s, integer inc_s,
                                   double*   buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_lb_opc_var1( integer       m_A,
                                   integer       n_A,
                                   float*    buff_c, integer inc_c,
                                   float*    buff_s, integer inc_s,
                                   scomplex* buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_lb_opz_var1( integer       m_A,
                                   integer       n_A,
                                   double*   buff_c, integer inc_c,
                                   double*   buff_s, integer inc_s,
                                   dcomplex* buff_A, integer rs_A, integer cs_A );

// end FLA_Apply_G_lb.h
// begin FLA_Apply_G_rf.h


// Variant 1

FLA_Error FLA_Apply_G_rf_opt_var1( FLA_Obj G, FLA_Obj A );
FLA_Error FLA_Apply_G_rf_ops_var1( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   float*    buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_opd_var1( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   double*   buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_opc_var1( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   scomplex* buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_opz_var1( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   dcomplex* buff_A, integer rs_A, integer cs_A );

FLA_Error FLA_Apply_G_rf_asm_var1( FLA_Obj G, FLA_Obj A );
FLA_Error FLA_Apply_G_rf_ass_var1( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   float*    buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asd_var1( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   double*   buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asc_var1( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   scomplex* buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asz_var1( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   dcomplex* buff_A, integer rs_A, integer cs_A );

FLA_Error FLA_Apply_G_rf_blk_var1( FLA_Obj G, FLA_Obj A, fla_dim_t b_alg );
FLA_Error FLA_Apply_G_rf_bls_var1( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   float*    buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_bld_var1( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   double*   buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_blc_var1( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   scomplex* buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_blz_var1( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   dcomplex* buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );

// Variant 2

FLA_Error FLA_Apply_G_rf_opt_var2( FLA_Obj G, FLA_Obj A );
FLA_Error FLA_Apply_G_rf_ops_var2( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   float*    buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_opd_var2( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   double*   buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_opc_var2( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   scomplex* buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_opz_var2( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   dcomplex* buff_A, integer rs_A, integer cs_A );

FLA_Error FLA_Apply_G_rf_asm_var2( FLA_Obj G, FLA_Obj A );
FLA_Error FLA_Apply_G_rf_ass_var2( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   float*    buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asd_var2( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   double*   buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asc_var2( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   scomplex* buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asz_var2( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   dcomplex* buff_A, integer rs_A, integer cs_A );

FLA_Error FLA_Apply_G_rf_blk_var2( FLA_Obj G, FLA_Obj A, fla_dim_t b_alg );
FLA_Error FLA_Apply_G_rf_bls_var2( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   float*    buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_bld_var2( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   double*   buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_blc_var2( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   scomplex* buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_blz_var2( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   dcomplex* buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );

// Variant 3

FLA_Error FLA_Apply_G_rf_opt_var3( FLA_Obj G, FLA_Obj A );
FLA_Error FLA_Apply_G_rf_ops_var3( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   float*    buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_opd_var3( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   double*   buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_opc_var3( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   scomplex* buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_opz_var3( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   dcomplex* buff_A, integer rs_A, integer cs_A );

FLA_Error FLA_Apply_G_rf_asm_var3( FLA_Obj G, FLA_Obj A );
FLA_Error FLA_Apply_G_rf_ass_var3( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   float*    buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asd_var3( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   double*   buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asc_var3( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   scomplex* buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asz_var3( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   dcomplex* buff_A, integer rs_A, integer cs_A );

FLA_Error FLA_Apply_G_rf_blk_var3( FLA_Obj G, FLA_Obj A, fla_dim_t b_alg );
FLA_Error FLA_Apply_G_rf_bls_var3( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   float*    buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_bld_var3( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   double*   buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_blc_var3( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   scomplex* buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_blz_var3( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   dcomplex* buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );

// Variant 4

FLA_Error FLA_Apply_G_rf_opt_var4( FLA_Obj G, FLA_Obj A );
FLA_Error FLA_Apply_G_rf_ops_var4( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   float*    buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_opd_var4( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   double*   buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_opc_var4( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   scomplex* buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_opz_var4( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   dcomplex* buff_A, integer rs_A, integer cs_A );

FLA_Error FLA_Apply_G_rf_asm_var4( FLA_Obj G, FLA_Obj A );
FLA_Error FLA_Apply_G_rf_ass_var4( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   float*    buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asd_var4( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   double*   buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asc_var4( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   scomplex* buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asz_var4( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   dcomplex* buff_A, integer rs_A, integer cs_A );

FLA_Error FLA_Apply_G_rf_blk_var4( FLA_Obj G, FLA_Obj A, fla_dim_t b_alg );
FLA_Error FLA_Apply_G_rf_bls_var4( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   float*    buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_bld_var4( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   double*   buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_blc_var4( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   scomplex* buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_blz_var4( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   dcomplex* buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );

// Variant 5

FLA_Error FLA_Apply_G_rf_opt_var5( FLA_Obj G, FLA_Obj A );
FLA_Error FLA_Apply_G_rf_ops_var5( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   float*    buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_opd_var5( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   double*   buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_opc_var5( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   scomplex* buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_opz_var5( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   dcomplex* buff_A, integer rs_A, integer cs_A );

FLA_Error FLA_Apply_G_rf_asm_var5( FLA_Obj G, FLA_Obj A );
FLA_Error FLA_Apply_G_rf_ass_var5( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   float*    buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asd_var5( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   double*   buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asc_var5( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   scomplex* buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asz_var5( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   dcomplex* buff_A, integer rs_A, integer cs_A );

FLA_Error FLA_Apply_G_rf_blk_var5( FLA_Obj G, FLA_Obj A, fla_dim_t b_alg );
FLA_Error FLA_Apply_G_rf_bls_var5( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   float*    buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_bld_var5( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   double*   buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_blc_var5( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   scomplex* buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_blz_var5( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   dcomplex* buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );

// Variant 6

FLA_Error FLA_Apply_G_rf_opt_var6( FLA_Obj G, FLA_Obj A );
FLA_Error FLA_Apply_G_rf_ops_var6( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   float*    buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_opd_var6( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   double*   buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_opc_var6( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   scomplex* buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_opz_var6( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   dcomplex* buff_A, integer rs_A, integer cs_A );

FLA_Error FLA_Apply_G_rf_asm_var6( FLA_Obj G, FLA_Obj A );
FLA_Error FLA_Apply_G_rf_ass_var6( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   float*    buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asd_var6( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   double*   buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asc_var6( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   scomplex* buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asz_var6( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   dcomplex* buff_A, integer rs_A, integer cs_A );

FLA_Error FLA_Apply_G_rf_blk_var6( FLA_Obj G, FLA_Obj A, fla_dim_t b_alg );
FLA_Error FLA_Apply_G_rf_bls_var6( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   float*    buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_bld_var6( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   double*   buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_blc_var6( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   scomplex* buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_blz_var6( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   dcomplex* buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );

// Variant 7

FLA_Error FLA_Apply_G_rf_opt_var7( FLA_Obj G, FLA_Obj A );
FLA_Error FLA_Apply_G_rf_ops_var7( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   float*    buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_opd_var7( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   double*   buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_opc_var7( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   scomplex* buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_opz_var7( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   dcomplex* buff_A, integer rs_A, integer cs_A );

FLA_Error FLA_Apply_G_rf_asm_var7( FLA_Obj G, FLA_Obj A );
FLA_Error FLA_Apply_G_rf_ass_var7( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   float*    buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asd_var7( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   double*   buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asc_var7( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   scomplex* buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asz_var7( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   dcomplex* buff_A, integer rs_A, integer cs_A );

FLA_Error FLA_Apply_G_rf_blk_var7( FLA_Obj G, FLA_Obj A, fla_dim_t b_alg );
FLA_Error FLA_Apply_G_rf_bls_var7( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   float*    buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_bld_var7( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   double*   buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_blc_var7( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   scomplex* buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_blz_var7( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   dcomplex* buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );

// Variant 8

FLA_Error FLA_Apply_G_rf_opt_var8( FLA_Obj G, FLA_Obj A );
FLA_Error FLA_Apply_G_rf_ops_var8( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   float*    buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_opd_var8( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   double*   buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_opc_var8( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   scomplex* buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_opz_var8( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   dcomplex* buff_A, integer rs_A, integer cs_A );

FLA_Error FLA_Apply_G_rf_asm_var8( FLA_Obj G, FLA_Obj A );
FLA_Error FLA_Apply_G_rf_ass_var8( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   float*    buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asd_var8( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   double*   buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asc_var8( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   scomplex* buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asz_var8( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   dcomplex* buff_A, integer rs_A, integer cs_A );

FLA_Error FLA_Apply_G_rf_blk_var8( FLA_Obj G, FLA_Obj A, fla_dim_t b_alg );
FLA_Error FLA_Apply_G_rf_bls_var8( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   float*    buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_bld_var8( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   double*   buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_blc_var8( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   scomplex* buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_blz_var8( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   dcomplex* buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );

// Variant 9

FLA_Error FLA_Apply_G_rf_opt_var9( FLA_Obj G, FLA_Obj A );
FLA_Error FLA_Apply_G_rf_ops_var9( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   float*    buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_opd_var9( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   double*   buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_opc_var9( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   scomplex* buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_opz_var9( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   dcomplex* buff_A, integer rs_A, integer cs_A );

FLA_Error FLA_Apply_G_rf_asm_var9( FLA_Obj G, FLA_Obj A );
FLA_Error FLA_Apply_G_rf_ass_var9( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   float*    buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asd_var9( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   double*   buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asc_var9( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   scomplex* buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asz_var9( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   dcomplex* buff_A, integer rs_A, integer cs_A );

FLA_Error FLA_Apply_G_rf_blk_var9( FLA_Obj G, FLA_Obj A, fla_dim_t b_alg );
FLA_Error FLA_Apply_G_rf_bls_var9( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   float*    buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_bld_var9( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   double*   buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_blc_var9( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   scomplex* buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_blz_var9( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   dcomplex* buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );







// Variant 3b

FLA_Error FLA_Apply_G_rf_asm_var3b( FLA_Obj G, FLA_Obj A );
FLA_Error FLA_Apply_G_rf_ass_var3b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   integer       iTL,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   float*    buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asd_var3b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   integer       iTL,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   double*   buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asc_var3b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   integer       iTL,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   scomplex* buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asz_var3b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   integer       iTL,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   dcomplex* buff_A, integer rs_A, integer cs_A );

FLA_Error FLA_Apply_G_rf_blk_var3b( FLA_Obj G, FLA_Obj A, fla_dim_t b_alg );
FLA_Error FLA_Apply_G_rf_bls_var3b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   float*    buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_bld_var3b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   double*   buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_blc_var3b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   scomplex* buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_blz_var3b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   dcomplex* buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );


// Variant 5b

FLA_Error FLA_Apply_G_rf_asm_var5b( FLA_Obj G, FLA_Obj A );
FLA_Error FLA_Apply_G_rf_ass_var5b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   integer       iTL,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   float*    buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asd_var5b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   integer       iTL,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   double*   buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asc_var5b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   integer       iTL,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   scomplex* buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asz_var5b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   integer       iTL,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   dcomplex* buff_A, integer rs_A, integer cs_A );

FLA_Error FLA_Apply_G_rf_blk_var5b( FLA_Obj G, FLA_Obj A, fla_dim_t b_alg );
FLA_Error FLA_Apply_G_rf_bls_var5b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   float*    buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_bld_var5b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   double*   buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_blc_var5b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   scomplex* buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_blz_var5b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   dcomplex* buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );


// Variant 6b

FLA_Error FLA_Apply_G_rf_asm_var6b( FLA_Obj G, FLA_Obj A );
FLA_Error FLA_Apply_G_rf_ass_var6b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   integer       iTL,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   float*    buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asd_var6b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   integer       iTL,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   double*   buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asc_var6b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   integer       iTL,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   scomplex* buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asz_var6b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   integer       iTL,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   dcomplex* buff_A, integer rs_A, integer cs_A );

FLA_Error FLA_Apply_G_rf_blk_var6b( FLA_Obj G, FLA_Obj A, fla_dim_t b_alg );
FLA_Error FLA_Apply_G_rf_bls_var6b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   float*    buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_bld_var6b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   double*   buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_blc_var6b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   scomplex* buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_blz_var6b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   dcomplex* buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );


// Variant 8b

FLA_Error FLA_Apply_G_rf_asm_var8b( FLA_Obj G, FLA_Obj A );
FLA_Error FLA_Apply_G_rf_ass_var8b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   integer       iTL,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   float*    buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asd_var8b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   integer       iTL,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   double*   buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asc_var8b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   integer       iTL,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   scomplex* buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asz_var8b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   integer       iTL,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   dcomplex* buff_A, integer rs_A, integer cs_A );

FLA_Error FLA_Apply_G_rf_blk_var8b( FLA_Obj G, FLA_Obj A, fla_dim_t b_alg );
FLA_Error FLA_Apply_G_rf_bls_var8b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   float*    buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_bld_var8b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   double*   buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_blc_var8b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   scomplex* buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_blz_var8b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   dcomplex* buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );

FLA_Error FLA_Apply_G_rf_bhs_var3( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   float*    buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_bhd_var3( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   double*   buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_bhc_var3( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   scomplex* buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_bhz_var3( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   FLA_Obj*  buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );


// Variant 9b

FLA_Error FLA_Apply_G_rf_asm_var9b( FLA_Obj G, FLA_Obj A );
FLA_Error FLA_Apply_G_rf_ass_var9b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   integer       iTL,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   float*    buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asd_var9b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   integer       iTL,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   double*   buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asc_var9b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   integer       iTL,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   scomplex* buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rf_asz_var9b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   integer       iTL,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   dcomplex* buff_A, integer rs_A, integer cs_A );

FLA_Error FLA_Apply_G_rf_blk_var9b( FLA_Obj G, FLA_Obj A, fla_dim_t b_alg );
FLA_Error FLA_Apply_G_rf_bls_var9b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   float*    buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_bld_var9b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   double*   buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_blc_var9b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   scomplex* buff_G, integer rs_G, integer cs_G,
                                   scomplex* buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );
FLA_Error FLA_Apply_G_rf_blz_var9b( integer       k_G,
                                   integer       m_A,
                                   integer       n_A,
                                   integer       i_k,
                                   dcomplex* buff_G, integer rs_G, integer cs_G,
                                   dcomplex* buff_A, integer rs_A, integer cs_A,
                                   integer       b_alg );


// end FLA_Apply_G_rf.h
// begin FLA_Apply_G_rb.h


FLA_Error FLA_Apply_G_rb_opt_var1( FLA_Obj c, FLA_Obj s, FLA_Obj A );
FLA_Error FLA_Apply_G_rb_ops_var1( integer       m_A,
                                   integer       n_A,
                                   float*    buff_c, integer inc_c,
                                   float*    buff_s, integer inc_s,
                                   float*    buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rb_opd_var1( integer       m_A,
                                   integer       n_A,
                                   double*   buff_c, integer inc_c,
                                   double*   buff_s, integer inc_s,
                                   double*   buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rb_opc_var1( integer       m_A,
                                   integer       n_A,
                                   float*    buff_c, integer inc_c,
                                   float*    buff_s, integer inc_s,
                                   scomplex* buff_A, integer rs_A, integer cs_A );
FLA_Error FLA_Apply_G_rb_opz_var1( integer       m_A,
                                   integer       n_A,
                                   double*   buff_c, integer inc_c,
                                   double*   buff_s, integer inc_s,
                                   dcomplex* buff_A, integer rs_A, integer cs_A );

// end FLA_Apply_G_rb.h

FLA_Error FLA_Apply_G( FLA_Side side, FLA_Direct direct, FLA_Obj G, FLA_Obj A );
FLA_Error FLA_Apply_G_internal( FLA_Side side, FLA_Direct direct, FLA_Obj G, FLA_Obj A );

// begin FLA_Givens2.h


FLA_Error FLA_Givens2( FLA_Obj chi_1, FLA_Obj chi_2, FLA_Obj gamma, FLA_Obj sigma, FLA_Obj chi_1_new );
FLA_Error FLA_Givens2_ops( float*  chi_1,
                           float*  chi_2,
                           float*  gamma,
                           float*  sigma,
                           float*  chi_1_new );
FLA_Error FLA_Givens2_opd( double* chi_1,
                           double* chi_2,
                           double* gamma,
                           double* sigma,
                           double* chi_1_new );
#define MAC_Givens2_ops( chi_1, chi_2, gamma, sigma, chi_1_new ) \
{ \
	float  chi_1_orig = *(chi_1); \
	float  chi_2_orig = *(chi_2); \
	float  g, s; \
	float  norm_x; \
	float  nscl; \
\
  nscl = fabs( chi_1_orig ) + fabs( chi_2_orig ); \
  if ( nscl == 0.0F ) \
  { \
    g = 1.0F; \
    s = 0.0F; \
    norm_x = 0.0F; \
  } \
  else \
  { \
    norm_x = ( float ) nscl * sqrt( (chi_1_orig / nscl) * (chi_1_orig / nscl) + \
                                    (chi_2_orig / nscl) * (chi_2_orig / nscl) ); \
    g = chi_1_orig / norm_x; \
    s = chi_2_orig / norm_x; \
\
    if ( fabs( chi_1_orig ) > fabs( chi_2_orig ) && g < 0.0F) \
    { \
      g      = -g; \
      s      = -s; \
      norm_x = -norm_x; \
    } \
  } \
\
	*(gamma)     = g; \
	*(sigma)     = s; \
	*(chi_1_new) = norm_x; \
\
}

#define MAC_Givens2_opd( chi_1, chi_2, gamma, sigma, chi_1_new ) \
{ \
	double chi_1_orig = *(chi_1); \
	double chi_2_orig = *(chi_2); \
	double g, s; \
	double norm_x; \
	double nscl; \
\
  nscl = fabs( chi_1_orig ) + fabs( chi_2_orig ); \
  if ( nscl == 0.0 ) \
  { \
    g = 1.0; \
    s = 0.0; \
    norm_x = 0.0; \
  } \
  else \
  { \
    norm_x = ( double ) nscl * sqrt( (chi_1_orig / nscl) * (chi_1_orig / nscl) + \
                                     (chi_2_orig / nscl) * (chi_2_orig / nscl) ); \
    g = chi_1_orig / norm_x; \
    s = chi_2_orig / norm_x; \
\
    if ( fabs( chi_1_orig ) > fabs( chi_2_orig ) && g < 0.0 ) \
    { \
      g      = -g; \
      s      = -s; \
      norm_x = -norm_x; \
    } \
  } \
\
	*(gamma)     = g; \
	*(sigma)     = s; \
	*(chi_1_new) = norm_x; \
\
}

#define MAC_Givens2_slartgp slartgp_
#define MAC_Givens2_dlartgp dlartgp_

// end FLA_Givens2.h

// begin FLA_Apply_GTG.h


FLA_Error FLA_Apply_GTG( FLA_Obj gamma, FLA_Obj sigma, FLA_Obj delta1, FLA_Obj epsilon1, FLA_Obj delta2 );
FLA_Error FLA_Apply_GTG_ops( float*  gamma,
                             float*  sigma,
                             float*  delta1,
                             float*  epsilon1,
                             float*  delta2 );
FLA_Error FLA_Apply_GTG_opd( double* gamma,
                             double* sigma,
                             double* delta1,
                             double* epsilon1,
                             double* delta2 );

#define MAC_Apply_GTG_ops( gamma, sigma, delta1, epsilon, delta2 ) \
{ \
	float  g, s; \
	float  d1, e, d2; \
	float  g2, s2, tgse; \
\
	g = *(gamma); \
	s = *(sigma); \
\
	d1 = *(delta1); \
	e  = *(epsilon); \
	d2 = *(delta2); \
\
	g2 = g * g; \
	s2 = s * s; \
	tgse = 2.0 * g * s * e; \
\
	*(delta1)  = g2 * d1 + tgse + s2 * d2; \
	*(delta2)  = s2 * d1 - tgse + g2 * d2; \
	*(epsilon) = g * s * (d2 - d1) + e * (g2 - s2); \
}

#define MAC_Apply_GTG_opd( gamma, sigma, delta1, epsilon, delta2 ) \
{ \
 \
	double g, s; \
	double d1, e, d2; \
	double g2, s2, tgse; \
\
	g = *(gamma); \
	s = *(sigma); \
\
	d1 = *(delta1); \
	e  = *(epsilon); \
	d2 = *(delta2); \
\
	g2 = g * g; \
	s2 = s * s; \
	tgse = 2.0 * g * s * e; \
\
	*(delta1)  = g2 * d1 + tgse + s2 * d2; \
	*(delta2)  = s2 * d1 - tgse + g2 * d2; \
	*(epsilon) = g * s * (d2 - d1) + e * (g2 - s2); \
\
 \
}

// end FLA_Apply_GTG.h

// begin FLA_Apply_GT_2x2.h


#define MAC_Apply_GT_2x2_ops( gamma, sigma, epsilon1, delta2, beta, epsilon2 ) \
{ \
	float g, s; \
	float e1, d2, e2; \
\
	g = *(gamma); \
	s = *(sigma); \
\
	e1 = *(epsilon1); \
	d2 = *(delta2); \
	e2 = *(epsilon2); \
\
	*(epsilon1)  =  g * e1 + s * d2; \
	*(delta2)    = -s * e1 + g * d2; \
\
	*(beta)      = s * e2; \
	*(epsilon2)  = g * e2; \
}

#define MAC_Apply_GT_2x2_opd( gamma, sigma, epsilon1, delta2, beta, epsilon2 ) \
{ \
	double g, s; \
	double e1, d2, e2; \
\
	g = *(gamma); \
	s = *(sigma); \
\
	e1 = *(epsilon1); \
	d2 = *(delta2); \
	e2 = *(epsilon2); \
\
	*(epsilon1)  =  g * e1 + s * d2; \
	*(delta2)    = -s * e1 + g * d2; \
\
	*(beta)      = s * e2; \
	*(epsilon2)  = g * e2; \
}

#define MAC_Apply_GT_2x1_ops( gamma, sigma, epsilon1, delta2 ) \
{ \
	float g, s; \
	float e1, d2; \
\
	g = *(gamma); \
	s = *(sigma); \
\
	e1 = *(epsilon1); \
	d2 = *(delta2); \
\
	*(epsilon1)  =  g * e1 + s * d2; \
	*(delta2)    = -s * e1 + g * d2; \
}

#define MAC_Apply_GT_2x1_opd( gamma, sigma, epsilon1, delta2 ) \
{ \
	double g, s; \
	double e1, d2; \
\
	g = *(gamma); \
	s = *(sigma); \
\
	e1 = *(epsilon1); \
	d2 = *(delta2); \
\
	*(epsilon1)  =  g * e1 + s * d2; \
	*(delta2)    = -s * e1 + g * d2; \
}

// end FLA_Apply_GT_2x2.h
// begin FLA_Apply_G_2x2.h


#define MAC_Apply_G_2x2_ops( gamma, sigma, delta1, beta, epsilon1, delta2 ) \
{ \
	float g, s; \
	float d1, e1, d2; \
\
	g = *(gamma); \
	s = *(sigma); \
\
	d1 = *(delta1); \
	e1 = *(epsilon1); \
	d2 = *(delta2); \
\
	*(delta1)    =  g * d1 + s * e1; \
	*(epsilon1)  = -s * d1 + g * e1; \
\
	*(beta)      = s * d2; \
	*(delta2)    = g * d2; \
}

#define MAC_Apply_G_2x2_opd( gamma, sigma, delta1, beta, epsilon1, delta2 ) \
{ \
	double g, s; \
	double d1, e1, d2; \
\
	g = *(gamma); \
	s = *(sigma); \
\
	d1 = *(delta1); \
	e1 = *(epsilon1); \
	d2 = *(delta2); \
\
	*(delta1)    =  g * d1 + s * e1; \
	*(epsilon1)  = -s * d1 + g * e1; \
\
	*(beta)      = s * d2; \
	*(delta2)    = g * d2; \
}

// end FLA_Apply_G_2x2.h
// begin FLA_Apply_G_1x2.h


#define MAC_Apply_G_1x2_ops( gamma, sigma, beta, epsilon ) \
{ \
	*(beta)    = *(epsilon) * *(sigma); \
	*(epsilon) = *(epsilon) * *(gamma); \
}

#define MAC_Apply_G_1x2_opd( gamma, sigma, beta, epsilon ) \
{ \
	*(beta)    = *(epsilon) * *(sigma); \
	*(epsilon) = *(epsilon) * *(gamma); \
}

// end FLA_Apply_G_1x2.h

// begin FLA_Apply_G_mx2_opt.h


#define MAC_Apply_G_mx2_ops( m_A, \
                             gamma12, \
                             sigma12, \
                             a1, inc_a1, \
                             a2, inc_a2 ) \
{ \
	float             ga     = *gamma12; \
	float             si     = *sigma12; \
	float*  restrict  alpha1 = a1; \
	float*  restrict  alpha2 = a2; \
	float             temp1; \
	float             temp2; \
	integer               i; \
\
	for ( i = 0; i < m_A; ++i ) \
	{ \
		temp1 = *alpha1; \
		temp2 = *alpha2; \
\
		*alpha1 =  ga * temp1 + si * temp2; \
		*alpha2 = -si * temp1 + ga * temp2; \
\
		alpha1 += inc_a1; \
		alpha2 += inc_a2; \
	} \
}

#define MAC_Apply_G_mx2_opc( m_A, \
                             gamma12, \
                             sigma12, \
                             a1, inc_a1, \
                             a2, inc_a2 ) \
{ \
	float              ga12   = *gamma12; \
	float              si12   = *sigma12; \
	scomplex* restrict alpha1 = a1; \
	scomplex* restrict alpha2 = a2; \
	scomplex           temp1; \
	scomplex           temp2; \
	integer                i; \
\
	for ( i = 0; i < m_A; ++i ) \
	{ \
		temp1 = *alpha1; \
		temp2 = *alpha2; \
\
		alpha1->real =  ga12 * temp1.real + si12 * temp2.real; \
		alpha1->imag =  ga12 * temp1.imag + si12 * temp2.imag; \
\
		alpha2->real = -si12 * temp1.real + ga12 * temp2.real; \
		alpha2->imag = -si12 * temp1.imag + ga12 * temp2.imag; \
\
		alpha1 += inc_a1; \
		alpha2 += inc_a2; \
	} \
}

#define MAC_Apply_G_mx2_opd( m_A, \
                             gamma12, \
                             sigma12, \
                             a1, inc_a1, \
                             a2, inc_a2 ) \
{ \
	double            ga     = *gamma12; \
	double            si     = *sigma12; \
	double* restrict  alpha1 = a1; \
	double* restrict  alpha2 = a2; \
	double            temp1; \
	double            temp2; \
	integer               i; \
\
	for ( i = 0; i < m_A; ++i ) \
	{ \
		temp1 = *alpha1; \
		temp2 = *alpha2; \
\
		*alpha1 =  ga * temp1 + si * temp2; \
		*alpha2 = -si * temp1 + ga * temp2; \
\
		alpha1 += inc_a1; \
		alpha2 += inc_a2; \
	} \
}

#define MAC_Apply_G_mx2_opz( m_A, \
                             gamma12, \
                             sigma12, \
                             a1, inc_a1, \
                             a2, inc_a2 ) \
{\
	double             ga12   = *gamma12; \
	double             si12   = *sigma12; \
	dcomplex* restrict alpha1 = a1; \
	dcomplex* restrict alpha2 = a2; \
	dcomplex           temp1; \
	dcomplex           temp2; \
	integer                i; \
\
	for ( i = 0; i < m_A; ++i ) \
	{ \
		temp1 = *alpha1; \
		temp2 = *alpha2; \
\
		alpha1->real =  ga12 * temp1.real + si12 * temp2.real; \
		alpha1->imag =  ga12 * temp1.imag + si12 * temp2.imag; \
\
		alpha2->real = -si12 * temp1.real + ga12 * temp2.real; \
		alpha2->imag = -si12 * temp1.imag + ga12 * temp2.imag; \
\
		alpha1 += inc_a1; \
		alpha2 += inc_a2; \
	} \
}

// end FLA_Apply_G_mx2_opt.h
// begin FLA_Apply_G_mx2_asm.h



#if FLA_VECTOR_INTRINSIC_TYPE == FLA_NO_INTRINSICS

#define MAC_Apply_G_mx2_ass MAC_Apply_G_mx2_ops
#define MAC_Apply_G_mx2_asd MAC_Apply_G_mx2_opd
#define MAC_Apply_G_mx2_asc MAC_Apply_G_mx2_opc
#define MAC_Apply_G_mx2_asz MAC_Apply_G_mx2_opz

#elif FLA_VECTOR_INTRINSIC_TYPE == FLA_SSE_INTRINSICS

#define MAC_Apply_G_mx2_ass( m_A, \
                             gamma12, \
                             sigma12, \
                             a1, inc_a1, \
                             a2, inc_a2 ) \
{\
	integer              n_iter32  = m_A / ( 4 * 8 ); \
	integer              n_left32  = m_A % ( 4 * 8 ); \
	integer              n_iter4   = n_left32 / ( 4 * 1 ); \
	integer              n_left    = n_left32 % ( 4 * 1 ); \
	integer              i; \
\
	const integer        step_a1 = inc_a1 * 4; \
	const integer        step_a2 = inc_a2 * 4; \
\
	float*  restrict alpha1 = a1; \
	float*  restrict alpha2 = a2; \
\
	v4sf_t           a1v, a2v; \
	v4sf_t           g12v, s12v; \
	v4sf_t           t1v; \
\
	g12v.v = _mm_load1_ps( gamma12 ); \
	s12v.v = _mm_load1_ps( sigma12 ); \
\
	for ( i = 0; i < n_iter32; ++i ) \
	{ \
\
		a1v.v = _mm_load_ps( ( float* )alpha1 ); \
		a2v.v = _mm_load_ps( ( float* )alpha2 ); \
\
		t1v.v = a1v.v; \
		a1v.v = t1v.v * g12v.v + a2v.v * s12v.v; \
		a2v.v = a2v.v * g12v.v - t1v.v * s12v.v; \
\
		_mm_store_ps( ( float* )alpha1, a1v.v ); \
		_mm_store_ps( ( float* )alpha2, a2v.v ); \
\
		alpha1 += step_a1; \
		alpha2 += step_a2; \
\
		a1v.v = _mm_load_ps( ( float* )alpha1 ); \
		a2v.v = _mm_load_ps( ( float* )alpha2 ); \
\
		t1v.v = a1v.v; \
		a1v.v = t1v.v * g12v.v + a2v.v * s12v.v; \
		a2v.v = a2v.v * g12v.v - t1v.v * s12v.v; \
\
		_mm_store_ps( ( float* )alpha1, a1v.v ); \
		_mm_store_ps( ( float* )alpha2, a2v.v ); \
\
		alpha1 += step_a1; \
		alpha2 += step_a2; \
\
		a1v.v = _mm_load_ps( ( float* )alpha1 ); \
		a2v.v = _mm_load_ps( ( float* )alpha2 ); \
\
		t1v.v = a1v.v; \
		a1v.v = t1v.v * g12v.v + a2v.v * s12v.v; \
		a2v.v = a2v.v * g12v.v - t1v.v * s12v.v; \
\
		_mm_store_ps( ( float* )alpha1, a1v.v ); \
		_mm_store_ps( ( float* )alpha2, a2v.v ); \
\
		alpha1 += step_a1; \
		alpha2 += step_a2; \
\
		a1v.v = _mm_load_ps( ( float* )alpha1 ); \
		a2v.v = _mm_load_ps( ( float* )alpha2 ); \
\
		t1v.v = a1v.v; \
		a1v.v = t1v.v * g12v.v + a2v.v * s12v.v; \
		a2v.v = a2v.v * g12v.v - t1v.v * s12v.v; \
\
		_mm_store_ps( ( float* )alpha1, a1v.v ); \
		_mm_store_ps( ( float* )alpha2, a2v.v ); \
\
		alpha1 += step_a1; \
		alpha2 += step_a2; \
\
		a1v.v = _mm_load_ps( ( float* )alpha1 ); \
		a2v.v = _mm_load_ps( ( float* )alpha2 ); \
\
		t1v.v = a1v.v; \
		a1v.v = t1v.v * g12v.v + a2v.v * s12v.v; \
		a2v.v = a2v.v * g12v.v - t1v.v * s12v.v; \
\
		_mm_store_ps( ( float* )alpha1, a1v.v ); \
		_mm_store_ps( ( float* )alpha2, a2v.v ); \
\
		alpha1 += step_a1; \
		alpha2 += step_a2; \
\
		a1v.v = _mm_load_ps( ( float* )alpha1 ); \
		a2v.v = _mm_load_ps( ( float* )alpha2 ); \
\
		t1v.v = a1v.v; \
		a1v.v = t1v.v * g12v.v + a2v.v * s12v.v; \
		a2v.v = a2v.v * g12v.v - t1v.v * s12v.v; \
\
		_mm_store_ps( ( float* )alpha1, a1v.v ); \
		_mm_store_ps( ( float* )alpha2, a2v.v ); \
\
		alpha1 += step_a1; \
		alpha2 += step_a2; \
\
		a1v.v = _mm_load_ps( ( float* )alpha1 ); \
		a2v.v = _mm_load_ps( ( float* )alpha2 ); \
\
		t1v.v = a1v.v; \
		a1v.v = t1v.v * g12v.v + a2v.v * s12v.v; \
		a2v.v = a2v.v * g12v.v - t1v.v * s12v.v; \
\
		_mm_store_ps( ( float* )alpha1, a1v.v ); \
		_mm_store_ps( ( float* )alpha2, a2v.v ); \
\
		alpha1 += step_a1; \
		alpha2 += step_a2; \
\
		a1v.v = _mm_load_ps( ( float* )alpha1 ); \
		a2v.v = _mm_load_ps( ( float* )alpha2 ); \
\
		t1v.v = a1v.v; \
		a1v.v = t1v.v * g12v.v + a2v.v * s12v.v; \
		a2v.v = a2v.v * g12v.v - t1v.v * s12v.v; \
\
		_mm_store_ps( ( float* )alpha1, a1v.v ); \
		_mm_store_ps( ( float* )alpha2, a2v.v ); \
\
		alpha1 += step_a1; \
		alpha2 += step_a2; \
	} \
\
	for ( i = 0; i < n_iter4; ++i ) \
	{ \
\
		a1v.v = _mm_load_ps( ( float* )alpha1 ); \
		a2v.v = _mm_load_ps( ( float* )alpha2 ); \
\
		t1v.v = a1v.v; \
		a1v.v = t1v.v * g12v.v + a2v.v * s12v.v; \
		a2v.v = a2v.v * g12v.v - t1v.v * s12v.v; \
\
		_mm_store_ps( ( float* )alpha1, a1v.v ); \
		_mm_store_ps( ( float* )alpha2, a2v.v ); \
\
		alpha1 += step_a1; \
		alpha2 += step_a2; \
	} \
\
	for ( i = 0; i < n_left; ++i ) \
	{ \
		float ga12 = *gamma12; \
		float si12 = *sigma12; \
		float temp1; \
		float temp2; \
\
		temp1 = *alpha1; \
		temp2 = *alpha2; \
\
		*alpha1 = temp1 * ga12 + temp2 * si12; \
		*alpha2 = temp2 * ga12 - temp1 * si12; \
\
		alpha1 += 1; \
		alpha2 += 1; \
	} \
}

#define MAC_Apply_G_mx2_asd( m_A, \
                             gamma12, \
                             sigma12, \
                             a1, inc_a1, \
                             a2, inc_a2 ) \
{\
	integer              n_iter16  = m_A / ( 2 * 8 ); \
	integer              n_left16  = m_A % ( 2 * 8 ); \
	integer              n_iter2   = n_left16 / ( 2 * 1 ); \
	integer              n_left    = n_left16 % ( 2 * 1 ); \
	integer              i; \
\
	const integer        step_a1 = inc_a1 * 2; \
	const integer        step_a2 = inc_a2 * 2; \
\
	double* restrict alpha1 = a1; \
	double* restrict alpha2 = a2; \
\
	v2df_t           a1v, a2v; \
	v2df_t           g12v, s12v; \
	v2df_t           t1v; \
\
	g12v.v = _mm_loaddup_pd( gamma12 ); \
	s12v.v = _mm_loaddup_pd( sigma12 ); \
\
	for ( i = 0; i < n_iter16; ++i ) \
	{ \
\
		a1v.v = _mm_load_pd( ( double* )alpha1 ); \
		a2v.v = _mm_load_pd( ( double* )alpha2 ); \
\
		t1v.v = a1v.v; \
		a1v.v = t1v.v * g12v.v + a2v.v * s12v.v; \
		a2v.v = a2v.v * g12v.v - t1v.v * s12v.v; \
\
		_mm_store_pd( ( double* )alpha1, a1v.v ); \
		_mm_store_pd( ( double* )alpha2, a2v.v ); \
\
		alpha1 += step_a1; \
		alpha2 += step_a2; \
\
		a1v.v = _mm_load_pd( ( double* )alpha1 ); \
		a2v.v = _mm_load_pd( ( double* )alpha2 ); \
\
		t1v.v = a1v.v; \
		a1v.v = t1v.v * g12v.v + a2v.v * s12v.v; \
		a2v.v = a2v.v * g12v.v - t1v.v * s12v.v; \
\
		_mm_store_pd( ( double* )alpha1, a1v.v ); \
		_mm_store_pd( ( double* )alpha2, a2v.v ); \
\
		alpha1 += step_a1; \
		alpha2 += step_a2; \
\
		a1v.v = _mm_load_pd( ( double* )alpha1 ); \
		a2v.v = _mm_load_pd( ( double* )alpha2 ); \
\
		t1v.v = a1v.v; \
		a1v.v = t1v.v * g12v.v + a2v.v * s12v.v; \
		a2v.v = a2v.v * g12v.v - t1v.v * s12v.v; \
\
		_mm_store_pd( ( double* )alpha1, a1v.v ); \
		_mm_store_pd( ( double* )alpha2, a2v.v ); \
\
		alpha1 += step_a1; \
		alpha2 += step_a2; \
\
		a1v.v = _mm_load_pd( ( double* )alpha1 ); \
		a2v.v = _mm_load_pd( ( double* )alpha2 ); \
\
		t1v.v = a1v.v; \
		a1v.v = t1v.v * g12v.v + a2v.v * s12v.v; \
		a2v.v = a2v.v * g12v.v - t1v.v * s12v.v; \
\
		_mm_store_pd( ( double* )alpha1, a1v.v ); \
		_mm_store_pd( ( double* )alpha2, a2v.v ); \
\
		alpha1 += step_a1; \
		alpha2 += step_a2; \
\
		a1v.v = _mm_load_pd( ( double* )alpha1 ); \
		a2v.v = _mm_load_pd( ( double* )alpha2 ); \
\
		t1v.v = a1v.v; \
		a1v.v = t1v.v * g12v.v + a2v.v * s12v.v; \
		a2v.v = a2v.v * g12v.v - t1v.v * s12v.v; \
\
		_mm_store_pd( ( double* )alpha1, a1v.v ); \
		_mm_store_pd( ( double* )alpha2, a2v.v ); \
\
		alpha1 += step_a1; \
		alpha2 += step_a2; \
\
		a1v.v = _mm_load_pd( ( double* )alpha1 ); \
		a2v.v = _mm_load_pd( ( double* )alpha2 ); \
\
		t1v.v = a1v.v; \
		a1v.v = t1v.v * g12v.v + a2v.v * s12v.v; \
		a2v.v = a2v.v * g12v.v - t1v.v * s12v.v; \
\
		_mm_store_pd( ( double* )alpha1, a1v.v ); \
		_mm_store_pd( ( double* )alpha2, a2v.v ); \
\
		alpha1 += step_a1; \
		alpha2 += step_a2; \
\
		a1v.v = _mm_load_pd( ( double* )alpha1 ); \
		a2v.v = _mm_load_pd( ( double* )alpha2 ); \
\
		t1v.v = a1v.v; \
		a1v.v = t1v.v * g12v.v + a2v.v * s12v.v; \
		a2v.v = a2v.v * g12v.v - t1v.v * s12v.v; \
\
		_mm_store_pd( ( double* )alpha1, a1v.v ); \
		_mm_store_pd( ( double* )alpha2, a2v.v ); \
\
		alpha1 += step_a1; \
		alpha2 += step_a2; \
\
		a1v.v = _mm_load_pd( ( double* )alpha1 ); \
		a2v.v = _mm_load_pd( ( double* )alpha2 ); \
\
		t1v.v = a1v.v; \
		a1v.v = t1v.v * g12v.v + a2v.v * s12v.v; \
		a2v.v = a2v.v * g12v.v - t1v.v * s12v.v; \
\
		_mm_store_pd( ( double* )alpha1, a1v.v ); \
		_mm_store_pd( ( double* )alpha2, a2v.v ); \
\
		alpha1 += step_a1; \
		alpha2 += step_a2; \
	} \
\
	for ( i = 0; i < n_iter2; ++i ) \
	{ \
\
		a1v.v = _mm_load_pd( ( double* )alpha1 ); \
		a2v.v = _mm_load_pd( ( double* )alpha2 ); \
\
		t1v.v = a1v.v; \
		a1v.v = t1v.v * g12v.v + a2v.v * s12v.v; \
		a2v.v = a2v.v * g12v.v - t1v.v * s12v.v; \
\
		_mm_store_pd( ( double* )alpha1, a1v.v ); \
		_mm_store_pd( ( double* )alpha2, a2v.v ); \
\
		alpha1 += step_a1; \
		alpha2 += step_a2; \
	} \
\
	if ( n_left == 1 ) \
	{ \
		double ga12 = *gamma12; \
		double si12 = *sigma12; \
		double temp1; \
		double temp2; \
\
		temp1 = *alpha1; \
		temp2 = *alpha2; \
\
		*alpha1 = temp1 * ga12 + temp2 * si12; \
		*alpha2 = temp2 * ga12 - temp1 * si12; \
	} \
}

#define MAC_Apply_G_mx2_asc( m_A, \
                             gamma12, \
                             sigma12, \
                             a1, inc_a1, \
                             a2, inc_a2 ) \
{\
	integer                n_iter16  = m_A / ( 2 * 8 ); \
	integer                n_left16  = m_A % ( 2 * 8 ); \
	integer                n_iter2   = n_left16 / ( 2 * 1 ); \
	integer                n_left    = n_left16 % ( 2 * 1 ); \
	integer                i; \
\
	const integer          step_a1 = inc_a1 * 2; \
	const integer          step_a2 = inc_a2 * 2; \
\
	scomplex* restrict alpha1 = a1; \
	scomplex* restrict alpha2 = a2; \
\
	v4sf_t             a1v, a2v; \
	v4sf_t             g12v, s12v; \
	v4sf_t             t1v; \
\
	g12v.v = _mm_load1_ps( gamma12 ); \
	s12v.v = _mm_load1_ps( sigma12 ); \
\
	for ( i = 0; i < n_iter16; ++i ) \
	{ \
\
		a1v.v = _mm_load_ps( ( float* )alpha1 ); \
		a2v.v = _mm_load_ps( ( float* )alpha2 ); \
\
		t1v.v = a1v.v; \
		a1v.v = t1v.v * g12v.v + a2v.v * s12v.v; \
		a2v.v = a2v.v * g12v.v - t1v.v * s12v.v; \
\
		_mm_store_ps( ( float* )alpha1, a1v.v ); \
		_mm_store_ps( ( float* )alpha2, a2v.v ); \
\
		alpha1 += step_a1; \
		alpha2 += step_a2; \
\
		a1v.v = _mm_load_ps( ( float* )alpha1 ); \
		a2v.v = _mm_load_ps( ( float* )alpha2 ); \
\
		t1v.v = a1v.v; \
		a1v.v = t1v.v * g12v.v + a2v.v * s12v.v; \
		a2v.v = a2v.v * g12v.v - t1v.v * s12v.v; \
\
		_mm_store_ps( ( float* )alpha1, a1v.v ); \
		_mm_store_ps( ( float* )alpha2, a2v.v ); \
\
		alpha1 += step_a1; \
		alpha2 += step_a2; \
\
		a1v.v = _mm_load_ps( 