/*
 * Copyright (C) 2024, Advanced Micro Devices. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holder nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
#ifndef __AU_MACROS_H__
#define __AU_MACROS_H__

#ifdef __cplusplus
#ifndef AUD_EXTERN_C_BEGIN
#define AUD_EXTERN_C_BEGIN                                                     \
    extern "C"                                                                 \
    {
#endif

#define AUD_EXTERN_C_BEGIN1()                                                  \
    extern "C"                                                                 \
    {
#ifndef AUD_EXTERN_C_END
#define AUD_EXTERN_C_END }
#endif
#define AUD_EXTERN_C_END1() }

#ifndef AUD_EXTERN_C
#define AUD_EXTERN_C extern "C"
#endif
#else
#define AUD_EXTERN_C_BEGIN
#define AUD_EXTERN_C_END
#define AUD_EXTERN_C
#endif
#if defined(AU_WARN_DEPRECATION)
#if defined(_MSC_VER)
#define AU_DEPRECATED_API                                                      \
    __declspec(deprecated("Deprecated, consult userguide."))
#else
#define AU_DEPRECATED_API                                                      \
    __attribute__((deprecated("Deprecated, consult userguide.")))
#endif
#if defined(_MSC_VER)
#define AU_DEPRECATED_API_X(msg) __declspec(deprecated(msg))
#else
#define AU_DEPRECATED_API_X(msg) __attribute__((deprecated(msg)))
#endif
#else
#define AU_DEPRECATED_API
#define AU_DEPRECATED_API_X(msg)
#endif

#endif /* __AU_MACROS_H__ */
