/*************************************************************
* This program drives the LEDs using the custom circuit.     *
*************************************************************/

#include "xparameters.h"
#include "mb_interface.h" 
#include "stdio.h"
#include "xutil.h"
#include "stdlib.h"

int main() {
    
  int offset = 0;
  int *addr_ptr; 
  char keyboard;
  int LED_value = 0;
  int status; 
  int reg_value;
  int all_off_value;
  int run_value;
  int linear_value; 

  while(1) {

/*  Print initialization message, and prompt for user input. */
  xil_printf ("*********************************************\r\n");
  xil_printf ("* --> Hyperterm window must be selected <-- *\r\n");
  xil_printf ("*                                           *\r\n");
  xil_printf ("* Enter value and Carriage Return           *\r\n");     
  xil_printf ("* Enter 0 to read status                    *\r\n");
  xil_printf ("* Enter 1 for LEDs off.                     *\r\n");
  xil_printf ("* Enter 2 for LEDs on.                      *\r\n");
  xil_printf ("* Enter 3 for Log scale.                    *\r\n");
  xil_printf ("* Enter 4 for Linear scale.                 *\r\n");
  xil_printf ("* Enter 5 for Constant value.               *\r\n");
  xil_printf ("* Enter 6 to exit program.                  *\r\n"); 
  xil_printf ("*********************************************\r\r\n");

/* Read the keyboard, print the entry.  */  
  keyboard = XUartLite_RecvByte(XPAR_RS232_UART_1_BASEADDR);
  xil_printf ("%c \r\r\n", keyboard);
 
 /* Perform requested action. */ 
  switch ( keyboard ) {
  	
  	case '0': {    /* Print the status as read from the circuit */
  	  addr_ptr = XPAR_PWM_LIGHTS_0_BASEADDR;
  	  status = *addr_ptr; 
  	  reg_value = (status & 0x0000ff00) >> 8;
  	  all_off_value = (status & 0x00000008) >> 3;
  	  run_value = (status & 0x00000004) >> 2;
  	  linear_value = (status & 0x00000003); 	  
   	  xil_printf ("Raw status read = %x \r\n", status); 
   	  xil_printf ("Register value  = %d \r\n", reg_value);	
   	  xil_printf ("All_off value   = %d \r\n", all_off_value);	
   	  xil_printf ("Run value       = %d \r\n", run_value);	
   	  xil_printf ("Linear value    = %d \r\r\n", linear_value); }   	    
  	  break;
  	  
  	case '1': {    /* Turn off LEDs */
  	  addr_ptr = XPAR_PWM_LIGHTS_0_BASEADDR;
  	  *addr_ptr = 0x00000000; }
  	  break;
  	   
  	case '2': {   /* Turn on LEDs */
  	  addr_ptr = XPAR_PWM_LIGHTS_0_BASEADDR + 4;
  	  *addr_ptr = 0x00000000; }
  	  break;
  	  
  	case '3': {   /* Use log drive for LEDs */
  	  addr_ptr = XPAR_PWM_LIGHTS_0_BASEADDR + 8;
  	  *addr_ptr = 0x00000000; }
  	  break;
  	  
  	case '4': {   /* Use linear drive for LEDs */
  	  addr_ptr = XPAR_PWM_LIGHTS_0_BASEADDR + 12;
  	  *addr_ptr = 0x00000000; }
  	  break;
  	  
  	case '5': {   /* Drive LEDs with register value */
  	  addr_ptr = XPAR_PWM_LIGHTS_0_BASEADDR + 16;
  	  xil_printf ("* Enter LED intensity value (0 to 255) and CR:     *\r\n");
  	  scanf ("%d", &LED_value);
  	  if (LED_value > 255) LED_value = 255;
  	  xil_printf ("%d \r\r\n", LED_value);
  	  *addr_ptr = LED_value << 24; }
  	  break;
  	  
  	case '6':   /* Exit program */
  	  xil_printf ("That was exciting, wasn't it? \r\r\n");
  	  exit(0);
  	  break;
  	default: {
  	  addr_ptr = XPAR_PWM_LIGHTS_0_BASEADDR;
   	  *addr_ptr = 0x00000000; } 	  
  	  break;
    }  
  }
}
