-- IODELAY2: Input and Output Fixed or Variable Delay Element
--           Spartan-6
-- Xilinx HDL Libraries Guide, version 12.1

IODELAY2_inst : IODELAY2
generic map (
   COUNTER_WRAPAROUND => "WRAPAROUND", -- STAY_AT_LIMIT or WRAPAROUND
   DATA_RATE => "SDR",                 -- SDR or DDR
   DELAY_SRC => "IO",                  -- IO, ODATAIN or IDATAIN
   IDELAY2_VALUE => 0,                 -- Amount of Input Delay (0-255)
   IDELAY_MODE => "NORMAL",            -- Unsupported
   IDELAY_TYPE => "DEFAULT",           -- FIXED, DEFAULT, VARIABLE_FROM_ZERO, VARIABLE_FROM_HALF_MAX or
                                       -- DIFF_PHASE_DETECTOR
   IDELAY_VALUE => 0,                  -- Amount of input delay (0-255)
   ODELAY_VALUE => 0,                  -- Amount of output delay (0-255)
   SERDES_MODE => "NONE",              -- NONE, MASTER or SLAVE
   SIM_TAPDELAY_VALUE => 75            -- Amount of delay used for simulation in pS
)
port map (
   BUSY => BUSY,         -- 1-bit Busy after CAL
   DATAOUT => DATAOUT,   -- 1-bit Delayed data output to ISERDES/Input register
   DATAOUT2 => DATAOUT2, -- 1-bit Delayed data output to general FPGA fabric
   DOUT => DOUT,         -- 1-bit Delayed Data Output to IOB
   TOUT => TOUT,         -- 1-bit Delayed Tristate Output
   CAL => CAL,           -- 1-bit Initiate calibration input
   CE => CE,             -- 1-bit Enable increment/decrement
   CLK => CLK,           -- 1-bit Clock input
   IDATAIN => IDATAIN,   -- 1-bit Data Signal from IOB
   INC => INC,           -- 1-bit Increment / Decrement input
   -- IOCLK0 - IOCLK1: 1-bit (each) I/O Clock inputs
   IOCLK0 => IOCLK0,
   IOCLK1 => IOCLK1,
   ODATAIN => ODATAIN,   -- 1-bit Output data input from OLOGIC or OSERDES.
   RST => RST,           -- 1-bit Reset to zero or 1/2 of total period
   T => T                -- 1-bit Tristate input signal
);

-- End of IODELAY2_inst instantiation
