-- ISERDES2: Input SERial/DESerializer
--           Spartan-6
-- Xilinx HDL Libraries Guide, version 12.1

ISERDES2_inst : ISERDES2
generic map (
   BITSLIP_ENABLE => FALSE,        -- Enable Bitslip Functionality (TRUE/FALSE)
   DATA_RATE => "SDR",             -- Data-rate (SDR/DDR)
   DATA_WIDTH => 1,                -- Parallel data width selection (2-8)
   INTERFACE_TYPE => "NETWORKING", -- NETWORKING, NETWORKING_PIPELINED or RETIMED
   SERDES_MODE => "NONE"           -- NONE, MASTER or SLAVE
)
port map (
   CFB0 => CFB0,           -- 1-bit Clock feed-through route output
   CFB1 => CFB1,           -- 1-bit Clock feed-through route output
   DFB => DFB,             -- 1-bit Feed-through clock output
   FABRICOUT => FABRICOUT, -- 1-bit Unsynchrnonized data output
   INCDEC => INCDEC,       -- 1-bit Phase detector output
   -- Q1 - Q4: 1-bit (each) Registered outputs to fabric
   Q1 => Q1,
   Q2 => Q2,
   Q3 => Q3,
   Q4 => Q4,
   SHIFTOUT => SHIFTOUT,   -- 1-bit Cascade output signal for master/slave I/O
   VALID => VALID,         -- 1-bit Output status of the phase detector
   BITSLIP => BITSLIP,     -- 1-bit Bitslip enable input
   CE0 => CE0,             -- 1-bit Clock enable input
   CLK0 => CLK0,           -- 1-bit I/O clock network input
   CLK1 => CLK1,           -- 1-bit Secondary I/O clock network input
   CLKDIV => CLKDIV,       -- 1-bit FPGA logic domain clock input
   D => D,                 -- 1-bit Input data
   IOCE => IOCE,           -- 1-bit Data strobe input
   RST => RST,             -- 1-bit Asynchronous reset input
   SHIFTIN => SHIFTIN      -- 1-bit Cascade input signal for master/slave I/O
);

-- End of ISERDES2_inst instantiation
