------------------------------------------------------------------------------
-- user_logic.vhd - entity/architecture pair
------------------------------------------------------------------------------
--
-- ***************************************************************************
-- ** Copyright (c) 1995-2009 Xilinx, Inc.  All rights reserved.            **
-- **                                                                       **
-- ** Xilinx, Inc.                                                          **
-- ** XILINX IS PROVIDING THIS DESIGN, CODE, OR INFORMATION "AS IS"         **
-- ** AS A COURTESY TO YOU, SOLELY FOR USE IN DEVELOPING PROGRAMS AND       **
-- ** SOLUTIONS FOR XILINX DEVICES.  BY PROVIDING THIS DESIGN, CODE,        **
-- ** OR INFORMATION AS ONE POSSIBLE IMPLEMENTATION OF THIS FEATURE,        **
-- ** APPLICATION OR STANDARD, XILINX IS MAKING NO REPRESENTATION           **
-- ** THAT THIS IMPLEMENTATION IS FREE FROM ANY CLAIMS OF INFRINGEMENT,     **
-- ** AND YOU ARE RESPONSIBLE FOR OBTAINING ANY RIGHTS YOU MAY REQUIRE      **
-- ** FOR YOUR IMPLEMENTATION.  XILINX EXPRESSLY DISCLAIMS ANY              **
-- ** WARRANTY WHATSOEVER WITH RESPECT TO THE ADEQUACY OF THE               **
-- ** IMPLEMENTATION, INCLUDING BUT NOT LIMITED TO ANY WARRANTIES OR        **
-- ** REPRESENTATIONS THAT THIS IMPLEMENTATION IS FREE FROM CLAIMS OF       **
-- ** INFRINGEMENT, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS       **
-- ** FOR A PARTICULAR PURPOSE.                                             **
-- **                                                                       **
-- ***************************************************************************
--
------------------------------------------------------------------------------
-- Filename:          user_logic.vhd
-- Version:           1.00.a
-- Description:       User logic.
-- Date:              Tue Mar 03 13:22:55 2009 (by Create and Import Peripheral Wizard)
-- VHDL Standard:     VHDL'93
------------------------------------------------------------------------------
-- Naming Conventions:
--   active low signals:                    "*_n"
--   clock signals:                         "clk", "clk_div#", "clk_#x"
--   reset signals:                         "rst", "rst_n"
--   generics:                              "C_*"
--   user defined types:                    "*_TYPE"
--   state machine next state:              "*_ns"
--   state machine current state:           "*_cs"
--   combinatorial signals:                 "*_com"
--   pipelined or register delay signals:   "*_d#"
--   counter signals:                       "*cnt*"
--   clock enable signals:                  "*_ce"
--   internal version of output port:       "*_i"
--   device pins:                           "*_pin"
--   ports:                                 "- Names begin with Uppercase"
--   processes:                             "*_PROCESS"
--   component instantiations:              "<ENTITY_>I_<#|FUNC>"
------------------------------------------------------------------------------

-- DO NOT EDIT BELOW THIS LINE --------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

library proc_common_v3_00_a;
use proc_common_v3_00_a.proc_common_pkg.all;

-- DO NOT EDIT ABOVE THIS LINE --------------------

--USER libraries added here

------------------------------------------------------------------------------
-- Entity section
------------------------------------------------------------------------------
-- Definition of Generics:
--   C_SLV_DWIDTH                 -- Slave interface data bus width
--   C_NUM_REG                    -- Number of software accessible registers
--
-- Definition of Ports:
--   Bus2IP_Clk                   -- Bus to IP clock
--   Bus2IP_Reset                 -- Bus to IP reset
--   Bus2IP_Addr                  -- Bus to IP address bus
--   Bus2IP_Data                  -- Bus to IP data bus
--   Bus2IP_BE                    -- Bus to IP byte enables
--   Bus2IP_RdCE                  -- Bus to IP read chip enable
--   Bus2IP_WrCE                  -- Bus to IP write chip enable
--   IP2Bus_Data                  -- IP to Bus data bus
--   IP2Bus_RdAck                 -- IP to Bus read transfer acknowledgement
--   IP2Bus_WrAck                 -- IP to Bus write transfer acknowledgement
--   IP2Bus_Error                 -- IP to Bus error response
------------------------------------------------------------------------------

entity user_logic is
  generic
  (
    -- ADD USER GENERICS BELOW THIS LINE ---------------
    --USER generics added here
    -- ADD USER GENERICS ABOVE THIS LINE ---------------

    -- DO NOT EDIT BELOW THIS LINE ---------------------
    -- Bus protocol parameters, do not add to or delete
    C_SLV_DWIDTH                   : integer              := 32;
    C_NUM_REG                      : integer              := 1
    -- DO NOT EDIT ABOVE THIS LINE ---------------------
  );
  port
  (
    -- ADD USER PORTS BELOW THIS LINE ------------------
    LEDs                           : out std_logic_vector (0 to 7);
    -- ADD USER PORTS ABOVE THIS LINE ------------------

    -- DO NOT EDIT BELOW THIS LINE ---------------------
    -- Bus protocol ports, do not add to or delete
    Bus2IP_Clk                     : in  std_logic;
    Bus2IP_Reset                   : in  std_logic;
    Bus2IP_Addr                    : in  std_logic_vector(0 to 31);
    Bus2IP_Data                    : in  std_logic_vector(0 to C_SLV_DWIDTH-1);
    Bus2IP_BE                      : in  std_logic_vector(0 to C_SLV_DWIDTH/8-1);
    Bus2IP_RdCE                    : in  std_logic_vector(0 to C_NUM_REG-1);
    Bus2IP_WrCE                    : in  std_logic_vector(0 to C_NUM_REG-1);
    IP2Bus_Data                    : out std_logic_vector(0 to C_SLV_DWIDTH-1);
    IP2Bus_RdAck                   : out std_logic;
    IP2Bus_WrAck                   : out std_logic;
    IP2Bus_Error                   : out std_logic
    -- DO NOT EDIT ABOVE THIS LINE ---------------------
  );

  attribute SIGIS : string;
  attribute SIGIS of Bus2IP_Clk    : signal is "CLK";
  attribute SIGIS of Bus2IP_Reset  : signal is "RST";

end entity user_logic;

------------------------------------------------------------------------------
-- Architecture section
------------------------------------------------------------------------------

architecture IMP of user_logic is

signal count:                std_logic_vector (28 downto 0);
constant slow_clock_tap:     integer := 24;
signal PWM_clock:            std_logic;
constant PWM_tap:            integer := 16;
signal all_off:              std_logic;
signal run:                  std_logic;
signal linear:               std_logic_vector (1 downto 0);  -- 00 = log, 01 = linear, 1x - register
signal PWM_value:            std_logic_vector (7 downto 0);
signal reg_value:            std_logic_vector (7 downto 0);

begin

--
-- Clock generator block
-- Assume clock frequency is 125Mhz
-- Tap 16 yields about 975Hz (PWM clock)
-- Tap 24 yields about 4Hz (Update clock)
--
clock_divider: process(BUS2IP_Clk)
    begin
        if (BUS2IP_Clk 'event and BUS2IP_Clk = '1') then
            count <= count + 1;
        end if;
end process clock_divider;        
--
-- decode bus logic
-- write to address 0 turns LEDs off
-- write to address 4 turns LEDs on
-- write to address 8 lights LEDs with a log pattern (looks smooth)
-- write to address C lights LEDs with a linear patterm (not smooth)
-- write to address 10 - 1C lights LEDs with register value (0 to 255)
--
decode: process(BUS2IP_Clk, Bus2IP_Reset, Bus2IP_WrCE, Bus2IP_Addr(28 to 29))
    begin
         if (BUS2IP_Clk 'event and BUS2IP_Clk = '1') then
            if ((Bus2IP_Reset = '0') and (Bus2IP_WrCE(0) = '1') and (Bus2IP_Addr(27 to 29) = "000")) then
                all_off <= '1';
                run <= '0';
                linear <= "00";
            end if;
            if ((Bus2IP_Reset = '0') and (Bus2IP_WrCE(0) = '1') and (Bus2IP_Addr(27 to 29) = "001")) then
                all_off <= '0';
                run <= '0';
                linear <= "00";
            end if;
            if ((Bus2IP_Reset = '0') and (Bus2IP_WrCE(0) = '1') and (Bus2IP_Addr(27 to 29) = "010")) then
                all_off <= '0';
                run <= '1';
                linear <= "00";
            end if;
            if ((Bus2IP_Reset = '0') and (Bus2IP_WrCE(0) = '1') and (Bus2IP_Addr(27 to 29) = "011")) then
                all_off <= '0';
                run <= '1';
                linear <= "01";
            end if;                
            if ((Bus2IP_Reset = '0') and (Bus2IP_WrCE(0) = '1') and (Bus2IP_Addr(27) = '1')) then
                all_off <= '0';
                run <= '1';
                linear <= "11";
                reg_value (7 downto 0) <= Bus2IP_Data(0 to 7);
            end if;
        end if;
end process decode;
            
--
-- Define linear / log patterns
--
PWM: process(count,linear)
    begin
        if linear = "00" then
            case (count (slow_clock_tap+3 downto slow_clock_tap)) is
                when "0000" => PWM_value <= "00000001";  -- 1
                when "0001" => PWM_value <= "00000010";  -- 4
                when "0010" => PWM_value <= "00001001";  -- 9
                when "0011" => PWM_value <= "00010000";  -- 16
                when "0100" => PWM_value <= "00011001";  -- 25  
                when "0101" => PWM_value <= "00100010";  -- 36
                when "0110" => PWM_value <= "00110001";  -- 49
                when "0111" => PWM_value <= "01000000";  -- 64
                when "1000" => PWM_value <= "01010001";  -- 81
                when "1001" => PWM_value <= "01100100";  -- 100
                when "1010" => PWM_value <= "01111001";  -- 121
                when "1011" => PWM_value <= "10010000";  -- 144
                when "1100" => PWM_value <= "10101001";  -- 169
                when "1101" => PWM_value <= "11000100";  -- 196
                when "1110" => PWM_value <= "11100001";  -- 225
                when others => PWM_value <= "11111111";  -- 255
            end case;
        elsif linear = "01" then
            case (count (slow_clock_tap+3 downto slow_clock_tap)) is
                when "0000" => PWM_value <= "00010000";  -- 16
                when "0001" => PWM_value <= "00100000";  -- 32
                when "0010" => PWM_value <= "00110000";  -- 48
                when "0011" => PWM_value <= "01000000";  -- 64
                when "0100" => PWM_value <= "01010000";  -- 80 
                when "0101" => PWM_value <= "01100000";  -- 96
                when "0110" => PWM_value <= "01110000";  -- 112
                when "0111" => PWM_value <= "10000000";  -- 128
                when "1000" => PWM_value <= "10010000";  -- 144
                when "1001" => PWM_value <= "10100000";  -- 160
                when "1010" => PWM_value <= "10110000";  -- 176
                when "1011" => PWM_value <= "11000000";  -- 192
                when "1100" => PWM_value <= "11010000";  -- 208
                when "1101" => PWM_value <= "11100000";  -- 224
                when "1110" => PWM_value <= "11110000";  -- 240
                when others => PWM_value <= "11111111";  -- 255
            end case;
        else
                PWM_value <= reg_value;
        end if;
end process PWM;
--
-- Drive LEDs (one is on, zero is off)
-- 
 
LEDs(0 to 7) <= "00000000" when (all_off = '1') else                         -- off
                "11111111" when (run = '0') else                             -- on
                "11111111" when (PWM_value >= count(15 downto 8)) else       -- PWM or reg_value
                "00000000";
                
--
-- Read back something on the data bus
-- Read back F0F0, then the register value, followed by "0000, all_off, run, linear (2 bits)";

IP2Bus_Data <= "1111000011110000" & reg_value & "0000" & all_off & run & linear when
                ((Bus2IP_Reset = '0') and (Bus2IP_RdCE(0) = '1')) else
                (others => '0');

--
-- Drive IP to Bus signals
--
  IP2Bus_WrAck <= Bus2IP_WrCE(0);
  IP2Bus_RdAck <= Bus2IP_RdCE(0);
  IP2Bus_Error <= '0';

end IMP;
