-- OSERDES: Output SERDES
--          Virtex-4
-- Xilinx HDL Libraries Guide, version 12.1

OSERDES_inst : OSERDES
generic map (
   DATA_RATE_OQ => "DDR", -- Specify data rate to "DDR" or "SDR" 
   DATA_RATE_TQ => "DDR", -- Specify data rate to "DDR", "SDR", or "BUF" 
   DATA_WIDTH => 4, -- Specify data width - For DDR: 4,6,8, or 10 
                    -- For SDR or BUF: 2,3,4,5,6,7, or 8 
   INIT_OQ => '0',  -- INIT for Q1 register - '1' or '0' 
   INIT_TQ => '0',  -- INIT for Q2 register - '1' or '0' 
   SERDES_MODE => "MASTER", --Set SERDES mode to "MASTER" or "SLAVE" 
   SRVAL_OQ => '0', -- Define Q1 output value upon SR assertion - '1' or '0' 
   SRVAL_TQ => '0', -- Define Q1 output value upon SR assertion - '1' or '0' 
   TRISTATE_WIDTH => 4) -- Specify parallel to serial converter width 
                        -- When DATA_RATE_TQ = DDR: 2 or 4 
                        -- When DATA_RATE_TQ = SDR or BUF: 1 " 
port map (
   OQ => OQ,    -- 1-bit output
   SHIFTOUT1 => SHIFTOUT1, -- 1-bit data expansion output
   SHIFTOUT2 => SHIFTOUT2, -- 1-bit data expansion output
   TQ => TQ,    -- 1-bit 3-state control output
   CLK => CLK,  -- 1-bit clock input
   CLKDIV => CLKDIV,  -- 1-bit divided clock input
   D1 => D1,    -- 1-bit parallel data input
   D2 => D2,    -- 1-bit parallel data input
   D3 => D3,    -- 1-bit parallel data input
   D4 => D4,    -- 1-bit parallel data input
   D5 => D5,    -- 1-bit parallel data input
   D6 => D6,    -- 1-bit parallel data input
   OCE => OCE,  -- 1-bit clcok enable input
   REV => '0',  -- Must be tied to logic zero
   SHIFTIN1 => SHIFTIN1, -- 1-bit data expansion input
   SHIFTIN2 => SHIFTIN2, -- 1-bit data expansion input
   SR => SR,   -- 1-bit set/reset input
   T1 => T1,   -- 1-bit parallel 3-state input
   T2 => T2,   -- 1-bit parallel 3-state input
   T3 => T3,   -- 1-bit parallel 3-state input
   T4 => T4,   -- 1-bit parallel 3-state input
   TCE => TCE  -- 1-bit 3-state signal clock enable input
);

-- End of OSERDES_inst instantiation
