// ISERDES: Source Synchronous Input Deserializer
//          Virtex-4
// Xilinx HDL Libraries Guide, version 12.1

ISERDES #(
   .BITSLIP_ENABLE("FALSE"), // "TRUE"/"FALSE" to enable bitslip controller
                             //    Must be "FALSE" if INTERFACE_TYPE set to "MEMORY"
   .DATA_RATE("DDR"), // Specify data rate of "DDR" or "SDR" 
   .DATA_WIDTH(4), // Specify data width - For DDR 4,6,8, or 10
                   //    For SDR 2,3,4,5,6,7, or 8 
   .INTERFACE_TYPE("MEMORY"), // Use model - "MEMORY" or "NETWORKING" 
   .IOBDELAY("NONE"), // Specify outputs where delay chain will be applied
                      //    "NONE", "IBUF", "IFD", or "BOTH" 
   .IOBDELAY_TYPE("DEFAULT"), // Set tap delay "DEFAULT", "FIXED", or "VARIABLE" 
   .IOBDELAY_VALUE(0), // Set initial tap delay to an integer from 0 to 63
   .NUM_CE(2), // Define number or clock enables to an integer of 1 or 2
   .SERDES_MODE("MASTER")  // Set SERDES mode to "MASTER" or "SLAVE" 
) ISERDES_inst (
   .O(O),    // 1-bit combinatorial output
   .Q1(Q1),  // 1-bit registered output
   .Q2(Q2),  // 1-bit registered output
   .Q3(Q3),  // 1-bit registered output
   .Q4(Q4),  // 1-bit registered output
   .Q5(Q5),  // 1-bit registered output
   .Q6(Q6),  // 1-bit registered output
   .SHIFTOUT1(SHIFTOUT1), // 1-bit carry output
   .SHIFTOUT2(SHIFTOUT2), // 1-bit carry output
   .BITSLIP(BITSLIP),     // 1-bit Bitslip input
   .CE1(CE1),        // 1-bit clock enable input
   .CE2(CE2),        // 1-bit clock enable input
   .CLK(CLK),        // 1-bit clock input
   .CLKDIV(CLKDIV),  // 1-bit divided clock input
   .D(D),            // 1-bit serial data input
   .DLYCE(DLYCE),    // 1-bit delay chain enable input
   .DLYINC(DLYINC),  // 1-bit delay increment/decrement input
   .DLYRST(DLYRST),  // 1-bit delay chain reset input
   .OCLK(OCLK),      // 1-bit high-speed clock input
   .REV(1'b0),       // Must be tied to logic zero
   .SHIFTIN1(SHIFTIN1), // 1-bit carry input
   .SHIFTIN2(SHIFTIN2), // 1-bit carry input
   .SR(SR)           // 1-bit set/reset input
);

// End of ISERDES_inst instantiation
