-- IODELAY: Input and/or Output Fixed/Variable Delay Element
--          Virtex-5
-- Xilinx HDL Libraries Guide, version 12.1

IODELAY_inst : IODELAY
generic map (
   DELAY_SRC => "I", -- Specify which input port to be used
                     -- "I"=IDATAIN, "O"=ODATAIN, "DATAIN"=DATAIN, "IO"=Bi-directional
   HIGH_PERFORMANCE_MODE => TRUE, -- TRUE specifies lower jitter
                                  -- at expense of more power
   IDELAY_TYPE => "FIXED",  -- "FIXED" or "VARIABLE" 
   IDELAY_VALUE => 0,   -- 0 to 63 tap values
   ODELAY_VALUE => 0,   -- 0 to 63 tap values
   REFCLK_FREQUENCY => 200.0,   -- Frequency used for IDELAYCTRL
                                 -- 175.0 to 225.0
   SIGNAL_PATTERN => "DATA")    -- Input signal type, "CLOCK" or "DATA"
port map (
   DATAOUT => DATAOUT,  -- 1-bit delayed data output
   C => C,     -- 1-bit clock input
   CE => CE,   -- 1-bit clock enable input
   DATAIN => DATAIN, -- 1-bit internal data input
   IDATAIN => IDATAIN,  -- 1-bit input data input (connect to port)
   INC => INC, -- 1-bit increment/decrement input
   ODATAIN => ODATAIN,  -- 1-bit output data input
   RST => RST,  -- 1-bit active high, synch reset input
   T => T  -- 1-bit 3-state control input
);

-- End of IODELAY_inst instantiation
