// PLL_ADV: Phase-Lock Loop Clock Circuit 
//          Virtex-5
// Xilinx HDL Libraries Guide, version 12.1

PLL_ADV #(
   .BANDWIDTH("OPTIMIZED"),  // "HIGH", "LOW" or "OPTIMIZED"
   .CLKFBOUT_MULT(1),        // Multiplication factor for all output clocks
   .CLKFBOUT_PHASE(0.0),     // Phase shift (degrees) of all output clocks
   .CLKIN1_PERIOD(0.000),    // Clock period (ns) of input clock on CLKIN1
   .CLKIN2_PERIOD(0.000),    // Clock period (ns) of input clock on CLKIN2
   .CLKOUT0_DIVIDE(1),       // Division factor for CLKOUT0 (1 to 128)
   .CLKOUT0_DUTY_CYCLE(0.5), // Duty cycle for CLKOUT0 (0.01 to 0.99)
   .CLKOUT0_PHASE(0.0),      // Phase shift (degrees) for CLKOUT0 (0.0 to 360.0)
   .CLKOUT1_DIVIDE(1),       // Division factor for CLKOUT1 (1 to 128)
   .CLKOUT1_DUTY_CYCLE(0.5), // Duty cycle for CLKOUT1 (0.01 to 0.99)
   .CLKOUT1_PHASE(0.0),      // Phase shift (degrees) for CLKOUT1 (0.0 to 360.0)
   .CLKOUT2_DIVIDE(1),       // Division factor for CLKOUT2 (1 to 128)
   .CLKOUT2_DUTY_CYCLE(0.5), // Duty cycle for CLKOUT2 (0.01 to 0.99)
   .CLKOUT2_PHASE(0.0),      // Phase shift (degrees) for CLKOUT2 (0.0 to 360.0)
   .CLKOUT3_DIVIDE(1),       // Division factor for CLKOUT3 (1 to 128)
   .CLKOUT3_DUTY_CYCLE(0.5), // Duty cycle for CLKOUT3 (0.01 to 0.99)
   .CLKOUT3_PHASE(0.0),      // Phase shift (degrees) for CLKOUT3 (0.0 to 360.0)
   .CLKOUT4_DIVIDE(1),       // Division factor for CLKOUT4 (1 to 128)
   .CLKOUT4_DUTY_CYCLE(0.5), // Duty cycle for CLKOUT4 (0.01 to 0.99)
   .CLKOUT4_PHASE(0.0),      // Phase shift (degrees) for CLKOUT4 (0.0 to 360.0)
   .CLKOUT5_DIVIDE(1),       // Division factor for CLKOUT5 (1 to 128)
   .CLKOUT5_DUTY_CYCLE(0.5), // Duty cycle for CLKOUT5 (0.01 to 0.99)
   .CLKOUT5_PHASE(0.0),      // Phase shift (degrees) for CLKOUT5 (0.0 to 360.0)
   .COMPENSATION("SYSTEM_SYNCHRONOUS"), // "SYSTEM_SYNCHRONOUS", 
                             //   "SOURCE_SYNCHRONOUS", "INTERNAL", "EXTERNAL", 
                             //   "DCM2PLL", "PLL2DCM" 
   .DIVCLK_DIVIDE(1),        // Division factor for all clocks (1 to 52)
   .EN_REL("FALSE"),         // Enable release (PMCD mode only)
   .PLL_PMCD_MODE("FALSE"),  // PMCD Mode, TRUE/FASLE
   .REF_JITTER(0.100),       // Input reference jitter (0.000 to 0.999 UI%)
   .RST_DEASSERT_CLK("CLKIN1") // In PMCD mode, clock to synchronize RST release
) PLL_ADV_inst (
   .CLKFBDCM(CLKFBDCM),      // Output feedback signal used when PLL feeds a DCM
   .CLKFBOUT(CLKFBOUT),      // General output feedback signal
   .CLKOUT0(CLKOUT0),        // One of six general clock output signals
   .CLKOUT1(CLKOUT1),        // One of six general clock output signals
   .CLKOUT2(CLKOUT2),        // One of six general clock output signals
   .CLKOUT3(CLKOUT3),        // One of six general clock output signals
   .CLKOUT4(CLKOUT4),        // One of six general clock output signals
   .CLKOUT5(CLKOUT5),        // One of six general clock output signals
   .CLKOUTDCM0(CLKOUTDCM0),  // One of six clock outputs to connect to the DCM
   .CLKOUTDCM1(CLKOUTDCM1),  // One of six clock outputs to connect to the DCM
   .CLKOUTDCM2(CLKOUTDCM2),  // One of six clock outputs to connect to the DCM
   .CLKOUTDCM3(CLKOUTDCM3),  // One of six clock outputs to connect to the DCM
   .CLKOUTDCM4(CLKOUTDCM4),  // One of six clock outputs to connect to the DCM
   .CLKOUTDCM5(CLKOUTDCM5),  // One of six clock outputs to connect to the DCM
   .DO(DO),                  // Dynamic reconfig data output (16-bits)
   .DRDY(DRDY),              // Dynamic reconfig ready output
   .LOCKED(LOCKED),          // Active high PLL lock signal
   .CLKFBIN(CLKFBIN),        // Clock feedback input
   .CLKIN1(CLKIN1),          // Primary clock input
   .CLKIN2(CLKIN2),          // Secondary clock input
   .CLKINSEL(CLKINSEL),      // Selects '1' = CLKIN1, '0' = CLKIN2
   .DADDR(DADDR),            // Dynamic reconfig address input (5-bits)
   .DCLK(DCLK),              // Dynamic reconfig clock input
   .DEN(DEN),                // Dynamic reconfig enable input
   .DI(DI),                  // Dynamic reconfig data input (16-bits)
   .DWE(DWE),                // Dynamic reconfig write enable input
   .REL(REL),                // Clock release input (PMCD mode only)
   .RST(RST)                 // Asynchronous PLL reset
);

// End of PLL_ADV_inst instantiation
