-- ICAP_VIRTEX6: Internal Configuration Access Port
--               Virtex-6
-- Xilinx HDL Libraries Guide, version 12.1

ICAP_VIRTEX6_inst : ICAP_VIRTEX6
generic map (
   DEVICE_ID => X"4244093",     -- Specifies the pre-programmed Device ID value
   ICAP_WIDTH => "X8",          -- Specifies the input and output data width to be used with the
                                -- ICAP_VIRTEX6. "X8", "X16", "X32".
   SIM_CFG_FILE_NAME => "NONE"  -- Specifies the Raw Bitstream (RBT) file to be parsed by the simulation
                                -- model
)
port map (
   BUSY => BUSY,   -- 1-bit Busy/Ready output
   O => O,         -- 32-bit Configuration data output bus
   CLK => CLK,     -- 1-bit Clock Input
   CSB => CSB,     -- 1-bit Active-Low ICAP input Enable
   I => I,         -- 32-bit Configuration data input bus
   RDWRB => RDWRB  -- 1-bit Read/Write Select input
);

-- End of ICAP_VIRTEX6_inst instantiation
