-- ISERDESE1: Input SERial/DESerializer
--            Virtex-6
-- Xilinx HDL Libraries Guide, version 12.1

ISERDESE1_inst : ISERDESE1
generic map (
   DATA_RATE => "DDR",         -- SDR or DDR
   DATA_WIDTH => 4,            -- Parallel data width (2-8, 10)
   DYN_CLKDIV_INV_EN => FALSE, -- Enable DYNCLKDIVINVSEL inversion (TRUE/FALSE)
   DYN_CLK_INV_EN => FALSE,    -- Enable DYNCLKINVSEL inversion (TRUE/FALSE)
   -- INIT_Q1 - INIT_Q4: Initial value on the Q outputs (0/1)
   INIT_Q1 => '0',
   INIT_Q2 => '0',
   INIT_Q3 => '0',
   INIT_Q4 => '0',
   INTERFACE_TYPE => "MEMORY", -- MEMORY, MEMORY_DDR3, MEMORY_QDR, NETWORKING, or OVERSAMPLE
   IOBDELAY => "NONE",         -- NONE, IBUF, IFD, BOTH
   NUM_CE => 2,                -- Number of clock enables (1 or 2)
   OFB_USED => FALSE,          -- Select OFB path (TRUE/FALSE)
   SERDES_MODE => "MASTER",    -- MASTER or SLAVE
   -- SRVAL_Q1 - SRVAL_Q4: Q output values when SR is used (0/1)
   SRVAL_Q1 => '0',
   SRVAL_Q2 => '0',
   SRVAL_Q3 => '0',
   SRVAL_Q4 => '0' 
)
port map (
   O => O,                       -- 1-bit Combinatorial output
   -- Q1 - Q6: 1-bit (each) Data outputs
   Q1 => Q1,
   Q2 => Q2,
   Q3 => Q3,
   Q4 => Q4,
   Q5 => Q5,
   Q6 => Q6,
   -- SHIFTOUT1/SHIFTOUT2: 1-bit (each) Cascade outputs for data width expansion
   SHIFTOUT1 => SHIFTOUT1,
   SHIFTOUT2 => SHIFTOUT2,
   BITSLIP => BITSLIP,           -- 1-bit The BITSLIP pin performs a Bitslip operation synchronous to CLKDIV
                                 -- when asserted (active High). Subsequently, the data seen on the Q1 to Q6
                                 -- output ports will shift, as in a barrel-shifter operation, one position
                                 -- every time Bitslip is invoked (DDR operation is different from SDR).

   -- CE1, CE2: 1-bit (each) Data register clock enable inputs
   CE1 => CE1,
   CE2 => CE2,
   CLK => CLK,                   -- 1-bit Clock input
   CLKB => CLKB,                 -- 1-bit Secondary clock input
   CLKDIV => CLKDIV,             -- 1-bit Divided clock input
   D => D,                       -- 1-bit Data input
   DDLY => DDLY,                 -- 1-bit Serial input data from IODELAY
   DYNCLKDIVSEL => DYNCLKDIVSEL, -- 1-bit Dynamic CLKDIV inversion input
   DYNCLKSEL => DYNCLKSEL,       -- 1-bit Dynamic CLK/CLKB inversion input
   OCLK => OCLK,                 -- 1-bit High speed output clock input
   OFB => OFB,                   -- 1-bit Feedback path input
   RST => RST,                   -- 1-bit Active high asynchronous reset input
   -- SHIFTIN1/SHIFTIN2: 1-bit (each) Cascade inputs for data width expansion
   SHIFTIN1 => SHIFTIN1,
   SHIFTIN2 => SHIFTIN2 
);

-- End of ISERDESE1_inst instantiation
