// BSCAN_SPARTAN6: Boundary Scan
//                 Spartan-6
// Xilinx HDL Libraries Guide, version 12.2

BSCAN_SPARTAN6 #(
   .JTAG_CHAIN(1)  // Value for USER command. Possible values: (1,2,3 or 4).
)
BSCAN_SPARTAN6_inst (
   .CAPTURE(CAPTURE), // 1-bit CAPTURE output from TAP controller
   .DRCK(DRCK),       // 1-bit Data register output for USER functions
   .RESET(RESET),     // 1-bit Reset output for TAP controller
   .RUNTEST(RUNTEST), // 1-bit Output signal that gets asserted when TAP controller is in Run Test Idle
                      // state.

   .SEL(SEL),         // 1-bit USER active output
   .SHIFT(SHIFT),     // 1-bit SHIFT output from TAP controller
   .TCK(TCK),         // 1-bit Scan Clock output. Fabric connection to TAP Clock pin.
   .TDI(TDI),         // 1-bit TDI output from TAP controller
   .TMS(TMS),         // 1-bit Test Mode Select output. Fabric connection to TAP.
   .UPDATE(UPDATE),   // 1-bit UPDATE output from TAP controller
   .TDO(TDO)          // 1-bit Data input for USER function
);

// End of BSCAN_SPARTAN6_inst instantiation
