-- IODELAYE1: Input and Output Fixed or Variable Delay Element
--            Virtex-6
-- Xilinx HDL Libraries Guide, version 12.2

IODELAYE1_inst : IODELAYE1
generic map (
   CINVCTRL_SEL => "FALSE",         -- Dynamically inverts the Clock (C) polarity.
   DELAY_SRC => "I",                -- Specifies the source to the IODELAY component. "I" means it will be
                                    -- connected directly to an input port or IBUF (input mode), "O" means
                                    -- it will be connected to an output port or OBUF (output mode), "IO"
                                    -- means it will be connected to a port, and "DATAIN" means it will not
                                    -- be connected to any port (internal mode).
   HIGH_PERFORMANCE_MODE => "TRUE", -- When TRUE, this attribute reduces the output jitter.
   IDELAY_TYPE => "DEFAULT",        -- Specifies a fixed, variable or default (eliminate hold time) input
                                    -- delay.
   IDELAY_VALUE => 0,               -- Specifies the number of taps of delay for the input path when in
                                    -- fixed mode or the initial delay tap value for variable mode.
   ODELAY_TYPE => "FIXED",
   ODELAY_VALUE => 0,               -- Specifies the number of taps of delay for the output path.
   REFCLK_FREQUENCY => 200.0,       -- When using an associated IDELAYCTRL, specifies the input reference
                                    -- frequency to the component.
   SIGNAL_PATTERN => "DATA"         -- Used by the delay calculator to determine different propagation
                                    -- delays through the IODELAY block based on the setting. DATA will be
                                    -- the addition of per tap delay and per tap jitter. No jitter is
                                    -- introduced for clock-like signals.
)
port map (
   CNTVALUEOUT => CNTVALUEOUT, -- 5-bit Counter value going to fabric for monitoring purpose
   DATAOUT => DATAOUT,         -- 1-bit Delayed data output from input port (connect to input datapath logic)
   C => C,                     -- 1-bit Clock input (Must be connected for variable mode)
   CE => CE,                   -- 1-bit Active high enable increment/decrement function
   CINVCTRL => CINVCTRL,       -- 1-bit Dynamically inverts the Clock (C) polarity
   CLKIN => CLKIN,             -- 1-bit Clock Access into the IODELAY (from the IO CLKMUX)
   CNTVALUEIN => CNTVALUEIN,   -- 5-bit Counter value from fabric for loadable counter application
   DATAIN => DATAIN,           -- 1-bit Data input for the internal datapath delay. When DATAIN is used,
                               -- IDATAIN and ODATAIN must be tied to a logic zero (ground).

   IDATAIN => IDATAIN,         -- 1-bit Data input to device from the I/O (connect directly to port, I/O
                               -- Buffer). When IDATAIN is used, DATAIN must be tied to a logic zero
                               -- (ground).

   INC => INC,                 -- 1-bit Increment / Decrement tap delay
   ODATAIN => ODATAIN,         -- 1-bit Data input for the output datapath from the device (connect to
                               -- output data source). When ODATAIN is used, DATAIN must be tied to a logic
                               -- zero (ground).

   RST => RST,                 -- 1-bit Active high, synchronous reset, resets delay chain to IDELAY_VALUE/
                               -- ODELAY_VALUE tap. If no value is specified, the default is 0.

   T => T                      -- 1-bit 3-state input control. Tie high for input-only or internal delay or
                               -- tie low for output only.

);

-- End of IODELAYE1_inst instantiation
