// DSP48E1: 48-bit Multi-Functional Arithmetic Block
//          Virtex-6
// Xilinx HDL Libraries Guide, version 12.2

DSP48E1 #(
   .ACASCREG(1),                     // Number of pipeline registers between A/ACIN input and ACOUT output,
                                     // 0, 1, or 2
   .ADREG(1),                        // Number of pipeline registers on pre-adder output, 0 or 1
   .ALUMODEREG(1),                   // Number of pipeline registers on ALUMODE input, 0 or 1
   .AREG(1),                         // Number of pipeline registers on the A input, 0, 1 or 2
   .AUTORESET_PATDET("NO_RESET"),    // NO_RESET, RESET_MATCH, RESET_NOT_MATCH
   .A_INPUT("DIRECT"),               // Selects A input used, "DIRECT" (A port) or "CASCADE" (ACIN port)
   .BCASCREG(1),                     // Number of pipeline registers between B/BCIN input and BCOUT output,
                                     // 0, 1, or 2
   .BREG(1),                         // Number of pipeline registers on the B input, 0, 1 or 2
   .B_INPUT("DIRECT"),               // Selects B input used, "DIRECT" (B port) or "CASCADE" (BCIN port)
   .CARRYINREG(1),                   // Number of pipeline registers for the CARRYIN input, 0 or 1
   .CARRYINSELREG(1),                // Number of pipeline registers for the CARRYINSEL input, 0 or 1
   .CREG(1),                         // Number of pipeline registers on the C input, 0 or 1
   .DREG(1),                         // Number of pipeline registers on the D input, 0 or 1
   .INMODEREG(1),                    // Number of pipeline registers on INMODE input, 0 or 1
   .MASK(48'h3fffffffffff),          // 48-bit Mask value for pattern detect
   .MREG(1),                         // Number of multiplier pipeline registers, 0 or 1
   .OPMODEREG(1),                    // Number of pipeline registers on OPMODE input, 0 or 1
   .PATTERN(48'h000000000000),       // 48-bit Pattern match for pattern detect
   .PREG(1),                         // Number of pipeline registers on the P output, 0 or 1
   .SEL_MASK("MASK"),                // "C", "MASK", "ROUNDING_MODE1", "ROUNDING_MODE2"
   .SEL_PATTERN("PATTERN"),          // Select pattern value between the "PATTERN" value or the value on the
                                     // "C" port
   .USE_DPORT("FALSE"),              // Select D port usage, TRUE or FALSE
   .USE_MULT("MULTIPLY"),            // Select multiplier usage, "MULTIPLY", "DYNAMIC", or "NONE" (no
                                     // multiplier)
   .USE_PATTERN_DETECT("NO_PATDET"), // Enable pattern detect, "PATDET", "NO_PATDET"
   .USE_SIMD("ONE48")                // SIMD selection, "ONE48", "TWO24", "FOUR12"
)
DSP48E1_inst (
   // Cascade: 30-bit (each) Cascade
   .ACOUT(ACOUT),                   // 30-bit A port cascade output
   .BCOUT(BCOUT),                   // 18-bit B port cascade output
   .CARRYCASCOUT(CARRYCASCOUT),     // 1-bit cascade carry output
   .MULTSIGNOUT(MULTSIGNOUT),       // 1-bit multiplier sign cascade output
   .PCOUT(PCOUT),                   // 48-bit cascade output
   // Control: 1-bit (each) Control
   .OVERFLOW(OVERFLOW),             // 1-bit overflow in add/acc output
   .PATTERNBDETECT(PATTERNBDETECT), // 1-bit active high pattern bar detect output
   .PATTERNDETECT(PATTERNDETECT),   // 1-bit active high pattern detect output
   .UNDERFLOW(UNDERFLOW),           // 1-bit active high underflow in add/acc output
   // Data: 4-bit (each) Data
   .CARRYOUT(CARRYOUT),             // 4-bit carry output
   .P(P),                           // 48-bit output
   // Cascade: 30-bit (each) Cascade
   .ACIN(ACIN),                     // 30-bit A cascade data input
   .BCIN(BCIN),                     // 18-bit B cascade input
   .CARRYCASCIN(CARRYCASCIN),       // 1-bit cascade carry input
   .MULTSIGNIN(MULTSIGNIN),         // 1-bit multiplier sign input
   .PCIN(PCIN),                     // 48-bit P cascade input
   // Control: 4-bit (each) Control
   .ALUMODE(ALUMODE),               // 4-bit ALU control input
   .CARRYINSEL(CARRYINSEL),         // 3-bit carry select input
   .CEINMODE(CEINMODE),             // 1-bit active high clock enable input for INMODE registers
   .CLK(CLK),                       // 1-bit Clock input
   .INMODE(INMODE),                 // 5-bit INMODE control input
   .OPMODE(OPMODE),                 // 7-bit operation mode input
   .RSTINMODE(RSTINMODE),           // 1-bit reset input for INMODE pipeline registers
   // Data: 30-bit (each) Data
   .A(A),                           // 30-bit A data input
   .B(B),                           // 18-bit B data input
   .C(C),                           // 48-bit C data input
   .CARRYIN(CARRYIN),               // 1-bit carry input signal
   .D(D),                           // 25-bit D data input
   // Reset/Clock Enable: 1-bit (each) Reset/Clock Enable
   .CEA1(CEA1),                     // 1-bit active high clock enable input for 1st stage A registers
   .CEA2(CEA2),                     // 1-bit active high clock enable input for 2nd stage A registers
   .CEAD(CEAD),                     // 1-bit active high clock enable input for pre-adder output registers
   .CEALUMODE(CEALUMODE),           // 1-bit active high clock enable input for ALUMODE registers
   .CEB1(CEB1),                     // 1-bit active high clock enable input for 1st stage B registers
   .CEB2(CEB2),                     // 1-bit active high clock enable input for 2nd stage B registers
   .CEC(CEC),                       // 1-bit active high clock enable input for C registers
   .CECARRYIN(CECARRYIN),           // 1-bit active high clock enable input for CARRYIN register
   .CECTRL(CECTRL),                 // 1-bit active high clock enable input for OPMODE and carry registers
   .CED(CED),                       // 1-bit active high clock enable input for D registers
   .CEM(CEM),                       // 1-bit active high clock enable input for multiplier registers
   .CEP(CEP),                       // 1-bit active high clock enable input for P registers
   .RSTA(RSTA),                     // 1-bit reset input for A pipeline registers
   .RSTALLCARRYIN(RSTALLCARRYIN),   // 1-bit reset input for carry pipeline registers
   .RSTALUMODE(RSTALUMODE),         // 1-bit reset input for ALUMODE pipeline registers
   .RSTB(RSTB),                     // 1-bit reset input for B pipeline registers
   .RSTC(RSTC),                     // 1-bit reset input for C pipeline registers
   .RSTCTRL(RSTCTRL),               // 1-bit reset input for OPMODE pipeline registers
   .RSTD(RSTD),                     // 1-bit reset input for D pipeline registers
   .RSTM(RSTM),                     // 1-bit reset input for multiplier registers
   .RSTP(RSTP)                      // 1-bit reset input for P pipeline registers
);

// End of DSP48E1_inst instantiation
