// FIFO_SYNC_MACRO: Synchronous First-In, First-Out (FIFO) RAM Buffer
//                  Virtex-6
// Xilinx HDL Libraries Guide, version 12.2

FIFO_SYNC_MACRO  #(
   .DEVICE("VIRTEX6"), // Target Device: "VIRTEX5", "VIRTEX6"
   .ALMOST_EMPTY_OFFSET(9'h080), // Sets the almost empty threshold
   .ALMOST_FULL_OFFSET(9'h080),  // Sets almost full threshold
   .DATA_WIDTH(0), // Valid values are 1-72 (37-72 only valid when FIFO_SIZE="36Kb")
   .DO_REG(0),     // Optional output register (0 or 1)
   .FIFO_SIZE ("18Kb"), // Target BRAM: "18Kb" or "36Kb"
   .SIM_MODE("SAFE") // Simulation: "SAFE" vs. "FAST", see "Synthesis and Simulation Design Guide" for details
) FIFO_SYNC_MACRO_inst (
   .ALMOSTEMPTY(ALMOSTEMPTY), // Output almost empty
   .ALMOSTFULL(ALMOSTFULL),   // Output almost full
   .DO(DO),                   // Output data
   .EMPTY(EMPTY),             // Output empty
   .FULL(FULL),               // Output full
   .RDCOUNT(RDCOUNT),         // Output read count
   .RDERR(RDERR),             // Output read error
   .WRCOUNT(WRCOUNT),         // Output write count
   .WRERR(WRERR),             // Output write error
   .CLK(CLK),                 // Input clock
   .DI(DI),                   // Input data
   .RDEN(RDEN),               // Input read enable
   .RST(RST),                 // Input reset
   .WREN(WREN)                // Input write enable
);

// End of FIFO_SYNC_MACRO_inst instantiation
