// MMCM_BASE: Base Mixed Mode Clock Manager
//            Virtex-6
// Xilinx HDL Libraries Guide, version 12.2

MMCM_BASE #(
   .BANDWIDTH("OPTIMIZED"),   // Jitter programming (HIGH,LOW,OPTIMIZED)
   .CLKFBOUT_MULT_F(5.0),     // Multiply value for all CLKOUT (5.0-64.0).
   .CLKFBOUT_PHASE(0.0),      // Phase offset in degrees of CLKFB (0.00-360.00).
   .CLKIN1_PERIOD(0.0),       // Input clock period in nS to ps resolution (i.e. 33.333 is 33 MHz).
   // CLKOUT0_DIVIDE - CLKOUT6_DIVIDE: Divide amount for each CLKOUT (1-128)
   .CLKOUT1_DIVIDE(1),
   .CLKOUT2_DIVIDE(1),
   .CLKOUT3_DIVIDE(1),
   .CLKOUT4_DIVIDE(1),
   .CLKOUT5_DIVIDE(1),
   .CLKOUT6_DIVIDE(1),
   .CLKOUT0_DIVIDE_F(1.0),    // Divide amount for CLKOUT0 (1.000-128.000).
   // CLKOUT0_DUTY_CYCLE - CLKOUT6_DUTY_CYCLE: Duty cycle for each CLKOUT (0.01-0.99).
   .CLKOUT0_DUTY_CYCLE(0.5),
   .CLKOUT1_DUTY_CYCLE(0.5),
   .CLKOUT2_DUTY_CYCLE(0.5),
   .CLKOUT3_DUTY_CYCLE(0.5),
   .CLKOUT4_DUTY_CYCLE(0.5),
   .CLKOUT5_DUTY_CYCLE(0.5),
   .CLKOUT6_DUTY_CYCLE(0.5),
   // CLKOUT0_PHASE - CLKOUT6_PHASE: Phase offset for each CLKOUT (-360.000-360.000).
   .CLKOUT0_PHASE(0.0),
   .CLKOUT1_PHASE(0.0),
   .CLKOUT2_PHASE(0.0),
   .CLKOUT3_PHASE(0.0),
   .CLKOUT4_PHASE(0.0),
   .CLKOUT5_PHASE(0.0),
   .CLKOUT6_PHASE(0.0),
   .CLKOUT4_CASCADE("FALSE"), // Cascase CLKOUT4 counter with CLKOUT6 (TRUE/FALSE)
   .CLOCK_HOLD("FALSE"),      // Hold VCO Frequency (TRUE/FALSE)
   .DIVCLK_DIVIDE(1),         // Master division value (1-80)
   .REF_JITTER1(0.0),         // Reference input jitter in UI (0.000-0.999).
   .STARTUP_WAIT("FALSE")     // Not supported. Must be set to FALSE.
)
MMCM_BASE_inst (
   // Clock Outputs: 1-bit (each) User configurable clock outputs
   .CLKOUT0(CLKOUT0),     // 1-bit CLKOUT0 output
   .CLKOUT0B(CLKOUT0B),   // 1-bit Inverted CLKOUT0 output
   .CLKOUT1(CLKOUT1),     // 1-bit CLKOUT1 output
   .CLKOUT1B(CLKOUT1B),   // 1-bit Inverted CLKOUT1 output
   .CLKOUT2(CLKOUT2),     // 1-bit CLKOUT2 output
   .CLKOUT2B(CLKOUT2B),   // 1-bit Inverted CLKOUT2 output
   .CLKOUT3(CLKOUT3),     // 1-bit CLKOUT3 output
   .CLKOUT3B(CLKOUT3B),   // 1-bit Inverted CLKOUT3 output
   .CLKOUT4(CLKOUT4),     // 1-bit CLKOUT4 output
   .CLKOUT5(CLKOUT5),     // 1-bit CLKOUT5 output
   .CLKOUT6(CLKOUT6),     // 1-bit CLKOUT6 output
   // Feedback Clocks: 1-bit (each) Clock feedback ports
   .CLKFBOUT(CLKFBOUT),   // 1-bit Feedback clock output
   .CLKFBOUTB(CLKFBOUTB), // 1-bit Inverted CLKFBOUT output
   // Status Port: 1-bit (each) MMCM status ports
   .LOCKED(LOCKED),       // 1-bit LOCK output
   // Clock Input: 1-bit (each) Clock input
   .CLKIN1(CLKIN1),
   // Control Ports: 1-bit (each) MMCM control ports
   .PWRDWN(PWRDWN),       // 1-bit Power-down input
   .RST(RST),             // 1-bit Reset input
   // Feedback Clocks: 1-bit (each) Clock feedback ports
   .CLKFBIN(CLKFBIN)      // 1-bit Feedback clock input
);

// End of MMCM_BASE_inst instantiation
