// SYSMON: System Monitor
//         Virtex-6
// Xilinx HDL Libraries Guide, version 12.2

SYSMON #(
   .INIT_40(16'h0000),              // Configuration register 0
   .INIT_41(16'h0000),              // Configuration register 1
   .INIT_42(16'h0800),              // Configuration register 2
   .INIT_43(16'h0000),              // Test register 0
   .INIT_44(16'h0000),              // Test register 1
   .INIT_45(16'h0000),              // Test register 2
   .INIT_46(16'h0000),              // Test register 3
   .INIT_47(16'h0000),              // Test register 4
   .INIT_48(16'h0000),              // Sequence register 0
   .INIT_49(16'h0000),              // Sequence register 1
   .INIT_4A(16'h0000),              // Sequence register 2
   .INIT_4B(16'h0000),              // Sequence register 3
   .INIT_4C(16'h0000),              // Sequence register 4
   .INIT_4D(16'h0000),              // Sequence register 5
   .INIT_4E(16'h0000),              // Sequence register 6
   .INIT_4F(16'h0000),              // Sequence register 7
   .INIT_50(16'h0000),              // Alarm limit register 0
   .INIT_51(16'h0000),              // Alarm limit register 1
   .INIT_52(16'h0000),              // Alarm limit register 2
   .INIT_53(16'h0000),              // Alarm limit register 3
   .INIT_54(16'h0000),              // Alarm limit register 4
   .INIT_55(16'h0000),              // Alarm limit register 5
   .INIT_56(16'h0000),              // Alarm limit register 6
   .INIT_57(16'h0000),              // Alarm limit register 7
   .SIM_DEVICE("VIRTEX5"),          // Device family selection
   .SIM_MONITOR_FILE("design.txt")  // Simulation analog entry file
)
SYSMON_inst (
   .ALM(ALM),                   // 3-bit output alarm for temp, Vccint and Vccaux
   .BUSY(BUSY),                 // 1-bit output ADC busy signal
   .CHANNEL(CHANNEL),           // 5-bit output channel selection
   .DO(DO),                     // 16-bit output data bus for dynamic reconfig
   .DRDY(DRDY),                 // 1-bit output data ready for dynamic reconfig
   .EOC(EOC),                   // 1-bit output end of conversion
   .EOS(EOS),                   // 1-bit output end of sequence
   .JTAGBUSY(JTAGBUSY),         // 1-bit output JTAG DRP busy
   .JTAGLOCKED(JTAGLOCKED),     // 1-bit output DRP port lock
   .JTAGMODIFIED(JTAGMODIFIED), // 1-bit output JTAG write to DRP
   .OT(OT),                     // 1-bit output over temperature alarm
   .CONVST(CONVST),             // 1-bit input convert start
   .CONVSTCLK(CONVSTCLK),       // 1-bit input convert start clock
   .DADDR(DADDR),               // 7-bit input address bus for dynamic reconfig
   .DCLK(DCLK),                 // 1-bit input clock for dynamic reconfig
   .DEN(DEN),                   // 1-bit input enable for dynamic reconfig
   .DI(DI),                     // 16-bit input data bus for dynamic reconfig
   .DWE(DWE),                   // 1-bit input write enable for dynamic reconfig
   .RESET(RESET),               // 1-bit input active high reset
   .VAUXN(VAUXN),               // 16-bit input N-side auxiliary analog input
   .VAUXP(VAUXP),               // 16-bit input P-side auxiliary analog input
   .VN(VN),                     // 1-bit input N-side analog input
   .VP(VP)                      // 1-bit input P-side analog input
);

// End of SYSMON_inst instantiation
