#--BEGIN DESIGN SPECIFIC DATA----------------------------------------------
# 1:environment variables for all configurations
# set ::env(XIL_TIMING_ALLOW_IMPOSSIBLE) 1
# 2:part definition
set PART xc6vlx240t-1-ff1156

# 3:constraints file
set UCF ../../Source/UCF/top_ml605.ucf

# 4:Partition names
# These names must match the actual instance names in the design
set TOP_PART    /top
set RED_PART    ${TOP_PART}/reconfig_red
set GREEN_PART  ${TOP_PART}/reconfig_green
set BLUE_PART   ${TOP_PART}/reconfig_blue

# 5:RM names

set RED_FAST   Red_Fast
set RED_SLOW   Red_Slow
set RED_BB     Red_Blank
set GREEN_FAST Green_Fast
set GREEN_SLOW Green_Slow
set GREEN_BB   Green_Blank
set BLUE_FAST  Blue_Fast
set BLUE_SLOW  Blue_Slow
set BLUE_BB    Blue_Blank
set STATIC     Static

# 6:RM list
# Each RM in the list will be synthesized with bottom-up synthesis.
# You must create a directory for each of the RMs in the list
set RMs [list $RED_FAST $RED_SLOW $GREEN_FAST $GREEN_SLOW $BLUE_FAST $BLUE_SLOW $STATIC]


# 7:Partition Attributes List
##############################################################################
# Create the per-partition attributes list.  This list must be called
# "PartitionAttrsList".  The format is:
#   set PartitionAttrsList <partitionlist>
# where
#   <partitionlist>  ::= { <partitionattrs> ... }
#   <partitionattrs> ::= { <partitionName> <attrslist> }
#   <attrslist>      ::= <namevalpair> ...
#   <namevalpair>    ::= { <attrName> <attrValue> }
##############################################################################

set PartitionAttrsList {
  {/top }
  {/top/reconfig_red {Reconfigurable true}}
  {/top/reconfig_green {Reconfigurable true}}
  {/top/reconfig_blue {Reconfigurable true}}
}
# 8:Configuration Information
##############################################################################
# Create the per-configuration variables.  The format is:
#   set CONFIG1DATA <ConfigList>
#   set CONFIG2DATA <ConfigList>
#     ...
#   set ALL_CFGS [list $CONFIG1DATA $CONFIG2DATA ... ]
# where
#   <ConfigList>        ::= { <ConfigNamePair> <Settings> }
#   <ConfigNamePair>    ::= { 'ConfigName' <Name> }
#   <Settings>          ::= { 'Settings' <SettingsList> }
#   <SettingsList>      ::= <PartSettingsList> ...
#   <PartSettingsList>  ::= <partitionName> <namevalpair> ...
##############################################################################

# Configuration FastConfig settings.
# Everything is implemented and `
#there is no import location

set CONFIG_FastConfig {
  {ConfigName CfgFast}
  {Settings
    {/top	{State implement} }
    {/top/reconfig_red	{State implement} {NetlistDir Red_Fast} {ModName Red_Fast } }
    {/top/reconfig_green	{State implement} {NetlistDir Green_Fast} {ModName Green_Fast} }
    {/top/reconfig_blue	{State implement} {NetlistDir Blue_Fast} {ModName Blue_Fast} }
   }
}

# Configuration SlowConfig settings.
#Static is imported from the FastConfig
set CONFIG_SlowConfig {
  {ConfigName CfgSlow}
  {Settings
    {/top	{State import} {ImportLocation ../XCfgFast} }
    {/top/reconfig_red	{State implement} {NetlistDir Red_Slow} {ModName Red_Slow} }
    {/top/reconfig_green	{State implement} {NetlistDir Green_Slow} {ModName Green_Slow} }
    {/top/reconfig_blue	{State implement} {NetlistDir Blue_Slow} {ModName Blue_Slow} }
  }
}
# Configuration FSFConfig settings.
#All 4 partitions are imported.
set CONFIG_FSFConfig {
  {ConfigName CfgFSF}
  {Settings
    {/top	{State import} {ImportLocation ../XCfgFast} }
    {/top/reconfig_red	{State import} {ImportLocation ../XCfgFast} {NetlistDir Red_Fast} {ModName Red_Fast} }
    {/top/reconfig_green	{State import} {ImportLocation ../XCfgFast} {NetlistDir Green_Fast} {ModName Green_Fast} }
    {/top/reconfig_blue	{State import} {ImportLocation ../XCfgSlow} {NetlistDir Blue_Slow} {ModName Blue_Slow} }
  }
}
# Configuration BlankConfig settings.
set CONFIG_BlankConfig {
  {ConfigName CfgBlank}
  {Settings
    {/top	{State import} {ImportLocation ../XCfgFast} }
    {/top/reconfig_red	{State implement} {NetlistDir Red_Blank} {ModName Red_Blank} }
    {/top/reconfig_green	{State implement} {NetlistDir Green_Blank} {ModName Green_Blank} }
    {/top/reconfig_blue	{State implement} {NetlistDir Blue_Blank} {ModName Blue_Blank} }
  }
}

# 9:List of configurations in order of implementation
# finally, build the list of all the configuration data.
# This list will drive the implementation of all configurations,
# in the order they are listed
set ALL_CFGS [list $CONFIG_FastConfig $CONFIG_SlowConfig $CONFIG_FSFConfig $CONFIG_BlankConfig]
# 10:Implementation options
# set the optional implementation data flags.
# The format of the optional data is:
# SYNTH_TOOL="xst" or "synplify_pro"
# RUN_RM_SYNTH=NO if the design has no modules to be synthesized bottom-up
# RUN_CFG_SYNTH=YES if you want "static" to be resynthesized for each configuration
# NGDBUILD_TOP=<top_path> is path to pre-existing top module for Ngdbuild
# NGDBUILD_SEARCH=<search_path ...> a string containing search path directories
# NGDBUILD_OPTS=<ngdbuild_command_line_options> optional command line options for Ngdbuild
# RUN_NGDBUILD=NO if you do not want to run NGDBuild
# RUN_MAP=NO if you do not want to run Map
# MAP_OPTS=<map_command_line_options> optional command line options for Map
# RUN_PAR=NO if you do not want to run PAR
# PAR_OPTS=<par_command_line_options> optional command line options for Par
# RUN_BITGEN=NO if you do not want to generate bitstreams
array set IMPLEMENTATION_DATA { \
                               SYNTH_TOOL "xst" \
                               RUN_RM_SYNTH YES \
                               RUN_CFG_SYNTH NO \
                               NGDBUILD_TOP ../Static/top.ngc \
                               RUN_NGDBUILD YES \
                               RUN_MAP YES \
                               RUN_PAR YES \
                               RUN_BITGEN YES \
			       			      }
#--END DESIGN SPECIFIC DATA------------------------------------------------
