-- JTAG_SIM_VIRTEX4: JTAG Interface Simulation Model
--                   Virtex-4
-- Xilinx HDL Libraries Guide, version 12.2

JTAG_SIM_VIRTEX4_inst : JTAG_SIM_VIRTEX4 
generic map (
   PART_NAME => "LX15") -- Specify target V4 device. Possible values are:
                        -- "LX15", "LX25", "LX40", "LX60", "LX80", "LX100"
                        -- "LX160", "LX200", "SX25", "SX35", "SX55", "FX12"
                        -- "FX20"
port map (
   TDO => TDO,         -- JTAG data output (1-bit)
   TCK => TCK,         -- Clock input (1-bit)
   TDI => TDI,         -- JTAG data input (1-bit)
   TMS => TMS          -- JTAG command input (1-bit)
);

[VHDL.Device Primitive Instantiation.Virtex-4.Config/BSCAN Components.Capture (CAPTURE_VIRTEX4)]
type=template
-- CAPTURE_VIRTEX4 : In order to incorporate this function into the design,
--      VHDL       : the following instance declaration needs to be placed
--    instance     : in the body of the design code.  The instance name
--   declaration   : (CAPTURE_VIRTEX4_inst) and/or the port declarations after the
--      code       : "=>" assignment maybe changed to properly reference and
--                 : connect this function to the design. All inputs must be
--                 : connected.

--     Library     : In addition to adding the instance declaration, a use
--   declaration   : statement for the UNISIM.vcomponents library needs to be
--       for       : added before the entity declaration.  This library
--     Xilinx      : contains the component declarations for all Xilinx
--    primitives   : primitives and points to the models that will be used
--                 : for simulation.

--  Copy the following two statements and paste them before the
--  Entity declaration, unless they already exist.

Library UNISIM;
use UNISIM.vcomponents.all;

--  <-----Cut code below this line and paste into the architecture body---->

-- CAPTURE_VIRTEX4: Register State Capture for Bitstream Readback
--                  Virtex-4
-- Xilinx HDL Libraries Guide, version 12.2

CAPTURE_VIRTEX4_inst : CAPTURE_VIRTEX4
generic map (
   ONESHOT => TRUE) -- TRUE or FALSE
port map (
   CAP => CAP,    -- Capture input
   CLK => CLK     -- Clock input
);
-- End of CAPTURE_VIRTEX4_inst instantiation
