-- RAMB16: 16k+2k Parity Paramatizable BlockRAM
--         Virtex-4
-- Xilinx HDL Libraries Guide, version 12.2

RAMB16_inst : RAMB16
generic map (
   DOA_REG => 0, -- Optional output registers on the A port (0 or 1)
   DOB_REG => 0, -- Optional output registers on the B port (0 or 1)
   INIT_A => X"000000000", --  Initial values on A output port
   INIT_B => X"000000000", --  Initial values on B output port
   INVERT_CLK_DOA_REG => FALSE, -- Invert clock on A port output registers (TRUE or FALSE)
   INVERT_CLK_DOB_REG => FALSE, -- Invert clock on B port output registers (TRUE or FALSE)
   RAM_EXTENSION_A => "NONE", -- "UPPER", "LOWER" or "NONE" when cascaded
   RAM_EXTENSION_B => "NONE", -- "UPPER", "LOWER" or "NONE" when cascaded
   READ_WIDTH_A => 0, -- Valid values are 1,2,4,9,18 or 36 
   READ_WIDTH_B => 0, -- Valid values are 1,2,4,9,18 or 36 
   SIM_COLLISION_CHECK => "ALL", -- Collision check enable "ALL", "WARNING_ONLY", 
                                 -- "GENERATE_X_ONLY" or "NONE" 
   SRVAL_A => X"000000000", --  Port A output value upon SSR assertion
   SRVAL_B => X"000000000", --  Port B output value upon SSR assertion
   WRITE_MODE_A => "WRITE_FIRST", --  WRITE_FIRST, READ_FIRST or NO_CHANGE
   WRITE_MODE_B => "WRITE_FIRST", --  WRITE_FIRST, READ_FIRST or NO_CHANGE
   WRITE_WIDTH_A => 0, -- Valid values are 1,2,4,9,18 or 36
   WRITE_WIDTH_B => 0, -- Valid values are 1,2,4,9,18 or 36 
   -- The following INIT_xx declarations specify the initial contents of the RAM
   INIT_00 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_01 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_02 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_03 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_04 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_05 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_06 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_07 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_08 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_09 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_0A => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_0B => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_0C => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_0D => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_0E => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_0F => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_10 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_11 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_12 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_13 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_14 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_15 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_16 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_17 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_18 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_19 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_1A => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_1B => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_1C => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_1D => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_1E => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_1F => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_20 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_21 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_22 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_23 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_24 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_25 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_26 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_27 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_28 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_29 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_2A => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_2B => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_2C => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_2D => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_2E => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_2F => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_30 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_31 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_32 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_33 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_34 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_35 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_36 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_37 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_38 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_39 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_3A => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_3B => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_3C => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_3D => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_3E => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_3F => X"0000000000000000000000000000000000000000000000000000000000000000",
   -- The next set of INITP_xx are for the parity bits
   INITP_00 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INITP_01 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INITP_02 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INITP_03 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INITP_04 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INITP_05 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INITP_06 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INITP_07 => X"0000000000000000000000000000000000000000000000000000000000000000")
port map (
   CASCADEOUTA => CASCADEOUTA, -- 1-bit cascade output
   CASCADEOUTB => CASCADEOUTB, -- 1-bit cascade output
   DOA => DOA,      -- 32-bit A port Data Output
   DOB => DOB,      -- 32-bit B port Data Output
   DOPA => DOPA,    -- 4-bit  A port Parity Output
   DOPB => DOPB,    -- 4-bit  B port Parity Output
   ADDRA => ADDRA,  -- 15-bit A port Address Input
   ADDRB => ADDRB,  -- 15-bit B port Address Input
   CASCADEINA => CASCADEINA, -- 1-bit cascade A input
   CASCADEINB => CASCADEINB, -- 1-bit cascade B input
   CLKA => CLKA,    -- Port A Clock
   CLKB => CLKB,    -- Port B Clock
   DIA => DIA,      -- 32-bit A port Data Input
   DIB => DIB,      -- 32-bit B port Data Input
   DIPA => DIPA,    -- 4-bit  A port parity Input
   DIPB => DIPB,    -- 4-bit  B port parity Input
   ENA => ENA,      -- 1-bit  A port Enable Input
   ENB => ENB,      -- 1-bit  B port Enable Input
   REGCEA => REGCEA, -- 1-bit A port register enable input
   REGCEB => REGCEB, -- 1-bit B port register enable input
   SSRA => SSRA,    -- 1-bit  A port Synchronous Set/Reset Input
   SSRB => SSRB,    -- 1-bit  B port Synchronous Set/Reset Input
   WEA => WEA,      -- 4-bit  A port Write Enable Input
   WEB => WEB       -- 4-bit  B port Write Enable Input
);

-- End of RAMB16_inst instantiation
