-- SYSMON: System Monitor
--         Virtex-5
-- Xilinx HDL Libraries Guide, version 12.2

SYSMON_inst : SYSMON
generic map (
   INIT_40 => X"0000", -- Configuration register 0
   INIT_41 => X"0000", -- Configuration register 1
   INIT_42 => X"0000", -- Configuration register 2
   INIT_43 => X"0000", -- Test register 0
   INIT_44 => X"0000", -- Test register 1
   INIT_45 => X"0000", -- Test register 2
   INIT_46 => X"0000", -- Test register 3
   INIT_47 => X"0000", -- Test register 4
   INIT_48 => X"0000", -- Sequence register 0
   INIT_49 => X"0000", -- Sequence register 1
   INIT_4A => X"0000", -- Sequence register 2
   INIT_4B => X"0000", -- Sequence register 3
   INIT_4C => X"0000", -- Sequence register 4
   INIT_4D => X"0000", -- Sequence register 5
   INIT_4E => X"0000", -- Sequence register 6
   INIT_4F => X"0000", -- Sequence register 7
   INIT_50 => X"0000", -- Alarm limit register 0
   INIT_51 => X"0000", -- Alarm limit register 1
   INIT_52 => X"0000", -- Alarm limit register 2
   INIT_53 => X"0000", -- Alarm limit register 3
   INIT_54 => X"0000", -- Alarm limit register 4
   INIT_55 => X"0000", -- Alarm limit register 5
   INIT_56 => X"0000", -- Alarm limit register 6
   INIT_57 => X"0000", -- Alarm limit register 7
   SIM_MONITOR_FILE => "design.txt") -- Simulation analog entry file
port map (
   ALM => ALM,           -- 3-bit output for temp, Vccint and Vccaux
   BUSY => BUSY,         -- 1-bit output ADC busy signal
   CHANNEL => CHANNEL,   -- 5-bit output channel selection
   DO => DO,             -- 16-bit output data bus for dynamic reconfig
   DRDY => DRDY,         -- 1-bit output data ready for dynamic reconfig
   EOC => EOC,           -- 1-bit output end of conversion
   EOS => EOS,           -- 1-bit output end of sequence
   JTAGBUSY => JTAGBUSY, -- 1-bit output JTAG DRP busy
   JTAGLOCKED => JTAGLOCKED, -- 1-bit output DRP port lock
   JTAGMODIFIED => JTAGMODIFIED, -- 1-bit output JTAG write to DRP
   OT => OT,             -- 1-bit output over temperature alarm
   CONVST => CONVST,     -- 1-bit input convert start
   CONVSTCLK => CONVSTCLK, -- 1-bit input convert start clock
   DADDR => DADDR,       -- 7-bit input address bus for dynamic reconfig
   DCLK => DCLK,         -- 1-bit input clock for dynamic reconfig
   DEN => DEN,           -- 1-bit input enable for dynamic reconfig
   DI => DI,             -- 16-bit input data bus for dynamic reconfig
   DWE => DWE,           -- 1-bit input write enable for dynamic reconfig
   RESET => RESET,       -- 1-bit input active high reset
   VAUXN => VAUXN,       -- 16-bit input N-side auxiliary analog input
   VAUXP => VAUXP,       -- 16-bit input P-side auxiliary analog input
   VN => VN,             -- 1-bit input N-side analog input
   VP => VP)              -- 1-bit input P-side analog input
);

-- End of SYSMON_inst instantiation
