-- FIFO18E1: 18KB FIFO (First In, First Out) Block RAM Memory
--           Virtex-6
-- Xilinx HDL Libraries Guide, version 12.3

FIFO18E1_inst : FIFO18E1
generic map (
   ALMOST_EMPTY_OFFSET => X"00080",  -- Sets the almost empty threshold
   ALMOST_FULL_OFFSET => X"00080",   -- Sets almost full threshold
   DATA_WIDTH => 4,                  -- Sets data width to 4, 9, 18, or 36
   DO_REG => 1,                      -- Enable output register (0 or 1) Must be 1 if EN_SYN = FALSE
   EN_SYN => FALSE,                  -- Specifies FIFO as dual-clock (FALSE) or Synchronous (TRUE)
   FIFO_MODE => "FIFO18",            -- Sets mode to FIFO18 or FIFO18_36
   FIRST_WORD_FALL_THROUGH => FALSE, -- Sets the FIFO FWFT to TRUE or FALSE
   INIT => X"000000000",             -- Initial values on output port
   SRVAL => X"000000000"             -- Set/Reset value for output port
)
port map (
   -- Read Data: 32-bit (each) Read output data
   DO => DO,                   -- 32-bit data output
   DOP => DOP,                 -- 4-bit parity data output
   -- Status: 1-bit (each) Flags and other FIFO status outputs
   ALMOSTEMPTY => ALMOSTEMPTY, -- 1-bit almost empty output flag
   ALMOSTFULL => ALMOSTFULL,   -- 1-bit almost full output flag
   EMPTY => EMPTY,             -- 1-bit empty output flag
   FULL => FULL,               -- 1-bit full output flag
   RDCOUNT => RDCOUNT,         -- 12-bit read count output
   RDERR => RDERR,             -- 1-bit read error output
   WRCOUNT => WRCOUNT,         -- 12-bit write count output
   WRERR => WRERR,             -- 1-bit write error
   -- Read Control Signals: 1-bit (each) Read clock, enable and reset input signals
   RDCLK => RDCLK,             -- 1-bit read clock input
   RDEN => RDEN,               -- 1-bit read enable input
   REGCE => REGCE,             -- 1-bit clock enable input
   RST => RST,                 -- 1-bit reset input
   RSTREG => RSTREG,           -- 1-bit output register set/reset
   -- Write Control Signals: 1-bit (each) Write clock and enable input signals
   WRCLK => WRCLK,             -- 1-bit write clock input
   WREN => WREN,               -- 1-bit write enable input
   -- Write Data: 32-bit (each) Write input data
   DI => DI,                   -- 32-bit data input
   DIP => DIP                  -- 4-bit parity input
);

-- End of FIFO18E1_inst instantiation
