----------------------------------------------------------------------------------
-- Company: Xilinx, Inc.
-- Engineer: Eddie Vergara
-- 
-- Create Date:    08:38:05 03/16/2009 
-- Design Name:    DRP Demo - Top 
-- Module Name:    drp_demo - Behavioral 
-- Project Name:   DRP Demo
-- Target Devices: xc5vlx30
-- Tool versions:  11.1
-- Description:    This unit connects instantiations of the Virtex-5 DCM macro 
--                 and DRP controller to the external I/O.
--
----------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity drp_demo is
    Port ( 
           --Clock and Reset
    	   clk_in : in  STD_LOGIC;
           drp_stmach_reset : in STD_LOGIC;
	   user_dcm_reset : in STD_LOGIC;
	   
	   --DRP User Interface
           drp_start : in  STD_LOGIC;
	   drp_current_mode : in STD_LOGIC;
	   drp_change_mode : in STD_LOGIC;
	   
	   drp_multiply, drp_divide : in STD_LOGIC_VECTOR (0 to 7);
	   
	   --DCM Outputs
	   dcm_clk0_out : out STD_LOGIC;
           dcm_clkfx_out : out  STD_LOGIC;
	   
	   --Monitor Signals
	   dcm_locked : out STD_LOGIC;
           drp_done : out STD_LOGIC);
end drp_demo;

architecture Behavioral of drp_demo is

        COMPONENT drp_dcm
	PORT(
		CLKIN_IN : IN std_logic;
		DADDR_IN : IN std_logic_vector(6 downto 0);
		DCLK_IN : IN std_logic;
		DEN_IN : IN std_logic;
		DI_IN : IN std_logic_vector(15 downto 0);
		DWE_IN : IN std_logic;
		RST_IN : IN std_logic;          
		CLK0_OUT : OUT std_logic;
		CLKFX_OUT : OUT std_logic;
		DRDY_OUT : OUT std_logic;
		LOCKED_OUT : OUT std_logic
		);
	END COMPONENT;
	
	COMPONENT drp_stmach 
        Port ( clk : in  STD_LOGIC;
           start : in  STD_LOGIC;
           reset : in  STD_LOGIC;
	   
           new_freq_mode : in STD_LOGIC;
           
	   drp_ready : in  STD_LOGIC;
           drp_en : out  STD_LOGIC;
           drp_we : out  STD_LOGIC;
           drp_addr : out  STD_LOGIC_VECTOR (6 downto 0);
           drp_sel : out STD_LOGIC;
	   
	   dcm_locked : in  STD_LOGIC;
           dcm_reset : out  STD_LOGIC;
	   
	   drp_done : out  STD_LOGIC);
	END COMPONENT;
	
	signal DEN_IN, DWE_IN, RST_IN, DRDY, LOCKED : std_logic;
	signal DI_IN : std_logic_vector(15 downto 0);
	signal DADDR_IN : std_logic_vector(6 downto 0);
	signal DRP_SEL : std_logic;
	signal dcm_reset_stmach : std_logic;
	
begin

        Inst_drp_dcm: drp_dcm PORT MAP(
		CLKIN_IN => CLK_IN,
		DADDR_IN => DADDR_IN,
		DCLK_IN => CLK_IN,
		DEN_IN => DEN_IN,
		DI_IN => DI_IN,
		DWE_IN => DWE_IN,
		RST_IN => RST_IN,
		CLKFX_OUT => dcm_clkfx_out,
		CLK0_OUT => dcm_clk0_out,
		DRDY_OUT => DRDY,
		LOCKED_OUT => LOCKED
	);
		
	Inst_drp_stmach: drp_stmach PORT MAP(
	   clk => CLK_IN,
           start => drp_start,
           reset => drp_stmach_reset,
	   
           new_freq_mode => drp_change_mode,
	   
	   drp_ready => DRDY,
           drp_en => DEN_IN,
           drp_we => DWE_IN,
           drp_addr => DADDR_IN,
	   drp_sel => drp_sel,
	   
	   dcm_locked => LOCKED,
           dcm_reset => dcm_reset_stmach,
	   
	   drp_done => drp_done
	   );
	   
DCM_RESET : process(clk_in)
	begin
		if (clk_in = '1' and clk_in'event) then
			if (drp_stmach_reset = '1') then
				RST_IN <= '1';
			else
				RST_IN <= dcm_reset_stmach or user_dcm_reset;
			end if;
		end if;
end process;

DI_IN(15 downto 8)<= x"00" when drp_sel = '1' else
	 drp_multiply;
	 
DI_IN(7 downto 0)<= ("00000" & drp_current_mode & "00")  when drp_sel = '1' else
	 drp_divide;

dcm_locked <= LOCKED;

	
end Behavioral;

