library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

library STD;
use STD.TEXTIO.all;

package drp_tb_pkg is

   function period_check (
	test : in integer; 
	current, previous, expected : time) 
    return boolean;

end;

package body drp_tb_pkg is


    function period_check (
	test : in integer; 
	current, previous, expected : time) 
    return boolean is

	    variable Message : line;
	    variable actual : time;
	    variable pass : boolean;
   

	 BEGIN

		actual := current - previous;

		if(actual = expected) then

			Write ( Message, LF);
			Write ( Message, string'("-- Test "));
			Write ( Message, test);
			Write ( Message, string'(": *END* - SUCCESS - CLKFX actual period matches expected: "));
			Write ( Message, actual);
			Write ( Message, LF);
			assert false report "" severity note;
			writeline(output, Message);
			pass := true;

		else

			Write ( Message, LF);
			Write ( Message, string'("-- Test "));
			Write ( Message, test);
			Write ( Message, string'(": *END* - FAILURE - CLKFX actual period does not match expected! "));
			Write ( Message, LF);
			Write ( Message, string'("Expected: "));
			Write ( Message, expected);
			Write ( Message, string'(" -- Actual: "));
			Write ( Message, actual);
			Write ( Message, LF);
			assert false report "" severity warning;
			writeline(output, Message);
			pass := false;

		end if;

		return pass;

	end function;
end package body;