//////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2005-2010 Xilinx, Inc.
// This design is confidential and proprietary of Xilinx, Inc.
// All Rights Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /   Vendor: Xilinx
// \   \   \/    Version: 12.1
//  \   \        Application: Partial Reconfiguration
//  /   /        Filename: blue_slow.v
// /___/   /\    Date Last Modified: 11 July 2009
// \   \  /  \   
//  \___\/\___\
// Device: Virtex-6
// Design Name: Color2
// Purpose: Partial Reconfiguration User Guide
///////////////////////////////////////////////////////////////////////////////
// slow blinking LED, DVI_out modified

module rm_blue (
	rst_n, 
	clk, 
	out,
	DVI_in0,
	DVI_in1,
	DVI_in2,
	DVI_in3,
	DVI_in4,
	DVI_in5,
	DVI_in6,
	DVI_in7,
	DVI_out0,
	DVI_out1,
	DVI_out2,
	DVI_out3,
	DVI_out4,
	DVI_out5,
	DVI_out6,
	DVI_out7);

   input rst_n;            // Active high reset, synchronous with 27MHz clock
   input clk;              // 100MHz input clock
   input  DVI_in0, DVI_in1, DVI_in2, DVI_in3,
          DVI_in4, DVI_in5, DVI_in6, DVI_in7;     // DVI_B input signal from DVI module
   output out;             // Output to LED
   output DVI_out0, DVI_out1, DVI_out2, DVI_out3,
          DVI_out4, DVI_out5, DVI_out6, DVI_out7; // modified DVI_B output signal
  
// change the color space here
   assign DVI_out0 = 1 | DVI_in0;
   assign DVI_out1 =  DVI_in1;
   assign DVI_out2 = 1 | DVI_in2;
   assign DVI_out3 =  DVI_in3;
   assign DVI_out4 = 1 | DVI_in4;
   assign DVI_out5 =  DVI_in5;
   assign DVI_out6 = 1 | DVI_in6;
   assign DVI_out7 =  DVI_in7;

	led_slow led_slow_inst (rst_n, clk, out);   

endmodule
