//////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2005-2010 Xilinx, Inc.
// This design is confidential and proprietary of Xilinx, Inc.
// All Rights Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /   Vendor: Xilinx
// \   \   \/    Version: 12.1
//  \   \        Application: Partial Reconfiguration
//  /   /        Filename: led_slow.v
// /___/   /\    Date Last Modified: 11 July 2009
// \   \  /  \   
//  \___\/\___\
// Device: Virtex-6
// Design Name: Color2
// Purpose: Partial Reconfiguration User Guide
///////////////////////////////////////////////////////////////////////////////
// slow blinking LED

module led_slow(
   rst_n, 
   clk, 
   led_out);
	
   input rst_n;                       
   input clk;                         
   output led_out;

   reg led_out;
   reg [27:0] count; // Counts lines in each frame

   assign reset = ~rst_n;

   always @(posedge clk)
     if (reset)
       begin
         count <= 0;
       end
     else
     	 begin
     	   count <= count + 1;
     	   led_out <= count[27];
     	 end

endmodule
