-- FIFO36_72: 72x36k Synchronous/Asynchronous BlockRAM FIFO /w ECC
--            Virtex-5 
-- Xilinx HDL Libraries Guide, version 12.3

FIFO36_72_inst : FIFO36_72
generic map (
   ALMOST_FULL_OFFSET => X"0080",  -- Sets almost full threshold
   ALMOST_EMPTY_OFFSET => X"0080", -- Sets the almost empty threshold
   DO_REG => 1,                    -- Enable output register (0 or 1)
                                   -- Must be 1 if EN_SYN = FALSE 
   EN_ECC_READ => FALSE,           -- Enable ECC decoder, TRUE or FALSE
   EN_ECC_WRITE => FALSE,          -- Enable ECC encoder, TRUE or FALSE
   EN_SYN => FALSE,                -- Specifies FIFO as Asynchronous (FALSE)
                                   -- or Synchronous (TRUE)
   FIRST_WORD_FALL_THROUGH => FALSE, -- Sets the FIFO FWFT to TRUE or FALSE
   SIM_MODE => "SAFE") -- Simulation: "SAFE" vs "FAST", see "Synthesis and Simulation
                       -- Design Guide" for details
port map (
   ALMOSTEMPTY => ALMOSTEMPTY,   -- 1-bit almost empty output flag
   ALMOSTFULL => ALMOSTFULL,     -- 1-bit almost full output flag
   DBITERR => DBITERR            -- 1-bit double bit error status output
   DO => DO,                     -- 64-bit data output
   DOP => DOP,                   -- 4-bit parity data output
   ECCPARITY => ECCPARITY        -- 8-bit generated error correction parity
   EMPTY => EMPTY,               -- 1-bit empty output flag
   FULL => FULL,                 -- 1-bit full output flag
   RDCOUNT => RDCOUNT,           -- 9-bit read count output
   RDERR => RDERR,               -- 1-bit read error output
   WRCOUNT => WRCOUNT,           -- 9-bit write count output
   WRERR => WRERR,               -- 1-bit write error
   DI => DI,                     -- 64-bit data input
   DIP => DIP,                   -- 4-bit parity input
   RDCLK => RDCLK,               -- 1-bit read clock input
   RDEN => RDEN,                 -- 1-bit read enable input
   RST => RST,                   -- 1-bit reset input
   WRCLK => WRCLK,               -- 1-bit write clock input
   WREN => WREN                  -- 1-bit write enable input
);

-- End of FIFO36_72_inst instantiation
