// IDDR: Input Double Data Rate Input Register with Set, Reset
//       and Clock Enable.
//       Virtex-5/6
// Xilinx HDL Libraries Guide, version 12.3

IDDR #(
   .DDR_CLK_EDGE("OPPOSITE_EDGE"), // "OPPOSITE_EDGE", "SAME_EDGE" 
                                   //    or "SAME_EDGE_PIPELINED" 
   .INIT_Q1(1'b0), // Initial value of Q1: 1'b0 or 1'b1
   .INIT_Q2(1'b0), // Initial value of Q2: 1'b0 or 1'b1
   .SRTYPE("SYNC") // Set/Reset type: "SYNC" or "ASYNC" 
) IDDR_inst (
   .Q1(Q1), // 1-bit output for positive edge of clock 
   .Q2(Q2), // 1-bit output for negative edge of clock
   .C(C),   // 1-bit clock input
   .CE(CE), // 1-bit clock enable input
   .D(D),   // 1-bit DDR data input
   .R(R),   // 1-bit reset
   .S(S)    // 1-bit set
);

// End of IDDR_inst instantiation
