// FIFO16: BlockRAM Asynchronous FIFO configured for 4k deep x 4 wide
//         Virtex-4 
// Xilinx HDL Libraries Guide, version 12.4

wire [27:0] unconnected;

FIFO16 #(
   .ALMOST_FULL_OFFSET(12'h080),     // Sets almost full threshold
   .ALMOST_EMPTY_OFFSET(12'h080),    // Sets the almost empty threshold
   .DATA_WIDTH(4),                   // Sets data width to 4, 9, 18, or 36
   .FIRST_WORD_FALL_THROUGH("FALSE") // Sets the FIFO FWFT to "TRUE" or "FALSE" 
) FIFO16_4kx4_inst (
   .ALMOSTEMPTY(ALMOSTEMPTY),    // 1-bit almost empty output flag
   .ALMOSTFULL(ALMOSTFULL),      // 1-bit almost full output flag
   .DO({unconnected[27:0], DO}), // 4-bit data output
   .EMPTY(EMPTY),          // 1-bit empty output flag
   .FULL(FULL),            // 1-bit full output flag
   .RDCOUNT(RDCOUNT),      // 12-bit read count output
   .RDERR(RDERR),          // 1-bit read error output
   .WRCOUNT(WRCOUNT),      // 12-bit write count output
   .WRERR(WRERR),          // 1-bit write error
   .DI({28'h0000000, DI}), // 4-bit data input (rest tied to ground)
   .DIP(4'h0),             // Parity bits tied to Ground
   .RDCLK(RDCLK),          // 1-bit read clock input
   .RDEN(RDEN),            // 1-bit read enable input
   .RST(RST),              // 1-bit reset input
   .WRCLK(WRCLK),          // 1-bit write clock input
   .WREN(WREN)             // 1-bit write enable input
);   

// End of FIFO16_4kx4_inst instantiation
