// PMCD: Phase-Matched Clock Divider Circuit
//       Virtex-4
// Xilinx HDL Libraries Guide, version 12.4

PMCD #(
   .EN_REL("FALSE"),  // TRUE/FALSE to allow synchronous deassertion of RST
   .RST_DEASSERT_CLK("CLKA") // Reset syncronization to which clock: CLKA, CLKB, CLKC or CLKD
) PMCD_inst (
   .CLKA1(CLKA1),     // Output CLKA divided by 1
   .CLKA1D2(CLKA1D2), // Output CLKA divided by 2
   .CLKA1D4(CLKA1D4), // Output CLKA divided by 4
   .CLKA1D8(CLKA1D8), // Output CLKA divided by 8
   .CLKB1(CLKB1),     // Output phase matched CLKB
   .CLKC1(CLKC1),     // Output phase matched CLKC
   .CLKD1(CLKD1),     // Output phase matched CLKD
   .CLKA(CLKA),       // Input CLKA
   .CLKB(CLKB),       // Input CLKB
   .CLKC(CLKC),       // Input CLKC
   .CLKD(CLKD),       // Input CLKD
   .REL(REL),         // PCMD release input
   .RST(RST)          // Active high reset input
);

// End of PMCD_inst instantiation
