-- ISERDES_NODELAY: Input SERial / DESerializer
--                  Virtex-5
-- Xilinx HDL Libraries Guide, version 13.1

ISERDES_NODELAY_inst : ISERDES_NODELAY
generic map (
   BITSLIP_ENABLE => FALSE, -- TRUE/FALSE to enable bitslip controller
                            --   Must be "FALSE" in interface type is "MEMORY"
   DATA_RATE => "DDR", -- Specify data rate of "DDR" or "SDR" 
   DATA_WIDTH => 4, -- Specify data width - 
                    --  NETWORKING SDR: 2, 3, 4, 5, 6, 7, 8 : DDR 4, 6, 8, 10
                    --  MEMORY SDR N/A : DDR 4
   INTERFACE_TYPE => "MEMORY", -- Use model - "MEMORY" or "NETWORKING" 
   NUM_CE => 2, -- Define number or clock enables to an integer of 1 or 2
   SERDES_MODE => "MASTER") --Set SERDES mode to "MASTER" or "SLAVE" 
port map (
   Q1 => Q1,  -- 1-bit registered SERDES output
   Q2 => Q2,  -- 1-bit registered SERDES output
   Q3 => Q3,  -- 1-bit registered SERDES output
   Q4 => Q4,  -- 1-bit registered SERDES output
   Q5 => Q5,  -- 1-bit registered SERDES output
   Q6 => Q6,  -- 1-bit registered SERDES output
   SHIFTOUT1 => SHIFTOUT1, -- 1-bit cascade Master/Slave output
   SHIFTOUT2 => SHIFTOUT2, -- 1-bit cascade Master/Slave output
   BITSLIP => BITSLIP,     -- 1-bit Bitslip enable input
   CE1 => CE1,        -- 1-bit clock enable input
   CE2 => CE2,        -- 1-bit clock enable input
   CLK => CLK,        -- 1-bit master clock input
   CLKB => CLKB,        -- 1-bit secondary clock input for DATA_RATE=DDR
   CLKDIV => CLKDIV,  -- 1-bit divided clock input
   D => D,            -- 1-bit data input, connects to IODELAY or input buffer
   OCLK => OCLK,      -- 1-bit fast output clock input
   RST => RST,        -- 1-bit asynchronous reset input
   SHIFTIN1 => SHIFTIN1, -- 1-bit cascade Master/Slave input
   SHIFTIN2 => SHIFTIN2 -- 1-bit cascade Master/Slave input
);

-- End of ISERDES_NODELAY_inst instantiation
