#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

typedef union {
    unsigned int i;
    float f;
} int32_float_t;

static const int N_SAMPLES = 16384;

void write_fft_data(const char *file) {
    int32_float_t re, im;
    int i;

    FILE *fp = fopen(file, "w+");
    if (!fp) {
        fprintf(stderr, "Could not write data to '%s'.\n", file);
        exit(1);
    }

    im.i = 0;
    for (i = 0; i < N_SAMPLES; i++) {
        re.f = sinf(2 * ((float)i / N_SAMPLES) * M_PI);
        fprintf(fp, "%08x %08x\n", re.i, im.i);
    }

    fclose(fp);
}

void read_fft_data(const char *file) {
    int32_float_t re, im;
    int i;

    FILE *fp = fopen(file, "r");
    if (!fp) {
        fprintf(stderr, "Could not read data from '%s'.\n", file);
        exit(1);
    }

    for (i = 0; i < N_SAMPLES; i++) {
        if (feof(fp)) {
            fprintf(stderr, "Could not read enough data from '%s'.\n", file);
            exit(1);
        }
        fscanf(fp, "%08x %08x\n", &re.i, &im.i);
        printf("%g %g\n", re.f, im.f);
    }

    fclose(fp);
}

int main(int argc, char **argv) {
    if (argc != 3) {
        printf("Usage: %s [read|write] <file>", argv[0]);
        return 0;
    }

    const char *operation = argv[1];
    const char *file = argv[2];

    if (strcmp(operation, "read") == 0) {
        read_fft_data(file);
    }
    else if (strcmp(operation, "write") == 0) {
        write_fft_data(file);
    }
    else {
        fprintf(stderr, "Invalid operation '%s'. Operation must be either 'read' or 'write'.\n", operation);
    }

    return 0;
}
