`timescale 1ns / 1ps

module fp_fft_top (
  clk,
  fft_start,
  fft_xn_re,
  fft_xn_im,
  fft_fwd_inv,
  fft_fwd_inv_we,
  fft_rfd,
  fft_xn_index,
  fft_busy,
  fft_edone,
  fft_done,
  fft_dv,
  fft_xk_index,
  fft_xk_re,
  fft_xk_im
);

  input          clk;
  input          fft_start;
  input  [31:0]  fft_xn_re;
  input  [31:0]  fft_xn_im;
  input          fft_fwd_inv;
  input          fft_fwd_inv_we;
  output         fft_rfd;
  output [13:0]  fft_xn_index;
  output         fft_busy;
  output         fft_edone;
  output         fft_done;
  output         fft_dv;
  output [13:0]  fft_xk_index;
  output [31:0]  fft_xk_re;
  output [31:0]  fft_xk_im;

  fp_fft_core fft (
    .clk        ( clk ),
    .start      ( fft_start ),
    .xn_re      ( fft_xn_re ),
    .xn_im      ( fft_xn_im ),
    .fwd_inv    ( fft_fwd_inv ),
    .fwd_inv_we ( fft_fwd_inv_we ),
    .rfd        ( fft_rfd ),
    .xn_index   ( fft_xn_index ),
    .busy       ( fft_busy ),
    .edone      ( fft_edone ),
    .done       ( fft_done ),
    .dv         ( fft_dv ),
    .xk_index   ( fft_xk_index ),
    .xk_re      ( fft_xk_re ),
    .xk_im      ( fft_xk_im )
  );

endmodule
