-- ICAP_VIRTEX6: Internal Configuration Access Port
--               Virtex-6
-- Xilinx HDL Libraries Guide, version 13.1

ICAP_VIRTEX6_inst : ICAP_VIRTEX6
generic map (
   DEVICE_ID => X"4244093",     -- Specifies the pre-programmed Device ID value
   ICAP_WIDTH => "X8",          -- Specifies the input and output data width to be used with the
                                -- ICAP_VIRTEX6.
   SIM_CFG_FILE_NAME => "NONE"  -- Specifies the Raw Bitstream (RBT) file to be parsed by the simulation
                                -- model
)
port map (
   BUSY => BUSY,   -- 1-bit output: Busy/Ready output
   O => O,         -- 32-bit output: Configuration data output bus
   CLK => CLK,     -- 1-bit input: Clock Input
   CSB => CSB,     -- 1-bit input: Active-Low ICAP input Enable
   I => I,         -- 32-bit input: Configuration data input bus
   RDWRB => RDWRB  -- 1-bit input: Read/Write Select input
);

-- End of ICAP_VIRTEX6_inst instantiation
