// FRAME_ECC_VIRTEX6: Configuration Frame Error Correction
//                    Virtex-6
// Xilinx HDL Libraries Guide, version 13.1

FRAME_ECC_VIRTEX6 #(
   .FARSRC("EFAR"),                // Determines if the output of FAR[23:0] configuration register points to
                                   // the FAR or EFAR. Sets configuration option register bit CTL0[7].
   .FRAME_RBT_IN_FILENAME("NONE")  // This file is output by the ICAP_VIRTEX6 model and it contains Frame
                                   // Data information for the Raw Bitstream (RBT) file. The FRAME_ECC model
                                   // will parse this file, calculate ECC and output any error conditions.
)
FRAME_ECC_VIRTEX6_inst (
   .CRCERROR(CRCERROR),             // 1-bit output: Output indicating a CRC error
   .ECCERROR(ECCERROR),             // 1-bit output: Output indicating an ECC error
   .ECCERRORSINGLE(ECCERRORSINGLE), // 1-bit output: Output Indicating single-bit Frame ECC error detected.
   .FAR(FAR),                       // 24-bit output: Frame Address Register Value output
   .SYNBIT(SYNBIT),                 // 5-bit output: Output bit address of error
   .SYNDROME(SYNDROME),             // 13-bit output: Output location of erroneous bit
   .SYNDROMEVALID(SYNDROMEVALID),   // 1-bit output: Frame ECC output indicating the SYNDROME output is
                                    // valid.

   .SYNWORD(SYNWORD)                // 7-bit output: Word output in the frame where an ECC error has been
                                    // detected

);

// End of FRAME_ECC_VIRTEX6_inst instantiation
