// MULT18X18SIO: 18 x 18 cascadable, signed synchronous/asynchronous multiplier
//               Spartan-3E/3A
// Xilinx HDL Libraries Guide, version 13.1

MULT18X18SIO #(
   .AREG(1), // Enable the input registers on the A port (1=on, 0=off)
   .BREG(1), // Enable the input registers on the B port (1=on, 0=off)
   .B_INPUT("DIRECT"), // B cascade input "DIRECT" or "CASCADE" 
   .PREG(1)  // Enable the input registers on the P port (1=on, 0=off)
) MULT18X18SIO_inst (
   .BCOUT(BCOUT), // 18-bit cascade output
   .P(P),    // 36-bit multiplier output
   .A(A),    // 18-bit multiplier input
   .B(B),    // 18-bit multiplier input
   .BCIN(BCIN), // 18-bit cascade input
   .CEA(CEA), // Clock enable input for the A port
   .CEB(CEB), // Clock enable input for the B port
   .CEP(CEP), // Clock enable input for the P port
   .CLK(CLK), // Clock input
   .RSTA(RSTA), // Synchronous reset input for the A port
   .RSTB(RSTB), // Synchronous reset input for the B port
   .RSTP(RSTP)  // Synchronous reset input for the P port
);

// End of MULT18X18SIO_inst instantiation
