/////////////////////////////////////////////////////////////////////////
// Copyright (c) 2008 Xilinx, Inc.  All rights reserved.
//
//                 XILINX CONFIDENTIAL PROPERTY
// This   document  contains  proprietary information  which   is
// protected by  copyright. All rights  are reserved.  This notice
// refers to original work by Xilinx, Inc. which may be derivitive
// of other work distributed under license of the authors.  In the
// case of derivitive work, nothing in this notice overrides the
// original author's license agreeement.  Where applicable, the 
// original license agreement is included in it's original 
// unmodified form immediately below this header.
//
// Xilinx, Inc.
// XILINX IS PROVIDING THIS DESIGN, CODE, OR INFORMATION "AS IS" AS A
// COURTESY TO YOU.  BY PROVIDING THIS DESIGN, CODE, OR INFORMATION AS
// ONE POSSIBLE   IMPLEMENTATION OF THIS FEATURE, APPLICATION OR
// STANDARD, XILINX IS MAKING NO REPRESENTATION THAT THIS IMPLEMENTATION
// IS FREE FROM ANY CLAIMS OF INFRINGEMENT, AND YOU ARE RESPONSIBLE
// FOR OBTAINING ANY RIGHTS YOU MAY REQUIRE FOR YOUR IMPLEMENTATION.
// XILINX EXPRESSLY DISCLAIMS ANY WARRANTY WHATSOEVER WITH RESPECT TO
// THE ADEQUACY OF THE IMPLEMENTATION, INCLUDING BUT NOT LIMITED TO
// ANY WARRANTIES OR REPRESENTATIONS THAT THIS IMPLEMENTATION IS FREE
// FROM CLAIMS OF INFRINGEMENT, IMPLIED WARRANTIES OF MERCHANTABILITY
// AND FITNESS FOR A PARTICULAR PURPOSE.
//
/////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//$Date: 2008/05/07 22:43:21 $
//$RCSfile: frame_gen.v,v $
//$Revision: 1.1 $
////////////////////////////////////////////////////////////////////////////////
//   ____  ____ 
//  /   /\/   / 
// /___/  \  /    Vendor: Xilinx 
// \   \   \/     Version : 1.4
//  \   \         Application : GTP Wizard
//  /   /         Filename : frame_gen.v
// /___/   /\     Timestamp : 
// \   \  /  \ 
//  \___\/\___\ 
//
//
// Module FRAME_GEN
// Generated by Xilinx GTP Wizard

`timescale 1ns / 1ps
`define DLY #1

//***********************************Entity Declaration*******************************

module FRAME_GEN #
(
    // parameter to set the number of words in the BRAM
    parameter   WORDS_IN_BRAM =   256,
    parameter    MEM_00       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_01       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_02       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_03       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_04       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_05       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_06       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_07       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_08       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_09       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_0A       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_0B       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_0C       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_0D       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_0E       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_0F       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_10       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_11       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_12       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_13       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_14       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_15       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_16       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_17       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_18       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_19       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_1A       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_1B       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_1C       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_1D       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_1E       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_1F       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_20       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_21       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_22       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_23       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_24       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_25       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_26       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_27       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_28       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_29       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_2A       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_2B       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_2C       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_2D       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_2E       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_2F       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_30       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_31       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_32       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_33       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_34       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_35       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_36       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_37       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_38       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_39       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_3A       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_3B       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_3C       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_3D       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_3E       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEM_3F       =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEMP_00      =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEMP_01      =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEMP_02      =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEMP_03      =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEMP_04      =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEMP_05      =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEMP_06      =   256'h0000000000000000000000000000000000000000000000000000000000000000,
    parameter    MEMP_07      =   256'h0000000000000000000000000000000000000000000000000000000000000000
)
(
    // User Interface
    TX_DATA,
    TX_CHARISK,

    // System Interface
    USER_CLK,       
    SYSTEM_RESET
); 

//***********************************Port Declarations*******************************

   // User Interface
    output  [31:0]  TX_DATA;
    output  [3:0]   TX_CHARISK;

      // System Interface
    input           USER_CLK;
    input           SYSTEM_RESET; 

//********************************* Wire Declarations********************************* 

    wire            tied_to_ground_i;
    wire    [31:0]  tied_to_ground_vec_i;
    wire    [31:0]  tx_data_float_i;
    wire    [3:0]   tx_charisk_float_i;

//***************************Internal Register Declarations*************************** 

    reg     [8:0]   read_counter_i;    
    
//*********************************Main Body of Code**********************************

    assign tied_to_ground_vec_i  =   32'h00000000;
    assign tied_to_ground_i      =   1'b0;
    assign tied_to_vcc_i         =   1'b1;
    
    //____________________________ Counter to read from BRAM __________________________    

    always @(posedge USER_CLK)
        if(SYSTEM_RESET | (read_counter_i == (WORDS_IN_BRAM-1)))  
        begin
             read_counter_i   <=  `DLY    9'd0;
        end
        else read_counter_i   <=  `DLY    read_counter_i + 9'd1;

    //________________________________ BRAM Instantiation _____________________________    

    RAMB16_S36_S36 #
    (
        .INIT_00(MEM_00),
        .INIT_01(MEM_01),
        .INIT_02(MEM_02),
        .INIT_03(MEM_03),
        .INIT_04(MEM_04),
        .INIT_05(MEM_05),
        .INIT_06(MEM_06),
        .INIT_07(MEM_07),
        .INIT_08(MEM_08),
        .INIT_09(MEM_09),
        .INIT_0A(MEM_0A),
        .INIT_0B(MEM_0B),
        .INIT_0C(MEM_0C),
        .INIT_0D(MEM_0D),
        .INIT_0E(MEM_0E),
        .INIT_0F(MEM_0F),
        .INIT_10(MEM_10),
        .INIT_11(MEM_11),
        .INIT_12(MEM_12),
        .INIT_13(MEM_13),
        .INIT_14(MEM_14),
        .INIT_15(MEM_15),
        .INIT_16(MEM_16),
        .INIT_17(MEM_17),
        .INIT_18(MEM_18),
        .INIT_19(MEM_19),
        .INIT_1A(MEM_1A),
        .INIT_1B(MEM_1B),
        .INIT_1C(MEM_1C),
        .INIT_1D(MEM_1D),
        .INIT_1E(MEM_1E),
        .INIT_1F(MEM_1F),
        .INIT_20(MEM_20),
        .INIT_21(MEM_21),
        .INIT_22(MEM_22),
        .INIT_23(MEM_23),
        .INIT_24(MEM_24),
        .INIT_25(MEM_25),
        .INIT_26(MEM_26),
        .INIT_27(MEM_27),
        .INIT_28(MEM_28),
        .INIT_29(MEM_29),
        .INIT_2A(MEM_2A),
        .INIT_2B(MEM_2B),
        .INIT_2C(MEM_2C),
        .INIT_2D(MEM_2D),
        .INIT_2E(MEM_2E),
        .INIT_2F(MEM_2F),
        .INIT_30(MEM_30),
        .INIT_31(MEM_31),
        .INIT_32(MEM_32),
        .INIT_33(MEM_33),
        .INIT_34(MEM_34),
        .INIT_35(MEM_35),
        .INIT_36(MEM_36),
        .INIT_37(MEM_37),
        .INIT_38(MEM_38),
        .INIT_39(MEM_39),
        .INIT_3A(MEM_3A),
        .INIT_3B(MEM_3B),
        .INIT_3C(MEM_3C),
        .INIT_3D(MEM_3D),
        .INIT_3E(MEM_3E),
        .INIT_3F(MEM_3F),
        .INITP_00(MEMP_00),
        .INITP_01(MEMP_01),
        .INITP_02(MEMP_02),
        .INITP_03(MEMP_03),
        .INITP_04(MEMP_04),
        .INITP_05(MEMP_05),
        .INITP_06(MEMP_06),
        .INITP_07(MEMP_07)
    )
    dual_port_block_ram_i 
    (
        .ADDRA (read_counter_i),
        .DIA   (tied_to_ground_vec_i[31:0]),
        .DIPA  (tied_to_ground_vec_i[3:0]),
        .DOA   (TX_DATA),
        .DOPA  (TX_CHARISK), 
        .WEA   (tied_to_ground_i),
        .ENA   (tied_to_vcc_i),
        .SSRA  (tied_to_ground_i), 
        .CLKA  (USER_CLK),
        
        .ADDRB (tied_to_ground_vec_i[8:0]),
        .DIB   (tied_to_ground_vec_i[31:0]),
        .DIPB  (tied_to_ground_vec_i[3:0]),
        .DOB   ( ),  
        .DOPB  ( ), 
        .WEB   (tied_to_ground_i),
        .ENB   (tied_to_ground_i),
        .SSRB  (tied_to_ground_i),
        .CLKB  (tied_to_ground_i)       
    );


endmodule 


