/////////////////////////////////////////////////////////////////////////
// Copyright (c) 2008 Xilinx, Inc.  All rights reserved.
//
//                 XILINX CONFIDENTIAL PROPERTY
// This   document  contains  proprietary information  which   is
// protected by  copyright. All rights  are reserved.  This notice
// refers to original work by Xilinx, Inc. which may be derivitive
// of other work distributed under license of the authors.  In the
// case of derivitive work, nothing in this notice overrides the
// original author's license agreeement.  Where applicable, the 
// original license agreement is included in it's original 
// unmodified form immediately below this header.
//
// Xilinx, Inc.
// XILINX IS PROVIDING THIS DESIGN, CODE, OR INFORMATION "AS IS" AS A
// COURTESY TO YOU.  BY PROVIDING THIS DESIGN, CODE, OR INFORMATION AS
// ONE POSSIBLE   IMPLEMENTATION OF THIS FEATURE, APPLICATION OR
// STANDARD, XILINX IS MAKING NO REPRESENTATION THAT THIS IMPLEMENTATION
// IS FREE FROM ANY CLAIMS OF INFRINGEMENT, AND YOU ARE RESPONSIBLE
// FOR OBTAINING ANY RIGHTS YOU MAY REQUIRE FOR YOUR IMPLEMENTATION.
// XILINX EXPRESSLY DISCLAIMS ANY WARRANTY WHATSOEVER WITH RESPECT TO
// THE ADEQUACY OF THE IMPLEMENTATION, INCLUDING BUT NOT LIMITED TO
// ANY WARRANTIES OR REPRESENTATIONS THAT THIS IMPLEMENTATION IS FREE
// FROM CLAIMS OF INFRINGEMENT, IMPLIED WARRANTIES OF MERCHANTABILITY
// AND FITNESS FOR A PARTICULAR PURPOSE.
//
/////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//$Date: 2008/05/07 22:43:21 $
//$RCSfile: mgt_usrclk_source.v,v $
//$Revision: 1.1 $
///////////////////////////////////////////////////////////////////////////////
//   __  __ 
//  /   /\/   / 
// /__/  \   /    Vendor: Xilinx 
// \   \   \/     Version : 1.4
//  \   \         Application : GTP Wizard 
//  /   /         Filename : mgt_usrclk_source.v
// /__/   /\      Timestamp : 02/08/2005 09:12:43
// \   \  /  \ 
//  \__\/\__\ 
//
//
// Module MGT_USRCLK_SOURCE (for use with GTP Transceivers)
// Generated by Xilinx GTP Wizard

`timescale 1ns / 1ps

//***********************************Entity Declaration*******************************
module MGT_USRCLK_SOURCE #
(
    parameter FREQUENCY_MODE = "LOW"
)
(
    DIV1_OUT,  
    DIV2_OUT,
    DCM_LOCKED_OUT,
    CLK_IN,  
    DCM_RESET_IN

);

`define DLY #1


//*********************************** Port Declaration *******************************

    output          DIV1_OUT;
    output          DIV2_OUT;
    output          DCM_LOCKED_OUT;
    input           CLK_IN;
    input           DCM_RESET_IN;

//*********************************Wire Declarations**********************************

    wire    [15:0]  not_connected_i;
    wire            clkfb_i;
    wire            clkdv_i;
    wire            clk0_i;

//*********************************** Beginning of Code *******************************


    // Instantiate a DCM module to divide the reference clock.
    DCM_BASE #
    (
        .CLKDV_DIVIDE               (2.0),
        .DFS_FREQUENCY_MODE         ("LOW"), 
        .DLL_FREQUENCY_MODE         (FREQUENCY_MODE)    
    )
    clock_divider_i
    (
        .CLK0                       (clk0_i),
        .CLK180                     (not_connected_i[0]),
        .CLK270                     (not_connected_i[1]),
        .CLK2X                      (not_connected_i[2]),
        .CLK2X180                   (not_connected_i[3]),
        .CLK90                      (not_connected_i[4]),
        .CLKDV                      (clkdv_i),
        .CLKFX                      (not_connected_i[5]),
        .CLKFX180                   (not_connected_i[6]),
        .LOCKED                     (DCM_LOCKED_OUT),
        .CLKFB                      (clkfb_i),
        .CLKIN                      (CLK_IN),
        .RST                        (DCM_RESET_IN)
    );

    
    BUFG dcm_1x_bufg_i
    (
        .I                          (clk0_i),
        .O                          (clkfb_i)
    );

    assign  DIV1_OUT  =   clkfb_i;


    BUFG dcm_div2_bufg_i
    (
        .I                          (clkdv_i),
        .O                          (DIV2_OUT)
    );


endmodule

