/////////////////////////////////////////////////////////////////////////
// Copyright (c) 2008 Xilinx, Inc.  All rights reserved.
//
//                 XILINX CONFIDENTIAL PROPERTY
// This   document  contains  proprietary information  which   is
// protected by  copyright. All rights  are reserved.  This notice
// refers to original work by Xilinx, Inc. which may be derivitive
// of other work distributed under license of the authors.  In the
// case of derivitive work, nothing in this notice overrides the
// original author's license agreeement.  Where applicable, the 
// original license agreement is included in it's original 
// unmodified form immediately below this header.
//
// Xilinx, Inc.
// XILINX IS PROVIDING THIS DESIGN, CODE, OR INFORMATION "AS IS" AS A
// COURTESY TO YOU.  BY PROVIDING THIS DESIGN, CODE, OR INFORMATION AS
// ONE POSSIBLE   IMPLEMENTATION OF THIS FEATURE, APPLICATION OR
// STANDARD, XILINX IS MAKING NO REPRESENTATION THAT THIS IMPLEMENTATION
// IS FREE FROM ANY CLAIMS OF INFRINGEMENT, AND YOU ARE RESPONSIBLE
// FOR OBTAINING ANY RIGHTS YOU MAY REQUIRE FOR YOUR IMPLEMENTATION.
// XILINX EXPRESSLY DISCLAIMS ANY WARRANTY WHATSOEVER WITH RESPECT TO
// THE ADEQUACY OF THE IMPLEMENTATION, INCLUDING BUT NOT LIMITED TO
// ANY WARRANTIES OR REPRESENTATIONS THAT THIS IMPLEMENTATION IS FREE
// FROM CLAIMS OF INFRINGEMENT, IMPLIED WARRANTIES OF MERCHANTABILITY
// AND FITNESS FOR A PARTICULAR PURPOSE.
//
/////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//$Date: 2008/05/07 22:43:21 $
//$RCSfile: mgtTop.v,v $
//$Revision: 1.1 $
////////////////////////////////////////////////////////////////////////////////
//   ____  ____ 
//  /   /\/   / 
// /___/  \  /    Vendor: Xilinx 
// \   \   \/     Version : 1.4
//  \   \         Application : GTP Wizard 
//  /   /         Filename : example_mgt_top.v
// /___/   /\     Timestamp : 
// \   \  /  \ 
//  \___\/\___\ 
//
//
// Module EXAMPLE_MGT_TOP
// Generated by Xilinx GTP Wizard




`timescale 1ns / 1ps
`define DLY #1


//***********************************Entity Declaration************************

module mgtTop #
(
    parameter EXAMPLE_CONFIG_INDEPENDENT_LANES          =   1,   //configuration for frame gen and check
    parameter EXAMPLE_LANE_WITH_START_CHAR              =   0,   // specifies lane with unique start frame char
    parameter EXAMPLE_WORDS_IN_BRAM                     =   512, // specifies amount of data in BRAM 
    parameter EXAMPLE_SIM_GTPRESET_SPEEDUP              =   1,   // simulation setting for MGT smartmodel
    parameter EXAMPLE_SIM_PLL_PERDIV2                   =   9'h140, // simulation setting for MGT smartmodel
    parameter EXAMPLE_USE_CHIPSCOPE                     =   0    // Set to 1 to use Chipscope to drive resets
)
(
    TILE0_REFCLK_PAD_N_IN,
    TILE0_REFCLK_PAD_P_IN,
    TILE1_REFCLK_PAD_N_IN,
    TILE1_REFCLK_PAD_P_IN,
    TILE2_REFCLK_PAD_N_IN,
    TILE2_REFCLK_PAD_P_IN,
    TILE3_REFCLK_PAD_N_IN,
    TILE3_REFCLK_PAD_P_IN,
    GTPRESET_IN,
    TILE0_PLLLKDET_OUT,
    TILE1_PLLLKDET_OUT,
    TILE2_PLLLKDET_OUT,
    TILE3_PLLLKDET_OUT,
    RXN_IN,
    RXP_IN,
    TXN_OUT,
    TXP_OUT,
    wb_clk,wb_reset,wb_stb_i,wb_dat_o,wb_dat_i,wb_ack_o,
    wb_adr_i,wb_we_i,wb_cyc_i,wb_sel_i, wb_rty_o, wb_err_o
);

//***********************************Ports Declaration*******************************

    input           TILE0_REFCLK_PAD_N_IN;
    input           TILE0_REFCLK_PAD_P_IN;
    input           TILE1_REFCLK_PAD_N_IN;
    input           TILE1_REFCLK_PAD_P_IN;
    input           TILE2_REFCLK_PAD_N_IN;
    input           TILE2_REFCLK_PAD_P_IN;
    input           TILE3_REFCLK_PAD_N_IN;
    input           TILE3_REFCLK_PAD_P_IN;
    input           GTPRESET_IN;
    output          TILE0_PLLLKDET_OUT;
    output          TILE1_PLLLKDET_OUT;
    output          TILE2_PLLLKDET_OUT;
    output          TILE3_PLLLKDET_OUT;
    input   [7:0]   RXN_IN;
    input   [7:0]   RXP_IN;
    output  [7:0]   TXN_OUT;
    output  [7:0]   TXP_OUT;

    input           wb_clk;
    input           wb_reset;
    input           wb_stb_i;
    output [31:0]   wb_dat_o;
    input  [31:0]   wb_dat_i;
    output          wb_ack_o;
    input  [31:0]   wb_adr_i;
    input           wb_we_i;
    input           wb_cyc_i;
    input  [3:0]    wb_sel_i;
    output          wb_err_o;
    output          wb_rty_o;
    
//************************** Register Declarations ****************************

    reg     [63:0]  ila_in0_r;
    reg     [63:0]  ila_in1_r;
    reg             wb_rty_o;
    reg  [31:0]     wb_dat_o;
    reg             wb_ack_o;
    reg  [127:0]    data_o;
    reg  [31:0]     control_reg;
    reg  [127:0]    data_reg;
    reg  [127:0]    data_i;
    reg             ready_i;


//**************************** Wire Declarations ******************************

    //------------------------ MGT Wrapper Wires ------------------------------
    //________________________________________________________________________
    //________________________________________________________________________
    //TILE0   (X0Y0)

    //---------------------- Loopback and Powerdown Ports ----------------------
    wire    [2:0]   tile0_loopback0_i;
    wire    [2:0]   tile0_loopback1_i;
    //--------------------- Receive Ports - 8b10b Decoder ----------------------
    wire    [1:0]   tile0_rxdisperr0_i;
    wire    [1:0]   tile0_rxdisperr1_i;
    wire    [1:0]   tile0_rxnotintable0_i;
    wire    [1:0]   tile0_rxnotintable1_i;
    //------------- Receive Ports - Comma Detection and Alignment --------------
    wire            tile0_rxenmcommaalign0_i;
    wire            tile0_rxenmcommaalign1_i;
    wire            tile0_rxenpcommaalign0_i;
    wire            tile0_rxenpcommaalign1_i;
    //----------------- Receive Ports - RX Data Path interface -----------------
    wire    [15:0]  tile0_rxdata0_i;
    wire    [15:0]  tile0_rxdata1_i;
    wire            tile0_rxreset0_i;
    wire            tile0_rxreset1_i;
    //------------- Receive Ports - RX Loss-of-sync State Machine --------------
    wire    [1:0]   tile0_rxlossofsync0_i;
    wire    [1:0]   tile0_rxlossofsync1_i;
    //------------------- Shared Ports - Tile and PLL Ports --------------------
    wire            tile0_gtpreset_i;
    wire            tile0_plllkdet_i;
    wire            tile0_refclkout_i;
    wire            tile0_resetdone0_i;
    wire            tile0_resetdone1_i;
    //-------------- Transmit Ports - 8b10b Encoder Control Ports --------------
    wire    [1:0]   tile0_txcharisk0_i;
    wire    [1:0]   tile0_txcharisk1_i;
    //---------------- Transmit Ports - TX Data Path interface -----------------
    wire    [15:0]  tile0_txdata0_i;
    wire    [15:0]  tile0_txdata1_i;
    wire            tile0_txoutclk0_i;
    wire            tile0_txoutclk1_i;
    //------------- Transmit Ports - TX Driver and OOB signalling --------------
    wire    [2:0]   tile0_txdiffctrl0_i;
    wire    [2:0]   tile0_txdiffctrl1_i;
    wire    [2:0]   tile0_txpreemphasis0_i;
    wire    [2:0]   tile0_txpreemphasis1_i;


    //________________________________________________________________________
    //________________________________________________________________________
    //TILE1   (X0Y1)

    //---------------------- Loopback and Powerdown Ports ----------------------
    wire    [2:0]   tile1_loopback0_i;
    wire    [2:0]   tile1_loopback1_i;
    //--------------------- Receive Ports - 8b10b Decoder ----------------------
    wire    [1:0]   tile1_rxdisperr0_i;
    wire    [1:0]   tile1_rxdisperr1_i;
    wire    [1:0]   tile1_rxnotintable0_i;
    wire    [1:0]   tile1_rxnotintable1_i;
    //------------- Receive Ports - Comma Detection and Alignment --------------
    wire            tile1_rxenmcommaalign0_i;
    wire            tile1_rxenmcommaalign1_i;
    wire            tile1_rxenpcommaalign0_i;
    wire            tile1_rxenpcommaalign1_i;
    //----------------- Receive Ports - RX Data Path interface -----------------
    wire    [15:0]  tile1_rxdata0_i;
    wire    [15:0]  tile1_rxdata1_i;
    wire            tile1_rxreset0_i;
    wire            tile1_rxreset1_i;
    //------------- Receive Ports - RX Loss-of-sync State Machine --------------
    wire    [1:0]   tile1_rxlossofsync0_i;
    wire    [1:0]   tile1_rxlossofsync1_i;
    //------------------- Shared Ports - Tile and PLL Ports --------------------
    wire            tile1_gtpreset_i;
    wire            tile1_plllkdet_i;
    wire            tile1_refclkout_i;
    wire            tile1_resetdone0_i;
    wire            tile1_resetdone1_i;
    //-------------- Transmit Ports - 8b10b Encoder Control Ports --------------
    wire    [1:0]   tile1_txcharisk0_i;
    wire    [1:0]   tile1_txcharisk1_i;
    //---------------- Transmit Ports - TX Data Path interface -----------------
    wire    [15:0]  tile1_txdata0_i;
    wire    [15:0]  tile1_txdata1_i;
    wire            tile1_txoutclk0_i;
    wire            tile1_txoutclk1_i;
    //------------- Transmit Ports - TX Driver and OOB signalling --------------
    wire    [2:0]   tile1_txdiffctrl0_i;
    wire    [2:0]   tile1_txdiffctrl1_i;
    wire    [2:0]   tile1_txpreemphasis0_i;
    wire    [2:0]   tile1_txpreemphasis1_i;


    //________________________________________________________________________
    //________________________________________________________________________
    //TILE2   (X0Y2)

    //---------------------- Loopback and Powerdown Ports ----------------------
    wire    [2:0]   tile2_loopback0_i;
    wire    [2:0]   tile2_loopback1_i;
    //--------------------- Receive Ports - 8b10b Decoder ----------------------
    wire    [1:0]   tile2_rxdisperr0_i;
    wire    [1:0]   tile2_rxdisperr1_i;
    wire    [1:0]   tile2_rxnotintable0_i;
    wire    [1:0]   tile2_rxnotintable1_i;
    //------------- Receive Ports - Comma Detection and Alignment --------------
    wire            tile2_rxenmcommaalign0_i;
    wire            tile2_rxenmcommaalign1_i;
    wire            tile2_rxenpcommaalign0_i;
    wire            tile2_rxenpcommaalign1_i;
    //----------------- Receive Ports - RX Data Path interface -----------------
    wire    [15:0]  tile2_rxdata0_i;
    wire    [15:0]  tile2_rxdata1_i;
    wire            tile2_rxreset0_i;
    wire            tile2_rxreset1_i;
    //------------- Receive Ports - RX Loss-of-sync State Machine --------------
    wire    [1:0]   tile2_rxlossofsync0_i;
    wire    [1:0]   tile2_rxlossofsync1_i;
    //------------------- Shared Ports - Tile and PLL Ports --------------------
    wire            tile2_gtpreset_i;
    wire            tile2_plllkdet_i;
    wire            tile2_refclkout_i;
    wire            tile2_resetdone0_i;
    wire            tile2_resetdone1_i;
    //-------------- Transmit Ports - 8b10b Encoder Control Ports --------------
    wire    [1:0]   tile2_txcharisk0_i;
    wire    [1:0]   tile2_txcharisk1_i;
    //---------------- Transmit Ports - TX Data Path interface -----------------
    wire    [15:0]  tile2_txdata0_i;
    wire    [15:0]  tile2_txdata1_i;
    wire            tile2_txoutclk0_i;
    wire            tile2_txoutclk1_i;
    //------------- Transmit Ports - TX Driver and OOB signalling --------------
    wire    [2:0]   tile2_txdiffctrl0_i;
    wire    [2:0]   tile2_txdiffctrl1_i;
    wire    [2:0]   tile2_txpreemphasis0_i;
    wire    [2:0]   tile2_txpreemphasis1_i;


    //________________________________________________________________________
    //________________________________________________________________________
    //TILE3   (X0Y3)

    //---------------------- Loopback and Powerdown Ports ----------------------
    wire    [2:0]   tile3_loopback0_i;
    wire    [2:0]   tile3_loopback1_i;
    //--------------------- Receive Ports - 8b10b Decoder ----------------------
    wire    [1:0]   tile3_rxdisperr0_i;
    wire    [1:0]   tile3_rxdisperr1_i;
    wire    [1:0]   tile3_rxnotintable0_i;
    wire    [1:0]   tile3_rxnotintable1_i;
    //------------- Receive Ports - Comma Detection and Alignment --------------
    wire            tile3_rxenmcommaalign0_i;
    wire            tile3_rxenmcommaalign1_i;
    wire            tile3_rxenpcommaalign0_i;
    wire            tile3_rxenpcommaalign1_i;
    //----------------- Receive Ports - RX Data Path interface -----------------
    wire    [15:0]  tile3_rxdata0_i;
    wire    [15:0]  tile3_rxdata1_i;
    wire            tile3_rxreset0_i;
    wire            tile3_rxreset1_i;
    //------------- Receive Ports - RX Loss-of-sync State Machine --------------
    wire    [1:0]   tile3_rxlossofsync0_i;
    wire    [1:0]   tile3_rxlossofsync1_i;
    //------------------- Shared Ports - Tile and PLL Ports --------------------
    wire            tile3_gtpreset_i;
    wire            tile3_plllkdet_i;
    wire            tile3_refclkout_i;
    wire            tile3_resetdone0_i;
    wire            tile3_resetdone1_i;
    //-------------- Transmit Ports - 8b10b Encoder Control Ports --------------
    wire    [1:0]   tile3_txcharisk0_i;
    wire    [1:0]   tile3_txcharisk1_i;
    //---------------- Transmit Ports - TX Data Path interface -----------------
    wire    [15:0]  tile3_txdata0_i;
    wire    [15:0]  tile3_txdata1_i;
    wire            tile3_txoutclk0_i;
    wire            tile3_txoutclk1_i;
    //------------- Transmit Ports - TX Driver and OOB signalling --------------
    wire    [2:0]   tile3_txdiffctrl0_i;
    wire    [2:0]   tile3_txdiffctrl1_i;
    wire    [2:0]   tile3_txpreemphasis0_i;
    wire    [2:0]   tile3_txpreemphasis1_i;


    //----------------------------- Global Signals -----------------------------
    wire            tx_system_reset_c;
    wire            tile0_rx_system_reset0_c;
    wire            tile0_rx_system_reset1_c;
    wire            tile1_rx_system_reset0_c;
    wire            tile1_rx_system_reset1_c;
    wire            tile2_rx_system_reset0_c;
    wire            tile2_rx_system_reset1_c;
    wire            tile3_rx_system_reset0_c;
    wire            tile3_rx_system_reset1_c;
    wire            tied_to_ground_i;
    wire    [63:0]  tied_to_ground_vec_i;
    wire            tied_to_vcc_i;
    wire    [7:0]   tied_to_vcc_vec_i;
    wire            drp_clk_in_i;
    
    wire            tile0_refclkout_bufg_i;
    
    
    //--------------------------- User Clocks ---------------------------------
    wire            tile1_txusrclk20_i;
    wire            tile3_txusrclk0_i;
    wire            tile3_txusrclk20_i;
    wire            tile1_txusrclk0_i;
    wire            tile2_txusrclk20_i;
    wire            tile0_txusrclk20_i;
    wire            tile2_txusrclk0_i;
    wire            tile0_txusrclk0_i;
    wire            txoutclk_dcm0_locked_i;
    wire            txoutclk_dcm0_reset_i;
    wire            txoutclk_dcm1_locked_i;
    wire            txoutclk_dcm1_reset_i;
    wire            txoutclk_dcm2_locked_i;
    wire            txoutclk_dcm2_reset_i;
    wire            txoutclk_dcm3_locked_i;
    wire            txoutclk_dcm3_reset_i;


    //--------------------- Frame check/gen Module Signals --------------------
    wire            tile0_refclk_i;
    wire            tile0_matchn0_i;
    wire    [1:0]   tile0_txcharisk0_float_i;
    wire    [15:0]  tile0_txdata0_float_i;
    wire    [7:0]   tile0_error_count0_i;
    wire            tile0_frame_check0_reset_i;
    wire            tile0_inc_in0_i;
    wire            tile0_inc_out0_i;
    wire            tile0_matchn1_i;
    wire    [1:0]   tile0_txcharisk1_float_i;
    wire    [15:0]  tile0_txdata1_float_i;
    wire    [7:0]   tile0_error_count1_i;
    wire            tile0_frame_check1_reset_i;
    wire            tile0_inc_in1_i;
    wire            tile0_inc_out1_i;

    wire            tile1_refclk_i;
    wire            tile1_matchn0_i;
    wire    [1:0]   tile1_txcharisk0_float_i;
    wire    [15:0]  tile1_txdata0_float_i;
    wire    [7:0]   tile1_error_count0_i;
    wire            tile1_frame_check0_reset_i;
    wire            tile1_inc_in0_i;
    wire            tile1_inc_out0_i;
    wire            tile1_matchn1_i;
    wire    [1:0]   tile1_txcharisk1_float_i;
    wire    [15:0]  tile1_txdata1_float_i;
    wire    [7:0]   tile1_error_count1_i;
    wire            tile1_frame_check1_reset_i;
    wire            tile1_inc_in1_i;
    wire            tile1_inc_out1_i;

    wire            tile2_refclk_i;
    wire            tile2_matchn0_i;
    wire    [1:0]   tile2_txcharisk0_float_i;
    wire    [15:0]  tile2_txdata0_float_i;
    wire    [7:0]   tile2_error_count0_i;
    wire            tile2_frame_check0_reset_i;
    wire            tile2_inc_in0_i;
    wire            tile2_inc_out0_i;
    wire            tile2_matchn1_i;
    wire    [1:0]   tile2_txcharisk1_float_i;
    wire    [15:0]  tile2_txdata1_float_i;
    wire    [7:0]   tile2_error_count1_i;
    wire            tile2_frame_check1_reset_i;
    wire            tile2_inc_in1_i;
    wire            tile2_inc_out1_i;

    wire            tile3_refclk_i;
    wire            tile3_matchn0_i;
    wire    [1:0]   tile3_txcharisk0_float_i;
    wire    [15:0]  tile3_txdata0_float_i;
    wire    [7:0]   tile3_error_count0_i;
    wire            tile3_frame_check0_reset_i;
    wire            tile3_inc_in0_i;
    wire            tile3_inc_out0_i;
    wire            tile3_matchn1_i;
    wire    [1:0]   tile3_txcharisk1_float_i;
    wire    [15:0]  tile3_txdata1_float_i;
    wire    [7:0]   tile3_error_count1_i;
    wire            tile3_frame_check1_reset_i;
    wire            tile3_inc_in1_i;
    wire            tile3_inc_out1_i;

    wire            reset_on_data_error_i;
    
    //----------------------- Sync Module Signals -----------------------------
    wire            tile0_rx_sync_done0_i;
    wire            tile0_rx_sync_done1_i;
    wire            tile1_rx_sync_done0_i;
    wire            tile1_rx_sync_done1_i;
    wire            tile2_rx_sync_done0_i;
    wire            tile2_rx_sync_done1_i;
    wire            tile3_rx_sync_done0_i;
    wire            tile3_rx_sync_done1_i;
    wire            tx_sync_done_i; 


    //--------------------- Chipscope Signals ---------------------------------

    wire    [35:0]  shared_vio_control_i;
    wire    [35:0]  tx_data_vio_control0_i;
    wire    [35:0]  rx_data_vio_control0_i;
    wire    [35:0]  ila_control0_i;
    wire    [35:0]  tx_data_vio_control1_i;
    wire    [35:0]  rx_data_vio_control1_i;
    wire    [35:0]  ila_control1_i;
    wire    [31:0]  shared_vio_in_i;
    wire    [31:0]  shared_vio_out_i;
    wire    [31:0]  tx_data_vio_in0_i;
    wire    [31:0]  tx_data_vio_out0_i;
    wire    [31:0]  tx_data_vio_in1_i;
    wire    [31:0]  tx_data_vio_out1_i;
    wire    [31:0]  rx_data_vio_in0_i;
    wire    [31:0]  rx_data_vio_out0_i;
    wire    [31:0]  rx_data_vio_in1_i;
    wire    [31:0]  rx_data_vio_out1_i;
    wire    [63:0]  ila_in0_i;
    wire    [63:0]  ila_in1_i;

    wire    [31:0]  tile0_tx_data_vio_in0_i;
    wire    [31:0]  tile0_tx_data_vio_out0_i;
    wire    [31:0]  tile0_rx_data_vio_in0_i;
    wire    [31:0]  tile0_rx_data_vio_out0_i;
    wire    [63:0]  tile0_ila_in0_i;
    wire    [31:0]  tile0_tx_data_vio_in1_i;
    wire    [31:0]  tile0_tx_data_vio_out1_i;
    wire    [31:0]  tile0_rx_data_vio_in1_i;
    wire    [31:0]  tile0_rx_data_vio_out1_i;
    wire    [63:0]  tile0_ila_in1_i;

    wire    [31:0]  tile1_tx_data_vio_in0_i;
    wire    [31:0]  tile1_tx_data_vio_out0_i;
    wire    [31:0]  tile1_rx_data_vio_in0_i;
    wire    [31:0]  tile1_rx_data_vio_out0_i;
    wire    [63:0]  tile1_ila_in0_i;
    wire    [31:0]  tile1_tx_data_vio_in1_i;
    wire    [31:0]  tile1_tx_data_vio_out1_i;
    wire    [31:0]  tile1_rx_data_vio_in1_i;
    wire    [31:0]  tile1_rx_data_vio_out1_i;
    wire    [63:0]  tile1_ila_in1_i;

    wire    [31:0]  tile2_tx_data_vio_in0_i;
    wire    [31:0]  tile2_tx_data_vio_out0_i;
    wire    [31:0]  tile2_rx_data_vio_in0_i;
    wire    [31:0]  tile2_rx_data_vio_out0_i;
    wire    [63:0]  tile2_ila_in0_i;
    wire    [31:0]  tile2_tx_data_vio_in1_i;
    wire    [31:0]  tile2_tx_data_vio_out1_i;
    wire    [31:0]  tile2_rx_data_vio_in1_i;
    wire    [31:0]  tile2_rx_data_vio_out1_i;
    wire    [63:0]  tile2_ila_in1_i;

    wire    [31:0]  tile3_tx_data_vio_in0_i;
    wire    [31:0]  tile3_tx_data_vio_out0_i;
    wire    [31:0]  tile3_rx_data_vio_in0_i;
    wire    [31:0]  tile3_rx_data_vio_out0_i;
    wire    [63:0]  tile3_ila_in0_i;
    wire    [31:0]  tile3_tx_data_vio_in1_i;
    wire    [31:0]  tile3_tx_data_vio_out1_i;
    wire    [31:0]  tile3_rx_data_vio_in1_i;
    wire    [31:0]  tile3_rx_data_vio_out1_i;
    wire    [63:0]  tile3_ila_in1_i;


    wire            gtpreset_i;
    wire    [1:0]   mux_sel_i;
    wire            user_tx_reset_i;
    wire            user_rx_reset_i;
    wire            ila_clk0_i;
    wire            ila_clk_mux_out0_i;
    wire            ila_clk1_i;
    wire            ila_clk_mux_out1_i;


//**************************** Main Body of Code *******************************

    //  Static signal Assigments    
    assign tied_to_ground_i             = 1'b0;
    assign tied_to_ground_vec_i         = 64'h0000000000000000;
    assign tied_to_vcc_i                = 1'b1;
    assign tied_to_vcc_vec_i            = 8'hff;

																			   
    always @(posedge wb_clk)
    begin
        if (wb_sel_i==4'hC)
           ready_i <=1'b1;
        else
            ready_i <=1'b0;
   end

    //--------------------- Wishbone Interface ---------------
    always @(posedge wb_clk or posedge wb_reset)
    begin
     if(wb_reset==1)
     begin
       wb_ack_o<=#1 0;
       wb_dat_o<=#1 0;
       control_reg <= #1 32'h0;
       data_reg <= #1 127'h0;
       data_o <= #1 127'h0;
     end
     else
     begin
       if(ready_i)
       begin
        control_reg[1] <= #1 1'b1;  
        data_reg <= #1 data_i;
       end
         
       if(wb_stb_i && wb_cyc_i && wb_we_i && ~wb_ack_o)
       begin
         wb_ack_o<=#1 1;
         case(wb_adr_i[7:0])
             8'h0:
             begin
                 //Writing control register
                 control_reg<= #1 wb_dat_i;
             end
             8'h4:
              begin
                 data_o[127:96]<= #1 wb_dat_i;
             end                 
             8'h8:
             begin
                 data_o[95:64]<= #1 wb_dat_i;
             end                 
			 8'hC:
              begin
                 data_o[63:32]<= #1 wb_dat_i;
             end                 
             8'h10:
             begin
                 data_o[31:0]<= #1 wb_dat_i;
             end                 
         endcase
       end
       else if(wb_stb_i && wb_cyc_i && ~wb_we_i && ~wb_ack_o)
       begin
           wb_ack_o<=#1 1;
           case(wb_adr_i[7:0])
             8'h0:
             begin
                 wb_dat_o<= #1 control_reg;
                 control_reg[1]<=1'b0;
             end
             8'h24:
             begin
                 wb_dat_o<= #1 data_reg[127:96];
             end
             8'h28:
             begin
                 wb_dat_o<= #1 data_reg[95:64];
             end
             8'h2C:
             begin
                 wb_dat_o<= #1 data_reg[63:32];
             end
             8'h30:
             begin
                 wb_dat_o<= #1 data_reg[31:0];
             end
           endcase
       end
       else
       begin
           wb_ack_o<=#1 0;
           control_reg[0]<= #1 1'b0;
       end
     end
    end

 
//xlnx add in an output register
//assign wb_rty_o = tile0_rxlossofsync0_i & tile0_rxlossofsync1_i & tile1_rxlossofsync0_i & tile1_rxlossofsync1_i & tile2_rxlossofsync0_i & tile2_rxlossofsync1_i & tile3_rxlossofsync0_i & tile3_rxlossofsync1_i ;
always @(posedge wb_clk)
begin
       wb_rty_o <= tile0_rxlossofsync0_i & tile0_rxlossofsync1_i & tile1_rxlossofsync0_i & tile1_rxlossofsync1_i & tile2_rxlossofsync0_i & tile2_rxlossofsync1_i & tile3_rxlossofsync0_i & tile3_rxlossofsync1_i ;
end    
//---------------------Dedicated GTP Reference Clock Inputs ---------------
    // The dedicated reference clock inputs you selected in the GUI are implemented using
    // IBUFDS instances.
    //
    // In the UCF file for this example design, you will see that each of
    // these IBUFDS instances has been LOCed to a particular set of pins. By LOCing to these
    // locations, we tell the tools to use the dedicated input buffers to the GTP reference
    // clock network, rather than general purpose IOs. To select other pins, consult the 
    // Implementation chapter of UG196, or rerun the wizard.
    //
    // This network is the highest performace (lowest jitter) option for providing clocks
    // to the GTP transceivers.
    
    IBUFDS tile0_refclk_ibufds_i
    (
        .O                              (tile0_refclk_i), 
        .I                              (TILE0_REFCLK_PAD_P_IN),
        .IB                             (TILE0_REFCLK_PAD_N_IN)
    );

    IBUFDS tile1_refclk_ibufds_i
    (
        .O                              (tile1_refclk_i), 
        .I                              (TILE1_REFCLK_PAD_P_IN),
        .IB                             (TILE1_REFCLK_PAD_N_IN)
    );

    IBUFDS tile2_refclk_ibufds_i
    (
        .O                              (tile2_refclk_i), 
        .I                              (TILE2_REFCLK_PAD_P_IN),
        .IB                             (TILE2_REFCLK_PAD_N_IN)
    );

    IBUFDS tile3_refclk_ibufds_i
    (
        .O                              (tile3_refclk_i), 
        .I                              (TILE3_REFCLK_PAD_P_IN),
        .IB                             (TILE3_REFCLK_PAD_N_IN)
    );






    //--------------------------------- User Clocks ---------------------------
    
    // The clock resources in this section were added based on userclk source selections on
    // the Latency, Buffering, and Clocking page of the GUI. A few notes about user clocks:
    // * The userclk and userclk2 for each GTP datapath (TX and RX) must be phase aligned to 
    //   avoid data errors in the fabric interface whenever the datapath is wider than 10 bits
    // * To minimize clock resources, you can share clocks between GTPs. GTPs using the same frequency
    //   or multiples of the same frequency can be accomadated using DCMs and PLLs. Use caution when
    //   using RXRECCLK as a clock source, however - these clocks can typically only be shared if all
    //   the channels using the clock are receiving data from TX channels that share a reference clock 
    //   source with each other.

    assign  txoutclk_dcm0_reset_i           =  !tile0_plllkdet_i;
    MGT_USRCLK_SOURCE #
    (
        .FREQUENCY_MODE                 ("HIGH")
    )
    txoutclk_dcm0_i
    (
        .DIV1_OUT                       (tile0_txusrclk0_i),
        .DIV2_OUT                       (tile0_txusrclk20_i),
        .DCM_LOCKED_OUT                 (txoutclk_dcm0_locked_i),
        .CLK_IN                         (tile0_txoutclk0_i),
        .DCM_RESET_IN                   (txoutclk_dcm0_reset_i)
    );


    assign  txoutclk_dcm1_reset_i           =  !tile3_plllkdet_i;
    MGT_USRCLK_SOURCE #
    (
        .FREQUENCY_MODE                 ("HIGH")
    )
    txoutclk_dcm1_i
    (
        .DIV1_OUT                       (tile3_txusrclk0_i),
        .DIV2_OUT                       (tile3_txusrclk20_i),
        .DCM_LOCKED_OUT                 (txoutclk_dcm1_locked_i),
        .CLK_IN                         (tile3_txoutclk0_i),
        .DCM_RESET_IN                   (txoutclk_dcm1_reset_i)
    );


    assign  txoutclk_dcm2_reset_i           =  !tile1_plllkdet_i;
    MGT_USRCLK_SOURCE #
    (
        .FREQUENCY_MODE                 ("HIGH")
    )
    txoutclk_dcm2_i
    (
        .DIV1_OUT                       (tile1_txusrclk0_i),
        .DIV2_OUT                       (tile1_txusrclk20_i),
        .DCM_LOCKED_OUT                 (txoutclk_dcm2_locked_i),
        .CLK_IN                         (tile1_txoutclk0_i),
        .DCM_RESET_IN                   (txoutclk_dcm2_reset_i)
    );


    assign  txoutclk_dcm3_reset_i           =  !tile2_plllkdet_i;
    MGT_USRCLK_SOURCE #
    (
        .FREQUENCY_MODE                 ("HIGH")
    )
    txoutclk_dcm3_i
    (
        .DIV1_OUT                       (tile2_txusrclk0_i),
        .DIV2_OUT                       (tile2_txusrclk20_i),
        .DCM_LOCKED_OUT                 (txoutclk_dcm3_locked_i),
        .CLK_IN                         (tile2_txoutclk0_i),
        .DCM_RESET_IN                   (txoutclk_dcm3_reset_i)
    );






    //--------------------------- The GTP Wrapper -----------------------------
    
    // Use the instantiation template in the examples directory to add the GTP wrapper to your design.
    // In this example, the wrapper is wired up for basic operation with a frame generator and frame 
    // checker. The GTPs will reset, then attempt to align and transmit data. If channel bonding is 
    // enabled, bonding should occur after alignment.

    // Wire all PLLLKDET signals to the top level as output ports
    assign TILE0_PLLLKDET_OUT = tile0_plllkdet_i;
    assign TILE1_PLLLKDET_OUT = tile1_plllkdet_i;
    assign TILE2_PLLLKDET_OUT = tile2_plllkdet_i;
    assign TILE3_PLLLKDET_OUT = tile3_plllkdet_i;


    ROCKETIO_WRAPPER #
    (
        .WRAPPER_SIM_GTPRESET_SPEEDUP           (EXAMPLE_SIM_GTPRESET_SPEEDUP),
        .WRAPPER_SIM_PLL_PERDIV2                (EXAMPLE_SIM_PLL_PERDIV2)
    )
    rocketio_wrapper_i
    (
    
        //_____________________________________________________________________
        //_____________________________________________________________________
        //TILE0  (X0Y0)

        //---------------------- Loopback and Powerdown Ports ----------------------
        .TILE0_LOOPBACK0_IN             (tile0_loopback0_i),
        .TILE0_LOOPBACK1_IN             (tile0_loopback1_i),
        //--------------------- Receive Ports - 8b10b Decoder ----------------------
        .TILE0_RXDISPERR0_OUT           (tile0_rxdisperr0_i),
        .TILE0_RXDISPERR1_OUT           (tile0_rxdisperr1_i),
        .TILE0_RXNOTINTABLE0_OUT        (tile0_rxnotintable0_i),
        .TILE0_RXNOTINTABLE1_OUT        (tile0_rxnotintable1_i),
        //------------- Receive Ports - Comma Detection and Alignment --------------
        .TILE0_RXENMCOMMAALIGN0_IN      (tile0_rxenmcommaalign0_i),
        .TILE0_RXENMCOMMAALIGN1_IN      (tile0_rxenmcommaalign1_i),
        .TILE0_RXENPCOMMAALIGN0_IN      (tile0_rxenpcommaalign0_i),
        .TILE0_RXENPCOMMAALIGN1_IN      (tile0_rxenpcommaalign1_i),
        //----------------- Receive Ports - RX Data Path interface -----------------
        .TILE0_RXDATA0_OUT              (tile0_rxdata0_i),
        .TILE0_RXDATA1_OUT              (tile0_rxdata1_i),
        .TILE0_RXRESET0_IN              (tile0_rxreset0_i),
        .TILE0_RXRESET1_IN              (tile0_rxreset1_i),
        .TILE0_RXUSRCLK0_IN             (tile3_txusrclk0_i),
        .TILE0_RXUSRCLK1_IN             (tile3_txusrclk0_i),
        .TILE0_RXUSRCLK20_IN            (tile3_txusrclk20_i),
        .TILE0_RXUSRCLK21_IN            (tile3_txusrclk20_i),
        //----- Receive Ports - RX Driver,OOB signalling,Coupling and Eq.,CDR ------
        .TILE0_RXN0_IN                  (RXN_IN[0]),
        .TILE0_RXN1_IN                  (RXN_IN[1]),
        .TILE0_RXP0_IN                  (RXP_IN[0]),
        .TILE0_RXP1_IN                  (RXP_IN[1]),
        //------------- Receive Ports - RX Loss-of-sync State Machine --------------
        .TILE0_RXLOSSOFSYNC0_OUT        (tile0_rxlossofsync0_i),
        .TILE0_RXLOSSOFSYNC1_OUT        (tile0_rxlossofsync1_i),
        //------------------- Shared Ports - Tile and PLL Ports --------------------
        .TILE0_CLKIN_IN                 (tile0_refclk_i),
        .TILE0_GTPRESET_IN              (tile0_gtpreset_i),
        .TILE0_PLLLKDET_OUT             (tile0_plllkdet_i),
        .TILE0_REFCLKOUT_OUT            (tile0_refclkout_i),
        .TILE0_RESETDONE0_OUT           (tile0_resetdone0_i),
        .TILE0_RESETDONE1_OUT           (tile0_resetdone1_i),
        //-------------- Transmit Ports - 8b10b Encoder Control Ports --------------
        .TILE0_TXCHARISK0_IN            (tile0_txcharisk0_i),
        .TILE0_TXCHARISK1_IN            (tile0_txcharisk1_i),
        //---------------- Transmit Ports - TX Data Path interface -----------------
        .TILE0_TXDATA0_IN               (tile0_txdata0_i),
        .TILE0_TXDATA1_IN               (tile0_txdata1_i),
        .TILE0_TXOUTCLK0_OUT            (tile0_txoutclk0_i),
        .TILE0_TXOUTCLK1_OUT            (tile0_txoutclk1_i),
        .TILE0_TXUSRCLK0_IN             (tile3_txusrclk0_i),
        .TILE0_TXUSRCLK1_IN             (tile3_txusrclk0_i),
        .TILE0_TXUSRCLK20_IN            (tile3_txusrclk20_i),
        .TILE0_TXUSRCLK21_IN            (tile3_txusrclk20_i),
        //------------- Transmit Ports - TX Driver and OOB signalling --------------
        .TILE0_TXDIFFCTRL0_IN           (tile0_txdiffctrl0_i),
        .TILE0_TXDIFFCTRL1_IN           (tile0_txdiffctrl1_i),
        .TILE0_TXN0_OUT                 (TXN_OUT[0]),
        .TILE0_TXN1_OUT                 (TXN_OUT[1]),
        .TILE0_TXP0_OUT                 (TXP_OUT[0]),
        .TILE0_TXP1_OUT                 (TXP_OUT[1]),
        .TILE0_TXPREEMPHASIS0_IN        (tile0_txpreemphasis0_i),
        .TILE0_TXPREEMPHASIS1_IN        (tile0_txpreemphasis1_i),


    
        //_____________________________________________________________________
        //_____________________________________________________________________
        //TILE1  (X0Y1)

        //---------------------- Loopback and Powerdown Ports ----------------------
        .TILE1_LOOPBACK0_IN             (tile1_loopback0_i),
        .TILE1_LOOPBACK1_IN             (tile1_loopback1_i),
        //--------------------- Receive Ports - 8b10b Decoder ----------------------
        .TILE1_RXDISPERR0_OUT           (tile1_rxdisperr0_i),
        .TILE1_RXDISPERR1_OUT           (tile1_rxdisperr1_i),
        .TILE1_RXNOTINTABLE0_OUT        (tile1_rxnotintable0_i),
        .TILE1_RXNOTINTABLE1_OUT        (tile1_rxnotintable1_i),
        //------------- Receive Ports - Comma Detection and Alignment --------------
        .TILE1_RXENMCOMMAALIGN0_IN      (tile1_rxenmcommaalign0_i),
        .TILE1_RXENMCOMMAALIGN1_IN      (tile1_rxenmcommaalign1_i),
        .TILE1_RXENPCOMMAALIGN0_IN      (tile1_rxenpcommaalign0_i),
        .TILE1_RXENPCOMMAALIGN1_IN      (tile1_rxenpcommaalign1_i),
        //----------------- Receive Ports - RX Data Path interface -----------------
        .TILE1_RXDATA0_OUT              (tile1_rxdata0_i),
        .TILE1_RXDATA1_OUT              (tile1_rxdata1_i),
        .TILE1_RXRESET0_IN              (tile1_rxreset0_i),
        .TILE1_RXRESET1_IN              (tile1_rxreset1_i),
        .TILE1_RXUSRCLK0_IN             (tile3_txusrclk0_i),
        .TILE1_RXUSRCLK1_IN             (tile3_txusrclk0_i),
        .TILE1_RXUSRCLK20_IN            (tile3_txusrclk20_i),
        .TILE1_RXUSRCLK21_IN            (tile3_txusrclk20_i),
        //----- Receive Ports - RX Driver,OOB signalling,Coupling and Eq.,CDR ------
        .TILE1_RXN0_IN                  (RXN_IN[2]),
        .TILE1_RXN1_IN                  (RXN_IN[3]),
        .TILE1_RXP0_IN                  (RXP_IN[2]),
        .TILE1_RXP1_IN                  (RXP_IN[3]),
        //------------- Receive Ports - RX Loss-of-sync State Machine --------------
        .TILE1_RXLOSSOFSYNC0_OUT        (tile1_rxlossofsync0_i),
        .TILE1_RXLOSSOFSYNC1_OUT        (tile1_rxlossofsync1_i),
        //------------------- Shared Ports - Tile and PLL Ports --------------------
        .TILE1_CLKIN_IN                 (tile1_refclk_i),
        .TILE1_GTPRESET_IN              (tile1_gtpreset_i),
        .TILE1_PLLLKDET_OUT             (tile1_plllkdet_i),
        .TILE1_REFCLKOUT_OUT            (tile1_refclkout_i),
        .TILE1_RESETDONE0_OUT           (tile1_resetdone0_i),
        .TILE1_RESETDONE1_OUT           (tile1_resetdone1_i),
        //-------------- Transmit Ports - 8b10b Encoder Control Ports --------------
        .TILE1_TXCHARISK0_IN            (tile1_txcharisk0_i),
        .TILE1_TXCHARISK1_IN            (tile1_txcharisk1_i),
        //---------------- Transmit Ports - TX Data Path interface -----------------
        .TILE1_TXDATA0_IN               (tile1_txdata0_i),
        .TILE1_TXDATA1_IN               (tile1_txdata1_i),
        .TILE1_TXOUTCLK0_OUT            (tile1_txoutclk0_i),
        .TILE1_TXOUTCLK1_OUT            (tile1_txoutclk1_i),
        .TILE1_TXUSRCLK0_IN             (tile3_txusrclk0_i),
        .TILE1_TXUSRCLK1_IN             (tile3_txusrclk0_i),
        .TILE1_TXUSRCLK20_IN            (tile3_txusrclk20_i),
        .TILE1_TXUSRCLK21_IN            (tile3_txusrclk20_i),
        //------------- Transmit Ports - TX Driver and OOB signalling --------------
        .TILE1_TXDIFFCTRL0_IN           (tile1_txdiffctrl0_i),
        .TILE1_TXDIFFCTRL1_IN           (tile1_txdiffctrl1_i),
        .TILE1_TXN0_OUT                 (TXN_OUT[2]),
        .TILE1_TXN1_OUT                 (TXN_OUT[3]),
        .TILE1_TXP0_OUT                 (TXP_OUT[2]),
        .TILE1_TXP1_OUT                 (TXP_OUT[3]),
        .TILE1_TXPREEMPHASIS0_IN        (tile1_txpreemphasis0_i),
        .TILE1_TXPREEMPHASIS1_IN        (tile1_txpreemphasis1_i),


    
        //_____________________________________________________________________
        //_____________________________________________________________________
        //TILE2  (X0Y2)

        //---------------------- Loopback and Powerdown Ports ----------------------
        .TILE2_LOOPBACK0_IN             (tile2_loopback0_i),
        .TILE2_LOOPBACK1_IN             (tile2_loopback1_i),
        //--------------------- Receive Ports - 8b10b Decoder ----------------------
        .TILE2_RXDISPERR0_OUT           (tile2_rxdisperr0_i),
        .TILE2_RXDISPERR1_OUT           (tile2_rxdisperr1_i),
        .TILE2_RXNOTINTABLE0_OUT        (tile2_rxnotintable0_i),
        .TILE2_RXNOTINTABLE1_OUT        (tile2_rxnotintable1_i),
        //------------- Receive Ports - Comma Detection and Alignment --------------
        .TILE2_RXENMCOMMAALIGN0_IN      (tile2_rxenmcommaalign0_i),
        .TILE2_RXENMCOMMAALIGN1_IN      (tile2_rxenmcommaalign1_i),
        .TILE2_RXENPCOMMAALIGN0_IN      (tile2_rxenpcommaalign0_i),
        .TILE2_RXENPCOMMAALIGN1_IN      (tile2_rxenpcommaalign1_i),
        //----------------- Receive Ports - RX Data Path interface -----------------
        .TILE2_RXDATA0_OUT              (tile2_rxdata0_i),
        .TILE2_RXDATA1_OUT              (tile2_rxdata1_i),
        .TILE2_RXRESET0_IN              (tile2_rxreset0_i),
        .TILE2_RXRESET1_IN              (tile2_rxreset1_i),
        .TILE2_RXUSRCLK0_IN             (tile3_txusrclk0_i),
        .TILE2_RXUSRCLK1_IN             (tile3_txusrclk0_i),
        .TILE2_RXUSRCLK20_IN            (tile3_txusrclk20_i),
        .TILE2_RXUSRCLK21_IN            (tile3_txusrclk20_i),
        //----- Receive Ports - RX Driver,OOB signalling,Coupling and Eq.,CDR ------
        .TILE2_RXN0_IN                  (RXN_IN[4]),
        .TILE2_RXN1_IN                  (RXN_IN[5]),
        .TILE2_RXP0_IN                  (RXP_IN[4]),
        .TILE2_RXP1_IN                  (RXP_IN[5]),
        //------------- Receive Ports - RX Loss-of-sync State Machine --------------
        .TILE2_RXLOSSOFSYNC0_OUT        (tile2_rxlossofsync0_i),
        .TILE2_RXLOSSOFSYNC1_OUT        (tile2_rxlossofsync1_i),
        //------------------- Shared Ports - Tile and PLL Ports --------------------
        .TILE2_CLKIN_IN                 (tile2_refclk_i),
        .TILE2_GTPRESET_IN              (tile2_gtpreset_i),
        .TILE2_PLLLKDET_OUT             (tile2_plllkdet_i),
        .TILE2_REFCLKOUT_OUT            (tile2_refclkout_i),
        .TILE2_RESETDONE0_OUT           (tile2_resetdone0_i),
        .TILE2_RESETDONE1_OUT           (tile2_resetdone1_i),
        //-------------- Transmit Ports - 8b10b Encoder Control Ports --------------
        .TILE2_TXCHARISK0_IN            (tile2_txcharisk0_i),
        .TILE2_TXCHARISK1_IN            (tile2_txcharisk1_i),
        //---------------- Transmit Ports - TX Data Path interface -----------------
        .TILE2_TXDATA0_IN               (tile2_txdata0_i),
        .TILE2_TXDATA1_IN               (tile2_txdata1_i),
        .TILE2_TXOUTCLK0_OUT            (tile2_txoutclk0_i),
        .TILE2_TXOUTCLK1_OUT            (tile2_txoutclk1_i),
        .TILE2_TXUSRCLK0_IN             (tile3_txusrclk0_i),
        .TILE2_TXUSRCLK1_IN             (tile3_txusrclk0_i),
        .TILE2_TXUSRCLK20_IN            (tile3_txusrclk20_i),
        .TILE2_TXUSRCLK21_IN            (tile3_txusrclk20_i),
        //------------- Transmit Ports - TX Driver and OOB signalling --------------
        .TILE2_TXDIFFCTRL0_IN           (tile2_txdiffctrl0_i),
        .TILE2_TXDIFFCTRL1_IN           (tile2_txdiffctrl1_i),
        .TILE2_TXN0_OUT                 (TXN_OUT[4]),
        .TILE2_TXN1_OUT                 (TXN_OUT[5]),
        .TILE2_TXP0_OUT                 (TXP_OUT[4]),
        .TILE2_TXP1_OUT                 (TXP_OUT[5]),
        .TILE2_TXPREEMPHASIS0_IN        (tile2_txpreemphasis0_i),
        .TILE2_TXPREEMPHASIS1_IN        (tile2_txpreemphasis1_i),


    
        //_____________________________________________________________________
        //_____________________________________________________________________
        //TILE3  (X0Y3)

        //---------------------- Loopback and Powerdown Ports ----------------------
        .TILE3_LOOPBACK0_IN             (tile3_loopback0_i),
        .TILE3_LOOPBACK1_IN             (tile3_loopback1_i),
        //--------------------- Receive Ports - 8b10b Decoder ----------------------
        .TILE3_RXDISPERR0_OUT           (tile3_rxdisperr0_i),
        .TILE3_RXDISPERR1_OUT           (tile3_rxdisperr1_i),
        .TILE3_RXNOTINTABLE0_OUT        (tile3_rxnotintable0_i),
        .TILE3_RXNOTINTABLE1_OUT        (tile3_rxnotintable1_i),
        //------------- Receive Ports - Comma Detection and Alignment --------------
        .TILE3_RXENMCOMMAALIGN0_IN      (tile3_rxenmcommaalign0_i),
        .TILE3_RXENMCOMMAALIGN1_IN      (tile3_rxenmcommaalign1_i),
        .TILE3_RXENPCOMMAALIGN0_IN      (tile3_rxenpcommaalign0_i),
        .TILE3_RXENPCOMMAALIGN1_IN      (tile3_rxenpcommaalign1_i),
        //----------------- Receive Ports - RX Data Path interface -----------------
        .TILE3_RXDATA0_OUT              (tile3_rxdata0_i),
        .TILE3_RXDATA1_OUT              (tile3_rxdata1_i),
        .TILE3_RXRESET0_IN              (tile3_rxreset0_i),
        .TILE3_RXRESET1_IN              (tile3_rxreset1_i),
        .TILE3_RXUSRCLK0_IN             (tile3_txusrclk0_i),
        .TILE3_RXUSRCLK1_IN             (tile3_txusrclk0_i),
        .TILE3_RXUSRCLK20_IN            (tile3_txusrclk20_i),
        .TILE3_RXUSRCLK21_IN            (tile3_txusrclk20_i),
        //----- Receive Ports - RX Driver,OOB signalling,Coupling and Eq.,CDR ------
        .TILE3_RXN0_IN                  (RXN_IN[6]),
        .TILE3_RXN1_IN                  (RXN_IN[7]),
        .TILE3_RXP0_IN                  (RXP_IN[6]),
        .TILE3_RXP1_IN                  (RXP_IN[7]),
        //------------- Receive Ports - RX Loss-of-sync State Machine --------------
        .TILE3_RXLOSSOFSYNC0_OUT        (tile3_rxlossofsync0_i),
        .TILE3_RXLOSSOFSYNC1_OUT        (tile3_rxlossofsync1_i),
        //------------------- Shared Ports - Tile and PLL Ports --------------------
        .TILE3_CLKIN_IN                 (tile3_refclk_i),
        .TILE3_GTPRESET_IN              (tile3_gtpreset_i),
        .TILE3_PLLLKDET_OUT             (tile3_plllkdet_i),
        .TILE3_REFCLKOUT_OUT            (tile3_refclkout_i),
        .TILE3_RESETDONE0_OUT           (tile3_resetdone0_i),
        .TILE3_RESETDONE1_OUT           (tile3_resetdone1_i),
        //-------------- Transmit Ports - 8b10b Encoder Control Ports --------------
        .TILE3_TXCHARISK0_IN            (tile3_txcharisk0_i),
        .TILE3_TXCHARISK1_IN            (tile3_txcharisk1_i),
        //---------------- Transmit Ports - TX Data Path interface -----------------
        .TILE3_TXDATA0_IN               (tile3_txdata0_i),
        .TILE3_TXDATA1_IN               (tile3_txdata1_i),
        .TILE3_TXOUTCLK0_OUT            (tile3_txoutclk0_i),
        .TILE3_TXOUTCLK1_OUT            (tile3_txoutclk1_i),
        .TILE3_TXUSRCLK0_IN             (tile3_txusrclk0_i),
        .TILE3_TXUSRCLK1_IN             (tile3_txusrclk0_i),
        .TILE3_TXUSRCLK20_IN            (tile3_txusrclk20_i),
        .TILE3_TXUSRCLK21_IN            (tile3_txusrclk20_i),
        //------------- Transmit Ports - TX Driver and OOB signalling --------------
        .TILE3_TXDIFFCTRL0_IN           (tile3_txdiffctrl0_i),
        .TILE3_TXDIFFCTRL1_IN           (tile3_txdiffctrl1_i),
        .TILE3_TXN0_OUT                 (TXN_OUT[6]),
        .TILE3_TXN1_OUT                 (TXN_OUT[7]),
        .TILE3_TXP0_OUT                 (TXP_OUT[6]),
        .TILE3_TXP1_OUT                 (TXP_OUT[7]),
        .TILE3_TXPREEMPHASIS0_IN        (tile3_txpreemphasis0_i),
        .TILE3_TXPREEMPHASIS1_IN        (tile3_txpreemphasis1_i)


    );


    //---------------------------- Frame Generators ---------------------------
    // The example design uses Block RAM based frame generators to provide test
    // data to the GTPs for transmission. By default the frame generators are 
    // loaded with an incrementing data sequence that includes commas/alignment
    // characters for alignment. If your protocol uses channel bonding, the 
    // frame generator will also be preloaded with a channel bonding sequence.
    
    // You can modify the data transmitted by changing the INIT values of the frame
    // generator in this file. Pay careful attention to bit order and the spacing
    // of your control and alignment characters.

    FRAME_GEN #
    (
        .WORDS_IN_BRAM(EXAMPLE_WORDS_IN_BRAM),
        .MEM_00(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_01(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_02(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_03(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_04(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_05(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_06(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_07(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_08(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_09(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_0A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_0B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_0C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_0D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_0E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_0F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_10(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_11(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_12(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_13(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_14(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_15(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_16(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_17(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_18(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_19(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_1A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_1B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_1C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_1D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_1E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_1F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_20(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_21(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_22(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_23(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_24(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_25(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_26(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_27(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_28(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_29(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_2A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_2B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_2C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_2D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_2E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_2F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_30(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_31(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_32(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_33(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_34(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_35(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_36(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_37(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_38(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_39(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_3A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_3B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_3C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_3D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_3E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_3F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEMP_00(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_01(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_02(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_03(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_04(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_05(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_06(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_07(256'h0000000000000000000000000000000000000000000000000000000000000001)
    )
    tile0_frame_gen0
    (
        // User Interface
        .TX_DATA                        ({tile0_txdata0_float_i,tile0_txdata0_i}),
        .TX_CHARISK                     ({tile0_txcharisk0_float_i,tile0_txcharisk0_i}),
        // System Interface
        .USER_CLK                       (tile0_txusrclk20_i),
        .SYSTEM_RESET                   (tx_system_reset_c)
    );
    
    FRAME_GEN #
    (
        .WORDS_IN_BRAM(EXAMPLE_WORDS_IN_BRAM),
        .MEM_00(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_01(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_02(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_03(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_04(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_05(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_06(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_07(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_08(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_09(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_0A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_0B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_0C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_0D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_0E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_0F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_10(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_11(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_12(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_13(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_14(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_15(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_16(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_17(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_18(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_19(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_1A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_1B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_1C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_1D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_1E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_1F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_20(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_21(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_22(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_23(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_24(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_25(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_26(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_27(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_28(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_29(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_2A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_2B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_2C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_2D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_2E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_2F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_30(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_31(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_32(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_33(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_34(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_35(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_36(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_37(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_38(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_39(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_3A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_3B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_3C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_3D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_3E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_3F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEMP_00(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_01(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_02(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_03(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_04(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_05(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_06(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_07(256'h0000000000000000000000000000000000000000000000000000000000000001)
    )
    tile0_frame_gen1
    (
        // User Interface
        .TX_DATA                        ({tile0_txdata1_float_i,tile0_txdata1_i}),
        .TX_CHARISK                     ({tile0_txcharisk1_float_i,tile0_txcharisk1_i}),
        // System Interface
        .USER_CLK                       (tile0_txusrclk20_i),
        .SYSTEM_RESET                   (tx_system_reset_c)
    );
    
    FRAME_GEN #
    (
        .WORDS_IN_BRAM(EXAMPLE_WORDS_IN_BRAM),
        .MEM_00(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_01(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_02(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_03(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_04(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_05(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_06(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_07(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_08(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_09(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_0A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_0B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_0C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_0D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_0E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_0F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_10(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_11(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_12(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_13(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_14(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_15(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_16(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_17(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_18(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_19(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_1A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_1B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_1C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_1D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_1E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_1F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_20(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_21(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_22(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_23(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_24(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_25(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_26(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_27(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_28(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_29(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_2A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_2B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_2C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_2D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_2E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_2F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_30(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_31(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_32(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_33(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_34(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_35(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_36(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_37(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_38(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_39(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_3A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_3B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_3C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_3D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_3E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_3F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEMP_00(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_01(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_02(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_03(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_04(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_05(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_06(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_07(256'h0000000000000000000000000000000000000000000000000000000000000001)
    )
    tile1_frame_gen0
    (
        // User Interface
        .TX_DATA                        ({tile1_txdata0_float_i,tile1_txdata0_i}),
        .TX_CHARISK                     ({tile1_txcharisk0_float_i,tile1_txcharisk0_i}),
        // System Interface
        .USER_CLK                       (tile1_txusrclk20_i),
        .SYSTEM_RESET                   (tx_system_reset_c)
    );
    
    FRAME_GEN #
    (
        .WORDS_IN_BRAM(EXAMPLE_WORDS_IN_BRAM),
        .MEM_00(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_01(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_02(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_03(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_04(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_05(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_06(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_07(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_08(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_09(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_0A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_0B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_0C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_0D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_0E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_0F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_10(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_11(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_12(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_13(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_14(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_15(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_16(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_17(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_18(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_19(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_1A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_1B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_1C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_1D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_1E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_1F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_20(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_21(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_22(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_23(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_24(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_25(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_26(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_27(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_28(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_29(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_2A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_2B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_2C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_2D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_2E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_2F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_30(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_31(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_32(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_33(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_34(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_35(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_36(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_37(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_38(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_39(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_3A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_3B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_3C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_3D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_3E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_3F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEMP_00(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_01(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_02(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_03(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_04(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_05(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_06(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_07(256'h0000000000000000000000000000000000000000000000000000000000000001)
    )
    tile1_frame_gen1
    (
        // User Interface
        .TX_DATA                        ({tile1_txdata1_float_i,tile1_txdata1_i}),
        .TX_CHARISK                     ({tile1_txcharisk1_float_i,tile1_txcharisk1_i}),
        // System Interface
        .USER_CLK                       (tile1_txusrclk20_i),
        .SYSTEM_RESET                   (tx_system_reset_c)
    );
    
    FRAME_GEN #
    (
        .WORDS_IN_BRAM(EXAMPLE_WORDS_IN_BRAM),
        .MEM_00(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_01(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_02(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_03(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_04(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_05(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_06(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_07(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_08(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_09(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_0A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_0B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_0C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_0D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_0E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_0F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_10(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_11(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_12(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_13(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_14(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_15(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_16(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_17(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_18(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_19(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_1A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_1B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_1C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_1D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_1E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_1F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_20(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_21(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_22(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_23(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_24(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_25(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_26(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_27(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_28(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_29(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_2A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_2B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_2C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_2D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_2E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_2F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_30(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_31(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_32(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_33(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_34(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_35(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_36(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_37(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_38(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_39(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_3A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_3B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_3C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_3D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_3E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_3F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEMP_00(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_01(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_02(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_03(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_04(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_05(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_06(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_07(256'h0000000000000000000000000000000000000000000000000000000000000001)
    )
    tile2_frame_gen0
    (
        // User Interface
        .TX_DATA                        ({tile2_txdata0_float_i,tile2_txdata0_i}),
        .TX_CHARISK                     ({tile2_txcharisk0_float_i,tile2_txcharisk0_i}),
        // System Interface
        .USER_CLK                       (tile2_txusrclk20_i),
        .SYSTEM_RESET                   (tx_system_reset_c)
    );
    
    FRAME_GEN #
    (
        .WORDS_IN_BRAM(EXAMPLE_WORDS_IN_BRAM),
        .MEM_00(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_01(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_02(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_03(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_04(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_05(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_06(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_07(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_08(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_09(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_0A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_0B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_0C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_0D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_0E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_0F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_10(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_11(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_12(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_13(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_14(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_15(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_16(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_17(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_18(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_19(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_1A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_1B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_1C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_1D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_1E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_1F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_20(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_21(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_22(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_23(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_24(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_25(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_26(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_27(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_28(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_29(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_2A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_2B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_2C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_2D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_2E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_2F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_30(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_31(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_32(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_33(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_34(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_35(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_36(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_37(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_38(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_39(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_3A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_3B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_3C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_3D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_3E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_3F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEMP_00(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_01(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_02(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_03(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_04(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_05(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_06(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_07(256'h0000000000000000000000000000000000000000000000000000000000000001)
    )
    tile2_frame_gen1
    (
        // User Interface
        .TX_DATA                        ({tile2_txdata1_float_i,tile2_txdata1_i}),
        .TX_CHARISK                     ({tile2_txcharisk1_float_i,tile2_txcharisk1_i}),
        // System Interface
        .USER_CLK                       (tile2_txusrclk20_i),
        .SYSTEM_RESET                   (tx_system_reset_c)
    );
    
    FRAME_GEN #
    (
        .WORDS_IN_BRAM(EXAMPLE_WORDS_IN_BRAM),
        .MEM_00(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_01(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_02(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_03(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_04(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_05(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_06(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_07(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_08(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_09(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_0A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_0B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_0C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_0D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_0E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_0F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_10(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_11(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_12(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_13(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_14(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_15(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_16(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_17(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_18(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_19(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_1A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_1B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_1C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_1D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_1E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_1F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_20(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_21(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_22(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_23(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_24(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_25(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_26(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_27(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_28(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_29(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_2A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_2B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_2C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_2D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_2E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_2F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_30(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_31(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_32(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_33(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_34(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_35(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_36(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_37(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_38(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_39(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_3A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_3B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_3C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_3D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_3E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_3F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEMP_00(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_01(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_02(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_03(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_04(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_05(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_06(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_07(256'h0000000000000000000000000000000000000000000000000000000000000001)
    )
    tile3_frame_gen0
    (
        // User Interface
        .TX_DATA                        ({tile3_txdata0_float_i,tile3_txdata0_i}),
        .TX_CHARISK                     ({tile3_txcharisk0_float_i,tile3_txcharisk0_i}),
        // System Interface
        .USER_CLK                       (tile3_txusrclk20_i),
        .SYSTEM_RESET                   (tx_system_reset_c)
    );
    
    FRAME_GEN #
    (
        .WORDS_IN_BRAM(EXAMPLE_WORDS_IN_BRAM),
        .MEM_00(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_01(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_02(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_03(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_04(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_05(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_06(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_07(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_08(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_09(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_0A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_0B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_0C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_0D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_0E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_0F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_10(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_11(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_12(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_13(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_14(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_15(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_16(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_17(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_18(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_19(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_1A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_1B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_1C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_1D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_1E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_1F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_20(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_21(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_22(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_23(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_24(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_25(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_26(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_27(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_28(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_29(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_2A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_2B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_2C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_2D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_2E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_2F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_30(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_31(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_32(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_33(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_34(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_35(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_36(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_37(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_38(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_39(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_3A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_3B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_3C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_3D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_3E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_3F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEMP_00(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_01(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_02(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_03(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_04(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_05(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_06(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_07(256'h0000000000000000000000000000000000000000000000000000000000000001)
    )
    tile3_frame_gen1
    (
        // User Interface
        .TX_DATA                        ({tile3_txdata1_float_i,tile3_txdata1_i}),
        .TX_CHARISK                     ({tile3_txcharisk1_float_i,tile3_txcharisk1_i}),
        // System Interface
        .USER_CLK                       (tile3_txusrclk20_i),
        .SYSTEM_RESET                   (tx_system_reset_c)
    );
    


    //-------------------------------- Frame Checkers -------------------------
    // The example design uses Block RAM based frame checkers to verify incoming  
    // data. By default the frame generators are loaded with a data sequence that 
    // matches the outgoing sequence of the frame generators for the TX ports.
    
    // You can modify the expected data sequence by changing the INIT values of the frame
    // checkers in this file. Pay careful attention to bit order and the spacing
    // of your control and alignment characters.
    
    // When the frame checker receives data, it attempts to synchronise to the 
    // incoming pattern by looking for the first sequence in the pattern. Once it 
    // finds the first sequence, it increments through the sequence, and indicates an 
    // error whenever the next value received does not match the expected value.

    assign tile0_frame_check0_reset_i = (EXAMPLE_CONFIG_INDEPENDENT_LANES==0)?reset_on_data_error_i:tile0_matchn0_i;

    // tile0_frame_check0 is always connected to the lane with the start of char
    // and this lane starts off the data checking on all the other lanes. The INC_IN port is tied off
    assign tile0_inc_in0_i = 1'b0;

    FRAME_CHECK #
    (
        .RX_DATA_WIDTH(16),
        .USE_COMMA(1),
        .WORDS_IN_BRAM(EXAMPLE_WORDS_IN_BRAM),
        .CONFIG_INDEPENDENT_LANES(1),
        .START_OF_PACKET_CHAR(16'h00bc),
        .MEM_00(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_01(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_02(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_03(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_04(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_05(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_06(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_07(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_08(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_09(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_0A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_0B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_0C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_0D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_0E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_0F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_10(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_11(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_12(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_13(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_14(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_15(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_16(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_17(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_18(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_19(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_1A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_1B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_1C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_1D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_1E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_1F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_20(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_21(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_22(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_23(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_24(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_25(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_26(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_27(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_28(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_29(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_2A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_2B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_2C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_2D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_2E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_2F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_30(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_31(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_32(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_33(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_34(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_35(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_36(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_37(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_38(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_39(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_3A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_3B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_3C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_3D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_3E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_3F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEMP_00(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_01(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_02(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_03(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_04(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_05(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_06(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_07(256'h0000000000000000000000000000000000000000000000000000000000000001)
    )
    tile0_frame_check0
    (
        // MGT Interface
        .RX_DATA                        (tile0_rxdata0_i),  
        .RX_ENMCOMMA_ALIGN              (tile0_rxenmcommaalign0_i),
        .RX_ENPCOMMA_ALIGN              (tile0_rxenpcommaalign0_i),
        .RX_ENCHAN_SYNC                 ( ),
        // Control Interface
        .INC_IN                         (tile0_inc_in0_i),
        .INC_OUT                        (tile0_inc_out0_i),
        .PATTERN_MATCH_N                (tile0_matchn0_i),
        .RESET_ON_ERROR                 (tile0_frame_check0_reset_i),
        // System Interface
        .USER_CLK                       (tile0_txusrclk20_i),
        .SYSTEM_RESET                   (tile0_rx_system_reset0_c),
        .ERROR_COUNT                    (tile0_error_count0_i)
  
    );
    
    assign tile0_frame_check1_reset_i = (EXAMPLE_CONFIG_INDEPENDENT_LANES==0)?reset_on_data_error_i:tile0_matchn1_i;

    // tile0_frame_check0 is always connected to the lane with the start of char
    // and this lane starts off the data checking on all the other lanes. The INC_IN port is tied off
    assign tile0_inc_in1_i = 1'b0;

    FRAME_CHECK #
    (
        .RX_DATA_WIDTH(16),
        .USE_COMMA(1),
        .WORDS_IN_BRAM(EXAMPLE_WORDS_IN_BRAM),
        .CONFIG_INDEPENDENT_LANES(1),
        .START_OF_PACKET_CHAR(16'h00bc),
        .MEM_00(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_01(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_02(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_03(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_04(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_05(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_06(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_07(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_08(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_09(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_0A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_0B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_0C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_0D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_0E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_0F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_10(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_11(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_12(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_13(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_14(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_15(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_16(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_17(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_18(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_19(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_1A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_1B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_1C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_1D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_1E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_1F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_20(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_21(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_22(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_23(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_24(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_25(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_26(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_27(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_28(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_29(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_2A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_2B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_2C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_2D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_2E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_2F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_30(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_31(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_32(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_33(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_34(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_35(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_36(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_37(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_38(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_39(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_3A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_3B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_3C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_3D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_3E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_3F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEMP_00(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_01(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_02(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_03(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_04(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_05(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_06(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_07(256'h0000000000000000000000000000000000000000000000000000000000000001)
    )
    tile0_frame_check1
    (
        // MGT Interface
        .RX_DATA                        (tile0_rxdata1_i),  
        .RX_ENMCOMMA_ALIGN              (tile0_rxenmcommaalign1_i),
        .RX_ENPCOMMA_ALIGN              (tile0_rxenpcommaalign1_i),
        .RX_ENCHAN_SYNC                 ( ),
        // Control Interface
        .INC_IN                         (tile0_inc_in1_i),
        .INC_OUT                        (tile0_inc_out1_i),
        .PATTERN_MATCH_N                (tile0_matchn1_i),
        .RESET_ON_ERROR                 (tile0_frame_check1_reset_i),
        // System Interface
        .USER_CLK                       (tile0_txusrclk20_i),
        .SYSTEM_RESET                   (tile0_rx_system_reset1_c),
        .ERROR_COUNT                    (tile0_error_count1_i)
  
    );
    
    assign tile1_frame_check0_reset_i = (EXAMPLE_CONFIG_INDEPENDENT_LANES==0)?reset_on_data_error_i:tile1_matchn0_i;

    // in the "independent lanes" configuration, each of the lanes looks for the unique start char and
    // in this case, the INC_IN port is tied off.
    // Else, the data checking is triggered by the "master" lane
    assign tile1_inc_in0_i = (EXAMPLE_CONFIG_INDEPENDENT_LANES==0)?tile0_inc_out0_i:1'b0;

    FRAME_CHECK #
    (
        .RX_DATA_WIDTH(16),
        .USE_COMMA(1),
        .WORDS_IN_BRAM(EXAMPLE_WORDS_IN_BRAM),
        .CONFIG_INDEPENDENT_LANES(EXAMPLE_CONFIG_INDEPENDENT_LANES),
        .START_OF_PACKET_CHAR(16'h00bc),
        .MEM_00(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_01(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_02(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_03(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_04(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_05(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_06(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_07(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_08(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_09(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_0A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_0B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_0C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_0D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_0E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_0F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_10(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_11(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_12(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_13(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_14(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_15(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_16(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_17(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_18(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_19(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_1A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_1B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_1C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_1D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_1E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_1F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_20(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_21(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_22(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_23(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_24(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_25(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_26(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_27(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_28(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_29(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_2A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_2B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_2C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_2D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_2E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_2F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_30(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_31(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_32(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_33(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_34(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_35(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_36(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_37(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_38(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_39(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_3A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_3B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_3C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_3D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_3E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_3F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEMP_00(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_01(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_02(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_03(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_04(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_05(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_06(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_07(256'h0000000000000000000000000000000000000000000000000000000000000001)
    )
    tile1_frame_check0
    (
        // MGT Interface
        .RX_DATA                        (tile1_rxdata0_i),  
        .RX_ENMCOMMA_ALIGN              (tile1_rxenmcommaalign0_i),
        .RX_ENPCOMMA_ALIGN              (tile1_rxenpcommaalign0_i),
        .RX_ENCHAN_SYNC                 ( ),
        // Control Interface
        .INC_IN                         (tile1_inc_in0_i),
        .INC_OUT                        (tile1_inc_out0_i),
        .PATTERN_MATCH_N                (tile1_matchn0_i),
        .RESET_ON_ERROR                 (tile1_frame_check0_reset_i),
        // System Interface
        .USER_CLK                       (tile1_txusrclk20_i),
        .SYSTEM_RESET                   (tile1_rx_system_reset0_c),
        .ERROR_COUNT                    (tile1_error_count0_i)
  
    );
    
    assign tile1_frame_check1_reset_i = (EXAMPLE_CONFIG_INDEPENDENT_LANES==0)?reset_on_data_error_i:tile1_matchn1_i;

    // in the "independent lanes" configuration, each of the lanes looks for the unique start char and
    // in this case, the INC_IN port is tied off.
    // Else, the data checking is triggered by the "master" lane
    assign tile1_inc_in1_i = (EXAMPLE_CONFIG_INDEPENDENT_LANES==0)?tile0_inc_out1_i:1'b0;
    assign wb_err_o = tile1_error_count0_i[7];
    FRAME_CHECK #
    (
        .RX_DATA_WIDTH(16),
        .USE_COMMA(1),
        .WORDS_IN_BRAM(EXAMPLE_WORDS_IN_BRAM),
        .CONFIG_INDEPENDENT_LANES(EXAMPLE_CONFIG_INDEPENDENT_LANES),
        .START_OF_PACKET_CHAR(16'h00bc),
        .MEM_00(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_01(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_02(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_03(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_04(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_05(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_06(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_07(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_08(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_09(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_0A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_0B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_0C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_0D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_0E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_0F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_10(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_11(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_12(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_13(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_14(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_15(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_16(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_17(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_18(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_19(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_1A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_1B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_1C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_1D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_1E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_1F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_20(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_21(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_22(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_23(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_24(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_25(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_26(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_27(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_28(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_29(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_2A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_2B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_2C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_2D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_2E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_2F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_30(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_31(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_32(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_33(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_34(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_35(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_36(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_37(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_38(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_39(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_3A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_3B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_3C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_3D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_3E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_3F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEMP_00(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_01(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_02(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_03(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_04(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_05(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_06(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_07(256'h0000000000000000000000000000000000000000000000000000000000000001)
    )
    tile1_frame_check1
    (
        // MGT Interface
        .RX_DATA                        (tile1_rxdata1_i),  
        .RX_ENMCOMMA_ALIGN              (tile1_rxenmcommaalign1_i),
        .RX_ENPCOMMA_ALIGN              (tile1_rxenpcommaalign1_i),
        .RX_ENCHAN_SYNC                 ( ),
        // Control Interface
        .INC_IN                         (tile1_inc_in1_i),
        .INC_OUT                        (tile1_inc_out1_i),
        .PATTERN_MATCH_N                (tile1_matchn1_i),
        .RESET_ON_ERROR                 (tile1_frame_check1_reset_i),
        // System Interface
        .USER_CLK                       (tile1_txusrclk20_i),
        .SYSTEM_RESET                   (tile1_rx_system_reset1_c),
        .ERROR_COUNT                    (tile1_error_count1_i)
  
    );
    
    assign tile2_frame_check0_reset_i = (EXAMPLE_CONFIG_INDEPENDENT_LANES==0)?reset_on_data_error_i:tile2_matchn0_i;

    // in the "independent lanes" configuration, each of the lanes looks for the unique start char and
    // in this case, the INC_IN port is tied off.
    // Else, the data checking is triggered by the "master" lane
    assign tile2_inc_in0_i = (EXAMPLE_CONFIG_INDEPENDENT_LANES==0)?tile0_inc_out0_i:1'b0;

    FRAME_CHECK #
    (
        .RX_DATA_WIDTH(16),
        .USE_COMMA(1),
        .WORDS_IN_BRAM(EXAMPLE_WORDS_IN_BRAM),
        .CONFIG_INDEPENDENT_LANES(EXAMPLE_CONFIG_INDEPENDENT_LANES),
        .START_OF_PACKET_CHAR(16'h00bc),
        .MEM_00(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_01(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_02(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_03(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_04(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_05(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_06(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_07(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_08(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_09(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_0A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_0B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_0C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_0D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_0E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_0F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_10(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_11(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_12(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_13(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_14(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_15(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_16(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_17(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_18(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_19(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_1A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_1B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_1C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_1D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_1E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_1F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_20(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_21(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_22(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_23(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_24(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_25(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_26(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_27(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_28(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_29(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_2A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_2B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_2C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_2D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_2E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_2F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_30(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_31(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_32(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_33(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_34(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_35(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_36(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_37(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_38(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_39(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_3A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_3B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_3C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_3D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_3E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_3F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEMP_00(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_01(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_02(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_03(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_04(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_05(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_06(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_07(256'h0000000000000000000000000000000000000000000000000000000000000001)
    )
    tile2_frame_check0
    (
        // MGT Interface
        .RX_DATA                        (tile2_rxdata0_i),  
        .RX_ENMCOMMA_ALIGN              (tile2_rxenmcommaalign0_i),
        .RX_ENPCOMMA_ALIGN              (tile2_rxenpcommaalign0_i),
        .RX_ENCHAN_SYNC                 ( ),
        // Control Interface
        .INC_IN                         (tile2_inc_in0_i),
        .INC_OUT                        (tile2_inc_out0_i),
        .PATTERN_MATCH_N                (tile2_matchn0_i),
        .RESET_ON_ERROR                 (tile2_frame_check0_reset_i),
        // System Interface
        .USER_CLK                       (tile2_txusrclk20_i),
        .SYSTEM_RESET                   (tile2_rx_system_reset0_c),
        .ERROR_COUNT                    (tile2_error_count0_i)
  
    );
    
    assign tile2_frame_check1_reset_i = (EXAMPLE_CONFIG_INDEPENDENT_LANES==0)?reset_on_data_error_i:tile2_matchn1_i;

    // in the "independent lanes" configuration, each of the lanes looks for the unique start char and
    // in this case, the INC_IN port is tied off.
    // Else, the data checking is triggered by the "master" lane
    assign tile2_inc_in1_i = (EXAMPLE_CONFIG_INDEPENDENT_LANES==0)?tile0_inc_out1_i:1'b0;

    FRAME_CHECK #
    (
        .RX_DATA_WIDTH(16),
        .USE_COMMA(1),
        .WORDS_IN_BRAM(EXAMPLE_WORDS_IN_BRAM),
        .CONFIG_INDEPENDENT_LANES(EXAMPLE_CONFIG_INDEPENDENT_LANES),
        .START_OF_PACKET_CHAR(16'h00bc),
        .MEM_00(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_01(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_02(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_03(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_04(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_05(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_06(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_07(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_08(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_09(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_0A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_0B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_0C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_0D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_0E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_0F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_10(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_11(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_12(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_13(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_14(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_15(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_16(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_17(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_18(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_19(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_1A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_1B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_1C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_1D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_1E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_1F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_20(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_21(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_22(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_23(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_24(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_25(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_26(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_27(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_28(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_29(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_2A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_2B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_2C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_2D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_2E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_2F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_30(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_31(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_32(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_33(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_34(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_35(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_36(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_37(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_38(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_39(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_3A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_3B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_3C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_3D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_3E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_3F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEMP_00(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_01(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_02(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_03(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_04(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_05(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_06(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_07(256'h0000000000000000000000000000000000000000000000000000000000000001)
    )
    tile2_frame_check1
    (
        // MGT Interface
        .RX_DATA                        (tile2_rxdata1_i),  
        .RX_ENMCOMMA_ALIGN              (tile2_rxenmcommaalign1_i),
        .RX_ENPCOMMA_ALIGN              (tile2_rxenpcommaalign1_i),
        .RX_ENCHAN_SYNC                 ( ),
        // Control Interface
        .INC_IN                         (tile2_inc_in1_i),
        .INC_OUT                        (tile2_inc_out1_i),
        .PATTERN_MATCH_N                (tile2_matchn1_i),
        .RESET_ON_ERROR                 (tile2_frame_check1_reset_i),
        // System Interface
        .USER_CLK                       (tile2_txusrclk20_i),
        .SYSTEM_RESET                   (tile2_rx_system_reset1_c),
        .ERROR_COUNT                    (tile2_error_count1_i)
  
    );
    
    assign tile3_frame_check0_reset_i = (EXAMPLE_CONFIG_INDEPENDENT_LANES==0)?reset_on_data_error_i:tile3_matchn0_i;

    // in the "independent lanes" configuration, each of the lanes looks for the unique start char and
    // in this case, the INC_IN port is tied off.
    // Else, the data checking is triggered by the "master" lane
    assign tile3_inc_in0_i = (EXAMPLE_CONFIG_INDEPENDENT_LANES==0)?tile0_inc_out0_i:1'b0;

    FRAME_CHECK #
    (
        .RX_DATA_WIDTH(16),
        .USE_COMMA(1),
        .WORDS_IN_BRAM(EXAMPLE_WORDS_IN_BRAM),
        .CONFIG_INDEPENDENT_LANES(EXAMPLE_CONFIG_INDEPENDENT_LANES),
        .START_OF_PACKET_CHAR(16'h00bc),
        .MEM_00(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_01(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_02(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_03(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_04(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_05(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_06(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_07(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_08(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_09(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_0A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_0B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_0C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_0D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_0E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_0F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_10(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_11(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_12(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_13(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_14(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_15(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_16(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_17(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_18(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_19(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_1A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_1B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_1C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_1D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_1E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_1F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_20(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_21(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_22(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_23(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_24(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_25(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_26(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_27(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_28(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_29(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_2A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_2B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_2C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_2D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_2E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_2F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_30(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_31(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_32(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_33(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_34(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_35(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_36(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_37(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_38(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_39(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_3A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_3B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_3C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_3D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_3E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_3F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEMP_00(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_01(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_02(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_03(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_04(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_05(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_06(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_07(256'h0000000000000000000000000000000000000000000000000000000000000001)
    )
    tile3_frame_check0
    (
        // MGT Interface
        .RX_DATA                        (tile3_rxdata0_i),  
        .RX_ENMCOMMA_ALIGN              (tile3_rxenmcommaalign0_i),
        .RX_ENPCOMMA_ALIGN              (tile3_rxenpcommaalign0_i),
        .RX_ENCHAN_SYNC                 ( ),
        // Control Interface
        .INC_IN                         (tile3_inc_in0_i),
        .INC_OUT                        (tile3_inc_out0_i),
        .PATTERN_MATCH_N                (tile3_matchn0_i),
        .RESET_ON_ERROR                 (tile3_frame_check0_reset_i),
        // System Interface
        .USER_CLK                       (tile3_txusrclk20_i),
        .SYSTEM_RESET                   (tile3_rx_system_reset0_c),
        .ERROR_COUNT                    (tile3_error_count0_i)
  
    );
    
    assign tile3_frame_check1_reset_i = (EXAMPLE_CONFIG_INDEPENDENT_LANES==0)?reset_on_data_error_i:tile3_matchn1_i;

    // in the "independent lanes" configuration, each of the lanes looks for the unique start char and
    // in this case, the INC_IN port is tied off.
    // Else, the data checking is triggered by the "master" lane
    assign tile3_inc_in1_i = (EXAMPLE_CONFIG_INDEPENDENT_LANES==0)?tile0_inc_out1_i:1'b0;

    FRAME_CHECK #
    (
        .RX_DATA_WIDTH(16),
        .USE_COMMA(1),
        .WORDS_IN_BRAM(EXAMPLE_WORDS_IN_BRAM),
        .CONFIG_INDEPENDENT_LANES(EXAMPLE_CONFIG_INDEPENDENT_LANES),
        .START_OF_PACKET_CHAR(16'h00bc),
        .MEM_00(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_01(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_02(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_03(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_04(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_05(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_06(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_07(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_08(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_09(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_0A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_0B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_0C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_0D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_0E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_0F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_10(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_11(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_12(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_13(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_14(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_15(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_16(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_17(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_18(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_19(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_1A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_1B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_1C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_1D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_1E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_1F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_20(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_21(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_22(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_23(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_24(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_25(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_26(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_27(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_28(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_29(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_2A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_2B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_2C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_2D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_2E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_2F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_30(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_31(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_32(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_33(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_34(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_35(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_36(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_37(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEM_38(256'h00000e0d00000c0b00000a0900000807000006050000040300000201000000bc),
        .MEM_39(256'h00001e1d00001c1b00001a19000018170000161500001413000012110000100f),
        .MEM_3A(256'h00002e2d00002c2b00002a29000028270000262500002423000022210000201f),
        .MEM_3B(256'h00003e3d00003c3b00003a39000038370000363500003433000032310000302f),
        .MEM_3C(256'h00004e4d00004c4b00004a49000048470000464500004443000042410000403f),
        .MEM_3D(256'h00005e5d00005c5b00005a59000058570000565500005453000052510000504f),
        .MEM_3E(256'h00006e6d00006c6b00006a69000068670000666500006463000062610000605f),
        .MEM_3F(256'h0000007d00007c7b00007a79000078770000767500007473000072710000706f),
        .MEMP_00(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_01(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_02(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_03(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_04(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_05(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_06(256'h0000000000000000000000000000000000000000000000000000000000000001),
        .MEMP_07(256'h0000000000000000000000000000000000000000000000000000000000000001)
    )
    tile3_frame_check1
    (
        // MGT Interface
        .RX_DATA                        (tile3_rxdata1_i),  
        .RX_ENMCOMMA_ALIGN              (tile3_rxenmcommaalign1_i),
        .RX_ENPCOMMA_ALIGN              (tile3_rxenpcommaalign1_i),
        .RX_ENCHAN_SYNC                 ( ),
        // Control Interface
        .INC_IN                         (tile3_inc_in1_i),
        .INC_OUT                        (tile3_inc_out1_i),
        .PATTERN_MATCH_N                (tile3_matchn1_i),
        .RESET_ON_ERROR                 (tile3_frame_check1_reset_i),
        // System Interface
        .USER_CLK                       (tile3_txusrclk20_i),
        .SYSTEM_RESET                   (tile3_rx_system_reset1_c),
        .ERROR_COUNT                    (tile3_error_count1_i)
  
    );
    

endmodule

//-------------------------------------------------------------------
//
//  VIO core module declaration 
//  This one is for driving shared ports and is asynchronous
//
//-------------------------------------------------------------------
module shared_vio
  (
    control,
    async_in,
    async_out
  );
  input  [35:0] control;
  input  [31:0] async_in;
  output [31:0] async_out;
endmodule

//-------------------------------------------------------------------
//
//  ICON core module declaration
//
//-------------------------------------------------------------------
module icon 
  (
      control0,
      control1,
      control2,
      control3,
      control4,
      control5,
      control6
  );
  output [35:0] control0;
  output [35:0] control1;
  output [35:0] control2;
  output [35:0] control3;
  output [35:0] control4;
  output [35:0] control5;
  output [35:0] control6;
endmodule


//-------------------------------------------------------------------
//
//  ILA core module declaration
//  This is used to allow RX signals to be monitored
//
//-------------------------------------------------------------------
module ila
  (
    control,
    clk,
    trig0
  );
  input [35:0] control;
  input clk;
  input [63:0] trig0;
endmodule


