/////////////////////////////////////////////////////////////////////////
// Copyright (c) 2008 Xilinx, Inc.  All rights reserved.
//
//                 XILINX CONFIDENTIAL PROPERTY
// This   document  contains  proprietary information  which   is
// protected by  copyright. All rights  are reserved.  This notice
// refers to original work by Xilinx, Inc. which may be derivitive
// of other work distributed under license of the authors.  In the
// case of derivitive work, nothing in this notice overrides the
// original author's license agreeement.  Where applicable, the 
// original license agreement is included in it's original 
// unmodified form immediately below this header.
//
// Xilinx, Inc.
// XILINX IS PROVIDING THIS DESIGN, CODE, OR INFORMATION "AS IS" AS A
// COURTESY TO YOU.  BY PROVIDING THIS DESIGN, CODE, OR INFORMATION AS
// ONE POSSIBLE   IMPLEMENTATION OF THIS FEATURE, APPLICATION OR
// STANDARD, XILINX IS MAKING NO REPRESENTATION THAT THIS IMPLEMENTATION
// IS FREE FROM ANY CLAIMS OF INFRINGEMENT, AND YOU ARE RESPONSIBLE
// FOR OBTAINING ANY RIGHTS YOU MAY REQUIRE FOR YOUR IMPLEMENTATION.
// XILINX EXPRESSLY DISCLAIMS ANY WARRANTY WHATSOEVER WITH RESPECT TO
// THE ADEQUACY OF THE IMPLEMENTATION, INCLUDING BUT NOT LIMITED TO
// ANY WARRANTIES OR REPRESENTATIONS THAT THIS IMPLEMENTATION IS FREE
// FROM CLAIMS OF INFRINGEMENT, IMPLIED WARRANTIES OF MERCHANTABILITY
// AND FITNESS FOR A PARTICULAR PURPOSE.
//
/////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
//$Date: 2008/05/07 22:43:23 $
//$RCSfile: rocketio_wrapper_tile.v,v $
//$Revision: 1.1 $
///////////////////////////////////////////////////////////////////////////////
//   ____  ____ 
//  /   /\/   / 
// /___/  \  /    Vendor: Xilinx 
// \   \   \/     Version : 1.4 
//  \   \         Application : GTP Wizard 
//  /   /         Filename : rocketio_wrapper_tile.v
// /___/   /\     Timestamp : 02/08/2005 09:12:43
// \   \  /  \ 
//  \___\/\___\ 
//
//
// Module ROCKETIO_WRAPPER_TILE (a GTP Tile Wrapper)
// Generated by Xilinx GTP Wizard



`timescale 1ns / 1ps


//***************************** Entity Declaration ****************************

module ROCKETIO_WRAPPER_TILE #
(
    // Simulation attributes
    parameter   TILE_SIM_GTPRESET_SPEEDUP  =   0,      // Set to 1 to speed up sim reset
    parameter   TILE_SIM_PLL_PERDIV2       =   9'h140,    // Set to the VCO Unit Interval time
    
    // Channel bonding attributes
    parameter   TILE_CHAN_BOND_MODE_0      =   "OFF",  // "MASTER", "SLAVE", or "OFF"
    parameter   TILE_CHAN_BOND_LEVEL_0     =   0,      // 0 to 7. See UG for details
    
    parameter   TILE_CHAN_BOND_MODE_1      =   "OFF",  // "MASTER", "SLAVE", or "OFF"
    parameter   TILE_CHAN_BOND_LEVEL_1     =   0,       // 0 to 7. See UG for details
			 

//gtx_tests
    parameter   GTX_SIM_TXREFCLK_SOURCE    =   3'b000,
    parameter   GTX_SIM_RXREFCLK_SOURCE    =   3'b000,
    parameter   GTX_SIM_GTXRESET_SPEEDUP   =   0,      // Set to 1 to speed up sim reset
    
    // Share RX PLL parameter
    parameter   GTX_TX_CLK_SOURCE          =   "TXPLL",
    // Save power parameter
    parameter   GTX_POWER_SAVE             =   10'b0000110000    
    
)
(
    //---------------------- Loopback and Powerdown Ports ----------------------
    LOOPBACK0_IN,
    LOOPBACK1_IN,
    //--------------------- Receive Ports - 8b10b Decoder ----------------------
    RXDISPERR0_OUT,
    RXDISPERR1_OUT,
    RXNOTINTABLE0_OUT,
    RXNOTINTABLE1_OUT,
    //------------- Receive Ports - Comma Detection and Alignment --------------
    RXENMCOMMAALIGN0_IN,
    RXENMCOMMAALIGN1_IN,
    RXENPCOMMAALIGN0_IN,
    RXENPCOMMAALIGN1_IN,
    //----------------- Receive Ports - RX Data Path interface -----------------
    RXDATA0_OUT,
    RXDATA1_OUT,
    RXRESET0_IN,
    RXRESET1_IN,
    RXUSRCLK0_IN,
    RXUSRCLK1_IN,
    RXUSRCLK20_IN,
    RXUSRCLK21_IN,
    //----- Receive Ports - RX Driver,OOB signalling,Coupling and Eq.,CDR ------
    RXN0_IN,
    RXN1_IN,
    RXP0_IN,
    RXP1_IN,
    //------------- Receive Ports - RX Loss-of-sync State Machine --------------
    RXLOSSOFSYNC0_OUT,
    RXLOSSOFSYNC1_OUT,
    //------------------- Shared Ports - Tile and PLL Ports --------------------
    CLKIN_IN,
    GTPRESET_IN,
    PLLLKDET_OUT,
    REFCLKOUT_OUT,
    RESETDONE0_OUT,
    RESETDONE1_OUT,
    //-------------- Transmit Ports - 8b10b Encoder Control Ports --------------
    TXCHARISK0_IN,
    TXCHARISK1_IN,
    //---------------- Transmit Ports - TX Data Path interface -----------------
    TXDATA0_IN,
    TXDATA1_IN,
    TXOUTCLK0_OUT,
    TXOUTCLK1_OUT,
    TXUSRCLK0_IN,
    TXUSRCLK1_IN,
    TXUSRCLK20_IN,
    TXUSRCLK21_IN,
    //------------- Transmit Ports - TX Driver and OOB signalling --------------
    TXDIFFCTRL0_IN,
    TXDIFFCTRL1_IN,
    TXN0_OUT,
    TXN1_OUT,
    TXP0_OUT,
    TXP1_OUT,
    TXPREEMPHASIS0_IN,
    TXPREEMPHASIS1_IN


);

//***************************** Port Declarations *****************************
        

    //---------------------- Loopback and Powerdown Ports ----------------------
    input   [2:0]   LOOPBACK0_IN;
    input   [2:0]   LOOPBACK1_IN;
    //--------------------- Receive Ports - 8b10b Decoder ----------------------
    output  [1:0]   RXDISPERR0_OUT;
    output  [1:0]   RXDISPERR1_OUT;
    output  [1:0]   RXNOTINTABLE0_OUT;
    output  [1:0]   RXNOTINTABLE1_OUT;
    //------------- Receive Ports - Comma Detection and Alignment --------------
    input           RXENMCOMMAALIGN0_IN;
    input           RXENMCOMMAALIGN1_IN;
    input           RXENPCOMMAALIGN0_IN;
    input           RXENPCOMMAALIGN1_IN;
    //----------------- Receive Ports - RX Data Path interface -----------------
    output  [15:0]  RXDATA0_OUT;
    output  [15:0]  RXDATA1_OUT;
    input           RXRESET0_IN;
    input           RXRESET1_IN;
    input           RXUSRCLK0_IN;
    input           RXUSRCLK1_IN;
    input           RXUSRCLK20_IN;
    input           RXUSRCLK21_IN;
    //----- Receive Ports - RX Driver,OOB signalling,Coupling and Eq.,CDR ------
    input           RXN0_IN;
    input           RXN1_IN;
    input           RXP0_IN;
    input           RXP1_IN;
    //------------- Receive Ports - RX Loss-of-sync State Machine --------------
    output  [1:0]   RXLOSSOFSYNC0_OUT;
    output  [1:0]   RXLOSSOFSYNC1_OUT;
    //------------------- Shared Ports - Tile and PLL Ports --------------------
    input           CLKIN_IN;
    input           GTPRESET_IN;
    output          PLLLKDET_OUT;
    output          REFCLKOUT_OUT;
    output          RESETDONE0_OUT;
    output          RESETDONE1_OUT;
    //-------------- Transmit Ports - 8b10b Encoder Control Ports --------------
    input   [1:0]   TXCHARISK0_IN;
    input   [1:0]   TXCHARISK1_IN;
    //---------------- Transmit Ports - TX Data Path interface -----------------
    input   [15:0]  TXDATA0_IN;
    input   [15:0]  TXDATA1_IN;
    output          TXOUTCLK0_OUT;
    output          TXOUTCLK1_OUT;
    input           TXUSRCLK0_IN;
    input           TXUSRCLK1_IN;
    input           TXUSRCLK20_IN;
    input           TXUSRCLK21_IN;
    //------------- Transmit Ports - TX Driver and OOB signalling --------------
    input   [2:0]   TXDIFFCTRL0_IN;
    input   [2:0]   TXDIFFCTRL1_IN;
    output          TXN0_OUT;
    output          TXN1_OUT;
    output          TXP0_OUT;
    output          TXP1_OUT;
    input   [2:0]   TXPREEMPHASIS0_IN;
    input   [2:0]   TXPREEMPHASIS1_IN;



//***************************** Wire Declarations *****************************

    // ground and vcc signals
    wire            tied_to_ground_i;
    wire    [63:0]  tied_to_ground_vec_i;
    wire            tied_to_vcc_i;
    wire    [63:0]  tied_to_vcc_vec_i;


   

    //RX Datapath signals
    wire    [15:0]  rxdata0_i;       

    //TX Datapath signals
    wire    [15:0]  txdata0_i;           

    // Inverted TXUSRCLK2 for GTP0
    wire            txusrclk20_n;

    // Electrical idle reset logic signals
    wire    [2:0]   loopback0_i;
    wire            rxelecidle0_i;
    wire            resetdone0_i;
    wire            rxelecidlereset0_i;
    wire            serialloopback0_i;
   

    //RX Datapath signals
    wire    [15:0]  rxdata1_i;       

    //TX Datapath signals
    wire    [15:0]  txdata1_i;           

    // Inverted TXUSRCLK2 for GTP1
    wire            txusrclk21_n;

    // Electrical idle reset logic signals
    wire    [2:0]   loopback1_i;
    wire            rxelecidle1_i;
    wire            resetdone1_i;
    wire            rxelecidlereset1_i;
    wire            serialloopback1_i;

    // Shared Electrical Idle Reset signal
    wire            rxenelecidleresetb_i;



// 
//********************************* Main Body of Code**************************
                       
    //-------------------------  Static signal Assigments ---------------------   

    assign tied_to_ground_i             = 1'b0;
    assign tied_to_ground_vec_i         = 64'h0000000000000000;
    assign tied_to_vcc_i                = 1'b1;
    assign tied_to_vcc_vec_i            = 64'hffffffffffffffff;
                                            

    
    // Invert TXUSRCLK2 for GTP0 (Improves timing for 2 byte interface)
    assign  txusrclk20_n   =   !TXUSRCLK20_IN;

    // Invert TXUSRCLK2 for GTP1 (Improves timing for 2 byte interface)
    assign  txusrclk21_n   =   !TXUSRCLK21_IN;



    //-------------------  GTP Datapath byte mapping  -----------------
    
    
    // The GTP provides little endian data (first byte received on RXDATA[7:0])     
    assign  RXDATA0_OUT    =   rxdata0_i;

    // The GTP transmits little endian data (TXDATA[7:0] transmitted first)     
    assign  txdata0_i    =   TXDATA0_IN;
    
    // The GTP provides little endian data (first byte received on RXDATA[7:0])     
    assign  RXDATA1_OUT    =   rxdata1_i;

    // The GTP transmits little endian data (TXDATA[7:0] transmitted first)     
    assign  txdata1_i    =   TXDATA1_IN;







    //-------------------------  Electrical Idle Reset Circuit  ---------------

    assign  RESETDONE0_OUT              =   resetdone0_i;
    assign  loopback0_i                 =   LOOPBACK0_IN;
    assign  RESETDONE1_OUT              =   resetdone1_i;
    assign  loopback1_i                 =   LOOPBACK1_IN;

    assign  serialloopback0_i           =   !loopback0_i[0] && loopback0_i[1] && !loopback0_i[2];
    assign  serialloopback1_i           =   !loopback1_i[0] && loopback1_i[1] && !loopback1_i[2];

    //Drive RXELECIDLERESET with elec idle reset enabled during normal operation when RXELECIDLE goes high
    assign  rxelecidlereset0_i          =   (rxelecidle0_i && resetdone0_i) && !serialloopback0_i;
    assign  rxelecidlereset1_i          =   (rxelecidle1_i && resetdone1_i) && !serialloopback1_i;
    assign  rxenelecidleresetb_i        =   !(rxelecidlereset0_i||rxelecidlereset1_i);  


	
//throw in two gtxes?
											 

    //------------------------- GTX Instantiations  --------------------------
        GTXE1 #
        (
            //_______________________ Simulation-Only Attributes __________________
    
            .SIM_RECEIVER_DETECT_PASS   ("TRUE"),
            
            .SIM_TX_ELEC_IDLE_LEVEL     ("X"),
    
            .SIM_GTXRESET_SPEEDUP       (GTX_SIM_GTXRESET_SPEEDUP),
            .SIM_VERSION                ("1.0"),
            .SIM_TXREFCLK_SOURCE        (GTX_SIM_TXREFCLK_SOURCE),
            .SIM_RXREFCLK_SOURCE        (GTX_SIM_RXREFCLK_SOURCE),
            

           //--------------------------TX PLL----------------------------
            .TX_CLK_SOURCE                          (GTX_TX_CLK_SOURCE),
            .TX_OVERSAMPLE_MODE                     ("FALSE"),
            .TXPLL_COM_CFG                          (24'h21680a),
            .TXPLL_CP_CFG                           (8'h00),
            .TXPLL_DIVSEL_FB                        (5),
            .TXPLL_DIVSEL_OUT                       (1),
            .TXPLL_DIVSEL_REF                       (2),
            .TXPLL_DIVSEL45_FB                      (4),
            .TXPLL_LKDET_CFG                        (3'b111),
            .TX_CLK25_DIVIDER                       (7),
            .TXPLL_SATA                             (2'b00),
            .TX_TDCC_CFG                            (2'b00),
            .PMA_CAS_CLK_EN                         ("FALSE"),
            .POWER_SAVE                             (GTX_POWER_SAVE),

           //-----------------------TX Interface-------------------------
            .GEN_TXUSRCLK                           ("TRUE"),
            .TX_DATA_WIDTH                          (16),
            .TX_USRCLK_CFG                          (6'h00),
            .TXOUTCLK_CTRL                          ("TXOUTCLKPMA_DIV2"),
            .TXOUTCLK_DLY                           (10'b0000000000),

           //------------TX Buffering and Phase Alignment----------------
            .TX_PMADATA_OPT                         (1'b0),
            .PMA_TX_CFG                             (20'h00082),
            .TX_BUFFER_USE                          ("TRUE"),
            .TX_BYTECLK_CFG                         (6'h00),
            .TX_EN_RATE_RESET_BUF                   ("TRUE"),
            .TX_XCLK_SEL                            ("TXOUT"),
            .TX_DLYALIGN_CTRINC                     (4'b0100),
            .TX_DLYALIGN_LPFINC                     (4'b0111),
            .TX_DLYALIGN_MONSEL                     (3'b000),
            .TX_DLYALIGN_OVRDSETTING                (8'b00000000),

           //-----------------------TX Gearbox---------------------------
            .GEARBOX_ENDEC                          (3'b000),
            .TXGEARBOX_USE                          ("FALSE"),

           //--------------TX Driver and OOB Signalling------------------
            .TX_DRIVE_MODE                          ("DIRECT"),
            .TX_IDLE_ASSERT_DELAY                   (3'b100),
            .TX_IDLE_DEASSERT_DELAY                 (3'b010),
            .TXDRIVE_LOOPBACK_HIZ                   ("FALSE"),
            .TXDRIVE_LOOPBACK_PD                    ("FALSE"),

           //------------TX Pipe Control for PCI Express/SATA------------
            .COM_BURST_VAL                          (4'b1111),

           //----------------TX Attributes for PCI Express---------------
            .TX_DEEMPH_0                            (5'b11010),
            .TX_DEEMPH_1                            (5'b10000),
            .TX_MARGIN_FULL_0                       (7'b1001110),
            .TX_MARGIN_FULL_1                       (7'b1001001),
            .TX_MARGIN_FULL_2                       (7'b1000101),
            .TX_MARGIN_FULL_3                       (7'b1000010),
            .TX_MARGIN_FULL_4                       (7'b1000000),
            .TX_MARGIN_LOW_0                        (7'b1000110),
            .TX_MARGIN_LOW_1                        (7'b1000100),
            .TX_MARGIN_LOW_2                        (7'b1000010),
            .TX_MARGIN_LOW_3                        (7'b1000000),
            .TX_MARGIN_LOW_4                        (7'b1000000),

           //--------------------------RX PLL----------------------------
            .RX_OVERSAMPLE_MODE                     ("FALSE"),
            .RXPLL_COM_CFG                          (24'h21680a),
            .RXPLL_CP_CFG                           (8'h00),
            .RXPLL_DIVSEL_FB                        (5),
            .RXPLL_DIVSEL_OUT                       (1),
            .RXPLL_DIVSEL_REF                       (2),
            .RXPLL_DIVSEL45_FB                      (4),
            .RXPLL_LKDET_CFG                        (3'b111),
            .RX_CLK25_DIVIDER                       (7),

           //-----------------------RX Interface-------------------------
            .GEN_RXUSRCLK                           ("TRUE"),
            .RX_DATA_WIDTH                          (16),
            .RXRECCLK_CTRL                          ("RXRECCLKPMA_DIV2"),
            .RXRECCLK_DLY                           (10'b0000000000),
            .RXUSRCLK_DLY                           (16'h0000),

           //--------RX Driver,OOB signalling,Coupling and Eq.,CDR-------
            .AC_CAP_DIS                             ("FALSE"),
            .CDR_PH_ADJ_TIME                        (5'b10100),
            .OOBDETECT_THRESHOLD                    (3'b000),
            .PMA_CDR_SCAN                           (27'h6404040),
            .PMA_RX_CFG                             (25'h05ce049),
            .RCV_TERM_GND                           ("FALSE"),
            .RCV_TERM_VTTRX                         ("TRUE"),
            .RX_EN_IDLE_HOLD_CDR                    ("FALSE"),
            .RX_EN_IDLE_RESET_FR                    ("TRUE"),
            .RX_EN_IDLE_RESET_PH                    ("TRUE"),
            .TX_DETECT_RX_CFG                       (14'h1832),
            .TERMINATION_CTRL                       (5'b10100),
            .TERMINATION_OVRD                       ("FALSE"),
            .CM_TRIM                                (2'b00),
            .PMA_RXSYNC_CFG                         (7'h00),
            .PMA_CFG                                (76'h0000000000000000000),
            .BGTEST_CFG                             (2'b00),
            .BIAS_CFG                               (17'h00000),

           //------------RX Decision Feedback Equalizer(DFE)-------------
            .DFE_CAL_TIME                           (5'b01100),
            .DFE_CFG                                (8'b01111011),
            .RX_EN_IDLE_HOLD_DFE                    ("TRUE"),
            .RX_EYE_OFFSET                          (8'h40),
            .RX_EYE_SCANMODE                        (2'h0),

           //-----------------------PRBS Detection-----------------------

           //----------------Comma Detection and Alignment---------------
            .ALIGN_COMMA_WORD                       (1),
            .COMMA_10B_ENABLE                       (10'b1111111111),
            .COMMA_DOUBLE                           ("FALSE"),
            .DEC_MCOMMA_DETECT                      ("FALSE"),
            .DEC_PCOMMA_DETECT                      ("FALSE"),
            .DEC_VALID_COMMA_ONLY                   ("FALSE"),
            .MCOMMA_10B_VALUE                       (10'b1010000011),
            .MCOMMA_DETECT                          ("TRUE"),
            .PCOMMA_10B_VALUE                       (10'b0101111100),
            .PCOMMA_DETECT                          ("TRUE"),
            .RX_DECODE_SEQ_MATCH                    ("FALSE"),
            .RX_SLIDE_AUTO_WAIT                     (5),
            .RX_SLIDE_MODE                          ("OFF"),
            .SHOW_REALIGN_COMMA                     ("TRUE"),

           //---------------RX Loss-of-sync State Machine----------------
            .RX_LOS_INVALID_INCR                    (8),
            .RX_LOS_THRESHOLD                       (128),
            .RX_LOSS_OF_SYNC_FSM                    ("FALSE"),

           //-----------------------RX Gearbox---------------------------
            .RXGEARBOX_USE                          ("FALSE"),

           //-----------RX Elastic Buffer and Phase alignment------------
            .RX_BUFFER_USE                          ("TRUE"),
            .RX_EN_IDLE_RESET_BUF                   ("TRUE"),
            .RX_EN_MODE_RESET_BUF                   ("TRUE"),
            .RX_EN_RATE_RESET_BUF                   ("TRUE"),
            .RX_EN_REALIGN_RESET_BUF                ("FALSE"),
            .RX_EN_REALIGN_RESET_BUF2               ("FALSE"),
            .RX_FIFO_ADDR_MODE                      ("FULL"),
            .RX_IDLE_HI_CNT                         (4'b1000),
            .RX_IDLE_LO_CNT                         (4'b0000),
            .RX_XCLK_SEL                            ("RXREC"),
            .RX_DLYALIGN_CTRINC                     (4'b0100),
            .RX_DLYALIGN_EDGESET                    (5'b00110),
            .RX_DLYALIGN_LPFINC                     (4'b0111),
            .RX_DLYALIGN_MONSEL                     (3'b000),
            .RX_DLYALIGN_OVRDSETTING                (8'b00000000),

           //----------------------Clock Correction----------------------
            .CLK_COR_ADJ_LEN                        (1),
            .CLK_COR_DET_LEN                        (1),
            .CLK_COR_INSERT_IDLE_FLAG               ("FALSE"),
            .CLK_COR_KEEP_IDLE                      ("FALSE"),
            .CLK_COR_MAX_LAT                        (16),
            .CLK_COR_MIN_LAT                        (14),
            .CLK_COR_PRECEDENCE                     ("TRUE"),
            .CLK_COR_REPEAT_WAIT                    (0),
            .CLK_COR_SEQ_1_1                        (10'b0000000000),
            .CLK_COR_SEQ_1_2                        (10'b0000000000),
            .CLK_COR_SEQ_1_3                        (10'b0000000000),
            .CLK_COR_SEQ_1_4                        (10'b0000000000),
            .CLK_COR_SEQ_1_ENABLE                   (4'b1111),
            .CLK_COR_SEQ_2_1                        (10'b0000000000),
            .CLK_COR_SEQ_2_2                        (10'b0000000000),
            .CLK_COR_SEQ_2_3                        (10'b0000000000),
            .CLK_COR_SEQ_2_4                        (10'b0000000000),
            .CLK_COR_SEQ_2_ENABLE                   (4'b1111),
            .CLK_COR_SEQ_2_USE                      ("FALSE"),
            .CLK_CORRECT_USE                        ("FALSE"),

           //----------------------Channel Bonding----------------------
            .CHAN_BOND_1_MAX_SKEW                   (1),
            .CHAN_BOND_2_MAX_SKEW                   (1),
            .CHAN_BOND_KEEP_ALIGN                   ("FALSE"),
            .CHAN_BOND_SEQ_1_1                      (10'b0000000000),
            .CHAN_BOND_SEQ_1_2                      (10'b0000000000),
            .CHAN_BOND_SEQ_1_3                      (10'b0000000000),
            .CHAN_BOND_SEQ_1_4                      (10'b0000000000),
            .CHAN_BOND_SEQ_1_ENABLE                 (4'b1111),
            .CHAN_BOND_SEQ_2_1                      (10'b0000000000),
            .CHAN_BOND_SEQ_2_2                      (10'b0000000000),
            .CHAN_BOND_SEQ_2_3                      (10'b0000000000),
            .CHAN_BOND_SEQ_2_4                      (10'b0000000000),
            .CHAN_BOND_SEQ_2_CFG                    (5'b00000),
            .CHAN_BOND_SEQ_2_ENABLE                 (4'b1111),
            .CHAN_BOND_SEQ_2_USE                    ("FALSE"),
            .CHAN_BOND_SEQ_LEN                      (1),
            .PCI_EXPRESS_MODE                       ("FALSE"),

           //-----------RX Attributes for PCI Express/SATA/SAS----------
            .SAS_MAX_COMSAS                         (52),
            .SAS_MIN_COMSAS                         (40),
            .SATA_BURST_VAL                         (3'b100),
            .SATA_IDLE_VAL                          (3'b100),
            .SATA_MAX_BURST                         (7),
            .SATA_MAX_INIT                          (22),
            .SATA_MAX_WAKE                          (7),
            .SATA_MIN_BURST                         (4),
            .SATA_MIN_INIT                          (12),
            .SATA_MIN_WAKE                          (4),
            .TRANS_TIME_FROM_P2                     (12'h03c),
            .TRANS_TIME_NON_P2                      (8'h19),
            .TRANS_TIME_RATE                        (8'hff),
            .TRANS_TIME_TO_P2                       (10'h064)

            
        ) 
        gtxe0_i 
        (
        
        //---------------------- Loopback and Powerdown Ports ----------------------
        .LOOPBACK                       (LOOPBACK0_IN),
        .RXPOWERDOWN                    (tied_to_ground_vec_i[1:0]),
        .TXPOWERDOWN                    (tied_to_ground_vec_i[1:0]),
        //------------ Receive Ports - 64b66b and 64b67b Gearbox Ports -------------
        .RXDATAVALID                    (),
        .RXGEARBOXSLIP                  (tied_to_ground_i),
        .RXHEADER                       (),
        .RXHEADERVALID                  (),
        .RXSTARTOFSEQ                   (),
        //--------------------- Receive Ports - 8b10b Decoder ----------------------
        .RXCHARISCOMMA                  (),
        .RXCHARISK                      (),
        .RXDEC8B10BUSE                  (tied_to_ground_i),
        .RXDISPERR                      (RXDISPERR0_OUT),
        .RXNOTINTABLE                   (RXNOTINTAVBLE0_OUT),
        .RXRUNDISP                      (),
        .USRCODEERR                     (tied_to_ground_i),
        //----------------- Receive Ports - Channel Bonding Ports ------------------
        .RXCHANBONDSEQ                  (),
        .RXCHBONDI                      (tied_to_ground_vec_i[3:0]),
        .RXCHBONDLEVEL                  (tied_to_ground_vec_i[2:0]),
        .RXCHBONDMASTER                 (tied_to_ground_i),
        .RXCHBONDO                      (),
        .RXCHBONDSLAVE                  (tied_to_ground_i),
        .RXENCHANSYNC                   (tied_to_ground_i),
        //----------------- Receive Ports - Clock Correction Ports -----------------
        .RXCLKCORCNT                    (),
        //------------- Receive Ports - Comma Detection and Alignment --------------
        .RXBYTEISALIGNED                (),
        .RXBYTEREALIGN                  (),
        .RXCOMMADET                     (RXCOMMADET_OUT),
        .RXCOMMADETUSE                  (tied_to_vcc_i),
        .RXENMCOMMAALIGN                (RXENMCOMMAALIGN0_IN),
        .RXENPCOMMAALIGN                (RXENPCOMMAALIGN0_IN),
        .RXSLIDE                        (tied_to_ground_i),
        //--------------------- Receive Ports - PRBS Detection ---------------------
        .PRBSCNTRESET                   (tied_to_ground_i),
        .RXENPRBSTST                    (tied_to_ground_vec_i[2:0]),
        .RXPRBSERR                      (),
        //----------------- Receive Ports - RX Data Path interface -----------------
        .RXDATA                         (rxdata0_i),
        .RXRECCLK                       (),
        .RXRECCLKPCS                    (),
        .RXRESET                        (RXRESET0_IN),
        .RXUSRCLK                       (RXUSRCLK0_IN),
        .RXUSRCLK2                      (RXUSRCLK20_IN),
        //---------- Receive Ports - RX Decision Feedback Equalizer(DFE) -----------
        .DFECLKDLYADJ                   (tied_to_ground_vec_i[5:0]),
        .DFECLKDLYADJMON                (),
        .DFEDLYOVRD                     (tied_to_ground_i),
        .DFEEYEDACMON                   (),
        .DFESENSCAL                     (),
        .DFETAP1                        (tied_to_ground_vec_i[4:0]),
        .DFETAP1MONITOR                 (),
        .DFETAP2                        (tied_to_ground_vec_i[4:0]),
        .DFETAP2MONITOR                 (),
        .DFETAP3                        (tied_to_ground_vec_i[3:0]),
        .DFETAP3MONITOR                 (),
        .DFETAP4                        (tied_to_ground_vec_i[3:0]),
        .DFETAP4MONITOR                 (),
        .DFETAPOVRD                     (tied_to_ground_i),
        //----- Receive Ports - RX Driver,OOB signalling,Coupling and Eq.,CDR ------
        .GATERXELECIDLE                 (rxelecidle0_i),
        .IGNORESIGDET                   (tied_to_ground_i),
        .RXCDRRESET                     (tied_to_ground_i),
        .RXELECIDLE                     (),
        .RXEQMIX                        ({tied_to_ground_vec_i[6:0],RXEQMIX_IN}),
        .RXN                            (RXN0_IN),
        .RXP                            (RXP0_IN),
        //------ Receive Ports - RX Elastic Buffer and Phase Alignment Ports -------
        .RXBUFRESET                     (tied_to_ground_i),
        .RXBUFSTATUS                    (),
        .RXCHANISALIGNED                (),
        .RXCHANREALIGN                  (),
        .RXDLYALIGNDISABLE              (tied_to_vcc_i),
        .RXDLYALIGNMONITOR              (),
        .RXDLYALIGNOVERRIDE             (tied_to_ground_i),
        .RXDLYALIGNRESET                (tied_to_ground_i),
        .RXDLYALIGNSWPPRECURB           (tied_to_vcc_i),
        .RXDLYALIGNUPDSW                (tied_to_ground_i),
        .RXENPMAPHASEALIGN              (tied_to_ground_i),
        .RXPMASETPHASE                  (tied_to_ground_i),
        .RXSTATUS                       (),
        //------------- Receive Ports - RX Loss-of-sync State Machine --------------
        .RXLOSSOFSYNC                   (),
        //-------------------- Receive Ports - RX Oversampling ---------------------
        .RXENSAMPLEALIGN                (tied_to_ground_i),
        .RXOVERSAMPLEERR                (),
        //---------------------- Receive Ports - RX PLL Ports ----------------------
        .GREFCLKRX                      (GREFCLKRX_IN),
        .GTXRXRESET                     (RXRESET0_IN),
        .MGTREFCLKRX                    (MGTREFCLKRX_IN),
        .NORTHREFCLKRX                  (NORTHREFCLKRX_IN),
        .PERFCLKRX                      (PERFCLKRX_IN),
        .PLLRXRESET                     (PLLRXRESET_IN),
        .RXPLLLKDET                     (RXPLLLKDET_OUT),
        .RXPLLLKDETEN                   (tied_to_vcc_i),
        .RXPLLPOWERDOWN                 (tied_to_ground_i),
        .RXPLLREFSELDY                  (tied_to_ground_vec_i[2:0]),
        .RXRATE                         (tied_to_ground_vec_i[1:0]),
        .RXRATEDONE                     (),
        .RXRESETDONE                    (RXRESETDONE_OUT),
        .SOUTHREFCLKRX                  (SOUTHREFCLKRX_IN),
        //------------ Receive Ports - RX Pipe Control for PCI Express -------------
        .PHYSTATUS                      (),
        .RXVALID                        (),
        //--------------- Receive Ports - RX Polarity Control Ports ----------------
        .RXPOLARITY                     (tied_to_ground_i),
        //------------------- Receive Ports - RX Ports for SATA --------------------
        .COMINITDET                     (),
        .COMSASDET                      (),
        .COMWAKEDET                     (),
        //----------- Shared Ports - Dynamic Reconfiguration Port (DRP) ------------
        .DADDR                          (tied_to_ground_vec_i[7:0]),
        .DCLK                           (tied_to_ground_i),
        .DEN                            (tied_to_ground_i),
        .DI                             (tied_to_ground_vec_i[15:0]),
        .DRDY                           (),
        .DRPDO                          (),
        .DWE                            (tied_to_ground_i),
        //------------ Transmit Ports - 64b66b and 64b67b Gearbox Ports ------------
        .TXGEARBOXREADY                 (),
        .TXHEADER                       (tied_to_ground_vec_i[2:0]),
        .TXSEQUENCE                     (tied_to_ground_vec_i[6:0]),
        .TXSTARTSEQ                     (tied_to_ground_i),
        //-------------- Transmit Ports - 8b10b Encoder Control Ports --------------
        .TXBYPASS8B10B                  (tied_to_ground_vec_i[3:0]),
        .TXCHARDISPMODE                 (tied_to_ground_vec_i[3:0]),
        .TXCHARDISPVAL                  (tied_to_ground_vec_i[3:0]),
        .TXCHARISK                      (tied_to_ground_vec_i[3:0]),
        .TXENC8B10BUSE                  (tied_to_ground_i),
        .TXKERR                         (),
        .TXRUNDISP                      (),
        //----------------------- Transmit Ports - GTX Ports -----------------------
        .GTXTEST                        (13'b1000000000000),
        .MGTREFCLKFAB                   (),
        .TSTCLK0                        (tied_to_ground_i),
        .TSTCLK1                        (tied_to_ground_i),
        .TSTIN                          (tied_to_ground_vec_i[19:0]),
        .TSTOUT                         (),
        //---------------- Transmit Ports - TX Data Path interface -----------------
        .TXDATA                         (txdata0_i),
        .TXOUTCLK                       (TXOUTCLK0_OUT),
        .TXOUTCLKPCS                    (),
        .TXRESET                        (tied_to_ground_i),
        .TXUSRCLK                       (TXUSRCLK0_IN),
        .TXUSRCLK2                      (TXUSRCLK20_IN),
        //-------------- Transmit Ports - TX Driver and OOB signaling --------------
        .TXBUFDIFFCTRL                  (3'b000),
        .TXDIFFCTRL                     (TXDIFFCTRL0_IN),
        .TXINHIBIT                      (tied_to_ground_i),
        .TXN                            (TXN0_OUT),
        .TXP                            (TXP0_OUT),
        .TXPOSTEMPHASIS                 (TXPOSTEMPHASIS0_IN),
        //------------- Transmit Ports - TX Driver and OOB signalling --------------
        .TXPREEMPHASIS                  (TXPREEMPHASIS0_IN),
        //--------- Transmit Ports - TX Elastic Buffer and Phase Alignment ---------
        .TXBUFSTATUS                    (),
        //------ Transmit Ports - TX Elastic Buffer and Phase Alignment Ports ------
        .TXDLYALIGNDISABLE              (tied_to_vcc_i),
        .TXDLYALIGNMONITOR              (),
        .TXDLYALIGNOVERRIDE             (tied_to_ground_i),
        .TXDLYALIGNRESET                (tied_to_ground_i),
        .TXDLYALIGNUPDSW                (tied_to_ground_i),
        .TXENPMAPHASEALIGN              (tied_to_ground_i),
        .TXPMASETPHASE                  (tied_to_ground_i),
        //--------------------- Transmit Ports - TX PLL Ports ----------------------
        .GREFCLKTX                      (GREFCLKTX_IN),
        .GTXTXRESET                     (GTPRESET_IN),
        .MGTREFCLKTX                    (MGTREFCLKTX_IN),
        .NORTHREFCLKTX                  (NORTHREFCLKTX_IN),
        .PERFCLKTX                      (PERFCLKTX_IN),
        .PLLTXRESET                     (PLLTXRESET_IN),
        .SOUTHREFCLKTX                  (SOUTHREFCLKTX_IN),
        .TXPLLLKDET                     (TXPLLLKDET_OUT),
        .TXPLLLKDETEN                   (tied_to_vcc_i),
        .TXPLLPOWERDOWN                 (tied_to_ground_i),
        .TXPLLREFSELDY                  (tied_to_ground_vec_i[2:0]),
        .TXRATE                         (tied_to_ground_vec_i[1:0]),
        .TXRATEDONE                     (),
        .TXRESETDONE                    (TXRESETDONE_OUT),
        //------------------- Transmit Ports - TX PRBS Generator -------------------
        .TXENPRBSTST                    (tied_to_ground_vec_i[2:0]),
        .TXPRBSFORCEERR                 (tied_to_ground_i),
        //------------------ Transmit Ports - TX Polarity Control ------------------
        .TXPOLARITY                     (tied_to_ground_i),
        //--------------- Transmit Ports - TX Ports for PCI Express ----------------
        .TXDEEMPH                       (tied_to_ground_i),
        .TXDETECTRX                     (tied_to_ground_i),
        .TXELECIDLE                     (tied_to_ground_i),
        .TXMARGIN                       (tied_to_ground_vec_i[2:0]),
        .TXPDOWNASYNCH                  (tied_to_ground_i),
        .TXSWING                        (tied_to_ground_i),
        //------------------- Transmit Ports - TX Ports for SATA -------------------
        .COMFINISH                      (),
        .TXCOMINIT                      (tied_to_ground_i),
        .TXCOMSAS                       (tied_to_ground_i),
        .TXCOMWAKE                      (tied_to_ground_i)

     );


   //------------------------- GTX Instantiations  --------------------------
        GTXE1 #
        (
            //_______________________ Simulation-Only Attributes __________________
    
            .SIM_RECEIVER_DETECT_PASS   ("TRUE"),
            
            .SIM_TX_ELEC_IDLE_LEVEL     ("X"),
    
            .SIM_GTXRESET_SPEEDUP       (GTX_SIM_GTXRESET_SPEEDUP),
            .SIM_VERSION                ("1.0"),
            .SIM_TXREFCLK_SOURCE        (GTX_SIM_TXREFCLK_SOURCE),
            .SIM_RXREFCLK_SOURCE        (GTX_SIM_RXREFCLK_SOURCE),
            

           //--------------------------TX PLL----------------------------
            .TX_CLK_SOURCE                          (GTX_TX_CLK_SOURCE),
            .TX_OVERSAMPLE_MODE                     ("FALSE"),
            .TXPLL_COM_CFG                          (24'h21680a),
            .TXPLL_CP_CFG                           (8'h00),
            .TXPLL_DIVSEL_FB                        (5),
            .TXPLL_DIVSEL_OUT                       (1),
            .TXPLL_DIVSEL_REF                       (2),
            .TXPLL_DIVSEL45_FB                      (4),
            .TXPLL_LKDET_CFG                        (3'b111),
            .TX_CLK25_DIVIDER                       (7),
            .TXPLL_SATA                             (2'b00),
            .TX_TDCC_CFG                            (2'b00),
            .PMA_CAS_CLK_EN                         ("FALSE"),
            .POWER_SAVE                             (GTX_POWER_SAVE),

           //-----------------------TX Interface-------------------------
            .GEN_TXUSRCLK                           ("TRUE"),
            .TX_DATA_WIDTH                          (16),
            .TX_USRCLK_CFG                          (6'h00),
            .TXOUTCLK_CTRL                          ("TXOUTCLKPMA_DIV2"),
            .TXOUTCLK_DLY                           (10'b0000000000),

           //------------TX Buffering and Phase Alignment----------------
            .TX_PMADATA_OPT                         (1'b0),
            .PMA_TX_CFG                             (20'h00082),
            .TX_BUFFER_USE                          ("TRUE"),
            .TX_BYTECLK_CFG                         (6'h00),
            .TX_EN_RATE_RESET_BUF                   ("TRUE"),
            .TX_XCLK_SEL                            ("TXOUT"),
            .TX_DLYALIGN_CTRINC                     (4'b0100),
            .TX_DLYALIGN_LPFINC                     (4'b0111),
            .TX_DLYALIGN_MONSEL                     (3'b000),
            .TX_DLYALIGN_OVRDSETTING                (8'b00000000),

           //-----------------------TX Gearbox---------------------------
            .GEARBOX_ENDEC                          (3'b000),
            .TXGEARBOX_USE                          ("FALSE"),

           //--------------TX Driver and OOB Signalling------------------
            .TX_DRIVE_MODE                          ("DIRECT"),
            .TX_IDLE_ASSERT_DELAY                   (3'b100),
            .TX_IDLE_DEASSERT_DELAY                 (3'b010),
            .TXDRIVE_LOOPBACK_HIZ                   ("FALSE"),
            .TXDRIVE_LOOPBACK_PD                    ("FALSE"),

           //------------TX Pipe Control for PCI Express/SATA------------
            .COM_BURST_VAL                          (4'b1111),

           //----------------TX Attributes for PCI Express---------------
            .TX_DEEMPH_0                            (5'b11010),
            .TX_DEEMPH_1                            (5'b10000),
            .TX_MARGIN_FULL_0                       (7'b1001110),
            .TX_MARGIN_FULL_1                       (7'b1001001),
            .TX_MARGIN_FULL_2                       (7'b1000101),
            .TX_MARGIN_FULL_3                       (7'b1000010),
            .TX_MARGIN_FULL_4                       (7'b1000000),
            .TX_MARGIN_LOW_0                        (7'b1000110),
            .TX_MARGIN_LOW_1                        (7'b1000100),
            .TX_MARGIN_LOW_2                        (7'b1000010),
            .TX_MARGIN_LOW_3                        (7'b1000000),
            .TX_MARGIN_LOW_4                        (7'b1000000),

           //--------------------------RX PLL----------------------------
            .RX_OVERSAMPLE_MODE                     ("FALSE"),
            .RXPLL_COM_CFG                          (24'h21680a),
            .RXPLL_CP_CFG                           (8'h00),
            .RXPLL_DIVSEL_FB                        (5),
            .RXPLL_DIVSEL_OUT                       (1),
            .RXPLL_DIVSEL_REF                       (2),
            .RXPLL_DIVSEL45_FB                      (4),
            .RXPLL_LKDET_CFG                        (3'b111),
            .RX_CLK25_DIVIDER                       (7),

           //-----------------------RX Interface-------------------------
            .GEN_RXUSRCLK                           ("TRUE"),
            .RX_DATA_WIDTH                          (16),
            .RXRECCLK_CTRL                          ("RXRECCLKPMA_DIV2"),
            .RXRECCLK_DLY                           (10'b0000000000),
            .RXUSRCLK_DLY                           (16'h0000),

           //--------RX Driver,OOB signalling,Coupling and Eq.,CDR-------
            .AC_CAP_DIS                             ("FALSE"),
            .CDR_PH_ADJ_TIME                        (5'b10100),
            .OOBDETECT_THRESHOLD                    (3'b000),
            .PMA_CDR_SCAN                           (27'h6404040),
            .PMA_RX_CFG                             (25'h05ce049),
            .RCV_TERM_GND                           ("FALSE"),
            .RCV_TERM_VTTRX                         ("TRUE"),
            .RX_EN_IDLE_HOLD_CDR                    ("FALSE"),
            .RX_EN_IDLE_RESET_FR                    ("TRUE"),
            .RX_EN_IDLE_RESET_PH                    ("TRUE"),
            .TX_DETECT_RX_CFG                       (14'h1832),
            .TERMINATION_CTRL                       (5'b10100),
            .TERMINATION_OVRD                       ("FALSE"),
            .CM_TRIM                                (2'b00),
            .PMA_RXSYNC_CFG                         (7'h00),
            .PMA_CFG                                (76'h0000000000000000000),
            .BGTEST_CFG                             (2'b00),
            .BIAS_CFG                               (17'h00000),

           //------------RX Decision Feedback Equalizer(DFE)-------------
            .DFE_CAL_TIME                           (5'b01100),
            .DFE_CFG                                (8'b01111011),
            .RX_EN_IDLE_HOLD_DFE                    ("TRUE"),
            .RX_EYE_OFFSET                          (8'h40),
            .RX_EYE_SCANMODE                        (2'h0),

           //-----------------------PRBS Detection-----------------------

           //----------------Comma Detection and Alignment---------------
            .ALIGN_COMMA_WORD                       (1),
            .COMMA_10B_ENABLE                       (10'b1111111111),
            .COMMA_DOUBLE                           ("FALSE"),
            .DEC_MCOMMA_DETECT                      ("FALSE"),
            .DEC_PCOMMA_DETECT                      ("FALSE"),
            .DEC_VALID_COMMA_ONLY                   ("FALSE"),
            .MCOMMA_10B_VALUE                       (10'b1010000011),
            .MCOMMA_DETECT                          ("TRUE"),
            .PCOMMA_10B_VALUE                       (10'b0101111100),
            .PCOMMA_DETECT                          ("TRUE"),
            .RX_DECODE_SEQ_MATCH                    ("FALSE"),
            .RX_SLIDE_AUTO_WAIT                     (5),
            .RX_SLIDE_MODE                          ("OFF"),
            .SHOW_REALIGN_COMMA                     ("TRUE"),

           //---------------RX Loss-of-sync State Machine----------------
            .RX_LOS_INVALID_INCR                    (8),
            .RX_LOS_THRESHOLD                       (128),
            .RX_LOSS_OF_SYNC_FSM                    ("FALSE"),

           //-----------------------RX Gearbox---------------------------
            .RXGEARBOX_USE                          ("FALSE"),

           //-----------RX Elastic Buffer and Phase alignment------------
            .RX_BUFFER_USE                          ("TRUE"),
            .RX_EN_IDLE_RESET_BUF                   ("TRUE"),
            .RX_EN_MODE_RESET_BUF                   ("TRUE"),
            .RX_EN_RATE_RESET_BUF                   ("TRUE"),
            .RX_EN_REALIGN_RESET_BUF                ("FALSE"),
            .RX_EN_REALIGN_RESET_BUF2               ("FALSE"),
            .RX_FIFO_ADDR_MODE                      ("FULL"),
            .RX_IDLE_HI_CNT                         (4'b1000),
            .RX_IDLE_LO_CNT                         (4'b0000),
            .RX_XCLK_SEL                            ("RXREC"),
            .RX_DLYALIGN_CTRINC                     (4'b0100),
            .RX_DLYALIGN_EDGESET                    (5'b00110),
            .RX_DLYALIGN_LPFINC                     (4'b0111),
            .RX_DLYALIGN_MONSEL                     (3'b000),
            .RX_DLYALIGN_OVRDSETTING                (8'b00000000),

           //----------------------Clock Correction----------------------
            .CLK_COR_ADJ_LEN                        (1),
            .CLK_COR_DET_LEN                        (1),
            .CLK_COR_INSERT_IDLE_FLAG               ("FALSE"),
            .CLK_COR_KEEP_IDLE                      ("FALSE"),
            .CLK_COR_MAX_LAT                        (16),
            .CLK_COR_MIN_LAT                        (14),
            .CLK_COR_PRECEDENCE                     ("TRUE"),
            .CLK_COR_REPEAT_WAIT                    (0),
            .CLK_COR_SEQ_1_1                        (10'b0000000000),
            .CLK_COR_SEQ_1_2                        (10'b0000000000),
            .CLK_COR_SEQ_1_3                        (10'b0000000000),
            .CLK_COR_SEQ_1_4                        (10'b0000000000),
            .CLK_COR_SEQ_1_ENABLE                   (4'b1111),
            .CLK_COR_SEQ_2_1                        (10'b0000000000),
            .CLK_COR_SEQ_2_2                        (10'b0000000000),
            .CLK_COR_SEQ_2_3                        (10'b0000000000),
            .CLK_COR_SEQ_2_4                        (10'b0000000000),
            .CLK_COR_SEQ_2_ENABLE                   (4'b1111),
            .CLK_COR_SEQ_2_USE                      ("FALSE"),
            .CLK_CORRECT_USE                        ("FALSE"),

           //----------------------Channel Bonding----------------------
            .CHAN_BOND_1_MAX_SKEW                   (1),
            .CHAN_BOND_2_MAX_SKEW                   (1),
            .CHAN_BOND_KEEP_ALIGN                   ("FALSE"),
            .CHAN_BOND_SEQ_1_1                      (10'b0000000000),
            .CHAN_BOND_SEQ_1_2                      (10'b0000000000),
            .CHAN_BOND_SEQ_1_3                      (10'b0000000000),
            .CHAN_BOND_SEQ_1_4                      (10'b0000000000),
            .CHAN_BOND_SEQ_1_ENABLE                 (4'b1111),
            .CHAN_BOND_SEQ_2_1                      (10'b0000000000),
            .CHAN_BOND_SEQ_2_2                      (10'b0000000000),
            .CHAN_BOND_SEQ_2_3                      (10'b0000000000),
            .CHAN_BOND_SEQ_2_4                      (10'b0000000000),
            .CHAN_BOND_SEQ_2_CFG                    (5'b00000),
            .CHAN_BOND_SEQ_2_ENABLE                 (4'b1111),
            .CHAN_BOND_SEQ_2_USE                    ("FALSE"),
            .CHAN_BOND_SEQ_LEN                      (1),
            .PCI_EXPRESS_MODE                       ("FALSE"),

           //-----------RX Attributes for PCI Express/SATA/SAS----------
            .SAS_MAX_COMSAS                         (52),
            .SAS_MIN_COMSAS                         (40),
            .SATA_BURST_VAL                         (3'b100),
            .SATA_IDLE_VAL                          (3'b100),
            .SATA_MAX_BURST                         (7),
            .SATA_MAX_INIT                          (22),
            .SATA_MAX_WAKE                          (7),
            .SATA_MIN_BURST                         (4),
            .SATA_MIN_INIT                          (12),
            .SATA_MIN_WAKE                          (4),
            .TRANS_TIME_FROM_P2                     (12'h03c),
            .TRANS_TIME_NON_P2                      (8'h19),
            .TRANS_TIME_RATE                        (8'hff),
            .TRANS_TIME_TO_P2                       (10'h064)

            
        ) 
        gtxe1_i 
        (
        
        //---------------------- Loopback and Powerdown Ports ----------------------
        .LOOPBACK                       (LOOPBACK1_IN),
        .RXPOWERDOWN                    (tied_to_ground_vec_i[1:0]),
        .TXPOWERDOWN                    (tied_to_ground_vec_i[1:0]),
        //------------ Receive Ports - 64b66b and 64b67b Gearbox Ports -------------
        .RXDATAVALID                    (),
        .RXGEARBOXSLIP                  (tied_to_ground_i),
        .RXHEADER                       (),
        .RXHEADERVALID                  (),
        .RXSTARTOFSEQ                   (),
        //--------------------- Receive Ports - 8b10b Decoder ----------------------
        .RXCHARISCOMMA                  (),
        .RXCHARISK                      (),
        .RXDEC8B10BUSE                  (tied_to_ground_i),
        .RXDISPERR                      (RXDISPERR1_OUT),
        .RXNOTINTABLE                   (RXNOTINTABLE1_OUT),
        .RXRUNDISP                      (),
        .USRCODEERR                     (tied_to_ground_i),
        //----------------- Receive Ports - Channel Bonding Ports ------------------
        .RXCHANBONDSEQ                  (),
        .RXCHBONDI                      (tied_to_ground_vec_i[3:0]),
        .RXCHBONDLEVEL                  (tied_to_ground_vec_i[2:0]),
        .RXCHBONDMASTER                 (tied_to_ground_i),
        .RXCHBONDO                      (),
        .RXCHBONDSLAVE                  (tied_to_ground_i),
        .RXENCHANSYNC                   (tied_to_ground_i),
        //----------------- Receive Ports - Clock Correction Ports -----------------
        .RXCLKCORCNT                    (),
        //------------- Receive Ports - Comma Detection and Alignment --------------
        .RXBYTEISALIGNED                (),
        .RXBYTEREALIGN                  (),
        .RXCOMMADET                     (RXCOMMADET_OUT),
        .RXCOMMADETUSE                  (tied_to_vcc_i),
        .RXENMCOMMAALIGN                (RXENMCOMMAALIGN1_IN),
        .RXENPCOMMAALIGN                (RXENPCOMMAALIGN1_IN),
        .RXSLIDE                        (tied_to_ground_i),
        //--------------------- Receive Ports - PRBS Detection ---------------------
        .PRBSCNTRESET                   (tied_to_ground_i),
        .RXENPRBSTST                    (tied_to_ground_vec_i[2:0]),
        .RXPRBSERR                      (),
        //----------------- Receive Ports - RX Data Path interface -----------------
        .RXDATA                         (rxdata1_i),
        .RXRECCLK                       (),
        .RXRECCLKPCS                    (),
        .RXRESET                        (RXRESET1_IN),
        .RXUSRCLK                       (RXUSRCLK1_IN),
        .RXUSRCLK2                      (RXUSRCLK21_IN),
        //---------- Receive Ports - RX Decision Feedback Equalizer(DFE) -----------
        .DFECLKDLYADJ                   (tied_to_ground_vec_i[5:0]),
        .DFECLKDLYADJMON                (),
        .DFEDLYOVRD                     (tied_to_ground_i),
        .DFEEYEDACMON                   (),
        .DFESENSCAL                     (),
        .DFETAP1                        (tied_to_ground_vec_i[4:0]),
        .DFETAP1MONITOR                 (),
        .DFETAP2                        (tied_to_ground_vec_i[4:0]),
        .DFETAP2MONITOR                 (),
        .DFETAP3                        (tied_to_ground_vec_i[3:0]),
        .DFETAP3MONITOR                 (),
        .DFETAP4                        (tied_to_ground_vec_i[3:0]),
        .DFETAP4MONITOR                 (),
        .DFETAPOVRD                     (tied_to_ground_i),
        //----- Receive Ports - RX Driver,OOB signalling,Coupling and Eq.,CDR ------
        .GATERXELECIDLE                 (rxelecidle1_i),
        .IGNORESIGDET                   (tied_to_ground_i),
        .RXCDRRESET                     (tied_to_ground_i),
        .RXELECIDLE                     (),
        .RXEQMIX                        ({tied_to_ground_vec_i[6:0],RXEQMIX_IN}),
        .RXN                            (RXN1_IN),
        .RXP                            (RXP1_IN),
        //------ Receive Ports - RX Elastic Buffer and Phase Alignment Ports -------
        .RXBUFRESET                     (tied_to_ground_i),
        .RXBUFSTATUS                    (),
        .RXCHANISALIGNED                (),
        .RXCHANREALIGN                  (),
        .RXDLYALIGNDISABLE              (tied_to_vcc_i),
        .RXDLYALIGNMONITOR              (),
        .RXDLYALIGNOVERRIDE             (tied_to_ground_i),
        .RXDLYALIGNRESET                (tied_to_ground_i),
        .RXDLYALIGNSWPPRECURB           (tied_to_vcc_i),
        .RXDLYALIGNUPDSW                (tied_to_ground_i),
        .RXENPMAPHASEALIGN              (tied_to_ground_i),
        .RXPMASETPHASE                  (tied_to_ground_i),
        .RXSTATUS                       (),
        //------------- Receive Ports - RX Loss-of-sync State Machine --------------
        .RXLOSSOFSYNC                   (),
        //-------------------- Receive Ports - RX Oversampling ---------------------
        .RXENSAMPLEALIGN                (tied_to_ground_i),
        .RXOVERSAMPLEERR                (),
        //---------------------- Receive Ports - RX PLL Ports ----------------------
        .GREFCLKRX                      (GREFCLKRX_IN),
        .GTXRXRESET                     (RXRESET1_IN),
        .MGTREFCLKRX                    (MGTREFCLKRX_IN),
        .NORTHREFCLKRX                  (NORTHREFCLKRX_IN),
        .PERFCLKRX                      (PERFCLKRX_IN),
        .PLLRXRESET                     (PLLRXRESET_IN),
        .RXPLLLKDET                     (RXPLLLKDET_OUT),
        .RXPLLLKDETEN                   (tied_to_vcc_i),
        .RXPLLPOWERDOWN                 (tied_to_ground_i),
        .RXPLLREFSELDY                  (tied_to_ground_vec_i[2:0]),
        .RXRATE                         (tied_to_ground_vec_i[1:0]),
        .RXRATEDONE                     (),
        .RXRESETDONE                    (RXRESETDONE_OUT),
        .SOUTHREFCLKRX                  (SOUTHREFCLKRX_IN),
        //------------ Receive Ports - RX Pipe Control for PCI Express -------------
        .PHYSTATUS                      (),
        .RXVALID                        (),
        //--------------- Receive Ports - RX Polarity Control Ports ----------------
        .RXPOLARITY                     (tied_to_ground_i),
        //------------------- Receive Ports - RX Ports for SATA --------------------
        .COMINITDET                     (),
        .COMSASDET                      (),
        .COMWAKEDET                     (),
        //----------- Shared Ports - Dynamic Reconfiguration Port (DRP) ------------
        .DADDR                          (tied_to_ground_vec_i[7:0]),
        .DCLK                           (tied_to_ground_i),
        .DEN                            (tied_to_ground_i),
        .DI                             (tied_to_ground_vec_i[15:0]),
        .DRDY                           (),
        .DRPDO                          (),
        .DWE                            (tied_to_ground_i),
        //------------ Transmit Ports - 64b66b and 64b67b Gearbox Ports ------------
        .TXGEARBOXREADY                 (),
        .TXHEADER                       (tied_to_ground_vec_i[2:0]),
        .TXSEQUENCE                     (tied_to_ground_vec_i[6:0]),
        .TXSTARTSEQ                     (tied_to_ground_i),
        //-------------- Transmit Ports - 8b10b Encoder Control Ports --------------
        .TXBYPASS8B10B                  (tied_to_ground_vec_i[3:0]),
        .TXCHARDISPMODE                 (tied_to_ground_vec_i[3:0]),
        .TXCHARDISPVAL                  (tied_to_ground_vec_i[3:0]),
        .TXCHARISK                      (tied_to_ground_vec_i[3:0]),
        .TXENC8B10BUSE                  (tied_to_ground_i),
        .TXKERR                         (),
        .TXRUNDISP                      (),
        //----------------------- Transmit Ports - GTX Ports -----------------------
        .GTXTEST                        (13'b1000000000000),
        .MGTREFCLKFAB                   (),
        .TSTCLK0                        (tied_to_ground_i),
        .TSTCLK1                        (tied_to_ground_i),
        .TSTIN                          (tied_to_ground_vec_i[19:0]),
        .TSTOUT                         (),
        //---------------- Transmit Ports - TX Data Path interface -----------------
        .TXDATA                         (txdata1_i),
        .TXOUTCLK                       (TXOUTCLK1_OUT),
        .TXOUTCLKPCS                    (),
        .TXRESET                        (tied_to_ground_i),
        .TXUSRCLK                       (TXUSRCLK1_IN),
        .TXUSRCLK2                      (TXUSRCLK21_IN),
        //-------------- Transmit Ports - TX Driver and OOB signaling --------------
        .TXBUFDIFFCTRL                  (3'b000),
        .TXDIFFCTRL                     (TXDIFFCTRL1_IN),
        .TXINHIBIT                      (tied_to_ground_i),
        .TXN                            (TXN1_OUT),
        .TXP                            (TXP1_OUT),
        .TXPOSTEMPHASIS                 (TXPOSTEMPHASIS1_IN),
        //------------- Transmit Ports - TX Driver and OOB signalling --------------
        .TXPREEMPHASIS                  (TXPREEMPHASIS1_IN),
        //--------- Transmit Ports - TX Elastic Buffer and Phase Alignment ---------
        .TXBUFSTATUS                    (),
        //------ Transmit Ports - TX Elastic Buffer and Phase Alignment Ports ------
        .TXDLYALIGNDISABLE              (tied_to_vcc_i),
        .TXDLYALIGNMONITOR              (),
        .TXDLYALIGNOVERRIDE             (tied_to_ground_i),
        .TXDLYALIGNRESET                (tied_to_ground_i),
        .TXDLYALIGNUPDSW                (tied_to_ground_i),
        .TXENPMAPHASEALIGN              (tied_to_ground_i),
        .TXPMASETPHASE                  (tied_to_ground_i),
        //--------------------- Transmit Ports - TX PLL Ports ----------------------
        .GREFCLKTX                      (GREFCLKTX_IN),
        .GTXTXRESET                     (GTXTXRESET_IN),
        .MGTREFCLKTX                    (MGTREFCLKTX_IN),
        .NORTHREFCLKTX                  (NORTHREFCLKTX_IN),
        .PERFCLKTX                      (PERFCLKTX_IN),
        .PLLTXRESET                     (PLLTXRESET_IN),
        .SOUTHREFCLKTX                  (SOUTHREFCLKTX_IN),
        .TXPLLLKDET                     (TXPLLLKDET_OUT),
        .TXPLLLKDETEN                   (tied_to_vcc_i),
        .TXPLLPOWERDOWN                 (tied_to_ground_i),
        .TXPLLREFSELDY                  (tied_to_ground_vec_i[2:0]),
        .TXRATE                         (tied_to_ground_vec_i[1:0]),
        .TXRATEDONE                     (),
        .TXRESETDONE                    (TXRESETDONE_OUT),
        //------------------- Transmit Ports - TX PRBS Generator -------------------
        .TXENPRBSTST                    (tied_to_ground_vec_i[2:0]),
        .TXPRBSFORCEERR                 (tied_to_ground_i),
        //------------------ Transmit Ports - TX Polarity Control ------------------
        .TXPOLARITY                     (tied_to_ground_i),
        //--------------- Transmit Ports - TX Ports for PCI Express ----------------
        .TXDEEMPH                       (tied_to_ground_i),
        .TXDETECTRX                     (tied_to_ground_i),
        .TXELECIDLE                     (tied_to_ground_i),
        .TXMARGIN                       (tied_to_ground_vec_i[2:0]),
        .TXPDOWNASYNCH                  (tied_to_ground_i),
        .TXSWING                        (tied_to_ground_i),
        //------------------- Transmit Ports - TX Ports for SATA -------------------
        .COMFINISH                      (),
        .TXCOMINIT                      (tied_to_ground_i),
        .TXCOMSAS                       (tied_to_ground_i),
        .TXCOMWAKE                      (tied_to_ground_i)

     );

/*

    //------------------------- GT11 Instantiations  --------------------------   

    GTX_DUAL # 
    (
        //_______________________ Simulation-Only Attributes __________________

        .SIM_GTXRESET_SPEEDUP        (TILE_SIM_GTPRESET_SPEEDUP),
 //good
        .SIM_PLL_PERDIV2             (TILE_SIM_PLL_PERDIV2),
	  //good

        //___________________________ Shared Attributes _______________________

        //---------------------- Tile and PLL Attributes ----------------------

        .CLK25_DIVIDER               (10),          //good
        .CLKINDC_B                   ("TRUE"),   
	//good
        .OOB_CLK_DIVIDER             (6),
			//good
        .OVERSAMPLE_MODE             ("FALSE"),
	 //good
        .PLL_DIVSEL_FB               (2),
			 //good
        .PLL_DIVSEL_REF              (1),
			 //good
        .PLL_TXDIVSEL_OUT_0       (1),				 //good
        .PLL_TXDIVSEL_OUT_1       (1), 				 //good
//        .TX_SYNC_FILTERB             (1),


        //______________________ Transmit Interface Attributes ________________

        //----------------- TX Buffering and Phase Alignment ------------------   

        .TX_BUFFER_USE_0            ("TRUE"),
		 //good
        .TX_XCLK_SEL_0              ("TXOUT"),
		  //good
        .TXRX_INVERT_0              (5'b00000),       //good 

        .TX_BUFFER_USE_1            ("TRUE"),
		   //good
        .TX_XCLK_SEL_1              ("TXOUT"),
			 //good
        .TXRX_INVERT_1              (5'b00000),        //good

  
        //------------------- TX Driver and OOB signalling --------------------  

         //.TX_DIFF_BOOST_0           ("TRUE"), - not there

         //.TX_DIFF_BOOST_1           ("TRUE"),  - not there

        //---------------- TX Pipe Control for PCI Express/SATA ---------------

        .COM_BURST_VAL_0            (4'b1111),
		 //good

        .COM_BURST_VAL_1            (4'b1111),
		  //good

        //_______________________ Receive Interface Attributes ________________

        //---------- RX Driver,OOB signalling,Coupling and Eq.,CDR ------------  

        .AC_CAP_DIS_0               ("TRUE"),
		 //good
        .OOBDETECT_THRESHOLD_0      (3'b001),
		   //good
        .PMA_CDR_SCAN_0             (27'h6c08040), 
	//good
        .PMA_RX_CFG_0               (25'h0dce088),
		//good
        .RCV_TERM_GND_0             ("FALSE"),
			//good
//missing        //.RCV_TERM_MID_0             ("FALSE"),
        .RCV_TERM_VTTRX_0           ("TRUE"),
			 //good
        .TERMINATION_IMP_0          (50),
				//good

														 //good
        .AC_CAP_DIS_1               ("TRUE"),
		    //good
        .OOBDETECT_THRESHOLD_1      (3'b001),
			 //good
        .PMA_CDR_SCAN_1             (27'h6c08040), 
	     //good
        .PMA_RX_CFG_1               (25'h0dce088),  
	//good
        .RCV_TERM_GND_1             ("FALSE"),
			  //good
        //.RCV_TERM_MID_1             ("FALSE"),
        .RCV_TERM_VTTRX_1           ("TRUE"),
			  //good
        .TERMINATION_IMP_1          (50),               //good

        .TERMINATION_CTRL           (5'b10100),
		 //good
        .TERMINATION_OVRD           ("FALSE"),
			//good

        //------------------- RX Serial Line Rate Settings --------------------   

        .PLL_RXDIVSEL_OUT_0         (1),
				  //good
        .PLL_SATA_0                 ("TRUE"),
			//good

        .PLL_RXDIVSEL_OUT_1         (1),                //good
        .PLL_SATA_1                 ("TRUE"),
		   //good


        //------------------------- PRBS Detection ----------------------------  

        .PRBS_ERR_THRESHOLD_0       (32'h00000001),
   //good

        .PRBS_ERR_THRESHOLD_1       (32'h00000001),
   //good

        //------------------- Comma Detection and Alignment -------------------  

        .ALIGN_COMMA_WORD_0         (1),
						//good
        .COMMA_10B_ENABLE_0         (10'b1111111111),
			 //good
        .COMMA_DOUBLE_0             ("FALSE"),
					  //good
        .DEC_MCOMMA_DETECT_0        ("FALSE"),
					   //good
        .DEC_PCOMMA_DETECT_0        ("FALSE"),
					 //good
        .DEC_VALID_COMMA_ONLY_0     ("FALSE"),
					  //good
        .MCOMMA_10B_VALUE_0         (10'b1010000011),
			   //good
        .MCOMMA_DETECT_0            ("TRUE"),
					  //good
        .PCOMMA_10B_VALUE_0         (10'b0101111100),
			   //good
        .PCOMMA_DETECT_0            ("TRUE"),
					   //good
        .RX_SLIDE_MODE_0            ("PCS"),
						//good

        .ALIGN_COMMA_WORD_1         (1),
					  //good
        .COMMA_10B_ENABLE_1         (10'b1111111111),
		   //good
        .COMMA_DOUBLE_1             ("FALSE"),
					//good
        .DEC_MCOMMA_DETECT_1        ("FALSE"),
				   //good
        .DEC_PCOMMA_DETECT_1        ("FALSE"),
				 //good
        .DEC_VALID_COMMA_ONLY_1     ("FALSE"),
				   //good
        .MCOMMA_10B_VALUE_1         (10'b1010000011),
			//good
        .MCOMMA_DETECT_1            ("TRUE"),
				   //good
        .PCOMMA_10B_VALUE_1         (10'b0101111100),
			//good
        .PCOMMA_DETECT_1            ("TRUE"),
					//good
        .RX_SLIDE_MODE_1            ("PCS"),
					 //good


        //------------------- RX Loss-of-sync State Machine -------------------  

        .RX_LOSS_OF_SYNC_FSM_0      ("FALSE"),
				 //good
        .RX_LOS_INVALID_INCR_0      (8),
        .RX_LOS_THRESHOLD_0         (128),

        .RX_LOSS_OF_SYNC_FSM_1      ("FALSE"),
				//good
        .RX_LOS_INVALID_INCR_1      (8),
        .RX_LOS_THRESHOLD_1         (128),

        //------------ RX Elastic Buffer and Phase alignment ports ------------   

        .RX_BUFFER_USE_0            ("TRUE"),
				//good
        .RX_XCLK_SEL_0              ("RXREC"),
				 //good

        .RX_BUFFER_USE_1            ("TRUE"),              //good
        .RX_XCLK_SEL_1              ("RXREC"),             //good

        //--------------------- Clock Correction Attributes -------------------   

        .CLK_CORRECT_USE_0          ("FALSE"),
			   //good
        .CLK_COR_ADJ_LEN_0          (1),
					//good
        .CLK_COR_DET_LEN_0          (1),
					 //good
        .CLK_COR_INSERT_IDLE_FLAG_0 ("FALSE"),
				  //good
        .CLK_COR_KEEP_IDLE_0        ("FALSE"),
				   //good
        .CLK_COR_MAX_LAT_0          (18),                   //good
        .CLK_COR_MIN_LAT_0          (16),
					 //good
        .CLK_COR_PRECEDENCE_0       ("TRUE"),
				   //good
        .CLK_COR_REPEAT_WAIT_0      (0),
							//good
        .CLK_COR_SEQ_1_1_0          (10'b0000000000),
			 //good
        .CLK_COR_SEQ_1_2_0          (10'b0000000000),
			 //good
        .CLK_COR_SEQ_1_3_0          (10'b0000000000),
			 //good
        .CLK_COR_SEQ_1_4_0          (10'b0000000000),
			 //good
        .CLK_COR_SEQ_1_ENABLE_0     (4'b0000),
					   //good
        .CLK_COR_SEQ_2_1_0          (10'b0000000000),
			  //good
        .CLK_COR_SEQ_2_2_0          (10'b0000000000),
			   //good
        .CLK_COR_SEQ_2_3_0          (10'b0000000000),
			//good
        .CLK_COR_SEQ_2_4_0          (10'b0000000000),
			  //good
        .CLK_COR_SEQ_2_ENABLE_0     (4'b0000),
					  //good
        .CLK_COR_SEQ_2_USE_0        ("FALSE"),
				   //good
        .RX_DECODE_SEQ_MATCH_0      ("TRUE"),
					 //good

        .CLK_CORRECT_USE_1          ("FALSE"),
			   //good
        .CLK_COR_ADJ_LEN_1          (1),
					//good
        .CLK_COR_DET_LEN_1          (1),
					//good
        .CLK_COR_INSERT_IDLE_FLAG_1 ("FALSE"),
			   //good
        .CLK_COR_KEEP_IDLE_1        ("FALSE"),
				  //good
        .CLK_COR_MAX_LAT_1          (18),
					 //good
        .CLK_COR_MIN_LAT_1          (16),
					  //good
        .CLK_COR_PRECEDENCE_1       ("TRUE"),
				 //good
        .CLK_COR_REPEAT_WAIT_1      (0),
						//good
        .CLK_COR_SEQ_1_1_1          (10'b0000000000),
		  //good
        .CLK_COR_SEQ_1_2_1          (10'b0000000000),
		   //good
        .CLK_COR_SEQ_1_3_1          (10'b0000000000),
		   //good
        .CLK_COR_SEQ_1_4_1          (10'b0000000000),
		   //good
        .CLK_COR_SEQ_1_ENABLE_1     (4'b0000),
					 //good
        .CLK_COR_SEQ_2_1_1          (10'b0000000000),
			 //good
        .CLK_COR_SEQ_2_2_1          (10'b0000000000),
			//good
        .CLK_COR_SEQ_2_3_1          (10'b0000000000),
			 //good
        .CLK_COR_SEQ_2_4_1          (10'b0000000000),
			//good
        .CLK_COR_SEQ_2_ENABLE_1     (4'b0000),
				   //good
        .CLK_COR_SEQ_2_USE_1        ("FALSE"),
				   //good
        .RX_DECODE_SEQ_MATCH_1      ("TRUE"),
					//good

        //-------------------- Channel Bonding Attributes ---------------------   

        .CHAN_BOND_1_MAX_SKEW_0     (1),
						 //good
        .CHAN_BOND_2_MAX_SKEW_0     (1),
						 //good 
        .CHAN_BOND_LEVEL_0          (TILE_CHAN_BOND_LEVEL_0),
	  //good
        .CHAN_BOND_MODE_0           (TILE_CHAN_BOND_MODE_0),
	   //good
        .CHAN_BOND_SEQ_1_1_0        (10'b0000000000),
			  //good
        .CHAN_BOND_SEQ_1_2_0        (10'b0000000000),
			  //good
        .CHAN_BOND_SEQ_1_3_0        (10'b0000000000),
			  //good
        .CHAN_BOND_SEQ_1_4_0        (10'b0000000000),
			  //good
        .CHAN_BOND_SEQ_1_ENABLE_0   (4'b0000),
					   //good
        .CHAN_BOND_SEQ_2_1_0        (10'b0000000000),
			  //good
        .CHAN_BOND_SEQ_2_2_0        (10'b0000000000),
			  //good
        .CHAN_BOND_SEQ_2_3_0        (10'b0000000000),
			  //good
        .CHAN_BOND_SEQ_2_4_0        (10'b0000000000),
			  //good
        .CHAN_BOND_SEQ_2_ENABLE_0   (4'b0000),
						//good
        .CHAN_BOND_SEQ_2_USE_0      ("FALSE"),  
					//good
        .CHAN_BOND_SEQ_LEN_0        (1),
						   //good
        .PCI_EXPRESS_MODE_0         ("FALSE"),     
			   //good
     
        .CHAN_BOND_1_MAX_SKEW_1     (1),
							  //good
        .CHAN_BOND_2_MAX_SKEW_1     (1),
							//good
        .CHAN_BOND_LEVEL_1          (TILE_CHAN_BOND_LEVEL_1),
	   //good
        .CHAN_BOND_MODE_1           (TILE_CHAN_BOND_MODE_1),
		//good
        .CHAN_BOND_SEQ_1_1_1        (10'b0000000000),
			   //good
        .CHAN_BOND_SEQ_1_2_1        (10'b0000000000),
			   //good
        .CHAN_BOND_SEQ_1_3_1        (10'b0000000000),
			   //good
        .CHAN_BOND_SEQ_1_4_1        (10'b0000000000),
			   //good
        .CHAN_BOND_SEQ_1_ENABLE_1   (4'b0000),
					   //good
        .CHAN_BOND_SEQ_2_1_1        (10'b0000000000),
			   //good
        .CHAN_BOND_SEQ_2_2_1        (10'b0000000000),
			   //good
        .CHAN_BOND_SEQ_2_3_1        (10'b0000000000),
			   //good
        .CHAN_BOND_SEQ_2_4_1        (10'b0000000000),
			   //good
        .CHAN_BOND_SEQ_2_ENABLE_1   (4'b0000),
						//good
        .CHAN_BOND_SEQ_2_USE_1      ("FALSE"),  
					//good
        .CHAN_BOND_SEQ_LEN_1        (1),
						   //good
        .PCI_EXPRESS_MODE_1         ("FALSE"),
					//good

        //---------------- RX Attributes for PCI Express/SATA ---------------

        .RX_STATUS_FMT_0            ("PCIE"),
		//good
        .SATA_BURST_VAL_0           (3'b100),
	   //good
        .SATA_IDLE_VAL_0            (3'b100),
		//good
        .SATA_MAX_BURST_0           (7),
			 //good
        .SATA_MAX_INIT_0            (22),
			//good
        .SATA_MAX_WAKE_0            (7),
			 //good
        .SATA_MIN_BURST_0           (4),
		     //good 
        .SATA_MIN_INIT_0            (12),
			  //good
        .SATA_MIN_WAKE_0            (4),
			  //good
        .TRANS_TIME_FROM_P2_0       (12'h060),
			//good
        .TRANS_TIME_NON_P2_0        (8'h25),
			//good
        .TRANS_TIME_TO_P2_0         (10'h064),
		  //good

        .RX_STATUS_FMT_1            ("PCIE"),
		   //good
        .SATA_BURST_VAL_1           (3'b100),
		  //good
        .SATA_IDLE_VAL_1            (3'b100),
		   //good
        .SATA_MAX_BURST_1           (7),
			//good
        .SATA_MAX_INIT_1            (22),
			//good
        .SATA_MAX_WAKE_1            (7),
			 //good
        .SATA_MIN_BURST_1           (4),
		     //good
        .SATA_MIN_INIT_1            (12),
			//good
        .SATA_MIN_WAKE_1            (4),
			 //good
        .TRANS_TIME_FROM_P2_1       (12'h060),
		 //good
        .TRANS_TIME_NON_P2_1        (8'h25),
		   //good
        .TRANS_TIME_TO_P2_1         (10'h064)         //good
     ) 
     gtx_dual_i 
     (

        //---------------------- Loopback and Powerdown Ports ----------------------
        .LOOPBACK0                      (loopback0_i),
        .LOOPBACK1                      (loopback1_i),
        .RXPOWERDOWN0                   (tied_to_ground_vec_i[1:0]),
        .RXPOWERDOWN1                   (tied_to_ground_vec_i[1:0]),
        .TXPOWERDOWN0                   (tied_to_ground_vec_i[1:0]),
        .TXPOWERDOWN1                   (tied_to_ground_vec_i[1:0]),
        //--------------------- Receive Ports - 8b10b Decoder ----------------------
        .RXCHARISCOMMA0                 (),
        .RXCHARISCOMMA1                 (),
        .RXCHARISK0                     (),
        .RXCHARISK1                     (),
        .RXDEC8B10BUSE0                 (tied_to_vcc_i),
        .RXDEC8B10BUSE1                 (tied_to_vcc_i),
        .RXDISPERR0                     (RXDISPERR0_OUT),
        .RXDISPERR1                     (RXDISPERR1_OUT),
        .RXNOTINTABLE0                  (RXNOTINTABLE0_OUT),
        .RXNOTINTABLE1                  (RXNOTINTABLE1_OUT),
        .RXRUNDISP0                     (),
        .RXRUNDISP1                     (),
        //----------------- Receive Ports - Channel Bonding Ports ------------------
        .RXCHANBONDSEQ0                 (),
        .RXCHANBONDSEQ1                 (),
        .RXCHBONDI0                     (tied_to_ground_vec_i[2:0]),
        .RXCHBONDI1                     (tied_to_ground_vec_i[2:0]),
        .RXCHBONDO0                     (),
        .RXCHBONDO1                     (),
        .RXENCHANSYNC0                  (tied_to_ground_i),
        .RXENCHANSYNC1                  (tied_to_ground_i),
        //----------------- Receive Ports - Clock Correction Ports -----------------
        .RXCLKCORCNT0                   (),
        .RXCLKCORCNT1                   (),
        //------------- Receive Ports - Comma Detection and Alignment --------------
        .RXBYTEISALIGNED0               (),
        .RXBYTEISALIGNED1               (),
        .RXBYTEREALIGN0                 (),
        .RXBYTEREALIGN1                 (),
        .RXCOMMADET0                    (),
        .RXCOMMADET1                    (),
        .RXCOMMADETUSE0                 (tied_to_vcc_i),
        .RXCOMMADETUSE1                 (tied_to_vcc_i),
        .RXENMCOMMAALIGN0               (RXENMCOMMAALIGN0_IN),
        .RXENMCOMMAALIGN1               (RXENMCOMMAALIGN1_IN),
        .RXENPCOMMAALIGN0               (RXENPCOMMAALIGN0_IN),
        .RXENPCOMMAALIGN1               (RXENPCOMMAALIGN1_IN),
        .RXSLIDE0                       (tied_to_ground_i),
        .RXSLIDE1                       (tied_to_ground_i),
        //--------------------- Receive Ports - PRBS Detection ---------------------
        .PRBSCNTRESET0                  (tied_to_ground_i),
        .PRBSCNTRESET1                  (tied_to_ground_i),
        .RXENPRBSTST0                   (tied_to_ground_vec_i[1:0]),
        .RXENPRBSTST1                   (tied_to_ground_vec_i[1:0]),
        .RXPRBSERR0                     (),
        .RXPRBSERR1                     (),
        //----------------- Receive Ports - RX Data Path interface -----------------
        .RXDATA0                        (rxdata0_i),
        .RXDATA1                        (rxdata1_i),
        .RXDATAWIDTH0                   (tied_to_vcc_i),
        .RXDATAWIDTH1                   (tied_to_vcc_i),
        .RXRECCLK0                      (),
        .RXRECCLK1                      (),
        .RXRESET0                       (RXRESET0_IN),
        .RXRESET1                       (RXRESET1_IN),
        .RXUSRCLK0                      (RXUSRCLK0_IN),
        .RXUSRCLK1                      (RXUSRCLK1_IN),
        .RXUSRCLK20                     (RXUSRCLK20_IN),
        .RXUSRCLK21                     (RXUSRCLK21_IN),
        //----- Receive Ports - RX Driver,OOB signalling,Coupling and Eq.,CDR ------
        .RXCDRRESET0                    (tied_to_ground_i),
        .RXCDRRESET1                    (tied_to_ground_i),
        .RXELECIDLE0                    (rxelecidle0_i),
        .RXELECIDLE1                    (rxelecidle1_i),
//        .RXELECIDLERESET0               (rxelecidlereset0_i),  //no equiv found
//        .RXELECIDLERESET1               (rxelecidlereset1_i),  //no equiv found
        .RXENEQB0                       (tied_to_vcc_i),
        .RXENEQB1                       (tied_to_vcc_i),
        .RXEQMIX0                       (tied_to_ground_vec_i[1:0]),
        .RXEQMIX1                       (tied_to_ground_vec_i[1:0]),
        .RXEQPOLE0                      (tied_to_ground_vec_i[3:0]),
        .RXEQPOLE1                      (tied_to_ground_vec_i[3:0]),
        .RXN0                           (RXN0_IN),
        .RXN1                           (RXN1_IN),
        .RXP0                           (RXP0_IN),
        .RXP1                           (RXP1_IN),
        //------ Receive Ports - RX Elastic Buffer and Phase Alignment Ports -------
        .RXBUFRESET0                    (tied_to_ground_i),
        .RXBUFRESET1                    (tied_to_ground_i),
        .RXBUFSTATUS0                   (),
        .RXBUFSTATUS1                   (),
        .RXCHANISALIGNED0               (),
        .RXCHANISALIGNED1               (),
        .RXCHANREALIGN0                 (),
        .RXCHANREALIGN1                 (),
        .RXPMASETPHASE0                 (tied_to_ground_i),
        .RXPMASETPHASE1                 (tied_to_ground_i),
        .RXSTATUS0                      (),
        .RXSTATUS1                      (),
        //------------- Receive Ports - RX Loss-of-sync State Machine --------------
        .RXLOSSOFSYNC0                  (RXLOSSOFSYNC0_OUT),
        .RXLOSSOFSYNC1                  (RXLOSSOFSYNC1_OUT),
        //-------------------- Receive Ports - RX Oversampling ---------------------
        .RXENSAMPLEALIGN0               (tied_to_ground_i),
        .RXENSAMPLEALIGN1               (tied_to_ground_i),
        .RXOVERSAMPLEERR0               (),
        .RXOVERSAMPLEERR1               (),
        //------------ Receive Ports - RX Pipe Control for PCI Express -------------
        .PHYSTATUS0                     (),
        .PHYSTATUS1                     (),
        .RXVALID0                       (),
        .RXVALID1                       (),
        //--------------- Receive Ports - RX Polarity Control Ports ----------------
        .RXPOLARITY0                    (tied_to_ground_i),
        .RXPOLARITY1                    (tied_to_ground_i),
        //----------- Shared Ports - Dynamic Reconfiguration Port (DRP) ------------
        .DADDR                          (tied_to_ground_vec_i[6:0]),
        .DCLK                           (tied_to_ground_i),
        .DEN                            (tied_to_ground_i),
        .DI                             (tied_to_ground_vec_i[15:0]),
        .DO                             (),
        .DRDY                           (),
        .DWE                            (tied_to_ground_i),
        //------------------- Shared Ports - Tile and PLL Ports --------------------
        .CLKIN                          (CLKIN_IN),
        .GTXRESET                       (GTPRESET_IN),
        .GTXTEST                        (tied_to_ground_vec_i[13:0]),
        .INTDATAWIDTH                   (tied_to_vcc_i),
        .PLLLKDET                       (PLLLKDET_OUT),
        .PLLLKDETEN                     (tied_to_vcc_i),
        .PLLPOWERDOWN                   (tied_to_ground_i),
        .REFCLKOUT                      (REFCLKOUT_OUT),
        .REFCLKPWRDNB                   (tied_to_vcc_i),
        .RESETDONE0                     (resetdone0_i),
        .RESETDONE1                     (resetdone1_i),
//        .RXENELECIDLERESETB             (rxenelecidleresetb_i), // removed found now equiv
//        .TXENPMAPHASEALIGN              (tied_to_ground_i),   // port changed
        .TXENPMAPHASEALIGN0              (tied_to_ground_i),   //replaces above
        .TXENPMAPHASEALIGN1              (tied_to_ground_i),   //replaces above
//        .TXPMASETPHASE                  (tied_to_ground_i),   //changed
        .TXPMASETPHASE0                  (tied_to_ground_i),
        .TXPMASETPHASE1                  (tied_to_ground_i),
        //-------------- Transmit Ports - 8b10b Encoder Control Ports --------------
        .TXBYPASS8B10B0                 (tied_to_ground_vec_i[1:0]),
        .TXBYPASS8B10B1                 (tied_to_ground_vec_i[1:0]),
        .TXCHARDISPMODE0                (tied_to_ground_vec_i[1:0]),
        .TXCHARDISPMODE1                (tied_to_ground_vec_i[1:0]),
        .TXCHARDISPVAL0                 (tied_to_ground_vec_i[1:0]),
        .TXCHARDISPVAL1                 (tied_to_ground_vec_i[1:0]),
        .TXCHARISK0                     (TXCHARISK0_IN),
        .TXCHARISK1                     (TXCHARISK1_IN),
        .TXENC8B10BUSE0                 (tied_to_vcc_i),
        .TXENC8B10BUSE1                 (tied_to_vcc_i),
        .TXKERR0                        (),
        .TXKERR1                        (),
        .TXRUNDISP0                     (),
        .TXRUNDISP1                     (),
        //----------- Transmit Ports - TX Buffering and Phase Alignment ------------
        .TXBUFSTATUS0                   (),
        .TXBUFSTATUS1                   (),
        //---------------- Transmit Ports - TX Data Path interface -----------------
        .TXDATA0                        (txdata0_i),
        .TXDATA1                        (txdata1_i),
        .TXDATAWIDTH0                   (tied_to_vcc_i),
        .TXDATAWIDTH1                   (tied_to_vcc_i),
        .TXOUTCLK0                      (TXOUTCLK0_OUT),
        .TXOUTCLK1                      (TXOUTCLK1_OUT),
        .TXRESET0                       (tied_to_ground_i),
        .TXRESET1                       (tied_to_ground_i),
        .TXUSRCLK0                      (TXUSRCLK0_IN),
        .TXUSRCLK1                      (TXUSRCLK1_IN),
        .TXUSRCLK20                     (txusrclk20_n),
        .TXUSRCLK21                     (txusrclk21_n),
        //------------- Transmit Ports - TX Driver and OOB signalling --------------
        .TXBUFDIFFCTRL0                 (TXDIFFCTRL0_IN),
        .TXBUFDIFFCTRL1                 (TXDIFFCTRL1_IN),
        .TXDIFFCTRL0                    (TXDIFFCTRL0_IN),
        .TXDIFFCTRL1                    (TXDIFFCTRL1_IN),
        .TXINHIBIT0                     (tied_to_ground_i),
        .TXINHIBIT1                     (tied_to_ground_i),
        .TXN0                           (TXN0_OUT),
        .TXN1                           (TXN1_OUT),
        .TXP0                           (TXP0_OUT),
        .TXP1                           (TXP1_OUT),
        .TXPREEMPHASIS0                 (TXPREEMPHASIS0_IN),
        .TXPREEMPHASIS1                 (TXPREEMPHASIS1_IN),
        //------------------- Transmit Ports - TX PRBS Generator -------------------
        .TXENPRBSTST0                   (tied_to_ground_vec_i[1:0]),
        .TXENPRBSTST1                   (tied_to_ground_vec_i[1:0]),
        //------------------ Transmit Ports - TX Polarity Control ------------------
        .TXPOLARITY0                    (tied_to_ground_i),
        .TXPOLARITY1                    (tied_to_ground_i),
        //--------------- Transmit Ports - TX Ports for PCI Express ----------------
        .TXDETECTRX0                    (tied_to_ground_i),
        .TXDETECTRX1                    (tied_to_ground_i),
        .TXELECIDLE0                    (tied_to_ground_i),
        .TXELECIDLE1                    (tied_to_ground_i),
        //------------------- Transmit Ports - TX Ports for SATA -------------------
        .TXCOMSTART0                    (tied_to_ground_i),
        .TXCOMSTART1                    (tied_to_ground_i),
        .TXCOMTYPE0                     (tied_to_ground_i),
        .TXCOMTYPE1                     (tied_to_ground_i)

     );
*/

endmodule

    
