//-----------------------------------------------------------------------------
//  
//  Copyright (c) 2009 Xilinx Inc.
//
//  Project  : Programmable Wave Generator
//  Module   : clk_gen.v
//  Parent   : wave_gen.v
//  Children : None
//
//  Description: 
//     This module is the clock generator for the design.
//     It takes in a single clock input (nominally 100MHz), and generates
//     three output clocks using a single DCM:
//        clk_rx - the CLK0 output of the DCM using a BUFG
//        clk_tx - the CLKFX output of the DCM using a BUFG
//                 - either at the same rate as clk_rx (M=2, D=2) or
//                   at a slightly lower frequency (M=31, D=32)
//        clk_samp - a decimated version of clk_tx using a BUFHCE (from
//                   clk_tx)
//                 - running at 1/prescale the frequency of clk_tx
//
//  Parameters:
//     None
//
//  Notes       : 
//
//  Multicycle and False Paths
//     None

`timescale 1ns/1ps


module clk_gen (
  input             clk_pin,         // Input clock pin - IBUFG is in core
  input             rst_i,           // Asynchronous input from IBUF

  input             rst_clk_tx,      // For clock divider
  
  input      [15:0] pre_clk_tx,      // Current divider

  output            clk_rx,          // Receive clock
  output            clk_tx,          // Transmit clock
  output            clk_samp,        // Sample clock

  output            en_clk_samp,     // Enable for clk_samp
  output            clock_locked     // Locked signal from DCM
);

//***************************************************************************
// Function definitions
//***************************************************************************

//***************************************************************************
// Parameter definitions
//***************************************************************************

//***************************************************************************
// Reg declarations
//***************************************************************************

//***************************************************************************
// Wire declarations
//***************************************************************************

  wire clkout_fx; // CLKFX output of DCM - unbuffered
  
//***************************************************************************
// Code
//***************************************************************************

  // Instantiate the prescale divider

  clk_div clk_div_i0 (
    .clk_tx          (clk_tx),
    .rst_clk_tx      (rst_clk_tx),
    .pre_clk_tx      (pre_clk_tx),
    .en_clk_samp     (en_clk_samp)
  );

  // Instantiate clk_core - generated by the Clocking Wizard
  clk_core clk_core_i0
   (// Clock in ports
    .CLK_IN1            (clk_pin),      // IN
    // Clock out ports
    .CLKOUT1           (clk_rx),     // OUT
    .CLKOUT2           (clkout_fx),     // OUT
    // Status and control signals
    .RESET              (rst_i),        // IN
    .LOCKED             (clock_locked));      // OUT		  
		  
 // Instantiate BUFG for clk_tx here
  
  BUFG BUFG_clk_tx_i0 (
     .O    (clk_tx),        // Clock buffer output
     .I    (clkout_fx)      // Clock buffer input
  ); // BUFG for clk_tx


  // Instantiate BUFGCE for clk_samp here

  BUFGCE BUFGCE_clk_samp_i0 (
     .O    (clk_samp),    // Clock buffer output
     .CE   (en_clk_samp), // Clock enable input
     .I    (clkout_fx)    // Clock buffer input
  ); // BUFGCE for clk_samp



  

endmodule
