--<insert: c:\HW\releasedULD\headers\out_ddr_flop.head>
-- -----------------------------------------------------------------------------
--
-- module:    out_ddr_flop
-- project:   wave_gen
-- company:   Xilinx, Inc.
-- author:    WK, AW
-- 
-- comment:
--   This is a wrapper around a basic DDR output flop. A version of this module
--   with identical ports exists for all target technologies for this design
-- 
-- known issues:
-- status           id     found     description                      by fixed date  by    comment
-- 
-- version history:
--   version    date    author     description
-- 
-- ---------------------------------------------------------------------------
-- 
-- disclaimer:
--   Disclaimer: LIMITED WARRANTY AND DISCLAMER. These designs  are
--   provided to you as is . Xilinx and its licensors make, and  you
--   receive no warranties or conditions, express,  implied,
--   statutory or otherwise, and Xilinx specifically disclaims  any
--   implied warranties of merchantability, non-infringement,  or
--   fitness for a particular purpose. Xilinx does not warrant  that
--   the functions contained in these designs will meet  your
--   requirements, or that the operation of these designs will  be
--   uninterrupted or error free, or that defects in the  Designs
--   will be corrected. Furthermore, Xilinx does not warrant  or
--   make any representations regarding use or the results of  the
--   use of the designs in terms of correctness,  accuracy,
--   reliability, or  otherwise.
--   
-- LIMITATION OF LIABILITY. In no event will Xilinx or  its
--   licensors be liable for any loss of data, lost profits,  cost
--   or procurement of substitute goods or services, or for  any
--   special, incidental, consequential, or indirect  damages
--   arising from the use or operation of the designs  or
--   accompanying documentation, however caused and on any  theory
--   of liability. This limitation will apply even if  Xilinx
--   has been advised of the possibility of such damage.  This
--   limitation shall apply not-withstanding the failure of  the
--   essential purpose of any limited remedies  herein.
--   
-- Copyright  2002, 2008, 2009 Xilinx,  Inc.
--   All rights reserved
-- 
-- -----------------------------------------------------------------------------
--

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.NUMERIC_STD.ALL;

library UNISIM;
use UNISIM.VComponents.all;

entity out_ddr_flop is
    Port ( clk        : in  STD_LOGIC;
           rst        : in  STD_LOGIC;
           d_rise     : in  STD_LOGIC;
           d_fall     : in  STD_LOGIC;
           q          : out  STD_LOGIC
       );
end out_ddr_flop;

architecture Behavioral of out_ddr_flop is

       signal clk_inv : std_logic := 'U';
       
       constant logic_high   : std_logic := '1';
       constant logic_low    : std_logic := '0';

    begin
    
       -- prepare the signals for use with the instantiation
       clk_inv <= not clk;

       -- ODDR2: Output Double Data Rate Output Register with Set, Reset
       --        and Clock Enable.
       --        Spartan-3E/3A/6
       -- Xilinx HDL Language Template, version 11.2
       ODDR2_inst : ODDR2
          generic map(
             DDR_ALIGNMENT => "NONE",   -- Sets output alignment to "NONE", "C0", "C1"
             INIT          => '0',      -- Sets initial state of the Q output to 0 or 1
             SRTYPE        => "SYNC"    -- Specifies "SYNC" or "ASYNC" set/reset
            )
          port map (
             Q     => q,                -- 1-bit output data
             C0    => clk,              -- 1-bit clock input
             C1    => clk_inv,          -- 1-bit clock input
             CE    => logic_high,       -- 1-bit clock enable input
             D0    => d_rise,           -- 1-bit data input (associated with C0)
             D1    => d_fall,           -- 1-bit data input (associated with C1)
             R     => rst,              -- 1-bit reset input
             S     => logic_low         -- 1-bit set input
           );

    end Behavioral;

