//*****************************************************************************
// (c) Copyright 2009 Xilinx, Inc. All rights reserved.
//
// This file contains confidential and proprietary information
// of Xilinx, Inc. and is protected under U.S. and
// international copyright and other intellectual property
// laws.
//
// DISCLAIMER
// This disclaimer is not a license and does not grant any
// rights to the materials distributed herewith. Except as
// otherwise provided in a valid license issued to you by
// Xilinx, and to the maximum extent permitted by applicable
// law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
// WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
// AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
// BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
// INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
// (2) Xilinx shall not be liable (whether in contract or tort,
// including negligence, or under any other theory of
// liability) for any loss or damage of any kind or nature
// related to, arising under or in connection with these
// materials, including for any direct, or any indirect,
// special, incidental, or consequential loss or damage
// (including loss of data, profits, goodwill, or any type of
// loss or damage suffered as a result of any action brought
// by a third party) even if such damage or loss was
// reasonably foreseeable or Xilinx had been advised of the
// possibility of the same.
//
// CRITICAL APPLICATIONS
// Xilinx products are not designed or intended to be fail-
// safe, or for use in any application requiring fail-safe
// performance, such as life-support or safety devices or
// systems, Class III medical devices, nuclear facilities,
// applications related to the deployment of airbags, or any
// other applications that could lead to death, personal
// injury, or severe property or environmental damage
// (individually and collectively, "Critical
// Applications"). Customer assumes the sole risk and
// liability of any use of Xilinx products in Critical
// Applications, subject only to applicable laws and
// regulations governing limitations on product liability.
//
// THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
// PART OF THIS FILE AT ALL TIMES.
//
//*****************************************************************************
//   ____  ____
//  /   /\/   /
// /___/  \  /   Vendor             : Xilinx
// \   \   \/    Version            : 3.5
//  \   \        Application        : MIG
//  /   /        Filename           : sim_tb_top.v
// /___/   /\    Date Last Modified : $Date: 2010/04/22 12:17:54 $
// \   \  /  \   Date Created	    : Mon Mar 2 2009
//  \___\/\___\
//
// Device      : Spartan-6
// Design Name : DDR/DDR2/DDR3/LPDDR
// Purpose     : This is the simulation testbench which is used to verify the
//               design. The basic clocks and resets to the interface are
//               generated here. This also connects the memory interface to the
//               memory model.
//*****************************************************************************

`timescale 1ps/1ps
module sim_tb_top;

// ========================================================================== //
// Parameters                                                                 //
// ========================================================================== //
   parameter DEBUG_EN              = 0;   
   	parameter C3_MEMCLK_PERIOD     = 3200;
   parameter C3_RST_ACT_LOW        = 0;
   parameter C3_INPUT_CLK_TYPE     = "DIFFERENTIAL";
   parameter C3_NUM_DQ_PINS        = 16;
   parameter C3_MEM_ADDR_WIDTH     = 13;
   parameter C3_MEM_BANKADDR_WIDTH = 3;   
   parameter C3_MEM_ADDR_ORDER     = "ROW_BANK_COLUMN"; 
      parameter C3_P0_MASK_SIZE       = 16;
   parameter C3_P0_DATA_PORT_SIZE  = 128;
   parameter C3_MEM_BURST_LEN	  = 8;
   parameter C3_MEM_NUM_COL_BITS   = 10;
   parameter C3_CALIB_SOFT_IP      = "TRUE";  
   parameter C3_SIMULATION      = "TRUE";
   parameter C3_HW_TESTING      = "FALSE";
   localparam C3_p0_BEGIN_ADDRESS                   = (C3_HW_TESTING == "TRUE") ? 32'h01000000:32'h00000400;
   localparam C3_p0_DATA_MODE                       = 4'b0010;
   localparam C3_p0_END_ADDRESS                     = (C3_HW_TESTING == "TRUE") ? 32'h02ffffff:32'h000007ff;
   localparam C3_p0_PRBS_EADDR_MASK_POS             = (C3_HW_TESTING == "TRUE") ? 32'hfc000000:32'hfffff800;
   localparam C3_p0_PRBS_SADDR_MASK_POS             = (C3_HW_TESTING == "TRUE") ? 32'h01000000:32'h00000400;

// ========================================================================== //
// Signal Declarations                                                        //
// ========================================================================== //

// Clocks
					// Clocks
   reg                              c3_sys_clk;
   wire                             c3_sys_clk_p;
   wire                             c3_sys_clk_n;
// System Reset
   reg                              c3_sys_rst;
   wire                             c3_sys_rst_n;



// Design-Top Port Map
   wire                             c3_error;
   wire                             c3_calib_done;
   wire [31:0]                      c3_cmp_data;
   wire                             c3_cmp_error;

   wire [C3_MEM_ADDR_WIDTH-1:0]      mcb3_dram_a;
   wire [C3_MEM_BANKADDR_WIDTH-1:0]  mcb3_dram_ba;  
   wire                             mcb3_dram_ck;  
   wire                             mcb3_dram_ck_n;
   wire [C3_NUM_DQ_PINS-1:0]        mcb3_dram_dq;   
   wire                             mcb3_dram_dqs;  
   wire                             mcb3_dram_dqs_n;
   wire                             mcb3_dram_dm;
   wire                             mcb3_dram_ras_n; 
   wire                             mcb3_dram_cas_n; 
   wire                             mcb3_dram_we_n;  
   wire                             mcb3_dram_cke; 
   wire				                mcb3_dram_odt;

   wire [319:0]       c3_error_status;
   wire                             mcb3_dram_udqs;    // for X16 parts
   wire                             mcb3_dram_udqs_n;  // for X16 parts
   wire                             mcb3_dram_udm;     // for X16 parts

  wire                              c3_vio_modify_enable;
  wire  [2:0]                       c3_vio_data_mode_value;
  wire  [2:0]                       c3_vio_addr_mode_value;


// User design  Sim
        wire                             c3_clk0;
   wire							 c3_rst0;

     wire		c3_p0_cmd_en;
  wire [2:0]	c3_p0_cmd_instr;
  wire [5:0]	c3_p0_cmd_bl;
  wire [29:0]	c3_p0_cmd_byte_addr;
  wire		c3_p0_cmd_empty;
  wire		c3_p0_cmd_full;
  wire		c3_p0_wr_en;
  wire [C3_P0_MASK_SIZE - 1:0]	c3_p0_wr_mask;
  wire [C3_P0_DATA_PORT_SIZE - 1:0]	c3_p0_wr_data;
  wire		c3_p0_wr_full;
  wire		c3_p0_wr_empty;
  wire [6:0]	c3_p0_wr_count;
  wire		c3_p0_wr_underrun;
  wire		c3_p0_wr_error;
  wire		c3_p0_rd_en;
  wire [C3_P0_DATA_PORT_SIZE - 1:0]	c3_p0_rd_data;
  wire		c3_p0_rd_full;
  wire		c3_p0_rd_empty;
  wire [6:0]	c3_p0_rd_count;
  wire		c3_p0_rd_overflow;
  wire		c3_p0_rd_error;



// Error & Calib Signals
   wire                             error;
   wire                             calib_done;
   wire				    rzq3;
     
   wire				    zio3;
     
   
// ========================================================================== //
// Clocks Generation                                                          //
// ========================================================================== //


   initial
      c3_sys_clk = 1'b0;
   always
      #(C3_MEMCLK_PERIOD/2) c3_sys_clk = ~c3_sys_clk;

   assign                c3_sys_clk_p = c3_sys_clk;
   assign                c3_sys_clk_n = ~c3_sys_clk;

// ========================================================================== //
// Reset Generation                                                           //
// ========================================================================== //
 
   initial begin
      c3_sys_rst = 1'b0;		
      #20000;
      c3_sys_rst = 1'b1;
   end
   assign c3_sys_rst_n = C3_RST_ACT_LOW ? c3_sys_rst : ~c3_sys_rst;


// ========================================================================== //
// Error Grouping                                                           //
// ========================================================================== //

assign error = c3_error;
assign calib_done = c3_calib_done;


   

   
   // The PULLDOWN component is connected to the ZIO signal primarily to avoid the
// unknown state in simulation. In real hardware, ZIO should be a no connect(NC) pin.
   PULLDOWN zio_pulldown3 (.O(zio3));
   PULLDOWN rzq_pulldown3 (.O(rzq3));
   

// ========================================================================== //
// DESIGN TOP INSTANTIATION                                                    //
// ========================================================================== //

mig #(

.C3_P0_MASK_SIZE       (C3_P0_MASK_SIZE      ),
.C3_P0_DATA_PORT_SIZE  (C3_P0_DATA_PORT_SIZE ),
	.C3_MEMCLK_PERIOD         (C3_MEMCLK_PERIOD    ),
.C3_RST_ACT_LOW        (C3_RST_ACT_LOW),
.C3_INPUT_CLK_TYPE     (C3_INPUT_CLK_TYPE),

 
.DEBUG_EN              (DEBUG_EN),

.C3_MEM_ADDR_ORDER     (C3_MEM_ADDR_ORDER    ),
.C3_NUM_DQ_PINS        (C3_NUM_DQ_PINS       ),
.C3_MEM_ADDR_WIDTH     (C3_MEM_ADDR_WIDTH    ),
.C3_MEM_BANKADDR_WIDTH (C3_MEM_BANKADDR_WIDTH),

.C3_SIMULATION         (C3_SIMULATION),
.C3_CALIB_SOFT_IP      (C3_CALIB_SOFT_IP )
)
design_top (


    .c3_sys_clk_p           (c3_sys_clk_p),
  .c3_sys_clk_n           (c3_sys_clk_n),
  .c3_sys_rst_n           (c3_sys_rst_n),                        

  .mcb3_dram_dq           (mcb3_dram_dq),  
  .mcb3_dram_a            (mcb3_dram_a),  
  .mcb3_dram_ba           (mcb3_dram_ba),
  .mcb3_dram_ras_n        (mcb3_dram_ras_n),                        
  .mcb3_dram_cas_n        (mcb3_dram_cas_n),                        
  .mcb3_dram_we_n         (mcb3_dram_we_n),                          
  .mcb3_dram_odt          (mcb3_dram_odt),
  .mcb3_dram_cke          (mcb3_dram_cke),                          
  .mcb3_dram_ck           (mcb3_dram_ck),                          
  .mcb3_dram_ck_n         (mcb3_dram_ck_n),       
  .mcb3_dram_dqs          (mcb3_dram_dqs),                          
  .mcb3_dram_dqs_n        (mcb3_dram_dqs_n),
  .mcb3_dram_udqs         (mcb3_dram_udqs),    // for X16 parts                        
  .mcb3_dram_udqs_n       (mcb3_dram_udqs_n),  // for X16 parts
  .mcb3_dram_udm          (mcb3_dram_udm),     // for X16 parts
  .mcb3_dram_dm           (mcb3_dram_dm),
    .c3_clk0		        (c3_clk0),
  .c3_rst0		        (c3_rst0),
	
 
  .c3_calib_done          (c3_calib_done),
     .mcb3_rzq               (rzq3),
               
     .mcb3_zio               (zio3),
               
     .c3_p0_cmd_clk                          (c3_clk0),
   .c3_p0_cmd_en                           (c3_p0_cmd_en),
   .c3_p0_cmd_instr                        (c3_p0_cmd_instr),
   .c3_p0_cmd_bl                           (c3_p0_cmd_bl),
   .c3_p0_cmd_byte_addr                    (c3_p0_cmd_byte_addr),
   .c3_p0_cmd_empty                        (c3_p0_cmd_empty),
   .c3_p0_cmd_full                         (c3_p0_cmd_full),
   .c3_p0_wr_clk                           (c3_clk0),
   .c3_p0_wr_en                            (c3_p0_wr_en),
   .c3_p0_wr_mask                          (c3_p0_wr_mask),
   .c3_p0_wr_data                          (c3_p0_wr_data),
   .c3_p0_wr_full                          (c3_p0_wr_full),
   .c3_p0_wr_empty                         (c3_p0_wr_empty),
   .c3_p0_wr_count                         (c3_p0_wr_count),
   .c3_p0_wr_underrun                      (c3_p0_wr_underrun),
   .c3_p0_wr_error                         (c3_p0_wr_error),
   .c3_p0_rd_clk                           (c3_clk0),
   .c3_p0_rd_en                            (c3_p0_rd_en),
   .c3_p0_rd_data                          (c3_p0_rd_data),
   .c3_p0_rd_full                          (c3_p0_rd_full),
   .c3_p0_rd_empty                         (c3_p0_rd_empty),
   .c3_p0_rd_count                         (c3_p0_rd_count),
   .c3_p0_rd_overflow                      (c3_p0_rd_overflow),
   .c3_p0_rd_error                         (c3_p0_rd_error)
);      

// user interface

 memc3_tb_top #
 (
   .C_NUM_DQ_PINS            (C3_NUM_DQ_PINS),
   .C_MEM_BURST_LEN          (C3_MEM_BURST_LEN),
   .C_MEM_NUM_COL_BITS       (C3_MEM_NUM_COL_BITS),
   .C_p0_BEGIN_ADDRESS                      (C3_p0_BEGIN_ADDRESS),
   .C_p0_DATA_MODE                          (C3_p0_DATA_MODE),
   .C_p0_END_ADDRESS                        (C3_p0_END_ADDRESS),
   .C_p0_PRBS_EADDR_MASK_POS                (C3_p0_PRBS_EADDR_MASK_POS),
   .C_p0_PRBS_SADDR_MASK_POS                (C3_p0_PRBS_SADDR_MASK_POS)
   )
memc3_tb_top_inst
(
   .clk0				(c3_clk0),
   .rst0				(c3_rst0),
   .calib_done			(c3_calib_done), 
   .error				(c3_error),
   .error_status		(c3_error_status),
   .cmp_data			(c3_cmp_data),
   .cmp_data_valid  	(c3_cmp_data_valid),
   .cmp_error			(c3_cmp_error),
   .vio_modify_enable   (1'b1),
   .vio_data_mode_value (3'b010),
   .vio_addr_mode_value (3'b011),
   .p0_mcb_cmd_en_o                         (c3_p0_cmd_en),
   .p0_mcb_cmd_instr_o                      (c3_p0_cmd_instr),
   .p0_mcb_cmd_bl_o                         (c3_p0_cmd_bl),
   .p0_mcb_cmd_addr_o                       (c3_p0_cmd_byte_addr),
   .p0_mcb_cmd_full_i                       (c3_p0_cmd_full),
   .p0_mcb_wr_en_o                          (c3_p0_wr_en),
   .p0_mcb_wr_mask_o                        (c3_p0_wr_mask),
   .p0_mcb_wr_data_o                        (c3_p0_wr_data),
   .p0_mcb_wr_full_i                        (c3_p0_wr_full),
   .p0_mcb_wr_fifo_counts                   (c3_p0_wr_count),
   .p0_mcb_rd_en_o                          (c3_p0_rd_en),
   .p0_mcb_rd_data_i                        (c3_p0_rd_data),
   .p0_mcb_rd_empty_i                       (c3_p0_rd_empty),
   .p0_mcb_rd_fifo_counts                   (c3_p0_rd_count)
  

  );

// ========================================================================== //
// Memory model instances                                                     // 
// ========================================================================== //

   
     ede1116 u_mem_c3(
        .ck         (mcb3_dram_ck),
        .ck_n       (mcb3_dram_ck_n),
        .cke        (mcb3_dram_cke),
        .cs_n       (1'b0),
        .ras_n      (mcb3_dram_ras_n),
        .cas_n      (mcb3_dram_cas_n),
        .we_n       (mcb3_dram_we_n),
        .ldm        (mcb3_dram_dm),
        .udm        (mcb3_dram_udm),
        .ba         (mcb3_dram_ba),
        .a          (mcb3_dram_a),
        .dq         (mcb3_dram_dq),
        .ldqs       (mcb3_dram_dqs),
        .udqs       (mcb3_dram_udqs),
        .ldqs_n     (mcb3_dram_dqs_n),
        .udqs_n     (mcb3_dram_udqs_n),
        .odt        (mcb3_dram_odt)
      );


// ========================================================================== //
// Reporting the test case status 
// ========================================================================== //
   initial
   begin : Logging
      fork
         begin : calibration_done
            wait (calib_done);
            $display("Calibration Done");
            #50000000;
            if (!error) begin
               $display("TEST PASSED");
            end   
            else begin
               $display("TEST FAILED: DATA ERROR");		 
            end
            disable calib_not_done;
	    $finish;
         end	 
         
         begin : calib_not_done
            #200000000;
            if (!calib_done) begin
               $display("TEST FAILED: INITIALIZATION DID NOT COMPLETE");
            end
            disable calibration_done;
	    $finish;
         end
      join	 
   end      

endmodule
