{
  'ClockGenerator' => {
    'DCM' => {
      'Clk0' => {
        'Used' => true
      },
      'Clk2x' => {
        'Used' => false
      },
      'ClkDv' => {
        'Used' => false
      },
      'ClkFx' => {
        'Used' => false
      },
      'ClkInDivideBy2' => false,
      'DFSFrequencyMode' => 'LOW',
      'DLLFrequencyMode' => 'LOW'
    },
    'Type' => 'DCM'
  },
  'CosimCore' => {
    'EntityName' => 'jtagcosim_iface_spartan6',
    'Interface' => {
      'Clock' => [
        {
          'Clock' => {
            'Period' => 37.00000000000
          },
          'Constraints' => [
            'NET "hwcosim_sys_clk" LOC = V10;'
          ],
          'DCMPort' => 'clk0',
          'Direction' => 'in',
          'IOType' => 'ibufg',
          'Name' => 'sys_clk',
          'Width' => 1
        }
      ],
      'Cosim' => [
        {
          'Direction' => 'out',
          'Name' => 'addr',
          'Width' => 24
        },
        {
          'Direction' => 'out',
          'Name' => 'bank_sel',
          'Width' => 8
        },
        {
          'Direction' => 'out',
          'Name' => 'cosim_clk_sel',
          'Width' => 1
        },
        {
          'Direction' => 'out',
          'Name' => 'data_in',
          'Width' => 32
        },
        {
          'Direction' => 'in',
          'Name' => 'data_out',
          'Width' => 32
        },
        {
          'Direction' => 'out',
          'Name' => 'sstep_clk',
          'Width' => 1
        },
        {
          'Direction' => 'out',
          'Name' => 'we',
          'Width' => 1
        },
        {
          'Direction' => 'out',
          'Name' => 're',
          'Width' => 1
        }
      ]
    }
  },
  'Design' => {
    'BasePath' => 'C:/Tutorials/mig_sp601',
    'Constraints' => [
      'CONFIG VCCAUX=2.5; # Valid values are 2.5 and 3.3',
      'CONFIG MCB_PERFORMANCE= STANDARD;',
      'NET "*memc?_wrapper_inst/memc?_mcb_raw_wrapper_inst/selfrefresh_mcb_mode" TIG;',
      'NET "*c?_pll_lock" TIG;',
      'NET "*memc?_wrapper_inst/memc?_mcb_raw_wrapper_inst/gen_term_calib.mcb_soft_calibration_top_inst/mcb_soft_calibration_inst/CKE_Train" TIG;',
      'NET "*memc3_infrastructure_inst/sys_clk_ibufg" TNM_NET = "SYS_CLK3";',
      'TIMESPEC "TS_SYS_CLK3" = PERIOD "SYS_CLK3"  5  ns HIGH 50 %;',
      'NET "mcb3_dram_dq[*]"                                 IN_TERM = NONE;',
      'NET "mcb3_dram_dqs"                                   IN_TERM = NONE;',
      'NET "mcb3_dram_dqs_n"                                 IN_TERM = NONE;',
      'NET "mcb3_dram_udqs"                                  IN_TERM = NONE;',
      'NET "mcb3_dram_udqs_n"                                IN_TERM = NONE;',
      'NET  "mcb3_dram_dq[*]"                               IOSTANDARD = SSTL18_II;',
      'NET  "mcb3_dram_a[*]"                                IOSTANDARD = SSTL18_II;',
      'NET  "mcb3_dram_ba[*]"                               IOSTANDARD = SSTL18_II;',
      'NET  "mcb3_dram_dqs"                                 IOSTANDARD = DIFF_SSTL18_II;',
      'NET  "mcb3_dram_udqs"                                IOSTANDARD = DIFF_SSTL18_II;',
      'NET  "mcb3_dram_dqs_n"                               IOSTANDARD = DIFF_SSTL18_II;',
      'NET  "mcb3_dram_udqs_n"                              IOSTANDARD = DIFF_SSTL18_II;',
      'NET  "mcb3_dram_ck"                                  IOSTANDARD = DIFF_SSTL18_II;',
      'NET  "mcb3_dram_ck_n"                                IOSTANDARD = DIFF_SSTL18_II;',
      'NET  "mcb3_dram_cke"                                 IOSTANDARD = SSTL18_II;',
      'NET  "mcb3_dram_ras_n"                               IOSTANDARD = SSTL18_II;',
      'NET  "mcb3_dram_cas_n"                               IOSTANDARD = SSTL18_II;',
      'NET  "mcb3_dram_we_n"                                IOSTANDARD = SSTL18_II;',
      'NET  "mcb3_dram_odt"                                 IOSTANDARD = SSTL18_II;',
      'NET  "mcb3_dram_dm"                                  IOSTANDARD = SSTL18_II;',
      'NET  "mcb3_dram_udm"                                 IOSTANDARD = SSTL18_II;',
      'NET  "mcb3_rzq"                                      IOSTANDARD = SSTL18_II;',
      'NET  "mcb3_zio"                                      IOSTANDARD = SSTL18_II;',
      'NET  "c3_sys_clk_p"                                IOSTANDARD = LVDS_25;',
      'NET  "c3_sys_clk_n"                                IOSTANDARD = LVDS_25;',
      'NET  "mcb3_dram_a[0]"                            LOC = "J7" ;',
      'NET  "mcb3_dram_a[10]"                           LOC = "F4" ;',
      'NET  "mcb3_dram_a[11]"                           LOC = "D3" ;',
      'NET  "mcb3_dram_a[12]"                           LOC = "G6" ;',
      'NET  "mcb3_dram_a[1]"                            LOC = "J6" ;',
      'NET  "mcb3_dram_a[2]"                            LOC = "H5" ;',
      'NET  "mcb3_dram_a[3]"                            LOC = "L7" ;',
      'NET  "mcb3_dram_a[4]"                            LOC = "F3" ;',
      'NET  "mcb3_dram_a[5]"                            LOC = "H4" ;',
      'NET  "mcb3_dram_a[6]"                            LOC = "H3" ;',
      'NET  "mcb3_dram_a[7]"                            LOC = "H6" ;',
      'NET  "mcb3_dram_a[8]"                            LOC = "D2" ;',
      'NET  "mcb3_dram_a[9]"                            LOC = "D1" ;',
      'NET  "mcb3_dram_ba[0]"                           LOC = "F2" ;',
      'NET  "mcb3_dram_ba[1]"                           LOC = "F1" ;',
      'NET  "mcb3_dram_ba[2]"                           LOC = "E1" ;',
      'NET  "mcb3_dram_cas_n"                           LOC = "K5" ;',
      'NET  "mcb3_dram_ck"                              LOC = "G3" ;',
      'NET  "mcb3_dram_ck_n"                            LOC = "G1" ;',
      'NET  "mcb3_dram_cke"                             LOC = "H7" ;',
      'NET  "mcb3_dram_dm"                              LOC = "K3" ;',
      'NET  "mcb3_dram_dq[0]"                           LOC = "L2" ;',
      'NET  "mcb3_dram_dq[10]"                          LOC = "N2" ;',
      'NET  "mcb3_dram_dq[11]"                          LOC = "N1" ;',
      'NET  "mcb3_dram_dq[12]"                          LOC = "T2" ;',
      'NET  "mcb3_dram_dq[13]"                          LOC = "T1" ;',
      'NET  "mcb3_dram_dq[14]"                          LOC = "U2" ;',
      'NET  "mcb3_dram_dq[15]"                          LOC = "U1" ;',
      'NET  "mcb3_dram_dq[1]"                           LOC = "L1" ;',
      'NET  "mcb3_dram_dq[2]"                           LOC = "K2" ;',
      'NET  "mcb3_dram_dq[3]"                           LOC = "K1" ;',
      'NET  "mcb3_dram_dq[4]"                           LOC = "H2" ;',
      'NET  "mcb3_dram_dq[5]"                           LOC = "H1" ;',
      'NET  "mcb3_dram_dq[6]"                           LOC = "J3" ;',
      'NET  "mcb3_dram_dq[7]"                           LOC = "J1" ;',
      'NET  "mcb3_dram_dq[8]"                           LOC = "M3" ;',
      'NET  "mcb3_dram_dq[9]"                           LOC = "M1" ;',
      'NET  "mcb3_dram_dqs"                             LOC = "L4" ;',
      'NET  "mcb3_dram_dqs_n"                           LOC = "L3" ;',
      'NET  "mcb3_dram_odt"                             LOC = "K6" ;',
      'NET  "mcb3_dram_ras_n"                           LOC = "L5" ;',
      'NET  "c3_sys_clk_n"                              LOC = "K16" ;',
      'NET  "c3_sys_clk_p"                              LOC = "K15" ;',
      'NET  "mcb3_dram_udm"                             LOC = "K4" ;',
      'NET  "mcb3_dram_udqs"                            LOC = "P2" ;',
      'NET  "mcb3_dram_udqs_n"                          LOC = "P1" ;',
      'NET  "mcb3_dram_we_n"                            LOC = "E3" ;',
      'NET  "mcb3_rzq"                                  LOC = "C2" ;',
      'NET  "mcb3_zio"                                  LOC = "L6" ;'
    ],
    'ConstraintsFile' => 'C:/Tutorials/mig_sp601/mig_dut_hwcosim.ucf',
    'EntityName' => 'mig_dut',
    'HDLFileExtension' => 'v',
    'HDLLanguage' => 'verilog',
    'InstanceName' => 'mig_hw_tb/mig_inst',
    'ParameterList' => [
      {
        'Name' => 'C3_P0_MASK_SIZE',
        'Signed' => 'signed',
        'Value' => '16'
      },
      {
        'Name' => 'C3_P0_DATA_PORT_SIZE',
        'Signed' => 'signed',
        'Value' => '128'
      },
      {
        'Name' => 'C3_MEMCLK_PERIOD',
        'Signed' => 'signed',
        'Value' => '3000'
      },
      {
        'Name' => 'C3_CALIB_SOFT_IP',
        'Range' => {
          'Left' => '31',
          'Right' => '0'
        },
        'Value' => '"TRUE"'
      },
      {
        'Name' => 'C3_RST_ACT_LOW',
        'Signed' => 'signed',
        'Value' => '0'
      },
      {
        'Name' => 'C3_INPUT_CLK_TYPE',
        'Range' => {
          'Left' => '95',
          'Right' => '0'
        },
        'Value' => '"DIFFERENTIAL"'
      },
      {
        'Name' => 'C3_MEM_ADDR_ORDER',
        'Range' => {
          'Left' => '119',
          'Right' => '0'
        },
        'Value' => '"ROW_BANK_COLUMN"'
      },
      {
        'Name' => 'C3_NUM_DQ_PINS',
        'Signed' => 'signed',
        'Value' => '16'
      },
      {
        'Name' => 'C3_MEM_ADDR_WIDTH',
        'Signed' => 'signed',
        'Value' => '13'
      },
      {
        'Name' => 'C3_MEM_BANKADDR_WIDTH',
        'Signed' => 'signed',
        'Value' => '3'
      },
      {
        'Name' => 'C3_MC_CALIB_BYPASS',
        'Range' => {
          'Left' => '15',
          'Right' => '0'
        },
        'Value' => '"NO"'
      }
    ],
    'PortList' => [
      {
        'Direction' => 'in',
        'Name' => 'c3_p0_cmd_en'
      },
      {
        'Direction' => 'in',
        'Name' => 'c3_p0_cmd_instr',
        'Range' => {
          'Left' => '2',
          'Right' => '0'
        }
      },
      {
        'Direction' => 'in',
        'Name' => 'c3_p0_cmd_bl',
        'Range' => {
          'Left' => '5',
          'Right' => '0'
        }
      },
      {
        'Direction' => 'in',
        'Name' => 'c3_p0_cmd_byte_addr',
        'Range' => {
          'Left' => '29',
          'Right' => '0'
        }
      },
      {
        'Direction' => 'out',
        'Name' => 'c3_p0_cmd_empty'
      },
      {
        'Direction' => 'out',
        'Name' => 'c3_p0_cmd_full'
      },
      {
        'Direction' => 'in',
        'Name' => 'c3_p0_wr_en'
      },
      {
        'Direction' => 'in',
        'Name' => 'c3_p0_wr_mask',
        'Range' => {
          'Left' => '15',
          'Right' => '0'
        }
      },
      {
        'Direction' => 'in',
        'Name' => 'c3_p0_wr_data',
        'Range' => {
          'Left' => '127',
          'Right' => '0'
        }
      },
      {
        'Direction' => 'out',
        'Name' => 'c3_p0_wr_full'
      },
      {
        'Direction' => 'out',
        'Name' => 'c3_p0_wr_empty'
      },
      {
        'Direction' => 'out',
        'Name' => 'c3_p0_wr_count',
        'Range' => {
          'Left' => '6',
          'Right' => '0'
        }
      },
      {
        'Direction' => 'out',
        'Name' => 'c3_p0_wr_underrun'
      },
      {
        'Direction' => 'out',
        'Name' => 'c3_p0_wr_error'
      },
      {
        'Direction' => 'in',
        'Name' => 'c3_p0_rd_en'
      },
      {
        'Direction' => 'out',
        'Name' => 'c3_p0_rd_data',
        'Range' => {
          'Left' => '127',
          'Right' => '0'
        }
      },
      {
        'Direction' => 'out',
        'Name' => 'c3_p0_rd_full'
      },
      {
        'Direction' => 'out',
        'Name' => 'c3_p0_rd_empty'
      },
      {
        'Direction' => 'out',
        'Name' => 'c3_p0_rd_count',
        'Range' => {
          'Left' => '6',
          'Right' => '0'
        }
      },
      {
        'Direction' => 'out',
        'Name' => 'c3_p0_rd_overflow'
      },
      {
        'Direction' => 'out',
        'Name' => 'c3_p0_rd_error'
      },
      {
        'Direction' => 'in',
        'Name' => 'c3_sys_rst_n'
      },
      {
        'Direction' => 'out',
        'Name' => 'c3_calib_done'
      },
      {
        'Direction' => 'in',
        'IsClock' => true,
        'Name' => 'c3_clk0',
        'Period' => 37.00000000000
      },
      {
        'Direction' => 'out',
        'Name' => 'c3_rst0'
      },
      {
        'Direction' => 'in',
        'IsExternal' => true,
        'Name' => 'c3_sys_clk_p'
      },
      {
        'Direction' => 'in',
        'IsExternal' => true,
        'Name' => 'c3_sys_clk_n'
      },
      {
        'Direction' => 'inout',
        'IsExternal' => true,
        'Name' => 'mcb3_dram_dq',
        'Range' => {
          'Left' => '15',
          'Right' => '0'
        }
      },
      {
        'Direction' => 'out',
        'IsExternal' => true,
        'Name' => 'mcb3_dram_a',
        'Range' => {
          'Left' => '12',
          'Right' => '0'
        }
      },
      {
        'Direction' => 'out',
        'IsExternal' => true,
        'Name' => 'mcb3_dram_ba',
        'Range' => {
          'Left' => '2',
          'Right' => '0'
        }
      },
      {
        'Direction' => 'out',
        'IsExternal' => true,
        'Name' => 'mcb3_dram_ras_n'
      },
      {
        'Direction' => 'out',
        'IsExternal' => true,
        'Name' => 'mcb3_dram_cas_n'
      },
      {
        'Direction' => 'out',
        'IsExternal' => true,
        'Name' => 'mcb3_dram_we_n'
      },
      {
        'Direction' => 'out',
        'IsExternal' => true,
        'Name' => 'mcb3_dram_odt'
      },
      {
        'Direction' => 'out',
        'IsExternal' => true,
        'Name' => 'mcb3_dram_cke'
      },
      {
        'Direction' => 'out',
        'IsExternal' => true,
        'Name' => 'mcb3_dram_dm'
      },
      {
        'Direction' => 'inout',
        'IsExternal' => true,
        'Name' => 'mcb3_dram_udqs'
      },
      {
        'Direction' => 'inout',
        'IsExternal' => true,
        'Name' => 'mcb3_dram_udqs_n'
      },
      {
        'Direction' => 'inout',
        'IsExternal' => true,
        'Name' => 'mcb3_rzq'
      },
      {
        'Direction' => 'inout',
        'IsExternal' => true,
        'Name' => 'mcb3_zio'
      },
      {
        'Direction' => 'out',
        'IsExternal' => true,
        'Name' => 'mcb3_dram_udm'
      },
      {
        'Direction' => 'inout',
        'IsExternal' => true,
        'Name' => 'mcb3_dram_dqs'
      },
      {
        'Direction' => 'inout',
        'IsExternal' => true,
        'Name' => 'mcb3_dram_dqs_n'
      },
      {
        'Direction' => 'out',
        'IsExternal' => true,
        'Name' => 'mcb3_dram_ck'
      },
      {
        'Direction' => 'out',
        'IsExternal' => true,
        'Name' => 'mcb3_dram_ck_n'
      }
    ],
    'ProjectFile' => 'C:/Tutorials/mig_sp601/hwcosim_xst.prj'
  },
  'Flow' => 'isim',
  'MemoryMap' => {
    'InputPortMapping' => [
      {
        'Address' => 0,
        'Port' => {
          'Name' => 'c3_p0_cmd_en'
        }
      },
      {
        'Address' => 1,
        'Port' => {
          'Name' => 'c3_p0_cmd_instr',
          'Range' => {
            'Left' => 2,
            'Right' => 0
          }
        }
      },
      {
        'Address' => 2,
        'Port' => {
          'Name' => 'c3_p0_cmd_bl',
          'Range' => {
            'Left' => 5,
            'Right' => 0
          }
        }
      },
      {
        'Address' => 3,
        'Port' => {
          'Name' => 'c3_p0_cmd_byte_addr',
          'Range' => {
            'Left' => 29,
            'Right' => 0
          }
        }
      },
      {
        'Address' => 4,
        'Port' => {
          'Name' => 'c3_p0_wr_en'
        }
      },
      {
        'Address' => 5,
        'Port' => {
          'Name' => 'c3_p0_wr_mask',
          'Range' => {
            'Left' => 15,
            'Right' => 0
          }
        }
      },
      {
        'Address' => 6,
        'Port' => {
          'Name' => 'c3_p0_wr_data',
          'Range' => {
            'Left' => 127,
            'Right' => 96
          }
        }
      },
      {
        'Address' => 7,
        'Port' => {
          'Name' => 'c3_p0_wr_data',
          'Range' => {
            'Left' => 95,
            'Right' => 64
          }
        }
      },
      {
        'Address' => 8,
        'Port' => {
          'Name' => 'c3_p0_wr_data',
          'Range' => {
            'Left' => 63,
            'Right' => 32
          }
        }
      },
      {
        'Address' => 9,
        'Port' => {
          'Name' => 'c3_p0_wr_data',
          'Range' => {
            'Left' => 31,
            'Right' => 0
          }
        }
      },
      {
        'Address' => 10,
        'Port' => {
          'Name' => 'c3_p0_rd_en'
        }
      },
      {
        'Address' => 11,
        'Port' => {
          'Name' => 'c3_sys_rst_n'
        }
      },
      {
        'Address' => 12,
        'Port' => {
          'Name' => 'c3_sys_clk_p'
        }
      },
      {
        'Address' => 13,
        'Port' => {
          'Name' => 'c3_sys_clk_n'
        }
      }
    ],
    'OutputPortMapping' => [
      {
        'Address' => 0,
        'Port' => {
          'Name' => 'c3_p0_cmd_empty'
        }
      },
      {
        'Address' => 1,
        'Port' => {
          'Name' => 'c3_p0_cmd_full'
        }
      },
      {
        'Address' => 2,
        'Port' => {
          'Name' => 'c3_p0_wr_full'
        }
      },
      {
        'Address' => 3,
        'Port' => {
          'Name' => 'c3_p0_wr_empty'
        }
      },
      {
        'Address' => 4,
        'Port' => {
          'Name' => 'c3_p0_wr_count',
          'Range' => {
            'Left' => 6,
            'Right' => 0
          }
        }
      },
      {
        'Address' => 5,
        'Port' => {
          'Name' => 'c3_p0_wr_underrun'
        }
      },
      {
        'Address' => 6,
        'Port' => {
          'Name' => 'c3_p0_wr_error'
        }
      },
      {
        'Address' => 7,
        'Port' => {
          'Name' => 'c3_p0_rd_data',
          'Range' => {
            'Left' => 127,
            'Right' => 96
          }
        }
      },
      {
        'Address' => 8,
        'Port' => {
          'Name' => 'c3_p0_rd_data',
          'Range' => {
            'Left' => 95,
            'Right' => 64
          }
        }
      },
      {
        'Address' => 9,
        'Port' => {
          'Name' => 'c3_p0_rd_data',
          'Range' => {
            'Left' => 63,
            'Right' => 32
          }
        }
      },
      {
        'Address' => 10,
        'Port' => {
          'Name' => 'c3_p0_rd_data',
          'Range' => {
            'Left' => 31,
            'Right' => 0
          }
        }
      },
      {
        'Address' => 11,
        'Port' => {
          'Name' => 'c3_p0_rd_full'
        }
      },
      {
        'Address' => 12,
        'Port' => {
          'Name' => 'c3_p0_rd_empty'
        }
      },
      {
        'Address' => 13,
        'Port' => {
          'Name' => 'c3_p0_rd_count',
          'Range' => {
            'Left' => 6,
            'Right' => 0
          }
        }
      },
      {
        'Address' => 14,
        'Port' => {
          'Name' => 'c3_p0_rd_overflow'
        }
      },
      {
        'Address' => 15,
        'Port' => {
          'Name' => 'c3_p0_rd_error'
        }
      },
      {
        'Address' => 16,
        'Port' => {
          'Name' => 'c3_calib_done'
        }
      },
      {
        'Address' => 17,
        'Port' => {
          'Name' => 'c3_rst0'
        }
      },
      {
        'Address' => 18,
        'Port' => {
          'Name' => 'mcb3_dram_a',
          'Range' => {
            'Left' => 12,
            'Right' => 0
          }
        }
      },
      {
        'Address' => 19,
        'Port' => {
          'Name' => 'mcb3_dram_ba',
          'Range' => {
            'Left' => 2,
            'Right' => 0
          }
        }
      },
      {
        'Address' => 20,
        'Port' => {
          'Name' => 'mcb3_dram_ras_n'
        }
      },
      {
        'Address' => 21,
        'Port' => {
          'Name' => 'mcb3_dram_cas_n'
        }
      },
      {
        'Address' => 22,
        'Port' => {
          'Name' => 'mcb3_dram_we_n'
        }
      },
      {
        'Address' => 23,
        'Port' => {
          'Name' => 'mcb3_dram_odt'
        }
      },
      {
        'Address' => 24,
        'Port' => {
          'Name' => 'mcb3_dram_cke'
        }
      },
      {
        'Address' => 25,
        'Port' => {
          'Name' => 'mcb3_dram_dm'
        }
      },
      {
        'Address' => 26,
        'Port' => {
          'Name' => 'mcb3_dram_udm'
        }
      },
      {
        'Address' => 27,
        'Port' => {
          'Name' => 'mcb3_dram_ck'
        }
      },
      {
        'Address' => 28,
        'Port' => {
          'Name' => 'mcb3_dram_ck_n'
        }
      }
    ]
  },
  'Platform' => {
    'Board' => 'sp601',
    'BoundaryScanPosition' => 1,
    'Clock' => {
      'Differential' => false,
      'Period' => 37,
      'Pin' => 'V10'
    },
    'Description' => 'SP601 (JTAG)',
    'Interface' => 'jtag',
    'Part' => {
      'BaseFamily' => 'spartan6',
      'Device' => 'xc6slx16',
      'Family' => 'spartan6',
      'Package' => 'csg324',
      'Speed' => '-2'
    },
    'Type' => 'jtag',
    'Vendor' => 'Xilinx'
  },
  'SYSGEN' => 'D:/opt/win64/ISE-12.3_M.66.0/ISE/sysgen',
  'Target' => {
    'ExcludedModules' => [

    ],
    'Modules' => [
      'jtag'
    ]
  },
  'TopLevel' => {
    'EntityName' => 'jtagcosim_top'
  },
  'Type' => 'hwcosim',
  'Version' => '9.2',
  'XILINX' => 'D:/opt/win64/ISE-12.3_M.66.0/ISE'
}
