`timescale 1ns/1ps

module mig_dut #
(
  parameter C3_P0_MASK_SIZE         = 16,
  parameter C3_P0_DATA_PORT_SIZE    = 128,
  parameter C3_MEMCLK_PERIOD        = 3000,
  parameter C3_CALIB_SOFT_IP        = "TRUE",
  parameter C3_RST_ACT_LOW          = 0,
  parameter C3_INPUT_CLK_TYPE       = "DIFFERENTIAL",
  parameter C3_MEM_ADDR_ORDER       = "ROW_BANK_COLUMN",
  parameter C3_NUM_DQ_PINS          = 16,
  parameter C3_MEM_ADDR_WIDTH       = 13,
  parameter C3_MEM_BANKADDR_WIDTH   = 3,
  parameter C3_MC_CALIB_BYPASS      = "NO"
)
(
  input                               c3_p0_cmd_en,
  input  [2:0]                        c3_p0_cmd_instr,
  input  [5:0]                        c3_p0_cmd_bl,
  input  [29:0]                       c3_p0_cmd_byte_addr,
  output                              c3_p0_cmd_empty,
  output                              c3_p0_cmd_full,
  input                               c3_p0_wr_en,
  input  [C3_P0_MASK_SIZE - 1:0]      c3_p0_wr_mask,
  input  [C3_P0_DATA_PORT_SIZE - 1:0] c3_p0_wr_data,
  output                              c3_p0_wr_full,
  output                              c3_p0_wr_empty,
  output [6:0]                        c3_p0_wr_count,
  output                              c3_p0_wr_underrun,
  output                              c3_p0_wr_error,
  input                               c3_p0_rd_en,
  output [C3_P0_DATA_PORT_SIZE - 1:0] c3_p0_rd_data,
  output                              c3_p0_rd_full,
  output                              c3_p0_rd_empty,
  output [6:0]                        c3_p0_rd_count,
  output                              c3_p0_rd_overflow,
  output                              c3_p0_rd_error,
  input                               c3_sys_rst_n,
  output                              c3_calib_done,
  input                               c3_clk0,
  output                              c3_rst0,
  input                               c3_sys_clk_p,
  input                               c3_sys_clk_n,
  inout  [C3_NUM_DQ_PINS-1:0]         mcb3_dram_dq,
  output [C3_MEM_ADDR_WIDTH-1:0]      mcb3_dram_a,
  output [C3_MEM_BANKADDR_WIDTH-1:0]  mcb3_dram_ba,
  output                              mcb3_dram_ras_n,
  output                              mcb3_dram_cas_n,
  output                              mcb3_dram_we_n,
  output                              mcb3_dram_odt,
  output                              mcb3_dram_cke,
  output                              mcb3_dram_dm,
  inout                               mcb3_dram_udqs,
  inout                               mcb3_dram_udqs_n,
  inout                               mcb3_rzq,
  inout                               mcb3_zio,
  output                              mcb3_dram_udm,
  inout                               mcb3_dram_dqs,
  inout                               mcb3_dram_dqs_n,
  output                              mcb3_dram_ck,
  output                              mcb3_dram_ck_n
);

wire c3_p0_cmd_clk;
wire c3_p0_wr_clk;
wire c3_p0_rd_clk;

assign c3_p0_cmd_clk = c3_clk0;
assign c3_p0_wr_clk = c3_clk0;
assign c3_p0_rd_clk = c3_clk0;

mig #
(
  .C3_P0_MASK_SIZE       (C3_P0_MASK_SIZE),
  .C3_P0_DATA_PORT_SIZE  (C3_P0_DATA_PORT_SIZE),
  .C3_MEMCLK_PERIOD      (C3_MEMCLK_PERIOD),
  .C3_CALIB_SOFT_IP      (C3_CALIB_SOFT_IP),
  .C3_RST_ACT_LOW        (C3_RST_ACT_LOW),
  .C3_INPUT_CLK_TYPE     (C3_INPUT_CLK_TYPE),
  .C3_MEM_ADDR_ORDER     (C3_MEM_ADDR_ORDER),
  .C3_NUM_DQ_PINS        (C3_NUM_DQ_PINS),
  .C3_MEM_ADDR_WIDTH     (C3_MEM_ADDR_WIDTH),
  .C3_MEM_BANKADDR_WIDTH (C3_MEM_BANKADDR_WIDTH)
)
mig (
  .mcb3_dram_dq        (mcb3_dram_dq),
  .mcb3_dram_a         (mcb3_dram_a),
  .mcb3_dram_ba        (mcb3_dram_ba),
  .mcb3_dram_ras_n     (mcb3_dram_ras_n),
  .mcb3_dram_cas_n     (mcb3_dram_cas_n),
  .mcb3_dram_we_n      (mcb3_dram_we_n),
  .mcb3_dram_odt       (mcb3_dram_odt),
  .mcb3_dram_cke       (mcb3_dram_cke),
  .mcb3_dram_dm        (mcb3_dram_dm),
  .mcb3_dram_udqs      (mcb3_dram_udqs),
  .mcb3_dram_udqs_n    (mcb3_dram_udqs_n),
  .mcb3_rzq            (mcb3_rzq),
  .mcb3_zio            (mcb3_zio),
  .mcb3_dram_udm       (mcb3_dram_udm),
  .c3_sys_clk_p        (c3_sys_clk_p),
  .c3_sys_clk_n        (c3_sys_clk_n),
  .c3_sys_rst_n        (c3_sys_rst_n),
  .c3_calib_done       (c3_calib_done),
  .c3_clk0             (),
  .c3_rst0             (c3_rst0),
  .mcb3_dram_dqs       (mcb3_dram_dqs),
  .mcb3_dram_dqs_n     (mcb3_dram_dqs_n),
  .mcb3_dram_ck        (mcb3_dram_ck),
  .mcb3_dram_ck_n      (mcb3_dram_ck_n),
  .c3_p0_cmd_clk       (c3_p0_cmd_clk),
  .c3_p0_cmd_en        (c3_p0_cmd_en),
  .c3_p0_cmd_instr     (c3_p0_cmd_instr),
  .c3_p0_cmd_bl        (c3_p0_cmd_bl),
  .c3_p0_cmd_byte_addr (c3_p0_cmd_byte_addr),
  .c3_p0_cmd_empty     (c3_p0_cmd_empty),
  .c3_p0_cmd_full      (c3_p0_cmd_full),
  .c3_p0_wr_clk        (c3_p0_wr_clk),
  .c3_p0_wr_en         (c3_p0_wr_en),
  .c3_p0_wr_mask       (c3_p0_wr_mask),
  .c3_p0_wr_data       (c3_p0_wr_data),
  .c3_p0_wr_full       (c3_p0_wr_full),
  .c3_p0_wr_empty      (c3_p0_wr_empty),
  .c3_p0_wr_count      (c3_p0_wr_count),
  .c3_p0_wr_underrun   (c3_p0_wr_underrun),
  .c3_p0_wr_error      (c3_p0_wr_error),
  .c3_p0_rd_clk        (c3_p0_rd_clk),
  .c3_p0_rd_en         (c3_p0_rd_en),
  .c3_p0_rd_data       (c3_p0_rd_data),
  .c3_p0_rd_full       (c3_p0_rd_full),
  .c3_p0_rd_empty      (c3_p0_rd_empty),
  .c3_p0_rd_count      (c3_p0_rd_count),
  .c3_p0_rd_overflow   (c3_p0_rd_overflow),
  .c3_p0_rd_error      (c3_p0_rd_error)
);

endmodule
