proc testmem {startAddress endAddress dataPattern} {
    isim force add {/mig_hw_tb/params/StartAddress} $startAddress -radix dec
    isim force add {/mig_hw_tb/params/EndAddress} $endAddress -radix dec
    isim force add {/mig_hw_tb/params/DataPattern} $dataPattern -radix dec
    isim force add {/mig_hw_tb/run_test_trigger} 0
    run 10 ns
    isim force add {/mig_hw_tb/run_test_trigger} 1
    set t0 [clock clicks -milliseconds]
    run all
    set t1 [clock clicks -milliseconds]
    set elapsed [expr {($t1 - $t0) / 1000.0}]
    puts "### Last test took $elapsed s\n"
}
