-- ODELAYE2: Output Fixed or Variable Delay Element
--           7 Series
-- Xilinx HDL Libraries Guide, version 13.1

ODELAYE2_inst : ODELAYE2
generic map (
   CINVCTRL_SEL => "FALSE",         -- Enable dynamic clock inversion ("TRUE"/"FALSE") 
   DELAY_SRC => "ODATAIN",          -- Delay input ("ODATAIN" or DATAIN")
   HIGH_PERFORMANCE_MODE => "TRUE", -- Reduced jitter ("TRUE"), Reduced power ("FALSE")
   ODELAY_TYPE => "FIXED",          -- "FIXED", "VARIABLE", "VAR_LOAD" or "VAR_LOAD_PIPE"
   ODELAY_VALUE => 0,               -- Input delay tap setting (0-31)
   PIPE_SEL => "FALSE",             -- Select pipelined mode, "TRUE"/"FALSE"
   REFCLK_FREQUENCY => 200.0,       -- IDELAYCTRL clock input frequency in MHz
   SIGNAL_PATTERN => "DATA"         -- "DATA" or "CLOCK" input signal
)
port map (
   CNTVALUEOUT => CNTVALUEOUT, -- 5-bit output - Counter value for monitoring purpose
   DATAOUT => DATAOUT,         -- 1-bit output - Delayed data output
   C => C,                     -- 1-bit input - Clock input
   CE => CE,                   -- 1-bit input - Active high enable increment/decrement function
   CINVCTRL => CINVCTRL,       -- 1-bit input - Dynamically inverts the Clock (C) polarity
   CNTVALUEIN => CNTVALUEIN,   -- 5-bit input - Counter value for loadable counter application
   DATAIN => DATAIN,           -- 1-bit input - Internal delay data
   ODATAIN => ODATAIN,         -- 1-bit input - Delay data input
   INC => INC,                 -- 1-bit input - Increment / Decrement tap delay
   ODATAIN => ODATAIN,         -- 1-bit input - Data input for the output datapath from the device
   REGRST => REGRST            -- 1-bit input - Active high, synchronous reset, resets delay chain to ODELAY_VALUE
                               -- tap. If no value is specified, the default is 0.
);

-- End of ODELAYE2_inst instantiation
