// FIFO18E1: 18KB FIFO (First In, First Out) Block RAM Memory
//           7 Series
// Xilinx HDL Libraries Guide, version 13.1

FIFO18E1 #(
   .ALMOST_EMPTY_OFFSET(13'h0080),    // Sets the almost empty threshold
   .ALMOST_FULL_OFFSET(13'h0080),     // Sets almost full threshold
   .DATA_WIDTH(4),                    // Sets data width to 4, 9, 18, or 36
   .DO_REG(1),                        // Enable output register (0 or 1) Must be 1 if EN_SYN = FALSE
   .EN_SYN("FALSE"),                  // Specifies FIFO as dual-clock (FALSE) or Synchronous (TRUE)
   .FIFO_MODE("FIFO18"),              // Sets mode to FIFO18 or FIFO18_36
   .FIRST_WORD_FALL_THROUGH("FALSE"), // Sets the FIFO FWFT to TRUE or FALSE
   .INIT(36'h000000000),              // Initial values on output port
   .SIM_DEVICE("VIRTEX6"),            // Must be set to "7SERIES" for simulation behavior
   .SRVAL(36'h000000000)              // Set/Reset value for output port
)
FIFO18E1_inst (
   // Read Data: 32-bit (each) output: Read output data
   .DO(DO),                   // 32-bit output: Data output
   .DOP(DOP),                 // 4-bit output: Parity data output
   // Status: 1-bit (each) output: Flags and other FIFO status outputs
   .ALMOSTEMPTY(ALMOSTEMPTY), // 1-bit output: Almost empty output flag
   .ALMOSTFULL(ALMOSTFULL),   // 1-bit output: Almost full output flag
   .EMPTY(EMPTY),             // 1-bit output: Empty output flag
   .FULL(FULL),               // 1-bit output: Full output flag
   .RDCOUNT(RDCOUNT),         // 12-bit output: Read count output
   .RDERR(RDERR),             // 1-bit output: Read error output
   .WRCOUNT(WRCOUNT),         // 12-bit output: Write count output
   .WRERR(WRERR),             // 1-bit output: Write error occured.
   // Read Control Signals: 1-bit (each) input: Read clock, enable and reset input signals
   .RDCLK(RDCLK),             // 1-bit input: Read clock input
   .RDEN(RDEN),               // 1-bit input: Read enable input
   .REGCE(REGCE),             // 1-bit input: Clock enable input
   .RST(RST),                 // 1-bit input: Reset input
   .RSTREG(RSTREG),           // 1-bit input: Output register set/reset input
   // Write Control Signals: 1-bit (each) input: Write clock and enable input signals
   .WRCLK(WRCLK),             // 1-bit input: Write clock input
   .WREN(WREN),               // 1-bit input: Write enable input
   // Write Data: 32-bit (each) input: Write input data
   .DI(DI),                   // 32-bit input: Data input
   .DIP(DIP)                  // 4-bit input: Parity input
);

// End of FIFO18E1_inst instantiation
